/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellId;
import com.sun.electric.database.ExportId;
import com.sun.electric.database.IdMapper;
import com.sun.electric.database.ImmutableElectricObject;
import com.sun.electric.database.ImmutablePortInst;
import com.sun.electric.database.SnapshotReader;
import com.sun.electric.database.SnapshotWriter;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.NodeProtoId;
import com.sun.electric.database.prototype.PortProtoId;
import com.sun.electric.database.text.ArrayIterator;
import com.sun.electric.database.text.ImmutableArrayList;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ImmutableNodeInst
extends ImmutableElectricObject {
    private static final int HARDSELECTN = 32768;
    private static final int NVISIBLEINSIDE = 0x800000;
    private static final int NTECHBITS = 0x7E0000;
    private static final int NTECHBITSSH = 17;
    private static final int NILOCKED = 0x1000000;
    private static final int FLAG_BITS = 0x1808000;
    public static final Flag HARD_SELECT = new Flag(32768);
    public static final Flag VIS_INSIDE = new Flag(0x800000);
    public static final Flag LOCKED = new Flag(0x1000000);
    public static final ImmutableNodeInst[] NULL_ARRAY = new ImmutableNodeInst[0];
    public static final ImmutableArrayList<ImmutableNodeInst> EMPTY_LIST = new ImmutableArrayList<ImmutableNodeInst>(NULL_ARRAY);
    public final int nodeId;
    public final NodeProtoId protoId;
    public final Name name;
    public final TextDescriptor nameDescriptor;
    public final Orientation orient;
    public final EPoint anchor;
    public final EPoint size;
    public final byte techBits;
    public final TextDescriptor protoDescriptor;
    final ImmutablePortInst[] ports;

    ImmutableNodeInst(int nodeId, NodeProtoId protoId, Name name, TextDescriptor nameDescriptor, Orientation orient, EPoint anchor, EPoint size, int flags, byte techBits, TextDescriptor protoDescriptor, Variable[] vars, ImmutablePortInst[] ports) {
        super(vars, flags);
        this.nodeId = nodeId;
        this.protoId = protoId;
        this.name = name;
        this.nameDescriptor = nameDescriptor;
        this.orient = orient;
        this.anchor = anchor;
        this.size = size;
        this.techBits = techBits;
        this.protoDescriptor = protoDescriptor;
        this.ports = ports;
    }

    public static ImmutableNodeInst newInstance(int nodeId, NodeProtoId protoId, Name name, TextDescriptor nameDescriptor, Orientation orient, EPoint anchor, EPoint size, int flags, int techBits, TextDescriptor protoDescriptor) {
        if (nodeId < 0) {
            throw new IllegalArgumentException("nodeId");
        }
        if (protoId == null) {
            throw new NullPointerException("protoId");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (!name.isValid() || name.hasEmptySubnames() || name.isTempname() && name.isBus()) {
            throw new IllegalArgumentException("bad name: " + name);
        }
        if (name.hasDuplicates()) {
            throw new IllegalArgumentException("name");
        }
        if (nameDescriptor != null) {
            nameDescriptor = nameDescriptor.withDisplayWithoutParamAndCode();
        }
        if (orient == null) {
            throw new NullPointerException("orient");
        }
        if (anchor == null) {
            throw new NullPointerException("anchor");
        }
        if (size.getGridX() < 0L || size.getGridY() < 0L) {
            throw new IllegalArgumentException("size");
        }
        if (protoId instanceof CellId) {
            size = EPoint.ORIGIN;
        }
        if (protoId == Generic.tech.cellCenterNode) {
            orient = Orientation.IDENT;
            anchor = EPoint.ORIGIN;
            size = EPoint.ORIGIN;
        }
        flags &= 0x1808000;
        techBits &= 0x3F;
        if (protoDescriptor != null) {
            protoDescriptor = protoDescriptor.withDisplayWithoutParamAndCode();
        }
        return new ImmutableNodeInst(nodeId, protoId, name, nameDescriptor, orient, anchor, size, flags, (byte)techBits, protoDescriptor, Variable.NULL_ARRAY, ImmutablePortInst.NULL_ARRAY);
    }

    public ImmutableNodeInst withName(Name name) {
        if (this.name.toString().equals(name.toString())) {
            return this;
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (!name.isValid() || name.hasEmptySubnames() || name.isTempname() && name.isBus()) {
            throw new IllegalArgumentException("name");
        }
        if (name.hasDuplicates()) {
            throw new IllegalArgumentException("name");
        }
        return new ImmutableNodeInst(this.nodeId, this.protoId, name, this.nameDescriptor, this.orient, this.anchor, this.size, this.flags, this.techBits, this.protoDescriptor, this.getVars(), this.ports);
    }

    public ImmutableNodeInst withNameDescriptor(TextDescriptor nameDescriptor) {
        if (nameDescriptor != null) {
            nameDescriptor = nameDescriptor.withDisplayWithoutParamAndCode();
        }
        if (this.nameDescriptor == nameDescriptor) {
            return this;
        }
        return new ImmutableNodeInst(this.nodeId, this.protoId, this.name, nameDescriptor, this.orient, this.anchor, this.size, this.flags, this.techBits, this.protoDescriptor, this.getVars(), this.ports);
    }

    public ImmutableNodeInst withOrient(Orientation orient) {
        if (this.orient == orient) {
            return this;
        }
        if (orient == null) {
            throw new NullPointerException("orient");
        }
        if (this.protoId == Generic.tech.cellCenterNode) {
            return this;
        }
        return new ImmutableNodeInst(this.nodeId, this.protoId, this.name, this.nameDescriptor, orient, this.anchor, this.size, this.flags, this.techBits, this.protoDescriptor, this.getVars(), this.ports);
    }

    public ImmutableNodeInst withAnchor(EPoint anchor) {
        if (this.anchor.equals(anchor)) {
            return this;
        }
        if (anchor == null) {
            throw new NullPointerException("anchor");
        }
        if (this.protoId == Generic.tech.cellCenterNode) {
            return this;
        }
        return new ImmutableNodeInst(this.nodeId, this.protoId, this.name, this.nameDescriptor, this.orient, anchor, this.size, this.flags, this.techBits, this.protoDescriptor, this.getVars(), this.ports);
    }

    public ImmutableNodeInst withSize(EPoint size) {
        if (this.size.equals(size)) {
            return this;
        }
        if (size.getGridX() < 0L || size.getGridY() < 0L) {
            throw new IllegalArgumentException("size is " + size);
        }
        if (this.protoId == Generic.tech.cellCenterNode) {
            return this;
        }
        if (this.protoId instanceof CellId) {
            return this;
        }
        return new ImmutableNodeInst(this.nodeId, this.protoId, this.name, this.nameDescriptor, this.orient, this.anchor, size, this.flags, this.techBits, this.protoDescriptor, this.getVars(), this.ports);
    }

    private ImmutableNodeInst withFlags(int flags) {
        if (this.flags == (flags &= 0x1808000)) {
            return this;
        }
        return new ImmutableNodeInst(this.nodeId, this.protoId, this.name, this.nameDescriptor, this.orient, this.anchor, this.size, flags, this.techBits, this.protoDescriptor, this.getVars(), this.ports);
    }

    public ImmutableNodeInst withStateBits(ImmutableNodeInst d) {
        return this.withFlags(d.flags).withTechSpecific(d.techBits);
    }

    public ImmutableNodeInst withFlag(Flag flag, boolean value) {
        return this.withFlags(flag.set(this.flags, value));
    }

    public ImmutableNodeInst withTechSpecific(int techBits) {
        if (this.techBits == (techBits &= 0x3F)) {
            return this;
        }
        return new ImmutableNodeInst(this.nodeId, this.protoId, this.name, this.nameDescriptor, this.orient, this.anchor, this.size, this.flags, (byte)techBits, this.protoDescriptor, this.getVars(), this.ports);
    }

    public ImmutableNodeInst withProtoDescriptor(TextDescriptor protoDescriptor) {
        if (protoDescriptor != null) {
            protoDescriptor = protoDescriptor.withDisplayWithoutParamAndCode();
        }
        if (this.protoDescriptor == protoDescriptor) {
            return this;
        }
        return new ImmutableNodeInst(this.nodeId, this.protoId, this.name, this.nameDescriptor, this.orient, this.anchor, this.size, this.flags, this.techBits, protoDescriptor, this.getVars(), this.ports);
    }

    public ImmutableNodeInst withVariable(Variable var) {
        Variable[] vars = this.arrayWithVariable(var.withParam(false));
        if (this.getVars() == vars) {
            return this;
        }
        return new ImmutableNodeInst(this.nodeId, this.protoId, this.name, this.nameDescriptor, this.orient, this.anchor, this.size, this.flags, this.techBits, this.protoDescriptor, vars, this.ports);
    }

    public ImmutableNodeInst withoutVariable(Variable.Key key) {
        Variable[] vars = this.arrayWithoutVariable(key);
        if (this.getVars() == vars) {
            return this;
        }
        return new ImmutableNodeInst(this.nodeId, this.protoId, this.name, this.nameDescriptor, this.orient, this.anchor, this.size, this.flags, this.techBits, this.protoDescriptor, vars, this.ports);
    }

    ImmutableNodeInst withRenamedIds(IdMapper idMapper) {
        Variable[] vars = this.arrayWithRenamedIds(idMapper);
        NodeProtoId protoId = this.protoId;
        ImmutablePortInst[] ports = this.portsWithRenamedIds(idMapper);
        if (protoId instanceof CellId) {
            protoId = idMapper.get((CellId)protoId);
        }
        if (this.getVars() == vars && this.protoId == protoId && this.ports == ports) {
            return this;
        }
        return new ImmutableNodeInst(this.nodeId, protoId, this.name, this.nameDescriptor, this.orient, this.anchor, this.size, this.flags, this.techBits, this.protoDescriptor, vars, ports);
    }

    private ImmutablePortInst[] portsWithRenamedIds(IdMapper idMapper) {
        if (this.ports.length == 0) {
            assert (this.ports == ImmutablePortInst.NULL_ARRAY);
            return this.ports;
        }
        if (this.protoId instanceof CellId) {
            boolean chronIndexChanged = false;
            int maxChronIndex = -1;
            CellId subCellId = (CellId)this.protoId;
            for (int chronIndex = 0; chronIndex < this.ports.length; ++chronIndex) {
                ImmutablePortInst oldPort = this.ports[chronIndex];
                if (oldPort == ImmutablePortInst.EMPTY) continue;
                ExportId oldExportId = subCellId.getPortId(chronIndex);
                assert (oldExportId.chronIndex == chronIndex);
                ExportId newExportId = idMapper.get(oldExportId);
                maxChronIndex = Math.max(maxChronIndex, newExportId.chronIndex);
                if (newExportId.chronIndex == chronIndex) continue;
                chronIndexChanged = true;
            }
            if (chronIndexChanged) {
                Object[] newPorts = new ImmutablePortInst[maxChronIndex + 1];
                assert (newPorts.length > 0);
                Arrays.fill(newPorts, ImmutablePortInst.EMPTY);
                for (int chronIndex = 0; chronIndex < this.ports.length; ++chronIndex) {
                    ImmutablePortInst oldPort = this.ports[chronIndex];
                    if (oldPort == ImmutablePortInst.EMPTY) continue;
                    newPorts[idMapper.get((ExportId)subCellId.getPortId((int)chronIndex)).chronIndex] = oldPort.withRenamedIds(idMapper);
                }
                return newPorts;
            }
        }
        ImmutablePortInst[] newPorts = null;
        for (int i = 0; i < this.ports.length; ++i) {
            ImmutablePortInst oldPort = this.ports[i];
            ImmutablePortInst newPort = oldPort.withRenamedIds(idMapper);
            if (newPort != oldPort && newPorts == null) {
                newPorts = new ImmutablePortInst[this.ports.length];
                System.arraycopy(this.ports, 0, newPorts, 0, i);
            }
            if (newPorts == null) continue;
            newPorts[i] = newPort;
        }
        return newPorts != null ? newPorts : this.ports;
    }

    public ImmutableNodeInst withPortInst(PortProtoId portProtoId, ImmutablePortInst portInst) {
        Object[] newPorts;
        if (portProtoId.getParentId() != this.protoId) {
            throw new IllegalArgumentException("portProtoId");
        }
        int portChronIndex = portProtoId.getChronIndex();
        if (portChronIndex < this.ports.length) {
            if (this.ports[portChronIndex] == portInst) {
                return this;
            }
            if (portInst == ImmutablePortInst.EMPTY && portChronIndex == this.ports.length - 1) {
                int newLength;
                for (newLength = this.ports.length - 1; newLength > 0 && this.ports[newLength - 1] == ImmutablePortInst.EMPTY; --newLength) {
                }
                if (newLength > 0) {
                    newPorts = new ImmutablePortInst[newLength];
                    System.arraycopy(this.ports, 0, newPorts, 0, newLength);
                } else {
                    newPorts = ImmutablePortInst.NULL_ARRAY;
                }
            } else {
                newPorts = (ImmutablePortInst[])this.ports.clone();
                newPorts[portChronIndex] = portInst;
            }
        } else {
            if (portInst == ImmutablePortInst.EMPTY) {
                return this;
            }
            newPorts = new ImmutablePortInst[portChronIndex + 1];
            System.arraycopy(this.ports, 0, newPorts, 0, this.ports.length);
            Arrays.fill(newPorts, this.ports.length, portChronIndex, ImmutablePortInst.EMPTY);
            newPorts[portChronIndex] = portInst;
        }
        return new ImmutableNodeInst(this.nodeId, this.protoId, this.name, this.nameDescriptor, this.orient, this.anchor, this.size, this.flags, this.techBits, this.protoDescriptor, this.getVars(), (ImmutablePortInst[])newPorts);
    }

    public boolean isUsernamed() {
        return !this.name.isTempname();
    }

    public ImmutablePortInst getPortInst(PortProtoId portProtoId) {
        if (portProtoId.getParentId() != this.protoId) {
            throw new IllegalArgumentException("portProtoId");
        }
        int portChronIndex = portProtoId.getChronIndex();
        return portChronIndex < this.ports.length ? this.ports[portChronIndex] : ImmutablePortInst.EMPTY;
    }

    public Iterator<PortProtoId> getPortsWithVariables() {
        if (this.ports.length == 0) {
            Iterator<PortProtoId> emptyIterator = ArrayIterator.emptyIterator();
            return emptyIterator;
        }
        return new PortInstIterator();
    }

    public boolean hasPortInstVariables() {
        return this.ports.length > 0;
    }

    public boolean is(Flag flag) {
        return flag.is(this.flags);
    }

    @Override
    void write(SnapshotWriter writer) throws IOException {
        writer.writeNodeId(this.nodeId);
        writer.writeNodeProtoId(this.protoId);
        writer.writeNameKey(this.name);
        writer.writeTextDescriptor(this.nameDescriptor);
        writer.writeOrientation(this.orient);
        writer.writePoint(this.anchor);
        writer.writePoint(this.size);
        writer.writeInt(this.flags);
        writer.writeByte(this.techBits);
        writer.writeTextDescriptor(this.protoDescriptor);
        for (int i = this.ports.length - 1; i >= 0; --i) {
            if (this.ports[i] == ImmutablePortInst.EMPTY) continue;
            writer.writeInt(i);
            this.ports[i].writeVars(writer);
        }
        writer.writeInt(-1);
        super.write(writer);
    }

    static ImmutableNodeInst read(SnapshotReader reader) throws IOException {
        int i;
        int nodeId = reader.readNodeId();
        NodeProtoId protoId = reader.readNodeProtoId();
        Name name = reader.readNameKey();
        TextDescriptor nameDescriptor = reader.readTextDescriptor();
        Orientation orient = reader.readOrientation();
        EPoint anchor = reader.readPoint();
        EPoint size = reader.readPoint();
        int flags = reader.readInt();
        byte techBits = reader.readByte();
        TextDescriptor protoDescriptor = reader.readTextDescriptor();
        Object[] ports = ImmutablePortInst.NULL_ARRAY;
        while ((i = reader.readInt()) != -1) {
            if (i >= ports.length) {
                Object[] newPorts = new ImmutablePortInst[i + 1];
                System.arraycopy(ports, 0, newPorts, 0, ports.length);
                Arrays.fill(newPorts, ports.length, newPorts.length, ImmutablePortInst.EMPTY);
                ports = newPorts;
            }
            ports[i] = ImmutablePortInst.read(reader);
        }
        boolean hasVars = reader.readBoolean();
        Variable[] vars = hasVars ? ImmutableNodeInst.readVars(reader) : Variable.NULL_ARRAY;
        return new ImmutableNodeInst(nodeId, protoId, name, nameDescriptor, orient, anchor, size, flags, techBits, protoDescriptor, vars, (ImmutablePortInst[])ports);
    }

    @Override
    public int hashCodeExceptVariables() {
        return this.nodeId;
    }

    @Override
    public boolean equalsExceptVariables(ImmutableElectricObject o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableNodeInst)) {
            return false;
        }
        ImmutableNodeInst that = (ImmutableNodeInst)o;
        return this.nodeId == that.nodeId && this.protoId == that.protoId && this.name == that.name && this.nameDescriptor == that.nameDescriptor && this.orient == that.orient && this.anchor == that.anchor && this.size == that.size && this.flags == that.flags && this.techBits == that.techBits && this.protoDescriptor == that.protoDescriptor;
    }

    public void check() {
        this.check(false);
        assert (this.nodeId >= 0);
        assert (this.protoId != null);
        assert (this.name != null);
        assert (this.name.isValid() && !this.name.hasEmptySubnames());
        assert (!this.name.isTempname() || !this.name.isBus());
        assert (!this.name.hasDuplicates());
        if (this.nameDescriptor != null) assert (this.nameDescriptor.isDisplay() && !this.nameDescriptor.isCode() && !this.nameDescriptor.isParam());
        assert (this.orient != null);
        assert (this.anchor != null);
        assert (this.size.getGridX() >= 0L);
        assert (this.size.getGridY() >= 0L);
        assert ((this.flags & 0xFE7F7FFF) == 0);
        assert ((this.techBits & 0xFFFFFFC0) == 0);
        if (this.protoDescriptor != null) assert (this.protoDescriptor.isDisplay() && !this.protoDescriptor.isCode() && !this.protoDescriptor.isParam());
        if (this.protoId instanceof CellId) assert (this.size == EPoint.ORIGIN);
        if (this.protoId == Generic.tech.cellCenterNode) assert (this.orient == Orientation.IDENT && this.anchor == EPoint.ORIGIN && this.size == EPoint.ORIGIN);
        for (int i = 0; i < this.ports.length; ++i) {
            ImmutablePortInst portInst = this.ports[i];
            if (portInst.getNumVariables() != 0) {
                portInst.check();
                continue;
            }
            assert (portInst == ImmutablePortInst.EMPTY);
        }
        if (this.ports.length > 0) assert (this.ports[this.ports.length - 1].getNumVariables() > 0);
    }

    public int getElibBits() {
        return this.flags | this.techBits << 17;
    }

    public static int flagsFromElib(int elibBits) {
        return elibBits & 0x1808000;
    }

    public static int techSpecificFromElib(int elibBits) {
        return (elibBits & 0x7E0000) >> 17;
    }

    public void computeBounds(NodeInst real, Rectangle2D.Double dstBounds) {
        double[] angles;
        if (this.protoId instanceof CellId) {
            Cell subCell = (Cell)real.getProto();
            ERectangle bounds = subCell.getBounds();
            this.orient.rectangleBounds(bounds.getMinX(), bounds.getMinY(), ((RectangularShape)bounds).getMaxX(), ((RectangularShape)bounds).getMaxY(), this.anchor.getX(), this.anchor.getY(), dstBounds);
            return;
        }
        if (this.size.getGridX() == 0L && this.size.getGridY() == 0L) {
            dstBounds.setRect(this.anchor.getX(), this.anchor.getY(), 0.0, 0.0);
            return;
        }
        PrimitiveNode pn = (PrimitiveNode)this.protoId;
        if (!(pn != Artwork.tech.circleNode && pn != Artwork.tech.thickCircleNode || (angles = real.getArcDegrees())[0] == 0.0 && angles[1] == 0.0)) {
            Point2D[] pointList = Artwork.fillEllipse(this.anchor, this.size.getLambdaX(), this.size.getLambdaY(), angles[0], angles[1]);
            Poly poly = new Poly(pointList);
            poly.setStyle(Poly.Type.OPENED);
            poly.transform(this.orient.rotateAbout(this.anchor.getX(), this.anchor.getY()));
            dstBounds.setRect(poly.getBounds2D());
            return;
        }
        if (pn.isWipeOn1or2()) {
            Poly[] polys;
            if (real.getProto() == Schematics.tech.busPinNode && (polys = Schematics.tech.getShapeOfNode(real)).length > 0) {
                Rectangle2D bounds = polys[0].getBounds2D();
                dstBounds.setRect(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
                return;
            }
            if (!real.hasExports() && real.pinUseCount()) {
                dstBounds.setRect(this.anchor.getX(), this.anchor.getY(), 0.0, 0.0);
                return;
            }
        }
        if (pn.isHoldsOutline() && real.getTrace() != null) {
            AffineTransform trans = this.orient.rotateAbout(this.anchor.getX(), this.anchor.getY());
            Poly[] polys = pn.getTechnology().getShapeOfNode(real);
            for (int i = 0; i < polys.length; ++i) {
                Poly poly = polys[i];
                poly.transform(trans);
                if (i == 0) {
                    dstBounds.setRect(poly.getBounds2D());
                    continue;
                }
                Rectangle2D.union(poly.getBounds2D(), dstBounds, dstBounds);
            }
            return;
        }
        double halfWidth = this.size.getLambdaX() * 0.5;
        double halfHeight = this.size.getLambdaY() * 0.5;
        this.orient.rectangleBounds(-halfWidth, -halfHeight, halfWidth, halfHeight, this.anchor.getX(), this.anchor.getY(), dstBounds);
    }

    public EPoint[] getTrace() {
        Variable var = this.getVar(NodeInst.TRACE);
        if (var == null) {
            return null;
        }
        Object obj = var.getObject();
        if (obj instanceof EPoint[]) {
            return (EPoint[])obj;
        }
        return null;
    }

    public double getSerpentineTransistorLength() {
        Variable var = this.getVar(NodeInst.TRANSISTOR_LENGTH_KEY);
        if (var == null) {
            return -1.0;
        }
        Object obj = var.getObject();
        if (obj instanceof Integer) {
            return (Integer)obj / 120;
        }
        if (obj instanceof Double) {
            return (Double)obj;
        }
        if (obj instanceof String) {
            return TextUtils.atof((String)obj);
        }
        return -1.0;
    }

    private class PortInstIterator
    implements Iterator<PortProtoId> {
        int chronIndex;
        PortProtoId next;

        PortInstIterator() {
            this.getNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public PortProtoId next() {
            PortProtoId result = this.next;
            if (result == null) {
                throw new NoSuchElementException();
            }
            this.getNext();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void getNext() {
            PortProtoId next = null;
            while (this.chronIndex < ImmutableNodeInst.this.ports.length) {
                if (ImmutableNodeInst.this.ports[this.chronIndex] != ImmutablePortInst.EMPTY) {
                    next = ImmutableNodeInst.this.protoId.getPortId(this.chronIndex++);
                    break;
                }
                ++this.chronIndex;
            }
            this.next = next;
        }
    }

    public static class Flag {
        private final int mask;

        private Flag(int mask) {
            this.mask = mask;
        }

        public boolean is(int userBits) {
            return (userBits & this.mask) != 0;
        }

        public int set(int userBits, boolean value) {
            return value ? userBits | this.mask : userBits & ~this.mask;
        }
    }
}

