/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.GeometryHandler;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.TransistorSize;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.Simulate;
import com.sun.electric.tool.io.input.SpiceNetlistReader;
import com.sun.electric.tool.io.output.CellModelPrefs;
import com.sun.electric.tool.io.output.Topology;
import com.sun.electric.tool.logicaleffort.LENetlister;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.Exec;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.ExecDialog;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.waveform.WaveformWindow;
import java.awt.Frame;
import java.awt.geom.AffineTransform;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Spice
extends Topology {
    public static final Variable.Key SPICE_TEMPLATE_KEY = Variable.newKey("ATTR_SPICE_template");
    public static final Variable.Key SPICE_2_TEMPLATE_KEY = Variable.newKey("ATTR_SPICE_template_spice2");
    public static final Variable.Key SPICE_3_TEMPLATE_KEY = Variable.newKey("ATTR_SPICE_template_spice3");
    public static final Variable.Key SPICE_H_TEMPLATE_KEY = Variable.newKey("ATTR_SPICE_template_hspice");
    public static final Variable.Key SPICE_P_TEMPLATE_KEY = Variable.newKey("ATTR_SPICE_template_pspice");
    public static final Variable.Key SPICE_GC_TEMPLATE_KEY = Variable.newKey("ATTR_SPICE_template_gnucap");
    public static final Variable.Key SPICE_SM_TEMPLATE_KEY = Variable.newKey("ATTR_SPICE_template_smartspice");
    public static final Variable.Key SPICE_A_TEMPLATE_KEY = Variable.newKey("ATTR_SPICE_template_assura");
    public static final Variable.Key SPICE_C_TEMPLATE_KEY = Variable.newKey("ATTR_SPICE_template_calibre");
    public static final Variable.Key SPICE_CARD_KEY = Variable.newKey("SIM_spice_card");
    public static final Variable.Key SPICE_DECLARATION_KEY = Variable.newKey("SIM_spice_declaration");
    public static final Variable.Key SPICE_MODEL_KEY = Variable.newKey("SIM_spice_model");
    public static final Variable.Key SPICE_CODE_FLAT_KEY = Variable.newKey("SIM_spice_code_flat");
    public static final Variable.Key ATTR_C = Variable.newKey("ATTR_C");
    public static final Variable.Key ATTR_R = Variable.newKey("ATTR_R");
    public static final String SPICE_EXTENSION_PREFIX = "Extension ";
    public static final Variable.Key CDL_TEMPLATE_KEY = Variable.newKey("ATTR_CDL_template");
    private static final int SPICEMAXLENSUBCKTNAME = 70;
    private static final int CDLMAXLENSUBCKTNAME = 40;
    private static final int SPICEMAXLENLINE = 78;
    private static final String SPICELEGALCHARS = "!#$%*+-/<>[]_@";
    private static final String PSPICELEGALCHARS = "!#$%*+-/<>[]_";
    private static final String CDLNOBRACKETLEGALCHARS = "!#$%*+-/<>_";
    private static final boolean CDLWRITESEMPTYSUBCKTS = false;
    private static final boolean USE_GLOBALS = true;
    private Technology layoutTechnology;
    private double maskScale;
    private boolean useCDL;
    private String legalSpiceChars;
    private Variable.Key preferedEngineTemplateKey;
    private boolean assuraHSpice = false;
    private Simulation.SpiceEngine spiceEngine;
    private HashMap<Cell, String> modelOverrides = new HashMap();
    private List<SegmentedNets> segmentedParasiticInfo = new ArrayList<SegmentedNets>();
    private ExemptedNets exemptedNets;
    private boolean writeEmptySubckts = true;
    private int spiceMaxLenLine = 78;
    private FlatSpiceCodeVisitor spiceCodeFlat = null;
    private Map<Cell, Cell> uniquifyCells;
    private int uniqueID;
    private Map<String, Integer> uniqueNames;
    private static final boolean useNewParasitics = true;
    private static final boolean CELLISEMPTYDEBUG = false;
    private HashMap<Cell, Boolean> checkedCells = new HashMap();

    public static void writeSpiceFile(Cell cell, VarContext context, String filePath, boolean cdl) {
        String runSpice;
        Spice out = new Spice();
        out.useCDL = cdl;
        if (out.openTextOutputStream(filePath)) {
            return;
        }
        if (out.writeCell(cell, context)) {
            return;
        }
        if (out.closeTextOutputStream()) {
            return;
        }
        System.out.println(filePath + " written");
        if (out.useCDL) {
            String templateFile;
            String deckFile = filePath;
            String deckPath = "";
            int lastDirSep = deckFile.lastIndexOf(File.separatorChar);
            if (lastDirSep > 0) {
                deckPath = deckFile.substring(0, lastDirSep);
                deckFile = deckFile.substring(lastDirSep + 1);
            }
            if (out.openTextOutputStream(templateFile = deckPath + File.separator + cell.getName() + ".cdltemplate")) {
                return;
            }
            String libName = Simulation.getCDLLibName();
            String libPath = Simulation.getCDLLibPath();
            out.printWriter.print("cdlInKeys = list(nil\n");
            out.printWriter.print("    'searchPath             \"" + deckFile + "");
            if (libPath.length() > 0) {
                out.printWriter.print("\n                             " + libPath);
            }
            out.printWriter.print("\"\n");
            out.printWriter.print("    'cdlFile                \"" + deckPath + File.separator + deckFile + "\"\n");
            out.printWriter.print("    'userSkillFile          \"\"\n");
            out.printWriter.print("    'opusLib                \"" + libName + "\"\n");
            out.printWriter.print("    'primaryCell            \"" + cell.getName() + "\"\n");
            out.printWriter.print("    'caseSensitivity        \"lower\"\n");
            out.printWriter.print("    'hierarchy              \"flatten\"\n");
            out.printWriter.print("    'cellTable              \"\"\n");
            out.printWriter.print("    'viewName               \"netlist\"\n");
            out.printWriter.print("    'viewType               \"\"\n");
            out.printWriter.print("    'pr                     nil\n");
            out.printWriter.print("    'skipDevice             nil\n");
            out.printWriter.print("    'schemaLib              \"sample\"\n");
            out.printWriter.print("    'refLib                 \"\"\n");
            out.printWriter.print("    'globalNodeExpand       \"full\"\n");
            out.printWriter.print(")\n");
            if (out.closeTextOutputStream()) {
                return;
            }
            System.out.println(templateFile + " written");
        }
        if (!(runSpice = Simulation.getSpiceRunChoice()).equals("Don't Run")) {
            String workdir;
            String command = Simulation.getSpiceRunProgram() + " " + Simulation.getSpiceRunProgramArgs();
            String rundir = workdir = User.getWorkingDirectory();
            if (Simulation.getSpiceUseRunDir()) {
                rundir = Simulation.getSpiceRunDir();
            }
            File dir = new File(rundir);
            int start = filePath.lastIndexOf(File.separator);
            if (start == -1) {
                start = 0;
            } else if (++start > filePath.length()) {
                start = filePath.length();
            }
            int end = filePath.lastIndexOf(".");
            if (end == -1) {
                end = filePath.length();
            }
            String filename_noext = filePath.substring(start, end);
            String filename = filePath.substring(start, filePath.length());
            command = command.replaceAll("\\$\\{WORKING_DIR}", workdir);
            command = command.replaceAll("\\$\\{USE_DIR}", rundir);
            command = command.replaceAll("\\$\\{FILENAME}", filename);
            command = command.replaceAll("\\$\\{FILENAME_NO_EXT}", filename_noext);
            FileType type = Simulate.getCurrentSpiceOutputType();
            String[] extensions = type.getExtensions();
            String outFile = rundir + File.separator + filename_noext + "." + extensions[0];
            SpiceFinishedListener l = new SpiceFinishedListener(cell, type, outFile);
            if (runSpice.equals("Run, Ingore Output")) {
                Exec e = new Exec(command, null, dir, null, null);
                if (Simulation.getSpiceRunProbe()) {
                    e.addFinishedListener(l);
                }
                e.start();
            }
            if (runSpice.equals("Run, Report Output")) {
                ExecDialog dialog = new ExecDialog((Frame)TopLevel.getCurrentJFrame(), false);
                if (Simulation.getSpiceRunProbe()) {
                    dialog.addFinishedListener(l);
                }
                dialog.startProcess(command, null, dir);
            }
            System.out.println("Running spice command: " + command);
        }
        if (Simulation.isParasiticsBackAnnotateLayout() && Simulation.isSpiceUseParasitics()) {
            out.backAnnotateLayout();
        }
    }

    Spice() {
    }

    @Override
    protected void start() {
        String headerPath;
        this.layoutTechnology = this.topCell.getTechnology().isLayout() ? this.topCell.getTechnology() : Schematics.getDefaultSchematicTechnology();
        this.spiceEngine = Simulation.getSpiceEngine();
        this.preferedEngineTemplateKey = SPICE_TEMPLATE_KEY;
        this.assuraHSpice = false;
        switch (this.spiceEngine) {
            case SPICE_ENGINE_2: {
                this.preferedEngineTemplateKey = SPICE_2_TEMPLATE_KEY;
                break;
            }
            case SPICE_ENGINE_3: {
                this.preferedEngineTemplateKey = SPICE_3_TEMPLATE_KEY;
                break;
            }
            case SPICE_ENGINE_H: {
                this.preferedEngineTemplateKey = SPICE_H_TEMPLATE_KEY;
                break;
            }
            case SPICE_ENGINE_P: {
                this.preferedEngineTemplateKey = SPICE_P_TEMPLATE_KEY;
                break;
            }
            case SPICE_ENGINE_G: {
                this.preferedEngineTemplateKey = SPICE_GC_TEMPLATE_KEY;
                break;
            }
            case SPICE_ENGINE_S: {
                this.preferedEngineTemplateKey = SPICE_SM_TEMPLATE_KEY;
                break;
            }
            case SPICE_ENGINE_H_ASSURA: {
                this.preferedEngineTemplateKey = SPICE_A_TEMPLATE_KEY;
                this.assuraHSpice = true;
                break;
            }
            case SPICE_ENGINE_H_CALIBRE: {
                this.preferedEngineTemplateKey = SPICE_C_TEMPLATE_KEY;
                this.assuraHSpice = true;
            }
        }
        if (this.assuraHSpice || this.useCDL || !this.useCDL && !Simulation.isSpiceWriteEmtpySubckts()) {
            this.writeEmptySubckts = false;
        }
        this.maskScale = 1.0;
        this.uniquifyCells = new HashMap<Cell, Cell>();
        this.uniqueID = 0;
        this.uniqueNames = new HashMap<String, Integer>();
        this.checkIfParameterized(this.topCell);
        this.legalSpiceChars = SPICELEGALCHARS;
        if (this.spiceEngine == Simulation.SpiceEngine.SPICE_ENGINE_P || this.spiceEngine == Simulation.SpiceEngine.SPICE_ENGINE_G) {
            this.legalSpiceChars = PSPICELEGALCHARS;
        }
        if (this.useCDL) {
            if (Simulation.isCDLConvertBrackets()) {
                this.legalSpiceChars = CDLNOBRACKETLEGALCHARS;
            }
            this.multiLinePrint(true, "* First line is ignored\n");
            headerPath = TextUtils.getFilePath(this.topCell.getLibrary().getLibFile());
            String filePart = Simulation.getCDLIncludeFile();
            if (!filePart.equals("")) {
                String fileName = headerPath + filePart;
                File test = new File(fileName);
                if (test.exists()) {
                    this.multiLinePrint(true, "* Primitives described in this file:\n");
                    this.addIncludeFile(filePart);
                } else {
                    System.out.println("Warning: CDL Include file not found: " + fileName);
                }
            }
        } else {
            this.writeHeader(this.topCell);
            this.spiceCodeFlat = new FlatSpiceCodeVisitor(this.filePath + ".flatcode", this);
            HierarchyEnumerator.enumerateCell(this.topCell, VarContext.globalContext, this.spiceCodeFlat, true);
            this.spiceCodeFlat.close();
        }
        if (Simulation.isParasiticsUseExemptedNetsFile()) {
            headerPath = TextUtils.getFilePath(this.topCell.getLibrary().getLibFile());
            this.exemptedNets = new ExemptedNets(new File(headerPath + File.separator + "exemptedNets.txt"));
        }
    }

    @Override
    protected void done() {
        if (!this.useCDL) {
            this.writeTrailer(this.topCell);
            this.multiLinePrint(false, ".END\n");
        }
    }

    private void writeMFactor(VarContext context, Nodable no, StringBuffer infstr) {
        Variable mVar = no.getVar(Simulation.M_FACTOR_KEY);
        if (mVar == null) {
            return;
        }
        Object value = context.evalVar(mVar);
        if (mVar.getObject().toString().equals("@M") || mVar.getObject().toString().equals("P(\"M\")")) {
            System.out.println("Warning: M=@M [eval=" + value + "] on " + no.getName() + " is a bad idea, not writing it out: " + context.push(no).getInstPath("."));
            return;
        }
        infstr.append(" M=" + Spice.formatParam(value.toString()));
    }

    @Override
    protected void enterCell(HierarchyEnumerator.CellInfo info) {
        if (this.exemptedNets != null) {
            this.exemptedNets.setExemptedNets(info);
        }
    }

    private Variable getEngineTemplate(Cell cell) {
        Variable varTemplate = null;
        varTemplate = cell.getVar(this.preferedEngineTemplateKey);
        if (!this.assuraHSpice && varTemplate == null) {
            varTemplate = cell.getVar(SPICE_TEMPLATE_KEY);
        }
        return varTemplate;
    }

    @Override
    protected void writeCellTopology(Cell cell, Topology.CellNetInfo cni, VarContext context, Topology.MyCellInfo info) {
        Iterator<NodeInst> it;
        NodeInst ni;
        Iterator<Geometric> aIt;
        ArcInst ai;
        Netlist netList;
        if (cell == this.topCell) {
            netList = cni.getNetList();
            Global.Set globals = netList.getGlobals();
            int globalSize = globals.size();
            if (!(Simulation.isSpiceUseNodeNames() && this.spiceEngine == Simulation.SpiceEngine.SPICE_ENGINE_3 || globalSize <= 0)) {
                StringBuffer infstr = new StringBuffer();
                infstr.append("\n.global");
                for (int i = 0; i < globalSize; ++i) {
                    Global global = globals.get(i);
                    String name = global.getName();
                    if (global == Global.power && this.getPowerName(null) != null) {
                        name = this.getPowerName(null);
                    }
                    if (global == Global.ground && this.getGroundName(null) != null) {
                        name = this.getGroundName(null);
                    }
                    infstr.append(" " + name);
                }
                infstr.append("\n");
                this.multiLinePrint(false, infstr.toString());
            }
        }
        netList = cni.getNetList();
        if (cell == this.topCell && !Simulation.isSpiceForceGlobalPwrGnd()) {
            if (cni.getPowerNet() == null) {
                System.out.println("WARNING: cannot find power at top level of circuit");
            }
            if (cni.getGroundNet() == null) {
                System.out.println("WARNING: cannot find ground at top level of circuit");
            }
        }
        HashMap<Network, SpiceNet> spiceNetMap = new HashMap<Network, SpiceNet>();
        Iterator<Network> it2 = netList.getNetworks();
        while (it2.hasNext()) {
            Network net = it2.next();
            SpiceNet spNet = new SpiceNet();
            spNet.network = net;
            spNet.transistorCount = 0;
            spNet.diffArea = 0.0;
            spNet.diffPerim = 0.0;
            spNet.nonDiffCapacitance = 0.0f;
            spNet.merge = new PolyMerge();
            spiceNetMap.put(net, spNet);
        }
        boolean verboseSegmentedNames = Simulation.isParasiticsUseVerboseNaming();
        boolean useParasitics = !this.useCDL && Simulation.isSpiceUseParasitics() && cell.getView() == View.LAYOUT;
        SegmentedNets segmentedNets = new SegmentedNets(cell, verboseSegmentedNames, cni, useParasitics);
        this.segmentedParasiticInfo.add(segmentedNets);
        if (useParasitics) {
            double scale = this.layoutTechnology.getScale();
            HashMap<Network, Network> exemptedNetsFound = new HashMap<Network, Network>();
            Iterator<ArcInst> ait = cell.getArcs();
            while (ait.hasNext()) {
                ai = ait.next();
                boolean ignoreArc = false;
                if (ai.getProto().getFunction() == ArcProto.Function.NONELEC) {
                    ignoreArc = true;
                }
                double length = ai.getLength() * scale / 1000.0;
                double width = ai.getWidth() * scale / 1000.0;
                double area = length * width;
                double fringe = length * 2.0;
                double cap = 0.0;
                double res = 0.0;
                Technology tech = ai.getProto().getTechnology();
                for (Poly poly : tech.getShapeOfArc(ai)) {
                    Layer layer;
                    if (poly.getStyle().isText() || (layer = poly.getLayer()).getTechnology() != this.layoutTechnology || (layer.getFunctionExtras() & 0x1000) != 0 || layer.isDiffusionLayer() || !(layer.getCapacitance() > 0.0)) continue;
                    double areacap = area * layer.getCapacitance();
                    double fringecap = fringe * layer.getEdgeCapacitance();
                    cap = areacap + fringecap;
                    res = length / width * layer.getResistance();
                }
                if (res <= cell.getTechnology().getMinResistance()) {
                    ignoreArc = true;
                }
                if (Simulation.isParasiticsUseExemptedNetsFile()) {
                    Network net = netList.getNetwork(ai, 0);
                    if (Simulation.isParasiticsIgnoreExemptedNets()) {
                        if (this.exemptedNets.isExempted(info.getNetID(net))) {
                            ignoreArc = true;
                            cap = 0.0;
                            if (!exemptedNetsFound.containsKey(net)) {
                                System.out.println("Not extracting net " + cell.describe(false) + " " + net.getName());
                                exemptedNetsFound.put(net, net);
                                cap = this.exemptedNets.getReplacementCap(cell, net);
                            }
                        }
                    } else if (this.exemptedNets.isExempted(info.getNetID(net)) && !ignoreArc) {
                        if (!exemptedNetsFound.containsKey(net)) {
                            System.out.println("Extracting net " + cell.describe(false) + " " + net.getName());
                            exemptedNetsFound.put(net, net);
                        }
                    } else {
                        ignoreArc = true;
                    }
                }
                int arcPImodels = SegmentedNets.getNumPISegments(res, this.layoutTechnology.getMaxSeriesResistance());
                if (ignoreArc) {
                    arcPImodels = 1;
                }
                segmentedNets.putSegment(ai.getHeadPortInst(), cap / (double)(arcPImodels + 1));
                segmentedNets.putSegment(ai.getTailPortInst(), cap / (double)(arcPImodels + 1));
                if (ignoreArc) {
                    segmentedNets.shortSegments(ai.getHeadPortInst(), ai.getTailPortInst());
                    continue;
                }
                segmentedNets.addArcRes(ai, res);
                if (arcPImodels <= 1) continue;
                segmentedNets.addArcCap(ai, cap);
            }
            aIt = cell.getNodes();
            while (aIt.hasNext()) {
                ni = (NodeInst)aIt.next();
                if (!ni.isCellInstance()) {
                    if (((PrimitiveNode)ni.getProto()).getGroupFunction() != PrimitiveNode.Function.TRANS) continue;
                    PortInst gate0 = ni.getTransistorGatePort();
                    PortInst gate1 = null;
                    Iterator<PortInst> pit = ni.getPortInsts();
                    while (pit.hasNext()) {
                        PortInst p2 = pit.next();
                        if (p2 == gate0 || netList.getNetwork(gate0) != netList.getNetwork(p2)) continue;
                        gate1 = p2;
                    }
                    if (gate1 == null) continue;
                    segmentedNets.shortSegments(gate0, gate1);
                    continue;
                }
                Cell subCell = (Cell)ni.getProto();
                SegmentedNets subNets = this.getSegmentedNets(subCell);
                if (subNets == null) continue;
                it = subNets.getShortedExports();
                while (it.hasNext()) {
                    List exports = (List)it.next();
                    PortInst pi1 = null;
                    for (String exportName : exports) {
                        PortInst pi = ni.findPortInst(exportName);
                        if (pi1 == null) {
                            pi1 = pi;
                            continue;
                        }
                        segmentedNets.shortSegments(pi1, pi);
                    }
                }
            }
        }
        int bipolarTrans = 0;
        int nmosTrans = 0;
        int pmosTrans = 0;
        aIt = cell.getNodes();
        while (aIt.hasNext()) {
            ni = aIt.next();
            this.addNodeInformation(netList, spiceNetMap, ni);
            PrimitiveNode.Function fun = ni.getFunction();
            if (fun == PrimitiveNode.Function.TRANPN || fun == PrimitiveNode.Function.TRA4NPN || fun == PrimitiveNode.Function.TRAPNP || fun == PrimitiveNode.Function.TRA4PNP || fun == PrimitiveNode.Function.TRANS) {
                ++bipolarTrans;
                continue;
            }
            if (fun == PrimitiveNode.Function.TRAEMES || fun == PrimitiveNode.Function.TRA4EMES || fun == PrimitiveNode.Function.TRADMES || fun == PrimitiveNode.Function.TRA4DMES || fun == PrimitiveNode.Function.TRADMOS || fun == PrimitiveNode.Function.TRA4DMOS || fun == PrimitiveNode.Function.TRANMOS || fun == PrimitiveNode.Function.TRA4NMOS) {
                ++nmosTrans;
                continue;
            }
            if (fun != PrimitiveNode.Function.TRAPMOS && fun != PrimitiveNode.Function.TRA4PMOS) continue;
            ++pmosTrans;
        }
        aIt = cell.getArcs();
        while (aIt.hasNext()) {
            Network net;
            SpiceNet spNet;
            ai = (ArcInst)aIt.next();
            if (ai.getProto().getFunction() == ArcProto.Function.NONELEC || (spNet = spiceNetMap.get(net = netList.getNetwork(ai, 0))) == null) continue;
            this.addArcInformation(spNet.merge, ai);
        }
        Iterator<Network> it3 = netList.getNetworks();
        while (it3.hasNext()) {
            Network net = it3.next();
            SpiceNet spNet = spiceNetMap.get(net);
            for (Layer layer : spNet.merge.getKeySet()) {
                List<PolyBase> polyList = spNet.merge.getMergedPoints(layer, true);
                if (polyList == null) continue;
                if (polyList.size() > 1) {
                    Collections.sort(polyList, GeometryHandler.shapeSort);
                }
                for (PolyBase poly : polyList) {
                    double perim = poly.getPerimeter();
                    double area = poly.getArea();
                    double scale = this.layoutTechnology.getScale();
                    if (layer.isDiffusionLayer()) {
                        spNet.diffArea += area * this.maskScale * this.maskScale;
                        spNet.diffPerim += perim * this.maskScale;
                        continue;
                    }
                    area = area * scale * scale / 1000000.0;
                    perim = perim * scale / 1000.0;
                    spNet.nonDiffCapacitance = (float)((double)spNet.nonDiffCapacitance + layer.getCapacitance() * area * this.maskScale * this.maskScale);
                    spNet.nonDiffCapacitance = (float)((double)spNet.nonDiffCapacitance + layer.getEdgeCapacitance() * perim * this.maskScale);
                }
            }
        }
        Network groundNet = cni.getGroundNet();
        Network powerNet = cni.getPowerNet();
        if (pmosTrans != 0 && powerNet == null) {
            String message = "WARNING: no power connection for P-transistor wells in " + cell;
            this.dumpErrorMessage(message);
        }
        if (nmosTrans != 0 && groundNet == null) {
            String message = "WARNING: no ground connection for N-transistor wells in " + cell;
            this.dumpErrorMessage(message);
        }
        String topLevelInstance = "";
        if (cell == this.topCell && !this.useCDL && !Simulation.isSpiceWriteSubcktTopCell()) {
            this.multiLinePrint(true, "\n*** TOP LEVEL CELL: " + cell.describe(false) + "\n");
        } else {
            if (!this.writeEmptySubckts && this.cellIsEmpty(cell)) {
                return;
            }
            String cellName = cni.getParameterizedName();
            this.multiLinePrint(true, "\n*** CELL: " + cell.describe(false) + "\n");
            StringBuffer infstr = new StringBuffer();
            infstr.append(".SUBCKT " + cellName);
            Iterator<Topology.CellSignal> sIt = cni.getCellSignals();
            while (sIt.hasNext()) {
                Topology.CellSignal cs = sIt.next();
                if (this.ignoreSubcktPort(cs)) continue;
                if (cs.isGlobal()) {
                    System.out.println("Warning: Explicit Global signal " + cs.getName() + " exported in " + cell.describe(false));
                }
                if (useParasitics && !cs.isGlobal() && cs.getExport() != null) {
                    Network net = cs.getNetwork();
                    HashMap<String, ArrayList<String>> shortedExportsMap = new HashMap<String, ArrayList<String>>();
                    Iterator<Export> it4 = net.getExports();
                    while (it4.hasNext()) {
                        Export e = it4.next();
                        PortInst pi = e.getOriginalPort();
                        String name = segmentedNets.getNetName(pi);
                        ArrayList<String> shortedExports = (ArrayList<String>)shortedExportsMap.get(name);
                        if (shortedExports == null) {
                            shortedExports = new ArrayList<String>();
                            shortedExportsMap.put(name, shortedExports);
                            infstr.append(" " + name);
                        }
                        shortedExports.add(e.getName());
                    }
                    for (List shortedExports : shortedExportsMap.values()) {
                        if (shortedExports.size() <= 1) continue;
                        segmentedNets.addShortedExports(shortedExports);
                    }
                    continue;
                }
                infstr.append(" " + cs.getName());
            }
            Global.Set globals = netList.getGlobals();
            int globalSize = globals.size();
            if (!Simulation.isSpiceUseNodeNames() || this.spiceEngine == Simulation.SpiceEngine.SPICE_ENGINE_3) {
                for (int i = 0; i < globalSize; ++i) {
                    Global global = globals.get(i);
                    Network net = netList.getNetwork(global);
                    Topology.CellSignal cs = cni.getCellSignal(net);
                    infstr.append(" " + cs.getName());
                }
            }
            if (cell == this.topCell && Simulation.isSpiceWriteSubcktTopCell()) {
                topLevelInstance = infstr.toString().replaceFirst("\\.SUBCKT ", "X") + " " + cellName;
            }
            if (!this.useCDL && Simulation.isSpiceUseCellParameters()) {
                Iterator<Variable> it5 = cell.getParameters();
                while (it5.hasNext()) {
                    Variable paramVar = it5.next();
                    if (paramVar.getCode() != AbstractTextDescriptor.Code.SPICE) continue;
                    infstr.append(" " + paramVar.getTrueName() + "=" + paramVar.getPureValue(-1));
                }
            }
            infstr.append("\n");
            this.multiLinePrint(false, infstr.toString());
            for (int i = 0; i < globalSize; ++i) {
                Global global = globals.get(i);
                Network net = netList.getNetwork(global);
                Topology.CellSignal cs = cni.getCellSignal(net);
                this.multiLinePrint(true, "** GLOBAL " + cs.getName() + "\n");
            }
            Iterator<Topology.CellSignal> sIt2 = cni.getCellSignals();
            while (sIt2.hasNext()) {
                Topology.CellSignal cs = sIt2.next();
                Export pp = cs.getExport();
                if (pp != null && !cs.isGlobal()) continue;
            }
        }
        if (!this.useCDL) {
            boolean firstDecl = true;
            it = cell.getNodes();
            while (it.hasNext()) {
                Variable cardVar;
                NodeInst ni2 = it.next();
                if (ni2.getProto() != Generic.tech.invisiblePinNode || (cardVar = ni2.getVar(SPICE_DECLARATION_KEY)) == null) continue;
                if (firstDecl) {
                    firstDecl = false;
                    this.multiLinePrint(true, "\n* Spice Declaration nodes in cell " + cell + "\n");
                }
                this.emitEmbeddedSpice(cardVar, context, segmentedNets, info, false);
            }
        }
        Iterator<Nodable> nIt = netList.getNodables();
        while (nIt.hasNext()) {
            TransistorSize size;
            Nodable no = nIt.next();
            NodeProto niProto = no.getProto();
            if (no.isCellInstance()) {
                Cell subCell = (Cell)niProto;
                Variable varTemplate = null;
                varTemplate = this.useCDL ? subCell.getVar(CDL_TEMPLATE_KEY) : this.getEngineTemplate(subCell);
                if (varTemplate != null) {
                    if (varTemplate.getObject() instanceof Object[]) {
                        Object[] manyLines = (Object[])varTemplate.getObject();
                        for (int i = 0; i < manyLines.length; ++i) {
                            String line = manyLines[i].toString();
                            StringBuffer infstr = this.replacePortsAndVars(line, no, context, cni, segmentedNets, info, false);
                            if (i == 0) {
                                this.writeMFactor(context, no, infstr);
                            }
                            infstr.append('\n');
                            this.multiLinePrint(false, infstr.toString());
                        }
                        continue;
                    }
                    String line = varTemplate.getObject().toString();
                    StringBuffer infstr = this.replacePortsAndVars(line, no, context, cni, segmentedNets, info, false);
                    this.writeMFactor(context, no, infstr);
                    infstr.append('\n');
                    this.multiLinePrint(false, infstr.toString());
                    continue;
                }
                Topology.CellNetInfo subCni = this.getCellNetInfo(this.parameterizedName(no, context));
                if (subCni == null || !this.writeEmptySubckts && this.cellIsEmpty((Cell)niProto)) continue;
                String modelChar = "X";
                if (no.getName() != null) {
                    modelChar = modelChar + this.getSafeNetName(no.getName(), false);
                }
                StringBuffer infstr = new StringBuffer();
                infstr.append(modelChar);
                Iterator<Topology.CellSignal> sIt = subCni.getCellSignals();
                while (sIt.hasNext()) {
                    Topology.CellSignal subCS = sIt.next();
                    Export pp = subCS.getExport();
                    int exportIndex = subCS.getExportIndex();
                    if (pp != null && cell.getView() == View.SCHEMATIC && subCni.getCell().getView() == View.LAYOUT) {
                        Network subNet = subCS.getNetwork();
                        boolean found = false;
                        Iterator<Export> eIt = subCell.getExports();
                        while (eIt.hasNext()) {
                            Export ex = eIt.next();
                            for (int i = 0; i < ex.getNameKey().busWidth(); ++i) {
                                String exName = ex.getNameKey().subname(i).toString();
                                if (!exName.equals(subNet.getName())) continue;
                                pp = ex;
                                exportIndex = i;
                                found = true;
                                break;
                            }
                            if (!found) continue;
                            break;
                        }
                        if (!found) {
                            if (pp.isGround() && pp.getName().startsWith("gnd")) {
                                infstr.append(" gnd");
                                continue;
                            }
                            if (pp.isPower() && pp.getName().startsWith("vdd")) {
                                infstr.append(" vdd");
                                continue;
                            }
                            System.out.println("No matching export on schematic/icon found for export " + subNet.getName() + " in cell " + subCni.getCell().describe(false));
                            infstr.append(" unknown");
                            continue;
                        }
                    }
                    if (pp == null || subCS.isGlobal() && subCS.getNetwork().isExported() && !this.isGlobalExport(subCS)) continue;
                    Network net = netList.getNetwork(no, pp, exportIndex);
                    Topology.CellSignal cs = cni.getCellSignal(net);
                    if (useParasitics && !cs.isGlobal()) {
                        SegmentedNets subSegmentedNets = this.getSegmentedNets((Cell)no.getProto());
                        Network subNet = subCS.getNetwork();
                        ArrayList<String> exportNames = new ArrayList<String>();
                        Iterator<Export> it6 = subNet.getExports();
                        while (it6.hasNext()) {
                            Export e = it6.next();
                            PortInst pi = e.getOriginalPort();
                            String name = subSegmentedNets.getNetName(pi);
                            if (exportNames.contains(name)) continue;
                            exportNames.add(name);
                            pi = no.getNodeInst().findPortInstFromProto(no.getProto().findPortProto(e.getNameKey()));
                            name = segmentedNets.getNetName(pi);
                            infstr.append(" " + name);
                        }
                        continue;
                    }
                    String name = cs.getName();
                    if (segmentedNets.getUseParasitics()) {
                        name = segmentedNets.getNetName(no.getNodeInst().findPortInstFromProto(pp));
                    }
                    infstr.append(" " + name);
                }
                if (!Simulation.isSpiceUseNodeNames() || this.spiceEngine == Simulation.SpiceEngine.SPICE_ENGINE_3) {
                    Global.Set globals = subCni.getNetList().getGlobals();
                    int globalSize = globals.size();
                    for (int i = 0; i < globalSize; ++i) {
                        Global global = globals.get(i);
                        infstr.append(" " + global.getName());
                    }
                }
                if (this.useCDL) {
                    infstr.append(" /" + subCni.getParameterizedName());
                } else {
                    infstr.append(" " + subCni.getParameterizedName());
                }
                if (!this.useCDL && Simulation.isSpiceUseCellParameters()) {
                    Iterator<Variable> it7 = subCell.getParameters();
                    while (it7.hasNext()) {
                        Variable paramVar = it7.next();
                        Variable instVar = no.getVar(paramVar.getKey());
                        String paramStr = "??";
                        if (instVar != null) {
                            if (paramVar.getCode() != AbstractTextDescriptor.Code.SPICE) continue;
                            Object obj = context.evalSpice(instVar, false);
                            if (obj != null) {
                                paramStr = Spice.formatParam(String.valueOf(obj));
                            }
                        }
                        infstr.append(" " + paramVar.getTrueName() + "=" + paramStr);
                    }
                }
                this.writeMFactor(context, no, infstr);
                infstr.append("\n");
                this.multiLinePrint(false, infstr.toString());
                continue;
            }
            NodeInst ni3 = (NodeInst)no;
            PrimitiveNode.Function fun = ni3.getFunction();
            if (fun.isResistor() || fun == PrimitiveNode.Function.INDUCT || fun.isCapacitor() || fun == PrimitiveNode.Function.DIODE || fun == PrimitiveNode.Function.DIODEZ) {
                if (fun.isResistor()) {
                    if (fun == PrimitiveNode.Function.PRESIST && this.isShortExplicitResistors() || fun == PrimitiveNode.Function.RESIST && this.isShortResistors()) continue;
                    Variable resistVar = ni3.getVar(Schematics.SCHEM_RESISTANCE);
                    String extra = "";
                    String partName = "R";
                    if (resistVar != null) {
                        extra = resistVar.describe(context, ni3);
                        if (TextUtils.isANumber(extra)) {
                            double pureValue = TextUtils.atof(extra);
                            extra = TextUtils.formatDoublePostFix(pureValue);
                        }
                    } else if (fun == PrimitiveNode.Function.PRESIST) {
                        partName = "XR";
                        double width = ni3.getYSize();
                        double length = ni3.getXSize();
                        SizeOffset offset = ni3.getSizeOffset();
                        width = width - offset.getHighYOffset() - offset.getLowYOffset();
                        length = length - offset.getHighXOffset() - offset.getLowXOffset();
                        extra = " L='" + length + "*LAMBDA' W='" + width + "*LAMBDA'";
                        if (this.layoutTechnology == Technology.getTSMC90Technology() || cell.getView() == View.LAYOUT && cell.getTechnology() == Technology.getTSMC90Technology()) {
                            if (ni3.getProto().getName().equals("P-Poly-RPO-Resistor")) {
                                extra = "GND rpporpo" + extra;
                            }
                            if (ni3.getProto().getName().equals("N-Poly-RPO-Resistor")) {
                                extra = "GND rnporpo" + extra;
                            }
                        } else {
                            if (ni3.getProto().getName().equals("P-Poly-RPO-Resistor")) {
                                extra = "rppo1rpo" + extra;
                            }
                            if (ni3.getProto().getName().equals("N-Poly-RPO-Resistor")) {
                                extra = "rnpo1rpo" + extra;
                            }
                        }
                    }
                    this.writeTwoPort(ni3, partName, extra, cni, netList, context, segmentedNets);
                    continue;
                }
                if (fun.isCapacitor()) {
                    Variable capacVar = ni3.getVar(Schematics.SCHEM_CAPACITANCE);
                    String extra = "";
                    if (capacVar != null && TextUtils.isANumber(extra = capacVar.describe(context, ni3))) {
                        double pureValue = TextUtils.atof(extra);
                        extra = TextUtils.formatDoublePostFix(pureValue);
                    }
                    this.writeTwoPort(ni3, "C", extra, cni, netList, context, segmentedNets);
                    continue;
                }
                if (fun == PrimitiveNode.Function.INDUCT) {
                    Variable inductVar = ni3.getVar(Schematics.SCHEM_INDUCTANCE);
                    String extra = "";
                    if (inductVar != null && TextUtils.isANumber(extra = inductVar.describe(context, ni3))) {
                        double pureValue = TextUtils.atof(extra);
                        extra = TextUtils.formatDoublePostFix(pureValue);
                    }
                    this.writeTwoPort(ni3, "L", extra, cni, netList, context, segmentedNets);
                    continue;
                }
                if (fun != PrimitiveNode.Function.DIODE && fun != PrimitiveNode.Function.DIODEZ) continue;
                Variable diodeVar = ni3.getVar(Schematics.SCHEM_DIODE);
                String extra = "";
                if (diodeVar != null) {
                    extra = diodeVar.describe(context, ni3);
                }
                if (extra.length() == 0) {
                    extra = "DIODE";
                }
                this.writeTwoPort(ni3, "D", extra, cni, netList, context, segmentedNets);
                continue;
            }
            if (((PrimitiveNode)niProto).getGroupFunction() != PrimitiveNode.Function.TRANS) continue;
            Network gateNet = netList.getNetwork(ni3.getTransistorGatePort());
            Topology.CellSignal gateCs = cni.getCellSignal(gateNet);
            Network sourceNet = netList.getNetwork(ni3.getTransistorSourcePort());
            Topology.CellSignal sourceCs = cni.getCellSignal(sourceNet);
            Network drainNet = netList.getNetwork(ni3.getTransistorDrainPort());
            Topology.CellSignal drainCs = cni.getCellSignal(drainNet);
            Topology.CellSignal biasCs = null;
            PortInst biasPort = ni3.getTransistorBiasPort();
            if (biasPort != null) {
                biasCs = cni.getCellSignal(netList.getNetwork(biasPort));
            }
            if (gateCs == null || sourceCs == null || drainCs == null) {
                String message = "WARNING: " + ni3 + " not fully connected in " + cell;
                this.dumpErrorMessage(message);
            }
            String modelName = null;
            String defaultBulkName = null;
            Variable modelVar = ni3.getVar(SPICE_MODEL_KEY);
            if (modelVar != null) {
                modelName = modelVar.getObject().toString();
            }
            boolean st090laytrans = false;
            if (cell.getView() == View.LAYOUT && this.layoutTechnology == Technology.getTSMC90Technology()) {
                st090laytrans = true;
            }
            String modelChar = "";
            if (fun == PrimitiveNode.Function.TRANSREF) {
                modelChar = "X";
                biasCs = cni.getCellSignal(groundNet);
                modelName = niProto.getName();
            } else if (fun == PrimitiveNode.Function.TRANMOS) {
                modelChar = "M";
                biasCs = cni.getCellSignal(groundNet);
                defaultBulkName = "gnd";
                if (modelName == null) {
                    modelName = "N";
                }
                if (st090laytrans) {
                    modelChar = "XM";
                    modelName = "nsvt";
                }
            } else if (fun == PrimitiveNode.Function.TRA4NMOS) {
                modelChar = "M";
                if (modelName == null) {
                    modelName = "N";
                }
                if (st090laytrans) {
                    modelChar = "XM";
                    modelName = "nsvt";
                }
            } else if (fun == PrimitiveNode.Function.TRADMOS) {
                modelChar = "M";
                biasCs = cni.getCellSignal(groundNet);
                if (modelName == null) {
                    modelName = "D";
                }
            } else if (fun == PrimitiveNode.Function.TRA4DMOS) {
                modelChar = "M";
                if (modelName == null) {
                    modelName = "D";
                }
            } else if (fun == PrimitiveNode.Function.TRAPMOS) {
                modelChar = "M";
                biasCs = cni.getCellSignal(powerNet);
                defaultBulkName = "vdd";
                if (modelName == null) {
                    modelName = "P";
                }
                if (st090laytrans) {
                    modelChar = "XM";
                    modelName = "psvt";
                }
            } else if (fun == PrimitiveNode.Function.TRA4PMOS) {
                modelChar = "M";
                if (modelName == null) {
                    modelName = "P";
                }
                if (st090laytrans) {
                    modelChar = "XM";
                    modelName = "psvt";
                }
            } else if (fun == PrimitiveNode.Function.TRANPN) {
                modelChar = "Q";
                if (modelName == null) {
                    modelName = "NBJT";
                }
            } else if (fun == PrimitiveNode.Function.TRA4NPN) {
                modelChar = "Q";
                if (modelName == null) {
                    modelName = "NBJT";
                }
            } else if (fun == PrimitiveNode.Function.TRAPNP) {
                modelChar = "Q";
                if (modelName == null) {
                    modelName = "PBJT";
                }
            } else if (fun == PrimitiveNode.Function.TRA4PNP) {
                modelChar = "Q";
                if (modelName == null) {
                    modelName = "PBJT";
                }
            } else if (fun == PrimitiveNode.Function.TRANJFET) {
                modelChar = "J";
                biasCs = null;
                if (modelName == null) {
                    modelName = "NJFET";
                }
            } else if (fun == PrimitiveNode.Function.TRA4NJFET) {
                modelChar = "J";
                if (modelName == null) {
                    modelName = "NJFET";
                }
            } else if (fun == PrimitiveNode.Function.TRAPJFET) {
                modelChar = "J";
                biasCs = null;
                if (modelName == null) {
                    modelName = "PJFET";
                }
            } else if (fun == PrimitiveNode.Function.TRA4PJFET) {
                modelChar = "J";
                if (modelName == null) {
                    modelName = "PJFET";
                }
            } else if (fun == PrimitiveNode.Function.TRADMES || fun == PrimitiveNode.Function.TRA4DMES) {
                modelChar = "Z";
                biasCs = null;
                modelName = "DMES";
            } else if (fun == PrimitiveNode.Function.TRAEMES || fun == PrimitiveNode.Function.TRA4EMES) {
                modelChar = "Z";
                biasCs = null;
                modelName = "EMES";
            } else if (fun == PrimitiveNode.Function.TRANS) {
                modelChar = "Q";
            }
            if (ni3.getName() != null) {
                modelChar = modelChar + this.getSafeNetName(ni3.getName(), false);
            }
            StringBuffer infstr = new StringBuffer();
            String drainName = drainCs.getName();
            String gateName = gateCs.getName();
            String sourceName = sourceCs.getName();
            if (segmentedNets.getUseParasitics()) {
                drainName = segmentedNets.getNetName(ni3.getTransistorDrainPort());
                gateName = segmentedNets.getNetName(ni3.getTransistorGatePort());
                sourceName = segmentedNets.getNetName(ni3.getTransistorSourcePort());
            }
            infstr.append(modelChar + " " + drainName + " " + gateName + " " + sourceName);
            if (biasCs != null) {
                String biasName = biasCs.getName();
                if (segmentedNets.getUseParasitics() && ni3.getTransistorBiasPort() != null) {
                    biasName = segmentedNets.getNetName(ni3.getTransistorBiasPort());
                }
                infstr.append(" " + biasName);
            } else if (cell.getView() == View.LAYOUT && defaultBulkName != null) {
                infstr.append(" " + defaultBulkName);
            }
            if (modelName != null) {
                infstr.append(" " + modelName);
            }
            if ((size = ni3.getTransistorSize(context)) == null) {
                System.out.println("Warning: transistor with null size " + ni3.getName());
            } else if (size.getDoubleWidth() > 0.0 || size.getDoubleLength() > 0.0) {
                double w = this.maskScale * size.getDoubleWidth();
                double l = this.maskScale * size.getDoubleLength();
                double lengthSubtraction = this.layoutTechnology.getGateLengthSubtraction() / this.layoutTechnology.getScale() * 1000.0;
                l -= lengthSubtraction;
                if (!Simulation.isSpiceWriteTransSizeInLambda()) {
                    l *= this.layoutTechnology.getScale() / 1000.0;
                    w *= this.layoutTechnology.getScale() / 1000.0;
                }
                if (fun == PrimitiveNode.Function.TRANMOS || fun == PrimitiveNode.Function.TRA4NMOS || fun == PrimitiveNode.Function.TRAPMOS || fun == PrimitiveNode.Function.TRA4PMOS || fun == PrimitiveNode.Function.TRADMOS || fun == PrimitiveNode.Function.TRA4DMOS || (fun == PrimitiveNode.Function.TRANJFET || fun == PrimitiveNode.Function.TRAPJFET || fun == PrimitiveNode.Function.TRADMES || fun == PrimitiveNode.Function.TRAEMES) && (this.spiceEngine == Simulation.SpiceEngine.SPICE_ENGINE_H || this.spiceEngine == Simulation.SpiceEngine.SPICE_ENGINE_H_ASSURA)) {
                    if (size.getDoubleLength() == 0.0 && size.getLength() instanceof String) {
                        if (lengthSubtraction != 0.0) {
                            infstr.append(" L=" + Spice.formatParam((String)size.getLength()) + " - " + lengthSubtraction);
                        } else {
                            infstr.append(" L=" + Spice.formatParam((String)size.getLength()));
                        }
                    } else {
                        infstr.append(" L=" + TextUtils.formatDouble(l, 2));
                        if (!Simulation.isSpiceWriteTransSizeInLambda() && !st090laytrans) {
                            infstr.append("U");
                        }
                    }
                    if (size.getDoubleWidth() == 0.0 && size.getWidth() instanceof String) {
                        infstr.append(" W=" + Spice.formatParam((String)size.getWidth()));
                    } else {
                        infstr.append(" W=" + TextUtils.formatDouble(w, 2));
                        if (!Simulation.isSpiceWriteTransSizeInLambda() && !st090laytrans) {
                            infstr.append("U");
                        }
                    }
                }
                if (fun != PrimitiveNode.Function.TRANMOS && fun != PrimitiveNode.Function.TRA4NMOS && fun != PrimitiveNode.Function.TRAPMOS && fun != PrimitiveNode.Function.TRA4PMOS && fun != PrimitiveNode.Function.TRADMOS && fun != PrimitiveNode.Function.TRA4DMOS) {
                    infstr.append(" AREA=" + TextUtils.formatDouble(l * w, 2));
                    if (!Simulation.isSpiceWriteTransSizeInLambda()) {
                        infstr.append("P");
                    }
                }
            } else {
                double lengthSubtraction = this.layoutTechnology.getGateLengthSubtraction() / this.layoutTechnology.getScale() * 1000.0;
                if (size.getDoubleLength() == 0.0 && size.getLength() instanceof String) {
                    if (lengthSubtraction != 0.0) {
                        infstr.append(" L=" + Spice.formatParam((String)size.getLength()) + " - " + lengthSubtraction);
                    } else {
                        infstr.append(" L=" + Spice.formatParam((String)size.getLength()));
                    }
                }
                if (size.getDoubleWidth() == 0.0 && size.getWidth() instanceof String) {
                    infstr.append(" W=" + Spice.formatParam((String)size.getWidth()));
                }
            }
            SpiceNet spNetGate = spiceNetMap.get(gateNet);
            SpiceNet spNetSource = spiceNetMap.get(sourceNet);
            SpiceNet spNetDrain = spiceNetMap.get(drainNet);
            if (spNetGate == null || spNetSource == null || spNetDrain == null) continue;
            if (!(this.useCDL || fun != PrimitiveNode.Function.TRANMOS && fun != PrimitiveNode.Function.TRA4NMOS && fun != PrimitiveNode.Function.TRAPMOS && fun != PrimitiveNode.Function.TRA4PMOS && fun != PrimitiveNode.Function.TRADMOS && fun != PrimitiveNode.Function.TRA4DMOS)) {
                double as = 0.0;
                double ad = 0.0;
                double ps = 0.0;
                double pd = 0.0;
                if (spNetSource.transistorCount != 0) {
                    as = spNetSource.diffArea / (double)spNetSource.transistorCount;
                    ps = spNetSource.diffPerim / (double)spNetSource.transistorCount;
                    if (!Simulation.isSpiceWriteTransSizeInLambda()) {
                        as *= this.layoutTechnology.getScale() * this.layoutTechnology.getScale() / 1000000.0;
                        ps *= this.layoutTechnology.getScale() / 1000.0;
                    }
                }
                if (spNetDrain.transistorCount != 0) {
                    ad = spNetDrain.diffArea / (double)spNetDrain.transistorCount;
                    pd = spNetDrain.diffPerim / (double)spNetDrain.transistorCount;
                    if (!Simulation.isSpiceWriteTransSizeInLambda()) {
                        ad *= this.layoutTechnology.getScale() * this.layoutTechnology.getScale() / 1000000.0;
                        pd *= this.layoutTechnology.getScale() / 1000.0;
                    }
                }
                if (as > 0.0) {
                    infstr.append(" AS=" + TextUtils.formatDouble(as, 3));
                    if (!Simulation.isSpiceWriteTransSizeInLambda() && !st090laytrans) {
                        infstr.append("P");
                    }
                }
                if (ad > 0.0) {
                    infstr.append(" AD=" + TextUtils.formatDouble(ad, 3));
                    if (!Simulation.isSpiceWriteTransSizeInLambda() && !st090laytrans) {
                        infstr.append("P");
                    }
                }
                if (ps > 0.0) {
                    infstr.append(" PS=" + TextUtils.formatDouble(ps, 3));
                    if (!Simulation.isSpiceWriteTransSizeInLambda() && !st090laytrans) {
                        infstr.append("U");
                    }
                }
                if (pd > 0.0) {
                    infstr.append(" PD=" + TextUtils.formatDouble(pd, 3));
                    if (!Simulation.isSpiceWriteTransSizeInLambda() && !st090laytrans) {
                        infstr.append("U");
                    }
                }
            }
            this.writeMFactor(context, ni3, infstr);
            infstr.append("\n");
            this.multiLinePrint(false, infstr.toString());
        }
        if (!this.useCDL && Simulation.isSpiceUseParasitics() && cell.getView() == View.LAYOUT) {
            int capCount = 0;
            int resCount = 0;
            this.multiLinePrint(true, "** Extracted Parasitic Capacitors ***\n");
            for (SegmentedNets.NetInfo netInfo : segmentedNets.getUniqueSegments()) {
                if (!(netInfo.cap > cell.getTechnology().getMinCapacitance()) || netInfo.netName.equals("gnd")) continue;
                this.multiLinePrint(false, "C" + capCount + " " + netInfo.netName + " 0 " + TextUtils.formatDouble(netInfo.cap, 2) + "fF\n");
                ++capCount;
            }
            this.multiLinePrint(true, "** Extracted Parasitic Resistors ***\n");
            Iterator<ArcInst> it8 = cell.getArcs();
            while (it8.hasNext()) {
                ArcInst ai2 = it8.next();
                Double res = (Double)segmentedNets.arcRes.get(ai2);
                if (res == null) continue;
                String n0 = segmentedNets.getNetName(ai2.getHeadPortInst());
                String n1 = segmentedNets.getNetName(ai2.getTailPortInst());
                int arcPImodels = SegmentedNets.getNumPISegments(res, this.layoutTechnology.getMaxSeriesResistance());
                if (arcPImodels > 1) {
                    double segCap = segmentedNets.getArcCap(ai2) / (double)(arcPImodels + 1);
                    double segRes = res / (double)arcPImodels;
                    String segn0 = n0;
                    String segn1 = n0;
                    for (int i = 0; i < arcPImodels; ++i) {
                        segn1 = n0 + "##" + i;
                        if (i == arcPImodels - 1) {
                            segn1 = n1;
                        }
                        this.multiLinePrint(false, "R" + resCount + " " + segn0 + " " + segn1 + " " + TextUtils.formatDouble(segRes) + "\n");
                        ++resCount;
                        if (i < arcPImodels - 1 && !segn1.equals("gnd")) {
                            this.multiLinePrint(false, "C" + capCount + " " + segn1 + " 0 " + TextUtils.formatDouble(segCap) + "fF\n");
                            ++capCount;
                        }
                        segn0 = segn1;
                    }
                    continue;
                }
                this.multiLinePrint(false, "R" + resCount + " " + n0 + " " + n1 + " " + TextUtils.formatDouble(res, 2) + "\n");
                ++resCount;
            }
        }
        if (!this.useCDL) {
            boolean firstDecl = true;
            Iterator<NodeInst> it9 = cell.getNodes();
            while (it9.hasNext()) {
                Variable cardVar;
                NodeInst ni4 = it9.next();
                if (ni4.getProto() != Generic.tech.invisiblePinNode || (cardVar = ni4.getVar(SPICE_CARD_KEY)) == null) continue;
                if (firstDecl) {
                    firstDecl = false;
                    this.multiLinePrint(true, "\n* Spice Code nodes in cell " + cell + "\n");
                }
                this.emitEmbeddedSpice(cardVar, context, segmentedNets, info, false);
            }
        }
        NccCellAnnotations anna = NccCellAnnotations.getAnnotations(cell);
        if (cell == this.topCell && anna != null) {
            if (anna.getExportsConnected().hasNext()) {
                this.multiLinePrint(true, "\n*** Exports shorted due to NCC annotation 'exportsConnectedByParent':\n");
            }
            Iterator<List<NccCellAnnotations.NamePattern>> it10 = anna.getExportsConnected();
            while (it10.hasNext()) {
                List<NccCellAnnotations.NamePattern> list = it10.next();
                ArrayList<Network> netsToConnect = new ArrayList<Network>();
                for (NccCellAnnotations.NamePattern pat : list) {
                    Iterator<PortProto> it32 = cell.getPorts();
                    while (it32.hasNext()) {
                        Network net;
                        Export e = (Export)it32.next();
                        String name = e.getName();
                        if (!pat.matches(name) || netsToConnect.contains(net = netList.getNetwork(e, 0))) continue;
                        netsToConnect.add(net);
                    }
                }
                String name = null;
                for (Network net : netsToConnect) {
                    if (name != null) {
                        this.multiLinePrint(false, "R" + name + " " + name + " " + net.getName() + " 0.001\n");
                    }
                    name = net.getName();
                }
            }
        }
        if (cell != this.topCell || this.useCDL || Simulation.isSpiceWriteSubcktTopCell()) {
            this.multiLinePrint(false, ".ENDS " + cni.getParameterizedName() + "\n");
        }
        if (cell == this.topCell && Simulation.isSpiceWriteSubcktTopCell()) {
            this.multiLinePrint(false, "\n\n" + topLevelInstance + "\n\n");
        }
    }

    private void emitEmbeddedSpice(Variable cardVar, VarContext context, SegmentedNets segmentedNets, HierarchyEnumerator.CellInfo info, boolean flatNetNames) {
        Object obj = cardVar.getObject();
        if (!(obj instanceof String) && !(obj instanceof String[])) {
            return;
        }
        if (!cardVar.isDisplay()) {
            return;
        }
        if (obj instanceof String) {
            StringBuffer buf = this.replacePortsAndVars((String)obj, context.getNodable(), context.pop(), null, segmentedNets, info, flatNetNames);
            buf.append('\n');
            String msg = buf.toString();
            boolean isComment = false;
            if (msg.startsWith("*")) {
                isComment = true;
            }
            this.multiLinePrint(isComment, msg);
        } else {
            String[] strings = (String[])obj;
            for (int i = 0; i < strings.length; ++i) {
                StringBuffer buf = this.replacePortsAndVars(strings[i], context.getNodable(), context.pop(), null, segmentedNets, info, flatNetNames);
                buf.append('\n');
                String msg = buf.toString();
                boolean isComment = false;
                if (msg.startsWith("*")) {
                    isComment = true;
                }
                this.multiLinePrint(isComment, msg);
            }
        }
    }

    private boolean checkIfParameterized(Cell cell) {
        boolean mark = false;
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            Cell np;
            NodeInst ni = it.next();
            if (!ni.isCellInstance() || ni.isIconOfParent()) continue;
            if (ni.getVar(LENetlister.ATTR_LEGATE) != null) {
                np = (Cell)ni.getProto();
                if (np.contentsView() != null) {
                    np = np.contentsView();
                }
                if (np.getVar(LENetlister.ATTR_LEGATE) == null) continue;
                mark = true;
                continue;
            }
            if (ni.getVar(LENetlister.ATTR_LEKEEPER) != null) {
                np = (Cell)ni.getProto();
                if (np.contentsView() != null) {
                    np = np.contentsView();
                }
                if (np.getVar(LENetlister.ATTR_LEKEEPER) == null) continue;
                mark = true;
                continue;
            }
            Cell proto = ((Cell)ni.getProto()).contentsView();
            if (proto == null) {
                proto = (Cell)ni.getProto();
            }
            if (!this.checkIfParameterized(proto)) continue;
            mark = true;
        }
        if (mark) {
            this.uniquifyCells.put(cell, cell);
        }
        return mark;
    }

    @Override
    protected String parameterizedName(Nodable no, VarContext context) {
        Cell cell = (Cell)no.getProto();
        StringBuffer uniqueCellName = new StringBuffer(this.getUniqueCellName(cell));
        if (this.uniquifyCells.get(cell) != null) {
            VarContext vc = context.push(no);
            uniqueCellName.append("_" + vc.getInstPath("."));
        } else {
            boolean useCellParams;
            boolean bl = useCellParams = !this.useCDL && Simulation.isSpiceUseCellParameters();
            if (this.canParameterizeNames() && no.isCellInstance()) {
                ArrayList<Variable> paramValues = new ArrayList<Variable>();
                Iterator<Variable> it = no.getVariables();
                while (it.hasNext()) {
                    Variable var = it.next();
                    if (!no.getNodeInst().isParam(var.getKey())) continue;
                    Variable cellvar = cell.getVar(var.getKey());
                    if (useCellParams && cellvar.getCode() == AbstractTextDescriptor.Code.SPICE) continue;
                    paramValues.add(var);
                }
                for (Variable var : paramValues) {
                    String eval = var.describe(context, no);
                    if (eval == null) continue;
                    uniqueCellName.append("-" + eval.toString());
                }
            }
        }
        int limit = this.maxNameLength();
        if (limit > 0 && uniqueCellName.length() > limit) {
            Integer i = this.uniqueNames.get(uniqueCellName.toString());
            if (i == null) {
                i = new Integer(this.uniqueID);
                ++this.uniqueID;
                this.uniqueNames.put(uniqueCellName.toString(), i);
            }
            uniqueCellName = uniqueCellName.delete(limit - 10, uniqueCellName.length());
            uniqueCellName.append("-ID" + i);
        }
        return this.getSafeCellName(uniqueCellName.toString());
    }

    private StringBuffer replacePortsAndVars(String line, Nodable no, VarContext context, Topology.CellNetInfo cni, SegmentedNets segmentedNets, HierarchyEnumerator.CellInfo info, boolean flatNetNames) {
        StringBuffer infstr = new StringBuffer();
        Cell subCell = null;
        if (no != null) {
            subCell = (Cell)no.getProto();
        }
        for (int pt = 0; pt < line.length(); ++pt) {
            Variable.Key varKey;
            int start;
            char chr = line.charAt(pt);
            if (chr != '$' || pt + 1 >= line.length() || line.charAt(pt + 1) != '(') {
                infstr.append(chr);
                continue;
            }
            for (pt = start = pt + 2; pt < line.length() && line.charAt(pt) != ')'; ++pt) {
            }
            String paramName = line.substring(start, pt);
            PortProto pp = null;
            if (subCell != null) {
                pp = subCell.findPortProto(paramName);
            }
            if (paramName.equalsIgnoreCase("node_name") && no != null) {
                String nodeName = this.getSafeNetName(no.getName(), false);
                infstr.append(nodeName);
                continue;
            }
            if (cni != null && pp != null) {
                Network net = cni.getNetList().getNetwork(no, pp, 0);
                Topology.CellSignal cs = cni.getCellSignal(net);
                String portName = cs.getName();
                if (segmentedNets.getUseParasitics()) {
                    PortInst pi = no.getNodeInst().findPortInstFromProto(pp);
                    portName = segmentedNets.getNetName(pi);
                }
                if (flatNetNames) {
                    portName = info.getUniqueNetName(net, ".");
                }
                infstr.append(portName);
                continue;
            }
            if (no != null && (varKey = Variable.findKey("ATTR_" + paramName)) != null) {
                Variable attrVar = null;
                if (varKey != null && (attrVar = no.getVar(varKey)) == null) {
                    attrVar = no.getParameter(varKey);
                }
                if (attrVar == null) {
                    infstr.append("??");
                    continue;
                }
                String pVal = "?";
                Variable parentVar = attrVar;
                if (subCell != null) {
                    parentVar = subCell.getVar(attrVar.getKey());
                }
                if (!this.useCDL && Simulation.isSpiceUseCellParameters() && parentVar.getCode() == AbstractTextDescriptor.Code.SPICE) {
                    Object obj = context.evalSpice(attrVar, false);
                    if (obj != null) {
                        pVal = obj.toString();
                    }
                } else {
                    pVal = String.valueOf(context.evalVar(attrVar, no));
                }
                if (attrVar.getCode() != AbstractTextDescriptor.Code.NONE) {
                    pVal = Spice.trimSingleQuotes(pVal);
                }
                infstr.append(pVal);
                continue;
            }
            boolean found = false;
            String hierName = null;
            String[] names = paramName.split("\\.");
            if (names.length > 1 && flatNetNames) {
                Network net;
                Cell thisCell = info.getCell();
                Netlist thisNetlist = info.getNetlist();
                VarContext thisContext = context;
                if (no != null) {
                    thisContext = thisContext.push(no);
                }
                for (int i = 0; i < names.length - 1; ++i) {
                    boolean foundno = false;
                    Iterator<Nodable> it = thisNetlist.getNodables();
                    while (it.hasNext()) {
                        Nodable subno = it.next();
                        if (!subno.getName().equals(names[i])) continue;
                        if (subno.getProto() instanceof Cell) {
                            thisCell = (Cell)subno.getProto();
                            thisNetlist = thisNetlist.getNetlist(subno);
                            thisContext = thisContext.push(subno);
                        }
                        foundno = true;
                    }
                    if (foundno) continue;
                    System.out.println("Unable to find " + names[i] + " in " + paramName);
                    break;
                }
                if ((net = this.findNet(thisNetlist, names[names.length - 1])) != null) {
                    HierarchyEnumerator.NetNameProxy proxy = new HierarchyEnumerator.NetNameProxy(thisContext, ".x", net);
                    Global g = this.getGlobal(proxy.getNet());
                    hierName = g != null ? g.getName() : proxy.toString();
                }
            } else {
                Network net = this.findNet(info.getNetlist(), paramName);
                if (net != null) {
                    HierarchyEnumerator.NetNameProxy proxy;
                    Global g;
                    hierName = flatNetNames ? ((g = this.getGlobal((proxy = info.getUniqueNetNameProxy(net, ".x")).getNet())) != null ? g.getName() : proxy.toString()) : cni.getCellSignal(net).getName();
                }
            }
            if (hierName != null) {
                if (flatNetNames) {
                    int i;
                    if (hierName.indexOf(".x") > 0) {
                        hierName = "x" + hierName;
                    }
                    if ((i = hierName.lastIndexOf(".x")) > 0) {
                        hierName = hierName.substring(0, i + 1) + hierName.substring(i + 2);
                    } else {
                        i = hierName.lastIndexOf("." + paramName);
                        if (i > 0) {
                            hierName = hierName.substring(0, i) + "_" + hierName.substring(i + 1);
                        }
                    }
                }
                infstr.append(hierName);
                found = true;
            }
            if (found) continue;
            System.out.println("Unable to lookup key $(" + paramName + ") in cell " + context.getInstPath("."));
        }
        return infstr;
    }

    private Network findNet(Netlist netlist, String netName) {
        Network foundnet = null;
        Iterator<Network> it = netlist.getNetworks();
        while (it.hasNext()) {
            Network net = it.next();
            if (!net.hasName(netName)) continue;
            foundnet = net;
            break;
        }
        return foundnet;
    }

    private Global getGlobal(Network net) {
        Netlist netlist = net.getNetlist();
        for (int i = 0; i < netlist.getGlobals().size(); ++i) {
            Global g = netlist.getGlobals().get(i);
            if (netlist.getNetwork(g) != net) continue;
            return g;
        }
        return null;
    }

    private boolean isGlobalExport(Topology.CellSignal cs) {
        if (!cs.isGlobal() || !cs.isExported()) {
            return false;
        }
        Iterator<Export> it = cs.getNetwork().getExports();
        while (it.hasNext()) {
            Export ex = it.next();
            for (int i = 0; i < ex.getNameKey().busWidth(); ++i) {
                String name = ex.getNameKey().subname(i).canonicString();
                if (!cs.getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean ignoreSubcktPort(Topology.CellSignal cs) {
        Export pp = cs.getExport();
        if (pp == null) {
            return true;
        }
        if (cs.isGlobal() && !cs.getNetwork().isExported()) {
            return true;
        }
        if (cs.isGlobal() && cs.getNetwork().isExported() && !this.isGlobalExport(cs)) {
            return true;
        }
        if (this.useCDL) {
            // empty if block
        }
        return false;
    }

    private SegmentedNets getSegmentedNets(Cell cell) {
        for (SegmentedNets seg : this.segmentedParasiticInfo) {
            if (seg.cell != cell) continue;
            return seg;
        }
        return null;
    }

    private void backAnnotateLayout() {
        HashSet<Cell> cellsToClear = new HashSet<Cell>();
        ArrayList<PortInst> capsOnPorts = new ArrayList<PortInst>();
        ArrayList<String> valsOnPorts = new ArrayList<String>();
        ArrayList<ArcInst> resOnArcs = new ArrayList<ArcInst>();
        ArrayList<Double> valsOnArcs = new ArrayList<Double>();
        for (SegmentedNets segmentedNets : this.segmentedParasiticInfo) {
            Cell cell = segmentedNets.cell;
            if (cell.getView() != View.LAYOUT) continue;
            cellsToClear.add(cell);
            for (SegmentedNets.NetInfo info : segmentedNets.getUniqueSegments()) {
                PortInst pi = (PortInst)info.joinedPorts.iterator().next();
                if (!(info.cap > cell.getTechnology().getMinCapacitance())) continue;
                capsOnPorts.add(pi);
                valsOnPorts.add(TextUtils.formatDouble(info.cap, 2) + "fF");
            }
            Iterator<ArcInst> it = cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = it.next();
                Double res = (Double)segmentedNets.arcRes.get(ai);
                Variable var = ai.getVar(ATTR_R);
                resOnArcs.add(ai);
                valsOnArcs.add(res);
            }
        }
        new BackAnnotateJob(cellsToClear, capsOnPorts, valsOnPorts, resOnArcs, valsOnArcs);
    }

    @Override
    protected String getSafeCellName(String name) {
        return this.getSafeNetName(name, false);
    }

    @Override
    protected String getPowerName(Network net) {
        if (net != null) {
            Iterator<String> it = net.getNames();
            while (it.hasNext()) {
                String netName = it.next();
                if (!netName.equalsIgnoreCase("vdd")) continue;
                return "vdd";
            }
        }
        return null;
    }

    @Override
    protected String getGroundName(Network net) {
        if (this.spiceEngine == Simulation.SpiceEngine.SPICE_ENGINE_2 || this.spiceEngine == Simulation.SpiceEngine.SPICE_ENGINE_P || this.spiceEngine == Simulation.SpiceEngine.SPICE_ENGINE_G) {
            return "0";
        }
        if (net != null) {
            Iterator<String> it = net.getNames();
            while (it.hasNext()) {
                String netName = it.next();
                if (!netName.equalsIgnoreCase("gnd")) continue;
                return "gnd";
            }
        }
        return null;
    }

    @Override
    protected String getGlobalName(Global glob) {
        return glob.getName();
    }

    @Override
    protected boolean isNetworksUseExportedNames() {
        return false;
    }

    @Override
    protected boolean isLibraryNameAlwaysAddedToCellName() {
        return false;
    }

    @Override
    protected boolean isAggregateNamesSupported() {
        return false;
    }

    @Override
    protected boolean isChooseBestExportName() {
        return false;
    }

    @Override
    protected boolean isSeparateInputAndOutput() {
        return false;
    }

    @Override
    protected boolean skipCellAndSubcells(Cell cell) {
        if (this.useCDL) {
            Variable cdlTemplate = cell.getVar(CDL_TEMPLATE_KEY);
            return cdlTemplate != null;
        }
        Variable varTemplate = null;
        varTemplate = cell.getVar(this.preferedEngineTemplateKey);
        if (varTemplate != null) {
            return true;
        }
        if (!this.assuraHSpice) {
            varTemplate = cell.getVar(SPICE_TEMPLATE_KEY);
        }
        if (varTemplate != null) {
            return true;
        }
        if (CellModelPrefs.spiceModelPrefs.isUseModelFromFile(cell)) {
            String fileName = CellModelPrefs.spiceModelPrefs.getModelFile(cell);
            if (!this.modelOverrides.containsKey(cell)) {
                this.multiLinePrint(true, "\n* " + cell + " is described in this file:\n");
                this.addIncludeFile(fileName);
                if (!fileName.startsWith("/") && !fileName.startsWith("\\")) {
                    File spiceFile = new File(this.filePath);
                    fileName = new File(spiceFile.getParent(), fileName).getPath();
                }
                this.modelOverrides.put(cell, fileName);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void validateSkippedCell(HierarchyEnumerator.CellInfo info) {
        String fileName = this.modelOverrides.get(info.getCell());
        if (fileName != null) {
            SpiceNetlistReader reader = new SpiceNetlistReader();
            try {
                reader.readFile(fileName, false);
                HierarchyEnumerator.CellInfo parentInfo = info.getParentInfo();
                Nodable no = info.getParentInst();
                String parameterizedName = this.parameterizedName(no, parentInfo.getContext());
                Topology.CellNetInfo cni = this.getCellNetInfo(parameterizedName);
                SpiceNetlistReader.Subckt subckt = reader.getSubckts().get(parameterizedName.toLowerCase());
                if (subckt == null) {
                    System.out.println("Error: No subckt for " + parameterizedName + " found in included file: " + fileName);
                } else {
                    ArrayList<String> signals = new ArrayList<String>();
                    Iterator<Topology.CellSignal> sIt = cni.getCellSignals();
                    while (sIt.hasNext()) {
                        Topology.CellSignal cs = sIt.next();
                        if (this.ignoreSubcktPort(cs)) continue;
                        signals.add(cs.getName());
                    }
                    List<String> subcktSignals = subckt.getPorts();
                    if (signals.size() != subcktSignals.size()) {
                        System.out.println("Warning: wrong number of ports for subckt " + parameterizedName + ": expected " + signals.size() + ", but found " + subcktSignals.size() + ", in included file " + fileName);
                    }
                    int len = Math.min(signals.size(), subcktSignals.size());
                    for (int i = 0; i < len; ++i) {
                        String s2;
                        String s1 = (String)signals.get(i);
                        if (s1.equalsIgnoreCase(s2 = subcktSignals.get(i))) continue;
                        System.out.println("Warning: port " + i + " of subckt " + parameterizedName + " is named " + s1 + " in Electric, but " + s2 + " in included file " + fileName);
                    }
                }
            }
            catch (FileNotFoundException e) {
                System.out.println("Error validating included file: " + e.getMessage());
            }
        }
    }

    @Override
    protected String getSafeNetName(String name, boolean bus) {
        return Spice.getSafeNetName(name, bus, this.legalSpiceChars, this.spiceEngine);
    }

    public static String getSafeNetName(String name) {
        String legalSpiceChars = SPICELEGALCHARS;
        if (Simulation.getSpiceEngine() == Simulation.SpiceEngine.SPICE_ENGINE_P) {
            legalSpiceChars = PSPICELEGALCHARS;
        }
        return Spice.getSafeNetName(name, false, legalSpiceChars, Simulation.getSpiceEngine());
    }

    private static String getSafeNetName(String name, boolean bus, String legalSpiceChars, Simulation.SpiceEngine spiceEngine) {
        boolean allAlNum = true;
        int len = name.length();
        if (len <= 0) {
            return name;
        }
        for (int i = 0; i < len; ++i) {
            boolean valid = TextUtils.isLetterOrDigit(name.charAt(i));
            if (i == 0) {
                valid = Character.isLetter(name.charAt(i));
            }
            if (valid) continue;
            allAlNum = false;
            break;
        }
        if (allAlNum) {
            return name;
        }
        StringBuffer sb = new StringBuffer();
        if (TextUtils.isDigit(name.charAt(0)) && spiceEngine != Simulation.SpiceEngine.SPICE_ENGINE_G && spiceEngine != Simulation.SpiceEngine.SPICE_ENGINE_P && spiceEngine != Simulation.SpiceEngine.SPICE_ENGINE_2) {
            sb.append('_');
        }
        for (int t = 0; t < name.length(); ++t) {
            char chr = name.charAt(t);
            boolean legalChar = TextUtils.isLetterOrDigit(chr);
            if (!legalChar) {
                for (int j = 0; j < legalSpiceChars.length(); ++j) {
                    char legalChr = legalSpiceChars.charAt(j);
                    if (chr != legalChr) continue;
                    legalChar = true;
                    break;
                }
            }
            if (!legalChar) {
                chr = '_';
            }
            sb.append(chr);
        }
        return sb.toString();
    }

    @Override
    protected boolean isShortResistors() {
        return this.useCDL && Simulation.getCDLIgnoreResistors();
    }

    @Override
    protected boolean isShortExplicitResistors() {
        if (this.useCDL && Simulation.getCDLIgnoreResistors()) {
            return false;
        }
        return false;
    }

    @Override
    protected boolean canParameterizeNames() {
        return true;
    }

    @Override
    protected int maxNameLength() {
        if (this.useCDL) {
            return 40;
        }
        return 70;
    }

    @Override
    protected boolean enumerateLayoutView(Cell cell) {
        return CellModelPrefs.spiceModelPrefs.isUseLayoutView(cell);
    }

    private void writeHeader(Cell cell) {
        String headerFile;
        boolean useParasitics;
        this.multiLinePrint(true, "*** SPICE deck for cell " + cell.noLibDescribe() + " from library " + cell.getLibrary().getName() + "\n");
        this.emitCopyright("*** ", "");
        if (User.isIncludeDateAndVersionInOutput()) {
            this.multiLinePrint(true, "*** Created on " + TextUtils.formatDate(this.topCell.getCreationDate()) + "\n");
            this.multiLinePrint(true, "*** Last revised on " + TextUtils.formatDate(this.topCell.getRevisionDate()) + "\n");
            this.multiLinePrint(true, "*** Written on " + TextUtils.formatDate(new Date()) + " by Electric VLSI Design System, version " + Version.getVersion() + "\n");
        } else {
            this.multiLinePrint(true, "*** Written by Electric VLSI Design System\n");
        }
        String foundry = this.layoutTechnology.getSelectedFoundry() == null ? "" : ", foundry " + this.layoutTechnology.getSelectedFoundry().toString();
        this.multiLinePrint(true, "*** Layout tech: " + this.layoutTechnology.getTechName() + foundry + "\n");
        this.multiLinePrint(true, "*** UC SPICE *** , MIN_RESIST " + this.layoutTechnology.getMinResistance() + ", MIN_CAPAC " + this.layoutTechnology.getMinCapacitance() + "FF\n");
        boolean bl = useParasitics = !this.useCDL && Simulation.isSpiceUseParasitics() && cell.getView() == View.LAYOUT;
        if (useParasitics) {
            for (Layer layer : this.layoutTechnology.getLayersSortedByHeight()) {
                double edgecap = layer.getEdgeCapacitance();
                double areacap = layer.getCapacitance();
                double res = layer.getResistance();
                if (edgecap == 0.0 && areacap == 0.0 && res == 0.0) continue;
                this.multiLinePrint(true, "***    " + layer.getName() + ":\tareacap=" + areacap + "FF/um^2,\tedgecap=" + edgecap + "FF/um,\tres=" + res + "ohms/sq\n");
            }
        }
        this.multiLinePrint(false, ".OPTIONS NOMOD NOPAGE\n");
        if (Simulation.isSpiceWriteTransSizeInLambda()) {
            double scale = this.layoutTechnology.getScale();
            this.multiLinePrint(true, "*** Lambda Conversion ***\n");
            this.multiLinePrint(false, ".opt scale=" + TextUtils.formatDouble(scale / 1000.0, 3) + "U\n\n");
        }
        if ((headerFile = Simulation.getSpiceHeaderCardInfo()).length() > 0) {
            if (headerFile.startsWith(SPICE_EXTENSION_PREFIX)) {
                String headerPath = TextUtils.getFilePath(TextUtils.makeURLToFile(this.filePath));
                String ext = headerFile.substring(SPICE_EXTENSION_PREFIX.length());
                if (ext.startsWith(".")) {
                    ext = ext.substring(1);
                }
                String filePart = cell.getName() + "." + ext;
                String fileName = headerPath + filePart;
                File test = new File(fileName);
                if (test.exists()) {
                    this.multiLinePrint(true, "* Model cards are described in this file:\n");
                    this.addIncludeFile(filePart);
                    System.out.println("Spice Header Card '" + fileName + "' is included");
                    return;
                }
                System.out.println("Spice Header Card '" + fileName + "' cannot be loaded");
            } else {
                File test = new File(headerFile);
                if (!test.exists()) {
                    System.out.println("Warning: cannot find model file '" + headerFile + "'");
                }
                this.multiLinePrint(true, "* Model cards are described in this file:\n");
                this.addIncludeFile(headerFile);
                return;
            }
        }
        int level = TextUtils.atoi(Simulation.getSpiceLevel());
        String[] header = null;
        switch (level) {
            case 1: {
                header = this.layoutTechnology.getSpiceHeaderLevel1();
                break;
            }
            case 2: {
                header = this.layoutTechnology.getSpiceHeaderLevel2();
                break;
            }
            case 3: {
                header = this.layoutTechnology.getSpiceHeaderLevel3();
            }
        }
        if (header != null) {
            for (int i = 0; i < header.length; ++i) {
                this.multiLinePrint(false, header[i] + "\n");
            }
            return;
        }
        System.out.println("WARNING: no model cards for SPICE level " + level + " in " + this.layoutTechnology.getTechName() + " technology");
    }

    private void writeTrailer(Cell cell) {
        String trailerFile = Simulation.getSpiceTrailerCardInfo();
        if (trailerFile.length() > 0) {
            if (trailerFile.startsWith(SPICE_EXTENSION_PREFIX)) {
                String trailerpath = TextUtils.getFilePath(TextUtils.makeURLToFile(this.filePath));
                String ext = trailerFile.substring(SPICE_EXTENSION_PREFIX.length());
                if (ext.startsWith(".")) {
                    ext = ext.substring(1);
                }
                String filePart = cell.getName() + "." + ext;
                String fileName = trailerpath + filePart;
                File test = new File(fileName);
                if (test.exists()) {
                    this.multiLinePrint(true, "* Trailer cards are described in this file:\n");
                    this.addIncludeFile(filePart);
                    System.out.println("Spice Trailer Card '" + fileName + "' is included");
                } else {
                    System.out.println("Spice Trailer Card '" + fileName + "' cannot be loaded");
                }
            } else {
                this.multiLinePrint(true, "* Trailer cards are described in this file:\n");
                this.addIncludeFile(trailerFile);
                System.out.println("Spice Trailer Card '" + trailerFile + "' is included");
            }
        }
    }

    private void writeTwoPort(NodeInst ni, String partName, String extra, Topology.CellNetInfo cni, Netlist netList, VarContext context, SegmentedNets segmentedNets) {
        String message;
        PortInst port0 = ni.getPortInst(0);
        PortInst port1 = ni.getPortInst(1);
        Network net0 = netList.getNetwork(port0);
        Network net1 = netList.getNetwork(port1);
        Topology.CellSignal cs0 = cni.getCellSignal(net0);
        Topology.CellSignal cs1 = cni.getCellSignal(net1);
        if (cs0 == null || cs1 == null) {
            message = "WARNING: " + ni + " component not fully connected in " + ni.getParent();
            this.dumpErrorMessage(message);
        }
        if (cs0 != null && cs1 != null && cs0 == cs1) {
            message = "WARNING: " + ni + " component appears to be shorted on net " + net0.toString() + " in " + ni.getParent();
            this.dumpErrorMessage(message);
            return;
        }
        if (ni.getName() != null) {
            partName = partName + this.getSafeNetName(ni.getName(), false);
        }
        StringBuffer sbExtra = new StringBuffer(extra);
        this.writeMFactor(context, ni, sbExtra);
        String name0 = cs0.getName();
        String name1 = cs1.getName();
        if (segmentedNets.getUseParasitics()) {
            name0 = segmentedNets.getNetName(port0);
            name1 = segmentedNets.getNetName(port1);
        }
        this.multiLinePrint(false, partName + " " + name1 + " " + name0 + " " + sbExtra.toString() + "\n");
    }

    private static String formatParam(String param) {
        String value = Spice.trimSingleQuotes(param);
        try {
            Double.valueOf(value);
            return value;
        }
        catch (NumberFormatException e) {
            return "'" + value + "'";
        }
    }

    private static String trimSingleQuotes(String param) {
        if (param.startsWith("'") && param.endsWith("'")) {
            return param.substring(1, param.length() - 1);
        }
        return param;
    }

    private void addNodeInformation(Netlist netList, HashMap<Network, SpiceNet> spiceNets, NodeInst ni) {
        if (ni.isCellInstance()) {
            return;
        }
        PrimitiveNode.Function function = ni.getFunction();
        Technology tech = ni.getProto().getTechnology();
        AffineTransform trans = ni.rotateOut();
        for (Poly poly : tech.getShapeOfNode(ni, null, null, true, true, null)) {
            SpiceNet spNet;
            PortProto pp = poly.getPort();
            if (pp == null) continue;
            Network net = netList.getNetwork(ni, pp, 0);
            Layer layer = poly.getLayer();
            if (!layer.isDiffusionLayer() && layer.getCapacitance() == 0.0 || layer.getTechnology() != Technology.getCurrent() || layer.getFunction() == Layer.Function.GATE || (spNet = spiceNets.get(net)) == null) continue;
            poly.transform(trans);
            spNet.merge.addPolygon(layer, poly);
            if (!layer.isDiffusionLayer() || !function.isTransistor()) continue;
            ++spNet.transistorCount;
        }
    }

    private void addArcInformation(PolyMerge merge, ArcInst ai) {
        boolean isDiffArc = ai.isDiffusionArc();
        Technology tech = ai.getProto().getTechnology();
        for (Poly poly : tech.getShapeOfArc(ai)) {
            Layer layer;
            if (poly.getStyle().isText() || (layer = poly.getLayer()).getTechnology() != Technology.getCurrent() || (layer.getFunctionExtras() & 0x1000) != 0 || !layer.isDiffusionLayer() && (isDiffArc || !(layer.getCapacitance() > 0.0))) continue;
            merge.addPolygon(layer, poly);
        }
    }

    private void addIncludeFile(String fileName) {
        if (this.useCDL) {
            this.multiLinePrint(false, ".include " + fileName + "\n");
            return;
        }
        if (this.spiceEngine == Simulation.SpiceEngine.SPICE_ENGINE_2 || this.spiceEngine == Simulation.SpiceEngine.SPICE_ENGINE_3 || this.spiceEngine == Simulation.SpiceEngine.SPICE_ENGINE_G || this.spiceEngine == Simulation.SpiceEngine.SPICE_ENGINE_S) {
            this.multiLinePrint(false, ".include " + fileName + "\n");
        } else if (this.spiceEngine == Simulation.SpiceEngine.SPICE_ENGINE_H || this.spiceEngine == Simulation.SpiceEngine.SPICE_ENGINE_H_ASSURA || this.spiceEngine == Simulation.SpiceEngine.SPICE_ENGINE_H_CALIBRE) {
            this.multiLinePrint(false, ".include '" + fileName + "'\n");
        } else if (this.spiceEngine == Simulation.SpiceEngine.SPICE_ENGINE_P) {
            this.multiLinePrint(false, ".INC " + fileName + "\n");
        }
    }

    private void validateIncludeFile(String fileName, String subcktName) {
    }

    private boolean cellIsEmpty(Cell cell) {
        Boolean b = this.checkedCells.get(cell);
        if (b != null) {
            return b;
        }
        boolean empty = true;
        ArrayList emptyCells = new ArrayList();
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (ni.isCellInstance()) {
                if (ni.isIconOfParent()) continue;
                Cell iconCell = (Cell)ni.getProto();
                Cell schCell = iconCell.contentsView();
                if (schCell == null) {
                    schCell = iconCell;
                }
                if (this.cellIsEmpty(schCell)) continue;
                empty = false;
                break;
            }
            PrimitiveNode.Function fun = ni.getFunction();
            if (fun.isResistor() || fun == PrimitiveNode.Function.INDUCT || fun.isCapacitor() || fun == PrimitiveNode.Function.DIODE || fun == PrimitiveNode.Function.DIODEZ) {
                empty = false;
                break;
            }
            if (((PrimitiveNode)ni.getProto()).getGroupFunction() != PrimitiveNode.Function.TRANS) continue;
            empty = false;
            break;
        }
        if (CellModelPrefs.spiceModelPrefs.isUseModelFromFile(cell)) {
            empty = false;
        }
        this.checkedCells.put(cell, new Boolean(empty));
        return empty;
    }

    private void dumpErrorMessage(String message) {
        this.multiLinePrint(true, "*** " + message + "\n");
        System.out.println(message);
    }

    private void multiLinePrint(boolean isComment, String str) {
        char contChar = '+';
        if (isComment) {
            contChar = '*';
        }
        int lastSpace = -1;
        int count = 0;
        boolean insideQuotes = false;
        int lineStart = 0;
        for (int pt = 0; pt < str.length(); ++pt) {
            char chr = str.charAt(pt);
            if (chr == '\n') {
                this.printWriter.print(str.substring(lineStart, pt + 1));
                count = 0;
                lastSpace = -1;
                lineStart = pt + 1;
                continue;
            }
            if (chr == ' ' && !insideQuotes) {
                lastSpace = pt;
            }
            if (chr == '\'') {
                boolean bl = insideQuotes = !insideQuotes;
            }
            if (++count < this.spiceMaxLenLine || insideQuotes || lastSpace <= -1) continue;
            String partial = str.substring(lineStart, lastSpace + 1);
            this.printWriter.print(partial + "\n" + contChar);
            count -= partial.length();
            lineStart = lastSpace + 1;
            lastSpace = -1;
        }
        if (lineStart < str.length()) {
            String partial = str.substring(lineStart);
            this.printWriter.print(partial);
        }
    }

    public static class FlatSpiceCodeVisitor
    extends HierarchyEnumerator.Visitor {
        private PrintWriter printWriter;
        private PrintWriter spicePrintWriter;
        private String filePath;
        Spice spice;
        SegmentedNets segNets;

        public FlatSpiceCodeVisitor(String filePath, Spice spice) {
            this.spice = spice;
            this.spicePrintWriter = spice.printWriter;
            this.filePath = filePath;
            spice.spiceMaxLenLine = 1000;
            this.segNets = null;
        }

        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            return true;
        }

        public void exitCell(HierarchyEnumerator.CellInfo info) {
            Cell cell = info.getCell();
            Iterator<NodeInst> it = cell.getNodes();
            while (it.hasNext()) {
                Variable cardVar;
                NodeInst ni = it.next();
                if (ni.getProto() != Generic.tech.invisiblePinNode || (cardVar = ni.getVar(SPICE_CODE_FLAT_KEY)) == null) continue;
                if (this.printWriter == null) {
                    try {
                        this.printWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.filePath)));
                    }
                    catch (IOException e) {
                        System.out.println("Unable to open " + this.filePath + " for write.");
                        return;
                    }
                    this.spice.printWriter = this.printWriter;
                    this.segNets = new SegmentedNets(null, false, null, false);
                }
                this.spice.emitEmbeddedSpice(cardVar, info.getContext(), this.segNets, info, true);
            }
        }

        public boolean visitNodeInst(Nodable ni, HierarchyEnumerator.CellInfo info) {
            return true;
        }

        public void close() {
            if (this.printWriter != null) {
                System.out.println(this.filePath + " written");
                this.spice.printWriter = this.spicePrintWriter;
                this.printWriter.close();
            }
            this.spice.spiceMaxLenLine = 78;
        }
    }

    private static class ExemptedNets {
        private HashMap<Cell, List<Net>> netsByCell = new HashMap();
        private Set<Integer> exemptedNetIDs = new TreeSet<Integer>();

        private ExemptedNets(File file) {
            try {
                String line;
                FileReader reader = new FileReader(file);
                BufferedReader br = new BufferedReader(reader);
                int lineno = 1;
                System.out.println("Using exempted nets file " + file.getAbsolutePath());
                while ((line = br.readLine()) != null) {
                    this.processLine(line, lineno);
                    ++lineno;
                }
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                return;
            }
        }

        private void processLine(String line, int lineno) {
            List<Net> list;
            if (line == null) {
                return;
            }
            if (line.trim().equals("")) {
                return;
            }
            String[] parts = line.trim().split("\\s+");
            if (parts.length < 3) {
                System.out.println("Error on line " + lineno + ": Expected 'LibraryName CellName NetName', but was " + line);
                return;
            }
            Cell cell = this.getCell(parts[0], parts[1]);
            if (cell == null) {
                return;
            }
            double cap = 0.0;
            if (parts.length > 3) {
                try {
                    cap = Double.parseDouble(parts[3]);
                }
                catch (NumberFormatException e) {
                    System.out.println("Error on line " + lineno + " " + e.getMessage());
                }
            }
            if ((list = this.netsByCell.get(cell)) == null) {
                list = new ArrayList<Net>();
                this.netsByCell.put(cell, list);
            }
            Net n = new Net();
            n.name = parts[2];
            n.replacementCap = cap;
            list.add(n);
        }

        private Cell getCell(String library, String cell) {
            Library lib = Library.findLibrary(library);
            if (lib == null) {
                System.out.println("Could not find library " + library);
                return null;
            }
            Cell c = lib.findNodeProto(cell);
            if (c == null) {
                System.out.println("Could not find cell " + cell + " in library " + library);
                return null;
            }
            return c;
        }

        private void setExemptedNets(HierarchyEnumerator.CellInfo info) {
            Cell cell = info.getCell();
            List<Net> netNames = this.netsByCell.get(cell);
            if (netNames == null) {
                return;
            }
            for (Net n : netNames) {
                String netName = n.name;
                Network net = this.findNetwork(info, netName);
                if (net == null) {
                    System.out.println("Cannot find network " + netName + " in cell " + cell.describe(true));
                    continue;
                }
                System.out.println("Specified exemption of net " + cell.describe(false) + "  " + netName);
                int netID = info.getNetID(net);
                this.exemptedNetIDs.add(new Integer(netID));
            }
        }

        private Network findNetwork(HierarchyEnumerator.CellInfo info, String name) {
            Iterator<Network> it = info.getNetlist().getNetworks();
            while (it.hasNext()) {
                Network net = it.next();
                if (!net.hasName(name)) continue;
                return net;
            }
            return null;
        }

        private boolean isExempted(int netID) {
            return this.exemptedNetIDs.contains(new Integer(netID));
        }

        private double getReplacementCap(Cell cell, Network net) {
            List<Net> netNames = this.netsByCell.get(cell);
            if (netNames == null) {
                return 0.0;
            }
            for (Net n : netNames) {
                if (!net.hasName(n.name)) continue;
                return n.replacementCap;
            }
            return 0.0;
        }

        private static class Net {
            private String name;
            private double replacementCap;

            private Net() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BackAnnotateJob
    extends Job {
        private Set<Cell> cellsToClear;
        private List<PortInst> capsOnPorts;
        private List<String> valsOnPorts;
        private List<ArcInst> resOnArcs;
        private List<Double> valsOnArcs;

        private BackAnnotateJob(Set<Cell> cellsToClear, List<PortInst> capsOnPorts, List<String> valsOnPorts, List<ArcInst> resOnArcs, List<Double> valsOnArcs) {
            super("Spice Layout Back Annotate", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.capsOnPorts = capsOnPorts;
            this.valsOnPorts = valsOnPorts;
            this.resOnArcs = resOnArcs;
            this.valsOnArcs = valsOnArcs;
            this.cellsToClear = cellsToClear;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            int i;
            TextDescriptor ctd = TextDescriptor.getPortInstTextDescriptor().withDispPart(AbstractTextDescriptor.DispPos.NAMEVALUE);
            TextDescriptor rtd = TextDescriptor.getArcTextDescriptor().withDispPart(AbstractTextDescriptor.DispPos.NAMEVALUE);
            int capCount = 0;
            int resCount = 0;
            for (Cell cell : this.cellsToClear) {
                Iterator<NodeInst> it = cell.getNodes();
                while (it.hasNext()) {
                    NodeInst ni = it.next();
                    Iterator<PortInst> pit = ni.getPortInsts();
                    while (pit.hasNext()) {
                        PortInst pi = pit.next();
                        Variable var = pi.getVar(ATTR_C);
                        if (var == null) continue;
                        pi.delVar(var.getKey());
                    }
                }
            }
            for (i = 0; i < this.capsOnPorts.size(); ++i) {
                PortInst pi = this.capsOnPorts.get(i);
                String str = this.valsOnPorts.get(i);
                pi.newVar(ATTR_C, (Object)str, ctd);
                ++resCount;
            }
            for (i = 0; i < this.resOnArcs.size(); ++i) {
                ArcInst ai = this.resOnArcs.get(i);
                Double res = this.valsOnArcs.get(i);
                Variable var = ai.getVar(ATTR_R);
                if (res == null && var != null) {
                    ai.delVar(ATTR_R);
                }
                if (res == null) continue;
                ai.newVar(ATTR_R, (Object)res, rtd);
                ++resCount;
            }
            System.out.println("Back-annotated " + resCount + " Resistors and " + capCount + " Capacitors");
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SegmentedNets {
        private static Comparator<PortInst> PORT_INST_COMPARATOR = new Comparator<PortInst>(){

            @Override
            public int compare(PortInst p1, PortInst p2) {
                if (p1 == p2) {
                    return 0;
                }
                int cmp = p1.getNodeInst().compareTo(p2.getNodeInst());
                if (cmp != 0) {
                    return cmp;
                }
                if (p1.getPortIndex() < p2.getPortIndex()) {
                    return -1;
                }
                return 1;
            }
        };
        private HashMap<PortInst, NetInfo> segmentedNets = new HashMap();
        private HashMap<ArcInst, Double> arcRes = new HashMap();
        boolean verboseNames = false;
        private Topology.CellNetInfo cni;
        boolean useParasitics = false;
        private HashMap<Network, Integer> netCounters;
        private Cell cell;
        private List<List<String>> shortedExports;
        private HashMap<ArcInst, Double> longArcCaps;

        private SegmentedNets(Cell cell, boolean verboseNames, Topology.CellNetInfo cni, boolean useParasitics) {
            this.verboseNames = verboseNames;
            this.cni = cni;
            this.useParasitics = useParasitics;
            this.netCounters = new HashMap();
            this.cell = cell;
            this.shortedExports = new ArrayList<List<String>>();
            this.longArcCaps = new HashMap();
        }

        private NetInfo putSegment(PortInst pi, double cap) {
            NetInfo info = this.segmentedNets.get(pi);
            if (info == null) {
                info = new NetInfo();
                info.netName = this.getNewName(pi, info);
                info.cap += cap;
                if (this.isPowerGround(pi)) {
                    info.cap = 0.0;
                }
                info.joinedPorts.add(pi);
                this.segmentedNets.put(pi, info);
            } else {
                info.cap += cap;
            }
            return info;
        }

        private String getNewName(PortInst pi, NetInfo info) {
            Export ex;
            Network net = this.cni.getNetList().getNetwork(pi);
            Topology.CellSignal cs = this.cni.getCellSignal(net);
            if (!this.useParasitics || !Simulation.isParasiticsExtractPowerGround() && this.isPowerGround(pi)) {
                return cs.getName();
            }
            Integer i = this.netCounters.get(net);
            if (i == null) {
                i = new Integer(0);
                this.netCounters.put(net, i);
            }
            String name = info.netName;
            Export export = ex = pi.getExports().hasNext() ? pi.getExports().next() : null;
            if (ex != null) {
                name = ex.getName();
            } else {
                name = i == 0 && !cs.isExported() ? cs.getName() : (this.verboseNames ? cs.getName() + "#" + i + pi.getNodeInst().getName() + "_" + pi.getPortProto().getName() : cs.getName() + "#" + i);
                i = new Integer(i + 1);
                this.netCounters.put(net, i);
            }
            return name;
        }

        private void shortSegments(PortInst p1, PortInst p2) {
            if (!this.segmentedNets.containsKey(p1)) {
                this.putSegment(p1, 0.0);
            }
            if (!this.segmentedNets.containsKey(p2)) {
                // empty if block
            }
            this.putSegment(p2, 0.0);
            NetInfo info1 = this.segmentedNets.get(p1);
            NetInfo info2 = this.segmentedNets.get(p2);
            if (info1 == info2) {
                return;
            }
            info1.joinedPorts.addAll(info2.joinedPorts);
            info1.cap += info2.cap;
            if (TextUtils.STRING_NUMBER_ORDER.compare(info2.netName, info1.netName) < 0) {
                info1.netName = info2.netName;
            }
            for (PortInst pi : info1.joinedPorts) {
                this.segmentedNets.put(pi, info1);
            }
        }

        private String getNetName(PortInst pi) {
            if (!this.useParasitics || this.isPowerGround(pi) && !Simulation.isParasiticsExtractPowerGround()) {
                Topology.CellSignal cs = this.cni.getCellSignal(this.cni.getNetList().getNetwork(pi));
                return cs.getName();
            }
            NetInfo info = this.segmentedNets.get(pi);
            if (info == null) {
                info = this.putSegment(pi, 0.0);
            }
            return info.netName;
        }

        private void addArcRes(ArcInst ai, double res) {
            if (this.isPowerGround(ai.getHeadPortInst()) && this.isPowerGround(ai.getTailPortInst()) && !Simulation.isParasiticsExtractPowerGround()) {
                this.shortSegments(ai.getHeadPortInst(), ai.getTailPortInst());
                return;
            }
            this.arcRes.put(ai, new Double(res));
        }

        private boolean isPowerGround(PortInst pi) {
            Network net = this.cni.getNetList().getNetwork(pi);
            Topology.CellSignal cs = this.cni.getCellSignal(net);
            if (cs.isPower() || cs.isGround()) {
                return true;
            }
            if (cs.getName().startsWith("vdd")) {
                return true;
            }
            return cs.getName().startsWith("gnd");
        }

        private TreeSet<NetInfo> getUniqueSegments() {
            return new TreeSet<NetInfo>(this.segmentedNets.values());
        }

        private boolean getUseParasitics() {
            return this.useParasitics;
        }

        private void addShortedExports(List<String> exports) {
            this.shortedExports.add(exports);
        }

        private Iterator<List<String>> getShortedExports() {
            return this.shortedExports.iterator();
        }

        public static int getNumPISegments(double res, double maxSeriesResistance) {
            int arcPImodels = 1;
            arcPImodels = (int)(res / maxSeriesResistance);
            if (res % maxSeriesResistance != 0.0) {
                ++arcPImodels;
            }
            return arcPImodels;
        }

        private void addArcCap(ArcInst ai, double cap) {
            this.longArcCaps.put(ai, new Double(cap));
        }

        private double getArcCap(ArcInst ai) {
            Double d = this.longArcCaps.get(ai);
            return d;
        }

        private static class NetInfo
        implements Comparable {
            private String netName = "unassigned";
            private double cap = 0.0;
            private TreeSet<PortInst> joinedPorts = new TreeSet(SegmentedNets.access$2000());

            private NetInfo() {
            }

            public int compareTo(Object obj) {
                NetInfo that = (NetInfo)obj;
                if (this.joinedPorts.isEmpty()) {
                    return that.joinedPorts.isEmpty() ? 0 : -1;
                }
                if (that.joinedPorts.isEmpty()) {
                    return 1;
                }
                return PORT_INST_COMPARATOR.compare(this.joinedPorts.first(), that.joinedPorts.first());
            }
        }
    }

    private static class SpiceFinishedListener
    implements Exec.FinishedListener {
        private Cell cell;
        private FileType type;
        private String file;

        private SpiceFinishedListener(Cell cell, FileType type, String file) {
            this.cell = cell;
            this.type = type;
            this.file = file;
        }

        public void processFinished(Exec.FinishedEvent e) {
            URL fileURL = TextUtils.makeURLToFile(this.file);
            WaveformWindow ww = WaveformWindow.findWaveformWindow(this.cell);
            Simulate.plotSimulationResults(this.type, this.cell, fileURL, ww);
        }
    }

    private static class SpiceNet {
        Network network;
        PolyMerge merge;
        double diffArea;
        double diffPerim;
        float nonDiffCapacitance;
        int transistorCount;

        private SpiceNet() {
        }
    }
}

