/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.Main;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;

public class Progress {
    private JProgressBar progressBar;
    private JTextArea taskOutput;
    private JFrame jf;
    private JInternalFrame jif;
    private static int xPos = 300;
    private static int yPos = 300;

    public Progress(String title) {
        if (TopLevel.isMDIMode()) {
            this.jif = new JInternalFrame(title);
            this.jif.setSize(300, 80);
            this.jif.setLocation(xPos, yPos);
            this.jif.setLayer(JLayeredPane.POPUP_LAYER);
        } else {
            this.jf = new JFrame(title);
            this.jf.setSize(300, 80);
            this.jf.setLocation(xPos, yPos);
        }
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.taskOutput = new JTextArea();
        this.taskOutput.setMargin(new Insets(5, 5, 5, 5));
        this.taskOutput.setEditable(false);
        this.taskOutput.setCursor(null);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.progressBar, "Center");
        panel.add((Component)this.taskOutput, "South");
        if (TopLevel.isMDIMode()) {
            this.jif.getContentPane().add(panel);
            TopLevel.addToDesktop(this.jif);
        } else {
            this.jf.getContentPane().add(panel);
            if (!Main.BATCHMODE) {
                this.jf.setVisible(true);
            }
        }
    }

    public void close() {
        if (TopLevel.isMDIMode()) {
            Point pt = this.jif.getLocation();
            xPos = pt.x;
            yPos = pt.y;
            this.jif.dispose();
        } else {
            Point pt = this.jf.getLocation();
            xPos = pt.x;
            yPos = pt.y;
            this.jf.dispose();
        }
    }

    public void setProgress(int progress) {
        if (progress < 0) {
            progress = 0;
        }
        if (progress > 100) {
            progress = 100;
        }
        this.progressBar.setValue(progress);
    }

    public int getProgress() {
        return this.progressBar.getValue();
    }

    public void setNote(String note) {
        this.taskOutput.setText(note);
    }

    public String getNote() {
        return this.taskOutput.getText();
    }
}

