/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.logicaleffort;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.logicaleffort.CachedCell;
import com.sun.electric.tool.logicaleffort.LENetlister;
import com.sun.electric.tool.logicaleffort.LENetwork;
import com.sun.electric.tool.logicaleffort.LENodable;
import com.sun.electric.tool.logicaleffort.LEPin;
import com.sun.electric.tool.logicaleffort.LESizer;
import com.sun.electric.tool.logicaleffort.LESizer2;
import com.sun.electric.tool.logicaleffort.LETool;
import com.sun.electric.tool.user.ErrorLogger;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LENetlister2
extends LENetlister {
    protected LENetlister.NetlisterConstants constants;
    private Map cellMap;
    private Map globalNetworks;
    private List sizableLENodables;
    private List allLENodables;
    private Map nodablesDefinitions;
    private LESizer2 sizer;
    private Job job;
    private PrintStream out;
    private boolean aborted;
    private ErrorLogger errorLogger;
    private HashMap lePortError;
    private Cell topLevelCell;
    private boolean disableCaching = true;
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_FIRSTPASS = false;
    private static final boolean DEBUG_PRINTCACHEDCELLS = false;

    public LENetlister2(Job job) {
        Tool leTool = Tool.findTool("logical effort");
        this.constants = null;
        this.topLevelCell = null;
        this.job = job;
        this.cellMap = new HashMap();
        this.globalNetworks = new HashMap();
        this.sizableLENodables = new ArrayList();
        this.allLENodables = new ArrayList();
        this.nodablesDefinitions = new HashMap();
        this.lePortError = new HashMap();
        this.out = new PrintStream(System.out);
        this.errorLogger = null;
        this.aborted = false;
    }

    public boolean netlist(Cell cell, VarContext context, boolean useCaching) {
        boolean bl = this.disableCaching = !useCaching;
        if (this.errorLogger != null) {
            this.errorLogger.delete();
        }
        this.errorLogger = ErrorLogger.newInstance("LE Netlister");
        Netlist netlist = cell.getNetlist(true);
        this.constants = this.getSettings(cell);
        if (this.constants == null) {
            this.constants = new LENetlister.NetlisterConstants();
            if (!this.saveSettings(this.constants, cell)) {
                return false;
            }
        }
        this.topLevelCell = cell;
        FirstPassEnum firstPass = new FirstPassEnum(this);
        HierarchyEnumerator.enumerateCell(cell, context, netlist, firstPass);
        firstPass.cleanup(this.disableCaching);
        System.out.println("Cached " + this.cellMap.size() + " cells");
        HierarchyEnumerator.enumerateCell(cell, context, netlist, this);
        return !this.aborted;
    }

    public boolean size(LESizer.Alg algorithm) {
        boolean verbose = false;
        this.sizer = new LESizer2(algorithm, this, this.job, this.errorLogger);
        boolean success = this.sizer.optimizeLoops(this.constants.epsilon, this.constants.maxIterations, verbose, this.constants.alpha, this.constants.keeperRatio);
        this.sizer = null;
        return success;
    }

    public void updateSizes() {
        Iterator cit = this.getSizeableNodables();
        while (cit.hasNext()) {
            LENodable leno = (LENodable)cit.next();
            Nodable no = leno.getNodable();
            NodeInst ni = no.getNodeInst();
            if (ni != null) {
                no = ni;
            }
            if (!leno.isLeGate()) continue;
            String varName = "LEDRIVE_" + leno.getName();
            this.topLevelCell.newVar(varName, (Object)new Float(leno.leX));
            if (!(leno.leX < 1.0f)) continue;
            String msg = "WARNING: Instance " + ni + " has size " + TextUtils.formatDouble(leno.leX, 3) + " less than 1 (" + leno.getName() + ")";
            System.out.println(msg);
            if (ni == null) continue;
            ErrorLogger.MessageLog log = this.errorLogger.logWarning(msg, ni.getParent(), 2);
            log.addGeom(ni, true, ni.getParent(), leno.context);
        }
        this.printStatistics();
        this.done();
    }

    public void done() {
        this.errorLogger.termLogging(true);
        this.errorLogger = null;
    }

    public ErrorLogger getErrorLogger() {
        return this.errorLogger;
    }

    public LENetlister.NetlisterConstants getConstants() {
        return this.constants;
    }

    protected Iterator getSizeableNodables() {
        return this.sizableLENodables.iterator();
    }

    protected float getGlobalSU() {
        return this.constants.su;
    }

    protected LESizer2 getSizer() {
        return this.sizer;
    }

    protected float getKeeperRatio() {
        return this.constants.keeperRatio;
    }

    private LENetwork getNetwork(int globalID, HierarchyEnumerator.CellInfo info) {
        LENetwork net = (LENetwork)this.globalNetworks.get(new Integer(globalID));
        if (net == null) {
            String name = info == null ? null : info.getUniqueNetName(globalID, ".");
            net = new LENetwork(name);
            this.globalNetworks.put(new Integer(globalID), net);
        }
        return net;
    }

    public HierarchyEnumerator.CellInfo newCellInfo() {
        return new LECellInfo();
    }

    public boolean enterCell(HierarchyEnumerator.CellInfo info) {
        if (this.aborted) {
            return false;
        }
        if (((LETool.AnalyzeCell)this.job).checkAbort(null)) {
            this.aborted = true;
            return false;
        }
        LECellInfo leinfo = (LECellInfo)info;
        leinfo.leInit(this.constants);
        if (this.topLevelCell != info.getCell() && this.isSettingsConflict(leinfo.getSettings(), this.topLevelCell, info.getContext(), info.getCell())) {
            this.aborted = true;
            return false;
        }
        boolean enter = true;
        CachedCell cachedCell = (CachedCell)this.cellMap.get(info.getCell());
        if (cachedCell != null && leinfo.getMFactor() == 1.0f) {
            Iterator it = cachedCell.getLocalNetworks().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Network jnet = (Network)entry.getKey();
                LENetwork subnet = (LENetwork)entry.getValue();
                int globalID = info.getNetID(jnet);
                LENetwork net = this.getNetwork(globalID, info);
                if (net == null) continue;
                net.add(subnet);
            }
            enter = false;
        }
        return enter;
    }

    public boolean visitNodeInst(Nodable ni, HierarchyEnumerator.CellInfo info) {
        LENodable uniqueLeno;
        LECellInfo leinfo = (LECellInfo)info;
        LENodable def = (LENodable)this.nodablesDefinitions.get(ni);
        if (def == null) {
            return true;
        }
        LENetwork outputNet = null;
        if (def.isLeGate()) {
            Network outNet = def.getOutputNet();
            int globalID = info.getNetID(outNet);
            outputNet = this.getNetwork(globalID, info);
        }
        float localsu = this.constants.su;
        if (leinfo.getSU() != -1.0f) {
            localsu = leinfo.getSU();
        }
        if ((uniqueLeno = def.createUniqueInstance(info.getContext(), outputNet, leinfo.getMFactor(), localsu, this.constants)).isLeGate()) {
            this.sizableLENodables.add(uniqueLeno);
        }
        this.allLENodables.add(uniqueLeno);
        Iterator pit = uniqueLeno.getPins().iterator();
        while (pit.hasNext()) {
            LEPin pin = (LEPin)pit.next();
            int globalID = info.getNetID(pin.getNetwork());
            LENetwork net = this.getNetwork(globalID, info);
            net.add(pin);
        }
        return false;
    }

    public void doneVisitNodeInst(Nodable ni, HierarchyEnumerator.CellInfo info) {
    }

    public void exitCell(HierarchyEnumerator.CellInfo info) {
    }

    private LENodable.Type getType(Nodable ni, HierarchyEnumerator.CellInfo info) {
        Variable var = null;
        var = ni.getParameter("ATTR_LEGATE");
        if (var != null) {
            int gate = VarContext.objectToInt(info.getContext().evalVar(var), 1);
            if (gate == 1) {
                return LENodable.Type.LEGATE;
            }
        } else {
            var = ni.getParameter("ATTR_LEKEEPER");
            if (var != null) {
                int gate = VarContext.objectToInt(info.getContext().evalVar(var), 1);
                if (gate == 1) {
                    return LENodable.Type.LEKEEPER;
                }
            } else {
                int ignore;
                if (ni.getParameter("ATTR_LEWIRE") != null) {
                    return LENodable.Type.WIRE;
                }
                if (ni.getProto() != null && ni.getProto().getFunction().isTransistor()) {
                    return LENodable.Type.TRANSISTOR;
                }
                if (ni.getProto() != null && ni.getProto().getFunction() == PrimitiveNode.Function.CAPAC) {
                    return LENodable.Type.CAPACITOR;
                }
                var = ni.getVar("ATTR_LEIGNORE");
                if (var != null ? (ignore = VarContext.objectToInt(info.getContext().evalVar(var), 1)) == 1 : (var = ni.getParameter("ATTR_LEIGNORE")) != null && (ignore = VarContext.objectToInt(info.getContext().evalVar(var), 1)) == 1) {
                    return LENodable.Type.IGNORE;
                }
            }
        }
        return null;
    }

    private LENodable createLENodable(LENodable.Type type, Nodable ni, HierarchyEnumerator.CellInfo info) {
        if (type == null) {
            return null;
        }
        Variable var = null;
        LENodable lenodable = new LENodable(ni, type, LETool.getMFactor(ni), ni.getParameter("ATTR_su"), ni.getParameter("ATTR_LEPARALLGRP"));
        Network outputNet = null;
        Netlist netlist = info.getNetlist();
        Iterator ppIt = ni.getProto().getPorts();
        while (ppIt.hasNext()) {
            PortProto pp = (PortProto)ppIt.next();
            float le = this.getLE(ni, type, pp, info);
            Network jnet = netlist.getNetwork(ni, pp, 0);
            LEPin.Dir dir = LEPin.Dir.INPUT;
            if (pp.getCharacteristic() == PortCharacteristic.OUT) {
                dir = LEPin.Dir.OUTPUT;
                if ((type == LENodable.Type.LEGATE || type == LENodable.Type.LEKEEPER) && outputNet != null) {
                    System.out.println("Error: Sizable gate " + ni.getNodeInst() + " has more than one output port!! Ignoring Gate");
                    return null;
                }
                outputNet = jnet;
                lenodable.setOutputNet(jnet);
            }
            if (type == LENodable.Type.TRANSISTOR) {
                if (pp.getCharacteristic() == PortCharacteristic.BIDIR) {
                    dir = LEPin.Dir.OUTPUT;
                }
                if (dir == LEPin.Dir.INPUT) {
                    float length;
                    var = ni.getVar(Schematics.ATTR_LENGTH);
                    if (var == null) {
                        System.out.println("Error: transistor " + ni.getName() + " has no length in Cell " + ni.getParent());
                    }
                    if ((length = VarContext.objectToFloat(info.getContext().evalVar(var), 2.0f)) != 2.0f) {
                        le = le * length / 2.0f;
                    }
                }
            }
            lenodable.addPort(pp.getName(), dir, le, jnet);
            if (type != LENodable.Type.WIRE) continue;
            break;
        }
        return lenodable;
    }

    private float getLE(Nodable ni, LENodable.Type type, PortProto pp, HierarchyEnumerator.CellInfo info) {
        Cell cell;
        Export exp;
        boolean leFound = false;
        float le = 1.0f;
        if (!(pp instanceof Export)) {
            return le;
        }
        Variable var = ((Export)pp).getVar("ATTR_le");
        if (var != null) {
            leFound = true;
            le = VarContext.objectToFloat(info.getContext().evalVar(var), 1.0f);
        } else if (pp.getCharacteristic() == PortCharacteristic.OUT && (type == LENodable.Type.LEGATE || type == LENodable.Type.LEKEEPER)) {
            float diff = 0.0f;
            var = ((Export)pp).getVar("ATTR_diffn");
            if (var != null) {
                diff += VarContext.objectToFloat(info.getContext().evalVar(var), 0.0f);
                leFound = true;
            }
            if ((var = ((Export)pp).getVar("ATTR_diffp")) != null) {
                diff += VarContext.objectToFloat(info.getContext().evalVar(var), 0.0f);
                leFound = true;
            }
            le = diff / 3.0f;
        }
        if (!(leFound || type != LENodable.Type.LEGATE && type != LENodable.Type.LEKEEPER || (exp = (cell = (Cell)ni.getProto()).findExport(pp.getName())) == null || this.lePortError.get(exp) != null)) {
            String msg = "Warning: Sizeable gate has no logical effort specified for port " + pp.getName() + " in " + cell;
            System.out.println(msg);
            ErrorLogger.MessageLog log = this.errorLogger.logWarning(msg, cell, 0);
            log.addExport(exp, true, cell, info.getContext().push(ni));
            this.lePortError.put(exp, exp);
        }
        return le;
    }

    public void printStatistics() {
        float totalsize = 0.0f;
        float instsize = 0.0f;
        int numLEGates = 0;
        int numLEWires = 0;
        Iterator cit = this.allLENodables.iterator();
        while (cit.hasNext()) {
            LENodable leno = (LENodable)cit.next();
            if (leno.isLeGate()) {
                ++numLEGates;
                instsize += leno.leX;
            }
            if (leno.getType() == LENodable.Type.WIRE) {
                ++numLEWires;
            }
            totalsize += leno.leX;
        }
        System.out.println("Number of LEGATEs: " + numLEGates);
        System.out.println("Total size of all LEGATEs: " + instsize);
    }

    public float getTotalLESize() {
        float instsize = 0.0f;
        Iterator cit = this.allLENodables.iterator();
        while (cit.hasNext()) {
            LENodable leno = (LENodable)cit.next();
            if (!leno.isLeGate()) continue;
            instsize += leno.leX;
        }
        return instsize;
    }

    public boolean printResults(Nodable no, VarContext context) {
        LEPin pin;
        if (no instanceof NodeInst) {
            no = Netlist.getNodableFor((NodeInst)no, 0);
        }
        LENodable leno = null;
        Iterator it = this.allLENodables.iterator();
        while (it.hasNext()) {
            LENodable aleno = (LENodable)it.next();
            if (aleno.getNodable() != no || !aleno.context.getInstPath(".").equals(context.getInstPath("."))) continue;
            leno = aleno;
            break;
        }
        if (leno == null) {
            return false;
        }
        System.out.println("Netlister: Gate Cap=" + this.constants.gateCap + ", Alpha=" + this.constants.alpha);
        leno.print();
        LENetwork outputNet = leno.outputNetwork;
        ArrayList<LEPin> gatesDrivenPins = new ArrayList<LEPin>();
        ArrayList<LEPin> loadsDrivenPins = new ArrayList<LEPin>();
        ArrayList<LEPin> wiresDrivenPins = new ArrayList<LEPin>();
        ArrayList<LEPin> gatesFightingPins = new ArrayList<LEPin>();
        if (outputNet == null) {
            return false;
        }
        Iterator it2 = outputNet.getAllPins().iterator();
        while (it2.hasNext()) {
            LEPin pin2 = (LEPin)it2.next();
            LENodable loopLeno = pin2.getInstance();
            if (pin2.getDir() == LEPin.Dir.INPUT) {
                if (loopLeno.isGate()) {
                    gatesDrivenPins.add(pin2);
                }
                if (loopLeno.getType() == LENodable.Type.LOAD) {
                    loadsDrivenPins.add(pin2);
                }
                if (loopLeno.getType() == LENodable.Type.TRANSISTOR) {
                    loadsDrivenPins.add(pin2);
                }
                if (loopLeno.getType() == LENodable.Type.CAPACITOR) {
                    loadsDrivenPins.add(pin2);
                }
                if (loopLeno.getType() == LENodable.Type.WIRE) {
                    wiresDrivenPins.add(pin2);
                }
            }
            if (pin2.getDir() != LEPin.Dir.OUTPUT) continue;
            if (loopLeno.isGate()) {
                gatesFightingPins.add(pin2);
            }
            if (loopLeno.getType() != LENodable.Type.TRANSISTOR) continue;
            loadsDrivenPins.add(pin2);
        }
        System.out.println("Note: Load = Size * LE * M");
        System.out.println("Note: Load = Size * LE * M * Alpha, for Gates Fighting");
        float totalLoad = 0.0f;
        System.out.println("  -------------------- Gates Driven (" + gatesDrivenPins.size() + ") --------------------");
        Iterator it3 = gatesDrivenPins.iterator();
        while (it3.hasNext()) {
            pin = (LEPin)it3.next();
            totalLoad += pin.getInstance().printLoadInfo(pin, this.constants.alpha);
        }
        System.out.println("  -------------------- Loads Driven (" + loadsDrivenPins.size() + ") --------------------");
        it3 = loadsDrivenPins.iterator();
        while (it3.hasNext()) {
            pin = (LEPin)it3.next();
            totalLoad += pin.getInstance().printLoadInfo(pin, this.constants.alpha);
        }
        System.out.println("  -------------------- Wires Driven (" + wiresDrivenPins.size() + ") --------------------");
        it3 = wiresDrivenPins.iterator();
        while (it3.hasNext()) {
            pin = (LEPin)it3.next();
            totalLoad += pin.getInstance().printLoadInfo(pin, this.constants.alpha);
        }
        System.out.println("  -------------------- Gates Fighting (" + gatesFightingPins.size() + ") --------------------");
        it3 = gatesFightingPins.iterator();
        while (it3.hasNext()) {
            pin = (LEPin)it3.next();
            totalLoad += pin.getInstance().printLoadInfo(pin, this.constants.alpha);
        }
        System.out.println("*** Total Load: " + TextUtils.formatDouble(totalLoad, 2));
        return true;
    }

    public static void test1() {
        LESizer.test1();
    }

    public static class LECellInfo
    extends LENetlister.LECellInfo {
        private CachedCell cachedCell;

        protected void setCachedCell(CachedCell c) {
            this.cachedCell = c;
        }

        protected CachedCell getCachedCell() {
            return this.cachedCell;
        }
    }

    private static class FirstPassEnum
    extends HierarchyEnumerator.Visitor {
        private LENetlister2 netlister;

        private FirstPassEnum(LENetlister2 netlister) {
            this.netlister = netlister;
        }

        public HierarchyEnumerator.CellInfo newCellInfo() {
            return new LECellInfo();
        }

        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            if (this.netlister.aborted) {
                return false;
            }
            if (((LETool.AnalyzeCell)this.netlister.job).checkAbort(null)) {
                this.netlister.aborted = true;
                return false;
            }
            CachedCell cachedCell = (CachedCell)this.netlister.cellMap.get(info.getCell());
            if (cachedCell == null) {
                cachedCell = new CachedCell(info.getCell(), info.getNetlist());
                this.netlister.cellMap.put(info.getCell(), cachedCell);
                return true;
            }
            HierarchyEnumerator.CellInfo parentInfo = info.getParentInfo();
            if (parentInfo != null) {
                Cell parent = info.getParentInfo().getCell();
                CachedCell parentCached = (CachedCell)this.netlister.cellMap.get(parent);
                Nodable no = info.getParentInst();
                parentCached.add(no, (LECellInfo)info.getParentInfo(), cachedCell, (LECellInfo)info, this.netlister.constants);
            }
            return false;
        }

        public boolean visitNodeInst(Nodable ni, HierarchyEnumerator.CellInfo info) {
            LENodable.Type type;
            CachedCell cachedCell = (CachedCell)this.netlister.cellMap.get(info.getCell());
            if (!(ni.getNodeInst().getProto() instanceof PrimitiveNode)) {
                // empty if block
            }
            if ((type = this.netlister.getType(ni, info)) == null) {
                return true;
            }
            if (type == LENodable.Type.IGNORE) {
                return false;
            }
            LENodable leno = this.netlister.createLENodable(type, ni, info);
            if (leno == null) {
                return true;
            }
            cachedCell.add(ni, leno);
            this.netlister.nodablesDefinitions.put(ni, leno);
            return false;
        }

        public void exitCell(HierarchyEnumerator.CellInfo info) {
            CachedCell cachedCell = (CachedCell)this.netlister.cellMap.get(info.getCell());
            HierarchyEnumerator.CellInfo parentInfo = info.getParentInfo();
            if (parentInfo != null) {
                Cell parent = info.getParentInfo().getCell();
                CachedCell parentCached = (CachedCell)this.netlister.cellMap.get(parent);
                Nodable no = info.getParentInst();
                parentCached.add(no, (LECellInfo)info.getParentInfo(), cachedCell, (LECellInfo)info, this.netlister.constants);
            }
        }

        protected void cleanup(boolean disableCaching) {
            HashMap<Cell, CachedCell> cachedMap = new HashMap<Cell, CachedCell>();
            Iterator it = this.netlister.cellMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Cell cell = (Cell)entry.getKey();
                CachedCell cachedCell = (CachedCell)entry.getValue();
                if (!cachedCell.isContextFree(this.netlister.constants)) continue;
                cachedMap.put(cell, cachedCell);
            }
            this.netlister.cellMap = cachedMap;
            if (disableCaching) {
                this.netlister.cellMap = new HashMap();
            }
        }
    }
}

