/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.CIF;
import com.sun.electric.tool.io.input.DEF;
import com.sun.electric.tool.io.input.DXF;
import com.sun.electric.tool.io.input.EDIF;
import com.sun.electric.tool.io.input.ELIB;
import com.sun.electric.tool.io.input.GDS;
import com.sun.electric.tool.io.input.JELIB;
import com.sun.electric.tool.io.input.LEF;
import com.sun.electric.tool.io.input.LibDirs;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.io.input.ReadableDump;
import com.sun.electric.tool.io.input.Sue;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.dialogs.Progress;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.net.URLConnection;

public class Input {
    protected static final int READ_BUFFER_SIZE = 65536;
    public static final Variable.Key IO_TRUE_LIBRARY = ElectricObject.newKey("IO_true_library");
    public static final Variable.Key IO_DUMMY_OBJECT = ElectricObject.newKey("IO_dummy_object");
    public static ErrorLogger errorLogger;
    protected String filePath;
    protected Library lib;
    protected InputStream inputStream;
    protected LineNumberReader lineReader;
    protected DataInputStream dataInputStream;
    protected long fileLength;
    protected static Progress progress;
    protected static String mainLibDirectory;
    protected boolean topLevelLibrary;
    protected int byteCount;

    Input() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Library readLibrary(URL fileURL, String libName, FileType type, boolean quick) {
        if (fileURL == null) {
            return null;
        }
        long startTime = System.currentTimeMillis();
        errorLogger = ErrorLogger.newInstance("Library Read");
        File f = new File(fileURL.getPath());
        if (f != null && f.exists()) {
            LibDirs.readLibDirs(f.getParent());
        }
        LibraryFiles.initializeLibraryInput();
        Library lib = null;
        boolean formerQuiet = Undo.changesQuiet(true);
        try {
            Input.startProgressDialog("library", fileURL.getFile());
            Cell.setAllowCircularLibraryDependences(true);
            Pref.initMeaningVariableGathering();
            StringBuffer errmsg = new StringBuffer();
            boolean exists = TextUtils.URLExists(fileURL, errmsg);
            if (!exists) {
                System.out.print(errmsg.toString());
                String fileName = fileURL.toString();
                if (fileName.indexOf(".") == -1) {
                    fileURL = TextUtils.makeURLToFile(fileName + "." + type.getExtensions()[0]);
                    System.out.print("Attempting to open " + fileURL + "\n");
                    errmsg.setLength(0);
                    exists = TextUtils.URLExists(fileURL, errmsg);
                    if (!exists) {
                        System.out.print(errmsg.toString());
                    }
                }
            }
            if (exists) {
                if (libName == null) {
                    libName = TextUtils.getFileNameWithoutExtension(fileURL);
                }
                lib = Input.readALibrary(fileURL, null, libName, type);
            }
            LibraryFiles.cleanupLibraryInput();
        }
        finally {
            Input.stopProgressDialog();
            Cell.setAllowCircularLibraryDependences(false);
        }
        Undo.changesQuiet(formerQuiet);
        if (lib != null && !quick) {
            long endTime = System.currentTimeMillis();
            float finalTime = (float)(endTime - startTime) / 1000.0f;
            System.out.println("Library " + fileURL.getFile() + " read, took " + finalTime + " seconds");
            Pref.reconcileMeaningVariables(lib.getName());
        }
        errorLogger.termLogging(true);
        return lib;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Library importLibrary(URL fileURL, FileType type) {
        if (fileURL == null) {
            return null;
        }
        StringBuffer errmsg = new StringBuffer();
        if (!TextUtils.URLExists(fileURL, errmsg)) {
            System.out.print(errmsg.toString());
            return null;
        }
        String libName = TextUtils.getFileNameWithoutExtension(fileURL);
        Library lib = Library.newInstance(libName, fileURL);
        lib.setChangedMajor();
        long startTime = System.currentTimeMillis();
        errorLogger = ErrorLogger.newInstance("File Import");
        File f = new File(fileURL.getPath());
        if (f != null && f.exists()) {
            LibDirs.readLibDirs(f.getParent());
        }
        boolean formerQuiet = Undo.changesQuiet(true);
        try {
            Input in;
            Input.startProgressDialog("import", fileURL.getFile());
            if (type == FileType.CIF) {
                in = new CIF();
                if (in.openTextInput(fileURL)) {
                    Library library = null;
                    return library;
                }
            } else if (type == FileType.DEF) {
                in = new DEF();
                if (in.openTextInput(fileURL)) {
                    Library library = null;
                    return library;
                }
            } else if (type == FileType.DXF) {
                in = new DXF();
                if (in.openTextInput(fileURL)) {
                    Library library = null;
                    return library;
                }
            } else if (type == FileType.EDIF) {
                in = new EDIF();
                if (in.openTextInput(fileURL)) {
                    Library library = null;
                    return library;
                }
            } else if (type == FileType.GDS) {
                in = new GDS();
                if (in.openBinaryInput(fileURL)) {
                    Library library = null;
                    return library;
                }
            } else if (type == FileType.LEF) {
                in = new LEF();
                if (in.openTextInput(fileURL)) {
                    Library library = null;
                    return library;
                }
            } else if (type == FileType.SUE) {
                in = new Sue();
                if (in.openTextInput(fileURL)) {
                    Library library = null;
                    return library;
                }
            } else {
                System.out.println("Unsupported input format");
                Library library = null;
                return library;
            }
            in.importALibrary(lib);
            in.closeInput();
        }
        finally {
            Input.stopProgressDialog();
            errorLogger.termLogging(true);
        }
        Undo.changesQuiet(formerQuiet);
        if (lib == null) {
            System.out.println("Error importing " + lib);
        } else {
            long endTime = System.currentTimeMillis();
            float finalTime = (float)(endTime - startTime) / 1000.0f;
            System.out.println("Library " + fileURL.getFile() + " read, took " + finalTime + " seconds");
        }
        return lib;
    }

    protected boolean importALibrary(Library lib) {
        return true;
    }

    protected static Library readALibrary(URL fileURL, Library lib, String libName, FileType type) {
        LibraryFiles in;
        if (type == FileType.ELIB) {
            in = new ELIB();
            if (in.openBinaryInput(fileURL)) {
                return null;
            }
        } else if (type == FileType.JELIB) {
            in = new JELIB();
            if (in.openTextInput(fileURL)) {
                return null;
            }
        } else if (type == FileType.READABLEDUMP) {
            in = new ReadableDump();
            if (in.openTextInput(fileURL)) {
                return null;
            }
        } else {
            System.out.println("Unknown import type: " + type);
            return null;
        }
        in.topLevelLibrary = false;
        if (lib == null) {
            mainLibDirectory = TextUtils.getFilePath(fileURL);
            in.topLevelLibrary = true;
        }
        if (lib == null) {
            lib = Library.newInstance(libName, fileURL);
        }
        in.lib = lib;
        boolean error = in.readInputLibrary();
        in.closeInput();
        if (error) {
            System.out.println("Error reading " + lib);
            if (in.topLevelLibrary) {
                mainLibDirectory = null;
            }
            return null;
        }
        return in.lib;
    }

    protected boolean openBinaryInput(URL fileURL) {
        this.filePath = fileURL.getFile();
        URLConnection urlCon = null;
        try {
            urlCon = fileURL.openConnection();
            this.fileLength = urlCon.getContentLength();
            this.inputStream = urlCon.getInputStream();
        }
        catch (IOException e) {
            System.out.println("Could not find file: " + this.filePath);
            return true;
        }
        this.byteCount = 0;
        BufferedInputStream bufStrm = new BufferedInputStream(this.inputStream, 65536);
        this.dataInputStream = new DataInputStream(bufStrm);
        return false;
    }

    protected boolean openTextInput(URL fileURL) {
        if (this.openBinaryInput(fileURL)) {
            return true;
        }
        InputStreamReader is = new InputStreamReader(this.inputStream);
        this.lineReader = new LineNumberReader(is);
        return false;
    }

    protected static void startProgressDialog(String type, String filePath) {
        progress = new Progress("Reading " + type + " " + filePath + "...");
        progress.setProgress(0);
    }

    protected static void stopProgressDialog() {
        progress.close();
        progress = null;
    }

    protected void updateProgressDialog(int bytesRead) {
        this.byteCount += bytesRead;
        if (progress != null && this.fileLength > 0L) {
            long pct = (long)this.byteCount * 100L / this.fileLength;
            progress.setProgress((int)pct);
        }
    }

    protected void closeInput() {
        if (this.inputStream == null) {
            return;
        }
        try {
            this.inputStream.close();
        }
        catch (IOException e) {
            System.out.println("Error closing file");
        }
        this.inputStream = null;
        this.dataInputStream = null;
        this.lineReader = null;
    }

    protected String getLine() throws IOException {
        StringBuffer sb = new StringBuffer();
        while (true) {
            int c;
            if ((c = this.lineReader.read()) == -1) {
                return null;
            }
            if (c == 10) break;
            sb.append((char)c);
        }
        return sb.toString();
    }

    protected String getLineFromBinary() throws IOException {
        StringBuffer sb = new StringBuffer();
        while (true) {
            int c;
            if ((c = this.dataInputStream.read()) == -1) {
                return null;
            }
            if (c == 10 || c == 13) break;
            sb.append((char)c);
        }
        return sb.toString();
    }

    static {
        progress = null;
        mainLibDirectory = null;
    }
}

