/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.hierarchy;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.NodeUsage;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.generator.layout.LayoutLib;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class HierarchyEnumerator {
    private Visitor visitor;
    private boolean caching;
    private int cellCnt = 0;
    private int instCnt = 0;
    private Global.Set rootGlobals;
    private int[] globalToNetID;
    private List netIdToNetDesc = new ArrayList();
    private int largestGlobalNetID = -1;

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    private HierarchyEnumerator() {
    }

    private int nextNetID() {
        return this.netIdToNetDesc.size();
    }

    private int[] numberNets(Cell cell, Netlist netlist, int[][] portNdxToNetIDs, CellInfo info) {
        int i;
        int numNets = netlist.getNumNetworks();
        int[] netNdxToNetID = new int[numNets];
        Arrays.fill(netNdxToNetID, -1);
        Global.Set globals = netlist.getGlobals();
        for (i = 0; i < globals.size(); ++i) {
            Global global = globals.get(i);
            int netIndex = netlist.getNetwork(global).getNetIndex();
            int globalIndex = this.rootGlobals.indexOf(global);
            netNdxToNetID[netIndex] = this.globalToNetID[globalIndex];
        }
        for (i = 0; i < portNdxToNetIDs.length; ++i) {
            Export export = (Export)cell.getPort(i);
            int[] ids = portNdxToNetIDs[i];
            for (int j = 0; j < ids.length; ++j) {
                int netIndex = netlist.getNetwork(export, j).getNetIndex();
                netNdxToNetID[netIndex] = ids[j];
            }
        }
        for (i = 0; i < numNets; ++i) {
            Network net = netlist.getNetwork(i);
            if (netNdxToNetID[i] >= 0) continue;
            int netID = this.nextNetID();
            this.netIdToNetDesc.add(new NetDescription(net, info));
            netNdxToNetID[i] = netID;
        }
        return netNdxToNetID;
    }

    private static int[] getPortNetIDs(Nodable no, PortProto pp, Netlist netlist, int[] netNdxToNetID) {
        int busWidth = pp.getNameKey().busWidth();
        int[] netIDs = new int[busWidth];
        for (int j = 0; j < busWidth; ++j) {
            int netIndex = netlist.getNetwork(no, pp, j).getNetIndex();
            int netID = netNdxToNetID[netIndex];
            HierarchyEnumerator.error(netID < 0, "no netID for net");
            netIDs[j] = netID;
        }
        return netIDs;
    }

    private int[][] buildPortMap(Netlist netlist, Nodable ni, int[] netNdxToNetID) {
        Cell cell = (Cell)ni.getProto();
        int numPorts = cell.getNumPorts();
        int[][] portNdxToNetIDs = new int[numPorts][];
        for (int i = 0; i < numPorts; ++i) {
            PortProto pp = cell.getPort(i);
            portNdxToNetIDs[i] = HierarchyEnumerator.getPortNetIDs(ni, pp, netlist, netNdxToNetID);
        }
        return portNdxToNetIDs;
    }

    private void allocateGlobalNetIDs(CellInfo rootInfo, Netlist rootNetlist) {
        HierarchyEnumerator.error(this.globalToNetID != null, "already initialized?");
        this.globalToNetID = new int[this.rootGlobals.size()];
        for (int i = 0; i < this.rootGlobals.size(); ++i) {
            int netIndex;
            Global global = this.rootGlobals.get(i);
            HierarchyEnumerator.error(this.rootGlobals.indexOf(global) != i, "bad index?");
            Network net = rootNetlist.getNetwork(global);
            this.globalToNetID[i] = netIndex = net.getNetIndex();
            if (netIndex == this.nextNetID()) {
                this.netIdToNetDesc.add(new NetDescription(net, rootInfo));
                continue;
            }
            HierarchyEnumerator.error(netIndex > this.nextNetID(), "HierarchyEnumerator: unexpected order of global signal " + global);
        }
        this.largestGlobalNetID = this.nextNetID() - 1;
    }

    private void enumerateCell(Nodable parentInst, Cell cell, VarContext context, Netlist netlist, int[][] portNdxToNetIDs, AffineTransform xformToRoot, CellInfo parent) {
        CellInfo info = this.visitor.newCellInfo();
        if (parent == null) {
            this.allocateGlobalNetIDs(info, netlist);
        }
        int firstNetID = this.nextNetID();
        int[] netNdxToNetID = this.numberNets(cell, netlist, portNdxToNetIDs, info);
        int lastNetIDPlusOne = this.nextNetID();
        ++this.cellCnt;
        info.init(parentInst, cell, context, netlist, netNdxToNetID, portNdxToNetIDs, xformToRoot, this.netIdToNetDesc, this.largestGlobalNetID, parent);
        boolean enumInsts = this.visitor.enterCell(info);
        if (!enumInsts) {
            return;
        }
        Iterator it = netlist.getNodables();
        while (it.hasNext()) {
            Nodable ni = (Nodable)it.next();
            ++this.instCnt;
            boolean descend = this.visitor.visitNodeInst(ni, info);
            NodeProto np = ni.getProto();
            if (!descend || !(np instanceof Cell) || ((Cell)np).isIcon()) continue;
            int[][] portNmToNetIDs2 = this.buildPortMap(netlist, ni, netNdxToNetID);
            AffineTransform xformToRoot2 = xformToRoot;
            if (ni instanceof NodeInst) {
                xformToRoot2 = new AffineTransform(xformToRoot);
                xformToRoot2.concatenate(((NodeInst)ni).rotateOut());
                xformToRoot2.concatenate(((NodeInst)ni).translateOut());
            }
            this.enumerateCell(ni, (Cell)np, this.caching ? context.pushCaching(ni) : context.push(ni), netlist.getNetlist(ni), portNmToNetIDs2, xformToRoot2, info);
        }
        this.visitor.exitCell(info);
        context.deleteVariableCache();
        for (int i = firstNetID; i < lastNetIDPlusOne; ++i) {
            this.netIdToNetDesc.set(i, null);
        }
    }

    private void doIt(Cell root, VarContext context, Netlist netlist, Visitor visitor, boolean cache) {
        this.visitor = visitor;
        this.caching = cache;
        if (context == null) {
            context = VarContext.globalContext;
        }
        int[][] exportNdxToNetIDs = new int[][]{};
        this.rootGlobals = netlist.getGlobals();
        this.enumerateCell(null, root, context, netlist, exportNdxToNetIDs, new AffineTransform(), null);
    }

    public static void enumerateCell(Cell root, VarContext context, Netlist netlist, Visitor visitor) {
        HierarchyEnumerator.enumerateCell(root, context, netlist, visitor, false);
    }

    public static void enumerateCell(Cell root, VarContext context, Netlist netlist, Visitor visitor, boolean caching) {
        if (netlist == null) {
            netlist = NetworkTool.getUserNetlist(root);
        }
        new HierarchyEnumerator().doIt(root, context, netlist, visitor, caching);
    }

    public static int getNumUniqueChildCells(Cell cell) {
        HashMap uniqueChildCells = new HashMap();
        HierarchyEnumerator.hierCellsRecurse(cell, uniqueChildCells);
        return uniqueChildCells.size();
    }

    private static void hierCellsRecurse(Cell cell, HashMap uniqueCells) {
        Iterator uit = cell.getUsagesIn();
        while (uit.hasNext()) {
            NodeProto np;
            NodeUsage nu = (NodeUsage)uit.next();
            if (nu.isIcon() || !((np = nu.getProto()) instanceof Cell)) continue;
            uniqueCells.put((Cell)np, (Cell)np);
            HierarchyEnumerator.hierCellsRecurse((Cell)np, uniqueCells);
        }
    }

    public static Network getNetworkInChild(Network parentNet, Nodable childNodable) {
        if (childNodable == null || parentNet == null) {
            return null;
        }
        if (!(childNodable.getProto() instanceof Cell)) {
            return null;
        }
        Cell childCell = (Cell)childNodable.getProto();
        Netlist parentNetlist = parentNet.getNetlist();
        Netlist childNetlist = parentNetlist.getNetlist(childNodable);
        PortProto pp = null;
        int i = 0;
        boolean found = false;
        NodeInst ni = childNodable.getNodeInst();
        Iterator it = ni.getPortInsts();
        while (it.hasNext()) {
            PortInst pi = (PortInst)it.next();
            pp = pi.getPortProto();
            for (i = 0; i < pp.getNameKey().busWidth(); ++i) {
                Network net = parentNetlist.getNetwork(childNodable, pp, i);
                if (net != parentNet) continue;
                found = true;
                break;
            }
            if (!found) continue;
            break;
        }
        if (!found) {
            return null;
        }
        if (childCell.contentsView() != null) {
            childCell = childCell.contentsView();
        }
        Export export = childCell.findExport(pp.getNameKey());
        Network childNet = childNetlist.getNetwork(export, i);
        return childNet;
    }

    public static class CellInfo {
        private Nodable parentInst;
        private Cell cell;
        private VarContext context;
        private Netlist netlist;
        private int[] netNdxToNetID;
        private int[][] exportNdxToNetIDs;
        private AffineTransform xformToRoot;
        private List netIdToNetDesc;
        private int largestGlobalNetID;
        private CellInfo parentInfo;

        void init(Nodable parentInst, Cell cell, VarContext context, Netlist netlist, int[] netToNetID, int[][] exportNdxToNetIDs, AffineTransform xformToRoot, List netIdToNetDesc, int largestGlobalNetID, CellInfo parentInfo) {
            this.parentInst = parentInst;
            this.cell = cell;
            this.context = context;
            this.netlist = netlist;
            this.netNdxToNetID = netToNetID;
            this.exportNdxToNetIDs = exportNdxToNetIDs;
            this.xformToRoot = xformToRoot;
            this.netIdToNetDesc = netIdToNetDesc;
            this.largestGlobalNetID = largestGlobalNetID;
            this.parentInfo = parentInfo;
        }

        private double angleFromXY(double x, double y) {
            double ans = Math.atan2(y, x) * 180.0 / Math.PI;
            return ans;
        }

        private double angle0To360(double a) {
            while (a >= 360.0) {
                a -= 360.0;
            }
            while (a < 0.0) {
                a += 360.0;
            }
            return a;
        }

        public final Cell getCell() {
            return this.cell;
        }

        public final boolean isRootCell() {
            return this.parentInfo == null;
        }

        public final VarContext getContext() {
            return this.context;
        }

        public final Netlist getNetlist() {
            return this.netlist;
        }

        public final CellInfo getParentInfo() {
            return this.parentInfo;
        }

        public final Nodable getParentInst() {
            return this.parentInst;
        }

        public final CellInfo getRootInfo() {
            CellInfo i = this;
            while (i.getParentInfo() != null) {
                i = i.getParentInfo();
            }
            return i;
        }

        public final int[] getExportNetIDs(Export e) {
            if (this.isRootCell()) {
                int width = this.netlist.getBusWidth(e);
                int[] netIDs = new int[width];
                for (int i = 0; i < width; ++i) {
                    netIDs[i] = this.netlist.getNetwork(e, i).getNetIndex();
                }
                return netIDs;
            }
            return this.exportNdxToNetIDs[e.getPortIndex()];
        }

        public final int getNetID(Network net) {
            return this.getNetID(net.getNetIndex());
        }

        private int getNetID(int netIndex) {
            return this.netNdxToNetID[netIndex];
        }

        public final boolean isGlobalNet(int netID) {
            HierarchyEnumerator.error(netID < 0, "negative netIDs are illegal");
            return netID <= this.largestGlobalNetID;
        }

        public final int[] getPortNetIDs(Nodable no, PortProto pp) {
            return HierarchyEnumerator.getPortNetIDs(no, pp, this.netlist, this.netNdxToNetID);
        }

        public final String getUniqueNetName(Network net, String sep) {
            NetNameProxy proxy = this.getUniqueNetNameProxy(net, sep);
            return proxy.toString();
        }

        public final NetNameProxy getUniqueNetNameProxy(Network net, String sep) {
            return this.getUniqueNetNameProxy(this.getNetID(net), sep);
        }

        public final String getUniqueNetName(int netID, String sep) {
            NetNameProxy proxy = this.getUniqueNetNameProxy(netID, sep);
            return proxy.toString();
        }

        public final NetNameProxy getUniqueNetNameProxy(int netID, String sep) {
            NetDescription ns = (NetDescription)this.netIdToNetDesc.get(netID);
            VarContext netContext = ns.getCellInfo().getContext();
            return new NetNameProxy(netContext, sep, ns.getNet());
        }

        public final String getUniqueNodableName(Nodable no, String sep) {
            return this.getUniqueNodableNameProxy(no, sep).toString();
        }

        public final NodableNameProxy getUniqueNodableNameProxy(Nodable no, String sep) {
            return new NodableNameProxy(this.getContext(), sep, no);
        }

        public final NetDescription netIdToNetDescription(int netID) {
            return (NetDescription)this.netIdToNetDesc.get(netID);
        }

        public Network getNetworkInParent(Network network) {
            if (this.parentInfo == null) {
                return null;
            }
            if (network == null) {
                return null;
            }
            if (network.getNetlist() != this.netlist) {
                return null;
            }
            boolean found = false;
            Export export = null;
            int i = 0;
            Iterator it = this.cell.getPorts();
            while (it.hasNext()) {
                export = (Export)it.next();
                for (i = 0; i < export.getNameKey().busWidth(); ++i) {
                    Network net = this.netlist.getNetwork(export, i);
                    if (net != network) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            if (!found) {
                return null;
            }
            Nodable no = this.context.getNodable();
            PortProto pp = no.getProto().findPortProto(export.getNameKey());
            Network parentNet = this.parentInfo.getNetlist().getNetwork(no, pp, i);
            return parentNet;
        }

        public final AffineTransform getPositionInRoot(NodeInst ni) {
            AffineTransform x = new AffineTransform(this.xformToRoot);
            return x;
        }

        public AffineTransform getTransformToRoot() {
            return this.xformToRoot;
        }

        public final Point2D getPositionInRoot(Point2D p) {
            Point2D.Double ans = new Point2D.Double();
            this.xformToRoot.transform(p, ans);
            return ans;
        }

        public final Rectangle2D getBoundsInRoot(Rectangle2D r) {
            double[] coords = new double[]{r.getX(), r.getY(), r.getX(), r.getY() + r.getHeight(), r.getX() + r.getWidth(), r.getY() + r.getHeight(), r.getX() + r.getWidth(), r.getY()};
            this.xformToRoot.transform(coords, 0, coords, 0, 8);
            double minY = Double.MAX_VALUE;
            double minX = Double.MAX_VALUE;
            double maxY = Double.MIN_VALUE;
            double maxX = Double.MIN_VALUE;
            for (int i = 0; i < 8; i += 2) {
                minX = Math.min(minX, coords[i]);
                maxX = Math.max(maxX, coords[i]);
                minY = Math.min(minY, coords[i + 1]);
                maxY = Math.max(maxY, coords[i + 1]);
            }
            return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
        }
    }

    public static class NetDescription {
        private Network net;
        private CellInfo info;

        NetDescription(Network net, CellInfo info) {
            this.net = net;
            this.info = info;
        }

        public Network getNet() {
            return this.net;
        }

        public CellInfo getCellInfo() {
            return this.info;
        }
    }

    public static abstract class Visitor {
        public CellInfo newCellInfo() {
            return new CellInfo();
        }

        public abstract boolean enterCell(CellInfo var1);

        public abstract void exitCell(CellInfo var1);

        public abstract boolean visitNodeInst(Nodable var1, CellInfo var2);
    }

    public static class NodableNameProxy
    extends NameProxy {
        private Nodable nodable;

        public String leafName() {
            return this.nodable.getName();
        }

        public NodableNameProxy(VarContext context, String sep, Nodable node) {
            super(context, sep);
            this.nodable = node;
        }

        public Cell leafCell() {
            return this.nodable.getParent();
        }

        public Nodable getNodable() {
            return this.nodable;
        }
    }

    public static class NetNameProxy
    extends NameProxy {
        private Network net;

        public String leafName() {
            Iterator it = this.net.getNames();
            if (it.hasNext()) {
                return (String)it.next();
            }
            return "netIndex" + this.net.getNetIndex();
        }

        public Iterator leafNames() {
            return this.net.getNames();
        }

        public NetNameProxy(VarContext context, String sep, Network net) {
            super(context, sep);
            this.net = net;
        }

        public Cell leafCell() {
            return this.net.getParent();
        }

        public Network getNet() {
            return this.net;
        }
    }

    public static abstract class NameProxy {
        private VarContext context;
        private String sep;

        private String makePath(VarContext context, String sep) {
            String path = context.getInstPath(sep);
            if (!path.equals("")) {
                path = path + sep;
            }
            return path;
        }

        protected NameProxy(VarContext context, String sep) {
            this.context = context;
            this.sep = sep;
        }

        public abstract String leafName();

        public abstract Cell leafCell();

        public VarContext getContext() {
            return this.context;
        }

        public String toString() {
            return this.makePath(this.context, this.sep) + this.leafName();
        }
    }
}

