/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.Attributes;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GetInfoArc
extends EDialog
implements HighlightListener,
DatabaseChangeListener {
    private static GetInfoArc theDialog = null;
    private static ArcInst shownArc = null;
    private String initialName;
    private double initialWidth;
    private boolean initialEasyToSelect;
    private boolean initialRigid;
    private boolean initialFixedAngle;
    private boolean initialSlidable;
    private boolean initialDirectional;
    private boolean initialEndsExtend;
    private boolean initialSkipHead;
    private boolean initialSkipTail;
    private boolean initialReverseEnds;
    private JLabel angle;
    private JButton apply;
    private JButton attributes;
    private JLabel busSize;
    private JButton cancel;
    private JCheckBox directional;
    private JCheckBox easyToSelect;
    private JCheckBox endsExtend;
    private JCheckBox fixedAngle;
    private JLabel headLoc;
    private JLabel headNode;
    private JButton headSee;
    private JLabel jLabel1;
    private JLabel jLabel11;
    private JLabel jLabel13;
    private JLabel jLabel15;
    private JLabel jLabel17;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField name;
    private JLabel network;
    private JButton ok;
    private JCheckBox reverseEnds;
    private JCheckBox rigid;
    private JCheckBox skipHead;
    private JCheckBox skipTail;
    private JCheckBox slidable;
    private JLabel tailLoc;
    private JLabel tailNode;
    private JButton tailSee;
    private JLabel type;
    private JTextField width;

    public static void showDialog() {
        if (theDialog == null) {
            TopLevel jf = TopLevel.getCurrentJFrame();
            theDialog = new GetInfoArc((Frame)jf, false);
        }
        theDialog.loadArcInfo();
        if (!theDialog.isVisible()) {
            theDialog.pack();
        }
        theDialog.setVisible(true);
    }

    public void highlightChanged() {
        if (!this.isVisible()) {
            return;
        }
        this.loadArcInfo();
    }

    public void databaseEndChangeBatch(Undo.ChangeBatch batch) {
        if (!this.isVisible()) {
            return;
        }
        boolean reload = false;
        Iterator it = batch.getChanges();
        while (it.hasNext()) {
            Undo.Change change = (Undo.Change)it.next();
            ElectricObject obj = change.getObject();
            if (obj != shownArc) continue;
            reload = true;
            break;
        }
        if (reload) {
            this.loadArcInfo();
        }
    }

    public void databaseChanged(Undo.Change change) {
    }

    private GetInfoArc(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        this.loadArcInfo();
        this.setLocation(100, 50);
        Highlight.addHighlightListener(this);
        Undo.addDatabaseChangeListener(this);
    }

    protected void escapePressed() {
        this.cancelActionPerformed(null);
    }

    private void loadArcInfo() {
        ArcInst ai = null;
        int arcCount = 0;
        Iterator it = Highlight.getHighlights();
        while (it.hasNext()) {
            ElectricObject eobj;
            Highlight h = (Highlight)it.next();
            if (h.getType() != Highlight.Type.EOBJ || !((eobj = h.getElectricObject()) instanceof ArcInst)) continue;
            ai = (ArcInst)eobj;
            ++arcCount;
        }
        if (arcCount > 1) {
            ai = null;
        }
        if (ai == null) {
            if (shownArc != null) {
                this.type.setText("");
                this.network.setText("");
                this.name.setEditable(false);
                this.name.setText("");
                this.width.setEditable(false);
                this.width.setText("");
                this.busSize.setText("");
                this.angle.setText("");
                this.easyToSelect.setEnabled(false);
                this.headNode.setText("");
                this.headLoc.setText("");
                this.headSee.setEnabled(false);
                this.tailNode.setText("");
                this.tailLoc.setText("");
                this.tailSee.setEnabled(false);
                this.rigid.setEnabled(false);
                this.rigid.setSelected(false);
                this.fixedAngle.setEnabled(false);
                this.fixedAngle.setSelected(false);
                this.slidable.setEnabled(false);
                this.slidable.setSelected(false);
                this.directional.setEnabled(false);
                this.directional.setSelected(false);
                this.endsExtend.setEnabled(false);
                this.endsExtend.setSelected(false);
                this.skipHead.setEnabled(false);
                this.skipHead.setSelected(false);
                this.skipTail.setEnabled(false);
                this.skipTail.setSelected(false);
                this.reverseEnds.setEnabled(false);
                this.reverseEnds.setSelected(false);
                this.apply.setEnabled(false);
                shownArc = null;
            }
            return;
        }
        this.name.setEditable(true);
        this.width.setEditable(true);
        this.easyToSelect.setEnabled(true);
        this.rigid.setEnabled(true);
        this.fixedAngle.setEnabled(true);
        this.slidable.setEnabled(true);
        this.directional.setEnabled(true);
        this.endsExtend.setEnabled(true);
        this.skipHead.setEnabled(true);
        this.skipTail.setEnabled(true);
        this.reverseEnds.setEnabled(true);
        this.headSee.setEnabled(true);
        this.tailSee.setEnabled(true);
        this.apply.setEnabled(true);
        this.initialName = ai.getName();
        this.initialWidth = ai.getWidth();
        this.initialEasyToSelect = !ai.isHardSelect();
        this.initialRigid = ai.isRigid();
        this.initialFixedAngle = ai.isFixedAngle();
        this.initialSlidable = ai.isSlidable();
        this.initialDirectional = ai.isDirectional();
        this.initialEndsExtend = ai.isExtended();
        this.initialSkipHead = ai.isSkipHead();
        this.initialSkipTail = ai.isSkipTail();
        this.initialReverseEnds = ai.isReverseEnds();
        this.type.setText(ai.getProto().describe());
        Netlist netlist = ai.getParent().getUserNetlist();
        int busWidth = netlist.getBusWidth(ai);
        String netName = netlist.getNetworkName(ai);
        this.network.setText(netName);
        this.name.setText(this.initialName);
        this.width.setText(Double.toString(this.initialWidth - ai.getProto().getWidthOffset()));
        this.busSize.setText(Integer.toString(busWidth));
        this.angle.setText(Double.toString((double)ai.getAngle() / 10.0));
        this.easyToSelect.setSelected(this.initialEasyToSelect);
        this.headNode.setText(ai.getHead().getPortInst().getNodeInst().describe());
        Point2D headPt = ai.getHead().getLocation();
        this.headLoc.setText("(" + headPt.getX() + "," + headPt.getY() + ")");
        this.tailNode.setText(ai.getTail().getPortInst().getNodeInst().describe());
        Point2D tailPt = ai.getTail().getLocation();
        this.tailLoc.setText("(" + tailPt.getX() + "," + tailPt.getY() + ")");
        this.rigid.setSelected(this.initialRigid);
        this.fixedAngle.setSelected(this.initialFixedAngle);
        this.slidable.setSelected(this.initialSlidable);
        this.directional.setSelected(this.initialDirectional);
        this.endsExtend.setSelected(this.initialEndsExtend);
        this.skipHead.setSelected(this.initialSkipHead);
        this.skipTail.setSelected(this.initialSkipTail);
        this.reverseEnds.setSelected(this.initialReverseEnds);
        shownArc = ai;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.type = new JLabel();
        this.jLabel3 = new JLabel();
        this.network = new JLabel();
        this.jLabel5 = new JLabel();
        this.name = new JTextField();
        this.jLabel6 = new JLabel();
        this.width = new JTextField();
        this.jLabel7 = new JLabel();
        this.busSize = new JLabel();
        this.jLabel9 = new JLabel();
        this.angle = new JLabel();
        this.easyToSelect = new JCheckBox();
        this.cancel = new JButton();
        this.jLabel11 = new JLabel();
        this.headNode = new JLabel();
        this.jLabel13 = new JLabel();
        this.headLoc = new JLabel();
        this.headSee = new JButton();
        this.ok = new JButton();
        this.jLabel15 = new JLabel();
        this.tailNode = new JLabel();
        this.jLabel17 = new JLabel();
        this.tailLoc = new JLabel();
        this.tailSee = new JButton();
        this.apply = new JButton();
        this.jPanel2 = new JPanel();
        this.rigid = new JCheckBox();
        this.reverseEnds = new JCheckBox();
        this.endsExtend = new JCheckBox();
        this.slidable = new JCheckBox();
        this.skipTail = new JCheckBox();
        this.directional = new JCheckBox();
        this.fixedAngle = new JCheckBox();
        this.skipHead = new JCheckBox();
        this.attributes = new JButton();
        this.setTitle("Arc Properties");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                GetInfoArc.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setText("Type:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.type.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.type, gridBagConstraints);
        this.jLabel3.setText("Network:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        this.network.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.network, gridBagConstraints);
        this.jLabel5.setText("Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.name, gridBagConstraints);
        this.jLabel6.setText("Width:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel6, gridBagConstraints);
        this.width.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.width, gridBagConstraints);
        this.jLabel7.setText("Bus size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel7, gridBagConstraints);
        this.busSize.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.busSize, gridBagConstraints);
        this.jLabel9.setText("Angle:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel9, gridBagConstraints);
        this.angle.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.angle, gridBagConstraints);
        this.easyToSelect.setText("Easy to Select");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.easyToSelect, gridBagConstraints);
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoArc.this.cancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.cancel, gridBagConstraints);
        this.jLabel11.setText("Head:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel11, gridBagConstraints);
        this.headNode.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.headNode, gridBagConstraints);
        this.jLabel13.setText("At:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 20, 4, 4);
        this.jPanel1.add((Component)this.jLabel13, gridBagConstraints);
        this.headLoc.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.headLoc, gridBagConstraints);
        this.headSee.setText("See");
        this.headSee.setMinimumSize(new Dimension(56, 20));
        this.headSee.setPreferredSize(new Dimension(56, 20));
        this.headSee.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoArc.this.headSeeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.headSee, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoArc.this.okActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.ok, gridBagConstraints);
        this.jLabel15.setText("Tail:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel15, gridBagConstraints);
        this.tailNode.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.tailNode, gridBagConstraints);
        this.jLabel17.setText("At:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 20, 4, 4);
        this.jPanel1.add((Component)this.jLabel17, gridBagConstraints);
        this.tailLoc.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.tailLoc, gridBagConstraints);
        this.tailSee.setText("See");
        this.tailSee.setMinimumSize(new Dimension(56, 20));
        this.tailSee.setPreferredSize(new Dimension(56, 20));
        this.tailSee.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoArc.this.tailSeeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.tailSee, gridBagConstraints);
        this.apply.setText("Apply");
        this.apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoArc.this.applyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.apply, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel2.setLayout(new GridBagLayout());
        this.rigid.setText("Rigid");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanel2.add((Component)this.rigid, gridBagConstraints);
        this.reverseEnds.setText("Reverse head and tail");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanel2.add((Component)this.reverseEnds, gridBagConstraints);
        this.endsExtend.setText("Ends extend");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanel2.add((Component)this.endsExtend, gridBagConstraints);
        this.slidable.setText("Slidable");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanel2.add((Component)this.slidable, gridBagConstraints);
        this.skipTail.setText("Ignore tail");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel2.add((Component)this.skipTail, gridBagConstraints);
        this.directional.setText("Directional");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel2.add((Component)this.directional, gridBagConstraints);
        this.fixedAngle.setText("Fixed-angle");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel2.add((Component)this.fixedAngle, gridBagConstraints);
        this.skipHead.setText("Ignore head");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanel2.add((Component)this.skipHead, gridBagConstraints);
        this.attributes.setText("Attributes");
        this.attributes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoArc.this.attributesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        this.jPanel2.add((Component)this.attributes, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.pack();
    }

    private void attributesActionPerformed(ActionEvent evt) {
        Attributes.showDialog();
    }

    private void tailSeeActionPerformed(ActionEvent evt) {
        if (shownArc == null) {
            return;
        }
        ArcInst ai = shownArc;
        NodeInst ni = shownArc.getTail().getPortInst().getNodeInst();
        Highlight.clear();
        Highlight.addElectricObject(ni, ni.getParent());
        Highlight.addElectricObject(ai, ai.getParent());
        Highlight.finished();
    }

    private void headSeeActionPerformed(ActionEvent evt) {
        if (shownArc == null) {
            return;
        }
        ArcInst ai = shownArc;
        NodeInst ni = shownArc.getHead().getPortInst().getNodeInst();
        Highlight.clear();
        Highlight.addElectricObject(ni, ni.getParent());
        Highlight.addElectricObject(ai, ai.getParent());
        Highlight.finished();
    }

    private void applyActionPerformed(ActionEvent evt) {
        if (shownArc == null) {
            return;
        }
        ChangeArc job = new ChangeArc(shownArc, this);
    }

    private void okActionPerformed(ActionEvent evt) {
        this.applyActionPerformed(evt);
        this.closeDialog(null);
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
    }

    private static class ChangeArc
    extends Job {
        ArcInst ai;
        GetInfoArc dialog;

        protected ChangeArc(ArcInst ai, GetInfoArc dialog) {
            super("Modify Arc", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ai = ai;
            this.dialog = dialog;
            this.startJob();
        }

        public boolean doIt() {
            double currentWidth;
            boolean currentReverseEnds;
            boolean currentSkipTail;
            boolean currentSkipHead;
            boolean currentEndsExtend;
            boolean currentDirectional;
            boolean currentSlidable;
            boolean currentFixedAngle;
            boolean currentRigid;
            boolean currentEasyToSelect;
            boolean changed = false;
            String currentName = this.dialog.name.getText().trim();
            if (!currentName.equals(this.dialog.initialName)) {
                this.dialog.initialName = new String(currentName);
                if (currentName.length() == 0) {
                    currentName = null;
                }
                this.ai.setName(currentName);
                changed = true;
            }
            if ((currentEasyToSelect = this.dialog.easyToSelect.isSelected()) != this.dialog.initialEasyToSelect) {
                if (currentEasyToSelect) {
                    this.ai.clearHardSelect();
                } else {
                    this.ai.setHardSelect();
                }
                this.dialog.initialEasyToSelect = currentEasyToSelect;
            }
            if ((currentRigid = this.dialog.rigid.isSelected()) != this.dialog.initialRigid) {
                if (currentRigid) {
                    this.ai.setRigid();
                } else {
                    this.ai.clearRigid();
                }
                this.dialog.initialRigid = currentRigid;
                changed = true;
            }
            if ((currentFixedAngle = this.dialog.fixedAngle.isSelected()) != this.dialog.initialFixedAngle) {
                if (currentFixedAngle) {
                    this.ai.setFixedAngle();
                } else {
                    this.ai.clearFixedAngle();
                }
                this.dialog.initialFixedAngle = currentFixedAngle;
                changed = true;
            }
            if ((currentSlidable = this.dialog.slidable.isSelected()) != this.dialog.initialSlidable) {
                if (currentSlidable) {
                    this.ai.setSlidable();
                } else {
                    this.ai.clearSlidable();
                }
                this.dialog.initialSlidable = currentSlidable;
                changed = true;
            }
            if ((currentDirectional = this.dialog.directional.isSelected()) != this.dialog.initialDirectional) {
                if (currentDirectional) {
                    this.ai.setDirectional();
                } else {
                    this.ai.clearDirectional();
                }
                this.dialog.initialDirectional = currentDirectional;
                changed = true;
            }
            if ((currentEndsExtend = this.dialog.endsExtend.isSelected()) != this.dialog.initialEndsExtend) {
                if (currentEndsExtend) {
                    this.ai.setExtended();
                } else {
                    this.ai.clearExtended();
                }
                this.dialog.initialEndsExtend = currentEndsExtend;
                changed = true;
            }
            if ((currentSkipHead = this.dialog.skipHead.isSelected()) != this.dialog.initialSkipHead) {
                if (currentSkipHead) {
                    this.ai.setSkipHead();
                } else {
                    this.ai.clearSkipHead();
                }
                this.dialog.initialSkipHead = currentSkipHead;
                changed = true;
            }
            if ((currentSkipTail = this.dialog.skipTail.isSelected()) != this.dialog.initialSkipTail) {
                if (currentSkipTail) {
                    this.ai.setSkipTail();
                } else {
                    this.ai.clearSkipTail();
                }
                this.dialog.initialSkipTail = currentSkipTail;
                changed = true;
            }
            if ((currentReverseEnds = this.dialog.reverseEnds.isSelected()) != this.dialog.initialReverseEnds) {
                if (currentReverseEnds) {
                    this.ai.setReverseEnds();
                } else {
                    this.ai.clearReverseEnds();
                }
                this.dialog.initialReverseEnds = currentReverseEnds;
                changed = true;
            }
            if (!DBMath.doublesEqual(currentWidth = TextUtils.atof(this.dialog.width.getText()) + this.ai.getProto().getWidthOffset(), this.dialog.initialWidth) || changed) {
                this.ai.modify(currentWidth - this.dialog.initialWidth, 0.0, 0.0, 0.0, 0.0);
                this.dialog.initialWidth = currentWidth;
            }
            return true;
        }
    }
}

