/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.jemNets;

import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import com.sun.electric.tool.ncc.basic.TransitiveRelation;
import com.sun.electric.tool.ncc.jemNets.NccCellInfo;
import com.sun.electric.tool.ncc.jemNets.Port;
import com.sun.electric.tool.ncc.jemNets.Subcircuit;
import com.sun.electric.tool.ncc.jemNets.Transistor;
import com.sun.electric.tool.ncc.jemNets.Wire;
import com.sun.electric.tool.ncc.jemNets.Wires;
import com.sun.electric.tool.ncc.processing.HierarchyInfo;
import com.sun.electric.tool.ncc.processing.SubcircuitInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

class Visitor
extends HierarchyEnumerator.Visitor {
    private static final boolean debug = false;
    private NccGlobals globals;
    private int depth = 0;
    private Wires wires;
    private final ArrayList parts = new ArrayList();
    private final ArrayList ports = new ArrayList();
    private NccCellAnnotations rootAnnotations;
    private final HierarchyInfo hierarchicalCompareInfo;

    private void error(boolean pred, String msg) {
        this.globals.error(pred, msg);
    }

    private void spaces() {
        for (int i = 0; i < this.depth; ++i) {
            this.globals.print(" ");
        }
    }

    private void addMatchingNetIDs(List netIDs, NccCellAnnotations.NamePattern pattern, HierarchyEnumerator.CellInfo rootInfo) {
        Cell rootCell = rootInfo.getCell();
        Iterator it = rootCell.getPorts();
        while (it.hasNext()) {
            Export e = (Export)it.next();
            int[] expNetIDs = rootInfo.getExportNetIDs(e);
            for (int i = 0; i < expNetIDs.length; ++i) {
                String expName = e.getNameKey().subname(i).toString();
                if (!pattern.matches(expName)) continue;
                netIDs.add(new Integer(expNetIDs[i]));
            }
        }
    }

    private void doExportsConnAnnot(TransitiveRelation mergedNetIDs, List connected, HierarchyEnumerator.CellInfo rootInfo) {
        ArrayList netIDs = new ArrayList();
        Iterator it = connected.iterator();
        while (it.hasNext()) {
            this.addMatchingNetIDs(netIDs, (NccCellAnnotations.NamePattern)it.next(), rootInfo);
        }
        for (int i = 1; i < netIDs.size(); ++i) {
            mergedNetIDs.theseAreRelated(netIDs.get(0), netIDs.get(i));
        }
    }

    private void doExportsConnAnnots(TransitiveRelation mergedNetIDs, HierarchyEnumerator.CellInfo rootInfo) {
        Cell root = rootInfo.getCell();
        if (this.rootAnnotations == null) {
            return;
        }
        Iterator it = this.rootAnnotations.getExportsConnected();
        while (it.hasNext()) {
            this.doExportsConnAnnot(mergedNetIDs, (List)it.next(), rootInfo);
        }
    }

    private void initWires(HierarchyEnumerator.CellInfo rootInfo) {
        TransitiveRelation mergedNetIDs = new TransitiveRelation();
        this.doExportsConnAnnots(mergedNetIDs, rootInfo);
        this.wires = new Wires(mergedNetIDs, rootInfo);
    }

    private void createPortsFromExports(HierarchyEnumerator.CellInfo rootInfo) {
        HashSet<Port> portSet = new HashSet<Port>();
        Cell rootCell = rootInfo.getCell();
        Iterator it = rootCell.getPorts();
        while (it.hasNext()) {
            Export e = (Export)it.next();
            int[] expNetIDs = rootInfo.getExportNetIDs(e);
            for (int i = 0; i < expNetIDs.length; ++i) {
                Wire wire = this.wires.get(expNetIDs[i], rootInfo);
                String expName = e.getNameKey().subname(i).toString();
                portSet.add(wire.addExportName(expName));
            }
        }
        Netlist rootNetlist = rootInfo.getNetlist();
        Global.Set globals = rootNetlist.getGlobals();
        for (int i = 0; i < globals.size(); ++i) {
            Global global = globals.get(i);
            String globName = global.getName();
            int netIndex = rootNetlist.getNetIndex(global);
            int netID = rootInfo.getNetID(netIndex);
            Wire wire = this.wires.get(netID, rootInfo);
            portSet.add(wire.addExportName(globName));
        }
        Iterator it2 = portSet.iterator();
        while (it2.hasNext()) {
            this.ports.add(it2.next());
        }
    }

    private Wire getWireForPortInst(PortInst pi, HierarchyEnumerator.CellInfo info) {
        NodeInst ni = pi.getNodeInst();
        NodeProto np = ni.getProto();
        this.error(!(np instanceof PrimitiveNode), "not PrimitiveNode");
        PortProto pp = pi.getPortProto();
        int[] netIDs = info.getPortNetIDs(ni, pp);
        this.error(netIDs.length != 1, "Primitive Port connected to bus?");
        return this.wires.get(netIDs[0], info);
    }

    private void buildMOS(NodeInst ni, Transistor.Type type, NccCellInfo info) {
        String name = info.getUniqueNodableName(ni, "/");
        int mul = info.getSizeMultiplier();
        double width = 0.0;
        double length = 0.0;
        if (this.globals.getOptions().checkSizes) {
            Dimension2D dim = ni.getTransistorSize(info.getContext());
            width = (double)mul * dim.getWidth();
            length = dim.getHeight();
        }
        Wire s = this.getWireForPortInst(ni.getTransistorSourcePort(), info);
        Wire g = this.getWireForPortInst(ni.getTransistorGatePort(), info);
        Wire d = this.getWireForPortInst(ni.getTransistorDrainPort(), info);
        Transistor t = new Transistor(type, name, width, length, s, g, d);
        this.parts.add(t);
    }

    private void doPrimitiveNode(NodeInst ni, NodeProto np, NccCellInfo info) {
        NodeProto.Function func = ni.getFunction();
        if (func == NodeProto.Function.TRA4NMOS) {
            this.buildMOS(ni, Transistor.NTYPE, info);
        } else if (func == NodeProto.Function.TRA4PMOS) {
            this.buildMOS(ni, Transistor.PTYPE, info);
        } else if (func == NodeProto.Function.TRANMOS) {
            this.buildMOS(ni, Transistor.NTYPE, info);
        } else if (func == NodeProto.Function.TRAPMOS) {
            this.buildMOS(ni, Transistor.PTYPE, info);
        } else if (func == NodeProto.Function.RESIST) {
            // empty if block
        }
    }

    private void addToPins(Wire[] pins, int pinNdx, Wire w) {
        if (pins[pinNdx] == null) {
            pins[pinNdx] = w;
        } else {
            this.globals.error(pins[pinNdx] != w, "exports that should be connected aren't");
        }
    }

    private void doSubcircuit(SubcircuitInfo subcktInfo, NccCellInfo info) {
        int i;
        Cell cell = info.getCell();
        Wire[] pins = new Wire[subcktInfo.numPorts()];
        Iterator it = cell.getPorts();
        while (it.hasNext()) {
            Export e = (Export)it.next();
            int[] expNetIDs = info.getExportNetIDs(e);
            for (int i2 = 0; i2 < expNetIDs.length; ++i2) {
                Wire wire = this.wires.get(expNetIDs[i2], info);
                String expName = e.getNameKey().subname(i2).toString();
                int pinNdx = subcktInfo.getPortIndex(expName);
                this.addToPins(pins, pinNdx, wire);
            }
        }
        Netlist netlist = info.getNetlist();
        Global.Set globalNets = netlist.getGlobals();
        for (i = 0; i < globalNets.size(); ++i) {
            Global global = globalNets.get(i);
            String globalName = global.getName();
            int pinNdx = subcktInfo.getPortIndex(globalName);
            int netIndex = netlist.getNetIndex(global);
            int netID = info.getNetID(netIndex);
            Wire wire = this.wires.get(netID, info);
            this.addToPins(pins, pinNdx, wire);
        }
        for (i = 0; i < pins.length; ++i) {
            this.globals.error(pins[i] == null, "disconnected subcircuit pins!");
        }
        String instName = info.getParentInst().getName();
        this.parts.add(new Subcircuit(instName, subcktInfo, pins));
    }

    private boolean annotationForceFlatten(NccCellInfo info) {
        if (info.isRootCell()) {
            return false;
        }
        NccCellInfo parentInfo = (NccCellInfo)info.getParentInfo();
        if (!parentInfo.isRootCell()) {
            return false;
        }
        Nodable no = info.getParentInst();
        String instName = no.getName();
        if (this.rootAnnotations == null) {
            return false;
        }
        return this.rootAnnotations.flattenInstance(instName);
    }

    public HierarchyEnumerator.CellInfo newCellInfo() {
        return new NccCellInfo(this.globals);
    }

    public boolean enterCell(HierarchyEnumerator.CellInfo ci) {
        NccCellInfo info = (NccCellInfo)ci;
        if (info.isRootCell()) {
            this.rootAnnotations = NccCellAnnotations.getAnnotations(info.getCell());
            this.initWires(info);
            this.createPortsFromExports(info);
        } else {
            Cell cell = info.getCell();
            if (!this.annotationForceFlatten(info) && this.hierarchicalCompareInfo != null && this.hierarchicalCompareInfo.treatAsPrimitive(cell)) {
                SubcircuitInfo subcktInfo = this.hierarchicalCompareInfo.getSubcircuitInfo(cell);
                this.doSubcircuit(subcktInfo, info);
                return false;
            }
        }
        if (this.globals.getOptions().mergeParallelCells) {
            info.recordMergeParallelInfo();
        }
        return true;
    }

    public void exitCell(HierarchyEnumerator.CellInfo info) {
    }

    public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo ci) {
        NccCellInfo info = (NccCellInfo)ci;
        NodeProto np = no.getProto();
        if (np instanceof PrimitiveNode) {
            this.doPrimitiveNode((NodeInst)no, np, info);
            return false;
        }
        this.error(!(np instanceof Cell), "expecting Cell");
        boolean paralleled = info.isDiscardable(no);
        return !paralleled;
    }

    public ArrayList getWireList() {
        return this.wires.getWireArray();
    }

    public ArrayList getPartList() {
        return this.parts;
    }

    public ArrayList getPortList() {
        return this.ports;
    }

    public Visitor(NccGlobals globals, HierarchyInfo hierarchicalCompareInfo) {
        this.globals = globals;
        this.hierarchicalCompareInfo = hierarchicalCompareInfo;
    }
}

