/*
 * Electric(tm) VLSI Design System
 *
 * File: sim.h
 * Simulation aid: header file
 * Written by: Steven M. Rubin, Static Free Software
 *
 * Copyright (c) 2000 Static Free Software.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Static Free Software
 * 4119 Alpine Road
 * Portola Valley, California 94028
 * info@staticfreesoft.com
 */

/********************* for all simulators *********************/

#define	ESIM     0						/* ESIM from MIT (SIM format) */
#define	RSIM     1						/* RSIM from MIT (SIM format) */
#define	RNL      2						/* RNL from MIT (SIM format) */
#define COSMOS	 3						/* COSMOS from CMU (SIM format) */
#define	SPICE    4						/* SPICE from Berkeley (SPICE format) */
#define MOSSIM   5						/* MOSSIM from CalTech (NTK format) */
#define TEXSIM   6						/* TEGAS from Calma (TDL format) */
#define ABEL     7						/* ABEL from Data I/O (PAL programmer) */
#define VERILOG  8						/* VERILOG from Gateway (VER format) */
#define SILOS	 9						/* SILOS from Simucad */
#define ALS 	10						/* ALS (NET format) */

/* the meaning of "SIM_dontrun" */
#define SIMRUNYES       -1				/* run simulation, show output */
#define SIMRUNYESPARSE   0				/* run simulation, show output, parse output */
#define SIMRUNNO         1				/* do not runs simulation */
#define SIMRUNYESQPARSE  2				/* run simulation, parse output */
#define SIMRUNYESQ       3				/* run simulation */

extern AIDENTRY  *sim_aid;				/* the Simulator aid object */
extern INTBIG     sim_format;			/* key for "SIM_format" (ESIM, etc) */
extern INTBIG     sim_netfile;			/* key for "SIM_netfile" */
extern INTBIG     sim_dontrun;			/* key for "SIM_dontrun" */
extern NODEPROTO *sim_simnt;			/* facet being simulated */
extern int        sim_tosim[2];			/* pipe to the simulator process */
extern int        sim_fromsim[2];		/* pipe from the simulator process */
extern INTBIG     sim_process;			/* process number of simulator */

/********************* for Simulation Window *********************/

/* the bits returned by "sim_window_isactive()" */
#define SIMWINDOWWAVEFORM   1			/* set if waveform window is active */
#define SIMWINDOWSCHEMATIC  2			/* set if schematic window is active */

/* logic levels and signal strengths in the window */
#define LOGIC_LOW      -1
#define LOGIC_X        -2
#define LOGIC_HIGH     -3
#define OFF_STRENGTH    0
#define NODE_STRENGTH   1
#define GATE_STRENGTH   2
#define VDD_STRENGTH    3

/* the meaning of "sim_window_state" */
#define FULLSTATE      01				/* set for full 12-state simulation */
#define SHOWWAVEFORM   02				/* set to show waveform window */
#define ADVANCETIME    04				/* set to advance time to end of simulation */

extern INTBIG       sim_window_state;	/* cached key for "SIM_window_state" */

/* prototypes */
void   sim_window_init(void);
void   sim_window_term(void);
INTSML sim_window_create(INTSML, NODEPROTO*, INTSML(*)(WINDOWPART*, INTSML), INTSML(*)(WINDOWPART*, INTSML));
void   sim_window_stopsimulation(void);
INTSML sim_window_isactive(NODEPROTO **np);
void   sim_window_redraw(void);
void   sim_window_setlines(INTSML);
INTSML sim_window_getlines(void);
void   sim_window_savegraph(void);
void   sim_window_displaymode(INTSML full);
void   sim_window_displaycolor(INTSML strength, INTSML color);
INTBIG sim_window_newtrace(INTSML, char*, INTBIG);
void   sim_window_loaddigtrace(INTBIG, INTSML, float*, INTSML*);
void   sim_window_loadanatrace(INTBIG, INTSML, float*, float*);
void   sim_window_setanarange(float, float);
void   sim_window_getanarange(float*, float*);
void   sim_window_setanaextents(float, float);
void   sim_window_getanaextents(float*, float*);
void   sim_window_settraceline(INTBIG, INTSML);
void   sim_window_killtrace(INTBIG);
void   sim_window_killalltraces(void);
INTSML sim_window_gettraceline(INTBIG);
char  *sim_window_gettracename(INTBIG);
INTBIG sim_window_gettracedata(INTBIG);
float  sim_window_getanatracevalue(INTBIG, float);
INTBIG sim_window_findtrace(char*);
void   sim_window_inittraceloop(void);
void   sim_window_inittraceloop2(void);
INTBIG sim_window_nexttraceloop(void);
INTBIG sim_window_nexttraceloop2(void);
void   sim_window_sethighlighttrace(INTBIG);
INTBIG sim_window_gethighlighttrace(void);
void   sim_window_setmaincursor(float);
float  sim_window_getmaincursor(void);
void   sim_window_setextensioncursor(float);
float  sim_window_getextensioncursor(void);
void   sim_window_settimerange(float, float);
void   sim_window_gettimerange(float*, float*);
void   sim_window_gettimeextents(float*, float*);
void   sim_window_updatelayoutwindow(void);
void   sim_windowconvertengineeringnotation(float, char*);
void   sim_window_addhighlightednet(INTSML);

/********************* for ESIM *********************/

#define	ESIMNAME    "esim"

/********************* for RSIM *********************/

#define	RSIMPRENAME "presim"
#define	RSIMNAME    "rsim"
#define	RSIMIN      "rsim.in"			/* name of file with binary network */

/********************* for ALS *********************/

#define	NET_EXT		".net"
#define PLOT_EXT	".hpgl"

/********************* for RNL *********************/

#define	RNLPRENAME  "presim"
#define	RNLNAME     "rnl"
#define	RNLIN       "rnl.in"			/* name of file with binary network */
#define	RNLCOMM     "nl.l"				/* file with simulator initialization */

/********************* for VERILOG *********************/

/* Meaning of bits in sim_verilog_state */
#define VERILOGUSEASSIGN  01			/* set to use "assign" construct */

extern INTBIG sim_verilog_state;		/* key for "SIM_verilog_state" */

/********************* for SPICE *********************/

#define MAXSPICELEVEL     3				/* levels 1, 2, and 3 */

/* Meaning of bits in sim_spice_state */
#define SPICERESISTANCE   01			/* set for resistances */
#define SPICEPLOT         02			/* set for plots (vs prints) */
#define SPICEDEBUG        04			/* set for debugging */
#define SPICENODENAMES   010			/* set for node names (vs numbers) */
#define SPICETYPE        060			/* mask for spice type */
#define SPICE2           000			/* type - spice 2 */
#define SPICE3           020			/* type - spice 3 */
#define SPICEHSPICE      040			/* type - hspice  */

extern INTBIG sim_spice_level;			/* key for "SIM_spice_level" */
extern INTBIG sim_spice_state;			/* key for "SIM_spice_state" */
extern INTSML sim_spice_debug;			/* SPICE debugging */
extern INTBIG sim_listingfile;			/* key for "SIM_listingfile" */

#if defined(__cplusplus) && !defined(ALLCPLUSPLUS)
extern "C"
{
#endif

/* prototypes for tool interface */
void   sim_init(INTBIG*, char*[], AIDENTRY*);
void   sim_done(void);
INTSML sim_set(INTSML, char*[]);
void   sim_slice(void);
void   sim_startbatch(AIDENTRY*, INTSML);
void   sim_modifynodeinst(NODEINST*,INTBIG,INTBIG,INTBIG,INTBIG,INTSML,INTSML);
void   sim_modifyarcinst(ARCINST*,INTBIG,INTBIG,INTBIG,INTBIG,INTBIG,INTBIG);
void   sim_modifyportproto(PORTPROTO*, NODEINST*, PORTPROTO*);
void   sim_newobject(INTBIG, INTBIG);
void   sim_killobject(INTBIG, INTBIG);
void   sim_newvariable(INTBIG, INTBIG, INTBIG, INTBIG);
void   sim_killvariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);

INTSML simals_charhandlerschem(WINDOWPART*, INTSML);
INTSML simals_charhandlerwave(WINDOWPART*, INTSML);

/* prototypes for intratool interface */
void     sim_freespicememory(void);
void     sim_spice_xprintf(FILE*, char*, ...);
NETWORK *sim_spice_networkfromname(char *name);
char    *sim_spice_signalname(NETWORK *net);
INTSML   sim_simpointout(char*, INTSML);
void     sim_spice_execute(char*, char*);
void     sim_writesim(NODEPROTO*, INTSML);
void     sim_writepalnetlist(NODEPROTO*);
void     sim_writemossim(NODEPROTO*);
void     sim_writetexnetlist(NODEPROTO*);
void     sim_writespice(NODEPROTO*);
void     sim_writevernetlist(NODEPROTO*);
void     sim_writesilnetlist(NODEPROTO*);
void     sim_resumesim(INTSML);
INTSML   sim_alsclockdlog(char *paramstart[]);

#if defined(__cplusplus) && !defined(ALLCPLUSPLUS)
}
#endif
