/* AMD pp. 173 - 177:
 * missing treatment combinations
 */
#include <dap.h>

void main()
{
  infile("amd173.dat", " ")
    {
      char treat[3], block[3];
      double y;
      input("treat block y");
      outset("amd173", "treat block y");
      skip(1);
      while (step())
          output();
    }

  sort("amd173", "treat block", "");
  means("amd173.srt", "y", "N MEAN VAR", "treat block");

  /* Now we have to construct a file for ftest "by hand"
   * to test the contrasts that are meaningful in the
   * presence of empty cells.
   */

  /* To avoid ugly, long strings */
  title("Testing interaction Ho:\n");
  dap_head(NULL, 0);
  fputs("u11 - u21 - (u13 - u23) = 0 and\n", dap_lst);
  fputs("u21 - u31 - (u22 - u32) = 0", dap_lst);

  inset("amd173.srt.mns")
    {
      char _type_[9];
      double y;
      char treat[3], block[3];
      int _term_;
      int n;
      int celln;
  
      outset("amd173.con", "");
      _term_ = 3;  /* bit 0 (1's place) is treat,
                    * bit 1 (2's place) is block
                    */
      for (celln = 1, n = 0; step(); )
        {
          output();
          if (++n == 3) /* if got N, MEAN, and VAR */
            {     /* then put in contrasts */
              n = 0;
              strcpy(_type_, "CONTR");
              switch (celln)
                {
              case 1: /* u11 */
                  y = 1.0; output();
                  y = 0.0; output();
                  break;
              case 2: /* u13, because u22 empty */
                  y = -1.0; output();
                  y = 0.0; output();
                  break;
              case 3: /* u21 */
                  y = -1.0; output();
                  y = 1.0; output();
                  break;
              case 4: /* u22 */
                  y = 0.0; output();
                  y = -1.0; output();
                  break;
              case 5: /* u23 */
                  y = 1.0; output();
                  y = 0.0; output();
                  break;
              case 6: /* u31 */
                  y = 0.0; output();
                  y = -1.0; output();
                  break;
              case 7: /* u32, and u33 empty */
                  y = 0.0; output();
                  y = 1.0; output();
                  break;
                }
              celln++;
            }
        }
    }
  ftest("amd173.con", "y treat block", "", "", "");

  title("Testing treatment Ho:\n");
  dap_head(NULL, 0);
  fputs("u11 + u13 - (u21 + u23) = 0\n", dap_lst);
  fputs("u21 + u22 - (u31 + u32) = 0\n", dap_lst);
  
  inset("amd173.srt.mns")
    {
      char _type_[9];
      double y;
      char treat[3], block[3];
      int _term_;
      int n;
      int celln;
  
      outset("amd173.con", "");
      _term_ = 1;  /* bit 0 (1's place) is treat */
      for (celln = 1, n = 0; step(); )
        {
          output();
          if (++n == 3)
            {
              n = 0;
              strcpy(_type_, "CONTR");
              switch (celln)
                {
              case 1: /* u11 */
                  y = 1.0; output();
                  y = 0.0; output();
                  break;
              case 2: /* u13, because u22 empty */
                  y = 1.0; output();
                  y = 0.0; output();
                  break;
              case 3: /* u21 */
                  y = -1.0; output();
                  y = 1.0; output();
                  break;
              case 4: /* u22 */
                  y = 0.0; output();
                  y = 1.0; output();
                  break;
              case 5: /* u23 */
                  y = -1.0; output();
                  y = 0.0; output();
                  break;
              case 6: /* u31 */
                  y = 0.0; output();
                  y = -1.0; output();
                  break;
              case 7: /* u32, and u33 empty */
                  y = 0.0; output();
                  y = -1.0; output();
                  break;
                }
              celln++;
            }
        }
    }
  
  ftest("amd173.con", "y treat block", "", "", "");
}
