#include <config.h>
#include "ucarp.h"
#include "garp.h"
#include "log.h"

#ifdef WITH_DMALLOC
# include <dmalloc.h>
#endif

int gratuitous_arp(const int dev_desc_fd, const int enable_virtual)
{
    static unsigned char arp[28] = {
            0x00, 0x01,   /* MAC address type */
            0x08, 0x00,   /* Protocol address type */
            0x06, 0x04,   /* MAC address size, protocol address size */
            0x00, 0x02,   /* OP (1=request, 2=reply) */
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   /* Sender MAC */
            0x00, 0x00, 0x00, 0x00,   /* Sender IP */
            0xff, 0xff, 0xff, 0xff, 0xff, 0xff,   /* Target MAC */
            0xff, 0xff, 0xff, 0xff   /* Target IP */
    };    
    unsigned char *pkt;
    struct ether_header *eh_ptr;
    int rc;

    if (ETHER_ADDR_LEN > 6) {
	abort();
    }
    memcpy(&arp[8], hwaddr, sizeof hwaddr);
    if (enable_virtual != 0) {
        arp[7] = 0x02;
        memcpy(&arp[14], &vaddr.s_addr, (size_t) 4U);
    } else {
	arp[7] = 0x01;
	memcpy(&arp[14], &vaddr.s_addr, (size_t) 4U);
	memset(&arp[18], 0xff, ETHER_ADDR_LEN);
	memcpy(&arp[24], &vaddr.s_addr, (size_t) 4U);
    }
    if ((pkt = ALLOCA(sizeof *eh_ptr + sizeof arp)) == NULL) {
        logfile(LOG_ERR, _("out of memory to send gratuitous ARP"));
        return -1;
    }
    memcpy(pkt + sizeof *eh_ptr, arp, sizeof arp);
    {
        struct ether_header eh;
        
        memcpy(&eh, pkt, sizeof eh);
        memcpy(&eh.ether_shost, &arp[8], ETHER_ADDR_LEN);
        memcpy(&eh.ether_dhost, &arp[18], ETHER_ADDR_LEN);
        eh.ether_type = htons(ETHERTYPE_ARP);
        memcpy(pkt, &eh, sizeof eh);
    }
    do {
	rc = write(dev_desc_fd, pkt, sizeof *eh_ptr + sizeof arp);
    } while (rc < 0 && errno == EINTR);
    if (rc < 0) {
        logfile(LOG_ERR, _("write() in garp: %s"), strerror(errno));
        ALLOCA_FREE(pkt);
        return -1;
    }
    ALLOCA_FREE(pkt);
    
    return 0;
}
