#include <config.h>
#include "ucarp.h"
#include "fillmac.h"
#include <sys/ioctl.h>
#ifdef HAVE_IFADDRS_H
# include <ifaddrs.h>
#endif
#ifdef HAVE_NET_IF_DL_H
# include <net/if_dl.h>
#endif
#ifdef HAVE_NET_IF_TYPES_H
# include <net/if_types.h>
#endif
#include "log.h"

#ifdef WITH_DMALLOC
# include <dmalloc.h>
#endif

#ifdef PF_PACKET
# define HWINFO_DOMAIN PF_PACKET
#else
# define HWINFO_DOMAIN PF_INET
#endif
#ifdef SOCK_PACKET
# define HWINFO_TYPE SOCK_PACKET
#else
# define HWINFO_TYPE SOCK_DGRAM
#endif   

int fill_mac_address(void)
{
    int s;

    if ((s = socket(HWINFO_DOMAIN, HWINFO_TYPE, 0)) == -1) {
        logfile(LOG_ERR, _("Unable to open raw device : [%s]"),
                strerror(errno));
        return -1;
    }
#ifdef SIOCGIFHWADDR
    {
        struct ifreq ifr;
        
        if (strlen(interface) >= sizeof ifr.ifr_name) {
            logfile(LOG_ERR, _("Interface name too long"));
            return -1;
        }
        strcpy(ifr.ifr_name, interface);                
        if (ioctl(s, SIOCGIFHWADDR, &ifr) != 0) {
            logfile(LOG_ERR,
                    _("Unable to get hardware info about an interface : %s"),
                    strerror(errno));
            (void) close(s);
            return -1;
        }
        switch (ifr.ifr_hwaddr.sa_family) {
        case ARPHRD_ETHER:
        case ARPHRD_IEEE802:
            break;
        default:
            logfile(LOG_ERR, _("Unknown hardware type [%u]"),
                    (unsigned int) ifr.ifr_hwaddr.sa_family);
        }
        memcpy(hwaddr, &ifr.ifr_hwaddr.sa_data, sizeof hwaddr);
    }
#elif defined(HAVE_GETIFADDRS)
    {   
        struct ifaddrs *ifas;
        struct ifaddrs *ifa;
        struct sockaddr_dl *sadl;
        struct ether_addr *ea;
        
        if (getifaddrs(&ifas) != 0) {
            logfile(LOG_ERR, _("Unable to get interface address : %s"),
                    strerror(errno));
            return -1;
        }
        ifa = ifas;
        while (ifa != NULL) {
            if (strcmp(ifa->ifa_name, interface) == 0 &&
                ifa->ifa_addr->sa_family == AF_LINK) {
                sadl = (struct sockaddr_dl *) ifa->ifa_addr;
                if (sadl == NULL || sadl->sdl_type != IFT_ETHER ||
                    sadl->sdl_alen <= 0) {
                    logfile(LOG_ERR,
                            _("Invalid media / hardware address for [%s]"),
                            interface);
                    return -1;
                }
                ea = (struct ether_addr *) LLADDR(sadl);
                memcpy(hwaddr, ea, sizeof hwaddr);
                
                return 0;
            }
            ifa = ifa->ifa_next;
        }
        return -1;
    }
#endif
    
    (void) close(s);    
    
    return 0;
}
