
#define DEFINE_GLOBALS 1

#include <config.h>
#include "ucarp.h"
#ifndef HAVE_GETOPT_LONG
# include "bsd-getopt_long.h"
#else
# include <getopt.h>
#endif
#ifdef HAVE_SETLOCALE
# include <locale.h>
#endif
#include "ucarp_p.h"

#ifdef WITH_DMALLOC
# include <dmalloc.h>
#endif

static void usage(void)
{
    puts("\n"
         PACKAGE_STRING ", compiled on " __DATE__ "\n\n"
         "--interface=<if> (-i <if>) : bind interface <if>\n"
         "--srcip=<ip> (-s <ip>) : source (real) IP address of that host\n"
         "--vhid=<id> (-v <id>) : virtual IP identifier (1-255)\n"
         "--pass=<pass> (-p <pass>) : password\n"
         "--preempt (-P) : becomes a master as soon as possible\n"
         "--addr=<ip> (-a <ip>) : virtual shared IP address\n"
         "--help (-h) : summary of command-line options\n"
         "--advbase=<seconds> (-b <seconds>) : advertisement frequency\n"
         "--advskew=<skew> (-k <skew>) : advertisement skew (0-255)\n"
         "--upscript=<file> (-u <file>) : run <file> to become a master\n"
         "--downscript=<file> (-d <file>) : run <file> to become a backup\n"
         "--deadratio=<ratio> (-r <ratio>) : ratio to consider a host as dead\n"
         "--shutdown (-z) : call shutdown script at exit\n"         
         "\n"
         "Sample usage :\n"
         "\n"
         "Manage the 10.1.1.252 shared virtual address on interface eth0, with\n"
         "1 as a virtual address idenfitier, mypassword as a password, and\n"
         "10.1.1.1 as a real permanent address for this host.\n"
         "Call /etc/vip-up.sh when the host becomes a master, and\n"
         "/etc/vip-down.sh when the virtual IP address has to be disabled.\n"
         "\n"
         "ucarp --interface=eth0 --srcip=10.1.1.1 --vhid=1 --pass=mypassword \\\n"
         "      --addr=10.1.1.252 \\\n"
         "      --upscript=/etc/vip-up.sh --downscript=/etc/vip-down.sh\n"
         "\n"
         "Please report bugs to " PACKAGE_BUGREPORT "."
         "\n");
    exit(EXIT_SUCCESS);
}

static void init_rand(void)
{
    struct timeval tv;
    
    gettimeofday(&tv, NULL);
#ifdef HAVE_SRANDOMDEV
    srandomdev();
#elif defined(HAVE_RANDOM)
    srandom((unsigned int) (tv.tv_sec ^ tv.tv_usec ^ (getpid() << 16)));
#else
    srand((unsigned int) (tv.tv_sec ^ tv.tv_usec ^ (getpid() << 16)));
#endif    
}

int main(int argc, char *argv[])
{
    int option_index = 0;
    int fodder;
    
    (void) close(0);
#ifdef HAVE_SETLOCALE
    setlocale(LC_ALL, "");
#endif
    if (argc <= 1) {
        usage();
    }
    while ((fodder = getopt_long(argc, argv, GETOPT_OPTIONS, long_options,
                                 &option_index)) != -1) {
        switch (fodder) {
        case 'h': {
            usage();
        }
        case 'i': {
            free(interface);
            interface = strdup(optarg); /* XXX - TODO : Check mem */
            break;            
        }
        case 's': {
            if (inet_aton(optarg, &srcip) == 0) {
                fprintf(stderr, "Invalid address : [%s]\n", optarg);
                return 1;
            }
            break;            
        }
        case 'v': {
            vhid = (unsigned char) strtoul(optarg, NULL, 0);
            break;            
        }
        case 'p': {
            free(pass);
            pass = strdup(optarg); /* XXX - TODO : Check mem */
            break;            
        }
        case 'P': {
            preempt = 1;
            break;
        }
        case 'a': {
            if (inet_aton(optarg, &vaddr) == 0) {
                fprintf(stderr, "Invalid address : [%s]\n", optarg);
                return 1;
            }            
            break;            
        }
        case 'b': {
            advbase = (unsigned char) strtoul(optarg, NULL, 0);
            break;            
        }
        case 'k': {
            advskew = (unsigned char) strtoul(optarg, NULL, 0);            
            break;            
        }
        case 'd': {
            free(downscript);
            downscript = strdup(optarg); /* XXX - TODO : Check mem */
            break;
        }
        case 'u': {
            free(downscript);
            upscript = strdup(optarg); /* XXX - TODO : Check mem */
            break;
        }
        case 'r': {
            dead_ratio = (unsigned int) strtoul(optarg, NULL, 0);
            break;
        }
        case 'z': {
            shutdown_at_exit = 1;
            break;
        }
        default: {
            usage();
        }
        }
    }
    if (interface == NULL || *interface == 0) {
        interface = pcap_lookupdev(NULL);
        if (interface == NULL || *interface == 0) {
            fprintf(stderr, "You must supply a network interface\n");
            return 1;
        }
        fprintf(stderr, "Using [%s] as a network interface\n", interface);
    }
    if (vhid == 0) {
        fprintf(stderr, "You must supply a valid virtual host id\n");
        return 1;
    }
    if (pass == NULL || *pass == 0) {
        fprintf(stderr, "You must supply a password\n");
        return 1;
    }
    if (advbase == 0 && advskew == 0) {
        fprintf(stderr, "You must supply an advertisement time base\n");
        return 1;
    }
    if (srcip.s_addr == 0) {
        fprintf(stderr, "You must supply a persistent source address\n");
        return 1;
    }
    if (vaddr.s_addr == 0) {
        fprintf(stderr, "You must supply a virtual host address\n");
        return 1;
    }
    if (upscript == NULL) {
        fprintf(stderr, "Warning : no script called when going up\n");
    }
    if (downscript == NULL) {
        fprintf(stderr, "Warning : no script called when going down\n");
    }
    if (dead_ratio <= 0U) {
        fprintf(stderr, "Dead ratio can't be zero\n");
        return 1;
    }
    init_rand();    
    if (docarp() != 0) {
        return 2;
    }    
    return 0;
}
