<?php

define('SKYCACHE_DEFAULT_DIR', '/tmp');
define('SKYCACHE_PREFIX', 'skycache-');
define('SKYCACHE_GC_DEFAULT_PROBABILITY', 10); # 0 ... 255
define('SKYCACHE_GC_DEFAULT_EXPIRY', 30 * 60);
define('SKYCACHE_DEFAULT_EXPIRY', SKYCACHE_GC_DEFAULT_EXPIRY);

function _skycache_get_key_file_and_etag() {
    global $_skycache_now;
    global $_skycache_ignore_encoding;
    global $_skycache_ignore_language;
    global $_skycache_ignore_uri;    
    global $_skycache_depends;
    global $_skycache_dir;    
    global $_skycache_key;
    global $_skycache_key_file;
    global $_skycache_etag;
    global $_skycache_etag_file;
    
    if (empty($_SERVER['REQUEST_METHOD']) ||
        ($_SERVER['REQUEST_METHOD'] !== 'GET' &&
         $_SERVER['REQUEST_METHOD'] !== 'HEAD') ||
        empty($_SERVER['REMOTE_ADDR'])) {
        return FALSE;
    }
    $key = '';
    if ($_skycache_ignore_encoding === FALSE &&
        !empty($_SERVER['HTTP_ACCEPT_ENCODING'])) {
        $key .= $_SERVER['HTTP_ACCEPT_ENCODING'];
    }
    $key .= "\0";
    if ($_skycache_ignore_language === FALSE &&
        !empty($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
        $key .= $_SERVER['HTTP_ACCEPT_LANGUAGE'];
    }
    $key .= "\0";
    if ($_skycache_ignore_uri === FALSE && !empty($_SERVER['REQUEST_URI'])) {
        $key .= $_SERVER['REQUEST_URI'];
    }
    $key .= "\0";
    if (!empty($_SERVER['HTTP_HOST'])) {
        $key .= $_SERVER['HTTP_HOST'];
    }
    $_skycache_key = md5($key . $_skycache_depends);
    $_skycache_key_file =
      $_skycache_dir . '/' . SKYCACHE_PREFIX . $_skycache_key;
    $_skycache_etag = $_skycache_key . $_skycache_now;
    $_skycache_etag_file =
      $_skycache_dir . '/' . SKYCACHE_PREFIX . $_skycache_etag;    
    
    return TRUE;
}

function _skycache_check_ifn($ifn) {
    global $_skycache_dir;
    global $_skycache_now;
    global $_skycache_expiry;
    
    if (preg_match('/^[0-9a-f]+$/i', $ifn) <= 0) {
        return FALSE;
    }
    $ifn_file = $_skycache_dir . '/' . SKYCACHE_PREFIX . $ifn;
    $obsolete_date = $_skycache_now;
    if ($_skycache_expiry > $obsolete_date) {
        return FALSE;
    }
    $obsolete_date -= $_skycache_expiry;
    if (($mtime = @filemtime($ifn_file)) === FALSE) {
        return FALSE;
    }
    if ($mtime < $obsolete_date) {
        header('X-Skycache-IFN-Expired-Since: ' . $mtime);
        return FALSE;
    }
    return TRUE;
}

function _skycache_send_etag_from_key() {
    global $_skycache_dir;    
    global $_skycache_key_file;    
    
    if (($found_etag_file = @readlink($_skycache_key_file)) === FALSE) {
        return FALSE;
    }
    $etag = substr($found_etag_file,
                   strlen($_skycache_dir) + 1 + strlen(SKYCACHE_PREFIX));
    if (empty($etag)) {
        return FALSE;
    }
    header('ETag: "' . $etag . '"');
    
    return TRUE;
}

function _skycache_send_cached_content() {
    global $_skycache_now;
    global $_skycache_key_file;
    global $_skycache_etag;
    global $_skycache_expiry;
    
    $obsolete_date = $_skycache_now;
    if ($_skycache_expiry > $obsolete_date) {
        return FALSE;
    }
    $obsolete_date -= $_skycache_expiry;
    if (($mtime = @filemtime($_skycache_key_file)) === FALSE) {
        return FALSE;
    }
    if ($mtime < $obsolete_date) {
        header('X-Skycache-Expired-Since: ' . $mtime);
        return FALSE;
    }
    if (isset($_SERVER['IF_NONE_MATCH']) &&
        _skycache_check_ifn($_SERVER['IF_NONE_MATCH']) === TRUE) {
        header('HTTP/1.1 304 Not Modified');
        exit;
    }    
    unset($headers);
    _skycache_send_etag_from_key();
    header('X-Skycache: from cache');
    if (@readfile($_skycache_key_file) === FALSE) {
        header('X-Skycache-Error: unreadable cache');   
        return FALSE;
    }
    return TRUE;
}

function _skycache_initial_check() {
    global $_skycache_fresh;    
    
    if (_skycache_get_key_file_and_etag() === FALSE) {
        header('X-Skycache: uncached URL');
        return FALSE;
    }
    if ($_skycache_fresh === TRUE) {
        header('X-Skycache: fresh content');    
        return FALSE;
    }
    if (_skycache_send_cached_content() === TRUE) {
        return TRUE;
    }
    return FALSE;
}

function _skycache_store_in_cache($content) {
    global $_skycache_no_store;
    global $_skycache_key_file;
    global $_skycache_etag_file;
    
    if ($_skycache_no_store === TRUE) {
        return FALSE;
    }    
    $tmp_file = $_skycache_etag_file . '.' . uniqid();
    if (($fp = fopen($tmp_file, 'w')) === FALSE) {
        @unlink($tmp_file);
        return FALSE;
    }
    if (fwrite($fp, $content) !== strlen($content)) {
        @unlink($tmp_file);
        @fclose($fp);
        return FALSE;   
    }
    if (fclose($fp) === FALSE ||
        rename($tmp_file, $_skycache_etag_file) === FALSE) {
        @unlink($tmp_file);     
        return FALSE;
    }
    $tmp_key_file = $_skycache_key_file . '.' . uniqid();
    if (@symlink($_skycache_etag_file, $tmp_key_file) === FALSE) {
        @unlink($tmp_key_file);
        if (@symlink($_skycache_etag_file, $tmp_key_file) === FALSE) {
            return TRUE;
        }
    }
    @rename($tmp_key_file, $_skycache_key_file);
    
    return TRUE;
}

function _skycache_ob_end(&$content) {
    global $_skycache_etag;
    global $_skycache_no_store;
    
    if (empty($_skycache_etag)) {
        die();
    }
    if ($_skycache_no_store === FALSE &&
        connection_aborted() == 0 && # doc: FALSE   real-world: 0
        _skycache_store_in_cache($content) === TRUE) {
        header('X-Skycache: stored');
        header('ETag: "' . $_skycache_etag . '"');
    }
    return $content;
}

function skycache_gc() {
    global $_skycache_now;
    global $_skycache_gc_expiry;
    global $_skycache_dir;    
    
    $obsolete_date = $_skycache_now;
    if ($_skycache_gc_expiry > $obsolete_date) {
        return FALSE;
    }
    $obsolete_date -= $_skycache_gc_expiry;
    if (($dir = opendir($_skycache_dir)) === FALSE) {
        return FALSE;
    }    
    $prefix_len = strlen(SKYCACHE_PREFIX);
    while (($entry = readdir($dir)) !== FALSE) {
        if (strncmp($entry, SKYCACHE_PREFIX, $prefix_len) !== 0 ||
            ($mtime = @filemtime($_skycache_dir . '/' . $entry)) === FALSE ||
            $mtime > $obsolete_date) {
            continue;
        }
        @unlink($_skycache_dir . '/' . $entry);
    }
    closedir($dir);
    
    return TRUE;
}

function skycache_set_gc_expiry($expiry) {
    global $_skycache_gc_expiry;
    
    $_skycache_gc_expiry = $expiry;
}

# $probability: 0 ... 255
function skycache_set_gc_probability($probability) {
    global $_skycache_gc_probability;
    
    $_skycache_gc_probability = $probability;
}

function skycache_set_expiry($expiry) {
    global $_skycache_expiry;
    
    $_skycache_expiry = $expiry;
}

function skycache_set_cache_dir($dir) {
    global $_skycache_dir;
    
    $_skycache_dir = $dir;
}

function skycache_ignore_encoding() {
    global $_skycache_ignore_encoding;
    
    $_skycache_ignore_encoding = TRUE;
}

function skycache_ignore_language() {
    global $_skycache_ignore_language;
    
    $_skycache_ignore_language = TRUE;
}

function skycache_ignore_uri() {
    global $_skycache_ignore_uri;
    
    $_skycache_ignore_uri = TRUE;
}

function skycache_depends($value) {
    global $_skycache_depends;
    
    $_skycache_depends .= "\0" . $value;
}

function skycache_fresh() {
    global $_skycache_fresh;
    
    $_skycache_fresh = TRUE;
}

function skycache_no_store() {
    global $_skycache_no_store;
    
    $_skycache_no_store = TRUE;
}

function skycache_version() {
    return 2.2;
}

function skycache() {
    global $_skycache_gc_probability;
    
    if ((rand() & 0xff) < $_skycache_gc_probability) {
        register_shutdown_function('skycache_gc');
    }
    if (_skycache_initial_check() === TRUE) {
        exit();
    }
    ob_start('_skycache_ob_end');
    ob_implicit_flush(0);
}

$_skycache_now = time();
$_skycache_fresh = FALSE;
$_skycache_ignore_encoding = FALSE;
$_skycache_ignore_language = FALSE;
$_skycache_ignore_uri = FALSE;
$_skycache_depends = '';
$_skycache_dir = SKYCACHE_DEFAULT_DIR;
$_skycache_expiry = SKYCACHE_DEFAULT_EXPIRY;
$_skycache_gc_expiry = SKYCACHE_GC_DEFAULT_EXPIRY;
$_skycache_gc_probability = SKYCACHE_GC_DEFAULT_PROBABILITY;
$_skycache_no_store = FALSE;

?>