#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include "php.h"
#include "php_ini.h"
#include "ext/standard/info.h"
#include "ext/standard/basic_functions.h"
#include "php_jenkins.h"

#ifdef WORDS_BIGENDIAN
# define HASH_BIG_ENDIAN 1
# define HASH_LITTLE_ENDIAN 0
#else
# define HASH_BIG_ENDIAN 0
# define HASH_LITTLE_ENDIAN 1
#endif

#ifdef HAVE_UINT8_T
typedef uint8_t php_uint8;
#else
typedef unsigned char php_uint8;
#endif
#ifdef HAVE_UINT16_T
typedef uint16_t php_uint16;
#else
typedef unsigned short php_uint16;
#endif

zend_function_entry jenkins_functions[] = {
	PHP_FE(jenkins_hash, NULL)
	PHP_FALIAS(jenkins_hash32, jenkins_hash, NULL)
	PHP_FE(jenkins_hash64, NULL)
	PHP_FE(jenkins_hash64_hex, NULL)
	{NULL, NULL, NULL}
};

zend_module_entry jenkins_module_entry = {
#if ZEND_MODULE_API_NO >= 20010901
	STANDARD_MODULE_HEADER,
#endif
	"jenkins",
	jenkins_functions,
	PHP_MINIT(jenkins),
	PHP_MSHUTDOWN(jenkins),
	NULL,
	NULL,
	PHP_MINFO(jenkins),
#if ZEND_MODULE_API_NO >= 20010901
	"0.9",
#endif
	STANDARD_MODULE_PROPERTIES
};

#ifdef COMPILE_DL_JENKINS
ZEND_GET_MODULE(jenkins)
#endif

#define rot(x,k) (((x)<<(k)) | ((x)>>(32-(k))))

#define mix(a,b,c) \
	{ \
		a -= c;  a ^= rot(c, 4);  c += b; \
		b -= a;  b ^= rot(a, 6);  a += c; \
		c -= b;  c ^= rot(b, 8);  b += a; \
		a -= c;  a ^= rot(c,16);  c += b; \
  b -= a;  b ^= rot(a,19);  a += c; \
  c -= b;  c ^= rot(b, 4);  b += a; \
}

#define final(a,b,c) \
{ \
  c ^= b; c -= rot(b,14); \
  a ^= c; a -= rot(c,11); \
  b ^= a; b -= rot(a,25); \
  c ^= b; c -= rot(b,16); \
  a ^= c; a -= rot(c,4);  \
  b ^= a; b -= rot(a,14); \
  c ^= b; c -= rot(b,24); \
}

static php_uint32 hashlittle(const void *key, size_t length,
			     php_uint32 initval)
{
  php_uint32 a,b,c;                                          /* internal state */
  union { const void *ptr; size_t i; } u;     /* needed for Mac Powerbook G4 */

  a = b = c = 0xdeadbeef + ((php_uint32)length) + initval;

  u.ptr = key;
  if (HASH_LITTLE_ENDIAN && ((u.i & 0x3) == 0)) {
    const php_uint32 *k = (const php_uint32 *)key;         /* read 32-bit chunks */
    while (length > 12)
    {
      a += k[0];
      b += k[1];
      c += k[2];
      mix(a,b,c);
      length -= 12;
      k += 3;
    }

    switch(length)
    {
    case 12: c+=k[2]; b+=k[1]; a+=k[0]; break;
    case 11: c+=k[2]&0xffffff; b+=k[1]; a+=k[0]; break;
    case 10: c+=k[2]&0xffff; b+=k[1]; a+=k[0]; break;
    case 9 : c+=k[2]&0xff; b+=k[1]; a+=k[0]; break;
    case 8 : b+=k[1]; a+=k[0]; break;
    case 7 : b+=k[1]&0xffffff; a+=k[0]; break;
    case 6 : b+=k[1]&0xffff; a+=k[0]; break;
    case 5 : b+=k[1]&0xff; a+=k[0]; break;
    case 4 : a+=k[0]; break;
    case 3 : a+=k[0]&0xffffff; break;
    case 2 : a+=k[0]&0xffff; break;
    case 1 : a+=k[0]&0xff; break;
    case 0 : return c;              /* zero length strings require no mixing */
    }
  } else if (HASH_LITTLE_ENDIAN && ((u.i & 0x1) == 0)) {
    const php_uint16 *k = (const php_uint16 *)key;         /* read 16-bit chunks */
    const php_uint8  *k8;

    while (length > 12)
    {
      a += k[0] + (((php_uint32)k[1])<<16);
      b += k[2] + (((php_uint32)k[3])<<16);
      c += k[4] + (((php_uint32)k[5])<<16);
      mix(a,b,c);
      length -= 12;
      k += 6;
    }

    k8 = (const php_uint8 *)k;
    switch(length)
    {
    case 12: c+=k[4]+(((php_uint32)k[5])<<16);
             b+=k[2]+(((php_uint32)k[3])<<16);
             a+=k[0]+(((php_uint32)k[1])<<16);
             break;
    case 11: c+=((php_uint32)k8[10])<<16;     /* fall through */
    case 10: c+=k[4];
             b+=k[2]+(((php_uint32)k[3])<<16);
             a+=k[0]+(((php_uint32)k[1])<<16);
             break;
    case 9 : c+=k8[8];                      /* fall through */
    case 8 : b+=k[2]+(((php_uint32)k[3])<<16);
             a+=k[0]+(((php_uint32)k[1])<<16);
             break;
    case 7 : b+=((php_uint32)k8[6])<<16;      /* fall through */
    case 6 : b+=k[2];
             a+=k[0]+(((php_uint32)k[1])<<16);
             break;
    case 5 : b+=k8[4];                      /* fall through */
    case 4 : a+=k[0]+(((php_uint32)k[1])<<16);
             break;
    case 3 : a+=((php_uint32)k8[2])<<16;      /* fall through */
    case 2 : a+=k[0];
             break;
    case 1 : a+=k8[0];
             break;
    case 0 : return c;                     /* zero length requires no mixing */
    }

  } else {                        /* need to read the key one byte at a time */
    const php_uint8 *k = (const php_uint8 *)key;

    while (length > 12)
    {
      a += k[0];
      a += ((php_uint32)k[1])<<8;
      a += ((php_uint32)k[2])<<16;
      a += ((php_uint32)k[3])<<24;
      b += k[4];
      b += ((php_uint32)k[5])<<8;
      b += ((php_uint32)k[6])<<16;
      b += ((php_uint32)k[7])<<24;
      c += k[8];
      c += ((php_uint32)k[9])<<8;
      c += ((php_uint32)k[10])<<16;
      c += ((php_uint32)k[11])<<24;
      mix(a,b,c);
      length -= 12;
      k += 12;
    }

    switch(length)                   /* all the case statements fall through */
    {
    case 12: c+=((php_uint32)k[11])<<24;
    case 11: c+=((php_uint32)k[10])<<16;
    case 10: c+=((php_uint32)k[9])<<8;
    case 9 : c+=k[8];
    case 8 : b+=((php_uint32)k[7])<<24;
    case 7 : b+=((php_uint32)k[6])<<16;
    case 6 : b+=((php_uint32)k[5])<<8;
    case 5 : b+=k[4];
    case 4 : a+=((php_uint32)k[3])<<24;
    case 3 : a+=((php_uint32)k[2])<<16;
    case 2 : a+=((php_uint32)k[1])<<8;
    case 1 : a+=k[0];
             break;
    case 0 : return c;
    }
  }
  final(a,b,c);
	
  return c;
}

static void hashlittle2( 
  const void *key,       /* the key to hash */
  size_t      length,    /* length of the key */
  php_uint32   *pc,        /* IN: primary initval, OUT: primary hash */
  php_uint32   *pb)        /* IN: secondary initval, OUT: secondary hash */
{
  php_uint32 a,b,c;                                          /* internal state */
  union { const void *ptr; size_t i; } u;     /* needed for Mac Powerbook G4 */

  a = b = c = 0xdeadbeef + ((php_uint32)length) + *pc;
  c += *pb;

  u.ptr = key;
  if (HASH_LITTLE_ENDIAN && ((u.i & 0x3) == 0)) {
    const php_uint32 *k = (const php_uint32 *)key;         /* read 32-bit chunks */

    while (length > 12)
    {
      a += k[0];
      b += k[1];
      c += k[2];
      mix(a,b,c);
      length -= 12;
      k += 3;
    }
    switch(length)
    {
    case 12: c+=k[2]; b+=k[1]; a+=k[0]; break;
    case 11: c+=k[2]&0xffffff; b+=k[1]; a+=k[0]; break;
    case 10: c+=k[2]&0xffff; b+=k[1]; a+=k[0]; break;
    case 9 : c+=k[2]&0xff; b+=k[1]; a+=k[0]; break;
    case 8 : b+=k[1]; a+=k[0]; break;
    case 7 : b+=k[1]&0xffffff; a+=k[0]; break;
    case 6 : b+=k[1]&0xffff; a+=k[0]; break;
    case 5 : b+=k[1]&0xff; a+=k[0]; break;
    case 4 : a+=k[0]; break;
    case 3 : a+=k[0]&0xffffff; break;
    case 2 : a+=k[0]&0xffff; break;
    case 1 : a+=k[0]&0xff; break;
    case 0 : *pc=c; *pb=b; return;  /* zero length strings require no mixing */
    }
  } else if (HASH_LITTLE_ENDIAN && ((u.i & 0x1) == 0)) {
    const php_uint16 *k = (const php_uint16 *)key;         /* read 16-bit chunks */
    const php_uint8  *k8;

    /*--------------- all but last block: aligned reads and different mixing */
    while (length > 12)
    {
      a += k[0] + (((php_uint32)k[1])<<16);
      b += k[2] + (((php_uint32)k[3])<<16);
      c += k[4] + (((php_uint32)k[5])<<16);
      mix(a,b,c);
      length -= 12;
      k += 6;
    }

    k8 = (const php_uint8 *)k;
    switch(length)
    {
    case 12: c+=k[4]+(((php_uint32)k[5])<<16);
             b+=k[2]+(((php_uint32)k[3])<<16);
             a+=k[0]+(((php_uint32)k[1])<<16);
             break;
    case 11: c+=((php_uint32)k8[10])<<16;     /* fall through */
    case 10: c+=k[4];
             b+=k[2]+(((php_uint32)k[3])<<16);
             a+=k[0]+(((php_uint32)k[1])<<16);
             break;
    case 9 : c+=k8[8];                      /* fall through */
    case 8 : b+=k[2]+(((php_uint32)k[3])<<16);
             a+=k[0]+(((php_uint32)k[1])<<16);
             break;
    case 7 : b+=((php_uint32)k8[6])<<16;      /* fall through */
    case 6 : b+=k[2];
             a+=k[0]+(((php_uint32)k[1])<<16);
             break;
    case 5 : b+=k8[4];                      /* fall through */
    case 4 : a+=k[0]+(((php_uint32)k[1])<<16);
             break;
    case 3 : a+=((php_uint32)k8[2])<<16;      /* fall through */
    case 2 : a+=k[0];
             break;
    case 1 : a+=k8[0];
             break;
    case 0 : *pc=c; *pb=b; return;  /* zero length strings require no mixing */
    }

  } else {                        /* need to read the key one byte at a time */
    const php_uint8 *k = (const php_uint8 *)key;

    /*--------------- all but the last block: affect some 32 bits of (a,b,c) */
    while (length > 12)
    {
      a += k[0];
      a += ((php_uint32)k[1])<<8;
      a += ((php_uint32)k[2])<<16;
      a += ((php_uint32)k[3])<<24;
      b += k[4];
      b += ((php_uint32)k[5])<<8;
      b += ((php_uint32)k[6])<<16;
      b += ((php_uint32)k[7])<<24;
      c += k[8];
      c += ((php_uint32)k[9])<<8;
      c += ((php_uint32)k[10])<<16;
      c += ((php_uint32)k[11])<<24;
      mix(a,b,c);
      length -= 12;
      k += 12;
    }

    switch(length)                   /* all the case statements fall through */
    {
    case 12: c+=((php_uint32)k[11])<<24;
    case 11: c+=((php_uint32)k[10])<<16;
    case 10: c+=((php_uint32)k[9])<<8;
    case 9 : c+=k[8];
    case 8 : b+=((php_uint32)k[7])<<24;
    case 7 : b+=((php_uint32)k[6])<<16;
    case 6 : b+=((php_uint32)k[5])<<8;
    case 5 : b+=k[4];
    case 4 : a+=((php_uint32)k[3])<<24;
    case 3 : a+=((php_uint32)k[2])<<16;
    case 2 : a+=((php_uint32)k[1])<<8;
    case 1 : a+=k[0];
             break;
    case 0 : *pc=c; *pb=b; return;  /* zero length strings require no mixing */
    }
  }

  final(a,b,c);
  *pc=c; *pb=b;
}

PHP_MINIT_FUNCTION(jenkins)
{
	return SUCCESS;
}

PHP_MSHUTDOWN_FUNCTION(jenkins)
{
	return SUCCESS;
}

PHP_MINFO_FUNCTION(jenkins)
{
	php_info_print_table_start();
	php_info_print_table_header(2, "jenkins hash support", "enabled");
	php_info_print_table_end();
}

PHP_FUNCTION(jenkins_hash)
{
	char *arg = NULL;
	int arg_len;
	php_uint32 hash;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "s",
				  &arg, &arg_len) == FAILURE) {
		return;
	}
	hash = hashlittle(arg, arg_len, 0);

	RETURN_LONG((long) hash);
}

PHP_FUNCTION(jenkins_hash64)
{
	char *arg = NULL;
	int arg_len;
	php_uint32 pc = 0U, pb = 0U;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "s",
				  &arg, &arg_len) == FAILURE) {
		return;
	}
	hashlittle2(arg, arg_len, &pc, &pb);
#if SIZEOF_LONG < 8
	RETURN_LONG((long) pc);
#else
	RETURN_LONG((long)
		    ((unsigned long) pc + (((unsigned long) pb) << 32)));
#endif
}

PHP_FUNCTION(jenkins_hash64_hex)
{
	static const char hex[] = "0123456789abcdef";
	char res[16];
	char *resptr = res;
	char *arg = NULL;
	int arg_len;
	php_uint32 pc = 0U, pb = 0U;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "s",
				  &arg, &arg_len) == FAILURE) {
		return;
	}
	hashlittle2(arg, arg_len, &pc, &pb);
	*resptr++ = hex[(pb >> 28) & 0xf];
	*resptr++ = hex[(pb >> 24) & 0xf];
	*resptr++ = hex[(pb >> 20) & 0xf];
	*resptr++ = hex[(pb >> 16) & 0xf];
	*resptr++ = hex[(pb >> 12) & 0xf];
	*resptr++ = hex[(pb >> 8) & 0xf];	
	*resptr++ = hex[(pb >> 4) & 0xf];
	*resptr++ = hex[pb & 0xf];
	*resptr++ = hex[(pc >> 28) & 0xf];
	*resptr++ = hex[(pc >> 24) & 0xf];
	*resptr++ = hex[(pc >> 20) & 0xf];
	*resptr++ = hex[(pc >> 16) & 0xf];
	*resptr++ = hex[(pc >> 12) & 0xf];
	*resptr++ = hex[(pc >> 8) & 0xf];	
	*resptr++ = hex[(pc >> 4) & 0xf];
	*resptr = hex[pc & 0xf];
	
	RETURN_STRINGL(res, sizeof res, 1);
}
