<?php
/*
 * ----------------------------------------------------------------------------
 * "THE BEER-WARE LICENSE" (Revision 43):
 * <chris@shagged.org> & <freaky@aagh.net> wrote this file.  As long as you
 * retain this notice you can do whatever you want with this stuff. If we 
 * meet some day, and you think this stuff is worth it, you can buy us a
 * beer in return. Chris Elsworth & Thomas Hurst
 * ----------------------------------------------------------------------------
 *
 * $Id: locale.php,v 1.9 2001/09/23 13:07:27 chris Exp $
 */

// XXX: put this in the site .ini?
$langs = array('en', 'fr', 'nl', 'tr');

if (!function_exists('_'))
{
	function _($string)
	{
		return $string;
	}
}
else
{
	putenv('LANG=' . NegotiateLanguage($langs));
	bindtextdomain('ftpstats', 'lib/catalogs');
	textdomain('ftpstats');
}

/* string NegotateLanguage(array $supported[, string $default])
	Negotiate a language in $supported with the browser using Accept-Language: {{{
*/
function NegotiateLanguage($supported, $default = FALSE)
{
	if (isset($GLOBALS['HTTP_SERVER_VARS']['HTTP_ACCEPT_LANGUAGE']))
	{
		$accepted = split(',[[:space:]]*', $GLOBALS['HTTP_SERVER_VARS']['HTTP_ACCEPT_LANGUAGE']);
		if (!$accepted) $accepted = array();
	}
	else
	{
		$accepted = array();
	}

	$supportedAccepted = array();

	foreach ($accepted as $lang)
	{
		if (eregi('^([a-z]+)-?[a-z]*;[[:space:]]*q=([0-9\.]+)', $lang, $res))
		{
			$weight = (int) ($res[2]*10);
			$lang = $res[1];
		}
		else
		{
			eregi('([a-z]+)', $lang, $res) and $lang = $res[1];
			$weight = 10;
		}

		if (in_array($lang, $supported))
		{
			$supportedAccepted[$weight][] = $lang;
		}
	}

	// We now have all accepted and supported languages indexed by weight
	// Pick out the first highest weighted one we have
	ksort($supportedAccepted, SORT_NUMERIC);
	$best = end($supportedAccepted);

	if (is_array($best))
	{
		return $best[0];
	}
	else
	{
		if ($default === FALSE)
		{
			return $supported[0];
		}
		else
		{
			return $default;
		}
	}
} // }}}

?>
