<?php
/*
 * ----------------------------------------------------------------------------
 * "THE BEER-WARE LICENSE" (Revision 43):
 * <chris@shagged.org> & <freaky@aagh.net> wrote this file.  As long as you
 * retain this notice you can do whatever you want with this stuff. If we
 * meet some day, and you think this stuff is worth it, you can buy us a
 * beer in return. Chris Elsworth & Thomas Hurst
 * ----------------------------------------------------------------------------
 */

require_once 'lib/Conf.php';
require_once 'functions.php';
require_once 'lib/locale.php';
require_once 'lib/Timer.php';

ob_start();

$V="v0.8.7";


$CONF = new Conf;
$CONF->load('lib/.htConf.ini');

$DB = mysql_pconnect(	$CONF->get('DB', 'Host'),
			$CONF->get('DB', 'User'),
			$CONF->get('DB', 'Pass'));

mysql_select_db($CONF->get('DB', 'Data'));

?>
<?php

// common functions that are used everywhere

function fs_Header($title, $subtitle) // {{{
{
global $PHP_SELF, $CONF;
// show top of page stuff - the CSS needs to be moved into a .css file?
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<link rel="stylesheet" href="lib/style.css">
<title>ftpStats</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
</head>
<body bgcolor="<?php print $CONF->get('HTML','bgcolor')?>"
         text="<?php print $CONF->get('HTML','text')?>"
         link="<?php print $CONF->get('HTML','link')?>">
<table border="0" align="center" cellspacing="0" cellpadding="0" width="100%">
  <tr>
    <td valign="top">
      <H1><img src="images/logo.gif" alt=""><font color="<?print $CONF->get('HTML', 'table_data')?>"> <?php print $title ?></font></H1>
      <H2><?php print $subtitle ?></H2>
    </td>
    <td width="90" valign="top">
      <div align="right">
        <p align="right">&lt; <a href="http://www.shagged.org/ftpstats/help.php"><b><?print _("Help")?></b></a> &gt;</p>
        <p align="right">&lt; <a href="http://www.shagged.org/ftpstats/about.php"><b><?print _("About")?></b></a> &gt;</p>
      </div>
    </td>
  </tr>
  <tr>
    <td valign="top" colspan="2">
      <div align="center">
        &lt; <a href="<? print "index.php"?>"><b><?print _("Index") ?></b></a> &gt;
        &lt; <a href="<? print (strstr($PHP_SELF, "index.php") ?
	"display.php" : fs_URL($args, DROP_ALL)) ?>"><b><?print _("Userlist")?></b></a> &gt;
      </div>
        <HR>
    </td>
  </tr>
</table>
<?php
} // }}}
function fs_Footer() // {{{
{
	global $V;
?>
<table border="0" align="center" cellspacing="0" cellpadding="0"
width="100%">
  <tr>
    <td> 
      <div align="left"><font size="-1"><i>ftpStats</i> <?php print $V ?> [<a href="http://www.shagged.org/ftpstats/"><b>http://www.shagged.org/ftpstats</b></a>]</font></div>
    </td>
    <td width="360"> 
      <div align="right"><font size="-1"><i>August 2001, Chris Elsworth</i>
      &lt;<a href="mailto:chris@shagged.org"><b>chris@shagged.org</b></a>&gt;</font></div>
    </td>
  </tr>
</table>
<?php
} // }}}

define('DROP_ALL', 0);
function fs_URL($new_args, $drop="") // {{{
{
	// construct an URL from the current URL, adding array $new_args,
	// and dropping those in array drop

	global $PHP_SELF, $HTTP_GET_VARS;

	// If we're not dropping everything ($drop=DROP_ALL) then populate
	// $new_args with existing variables
	if ($drop != DROP_ALL)
	{
		foreach ($HTTP_GET_VARS AS $key => $value)
		{
			$keep_this = TRUE; // default to true
			if ($drop)
			{
				foreach($drop AS $foo => $drop_key)
				{
					if ($drop_key == $key)
						$keep_this = FALSE;
				}
			}
			if ($keep_this) $new_args[] = "$key=$value";
		}
	}

	// build up URL with contents of $new_args
	$url  = $PHP_SELF;
	$url .= "?" . $new_args[0];

	for ($i = 1 ; $i < count ($new_args) ; $i++)
		$url .= "&" . $new_args[$i];

	return $url;
} // }}}

function query_took_seconds($seconds) // show how long a query took {{{
{
	global $CONF;
?>
        <table align="center" class="userList" cellspacing="0" cellpadding="0" width="300">
          <tr>
            <td align="center"><? printf (_("Query took %0.4f seconds\n"), $seconds)?></td>
          </tr>
        </table> <BR>
<?php
}
// }}}

function show_pretty_bytes($number, $dp) // print out a nicely formatted byte number {{{
{
	if (!$dp) $dp = 2;
	if ($number > 1073741824)
		print number_format(($number / 1073741824), $dp) . " GB";
	elseif ($number > 1048576)
		print number_format(($number / 1048576), $dp) . " MB";
	elseif ($number > 1024)
		print number_format(($number / 1024), $dp) . " KB";
	else
		print number_format($number, 0) . " bytes";
} // }}}
function show_pretty_kbytes($number, $dp) // print a nicely formated kbyte number {{{
{
	if (!$dp) $dp = 2;
	if ($number > 1073741824)
		print number_format(($number / 1073741824), $dp) . " TB";
	elseif ($number > 1048576)
		print number_format(($number / 1048576), $dp) . " GB";
	elseif ($number > 1024)
		print number_format(($number / 1024), $dp) . " MB";
	else
		print number_format($number, 0) . " KB";
} // }}}
function show_pretty_secs($number) // print nicely formatted duration {{{
{
	if ($number == 0) print "0s";

	if ($number >= 86400)
	{
		print floor($number/86400) . "d ";
		$number %= 86400;
	}
	if ($number >= 3600)
	{
		print floor($number/3600) . "h ";
		$number %= 3600;
	}
	if ($number >= 60)
	{
		print floor($number/60) . "m ";
		$number %= 60;
	}
	if ($number > 0) print $number . "s";
} // }}}

?>
