<?php

/* LICENSE AND COPYRIGHT {{{
 * Copyright (c) 2001 Thomas Hurst <freaky@aagh.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 * In addition, you are encouraged to inform the author of any use or
 * modifications made to this software.
 *
 *  $Id: Conf.php,v 1.3 2001/08/18 15:24:52 freaky Exp $
 *
 */ // }}}

class Conf // {{{
{
	var $mConf = array();

	function load($filespec) // {{{
	{
		$group = '*** MISSING ***';
		if ($file = file($filespec))
		{
			foreach ($file AS $line)
			{
				if (preg_match('/^\s{0,}([A-Za-z0-9_\.]+)\s{0,}=\s{0,}(.*)$/', $line, $res))
				{
					$this->mConf[$group][$res[1]] = $res[2];
				}
				else if (preg_match('/^\s{0,}\[([A-Za-z0-9_\.]+)\]/', $line, $res))
				{
					$group = $res[1];
				}
			}
		}
	} // }}}

	function get($group, $key) // {{{
	{
		if (isset($this->mConf[$group][$key]))
		{
			return $this->mConf[$group][$key];
		}
		else
		{
			trigger_error("Undefined config value $group::$key");
			return FALSE;
		}
	} // }}}

	function getGroup($group) // {{{
	{
		if (isset($this->mConf[$group]))
		{
			return $this->mConf[$group];
		}
		else
		{
			trigger_error("Undefined config group $group");
			return FALSE;
		}
	} // }}}
}
// }}}

?>
