<?php
/*
 * ----------------------------------------------------------------------------
 * "THE BEER-WARE LICENSE" (Revision 43):
 * <chris@shagged.org> & <freaky@aagh.net> wrote this file.  As long as you
 * retain this notice you can do whatever you want with this stuff. If we 
 * meet some day, and you think this stuff is worth it, you can buy us a
 * beer in return. Chris Elsworth & Thomas Hurst
 * ----------------------------------------------------------------------------
 */

function fs_HourDistribution($dirn, $user, $from, $to) // {{{
{
// this shows an hourly distribution graph for selective records.
// $dirn can be Up or Dn unset for both
// If a $user is supplied, restrict to that user, if unset, do all

global $CONF;
$highlight = $CONF->get('HTML','highlight');
$text = $CONF->get('HTML','text');

list($earliest, $latest) = fs_findFirstLastXfer($user, $from, $to, $dirn);


$hours = range(0,23);
for ($i = 0; $i < 24; $i++)
	$hours[$i] = 0;

$query = "SELECT HOUR(xferTime) AS hour,
	COUNT(*) AS count FROM xfers WHERE 1=1 ";

if ($dirn) $query .= " AND xferDirn='$dirn' ";
$query .= fs_StandardMySQL($user, $from, $to);
$query .= " GROUP BY HOUR(xferTime) ";

$result = mysql_query($query) or die(mysql_error());
while($row=mysql_fetch_array($result))
	$hours[$row['hour']] = $row['count'];

if (!$hours)
{
	?></table><?
	return;
}

// work out scale
if (max($hours) != 0)
	$scale = 180 / max($hours);

?>
<table border="0" align="center" cellspacing="0" cellpadding="0">
  <tr> 
    <td align="center" colspan="24">
	<? fs_DistribHeader($user, $from, $to, $dirn, "h") ?>
      <hr>
    </td>
  </tr>
  <tr>
<?php
foreach ($hours AS $hour => $foo)
{
	$bgcolor = ($bgcolor == $CONF->get('HTML','graph_1')
	? $CONF->get('HTML','graph_2') : $CONF->get('HTML','graph_1'));
?>
    <td width="20" height="200" valign="bottom" align="center" nowrap bgcolor="<?php print $bgcolor?>">
      <font size="1"><?php
      	if (isset($percent))
		printf("%01.1f", $hours[$hour]);
	else
		print $hours[$hour];
	?></font><br>
      <img src="images/vertical_bar.gif" height="<?php print $hours[$hour]*$scale?>" width="10" alt="">
    </td>
<?php } ?>
  </tr>
  <tr> 
    <td colspan="24"><hr></td>
  </tr>
  <tr> 
<? for($i = 0; $i < 24; $i++) { ?>
		<td width="20" align="center">
		  <font size="-1"><?printf ("%02d", $i)?></font>
		</td>
	<? } ?>
  </tr>
</table>

<?php
} // }}}

function fs_DayDistribution($dirn, $user, $from, $to) // {{{
{
// this shows a daily transfer distribution for selective records.

global $CONF, $HTTP_SERVER_VARS;

$highlight = $CONF->get('HTML','highlight');

if (!$to) // no $to = set it to now
	$to = time();	

if (!$from) // no $from = set it to a week ago
	$from = $to - ( 86400 * 7);

?>

<table border="0" align="center" cellspacing="0" cellpadding="0">
  <tr> 
    <td colspan="2" align="center"> 
	<? fs_DistribHeader($user, $from, $to, $dirn, "d") ?>
    </td>
  </tr>
<?php
$days = array();

$query = "SELECT UNIX_TIMESTAMP(xferTime) AS date,
	COUNT(*) AS count FROM xfers WHERE 1=1 ";

if ($dirn) $query .= " AND xferDirn='$dirn'";
$query .= fs_StandardMySQL($user, $from, $to);
$query .= " GROUP BY (CONCAT(YEAR(xferTime),DAYOFYEAR(xferTime))) ";

$result = mysql_query($query) or die(mysql_error());
while($row=mysql_fetch_array($result))
	$days[$row['date']] = $row['count'];

if (!$days)
{
	?></table><?
	return;
}

// work out scale
if (max($days) != 0)
	$scale = 480 / max($days);

$drop = array();
$drop[] = "from";
$drop[] = "to";

foreach ($days as $date => $foo)
{
	$bgcolor = ($bgcolor == $CONF->get('HTML','graph_2')
	? $CONF->get('HTML','graph_1') : $CONF->get('HTML','graph_2'));

	$ymd = date("Y-m-d", $date);
	// set $from and $to for using in <A HREF>
	$last_midnight = date("Y-m-d 00:00:00", $date);
	$from = strtotime($last_midnight);
	$to = $from + 86399;
	$args = array();
	$args[0] = "from=$from";
	$args[1] = "to=$to";
?>
  <tr>
    <td width="100" height="25" align="right" valign="middle" bgcolor="<?php print $bgcolor?>"> 
      <a style="color: white" href="<? print fs_URL($args) ?>"><font size="-1"><?php print date("M jS, Y", $date)?></font></a>&nbsp;
    </td>
    <td width="500" height="25" valign="middle" bgcolor="<?php print $bgcolor?>"><font size="1">
	<img src="images/horizontal_bar.gif" height="10" width="<?php print $days[$date]*$scale?>" alt=""><?php print "&nbsp;" . $days[$date ] ?></font>
    </td>
  </tr>
<?php } ?>
</table>
<?php } // }}}

function fs_DateForm() // show date forms {{{
{
global $HTTP_SERVER_VARS;
$today = getdate();

$drop = array('from', 'to');
//$drop[] = "from";
//$drop[] = "to";

$months = array ("", "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul",
	"Aug", "Sep", "Oct", "Nov", "Dec");
?>
<form method="post" action="<?php print $HTTP_SERVER_VARS['REQUEST_URI']?>">
  <table border="0" cellspacing="1" cellpadding="0" align="center">
    <tr> <!-- From fields {{{ -->
      <td align="right"><font size="-1"><?print _("From")?> (DD-MMM-YYYY): </font></td>
      <td><font size="-1"> 
        <input type="text" name="f-day" size="3" value=<?php print $today['mday']?>>

        - 
        <select size="1" name="f-month"> <!-- show months {{{ -->
<?php
for($i = 1 ; $i <= 12 ; $i++)
{
	printf ("<option value=\"%02d\" ", $i);
	if ($today['mon'] == $i)
		print "SELECTED='SELECTED'";
	print ">" . $months[$i] . "</option>\n";
}
?>
        </select> <!-- }}} -->
        - 
        <select size="1" name="f-year">
<?php	list($min, $max) = fs_GetMinMaxYear();	
	$years = range ($min,$max);

	foreach ($years AS $year)
		print "<option value=\"$year\">$year</option>";
?>
        </select>
        </font></td>
      <td><font size="-1">&nbsp;(HH:MM): </font></td>
      <td><font size="-1">
        <input type="text" name="f-hour" size="3" value="00">
        : 
        <input type="text" name="f-min" size="3" value="00">
      </font></td>
      <td rowspan="2" align="right" width="120">
        <input type="submit" name="daterange" value="Do it!">
	<input type="reset" name="Reset" value="Reset">
      </td>
    </tr> <!-- }}} -->
    <tr> <!-- To fields {{{ -->
      <td align="right"><font size="-1"><?print _("To")?> (DD-MMM-YYYY): </font></td>
      <td><font size="-1"> 
        <input type="text" name="t-day" size="3" value=<?php print $today['mday']?>>
        - 
        <select size="1" name="t-month"> <!-- show months {{{ -->
<?php
for($i = 1 ; $i <= 12 ; $i++)
{
	printf ("<option value=\"%02d\" ", $i);
        if ($today['mon'] == $i)
                print "SELECTED='SELECTED'";
        print ">" . $months[$i] . "</option>\n";
}
?>
        </select> <!-- }}} -->
        - 
        <select size="1" name="t-year">
	<?php	foreach ($years AS $year)
			print "<option value=\"$year\">$year</option>";
	?>
        </select>
        </font></td>
      <td><font size="-1">&nbsp;(HH:MM): </font></td>
      <td><font size="-1"> 
        <input type="text" name="t-hour" size="3" value="23">
        : 
        <input type="text" name="t-min" size="3" value="59">
      </font></td>
    </tr> <!-- }}} -->
  </table>
	<div align="center">&lt; <a href="<?print fs_URL($args, $drop)?>"><b><?print _("Remove From/To Selection")?></b></a> &gt;</div>
</form>
<?php
}
// }}}

function fs_XferList($ip, $dirn, $file, $limit, $sort, $user, $from, $to, $first, $last, $count) // show list of xferred files {{{
{
	// $file = show only this file
	// $limit = limit table to X entries
	// $sort = header to sort by
	// $from/$to = date ranges
	// $first/$last = current table position

	global $CONF;

	if ($ip) {
		$long = ip2long($ip);
		if ($long < 0) $long += pow(2,32);
	}

	$t_user = $t_time = $t_size = $t_dur = $t_file = $t_dirn = array();

	$query  = "SELECT COUNT(*) AS total FROM xfers WHERE 1=1 ";
	$query .= fs_StandardMySQL($user, $from, $to);
	if ($file) $query .= " AND xferFile = '$file' ";
	if ($dirn) $query .= " AND xferDirn = '$dirn' ";
	if ($long) $query .= " AND xferIP = '$long' ";

	$result = mysql_query($query) or die(mysql_error());
	$row = mysql_fetch_array($result);
	$total = $row['total'];

	if ($total == 0)
	{ ?>
	  <BR<BR><BR>
	  <table border="0" align="center" cellspacing="0" cellpadding="0" width="300">
	    <tr>
	      <td align="center"><? print _("No transfers found.")?></td>
	    </tr>
	  </table>
	<? return;
	}

	$query  = "SELECT Username,UNIX_TIMESTAMP(xferTime),xferDur,
		xferSize,xferFile,xferDirn FROM xfers WHERE 1=1 ";
	$query .= fs_StandardMySQL($user, $from, $to);
	if ($file) $query .= " AND xferFile = '$file' ";
	if ($dirn) $query .= " AND xferDirn = '$dirn' ";
	if ($long) $query .= " AND xferIP = '$long' ";

	// do the sorting and limiting in MySQL - nice and quick :)
	$query .= " ORDER BY ";

	if (substr($sort, -1) == "R")
		$sort_stripped = substr($sort, 0, strlen($sort)-1);
	else
		$sort_stripped = $sort;

	switch ($sort_stripped) {
		case "User": $query .= "Username "; break;
		case "Time": $query .= "xferTime "; break;
		case "Dirn": $query .= "xferDirn "; break;
		case "Size": $query .= "xferSize "; break;
		case "File": $query .= "xferFile "; break;
		case "Speed":
			// this is a special case. To accurately work out
			// the speed we need to discount any transfers with
			// an xferTime < 1 or xferSize < 1
			$query  = "SELECT COUNT(*) AS total
				FROM xfers WHERE xferDur>0 AND xferSize>0";
			$query .= fs_StandardMySQL($user, $from, $to);
			if ($file) $query .= " AND xferFile = '$file' ";
			if ($dirn) $query .= " AND xferDirn = '$dirn' ";
			if ($long) $query .= " AND xferIP = '$long' ";
			$result = mysql_query($query) or die(mysql_error());
			$row = mysql_fetch_array($result);
			$total = $row['total'];

			$query = " SELECT Username,UNIX_TIMESTAMP(xferTime),
			xferDur, xferSize,xferFile,xferDirn FROM xfers WHERE
			xferDur>0 AND xferSize>0";
			$query .= fs_StandardMySQL($user, $from, $to);
			if ($file) $query .= " AND xferFile = '$file' ";
			if ($dirn) $query .= " AND xferDirn = '$dirn' ";
			if ($long) $query .= " AND xferIP = '$long' ";
			$query .= " ORDER BY xferSize/xferDur ";
			break;

		default:
			$query .= "xferTime ";
			$sort = "TimeR"; // this is so the arrow gets added
			break;
	}

	if (substr($sort, -1) == "R")
		$query .= " DESC ";

	if ($first) {
		if ($first >= $total)
			$first = $total - $count;
		else
			$first--; // arrays start at 0, account for this
	}
	else
		$first = 0; //nothing set, start at beginning

	$query .= " LIMIT $first,$count ";

	$x = 0;
	$result = mysql_query($query) or die(mysql_error());
	while ($row=mysql_fetch_array($result)) {
		$t_time[$x] = $row['UNIX_TIMESTAMP(xferTime)'];
		$t_dirn[$x] = $row['xferDirn'];
		$t_user[$x] = $row['Username'];
		$t_dur[$x]  = $row['xferDur'];
		$t_size[$x] = $row['xferSize'];
		$t_file[$x] = $row['xferFile'];
		
		if (($t_dur[$x] == 0) || ($t_size[$x] == 0))
			$speed[$x] =  "N/A"; // can't work out speed, not enough info
		else
			$speed[$x] = $t_size[$x] / $t_dur[$x];

		$x++;
	}

	?><center><font size="-2">
	<?print _("Click a column header to sort by that column.");
	print _("Click [i] for File Information.")?>
	</font></center><?

	fs_TableNavigationHeader($first, $total, $count);

	$args = $drop = array();
?>
<table align="center" class="userList" cellspacing="0" cellpadding="0" width="95%">
  <tr> 
    <th align="left" width="120">&nbsp;<?  fs_SortableHeader($sort, "Time", "Time") ?></th>
    <th align="center" width="40"><? fs_SortableHeader($sort, "Dirn", "Dirn") ?></th>
    <th align="left" width="70">&nbsp;<? fs_SortableHeader($sort, "User", "Username") ?></th>
    <th align="right" width="60"><? fs_SortableHeader($sort, "Speed", "Speed") ?>&nbsp;</th>
    <th align="right" width="80"><? fs_SortableHeader($sort, "Size", "Size") ?>&nbsp;</th>
    <th align="left">&nbsp;<? fs_SortableHeader($sort, "File", "Filename") ?></th>
  </tr>
<?php
if ($count > $x) $count = $x; // if we don't have 15 entries to show, shorten the table
$drop[] = "xferlist"; // forget xferlist if we click on File Info
$drop[] = "showuser"; // forget showuser if required
$drop[] = "first";
$drop[] = "last";
for ($i = 0; $i < $count; $i++)
{ ?>
  <tr> 
    <td width="120"><div align="left">&nbsp;<?php print date("M jS, Y H:i:s", $t_time[$i])?></div></td>
    <td width="40"><div align="center"><?php print $t_dirn[$i]?></div></td>
    <td width="70"><div align="left">&nbsp;<?php print $t_user[$i]?></div></td>
    <td width="60"><div align="right"><?php
	if ($speed[$i] > 1048576) {
		$speed[$i] /= 1048576;
		print number_format($speed[$i], 1) . "M/s";
	}
	elseif ($speed[$i] > 99) {
		$speed[$i] /= 1024;
		print number_format($speed[$i], 1) . "K/s"; 
	}
	else
		print number_format($speed[$i], 1) . "b/s";
	?>&nbsp;</div></td>
    <td width="80"><div align="right"><?php show_pretty_bytes($t_size[$i], 1);?>&nbsp;</div></td>
    <td ><div align="left">&nbsp;<a href="<?
      $args[0] = "file=$t_file[$i]";
      print fs_URL($args, $drop)?>">[i]</a> <? print $t_file[$i] ?></div>
    </td>
  </tr>
<?php } ?>
</table>

<?php
} // }}}

function fs_UserList($sort, $from, $to, $first, $last, $count) // {{{
{
	// show userlist, optional sorting
	global $CONF;

	$users = $down = $up = $dbytes = $ubytes = $ratio = $maxspd =
		$lastxfer = array();

	// find total amount of users in the list
	$query = "SELECT COUNT(DISTINCT Username) AS total FROM xfers
		WHERE 1=1 ";
	$query .= fs_StandardMySQL($user, $from, $to);
	$result = mysql_query($query) or die(mysql_error());
	$row = mysql_fetch_array($result);
	$total = $row['total'];
	
	if ($total == 0)
	{ ?>
	  <BR>
	  <table border="0" align="center" cellspacing="0" cellpadding="0" width="400">
	    <tr>
	      <td align="center"><?print _("No users found who have done transfers in this time period")?></td>
	    </tr>
	  </table>
	<? return;
	}

	$query = "
		SELECT xfers.Username AS Username,
		SUM(IF(xfers.xferDirn='Dn',1,0)) AS downloads,
		SUM(IF(xfers.xferDirn='Dn',xferSize,0)) AS dbytes,
		SUM(IF(xfers.xferDirn='Up',1,0)) AS uploads,
		SUM(IF(xfers.xferDirn='Up',xferSize,0)) AS ubytes,
		MAX(xfers.xferSize/xfers.xferDur) AS maxspd, 
		UNIX_TIMESTAMP(MAX(xfers.xferTime)) AS lastxfer
		FROM xfers WHERE 1=1 ";
	$query .= fs_StandardMySQL($user, $from, $to);
	$query .= " GROUP BY xfers.Username ORDER BY ";

	if (substr($sort, -1) == "R")
		$sort_stripped = substr($sort, 0, strlen($sort)-1);
	else
		$sort_stripped = $sort;

	switch ($sort_stripped) {
		case "User":     $query .= "Username ";                 break;
		case "Down":     $query .= "downloads ";                break;
		case "Up":       $query .= "uploads ";                  break;
		case "DBytes":   $query .= "dbytes ";                   break;
		case "UBytes":   $query .= "ubytes ";                   break;
		case "ratio":    $query .= " ";                         break; // FIXME: ratio is broken
		case "MaxSpd":   $query .= "maxspd ";                   break;
		case "LastXfer": $query .= "lastxfer ";                 break;
		default:         $query .= "Username "; $sort = "User"; break;
	}

	if (substr($sort, -1) == "R")
		$query .= " DESC ";

	if ($first)
	{
		if ($first > $total)
			$first = $total - $count;
		else
			$first--;
	} else
		$first = 0;

	$query .= " LIMIT $first, $count";

	$i = 0;
	$result = mysql_query($query) or die(mysql_error());
	while($row=mysql_fetch_array($result))
	{
		$users[$i] = $row['Username'];
		$user = $users[$i];
		
		$down[$i] = $row['downloads'];
		$dbytes[$i] = $row['dbytes'];

		$up[$i] = $row['uploads'];
		$ubytes[$i] = $row['ubytes'];

		if ($row['downloads'] == 0)
			$ratio[$i] = "0:" . $row['uploads'];
		elseif ($row['uploads'] == 0)
			$ratio[$i] = $row['downloads'] . ":0";
		else
			$ratio[$i] =number_format($row['downloads']/$row['uploads'],1) .  ":1";

		$maxspd[$i] = $row['maxspd'];
		$lastxfer[$i] = $row['lastxfer'];

		$i++;
	}

	$asc = '<img src="' .$CONF->get('HTML', 'ascending'). '">';
	$desc = '<img src="' .$CONF->get('HTML', 'descending'). '">';

	?><center><font size="-2">
	<?print _("Click a column header to sort by that column.");
	print _("Click a Username to jump to Specific Information for that user.")?>
	</font></center>

	<? fs_TableNavigationHeader($first, $total, $count);

	$args = $drop = array();
?>
<table align="center" class="userList" cellspacing="0" cellpadding="0" width="95%">
  <tr> 
    <th width="30" align="right"><?print _("Rank")?>&nbsp;</th>
    <th width="70" align="left">&nbsp;<? fs_SortableHeader($sort, "User", _("Username")) ?></th>
    <th align="right" width="50"><? fs_SortableHeader($sort, "Down", _("Dnloads")) ?>&nbsp;</th>
    <th align="right" width="50"><? fs_SortableHeader($sort, "Up", _("Uploads")) ?>&nbsp;</th>
    <th align="right" width="70"><? fs_SortableHeader($sort, "DBytes", _("Down Bytes")) ?>&nbsp;</th>
    <th align="right" width="70"><? fs_SortableHeader($sort, "UBytes", _("Up Bytes")) ?>&nbsp;</th>
    <th align="center" width="50"><? fs_SortableHeader($sort, "ratio", _("D/U Ratio")) ?></th>
    <th align="right" width="80"><? fs_SortableHeader($sort, "MaxSpd", _("Best Speed")) ?>&nbsp;</th>
    <th align="left">&nbsp;<? fs_SortableHeader($sort, "LastXfer", _("Last Transfer")) ?></th>
  </tr>
<?php $args[0]="";
$drop[]="first"; $drop[]="last";
for ($x = 0 ; $x < $i ; $x++)
{
?>
  <tr> 
    <td width="30"><div align="right"><? print $first+$x+1 ?>.&nbsp;</div></td>
    <td width="70"> 
      <div align="left">&nbsp;<a style="text-decoration: underline; color: white" href="<? print fs_URL($args, $drop) . "&showuser=" .$users[$x]; ?>"><?php print $users[$x]?></a></div>
    </td>
    <td width="50"> <div align="right"><?php print $down[$x] ?>&nbsp;</div> </td>
    <td width="50"> <div align="right"><?php print $up[$x] ?>&nbsp;</div> </td>
    <td width="70"> <div align="right"><?php show_pretty_bytes($dbytes[$x], 2) ?>&nbsp;</div> </td>
    <td width="70"> <div align="right"><?php show_pretty_bytes($ubytes[$x], 2) ?>&nbsp;</div> </td>
    <td width="50"> <div align="center"><?php print $ratio[$x] ?></div> </td>
    <td width="80"> <div align="right"><?php show_pretty_bytes($maxspd[$x], 2)?>/s&nbsp;</div> </td>
    <td> <div align="left">&nbsp;<?print (($lastxfer[$x]) ? date ("M jS, Y H:i:s", $lastxfer[$x]) : "");?></div> </td>
  </tr>
<?php
}
?>
</table>

<?php

} // }}}

function fs_UserInfo($user, $from, $to) // show pretty table with lots of nice info {{{
{
	global $CONF, $HTTP_SERVER_VARS;

	$tble_bg_hdr = $CONF->get('HTML', 'table_bg_header');
	$tble_bg_dta = $CONF->get('HTML', 'table_bg_data');
	$tble_dta = $CONF->get('HTML', 'table_data');
?>
<table align="center" class="userList" cellspacing="0" cellpadding="0">
  <tr> 
    <th width="180" align="right"><? print _("First Logged Transfer")?>&nbsp;</th>
    <td width="130" align="center"> 
      <font color="<?print $tble_dta?>"><?php
	list($earliest, $latest) = fs_findFirstLastXfer($user, $from, $to, "");
	print date("M jS, Y H:i", $earliest);?></font>
    </td>
    <th width="180" align="right">Total Uploads&nbsp;</font></th>
    <td width="130" align="center">
      <font color="<?print $tble_dta?>"><?php
	$query  = "SELECT SUM(IF(xferDirn='Up', 1, 0)) as uploads,
	SUM(IF(xferDirn='Up', xferSize, 0))/1024 as uplk,
	MAX(IF(xferDirn='Up', xferSize, 0)) AS maxup,
	MIN(IF(xferDirn='Up', xferDur, 0)) AS minuptime,
	MAX(IF(xferDirn='Up', xferDur, 0)) AS maxuptime,
	MAX(IF(xferDirn='Up', xferSize/xferDur, 0)) AS maxupspd,
	AVG(IF(xferDirn='Up', xferSize/xferDur, 0)) AS avgupspd,
	SUM(IF(xferDirn='Dn', 1, 0)) as downloads,
	SUM(IF(xferDirn='Dn', xferSize, 0))/1024 as dnk,
	MAX(IF(xferDirn='Dn', xferSize, 0)) AS maxdn,
	MIN(IF(xferDirn='Dn', xferDur, 0)) AS mindntime,
	MAX(IF(xferDirn='Dn', xferDur, 0)) AS maxdntime,
	MAX(IF(xferDirn='Dn', xferSize/xferDur, 0)) AS maxdnspd,
	AVG(IF(xferDirn='Dn', xferSize/xferDur, 0)) AS avgdnspd
	FROM xfers WHERE 1=1 ";
	$query .= fs_StandardMySQL($user, $from, $to);

	$result = mysql_query($query) or die(mysql_error());
	$row=mysql_fetch_array($result);

	$up = $row['uploads'];
	$uplk= $row['uplk'];
	$maxup = $row['maxup'];
	$minuptime = $row['minuptime'];
	$maxuptime = $row['maxuptime'];
	$maxupspd = $row['maxupspd'];
	$avgupspd = $row['avgupspd'];

	$down = $row['downloads'];
	$dnk = $row['dnk'];
	$maxdn = $row['maxdn'];
	$mindntime = $row['mindntime'];
	$maxdntime = $row['maxdntime'];
	$maxdnspd = $row['maxdnspd'];
	$avgdnspd = $row['avgdnspd'];

	print number_format($up);?></font>
    </td>
  </tr>
  <tr> 
    <th width="180" align="right"><? print _("Last Logged Transfer")?>&nbsp;</th>
    <td width="130" align="center">
      <font color="<?print $tble_dta?>"><?php print date("M jS, Y H:i", $latest); ?></font>
    </td>
    <th width="180" align="right"><? print _("Total Downloads")?>&nbsp;</font></th>
    <td width="130" align="center">
      <font color="<?print $tble_dta?>"><?php print number_format($down);?></font>
    </td>
  </tr>
  <tr> 
    <th width="180" align="right"><? print _("Total Bytes Uploaded")?>&nbsp;</th>
    <td width="130" align="center">
      <font color="<?print $tble_dta?>"><?php show_pretty_kbytes($uplk, 2); ?></font>
    </td>
    <th width="180" align="right"><? print _("Largest Upload")?>&nbsp;</th>
    <td width="130" align="center">
      <font color="<?print $tble_dta?>"><?php show_pretty_bytes($maxup, 2); ?></font>
    </td>
  </tr>
  <tr> 
    <th width="180" align="right"><? print _("Total Bytes Downloaded")?>&nbsp;</th>
    <td width="130" align="center">
      <font color="<?print $tble_dta?>"><?php show_pretty_kbytes($dnk, 2); ?></font>
    </td>
    <th width="180" align="right"><? print _("Largest Download")?>&nbsp;</th>
    <td width="130"  align="center">
      <font color="<?print $tble_dta?>"><?php show_pretty_bytes($maxdn, 2); ?></font>
    </td>
  </tr>
</table>
<BR>
<table align="center" class="userList" cellspacing="0" cellpadding="0">
  <tr> 
    <th width="180"  align="right"><? print _("Shortest Upload")?>&nbsp;</th>
    <td width="130"  align="center"> 
      <font color="<?print $tble_dta?>"><?php show_pretty_secs($minuptime); ?></font>
    </td>
    <th width="180"  align="right"><? print _("Longest Upload")?>&nbsp;</th>
    <td width="130"  align="center"> 
      <font color="<?print $tble_dta?>"><? show_pretty_secs($maxuptime); ?></font>
    </td>
  </tr>
  <tr>
    <th width="180"  align="right"><? print _("Shortest Download")?>&nbsp;</th>
    <td width="130"  align="center">
      <font color="<?print $tble_dta?>"><? show_pretty_secs($mindntime); ?></font>
    </td>
    <th width="180"  align="right"><? print _("Longest Download")?>&nbsp;</th>
    <td width="130"  align="center">
      <font color="<?print $tble_dta?>"><? show_pretty_secs($maxdntime); ?></font>
    </td>
  </tr>
  <tr>
    <th width="180"  align="right"><? print _("Best Upload Speed")?>&nbsp;</th>
    <td width="130"  align="center">
      <font color="<?print $tble_dta?>"><? show_pretty_bytes($maxupspd, 2); print "/s"; ?></font>
    </td>
    <th width="180"  align="right"><? print _("Average Upload Speed")?>&nbsp;</th>
    <td width="130"  align="center">
      <font color="<?print $tble_dta?>"><? show_pretty_bytes($avgupspd, 2); print "/s"; ?></font>
    </td>
  </tr>
  <tr>
    <th width="180" align="right"><? print _("Best Download Speed")?>&nbsp;</th>
    <td width="130"  align="center">
      <font color="<?print $tble_dta?>"><? show_pretty_bytes($maxdnspd, 2); print "/s"; ?></font>
    </td>
    <th width="180" align="right"><? print _("Average Download Speed")?>&nbsp;</th>
    <td width="130" align="center">
      <font color="<?print $tble_dta?>"><? show_pretty_bytes($avgdnspd, 2); print "/s"; ?></font>
    </td>
  </tr>
</table>
<?php
} // }}}

function fs_GetMinMaxYear() // get min/max year logged {{{
{
	$query = "SELECT MIN(YEAR(xferTime)) AS min,
		MAX(YEAR(xferTime)) AS max FROM xfers";
	$result = mysql_query($query) or die(mysql_error());
	$row=mysql_fetch_array($result);
	$min = $row['min']; $max = $row['max'];

	return array($min, $max);
} // }}}

function fs_findFirstLastXfer($user, $from, $to, $dirn) // {{{
{
	// Find the first and last xfer (this user) performed (in this
	// direction).

	$query = "SELECT UNIX_TIMESTAMP(MIN(xferTime)) AS first,
	UNIX_TIMESTAMP(MAX(xferTime)) AS last FROM xfers WHERE 1=1 ";
	$query .= fs_StandardMySQL($user, $from, $to);
	if ($dirn) $query .= " AND xferDirn = '$dirn' ";

	$result = mysql_query($query) or die(mysql_error());
	$row=mysql_fetch_array($result);
	return array($row['first'], $row['last']);
} // }}}

function fs_StandardMySQL($user, $from, $to) // commonly used MySQL queries {{{
{
	if ($user) $query = " AND Username='$user' ";
	if ($from) $query .= " AND UNIX_TIMESTAMP(xferTime) > '$from' ";
	if ($to) $query .= " AND UNIX_TIMESTAMP(xferTime) < '$to' ";

	return $query;
} // }}}

function show_from_to($from, $to) // for the header {{{
{
	$who_for ="";
	if ($from) {
		if ($to)
			$who_for .= "<BR>( " . date("M jS, Y H:i:s", $from) .  " to " .  date("M jS, Y H:i:s", $to) . " )";
		else
			$who_for .= " (since " .  date("M jS, Y H:i:s", $from) . ")";
	}
	elseif ($to)
		$who_for .= " (up to " . date("M jS, Y H:i:s", $to) . " )";
	else
		$who_for .= " ("._("all logged dates").")";

	return $who_for;

} // }}}

function fs_LastXfer($user, $from, $to) // return unixtime of last xfer {{{
{
	// find the very last xfer done - skip fs_StandardMySQL because we
	// currently don't need it. Used in index.php
	$query =  "SELECT UNIX_TIMESTAMP(MAX(xferTime)) AS last FROM xfers";
	#$query .= fs_StandardMySQL($user, $from, $to);
	$result = mysql_query($query) or die(mysql_error());
	$row=mysql_fetch_array($result);
	return $row['last'];
} // }}}

function fs_SortableHeader($sort, $type, $pretty) // show column headers in a sortable link {{{
{
	// this function is absolutely horribly laid out. Freaky's template
	// should hopefully clear it up :)
	// $sort = the CURRENT sort column. If this matches $type, we're
	// displaying the currently sorted column so print a directional
	// arrow.
	// $type = the column we're currently displaying
	// $pretty = a string to print for users to klick


	global $CONF;
	?><a style="color: white; text-decoration: underline" href=<? 
	print "\"";

	$args = array();
	$args[0] = "sort=$type" .(strstr($sort, $type . "R") ? "" : "R");
	$drop = array();
	$drop[] = "sort";

	print fs_URL($args, $drop) ."\">". ($pretty ? $pretty : $type) . "</a>";

	if ($sort == $type) // normal
		print "<img src=\"" . $CONF->get('HTML', 'ascending') .
		"\" alt=\"\">";
	elseif ($sort == $type . "R") // reverse
		print "<img src=\"" . $CONF->get('HTML', 'descending') .
		"\" alt=\"\">";

	return $args;

} // }}}

function fs_TableNavigationHeader($first, $total, $count) // draw table containing navigation numbers for userlist/xferlist {{{
{
	global $CONF;
	$args = $drop = array();

	$drop[] = "first";
	$drop[] = "last";

	$last = $first + $count; // current last in list
	if ($last > $total)
		$last = $total;

	$first_of_prev_page = ($first-$count+1 > 0 ? $first-$count+1 : 1);
	$last_of_prev_page = ($first_of_prev_page+$count-1 < $total ?
		$first_of_prev_page+$count-1 : $total);

	$first_of_next_page = ($first+$count+1 < $total ? $first+$count+1 : $total);
	$last_of_next_page = ($first_of_next_page+$count-1 < $total ?
		$first_of_next_page+$count-1 : $total);

	$last_of_last_page = $total;
	$first_of_last_page = ($total-$count+1 > 0 ? $total-$count+1 : 1);

?>
<table border="0" align="center" cellspacing="0" cellpadding="0" width="95%">
  <tr >
    <td height="25" width="370" align="left" bgcolor="<?print $CONF->get('HTML', 'bgcolor')?>">
      <font size="-1">&lt;&lt;[ <b><a href="<? // link for start of list
        $args[0] = "first=1";
        $args[1] = "last=$count";
        print fs_URL($args, $drop)?>"><?print _("FIRST")?> <?print $count?></a></b> ]&nbsp;&nbsp;&lt;[
	<b><a href="<? // link for previous page
        $args[0] = "first=$first_of_prev_page";
        $args[1] = "last=$last_of_prev_page";
        print fs_URL($args, $drop)?>"><?print _("PREV PG")?></a></b> ]&nbsp;&nbsp;[ 
        <b><a href="<? // link for next page
        $args[0] = "first=$first_of_next_page";
        $args[1] = "last=$last_of_next_page";
        print fs_URL($args, $drop)?>"><?print _("NEXT PG")?></a></b> ]&gt;&nbsp;&nbsp;[
        <b><a href="<? // link for last page
        $args[0] = "first=$first_of_last_page";
        $args[1] = "last=$last_of_last_page";
        print fs_URL($args, $drop)?>"><?print _("LAST")?> <?print $count?></a></b> ]&gt;&gt;
      </font>
    </td>
    <form method="post" action="<? print fs_URL($args)?>">
    <td height="25" valign="middle" align="center" bgcolor="<?print $CONF->get('HTML', 'bgcolor')?>">
      <font size="-1">Jump #<input type="text" name="first" size="2"></font>
    </td>
    </form>
    <td height="25" align="right" bgcolor="<?print $CONF->get('HTML', 'bgcolor')?>"><font size="-1"><?
	printf(_("Showing %s to %s of %s"),
		"<font color=\"" . $CONF->get('HTML', 'highlight') ."\">" .
		number_format($first+1) . "</font>" .
		"<font color=\"" . $CONF->get('HTML', 'text') ."\">",

		"</font><font color=\"" . $CONF->get('HTML', 'highlight') .
		"\">" .  number_format($last) . "</font>" .
		"<font color=\"" . $CONF->get('HTML', 'text') ."\">",

		"</font><font color=\"" . $CONF->get('HTML', 'highlight') .
		"\">" .  number_format($total)
	);
      ?></font>
    </td>
  </tr>
</table>
<?
	return $args;
} // }}}

function fs_MonthDistributionTable($limit, $sort, $user, $from, $to, $first, $last) // {{{
{
	// get a list of months which have activity, and display summaries
	// about them

	global $CONF;

	// couple of shortcuts
	$tble_bg_hdr = $CONF->get('HTML', 'table_bg_header');
	$tble_bg_dta = $CONF->get('HTML', 'table_bg_data');

	$month_no = $num_xfers = $bytes = $maxspd = $avgspd = $users = array();

	$query =  "SELECT UNIX_TIMESTAMP(xferTime) AS time,
		COUNT(*) AS num_xfers,
		SUM(xferSize) AS bytes,
		MAX(xferSize/xferDur) AS maxspd,
		AVG(xferSize/xferDur) AS avgspd,
		COUNT(DISTINCT(Username)) AS users 
		FROM xfers WHERE 1=1 ";
	$query .= fs_StandardMySQL($user, $from, $to);
	$query .= " GROUP BY CONCAT(MONTH(xferTime),YEAR(xferTime)) ";

	$query .= " ORDER BY ";

	// default to first entry
	if (!$first) $first = 0;

	if (substr($sort, -1) == "R")
		$sort_stripped = substr($sort, 0, strlen($sort)-1);
	else
		$sort_stripped = $sort;

	switch ($sort_stripped) {
		case "Time":      $query .= " time ";                 break;
		case "Transfers": $query .= " num_xfers ";            break;
		case "Bytes":     $query .= " bytes ";                break;
		case "Users":     $query .= " users ";                break;
		case "MaxSpd":    $query .= " maxspd ";               break;
		case "AvgSpd":    $query .= " avgspd ";               break;
		default:          $query .= " time "; $sort = "Time"; break;
	}

	if (substr($sort, -1) == "R")
		$query .= " DESC ";

	$result = mysql_query($query) or die(mysql_error());
	while($row=mysql_fetch_array($result))
	{
		$month = $row['time'];
		$num_xfers[$month] = $row['num_xfers'];
		$bytes[$month] = $row['bytes'];
		$maxspd[$month] = $row['maxspd'];
		$avgspd[$month] = $row['avgspd'];
		$users[$month] = $row['users'];
		$days_in[$month] = date("t", $row['time']);
	}

	?><center><font size="-2">
	<? print _("Click a column header to sort by that column.");
	print _("Click a month name for more detailed information on that month. ( * = Unique Users )")?>
	</font></center>

<table align="center" class="dataList" cellspacing="0" cellpadding="0">
  <tr> 
    <th rowspan="2" height="50" align="center" width="100"> 
      <div align="left">&nbsp;<?fs_SortableHeader($sort, "Time", "Month")?></div>
    </th>
    <th align="center" colspan="3"><b><?print _("Daily Average")?></b></th>
    <td width="10">&nbsp;</td>
    <th align="center" colspan="3"><b><?print _("Monthly Total")?></b></th>
    <td width="10">&nbsp;</td>
    <th align="center" colspan="2"><b><?print _("Speeds")?></b></th>
  </tr>
  <tr> 
    <th width="70"><div align="right"><?fs_SortableHeader($sort, "Transfers", _("Transfers"))?>&nbsp;</div></th>
    <th width="80"><div align="right"><?fs_SortableHeader($sort, "Bytes", _("Bytes"))?>&nbsp;</div></th>
    <th width="55"><div align="right"><?fs_SortableHeader($sort, "Users", _("Users"))?>*&nbsp;</div></th>
    <td width="10">&nbsp;</td>
    <th width="70"><div align="right"><?fs_SortableHeader($sort, "Transfers", _("Transfers"))?>&nbsp;</div></th>
    <th width="80"><div align="right"><?fs_SortableHeader($sort, "Bytes", _("Bytes"))?>&nbsp;</div></th>
    <th width="55"><div align="right"><?fs_SortableHeader($sort, "Users", _("Users"))?>*&nbsp;</div></th>
    <td width="10">&nbsp;</td>
    <th width="80"><div align="right"><?fs_SortableHeader($sort, "MaxSpd", _("Best Speed"))?>&nbsp;</div></th>
    <th width="80"><div align="right"><?fs_SortableHeader($sort, "AvgSpd", _("Avg Speed"))?>&nbsp;</div></th>
  </tr>
<?$args = array();
foreach ($num_xfers AS $thismonth => $xfer_count)
{ ?>
  <tr> 
    <td width="100" height="25"> 
      <div align="left">&nbsp;<?
        $beginning = strtotime(date("Y-m-1 00:00:00", $thismonth));
	$end = strtotime(date("Y-m-t 23:59:59", $thismonth));
	$args[0] = "from=$beginning";
	$args[1] = "to=$end";
	$args[2] = "serverstats=y";?>
	<a style="color: white; text-decoration: underline" href="<?print fs_URL($args)?>"><?print date("F Y", $thismonth)?></a></div>
    </td>
    <td width="70"><div align="right"><?print number_format($num_xfers[$thismonth]/$days_in[$thismonth])?>&nbsp;</div></td>
    <td width="80"><div align="right"><?print number_format($bytes[$thismonth]/$days_in[$thismonth])?>&nbsp;</div></td>
    <td width="55"><div align="right"><?print number_format($users[$thismonth]/$days_in[$thismonth], 1)?>&nbsp;</div></td>
    <td width="10">&nbsp;</td>
    <td width="70"><div align="right"><?print number_format($num_xfers[$thismonth])?>&nbsp;</div></td>
    <td width="80"><div align="right"><?print number_format($bytes[$thismonth])?>&nbsp;</div></td>
    <td width="55"><div align="right"><?print number_format($users[$thismonth])?>&nbsp;</div></td>
    <td width="10">&nbsp;</td>
    <td width="80"><div align="right"><?show_pretty_bytes($maxspd[$thismonth], 2)?>/s&nbsp;</div></td>
    <td width="80"><div align="right"><?show_pretty_bytes($avgspd[$thismonth], 2)?>/s&nbsp;</div></td>
  </tr>
<? } ?>
</table>

<?

} // }}}

function fs_MonthDistributionGraph($from, $to) // show graph of the specified month {{{
{
	global $CONF;

	$months = array ("", "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul",
		"Aug", "Sep", "Oct", "Nov", "Dec");

	$xfer_count = $byte_count = array();

	$query =  "SELECT MONTH(xferTime) as time,
		COUNT(*) AS xfer_count,
		SUM(xferSize) AS byte_count FROM xfers
		GROUP BY CONCAT(MONTH(xferTime),YEAR(xferTime))";

	$result = mysql_query($query) or die(mysql_error());
	while($row=mysql_fetch_array($result))
	{
		$xfer_count[$row['time']] = $row['xfer_count'];
		$byte_count[$row['time']] = $row['byte_count'];
	}

// work out scale
if (!$xfer_count)
	return;

if (max($xfer_count) != 0)
	$scale = 130 / max($xfer_count);

?>
<table border="0" align="center">
<tr>
  <td>
    <table border="0" align="center">
      <tr> 
        <td colspan="12" align="center">
	  <?print _("Number of Transfers per Month")?>
	  <hr>
	</td>
      </tr>
      <tr valign="bottom"> 
<?for ($i = 1; $i <= 12 ; $i++)
{
        $bgcolor = ($bgcolor == $CONF->get('HTML','graph_1')
        ? $CONF->get('HTML','graph_2') : $CONF->get('HTML','graph_1'));
?>
        <td width="20" height="150" bgcolor="<?print $bgcolor ?>"> 
      <div align="center"><font size="-2"><?print $xfer_count[$i]?></font><BR>
	<img src="images/vertical_bar.gif" height="<?php print $xfer_count[$i]*$scale?>" width="10" alt=""></div>
        </td>
<? } ?>
      </tr>
      <tr> 
        <td colspan="12"><hr></td>
      </tr>
      <tr> 
<?
for ($i = 1; $i <= 12; $i++)
{
	?><td width="20" align="center">
	<font size="-1"><?print $months[$i]?></font></td><?
}
?>
      </tr>
    </table>
  </td>
  <td width="30">&nbsp;</td>
  <td>
  <table border="0" align="center">
    <tr>
      <td colspan="12" align="center">
        <?print _("Bytes Transferred per Month")?>
	<hr>
      </td>
    </tr>
    <tr valign="bottom"> 
<?
if (!$byte_count)
        return;
        
if (max($byte_count) != 0)
        $scale = 125 / max($byte_count);

for ($i = 1; $i <= 12 ; $i++)
{
        $bgcolor = ($bgcolor == $CONF->get('HTML','graph_1')
        ? $CONF->get('HTML','graph_2') : $CONF->get('HTML','graph_1'));
?>
    <td width="20" height="150" bgcolor="<?print $bgcolor ?>"> 
	<div align="center"><font size="-2"><?show_pretty_bytes($byte_count[$i], 1)?></font><BR> 
	<img src="images/vertical_bar.gif" height="<?php print $byte_count[$i]*$scale?>" width="10" alt=""></div>
    </td>
<? } ?>
</tr>
  <tr>
    <td colspan="12">
      <hr>
    </td>
  </tr>
   <tr>
<? for ($i = 1; $i <= 12; $i++)
{ ?>
	<td width="20" align="center"><font size="-1"><?print $months[$i]?></font></td>
<? } ?>
  </tr>
</table>
</tr>
</table>

<?

} // }}}

function fs_FileInfo($file) // {{{
{
	global $CONF;
	// security check - if the file being stat'ed isn't in the MySQL
	// table, ignore it. Stops people stat'ing sysfiles.

	if (!$file)
		return;

	$query = "SELECT xferFile FROM xfers WHERE xferFile='$file' LIMIT 1";

	$result = mysql_query($query) or die(mysql_error());

	if (mysql_num_rows($result) == 0)
		return;

	if (!$stat = stat($file))
	{ ?>
		<BR>
		<table border="0" align="center" cellspacing="0" cellpadding="0">
		  <tr>
		    <td>File does not exist on this system (any more?)</td>
		  </tr>
		</table>
		<BR>

		<?
		return;
	}

	$uid = posix_getpwuid($stat[4]);
	$gid = posix_getgrgid($stat[5]);
	$perms = $stat[2];

	$query  = "SELECT MIN(UNIX_TIMESTAMP(xferTime)) as early,
		MAX(UNIX_TIMESTAMP(xferTime)) as late,
		COUNT(*) AS num_xfers
		FROM xfers WHERE xferFile='$file' ";
	$query .= fs_StandardMySQL($user, $from, $to);

	$result = mysql_query($query) or die(mysql_error());

	$row = mysql_fetch_array($result);
	$early = $row['early'];
	$late = $row['late'];
	$num_xfers = $row['num_xfers'];

	$tble_dta = $CONF->get('HTML', 'table_data');

?>
<table border="0" cellpadding="0" cellspacing="0" align="center">
  <tr>
    <td>
      <table width="100%" border="0" cellpadding="0" cellspacing="0">
        <tr> 
          <td height="25"> 
            <div align="center"><font size="-1"><b>File Summary (<?print $file?>)</b></font></div>
          </td>
        </tr>
      </table>
      <table class="userList" align="center" cellpadding="0" cellspacing="0">
        <tr> 
          <th width="100"><div align="right">Last Modified&nbsp;</div></th>
          <td width="220"><font color="<?print $tble_dta?>">&nbsp;<?print date("M jS, Y H:i:s", $stat[9])?>
            </font></td>
          <th width="100"><div align="right">File Size&nbsp;</div></th>
          <td width="140"><font color="<?print $tble_dta?>">&nbsp;<?show_pretty_bytes($stat[7], 2)?></font></td>
        </tr>
        <tr> 
          <th width="100"><div align="right">First Transfer&nbsp;</div></th>
          <td width="220"><font color="<?print $tble_dta?>">&nbsp;<?print date("M jS, Y H:i:s", $early)?></font></td>
          <th width="100"><div align="right">Owner:Group&nbsp;</div></th>
          <td width="140"><font color="<?print $tble_dta?>">&nbsp;<? print $uid['name'] . ":" . $gid['name']?></font></td>
        </tr>
        <tr> 
          <th width="100"><div align="right">Last Transfer&nbsp;</div></th>
          <td width="220"><font color="<?print $tble_dta?>">&nbsp;<?print date("M jS, Y H:i:s", $late)?>
</font></td>
          <th width="100"><div align="right">Permissions&nbsp;</div></th>
          <td width="140"><font color="<?print $tble_dta?>">&nbsp;<?print fs_FilePermissions($perms)?></font></td>
        </tr>
        <tr> 
          <th width="100"><div align="right">&nbsp;</div></th>
          <td width="220">&nbsp;</td>
          <th width="100"><div align="right">Downloads&nbsp;</div></th>
          <td width="140"><font color="<?print $tble_dta?>">&nbsp;<?print number_format($num_xfers)?></font></td>
        </tr>
      </table>
    </td>
  </tr>
</table>
<?


} // }}}

function fs_FilePermissions($mode) // show file permissions from a decimal figure {{{
{
	if(($mode & 0xC000) === 0xC000) // Unix domain socket 
		$type = 's'; 
	elseif(($mode & 0x4000) === 0x4000) // Directory 
		$type = 'd'; 
	elseif(($mode & 0xA000) === 0xA000) // Symbolic link 
		$type = 'l'; 
	elseif(($mode & 0x8000) === 0x8000) // Regular file 
		$type = '-'; 
	elseif(($mode & 0x6000) === 0x6000) // Block special file 
		$type = 'b'; 
	elseif(($mode & 0x2000) === 0x2000) // Character special file 
		$type = 'c'; 
	elseif(($mode & 0x1000) === 0x1000) // Named pipe 
		$type = 'p'; 
	else // Unknown 
		$type = '?';

	/* Determine permissions */ 
	$owner["rd"] = ($mode & 00400) ? 'r' : '-'; 
	$owner["wr"] = ($mode & 00200) ? 'w' : '-'; 
	$owner["ex"] = ($mode & 00100) ? 'x' : '-'; 
	$group["rd"] = ($mode & 00040) ? 'r' : '-'; 
	$group["wr"] = ($mode & 00020) ? 'w' : '-'; 
	$group["ex"] = ($mode & 00010) ? 'x' : '-'; 
	$world["rd"] = ($mode & 00004) ? 'r' : '-'; 
	$world["wr"] = ($mode & 00002) ? 'w' : '-'; 
	$world["ex"] = ($mode & 00001) ? 'x' : '-'; 

	/* Adjust for SUID, SGID and sticky bit */ 
	if( $mode & 0x800 ) 
	$owner["ex"] = ($owner[ex]=='x') ? 's' : 'S'; 
	if( $mode & 0x400 ) 
	$group["ex"] = ($group[ex]=='x') ? 's' : 'S'; 
	if( $mode & 0x200 ) 
	$world["ex"] = ($world[ex]=='x') ? 't' : 'T'; 

	print substr(decoct($mode), 2);
	$mode = sprintf(" (%1s", $type); 
	$mode .= sprintf("%1s%1s%1s", $owner[rd], $owner[wr], $owner[ex]); 
	$mode .= sprintf("%1s%1s%1s", $group[rd], $group[wr], $group[ex]); 
	$mode .= sprintf("%1s%1s%1s)\n", $world[rd], $world[wr], $world[ex]); 

	return $mode;
} // }}}

function show_custom_form() // {{{
{
	global $CONF;
	$d_r = $CONF->get('HTML', 'default_radio');
?>
<form name="custom_query" method="post" action="display.php" enctype="multipart/form-data">
  <p><div align="center"><font size="-1">Show me information about : </font></div></p>
  <table align="center" border="0" cellspacing="0" cellpadding="0">
    <tr valign="middle"> 
      <td width="100" height="30"> 
        <div align="right"> 
          <input type="radio" name="radiobutton" value="users" <?if ($d_r == "users") print "checked" ?>>
        </div>
      </td>
      <td width="100" height="30"><div align="right"><font size="-1">users who have:</font></div></td>
      <td height="30" valign="middle" width="300"> 
        <p> 
          <select name="users_xferdirn">
            <option selected>downloaded</option>
            <option>uploaded</option>
          </select>
          <select name="users_sortdirn">
            <option selected>the most</option>
            <option>the least</option>
          </select>
          <select name="users_files">
            <option selected>files</option>
            <option>bytes</option>
          </select>
        </p>
      </td>
    </tr>
    <tr><td colspan="3" align="center"><font size="-1"><b>OR</b></font></td></tr>
    <tr> 
      <td width="100" height="30"> 
        <div align="right"> 
          <input type="radio" name="radiobutton" value="other" <?if ($d_r == "other") print "checked" ?>>
        </div>
      </td>
      <td width="100" height="30"><div align="right"><font size="-1">the:</font></div></td>
      <td height="30" valign="middle" width="300">
        <select name="sort_option">
          <option selected>biggest</option>
          <option>smallest</option>
          <option>most recent</option>
	  <option>oldest</option>
          <option>fastest</option>
	  <option>slowest</option>
        </select>
        <select name="dirn">
          <option selected>transfers</option>
          <option>downloads</option>
          <option>uploads</option>
        </select>
        </td>
    </tr>
    <tr><td colspan="3" align="center"><font size="-1"><b>OR</b></font></td></tr>
    <tr> 
      <td width="100" height="30"> 
        <div align="right"><font size="-1"> 
          <input type="radio" name="radiobutton" value="files" <?if ($d_r == "files") print "checked" ?>>
          </font></div>
      </td>
      <td width="100" height="30"><div align="right"><font size="-1">this file pattern:</font></div></td>
      <td height="30" valign="middle" width="300"> 
        <input type="text" size="35" name="file_pattern" value="Not operational yet">
      </td>
    </tr>
    <tr><td colspan="3" align="center"><font size="-1"><b>OR</b></font></td></tr>
    <tr> 
      <td width="100" height="30"> 
        <div align="right"><font size="-1"> 
          <input type="radio" name="radiobutton" value="user" <?if ($d_r == "user") print "checked" ?>>
          </font></div>
      </td>
      <td width="100" height="30"><font size="-1"><div align="right">this user:</font></div></td>
      <td height="30" valign="middle" width="300">
        <select name="user_sel">
	<?
		$query = "SELECT DISTINCT Username FROM xfers ORDER BY Username";

		$result = mysql_query($query);
		$row = mysql_fetch_array($result);
		print "<option selected>" . $row['Username'] . "</option>\n";

		while($row = mysql_fetch_array($result))
			print "<option>" . $row['Username'] . "</option>\n";

	?>
        </select>
        </td>
    </tr>
    <tr>
      <td align="center" colspan="4">
	<BR>
	<input type="submit" name="userinfo" value="Go">
      </td>
    </tr>
  </table>
</form>
<?

} // }}}

function calculate_table($from, $to) // {{{
{
	global $CONF;

	if (!$from)
		return "xfers";
	
	// list of tables..
	$result = mysql_list_tables($CONF->get('DB', 'Data'));
	for ($x = 0; $x < mysql_num_rows($result); $x++)
		$tables[$x] = mysql_tablename ($result, $x);
	
	$f = localtime($from, 1);
	$t = localtime($to, 1);

	$f['tm_year'] += 1900; $f['tm_mon'] += 1;
	$t['tm_year'] += 1900; $t['tm_mon'] += 1;

	$f_week = floor($f['tm_yday'] / 7);
	$t_week = floor($t['tm_yday'] / 7);

	// same week but not same day - if we have a weekly table, use that
	if(($f_week == $t_week) && ($f['tm_yday'] != $t['tm_yday']))
	{
		$table_id = "xfers_w".$f_week."_".$f['tm_year'];
		if (in_array($table_id, $tables))
			return $table_id;
	}

	// same year?
	if ($f['tm_year'] == $t['tm_year'])
	{
		if ($f['tm_yday'] == $t['tm_yday']) // same day
		{
			$table_id = "xfers_d".$f['tm_yday']."_".$f['tm_year'];

			if (!in_array($table_id, $tables))
			{	// not found - try for weekly
				$table_id = "xfers_w".$f_week."_".$f['tm_year'];
				if (!in_array($table_id, $tables))
				{	// not found - monthly?
					$table_id = "xfers_m".$f['tm_mon']."_".$f['tm_year'];
					if (!in_array($table_id, $tables))
						// not found - yearly?
						$table_id = "xfers_".$f['tm_year'];
			}	}

		} elseif($f['tm_mon'] == $t['tm_mon']) // same month (dayrange)
		{
			$table_id = "xfers_m".$f['tm_mon']."_".$f['tm_year'];
			if(!in_array($table_id, $tables))
				// not found - try year
				$table_id = "xfers_".$f['tm_year'];

		} else // same year only
			$table_id = "xfers_".$f['tm_year'];
	}

	// fall back to xfers if required
	if (!in_array($table_id, $tables))
		$table_id = "xfers";

	return $table_id;

} // }}}

function fs_IpUserSummary($user, $ip, $sort, $from, $to, $first, $last, $count) // {{{
{
	// Show which IP the given user has used
	global $CONF;
	$results = array();

	$for = ($user ? $user : "everyone");

	$query = "SELECT COUNT(DISTINCT xferIP) AS total FROM xfers WHERE 1=1 ";
	$query .= fs_StandardMySQL($user, $from, $to);
	$result = mysql_query($query) or die(mysql_error());
	$row = mysql_fetch_array($result);
	$total = $row['total'];


	$query =  "SELECT xferIP, COUNT(xferIP) AS count FROM xfers WHERE 1=1 ";
	$query .= fs_StandardMySQL($user, $from, $to);
	$query .= " GROUP BY xferIP ORDER BY ";

	if (substr($sort, -1) == "R")
		$sort_stripped = substr($sort, 0, strlen($sort)-1);
	else
		$sort_stripped = $sort;
	
	switch ($sort_stripped) {
		case "IP":
			$query .= "xferIP ";
			break;
		case "Uses":
			$query .= "count ";
			break;
		default:
			$query .= "xferIP ";
			$sort = "IP";
			break;
	}

	if (substr($sort, -1) == "R")
		$query .= " DESC ";

	if ($first) {
		if ($first >= $total)
			$first = $total - $count;
		else
			$first--; // arrays start at 0, account for this
	}
	else
		$first = 0; //nothing set, start at beginning
	
	$query .= " LIMIT $first,$count ";

	$result = mysql_query($query) or die(mysql_error());
	while ($row=mysql_fetch_array($result)) {
		if ($row['xferIP']) { # ignore blanks
			$long = $row['xferIP'];
			if (($quad = long2ip($long)) == "127.255.255.255") {
				$long -= pow(2,32);
				$quad = long2ip($long);
			}

			$results[$quad] = $row['count'];
			$total_xfers += $row['count'];
		}
	}
?>
<table border="0" align="center" cellspacing="0" cellpadding="0">
  <tr>
    <td height="25"> 
      <div align="center"><b><font size="-1">Remote Address Summary (for <?print $for?>)</font></b></div>
    </td>
  </tr>
  <tr>
    <td><?fs_TableNavigationHeader($first, $total, $count)?>
      <table class="userList" cellspacing="0" cellpadding="0">
        <tr> 
          <th align="left" width="100">&nbsp;<?fs_SortableHeader($sort, "IP", "IP")?></th>
          <th align="left" width="250">&nbsp;Host</th>
          <th width="50"><? fs_SortableHeader($sort, "Uses", "Uses")?></th>
          <th align="left" width="200">&nbsp;Use %</th>
        </tr>
<?
$args = $drop = array();
$drop[] = "ip_summ";
$drop[] = "showuser";
$drop[] = "first";
$drop[] = "last";
$drop[] = "sort";

foreach ($results AS $ip => $count)
{ ?>
        <tr> 
          <td width="100">&nbsp;<font size="-1"><a style="text-decoration: underline; color: white" href="<?$args[0] = "ip=$ip";
	    print fs_URL($args, $drop)?>"><?print $ip?></a></font>
	  </td>
          <td width="250">&nbsp;<font size="-1"><?print gethostbyaddr($ip)?></font></td>
          <td width="50"><div align="center"><font size="-1"><?print $count?></font></div></td>
          <td width="200">&nbsp;<font size="-1"><?print number_format(($count/$total_xfers)*100,1)?></font></td>
        </tr>
<? } ?>
      </table>
    </td>
  </tr>
</table>

<? } // }}}

function fs_IpSummary($user, $ip, $from, $to) // {{{
{
	// Show who's used the given IP

	global $CONF;
	$count = $latest = array();

	$long = ip2long($ip);
	if ($long < 0) $long += pow(2,32);

	$query =  "SELECT DISTINCT Username,
		COUNT(Username) AS count,
		UNIX_TIMESTAMP(MAX(xferTime)) as latest
		FROM xfers WHERE xferIP='$long' ";
	$query .= fs_StandardMySQL($user, $from, $to);
	$query .= " GROUP BY Username ORDER BY Username";

	$result = mysql_query($query) or die(mysql_error());
	while ($row=mysql_fetch_array($result)) {
		$count[$row['Username']] = $row['count'];
		$latest[$row['Username']] = $row ['latest'];
		$total += $row['count'];
	}
?>

<table border="0" align="center" cellspacing="0" cellpadding="0">
  <tr>
    <td height="25"> 
      <div align="center"><b><font size="-1">Remote Address Summary (for <?print $ip?>)</font></b></div>
    </td>
  </tr>
  <tr>
    <td>
      <table class="userList" cellspacing="0" cellpadding="0">
        <tr> 
          <th width="100"><font size="-2">&nbsp;User</font></th>
          <th width="250"><font size="-2">&nbsp;Last Login</font></th>
          <th width="50"><div align="center"><font size="-2">Uses</font></div></th>
          <th width="200">&nbsp;<font size="-2">Use %</font></th>
        </tr>
<?
$args = $drop = array();
$drop[]="ip";

foreach($count AS $user => $foo)
{ ?>
        <tr> 
          <td width="100">&nbsp;<font size="-1"><a style="text-decoration: underline; color: white" href="<?$args[0] = "showuser=$user"; print fs_URL($args, $drop)?>"><?print $user?></a></font></td>
          <td width="250">&nbsp;<font size="-1"><?print date("M jS, Y H:i:s", $latest[$user])?></font></td>
          <td width="50"><div align="center"><font size="-1"><?print $count[$user]?></font></div></td>
          <td width="200">&nbsp;<font size="-1"><?print number_format(($count[$user]/$total)*100,1)?></font></td>
        </tr>
<? } ?>
      </table>
    </td>
  </tr>
</table>

<?
} // }}}

function fs_DistribHeader($user, $from, $to, $dirn, $period) // {{{
{
	// show the header to go above Day/Hour Distribution graphs
	// $period = d for Day, other for Hour

	global $CONF;
	$highlight = $CONF->get('HTML','highlight');
	list($earliest, $latest) = fs_findFirstLastXfer($user, $from, $to, $dirn);

	printf (_("Number of %s by %s for %s"),
		($dirn ? ($dirn=='Up' ? _("Uploads") : _("Downloads")) :
			_("Transfers")),
		($period == "d" ? _("Day") : _("Hour")),
		"<font color=\"$highlight\">" .
		($user ? $user : _("all users")) . "</font>");
	
	?><BR><?
	printf (_("From %s - To %s"),
		"<font color=\"$highlight\">" .
		($from ? date("M jS, Y H:i:s", $from) : _("anytime")) .  "</font>",

		"<font color=\"$highlight\">" .
		($to ? date("M jS, Y H:i:s", $to) : _("anytime")) .  "</font>");

	if (isset($earliest)) {
		?><BR><?
		printf ( _("First %s - Last %s"),
			"<font color=\"$highlight\">" .
			date("M jS, Y H:i:s", $earliest) .  "</font>",

			"<font color=\"$highlight\">" .
			date("M jS, Y H:i:s", $latest) . "</font>" );
	} else
		print "<BR>" . _("No transfers found.");

} // }}}

?>
