#!/usr/bin/perl
#
# Builds messages.po from a set of php files
#

use File::Find;
use strict;

my($filePattern) = '\.(php|phtml|inc)$';
my(%strings);

find({ wanted => \&ExtractStrings, no_chdir => 1}, @ARGV);

open XGETTEXT, '| xgettext --keyword=_ -C --no-location -';
foreach my $string (sort keys %strings)
{
	# FIXME We don't handle escaping if the string was '..'
	print XGETTEXT "_(\"$string\")\n";
}
close XGETTEXT;

sub ExtractStrings
{
	my($file) = $File::Find::name;

	if ($file =~ /$filePattern/o)
	{
		print "Scanning $file...\n";
		my $count = 0;
		my $string = '';

		open FILE, $_ or warn "$_: $!";
		while (my $line = <FILE>)
		{
			$string .= $line;
		}

		#while ($string =~ s/(gettext|_)\s+\((["'])([^[\\\2][\2]]+)\2\s+\)//)
		#while ($string =~ s/_\("([^"]+)"\)//)
		while ($string =~ s/_\(["']([^'"]+)['"]\)//)
		{
			$count++;
			$strings{$1}++;
		}


		print "$count strings extracted\n";
		close FILE;

	}
}
