/* ncdbm.h */

#ifndef NCDBM_H
#define NCDBM_H 1

#ifndef NCDBM_INTERNAL_H
typedef struct NcDBMDatum {
	char *dptr;
	int dsize;
} NcDBMDatum;

typedef unsigned int NcDBM_hash32_t;

typedef NcDBM_hash32_t (*NcDBMHashFunction)(const unsigned char *ucp, int dsize);

typedef struct NcDBMFile {
	char magic[8];
	char opaque[632];
} NcDBMFile, *NcDBMFilePtr;
#endif

typedef struct NcDBMIterState {
	NcDBM_hash32_t h, ho;
	int n;
} NcDBMIterState, *NcDBMIterStatePtr;

#define NCDBM_DEFAULT_HSIZE 8191

#define NCDBM_O_RDONLY        000000
#define NCDBM_O_WRONLY        000001
#define NCDBM_O_RDWR          000002
#define NCDBM_O_CREAT         000100
#define NCDBM_O_EXCL          000200
#define NCDBM_O_TRUNC         001000
#define NCDBM_O_SYNC          010000

/* These correspond to the textual descriptions in errno.c. */
typedef enum NcDBMErrno {
	NCDBM_NO_ERR				=  0,
	NCDBM_ERR_MISC				= -1,
	NCDBM_ERR_MEM_HOSED			= -2,
	NCDBM_ERR_OPEN				= -3,
	NCDBM_ERR_NOT_NCDBM			= -4,
	NCDBM_ERR_SEEK				= -5,
	NCDBM_ERR_READ				= -6,
	NCDBM_ERR_WRITE				= -7,
	NCDBM_NOT_FOUND				= -8,
	NCDBM_ERR_ALREADY_EXISTS		= -9,
	NCDBM_ERR_BAD_PARAMETER			= -10,
	NCDBM_ERR_KEY_TOO_LARGE			= -11,
	NCDBM_ERR_NO_MORE_RECORDS		= -12,
	NCDBM_ERR_MALLOC			= -13,
	NCDBM_ERR_RECORD_TOO_LARGE		= -14,
	NCDBM_ERR_LOCK				= -15,
	NCDBM_ERR_FILE_IS_NDBM			= -16,
	NCDBM_ERR_FILE_IS_BDB			= -17,
	NCDBM_ERR_FILE_IS_GDBM			= -18,
	NCDBM_ERR_SUN_C_BUG			= -19,
	NCDBM_ERR_NUM_ERRS			= -20	/* not an error, just how many there are. */
} NcDBMErrno;

typedef enum NcDBMInsertMode {
	NCDBM_INSERT = 0,
	NCDBM_REPLACE
} NcDBMInsertMode;

/* Function prototypes. */

#ifdef __cplusplus
extern "C" {
#endif

#define NcDBM_Fetch NcDBM_Query

NcDBM_hash32_t NcDBM_DefaultHashFunction(const unsigned char *ucp, int dsize);
void NcDBM_SetHashFunction(NcDBMFile *const db, NcDBMHashFunction func);
int NcDBM_Open(NcDBMFile *const db, const char *const dbPathName, const int how, const int mode, const int hsize);
int NcDBM_Close(NcDBMFile *const db);
int NcDBM_Query(NcDBMFile *const db, const NcDBMDatum key, NcDBMDatum *const content);
int NcDBM_Exists(NcDBMFile *const db, const NcDBMDatum key);
int NcDBM_Insert(NcDBMFile *const db, NcDBMDatum key, NcDBMDatum content, NcDBMInsertMode flags);
int NcDBM_ExclusiveLock(NcDBMFile *const db, int lockmode);
int NcDBM_Delete(NcDBMFile *const db, const NcDBMDatum key);
int NcDBM_NextKey(
	NcDBMFile *const db,
	NcDBMDatum *const nxtkey,
	NcDBMDatum *const content,
	NcDBMIterState *itp);
int NcDBM_FirstKey(
	NcDBMFile *const db, 
	NcDBMDatum *const firstkey, 
	NcDBMDatum *const content,
	NcDBMIterState *const itp);
const char *NcDBM_Strerror(int e);
#ifdef __cplusplus
}
#endif

#endif	/* NCDBM_H */
