/* errno.c */

#ifdef HAVE_CONFIG_H
#	include "config.h"
#elif defined(WIN32)
#	include "config.h.win32"
#	include <windows.h>
#	include <io.h>
#endif

#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#	include <sys/types.h>
#endif

#ifdef HAVE_FCNTL_H
#	include <fcntl.h>
#endif

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stddef.h>
#include <ctype.h>
#include <errno.h>

#include "internal.h"
#include "ncdbm.h"

static const char *const gNcDBMErrors[] = {
	"no error",
	"misc error",
	"specified library datastructure is corrupt",
	"open failed",
	"this is not a NcDBM database",
	"seek error",
	"read error",
	"write error",
	"Item not found",
	"key field already exists",
	"bad parameter",
	"key too large",
	"no more records",
	"malloc failed",
	"record too large",
	"could not acquire file lock",
	"cannot use NDBM databases",
	"cannot use Berkeley DB databases",
	"cannot use GDBM databases",
	"misaligned structure",
	NULL
};

const char *
NcDBM_Strerror(int e)
{
	if ((e > 0) || (e <= NCDBM_ERR_NUM_ERRS))
		e = NCDBM_ERR_MISC;
	e = -e;
	return gNcDBMErrors[e];
}	/* NcDBM_Strerror */
