/* internal.h */

#ifndef NCDBM_INTERNAL_H
#define NCDBM_INTERNAL_H 1

#define NCDBM_MAGIC_STR	"_NcDBM_"
#define NCDBM_MAGIC_INT	0x034c2434
#define GDBM_MAGIC_INT1	0x13579ace
#define GDBM_MAGIC_INT2	0xce9a5713
#define GDBM_MAGIC_STR "GDBM"
#define BDB_MAGIC_INT1	0x00061561
#define BDB_MAGIC_INT2	0x61160600
#define BDB_MAGIC_INT3	0x00053162
#define BDB_MAGIC_INT4	0x62310500

#define NCDBM_MAX_KEY_SIZE 255
#define NCDBM_KEY_PREFIX_SIZE 16

#define NcDBM_int32_t int
#define NcDBM_uint32_t unsigned int

typedef NcDBM_int32_t NcDBM_off_t;

typedef NcDBM_uint32_t NcDBM_hash32_t;

#if (defined(WIN32) || defined(_WINDOWS)) && (!defined(windows))
#	define windows 1
#elif !defined(unix)
#	define unix 1
#endif

#ifdef windows
#	define off_t long
#	define access _access
#	ifndef F_OK
#		define F_OK 00
#	endif
#	ifndef strcasecmp
#		define strcasecmp stricmp
#		define strncasecmp strnicmp
#	endif
#endif

typedef NcDBM_hash32_t (*NcDBMHashFunction)(const unsigned char *ucp, int dsize);

typedef struct NcDBMDatum {
	char *dptr;
	int dsize;
} NcDBMDatum;

#ifdef NO_PACKING
#	define PACKED
#	define ALIGN2
#	define ALIGN4
#else
#	ifdef WIN32
#		pragma pack(push, 1)
#	endif
#	if (defined(__GNUC__)) && (__GNUC__ >= 2)
#		define ALIGN2 __attribute__ ((aligned (2)))
#		define ALIGN4 __attribute__ ((aligned (4)))
#		define PACKED __attribute__ ((packed))
#	endif
#endif

#ifndef PACKED
#	define PACKED
#endif

#ifndef ALIGN2
#	define ALIGN2
#endif

#ifndef ALIGN4
#	define ALIGN4
#endif

/* NOTE: These structures need to be represented exactly as-is,
 * with no implicit pad-bytes.  It is read directly from
 * media and padding would screw up the field data.
 *
 * On Windows we use #pragma pack to do this, and on UNIX
 * we use GCC's syntax (or another compiler and it's options).
 *
 */

typedef struct NcDBMFileHeader {
	char magic[8]				PACKED	;
	NcDBM_int32_t reserved[2]		PACKED	;
	NcDBM_hash32_t prime			PACKED	;
} NcDBMFileHeader;

typedef struct NcDBMRecordHeader {

	/* This field is what limits us to 2 GB (31 bit) addressing
	 * within the database file.  That's OK since this wasn't
	 * designed to handle files even close to that large!
	 */
	NcDBM_off_t nextOffset			PACKED	;

	unsigned short recSize			PACKED	;
	unsigned short keySize			PACKED	;
	char keyPrefix[NCDBM_KEY_PREFIX_SIZE]	PACKED	;
} NcDBMRecordHeader;

/* Unfortunately, have to define this for backwards compatibility. */
#define NO_PACKING 1

#ifndef NO_PACKING
#	ifdef WIN32
#		pragma pack(pop)
#	endif
#endif

typedef struct NcDBMFile {
	char magic[8];
	FILE *fp;
	NcDBMHashFunction func;
	NcDBM_hash32_t prime;
	off_t hOff, dOff;
	int dirty;
	int useLocks;
	int ouseLocks;
#ifdef windows
	int isWinNT;		/* Need to distinguish Win9x and NT for locking */
	char reserved[60];
#else
	char reserved[64];
#endif
	char fbuf[512];
} NcDBMFile, *NcDBMFilePtr;

#ifdef windows
#	define NCDBM_BINARY "b"
#else
#	define NCDBM_BINARY ""
#endif

#ifndef F_RDLCK
#	define F_RDLCK		0
#	define F_WRLCK		1
#	define F_UNLCK		2
#endif

#ifdef NCDBM_DEBUG
#	define NCDBM_TRACE(a) NcDBM_Debug a
#else
#	define NCDBM_TRACE(a) 
#endif

/* Function prototypes. */
NcDBM_hash32_t NcDBM_off_t_to_NcDBM_hash32_t(const off_t a);

int NcDBM_Query0(
	NcDBMFile *const db,
	const NcDBMDatum key,
	NcDBM_hash32_t h,
	NcDBMDatum *const content,
	NcDBMRecordHeader *const rhp,
	off_t *hop,
	off_t *phop,
	NcDBMRecordHeader *prevrhp);

int NcDBM_Delete0(
	NcDBMFile *const db,
	NcDBM_hash32_t h,
	NcDBMRecordHeader *rh,
	off_t prevho,
	NcDBMRecordHeader *prevrh);

int NcDBM_VerifyDatabaseHeader(NcDBMFile *const db, int needseek);
int NcDBM_EmptyDatabase(NcDBMFile *const db, int needseek);
int NcDBM_LockInt(NcDBMFile *const db, int lock, off_t o);
int NcDBM_LockFile(NcDBMFile *const db, int lock);

#ifdef NCDBM_DEBUG
void NcDBM_Debug(const int, const char *const, ...)
#if (defined(__GNUC__)) && (__GNUC__ >= 2)
__attribute__ ((format (printf, 2, 3)))
#endif
;
#endif

#endif	/* NCDBM_INTERNAL_H */
