#!/bin/sh
#
# This script can be used to easily convert NcFTPd's "xfer" log files
# into wu-ftpd's "xferlog" format.
#
# Example:  /bin/sh to_wu.sh < xfer.199807 > xferlog
#

if [ $# -ne 0 ] ; then
	echo "Usage:  cat <NcFTPd xfer log files> | $0" 1>&2
	exit 2
fi

#
# Try "nawk", "gawk", or "mawk", if you get syntax errors running this.
#
AWK="awk"

$AWK '{
	year = substr($0, 1, 4);
	month = substr($0, 6, 2);
	day = substr($0, 9, 2);
	hour = substr($0, 12, 2);
	minute = substr($0, 15, 2);
	second = substr($0, 18, 2);

	for (i=20; i<length($0); i++) {
		if (substr($0, i, 1) == "|")
			break;
	}
	if (substr($0, i, 1) == "|") {
		rest = substr($0, i + 2);
		ltype = substr(rest, 1, 1);
		if ((ltype == "R") || (ltype == "S")) {
			# Note:  only process R and S lines,
			# which are Retrieve and Store (download and upload)
			# log entries.
			#
			printf("%s,%s,%s,%s,%s,%s,%s\n", year, month, day, hour, minute, second, rest);
		}
	}
}' | \
sed 's/,,/, ,/g;s/,,,/, , ,/g;s/,,/, ,/g' | \
$AWK '-F,' 'BEGIN {
	# English dependencies :(
	months[1] = "Jan";
	months[2] = "Feb";
	months[3] = "Mar";
	months[4] = "Apr";
	months[5] = "May";
	months[6] = "Jun";
	months[7] = "Jul";
	months[8] = "Aug";
	months[9] = "Sep";
	months[10] = "Oct";
	months[11] = "Nov";
	months[12] = "Dec";
	days[0] = "Sun";
	days[1] = "Mon";
	days[2] = "Tue";
	days[3] = "Wed";
	days[4] = "Thu";
	days[5] = "Fri";
	days[6] = "Sat";
	# Yuck.  Fast but ugly way to get the weekday.
	w[199801] = "4560123456012345601234560123456";
	w[199802] = "0123456012345601234560123456   ";
	w[199803] = "0123456012345601234560123456012";
	w[199804] = "345601234560123456012345601234 ";
	w[199805] = "5601234560123456012345601234560";
	w[199806] = "123456012345601234560123456012 ";
	w[199807] = "3456012345601234560123456012345";
	w[199808] = "6012345601234560123456012345601";
	w[199809] = "234560123456012345601234560123 ";
	w[199810] = "4560123456012345601234560123456";
	w[199811] = "012345601234560123456012345601 ";
	w[199812] = "2345601234560123456012345601234";
	w[199901] = "5601234560123456012345601234560";
	w[199902] = "1234560123456012345601234560   ";
	w[199903] = "1234560123456012345601234560123";
	w[199904] = "456012345601234560123456012345 ";
	w[199905] = "6012345601234560123456012345601";
	w[199906] = "234560123456012345601234560123 ";
	w[199907] = "4560123456012345601234560123456";
	w[199908] = "0123456012345601234560123456012";
	w[199909] = "345601234560123456012345601234 ";
	w[199910] = "5601234560123456012345601234560";
	w[199911] = "123456012345601234560123456012 ";
	w[199912] = "3456012345601234560123456012345";
	w[200001] = "6012345601234560123456012345601";
	w[200002] = "23456012345601234560123456012  ";
	w[200003] = "3456012345601234560123456012345";
	w[200004] = "601234560123456012345601234560 ";
	w[200005] = "1234560123456012345601234560123";
	w[200006] = "456012345601234560123456012345 ";
	w[200007] = "6012345601234560123456012345601";
	w[200008] = "2345601234560123456012345601234";
	w[200009] = "560123456012345601234560123456 ";
	w[200010] = "0123456012345601234560123456012";
	w[200011] = "345601234560123456012345601234 ";
	w[200012] = "5601234560123456012345601234560";
	w[200101] = "1234560123456012345601234560123";
	w[200102] = "4560123456012345601234560123   ";
	w[200103] = "4560123456012345601234560123456";
	w[200104] = "012345601234560123456012345601 ";
	w[200105] = "2345601234560123456012345601234";
	w[200106] = "560123456012345601234560123456 ";
	w[200107] = "0123456012345601234560123456012";
	w[200108] = "3456012345601234560123456012345";
	w[200109] = "601234560123456012345601234560 ";
	w[200110] = "1234560123456012345601234560123";
	w[200111] = "456012345601234560123456012345 ";
	w[200112] = "6012345601234560123456012345601";
	w[200201] = "2345601234560123456012345601234";
	w[200202] = "5601234560123456012345601234   ";
	w[200203] = "5601234560123456012345601234560";
	w[200204] = "123456012345601234560123456012 ";
	w[200205] = "3456012345601234560123456012345";
	w[200206] = "601234560123456012345601234560 ";
	w[200207] = "1234560123456012345601234560123";
	w[200208] = "4560123456012345601234560123456";
	w[200209] = "012345601234560123456012345601 ";
	w[200210] = "2345601234560123456012345601234";
	w[200211] = "560123456012345601234560123456 ";
	w[200212] = "0123456012345601234560123456012";
	w[200301] = "3456012345601234560123456012345";
	w[200302] = "6012345601234560123456012345   ";
	w[200303] = "6012345601234560123456012345601";
	w[200304] = "234560123456012345601234560123 ";
	w[200305] = "4560123456012345601234560123456";
	w[200306] = "012345601234560123456012345601 ";
	w[200307] = "2345601234560123456012345601234";
	w[200308] = "5601234560123456012345601234560";
	w[200309] = "123456012345601234560123456012 ";
	w[200310] = "3456012345601234560123456012345";
	w[200311] = "601234560123456012345601234560 ";
	w[200312] = "1234560123456012345601234560123";
	w[200401] = "4560123456012345601234560123456";
	w[200402] = "01234560123456012345601234560  ";
	w[200403] = "1234560123456012345601234560123";
	w[200404] = "456012345601234560123456012345 ";
	w[200405] = "6012345601234560123456012345601";
	w[200406] = "234560123456012345601234560123 ";
	w[200407] = "4560123456012345601234560123456";
	w[200408] = "0123456012345601234560123456012";
	w[200409] = "345601234560123456012345601234 ";
	w[200410] = "5601234560123456012345601234560";
	w[200411] = "123456012345601234560123456012 ";
	w[200412] = "3456012345601234560123456012345";
	w[200501] = "6012345601234560123456012345601";
	w[200502] = "2345601234560123456012345601   ";
	w[200503] = "2345601234560123456012345601234";
	w[200504] = "560123456012345601234560123456 ";
	w[200505] = "0123456012345601234560123456012";
	w[200506] = "345601234560123456012345601234 ";
	w[200507] = "5601234560123456012345601234560";
	w[200508] = "1234560123456012345601234560123";
	w[200509] = "456012345601234560123456012345 ";
	w[200510] = "6012345601234560123456012345601";
	w[200511] = "234560123456012345601234560123 ";
	w[200512] = "4560123456012345601234560123456";
	w[200601] = "0123456012345601234560123456012";
	w[200602] = "3456012345601234560123456012   ";
	w[200603] = "3456012345601234560123456012345";
	w[200604] = "601234560123456012345601234560 ";
	w[200605] = "1234560123456012345601234560123";
	w[200606] = "456012345601234560123456012345 ";
	w[200607] = "6012345601234560123456012345601";
	w[200608] = "2345601234560123456012345601234";
	w[200609] = "560123456012345601234560123456 ";
	w[200610] = "0123456012345601234560123456012";
	w[200611] = "345601234560123456012345601234 ";
	w[200612] = "5601234560123456012345601234560";
	w[200701] = "1234560123456012345601234560123";
	w[200702] = "4560123456012345601234560123   ";
	w[200703] = "4560123456012345601234560123456";
	w[200704] = "012345601234560123456012345601 ";
	w[200705] = "2345601234560123456012345601234";
	w[200706] = "560123456012345601234560123456 ";
	w[200707] = "0123456012345601234560123456012";
	w[200708] = "3456012345601234560123456012345";
	w[200709] = "601234560123456012345601234560 ";
	w[200710] = "1234560123456012345601234560123";
	w[200711] = "456012345601234560123456012345 ";
	w[200712] = "6012345601234560123456012345601";
}
{
	year=$1;
	month=int($2);
	day=$3;
	hour=$4;
	minute=$5;
	second=$6;
	retr=$7;	# R for retrieve, S for store
	filename=$8;
	filesize=$9;
	dura=$10;
	kbsec=$11;
	login=$12;
	email=$13;	# may not be valid
	host=$14;
	suffix=$15;	# empty for plain transfers, or ".tar", ".gz",
			# or ".tar.gz" if they used on-the-fly

	if (login == " ")
		login = "unknown";
	if (host == " ")
		host = "unknown";
	if (email == " ")
		email = "unknown";

	yyyymm = int(sprintf("%04d%02d", year, month));
	if (yyyymm > 200712) {
		dayoftheweek = "Xxx";
	} else {
		idayoftheweek = int(substr(w[yyyymm], day, 1));
		dayoftheweek = days[idayoftheweek];
	}

	ctime = sprintf("%s %s %2d %02d:%02d:%02d %04d", dayoftheweek, months[month], day, hour, minute, second, year);

	xfertime = int(dura + 0.5000);
	remotehost = host;
	bytecount = filesize;
	xfile = filename;
	xtype = "b";	# Sorry, transfer type is not logged.

	optionstr = "_";
	if (suffix == ".tar") {
		optionstr == "T";
	} else if (suffix == ".tar.gz") {
		# Note:  Using "C" for gzip and compress both.
		optionstr = "CT";
	} else if (suffix == ".gz") {
		# Note:  Using "C" for gzip and compress both.
		optionstr = "C";
	}

	if (retr == "S") {
		direction = "i";	# In
	} else {
		direction = "o";	# Out
	}

	if ((login == "anonymous") || (login == "")) {
		usertype = "a";
		emailorlogin = email;
	} else {
		usertype = "r";
		emailorlogin = login;
	}

	# No identd user to log
	authenticated = 0;
	authuser = "*";

        printf("%s %d %s %d %s %s ", ctime, xfertime, remotehost, bytecount, xfile, xtype);
        printf("%s %s %s %s ftp %d %s\n", optionstr, direction, usertype, emailorlogin, authenticated, authuser);
}'
exit 0
