#!/usr/bin/perl -w
#
# Copyright (C) 2004, NcFTP Software.
# All Rights Reserved.
#

#############################################################################
#
# How to use this CGI script:
#
# This CGI script can be used to allow system administrators to manipulate
# NcFTPd password databases using a web-based interface instead of running
# "ncftpd_passwd" directly.
#
# For highest security, do not install this script at all and continue to
# manually run "ncftpd_passwd".
#
# (1) Create the file /etc/ftp.passwd.conf.  "chown root" and "chmod 600"
#     the file.  Then edit the file and add a line that contains the complete
#     pathname to the password database, followed by a space, followed by
#     the username the web server runs the CGI as, followed by a comma,
#     followed by the tokens "allow-setuid-root,allow-mkdir".
#     A sample line could look like this assuming the web server user is "web":
#        /usr/local/etc/ncftpd/passwd.db web,allow-setuid-root,allow-mkdir
#
# (2) Create a setuid-root COPY of ncftpd_passwd which is only accessible
#     by your web server user. Example:
#        cp /usr/local/sbin/ncftpd_passwd /usr/local/sbin/web_ncftpd_passwd
#        chown root /usr/local/sbin/web_ncftpd_passwd
#        chgrp web /usr/local/sbin/web_ncftpd_passwd
#        chmod 4710 /usr/local/sbin/web_ncftpd_passwd
#     Then scroll down below and set the variable $ncftpd_passwd to the
#     pathname of the copy of ncftpd_passwd that you just made.
#
# (3) Scroll below and set the $database_file_name variable to the pathname to
#     the NcFTPd password database you wish to edit via web browser.
#
# (4) Move this script to a cgi-bin directory, preferably one only
#     accessible by an https:// URL, since the form data transmits the
#     passwords in cleartext otherwise.  Make sure the script is
#     executable (chmod 755 useradmin.pl) and is accessible by the
#     web user.
#
# (5) Run your web browser and enter in the URL to the script and you're
#     done!
#############################################################################



#############################################################################
# (Skip to the next section)
#############################################################################

use strict;
use CGI qw(:all escapeHTML);
use CGI::Carp qw(fatalsToBrowser);
use FileHandle;
use IPC::Open2;
use IPC::Open3;
use POSIX qw(strftime);

#############################################################################
# Change these!
#############################################################################

my ($ncftpd_passwd)		= "/usr/local/sbin/web_ncftpd_passwd";
my ($database_file_name)	= "/usr/local/etc/ncftpd/passwd.db";
my ($debug) 			= 0;

#############################################################################
# No more user-configurable options below this point.
#############################################################################



$CGI::POST_MAX=1024 * 4;		# max 4K posts
$CGI::DISABLE_UPLOADS = 1;		# no uploads
my ($started_html) 			= 0;
my ($finished_html) 			= 0;
my ($starttime)				= time();
my ($script)				= script_name();
my ($print_cmd_as_comment)		= 0;
my (@ncftpd_passwd_args)		= ();
my ($ncftpd_passwd_cmd) 		= "";
my ($ncftpd_passwd_stdout)		= "";
my ($ncftpd_passwd_stderr)		= "";
my ($ncftpd_passwd_status)		= -1;
my ($log_is_open)			= 0;


sub StartHTML
{
	my ($title) = $_[0] || "";

	if ($finished_html) {
		die("Already wrote a complete HTML page to remote browser.");
	} elsif ($started_html++ == 0) {
		print header(), start_html($title), "\n\n";
		DebugParams() if ($debug);
	} else {
		# Start another section!
		print "\n\n\n<hr>\n<h3>$title</h3>\n\n";
	}
}	# StartHTML




sub EndHTML
{
	if (($started_html > 0) && ($finished_html++ == 0)) {
		print end_html(), "\n";
	}
}	# EndHTML




sub DebugParams
{
	my (@params) = param();
	my ($parm);

	print "\n\n", comment("Cookies and CGI parameters are listed here."), "\n";
	print "<TABLE border>\n";
	print "\t", Tr(th({-bgcolor=>"black"}, "<font color=white>Parameters</font>")), "\n";
	if (scalar(@params) == 0) {
		print "\t", Tr(td({-align=>"center"}, "(none)")), "\n";
	} else {
		print "\t<TR><TD>\n";
		print "\t\t<TABLE cellspacing=\"5\">\n";
		for $parm (@params) {
			$parm = escapeHTML($parm);
			print "\t\t\t", Tr(th({-align=>"right"}, $parm), td(escapeHTML(param($parm)))), "\n";
		}
		print "\t\t</TABLE>\n";
		print "\t</TR></TD>\n";
	}

	print "\t", Tr(th({-bgcolor=>"black"}, "<font color=white>Cookies</font>")), "\n";
	@params = cookie();
	if (scalar(@params) == 0) {
		print "\t", Tr(td({-align=>"center"}, "(none)")), "\n";
	} else {
		print "\t<TR><TD>\n";
		print "\t\t<TABLE cellspacing=\"5\">\n";
		for $parm (@params) {
			print "\t\t\t", Tr(th({-align=>"right"}, $parm), td(escapeHTML(cookie($parm)))), "\n";
		}
		print "\t\t</TABLE>\n";
		print "\t</TR></TD>\n";
	}

	print "</TABLE>\n\n";
}	# DebugParams




sub LsLd
{
	my ($output, @lsitems) = @_;
	local (*LSR, *LSW);
	my ($pid);
	my ($rc) = 0;
	my ($line);
	my ($old_sigpipe);

	$old_sigpipe = $SIG{PIPE};
	$SIG{PIPE} = 'IGNORE';

	$$output = "";
	$pid = open2(\*LSR, \*LSW, "/bin/ls", "-ld", @lsitems);
	if ($pid > 0) {
		close(LSW);
		while (defined($line = <LSR>)) {
			$$output .= $line;
		}
		close(LSR);
		waitpid($pid, 0);
		$rc = 1;
	}

	$SIG{PIPE} = $old_sigpipe;
	return ($rc);
}	# LsLd




sub NotAccessibleThenPrintError
{
	my ($pathname, $ftype) = @_;
	my ($need_r) = 0;
	my ($need_w) = 0;
	my ($need_x) = 0;
	my ($fail) = 0;

	$ftype = "-r--" if (! defined($ftype));
	return (-2) if (($ftype !~ /^[d\-]/) || (! defined($pathname)) || ($pathname eq ""));

	# Coalesce multiple slashes
	$pathname =~ s-/{2,}-/-g;

	# Remove trailing slashes
	$pathname =~ s-/+$--;

	$need_r = 1 if (index($ftype, "r") >= 0);
	$need_w = 1 if (index($ftype, "w") >= 0);
	$need_x = 1 if (index($ftype, "x") >= 0);
	$ftype = substr($ftype, 0, 1);

	$fail++ if (($ftype eq "-") && (! -f $pathname));
	$fail++ if (($ftype eq "d") && (! -d $pathname));
	if (! $fail) {
		#
		# It exists at least.
		#
		$fail++ if (($need_r) && (! -r _));
		$fail++ if (($need_w) && (! -w _));
		$fail++ if (($need_x) && (! -x _));
	}

	return (0) if ($fail == 0);

	StartHTML("Access error");

	if ($ftype eq "-") {
		if ($need_x) {
			print p(b("Error: "), "Cannot run <tt>$pathname</tt>."), "\n";
		} elsif (($need_r) && ($need_w)) {
			print p(b("Error: "), "Cannot access the file <tt>$pathname</tt> for reading and writing."), "\n";
		} elsif ($need_r) {
			print p(b("Error: "), "Cannot access the file <tt>$pathname</tt> for reading."), "\n";
		} elsif ($need_w) {
			print p(b("Error: "), "Cannot access the file <tt>$pathname</tt> for writing."), "\n";
		} else {
			print p(b("Error: "), "Cannot access the file <tt>$pathname</tt>."), "\n";
		}
	} else {
		if (($need_r) && ($need_w) && ($need_x)) {
			print p(b("Error: "), "Cannot access the directory <tt>$pathname</tt> for traversal (execution), listing (reading), creating and removing (writing)"), "\n";
		} elsif (($need_r) && ($need_x)) {
			print p(b("Error: "), "Cannot access the directory <tt>$pathname</tt> for traversal (execution) and listing (reading)"), "\n";
		} elsif (($need_w) && ($need_x)) {
			print p(b("Error: "), "Cannot access the directory <tt>$pathname</tt> for traversal (execution), and creating/removing (writing)"), "\n";
		} else {
			if ($need_x) {
				print p(b("Error: "), "Cannot access the directory <tt>$pathname</tt> for traversal (execution)"), "\n";
			}
			if ($need_r) {
				print p(b("Error: "), "Cannot access the directory <tt>$pathname</tt> for listing (reading)"), "\n";
			}
			if($need_w) {
				print p(b("Error: "), "Cannot access the directory <tt>$pathname</tt> for creating and removing (writing)"), "\n";
			}
		}
	}

	my ($usr) = getpwuid($>) || "UID $>";
	my (@gids) = split(/\s/, $));
	my ($grps) = "";
	my ($gid, $gid1, $grp, $skipgrp, $ngrp);
	$gid1 = "none";

	for $gid (@gids) {
		$skipgrp = 0;
		if ($gid1 eq "none") {
			$gid1 = $gid;
		} else {
			$skipgrp = 1 if ($gid == $gid1);
		}
		if (! $skipgrp) {
			$grp = getgrgid($gid);
			# $grp .= " ($gid)";
			if ($grps eq "") {
				$grps = tt($grp);
			} else {
				$grps .= ", " . tt($grp);
			}
		}
	}

	print p(
		tt(script_name()),
		"is running as user ", tt($usr), " and ",
		scalar(@gids) > 1 ? "groups" : "group",
		"$grps."
	), "\n";

	my ($lsitem) = $pathname;
	my (@lsitems) = ();
	while ($lsitem ne "") {
		push(@lsitems, $lsitem);
		$lsitem =~ s-/[^/]+$--;
	}

	my ($stuff);
	if (LsLd(\$stuff, @lsitems)) {;
		print p(ul(pre(escapeHTML($stuff)))), "\n";
	}

	$fail = 0;
	for $lsitem (reverse(@lsitems)) {
		if (! -e $lsitem) {
			my ($parent_dir) = $lsitem;
			if ($lsitem =~ /^(.*)\//) {
				$parent_dir = $1;
			} else {
				# Don't give us relative paths
				$parent_dir = "..";
			}
			if (($need_w) && (! -w $parent_dir)) {
				print p(b("Reason:"), "parent directory", tt($parent_dir), "is not writable."), "\n";
			} elsif ((($need_r) || ($need_x)) && (! -x $parent_dir)) {
				print p(b("Reason:"), "parent directory", tt($parent_dir), "is not traversable (executable)."), "\n";
			} else {
				print p(b("Reason: "), tt($lsitem), "does not exist."), "\n";
			}
			$fail++;
			last;
		} elsif ((-d $lsitem) && (! -x $lsitem)) {
			print p(b("Reason: "), "directory", tt($lsitem), "is not traversable (executable)."), "\n";
			$fail++;
			last;
		}
	}

	if ($fail == 0) {
		#
		# Then the item exists -- but it earlier failed one of our
		# other tests, so print what that was.
		#
		if ($ftype eq "d") {
			$ftype = "directory";
		} else {
			$ftype = "file";
		}
		stat($pathname);

		
		if (($need_r) && (! -r _)) {
			print p(b("Reason: "), "the $ftype", tt($pathname), "is not readable."), "\n";
		}
		if (($need_w) && (! -w _)) {
			print p(b("Reason: "), "the $ftype", tt($pathname), "is not writable."), "\n";
		}
		if (($need_x) && (! -x _)) {
			print p(b("Reason: "), "the $ftype", tt($pathname), "is not executable."), "\n";
		}
	}

	return (-1);
}	# NotAccessibleThenPrintError




sub RunNcftpd_passwdWithStdin
{
	local (*PIPE_stdin, *PIPE_stdout, *PIPE_stderr);
	my ($done_stdout);
	my ($done_stderr);
	my ($pid, $arg);
	my ($old_sigpipe);
	my ($stdin_data);

	#
	# Create displayable version of argument list
	#
	$stdin_data = shift();
	@ncftpd_passwd_args = @_;
	$ncftpd_passwd_cmd = "$ncftpd_passwd";
	foreach $arg (@ncftpd_passwd_args) {
		if ($arg =~ /[\s\|\;\$\&\*\?\(\()\~\`\\]/) {
			$ncftpd_passwd_cmd .= " '$arg'";
		} elsif ($arg eq "") {
			$ncftpd_passwd_cmd .= " ''";
		} else {
			$ncftpd_passwd_cmd .= " $arg";
		}
	}

	if ($debug) {
		StartHTML("Debug");
		print h3("Command"), "\n";
		print p(ul(pre(escapeHTML($ncftpd_passwd_cmd)))), "\n";
	}

	return (-1) if (NotAccessibleThenPrintError($ncftpd_passwd, "---x") < 0);

	$ncftpd_passwd_status = -1;
	$ncftpd_passwd_stdout = "";
	$ncftpd_passwd_stderr = "";

	$old_sigpipe = $SIG{PIPE};
	$SIG{PIPE} = 'IGNORE';

	$pid = open3(\*PIPE_stdin, \*PIPE_stdout, \*PIPE_stderr,
		$ncftpd_passwd, @ncftpd_passwd_args);

	if ($pid < 2) {
		StartHTML("Error");
		print p(b("Error: "), "Could not run ncftpd_passwd."), "\n";
		print p(b("Reason: "), "open3 failed: $!"), "\n";
		print p("The command attempted was:", "\n");
		print ul(pre(escapeHTML($ncftpd_passwd_cmd))), "\n";
		if (defined($old_sigpipe)) { $SIG{PIPE} = $old_sigpipe; }
		return (-2);
	}

	print PIPE_stdin $stdin_data;
	close(PIPE_stdin);

	$done_stdout = $done_stderr = 0;
	while ((! $done_stdout) || (! $done_stderr)) {
		my ($rin, $rout);
		my ($nread, $data);

		$rin = '';
		if ($done_stdout == 0) {
			vec($rin, fileno(PIPE_stdout), 1) = 1;
		}
		if ($done_stderr == 0) {
			vec($rin, fileno(PIPE_stderr), 1) = 1;
		}

		# Wait forever until data input or EOF is ready
		$rout = $rin;
		$nread = select($rout, undef, undef, undef);

		if (($nread <= 0) || (! defined($rout))) {
			close(PIPE_stdout) unless ($done_stdout);
			close(PIPE_stderr) unless ($done_stderr);
			if (defined($old_sigpipe)) { $SIG{PIPE} = $old_sigpipe; }
			StartHTML("Error");
			print p(b("Error: "), "select() failed."), "\n";
			return (-3);
		}

		if ((! $done_stdout) && (vec($rout, fileno(PIPE_stdout), 1) == 1)) {
			$nread = sysread(PIPE_stdout, $data, 256);
			if ($nread <= 0) {
				close(PIPE_stdout);
				$done_stdout = 1;
			} else {
				$ncftpd_passwd_stdout .= $data;
			}
		}
		
		if ((! $done_stderr) && (vec($rout, fileno(PIPE_stderr), 1) == 1)) {
			$nread = sysread(PIPE_stderr, $data, 256);
			if ($nread <= 0) {
				close(PIPE_stderr);
				$done_stderr = 1;
			} else {
				$ncftpd_passwd_stderr .= $data;
			}
		}
	}

	$ncftpd_passwd_status = ($? >> 8) if (waitpid($pid, 0) > 0);
	if (defined($old_sigpipe)) { $SIG{PIPE} = $old_sigpipe; }

	return (1);
}	# RunNcftpd_passwdWithStdin




sub PrintErrorFooter
{
	if ($ncftpd_passwd_stderr ne "") {
		print "\n\n\n";
		print "<hr>\n" if ($ncftpd_passwd_stdout ne "");
		print "<h3>Error Messages</h3>\n";
		print p(ul(pre(escapeHTML($ncftpd_passwd_stderr)))), "\n";
		# print "\n\n\n<hr><h3>Command Attempted</h3>\n";
		# print p(ul(pre(escapeHTML($ncftpd_passwd_cmd)), p("Exit status code: ", b($ncftpd_passwd_status)))), "\n";
	} elsif ($print_cmd_as_comment) {
		print "\n\n\n<!-- command attempted was:\n$ncftpd_passwd_cmd\nexit status = $ncftpd_passwd_status\n-->\n\n\n";
	}
}	# PrintErrorFooter




sub ProcessForm
{
	my ($user, $oldpass, $newpass, $verpass);
	
	if (! defined(param("user"))) {
		StartHTML("NcFTPd: Password Change Error");
		print "<B>Error</B>: Missing user name.\n";
		return;
	}
	$user = param("user");
	if ($user !~ /^[A-Za-z0-9\_\-\.\@\+\,]+$/) {
		StartHTML("NcFTPd: Password Change Error");
		print "<B>Error</B>: Invalid user name.\n";
		return;
	}
	
	if ((! defined($oldpass = param("oldpass"))) || ($oldpass eq "")) {
		StartHTML("NcFTPd: Password Change Error");
		print "<B>Error</B>: Missing old password.\n";
		return;
	}
	if ($oldpass =~ /[\r\n\0]/) {
		StartHTML("NcFTPd: Password Change Error");
		print "<B>Error</B>: Invalid old password.\n";
		return;
	}
	
	if ((! defined($newpass = param("newpass"))) || ($newpass eq "")) {
		StartHTML("NcFTPd: Password Change Error");
		print "<B>Error</B>: Missing new password.\n";
		return;
	}
	if ($newpass =~ /[\r\n\0]/) {
		StartHTML("NcFTPd: Password Change Error");
		print "<B>Error</B>: Invalid new password.\n";
		return;
	}
	
	if ((! defined($verpass = param("verpass"))) || ($verpass eq "")) {
		StartHTML("NcFTPd: Password Change Error");
		print "<B>Error</B>: Missing new password.\n";
		return;
	}
	if ($verpass ne $newpass) {
		StartHTML("NcFTPd: Password Change Error");
		print "<B>Error</B>: New passwords do not match.\n";
		return;
	}
	if ($oldpass eq $newpass) {
		StartHTML("NcFTPd: Password Change Error");
		print "<B>Error</B>: New password is the same as the old password.\n";
		return;
	}
	
	if ((RunNcftpd_passwdWithStdin("$user\n$oldpass\n$newpass\n$verpass\n", "-f", $database_file_name, "-0") >= 0) && ($ncftpd_passwd_stdout ne "")) {
		StartHTML("NcFTPd: Password Changed");
		print $ncftpd_passwd_stdout;
	} else {
		StartHTML("NcFTPd: Password Change Error");
		PrintErrorFooter();
	}
}	# ProcessForm




sub ShowForm
{
	StartHTML("NcFTPd: Password Change");

	print "<p>\n";
	my ($formurl) = self_url();
	print start_form(-action=>"$formurl?change", -method=>"POST"), "\n";
	my ($op) = "change";
	print hidden(-name=>"op", -value=>$op), "\n";
	
	print "<table>\n";
	print "<tr><td><b>Username</b>:</td><td><input type=text name=\"user\" size=16 maxlength=63></td></tr>\n";
	print "<tr><td><b>Current password</b>:</td><td><input type=password name=\"oldpass\" size=16 maxlength=63></td></tr>\n";
	print "<tr><td><b>New password</b>:</td><td><input type=password name=\"newpass\" size=16 maxlength=63></td></tr>\n";
	print "<tr><td><b>Verify your new password</b>:</td><td><input type=password name=\"verpass\" size=16 maxlength=63></td></tr>\n";
	print "<tr><td></td><td><input value=\"Submit\" type=\"submit\"></td></tr>\n";
	print "</table>\n";
	print end_form(), "\n";
}	# ShowForm




sub Main
{
	my ($op) = "";

	if (! defined(param("op"))) {
		ShowForm();
	} else {
		$op = lc(param("op"));
		if ($op eq "change") {
			ProcessForm();
		} else {
			# Unknown op.
			ShowForm();
		}
	}

	EndHTML();	# Finish our page, if we started writing one
}	# Main

Main();
