#!/bin/sh

#############################################################################
#
# How to use this CGI script:
#
# This CGI script can be used to let regular users change their own
# passwords in a NcFTPd password database without the help of a sysadmin.
# For highest security, do not install this script at all and continue to
# manually set the passwords.
#
# (1) Install "form2env" and set the path below.  "form2env" comes with the
#     NcFTPd Reporting Package, which is included in the "rptbin" directory
#     of the NcFTPd distribution you downloaded.
#
# (2) Create the file /etc/ftp.passwd.conf.  "chown root" and "chmod 600"
#     the file.  Then edit the file and add a line that contains the complete
#     pathname to the password database, followed by a space, followed by
#     the username the web server runs the CGI as, followed by a comma,
#     followed by the token "allow-setuid-root".  A sample line could look
#     like:
#        /usr/local/etc/ncftpd/passwd.db web,allow-setuid-root
#
# (3) Make ncftpd_passwd setuid root.  I.e., "chown root ncftpd_passwd",
#     "chgrp 0 ncftpd_passwd", and "chmod 4711 ncftpd_passwd".  Make sure
#     that the NCFTPD_PASSWD shell variable above is set to the correct
#     path.
#
# (4) Copy this script to a cgi-bin directory, preferably one only
#     accessible by an https:// URL, since the form data transmits the
#     passwords in cleartext otherwise.
#
# For better security, put a copy of ncftpd_passwd in a directory only
# accessible by the web user.  That way the only time the setuid-root
# version of ncftpd_passwd you just made is only used by the web server.
#
#############################################################################

FORM2ENV=/usr/local/bin/form2env
PASSWDDB=/usr/local/etc/ncftpd/passwd.db
NCFTPD_PASSWD=/usr/local/etc/ncftpd/ncftpd_passwd
DEBUG=no

#############################################################################
# No more user-configurable options below this point.
#############################################################################

me=`basename $0`

if [ "$#" -eq 0 ] ; then
	#####################################################################
	# The default action for this script is to display the form HTML page
	#####################################################################

	echo "Content-type: text/html"
	echo ""
	echo "<html>"
	echo "<head>"
	echo "<title>NcFTPd: Password Change</title>"
	echo "</head>"
	echo "<body bgcolor=\"#FFFFFF\">"
	echo "<p>"
	echo "<form action=\"${me}?submit\" method=\"post\">"
	echo "<table>"
	echo "<tr><td><b>Username</b>:</td><td><input type=text name=\"user_ano\" size=16 maxlength=63></td></tr>"
	echo "<tr><td><b>Current password</b>:</td><td><input type=password name=\"oldpass\" size=16 maxlength=63></td></tr>"
	echo "<tr><td><b>New password</b>:</td><td><input type=password name=\"newpass\" size=16 maxlength=63></td></tr>"
	echo "<tr><td><b>Verify your new password</b>:</td><td><input type=password name=\"verpass\" size=16 maxlength=63></td></tr>"
	echo "<tr><td></td><td><input value=\"Submit\" type=\"submit\"></td></tr>"
	echo "</table>"
	echo "</form>"
	echo "<p><address></address></body></html>"
else
	#####################################################################
	# Process the form data
	#####################################################################

	for f in "$FORM2ENV" "$NCFTPD_PASSWD" "$PASSWDDB" ; do
		if [ ! -f "$f" ] ; then
			echo "Content-type: text/html"
			echo ""
			echo "<html>"
			echo "<head>"
			echo "<title>Error</title>"
			echo "</head>"
			echo "<body><p>"
			echo "Missing <TT>$f</TT>, or it is not accessible."
			echo "Check the permissions on the parent directories and the file itself."
			echo "</p></body>"
			echo "</html>"
			exit 1
		fi
	done

	for f in "$FORM2ENV" "$NCFTPD_PASSWD" ; do
		if [ ! -x "$f" ] ; then
			echo "Content-type: text/html"
			echo ""
			echo "<html>"
			echo "<head>"
			echo "<title>Error</title>"
			echo "</head>"
			echo "<body>"
			echo "<p>"
			echo "Cannot execute <TT>$f</TT>."
			echo "</p><pre>"
			/bin/ls -l "$f" 2>&1
			echo "</pre>"
			echo "</body>"
			echo "</html>"
			exit 1
		fi
	done

	if [ "$DEBUG" = yes ] ; then
		/bin/rm -f /tmp/form.env
		echo '-----before-----' > /tmp/form.env
		set >> /tmp/form.env
		eval `tee /tmp/form.input | $FORM2ENV`
		echo '-----after-----' >> /tmp/form.env
		set >> /tmp/form.env
	else
		eval `$FORM2ENV`
	fi

	#####################################################################
	# This set the following environment variables based upon the
	# form response data:
	#
	#       form_user_ano
	#       form_oldpass
	#       form_newpass
	#
	# The naming convention determines how the form data is filtered
	# by the form2env program.  This is important since a common attack
	# on CGI scripts is to try and pass in characters that could cause
	# a command to be run.
	#
	# The "_ao" means alphabetic-only, so every character except A-Z
	# and a-z are deleted from the input.  "_ano" means alpha-numeric
	# only, and "_nosh" means exclude characters that have special
	# meaning to the shell.
	#
	# The "_num" means only 0-9 and . are allowed.  The "_num_02d"
	# means to make sure the result is zero-padded to two digits.
	#####################################################################

	echo "Content-type: text/html"
	echo ""
	echo "<html>"
	echo "<head>"
	echo "<title>NcFTPd: Password Change Results</title>"
	echo "</head>"
	echo "<body bgcolor=\"#FFFFFF\">"
	echo "<p>"

	if [ "$1" != submit ] ; then
		echo "The form processor did not receive a &quot;submit&quot; argument."
	else
		$NCFTPD_PASSWD -f "$PASSWDDB" -0 2>&1 <<EOF
$form_user_ano
$form_oldpass
$form_newpass
$form_verpass
EOF
		echo "</p>"
	fi
	echo "</body>"
	echo "</html>"
fi
