#!/bin/sh
#
# Use this script from the /etc/inittab only!
#
# For example, you might copy this script to /usr/local/etc/ncftpd/ncftpd.sh,
# and then have an /etc/inittab entry that looks like this:
#
# nc:2345:respawn:/usr/local/etc/ncftpd/ncftpd.sh
#

#############################################################################
#
# Choose "verbose mode" by setting NCFTPD_VERBOSITY to "-v" while testing,
# and then set it NCFTPD_VERBOSITY to "" when testing is complete.
#
# NCFTPD_VERBOSITY="-v"
NCFTPD_VERBOSITY=""


#############################################################################
#
# Location of NcFTPd's configuration files.
#
NCFTPD_GENERAL_CF="/usr/local/etc/ncftpd/general.cf"
NCFTPD_DOMAIN_CF="/usr/local/etc/ncftpd/domain.cf"


#############################################################################
#
# Location of the startup log.  This log is used before the logger
# process has been bootstrapped, so the startup log serves as a
# location to log errors that occur before the logger has been
# started.
#
NCFTPD_STARTUP_ERROR_LOG="/usr/local/etc/ncftpd/startup_errors"


#############################################################################
#
# Rather than running $NCFTPD_PROG directly, we set the
# PATH and use a relative path.  This makes it easy to
# spot the "ncftpd" processes in "ps" or "top".
#
# This also implies that you must properly set the variable
# $NCFTPD_PROG_PATH so it contains the directory containing
# $NCFTPD_PROG.
#
NCFTPD_PROG_PATH="/usr/local/sbin:/usr/local/bin:$PATH"
NCFTPD_PROG="/usr/local/sbin/ncftpd"


#############################################################################
#
# The following file is only used for systems using the inittab invocation
# of NcFTPd.  When this file is present, NcFTPd will not launch. Remove this
# file to allow NcFTPd to start again.
#
NCFTPD_STOP_FILE="/usr/local/etc/ncftpd/stop"


#############################################################################
# No more user-configurable options below this point.
#############################################################################

if [ -f "${NCFTPD_PROG}" ] && [ -f "${NCFTPD_GENERAL_CF}" ] && [ -f "${NCFTPD_DOMAIN_CF}" ] ; then
	if [ -f "${NCFTPD_STOP_FILE}" ] ; then
		ix=0
		while [ -f "${NCFTPD_STOP_FILE}" ] ; do
			iy=1
			if [ "$ix" -le 15 ] ; then
				iy=0
			elif [ "$ix" -le 3600 ] && [ `expr "$ix" '%' 60` -eq 0 ]; then
				iy=0
			elif [ `expr "$ix" '%' 3600` -eq 0 ]; then
				iy=0
			fi
			if [ "$iy" -eq 0 ] ; then
				echo "`date '+%Y-%m-%d %H:%M:%S'` Remove this file to allow NcFTPd to start up:" >> "$NCFTPD_STARTUP_ERROR_LOG" 2>&1
				/bin/ls -ld "${NCFTPD_STOP_FILE}" >> "$NCFTPD_STARTUP_ERROR_LOG" 2>&1
			fi
			ix=`expr "$ix" + 3`
			sleep 3
		done
	else
		sleep 5
	fi
	PATH="${NCFTPD_PROG_PATH}"
	export PATH
	exec ncftpd ${NCFTPD_VERBOSITY} "${NCFTPD_GENERAL_CF}" "${NCFTPD_DOMAIN_CF}" > "$NCFTPD_STARTUP_ERROR_LOG" 2>&1
	es="$?"
else
	/bin/ls -l "${NCFTPD_PROG}" "${NCFTPD_GENERAL_CF}" "${NCFTPD_DOMAIN_CF}" > "$NCFTPD_STARTUP_ERROR_LOG" 2>&1
	es="$?"
fi

# If this point is reached, then NcFTPd is not running.  We use "exec"
# above to replace this shell context if it can be run.
#
sleep 30
exit "$es"
