/* simpleget.c */

#include <unistd.h>
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <signal.h>
#include <setjmp.h>

#include <ncftp.h>				/* Library header. */
#include <Strn.h>				/* Library header. */

int
main(int argc, char **argv)
{
	int result;
	int es;
	FTPLibraryInfo li;
	FTPConnectionInfo ci;

	if (argc < 3) {
		fprintf(stderr, "Usage: simpleget <host> <pathname>\n");
		exit(5);
	}

	result = FTPInitLibrary(&li);
	if (result < 0) {
		fprintf(stderr, "simpleget: init library error %d (%s).\n", result, FTPStrError(result));
		exit(4);
	}

	result = FTPInitConnectionInfo(&li, &ci, kDefaultFTPBufSize);
	if (result < 0) {
		fprintf(stderr, "simpleget: init connection info error %d (%s).\n", result, FTPStrError(result));
		exit(3);
	}

	strcpy(ci.host, argv[1]);
	strcpy(ci.user, "anonymous");
	ci.debugLog = stdout;	/* Print the whole FTP conversation. */
	ci.errLog = stderr;

	if ((result = FTPOpenHost(&ci)) < 0) {
		FTPPerror(&ci, result, 0, "Could not open", ci.host);
		es = 2;
	} else {
		/* At this point, we should close the host when
		 * were are finished.
		 */
		result = FTPGetFiles3(
				&ci,
				argv[2],
				".",
				kRecursiveNo,
				kGlobYes,
				kTypeBinary,
				kResumeYes,
				kAppendNo,
				kDeleteNo,
				kTarNo,
				NoConfirmResumeDownloadProc,
				0
			);
		if (result < 0) {
			FTPPerror(&ci, result, kErrCouldNotStartDataTransfer, "Could not get", argv[2]);
			es = 1;
		} else {
			es = 0;
		}

		FTPCloseHost(&ci);
	}

	exit(es);
}	/* main */
