/* monkeys.c
 *
 * This spawns multiple simultaneous instances of the FTP Monkey.
 * I use this to load test an FTP server.
 */

#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include <errno.h>
#include <time.h>
#include <stdlib.h>
#include <signal.h>
#include <setjmp.h>

extern char *optarg;
extern int optind;

static void
Usage(void)
{
	fprintf(stderr, "FTP Monkey Runner, copyright 1996 by Mike Gleason, NCEMRSoft.\n");
	fprintf(stderr, "Usage: ftp_monkeys [flags]\n");

	(void) fprintf(stderr, "\nGeneral Flags:\n\
  -u XX  Use username XX instead of anonymous.\n\
  -p XX  Use password XX with the username.\n\
  -P XX  Use port number XX instead of the default FTP service port (21).\n\
  -a XX  Quit after test has run for XX seconds (default: 7200).\n\
  -D XX  Use remote directory XX as base.\n\
  -n XX  Use XX as the number of monkeys to run (default: 5).\n\
  -h XX  Have monkeys connect to the host XX (default: Localhost).\n");
	(void) fprintf(stderr, "\nExamples:\n\
  ftp_monkeys -n 7 -a 3600 -h 127.0.0.1\n\
  ftp_monkeys -n 25 -a 600\n\
  ftp_monkeys -n 50\n\n");
#ifdef UNAME
	fprintf(stderr, "System: %s.\n", UNAME);
#endif
	exit(2);
}	/* Usage */

int
main(int argc, char **argv)
{
	int logfd;
	char lname[64];
	char seedstr[32];
	char dstr[32];
	char logstr[64];
	int c, f, i, n, seed, t, k;
	time_t now;
	struct tm *ltp;
	int es, status;
	char *a[24];
	const char *aarg, *Darg, *Parg, *uarg, *parg, *host;

	n = 5;
	aarg = "7200";
	Darg = NULL;
	Parg = NULL;
	uarg = NULL;
	parg = NULL;
	host = "Localhost";

	while ((c = getopt(argc, argv, "a:D:P:u:p:n:h:")) > 0) switch(c) {
		case 'a':
			aarg = optarg;
			break;
		case 'D':
			Darg = optarg;
			break;
		case 'P':
			Parg = optarg;
			break;
		case 'u':
			uarg = optarg;
			break;
		case 'p':
			parg = optarg;
			break;
		case 'n':
			n = atoi(optarg);
			break;
		case 'h':
			host = optarg;
			break;
		default:
			Usage();
	}

	time(&now);
	ltp = localtime(&now);
	strftime(dstr, sizeof(dstr), "%m/%d %H:%M:%S", ltp);

	a[0] = (char *) "ftp_monkey";
	a[1] = (char *) "-s";
	a[2] = (char *) "0";
	a[3] = (char *) "-R";
	a[4] = (char *) "-a";
	a[5] = (char *) aarg;
	k = 6;
	if (uarg != NULL) {
		a[k] = (char *) "-u";
		k++;
		a[k] = (char *) uarg;
		k++;
	}
	if (parg != NULL) {
		a[k] = (char *) "-p";
		k++;
		a[k] = (char *) parg;
		k++;
	}
	if (Parg != NULL) {
		a[k] = (char *) "-P";
		k++;
		a[k] = (char *) Parg;
		k++;
	}
	if (Darg != NULL) {
		a[k] = (char *) "-D";
		k++;
		a[k] = (char *) Darg;
		k++;
	}
	a[k] = (char *) host;
	a[++k] = NULL;

	for (seed=0; seed<n; seed++) {
		i = seed;
		sprintf(lname, "out.%02d", i);
		logfd = open(lname, O_WRONLY|O_APPEND|O_TRUNC|O_CREAT, 00666);
		if (logfd < 0) {
			perror(lname);
			exit(1);
		}
		sprintf(seedstr, "%d", seed);
		sprintf(logstr, "%s  seed=%d\n", dstr, seed);
		write(logfd, logstr, strlen(logstr));
		a[2] = seedstr;
		if ((f = fork()) < 0) {
			perror("fork");
			exit(1);
		} else if (f == 0) {
			/* child */
			close(1);
			close(2);
			dup2(logfd, 1);
			dup2(logfd, 2);
			close(logfd);
			execvp(a[0], a);
			perror(a[0]);
			exit(1);
		} else {
			close(logfd);
			printf("%s  ", dstr);
			for (t=0; a[t] != NULL; t++)
				printf("%s ", a[t]);
			printf(" > %s  (pid: %u)\n", lname, f);
			sleep(1);
		}
	}

	while (1) {
		if ((f = wait(&status)) > 0) {
			if (WIFEXITED(status) == 0)
				continue;
			es = WEXITSTATUS(status);

			time(&now);
			ltp = localtime(&now);
			strftime(dstr, sizeof(dstr), "%m/%d %H:%M:%S", ltp);
			fprintf(stdout, "%s  pid=%d exited=%d.\n", dstr, f, es);
		} else if ((f < 0) && (errno != EINTR))
			exit(0);	/* all monkeys done */
	}
}	/* main */
