#ifdef HAVE_CONFIG_H
#	include <config.h>
#endif

#include <unistd.h>
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <signal.h>
#include <setjmp.h>

#include <ncftp.h>				/* Library header. */
#include <Strn.h>				/* Library header. */

jmp_buf gJmp;
int gGotSig = 0;
const char *gOperation = "Could not connect to remote host";

extern char *optarg;
extern int optind;

static void
Usage(void)
{
	fprintf(stderr, "Usage:  getwelcome <host>\n");
	fprintf(stderr, "\nLibrary version: %s.\n", gLibNcFTPVersion + 5);
#ifdef UNAME
	fprintf(stderr, "System: %s.\n", UNAME);
#endif
	exit(2);
}	/* Usage */



static void
Abort(int sigNum)
{
	static int onceOnly = 0;

	if (onceOnly == 0) {
		++onceOnly;
		gGotSig = sigNum;
		longjmp(gJmp, 1);
	}
}	/* Abort */



int
main(int argc, char **argv)
{
	int result, c;
	FTPLibraryInfo li;
	FTPConnectionInfo fi;

	result = FTPInitLibrary(&li);
	if (result < 0) {
		fprintf(stderr, "getwelcome: init library error %d (%s).\n", result, FTPStrError(result));
		exit(3);
	}
	result = FTPInitConnectionInfo(&li, &fi, kDefaultFTPBufSize);
	if (result < 0) {
		fprintf(stderr, "getwelcome: init connection info error %d (%s).\n", result, FTPStrError(result));
		exit(4);
	}

	fi.debugLog = stdout;
	fi.errLog = stderr;
	STRNCPY(fi.user, "anonymous");
	fi.connTimeout = (unsigned int) 20;

	while ((c = getopt(argc, argv, "")) > 0) switch(c) {
		default:
			Usage();
	}
	if (optind > argc - 1)
		Usage();

	STRNCPY(fi.host, argv[optind]);
	if (setjmp(gJmp) == 0) {
		signal(SIGINT, Abort);
		signal(SIGTERM, Abort);
		signal(SIGALRM, Abort);
		if ((result = FTPOpenHost(&fi)) < 0) {
			fprintf(stderr, "getwelcome: cannot open %s: %s.\n", fi.host, FTPStrError(result));
			exit(5);
		}
	} else {
		signal(SIGALRM, SIG_IGN);
		signal(SIGINT, SIG_IGN);
		signal(SIGTERM, SIG_IGN);
		if (gGotSig == SIGALRM) {
			fprintf(stderr, "getwelcome: %s: timed-out.\n", gOperation);
		} else {
			fprintf(stderr, "\ngetwelcome: caught signal, cleaning up...\n");
		}
	}

	if (setjmp(gJmp) == 0) {
		signal(SIGINT, Abort);
		signal(SIGTERM, Abort);
		FTPCloseHost(&fi);
	} else {
		signal(SIGALRM, SIG_IGN);
		signal(SIGINT, SIG_IGN);
		signal(SIGTERM, SIG_IGN);
		if (gGotSig == SIGALRM) {
			fprintf(stderr, "getwelcome: %s: timed-out.\n", gOperation);
		} else {
			fprintf(stderr, "\ngetwelcome: caught signal, cleaning up...\n");
		}
	}
	exit(0);
}	/* main */
