#!/bin/sh
do_install="no"
if [ "x$RAN_FROM_MAKE_ALL" != xyes ] && [ -f ./make.env ] ; then
	echo "* Sourcing ./make.env."
	. ./make.env
fi

home=`pwd`

for dir in zlib* ; do
	if [ -d "$dir" ] ; then
		break
	fi
done
if [ ! -f "$dir/libz.a" ] ; then
	echo "*** Need to build zlib before buliding Gnuplot (missing libz.a)!" 1>&2
	exit 1
fi
zlibdir="$home/$dir"

for dir in libpng* ; do
	if [ -d "$dir" ] ; then
		break
	fi
done
if [ ! -f "$dir/libpng.a" ] ; then
	echo "*** Need to build libpng before buliding Gnuplot (missing libpng.a)!" 1>&2
	exit 1
fi
pngdir="$home/$dir"

cdd=no
tgz=""
for f in gnuplot* ; do
	if [ -d "$f" ] ; then
		cd "$f"
		cdd=yes
		break
	else
		case "$f" in
			*.tar.gz)
				tgz="$f"
				gzip=gzip
				;;
			*.tar.bz2)
				tgz="$f"
				gzip=bzip2
				;;
		esac
	fi
done
if [ "$cdd" = no ] && [ "$tgz" != "" ] ; then
	echo "extracting: $gzip -d -c $tgz | tar xf -"
	$gzip -d -c "$tgz" | tar xf - 
fi
for dir in gnuplot* ; do
	if [ -d "$dir" ] ; then
		foundgnuplotdir=yes
		break
	fi
done
if [ "$foundgnuplotdir" = no ] ; then
	echo "*** Could not change directory to gnuplot source dir!" 1>&2
	exit 1
fi

cd "$dir"
if [ ! -f gnuplot ] ; then
	CPPFLAGS="$CPPFLAGS -I${zlibdir} -I${pngdir}"
	LDFLAGS="$LDFLAGS -L${zlibdir} -L${pngdir}"
	export CPPFLAGS LDFLAGS

	pwd
	./configure \
		--with-png="$pngdir" \
		--without-x \
		--without-linux-vga \
		--without-ggi \
		--without-xmi \
		--without-plot \
		--without-readline \
		--without-gd \
		--without-pdf \
		--without-cwdrc \
		--without-lisp-files \
		--without-row-help \
		--without-tutorial

	status="$?" ; if [ "$status" -ne 0 ] ; then exit "$status" ; fi
	mv config.h config.h.orig
	sed 's/^.*HAVE_STRINGIZE.*/#define HAVE_STRINGIZE 1/;' < config.h.orig > config.h

	mv src/Makefile src/Makefile.orig
	sed 's/-lz -lpng/-lpng -lz/g' < src/Makefile.orig > src/Makefile

	${MAKE-make}
	status="$?" ; if [ "$status" -ne 0 ] ; then exit "$status" ; fi
	if [ -x src/gnuplot ] ; then
		mv src/gnuplot gnuplot
	fi
	if [ ! -x gnuplot ] ; then
		echo "Error compiling gnuplot, exiting." 1>&2
		exit 2
	fi
	strip gnuplot
fi

echo
echo
echo "Gnuplot directory is:"
pwd
echo
/bin/ls -l gnuplot
exit 0
