/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 1

/* If NAME_PREFIX is specified substitute the variables and functions
   names.  */
#define yyparse base_yyparse
#define yylex   base_yylex
#define yyerror base_yyerror
#define yylval  base_yylval
#define yychar  base_yychar
#define yydebug base_yydebug
#define yynerrs base_yynerrs
#define yylloc base_yylloc

/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_COUNT = 265,
     SQL_DATETIME_INTERVAL_CODE = 266,
     SQL_DATETIME_INTERVAL_PRECISION = 267,
     SQL_DESCRIBE = 268,
     SQL_DESCRIPTOR = 269,
     SQL_DISCONNECT = 270,
     SQL_FOUND = 271,
     SQL_FREE = 272,
     SQL_GET = 273,
     SQL_GO = 274,
     SQL_GOTO = 275,
     SQL_IDENTIFIED = 276,
     SQL_INDICATOR = 277,
     SQL_KEY_MEMBER = 278,
     SQL_LENGTH = 279,
     SQL_LONG = 280,
     SQL_NULLABLE = 281,
     SQL_OCTET_LENGTH = 282,
     SQL_OPEN = 283,
     SQL_OUTPUT = 284,
     SQL_REFERENCE = 285,
     SQL_RETURNED_LENGTH = 286,
     SQL_RETURNED_OCTET_LENGTH = 287,
     SQL_SCALE = 288,
     SQL_SECTION = 289,
     SQL_SHORT = 290,
     SQL_SIGNED = 291,
     SQL_SQL = 292,
     SQL_SQLERROR = 293,
     SQL_SQLPRINT = 294,
     SQL_SQLWARNING = 295,
     SQL_START = 296,
     SQL_STOP = 297,
     SQL_STRUCT = 298,
     SQL_UNSIGNED = 299,
     SQL_VAR = 300,
     SQL_WHENEVER = 301,
     S_ADD = 302,
     S_AND = 303,
     S_ANYTHING = 304,
     S_AUTO = 305,
     S_CONST = 306,
     S_DEC = 307,
     S_DIV = 308,
     S_DOTPOINT = 309,
     S_EQUAL = 310,
     S_EXTERN = 311,
     S_INC = 312,
     S_LSHIFT = 313,
     S_MEMPOINT = 314,
     S_MEMBER = 315,
     S_MOD = 316,
     S_MUL = 317,
     S_NEQUAL = 318,
     S_OR = 319,
     S_REGISTER = 320,
     S_RSHIFT = 321,
     S_STATIC = 322,
     S_SUB = 323,
     S_VOLATILE = 324,
     S_TYPEDEF = 325,
     CSTRING = 326,
     CVARIABLE = 327,
     CPP_LINE = 328,
     IP = 329,
     DOLCONST = 330,
     ECONST = 331,
     NCONST = 332,
     UCONST = 333,
     UIDENT = 334,
     IDENT = 335,
     FCONST = 336,
     SCONST = 337,
     BCONST = 338,
     XCONST = 339,
     Op = 340,
     ICONST = 341,
     PARAM = 342,
     TYPECAST = 343,
     DOT_DOT = 344,
     COLON_EQUALS = 345,
     ABORT_P = 346,
     ABSOLUTE_P = 347,
     ACCESS = 348,
     ACTION = 349,
     ADD_P = 350,
     ADMIN = 351,
     AFTER = 352,
     AGGREGATE = 353,
     ALL = 354,
     ALSO = 355,
     ALTER = 356,
     ALWAYS = 357,
     ANALYSE = 358,
     ANALYZE = 359,
     AND = 360,
     ANY = 361,
     ARRAY = 362,
     AS = 363,
     ASC = 364,
     ASSERTION = 365,
     ASSIGNMENT = 366,
     ASYMMETRIC = 367,
     AT = 368,
     ATTRIBUTE = 369,
     AUTHORIZATION = 370,
     BACKWARD = 371,
     BEFORE = 372,
     BEGIN_P = 373,
     BETWEEN = 374,
     BIGINT = 375,
     BINARY = 376,
     BIT = 377,
     BOOLEAN_P = 378,
     BOTH = 379,
     BY = 380,
     CACHE = 381,
     CALLED = 382,
     CASCADE = 383,
     CASCADED = 384,
     CASE = 385,
     CAST = 386,
     CATALOG_P = 387,
     CHAIN = 388,
     CHAR_P = 389,
     CHARACTER = 390,
     CHARACTERISTICS = 391,
     CHECK = 392,
     CHECKPOINT = 393,
     CLASS = 394,
     CLOSE = 395,
     CLUSTER = 396,
     COALESCE = 397,
     COLLATE = 398,
     COLLATION = 399,
     COLUMN = 400,
     COMMENT = 401,
     COMMENTS = 402,
     COMMIT = 403,
     COMMITTED = 404,
     CONCURRENTLY = 405,
     CONFIGURATION = 406,
     CONNECTION = 407,
     CONSTRAINT = 408,
     CONSTRAINTS = 409,
     CONTENT_P = 410,
     CONTINUE_P = 411,
     CONVERSION_P = 412,
     COPY = 413,
     COST = 414,
     CREATE = 415,
     CROSS = 416,
     CSV = 417,
     CURRENT_P = 418,
     CURRENT_CATALOG = 419,
     CURRENT_DATE = 420,
     CURRENT_ROLE = 421,
     CURRENT_SCHEMA = 422,
     CURRENT_TIME = 423,
     CURRENT_TIMESTAMP = 424,
     CURRENT_USER = 425,
     CURSOR = 426,
     CYCLE = 427,
     DATA_P = 428,
     DATABASE = 429,
     DAY_P = 430,
     DEALLOCATE = 431,
     DEC = 432,
     DECIMAL_P = 433,
     DECLARE = 434,
     DEFAULT = 435,
     DEFAULTS = 436,
     DEFERRABLE = 437,
     DEFERRED = 438,
     DEFINER = 439,
     DELETE_P = 440,
     DELIMITER = 441,
     DELIMITERS = 442,
     DESC = 443,
     DICTIONARY = 444,
     DISABLE_P = 445,
     DISCARD = 446,
     DISTINCT = 447,
     DO = 448,
     DOCUMENT_P = 449,
     DOMAIN_P = 450,
     DOUBLE_P = 451,
     DROP = 452,
     EACH = 453,
     ELSE = 454,
     ENABLE_P = 455,
     ENCODING = 456,
     ENCRYPTED = 457,
     END_P = 458,
     ENUM_P = 459,
     ESCAPE = 460,
     EXCEPT = 461,
     EXCLUDE = 462,
     EXCLUDING = 463,
     EXCLUSIVE = 464,
     EXECUTE = 465,
     EXISTS = 466,
     EXPLAIN = 467,
     EXTENSION = 468,
     EXTERNAL = 469,
     EXTRACT = 470,
     FALSE_P = 471,
     FAMILY = 472,
     FETCH = 473,
     FIRST_P = 474,
     FLOAT_P = 475,
     FOLLOWING = 476,
     FOR = 477,
     FORCE = 478,
     FOREIGN = 479,
     FORWARD = 480,
     FREEZE = 481,
     FROM = 482,
     FULL = 483,
     FUNCTION = 484,
     FUNCTIONS = 485,
     GLOBAL = 486,
     GRANT = 487,
     GRANTED = 488,
     GREATEST = 489,
     GROUP_P = 490,
     HANDLER = 491,
     HAVING = 492,
     HEADER_P = 493,
     HOLD = 494,
     HOUR_P = 495,
     IDENTITY_P = 496,
     IF_P = 497,
     ILIKE = 498,
     IMMEDIATE = 499,
     IMMUTABLE = 500,
     IMPLICIT_P = 501,
     IN_P = 502,
     INCLUDING = 503,
     INCREMENT = 504,
     INDEX = 505,
     INDEXES = 506,
     INHERIT = 507,
     INHERITS = 508,
     INITIALLY = 509,
     INLINE_P = 510,
     INNER_P = 511,
     INOUT = 512,
     INPUT_P = 513,
     INSENSITIVE = 514,
     INSERT = 515,
     INSTEAD = 516,
     INT_P = 517,
     INTEGER = 518,
     INTERSECT = 519,
     INTERVAL = 520,
     INTO = 521,
     INVOKER = 522,
     IS = 523,
     ISNULL = 524,
     ISOLATION = 525,
     JOIN = 526,
     KEY = 527,
     LABEL = 528,
     LANGUAGE = 529,
     LARGE_P = 530,
     LAST_P = 531,
     LC_COLLATE_P = 532,
     LC_CTYPE_P = 533,
     LEADING = 534,
     LEAST = 535,
     LEFT = 536,
     LEVEL = 537,
     LIKE = 538,
     LIMIT = 539,
     LISTEN = 540,
     LOAD = 541,
     LOCAL = 542,
     LOCALTIME = 543,
     LOCALTIMESTAMP = 544,
     LOCATION = 545,
     LOCK_P = 546,
     MAPPING = 547,
     MATCH = 548,
     MAXVALUE = 549,
     MINUTE_P = 550,
     MINVALUE = 551,
     MODE = 552,
     MONTH_P = 553,
     MOVE = 554,
     NAME_P = 555,
     NAMES = 556,
     NATIONAL = 557,
     NATURAL = 558,
     NCHAR = 559,
     NEXT = 560,
     NO = 561,
     NONE = 562,
     NOT = 563,
     NOTHING = 564,
     NOTIFY = 565,
     NOTNULL = 566,
     NOWAIT = 567,
     NULL_P = 568,
     NULLIF = 569,
     NULLS_P = 570,
     NUMERIC = 571,
     OBJECT_P = 572,
     OF = 573,
     OFF = 574,
     OFFSET = 575,
     OIDS = 576,
     ON = 577,
     ONLY = 578,
     OPERATOR = 579,
     OPTION = 580,
     OPTIONS = 581,
     OR = 582,
     ORDER = 583,
     OUT_P = 584,
     OUTER_P = 585,
     OVER = 586,
     OVERLAPS = 587,
     OVERLAY = 588,
     OWNED = 589,
     OWNER = 590,
     PARSER = 591,
     PARTIAL = 592,
     PARTITION = 593,
     PASSING = 594,
     PASSWORD = 595,
     PLACING = 596,
     PLANS = 597,
     POSITION = 598,
     PRECEDING = 599,
     PRECISION = 600,
     PRESERVE = 601,
     PREPARE = 602,
     PREPARED = 603,
     PRIMARY = 604,
     PRIOR = 605,
     PRIVILEGES = 606,
     PROCEDURAL = 607,
     PROCEDURE = 608,
     QUOTE = 609,
     RANGE = 610,
     READ = 611,
     REAL = 612,
     REASSIGN = 613,
     RECHECK = 614,
     RECURSIVE = 615,
     REF = 616,
     REFERENCES = 617,
     REINDEX = 618,
     RELATIVE_P = 619,
     RELEASE = 620,
     RENAME = 621,
     REPEATABLE = 622,
     REPLACE = 623,
     REPLICA = 624,
     RESET = 625,
     RESTART = 626,
     RESTRICT = 627,
     RETURNING = 628,
     RETURNS = 629,
     REVOKE = 630,
     RIGHT = 631,
     ROLE = 632,
     ROLLBACK = 633,
     ROW = 634,
     ROWS = 635,
     RULE = 636,
     SAVEPOINT = 637,
     SCHEMA = 638,
     SCROLL = 639,
     SEARCH = 640,
     SECOND_P = 641,
     SECURITY = 642,
     SELECT = 643,
     SEQUENCE = 644,
     SEQUENCES = 645,
     SERIALIZABLE = 646,
     SERVER = 647,
     SESSION = 648,
     SESSION_USER = 649,
     SET = 650,
     SETOF = 651,
     SHARE = 652,
     SHOW = 653,
     SIMILAR = 654,
     SIMPLE = 655,
     SMALLINT = 656,
     SOME = 657,
     STABLE = 658,
     STANDALONE_P = 659,
     START = 660,
     STATEMENT = 661,
     STATISTICS = 662,
     STDIN = 663,
     STDOUT = 664,
     STORAGE = 665,
     STRICT_P = 666,
     STRIP_P = 667,
     SUBSTRING = 668,
     SYMMETRIC = 669,
     SYSID = 670,
     SYSTEM_P = 671,
     TABLE = 672,
     TABLES = 673,
     TABLESPACE = 674,
     TEMP = 675,
     TEMPLATE = 676,
     TEMPORARY = 677,
     TEXT_P = 678,
     THEN = 679,
     TIME = 680,
     TIMESTAMP = 681,
     TO = 682,
     TRAILING = 683,
     TRANSACTION = 684,
     TREAT = 685,
     TRIGGER = 686,
     TRIM = 687,
     TRUE_P = 688,
     TRUNCATE = 689,
     TRUSTED = 690,
     TYPE_P = 691,
     UNBOUNDED = 692,
     UNCOMMITTED = 693,
     UNENCRYPTED = 694,
     UNION = 695,
     UNIQUE = 696,
     UNKNOWN = 697,
     UNLISTEN = 698,
     UNLOGGED = 699,
     UNTIL = 700,
     UPDATE = 701,
     USER = 702,
     USING = 703,
     VACUUM = 704,
     VALID = 705,
     VALIDATE = 706,
     VALIDATOR = 707,
     VALUE_P = 708,
     VALUES = 709,
     VARCHAR = 710,
     VARIADIC = 711,
     VARYING = 712,
     VERBOSE = 713,
     VERSION_P = 714,
     VIEW = 715,
     VOLATILE = 716,
     WHEN = 717,
     WHERE = 718,
     WHITESPACE_P = 719,
     WINDOW = 720,
     WITH = 721,
     WITHOUT = 722,
     WORK = 723,
     WRAPPER = 724,
     WRITE = 725,
     XML_P = 726,
     XMLATTRIBUTES = 727,
     XMLCONCAT = 728,
     XMLELEMENT = 729,
     XMLEXISTS = 730,
     XMLFOREST = 731,
     XMLPARSE = 732,
     XMLPI = 733,
     XMLROOT = 734,
     XMLSERIALIZE = 735,
     YEAR_P = 736,
     YES_P = 737,
     ZONE = 738,
     NULLS_FIRST = 739,
     NULLS_LAST = 740,
     WITH_TIME = 741,
     POSTFIXOP = 742,
     UMINUS = 743
   };
#endif
#define SQL_ALLOCATE 258
#define SQL_AUTOCOMMIT 259
#define SQL_BOOL 260
#define SQL_BREAK 261
#define SQL_CALL 262
#define SQL_CARDINALITY 263
#define SQL_CONNECT 264
#define SQL_COUNT 265
#define SQL_DATETIME_INTERVAL_CODE 266
#define SQL_DATETIME_INTERVAL_PRECISION 267
#define SQL_DESCRIBE 268
#define SQL_DESCRIPTOR 269
#define SQL_DISCONNECT 270
#define SQL_FOUND 271
#define SQL_FREE 272
#define SQL_GET 273
#define SQL_GO 274
#define SQL_GOTO 275
#define SQL_IDENTIFIED 276
#define SQL_INDICATOR 277
#define SQL_KEY_MEMBER 278
#define SQL_LENGTH 279
#define SQL_LONG 280
#define SQL_NULLABLE 281
#define SQL_OCTET_LENGTH 282
#define SQL_OPEN 283
#define SQL_OUTPUT 284
#define SQL_REFERENCE 285
#define SQL_RETURNED_LENGTH 286
#define SQL_RETURNED_OCTET_LENGTH 287
#define SQL_SCALE 288
#define SQL_SECTION 289
#define SQL_SHORT 290
#define SQL_SIGNED 291
#define SQL_SQL 292
#define SQL_SQLERROR 293
#define SQL_SQLPRINT 294
#define SQL_SQLWARNING 295
#define SQL_START 296
#define SQL_STOP 297
#define SQL_STRUCT 298
#define SQL_UNSIGNED 299
#define SQL_VAR 300
#define SQL_WHENEVER 301
#define S_ADD 302
#define S_AND 303
#define S_ANYTHING 304
#define S_AUTO 305
#define S_CONST 306
#define S_DEC 307
#define S_DIV 308
#define S_DOTPOINT 309
#define S_EQUAL 310
#define S_EXTERN 311
#define S_INC 312
#define S_LSHIFT 313
#define S_MEMPOINT 314
#define S_MEMBER 315
#define S_MOD 316
#define S_MUL 317
#define S_NEQUAL 318
#define S_OR 319
#define S_REGISTER 320
#define S_RSHIFT 321
#define S_STATIC 322
#define S_SUB 323
#define S_VOLATILE 324
#define S_TYPEDEF 325
#define CSTRING 326
#define CVARIABLE 327
#define CPP_LINE 328
#define IP 329
#define DOLCONST 330
#define ECONST 331
#define NCONST 332
#define UCONST 333
#define UIDENT 334
#define IDENT 335
#define FCONST 336
#define SCONST 337
#define BCONST 338
#define XCONST 339
#define Op 340
#define ICONST 341
#define PARAM 342
#define TYPECAST 343
#define DOT_DOT 344
#define COLON_EQUALS 345
#define ABORT_P 346
#define ABSOLUTE_P 347
#define ACCESS 348
#define ACTION 349
#define ADD_P 350
#define ADMIN 351
#define AFTER 352
#define AGGREGATE 353
#define ALL 354
#define ALSO 355
#define ALTER 356
#define ALWAYS 357
#define ANALYSE 358
#define ANALYZE 359
#define AND 360
#define ANY 361
#define ARRAY 362
#define AS 363
#define ASC 364
#define ASSERTION 365
#define ASSIGNMENT 366
#define ASYMMETRIC 367
#define AT 368
#define ATTRIBUTE 369
#define AUTHORIZATION 370
#define BACKWARD 371
#define BEFORE 372
#define BEGIN_P 373
#define BETWEEN 374
#define BIGINT 375
#define BINARY 376
#define BIT 377
#define BOOLEAN_P 378
#define BOTH 379
#define BY 380
#define CACHE 381
#define CALLED 382
#define CASCADE 383
#define CASCADED 384
#define CASE 385
#define CAST 386
#define CATALOG_P 387
#define CHAIN 388
#define CHAR_P 389
#define CHARACTER 390
#define CHARACTERISTICS 391
#define CHECK 392
#define CHECKPOINT 393
#define CLASS 394
#define CLOSE 395
#define CLUSTER 396
#define COALESCE 397
#define COLLATE 398
#define COLLATION 399
#define COLUMN 400
#define COMMENT 401
#define COMMENTS 402
#define COMMIT 403
#define COMMITTED 404
#define CONCURRENTLY 405
#define CONFIGURATION 406
#define CONNECTION 407
#define CONSTRAINT 408
#define CONSTRAINTS 409
#define CONTENT_P 410
#define CONTINUE_P 411
#define CONVERSION_P 412
#define COPY 413
#define COST 414
#define CREATE 415
#define CROSS 416
#define CSV 417
#define CURRENT_P 418
#define CURRENT_CATALOG 419
#define CURRENT_DATE 420
#define CURRENT_ROLE 421
#define CURRENT_SCHEMA 422
#define CURRENT_TIME 423
#define CURRENT_TIMESTAMP 424
#define CURRENT_USER 425
#define CURSOR 426
#define CYCLE 427
#define DATA_P 428
#define DATABASE 429
#define DAY_P 430
#define DEALLOCATE 431
#define DEC 432
#define DECIMAL_P 433
#define DECLARE 434
#define DEFAULT 435
#define DEFAULTS 436
#define DEFERRABLE 437
#define DEFERRED 438
#define DEFINER 439
#define DELETE_P 440
#define DELIMITER 441
#define DELIMITERS 442
#define DESC 443
#define DICTIONARY 444
#define DISABLE_P 445
#define DISCARD 446
#define DISTINCT 447
#define DO 448
#define DOCUMENT_P 449
#define DOMAIN_P 450
#define DOUBLE_P 451
#define DROP 452
#define EACH 453
#define ELSE 454
#define ENABLE_P 455
#define ENCODING 456
#define ENCRYPTED 457
#define END_P 458
#define ENUM_P 459
#define ESCAPE 460
#define EXCEPT 461
#define EXCLUDE 462
#define EXCLUDING 463
#define EXCLUSIVE 464
#define EXECUTE 465
#define EXISTS 466
#define EXPLAIN 467
#define EXTENSION 468
#define EXTERNAL 469
#define EXTRACT 470
#define FALSE_P 471
#define FAMILY 472
#define FETCH 473
#define FIRST_P 474
#define FLOAT_P 475
#define FOLLOWING 476
#define FOR 477
#define FORCE 478
#define FOREIGN 479
#define FORWARD 480
#define FREEZE 481
#define FROM 482
#define FULL 483
#define FUNCTION 484
#define FUNCTIONS 485
#define GLOBAL 486
#define GRANT 487
#define GRANTED 488
#define GREATEST 489
#define GROUP_P 490
#define HANDLER 491
#define HAVING 492
#define HEADER_P 493
#define HOLD 494
#define HOUR_P 495
#define IDENTITY_P 496
#define IF_P 497
#define ILIKE 498
#define IMMEDIATE 499
#define IMMUTABLE 500
#define IMPLICIT_P 501
#define IN_P 502
#define INCLUDING 503
#define INCREMENT 504
#define INDEX 505
#define INDEXES 506
#define INHERIT 507
#define INHERITS 508
#define INITIALLY 509
#define INLINE_P 510
#define INNER_P 511
#define INOUT 512
#define INPUT_P 513
#define INSENSITIVE 514
#define INSERT 515
#define INSTEAD 516
#define INT_P 517
#define INTEGER 518
#define INTERSECT 519
#define INTERVAL 520
#define INTO 521
#define INVOKER 522
#define IS 523
#define ISNULL 524
#define ISOLATION 525
#define JOIN 526
#define KEY 527
#define LABEL 528
#define LANGUAGE 529
#define LARGE_P 530
#define LAST_P 531
#define LC_COLLATE_P 532
#define LC_CTYPE_P 533
#define LEADING 534
#define LEAST 535
#define LEFT 536
#define LEVEL 537
#define LIKE 538
#define LIMIT 539
#define LISTEN 540
#define LOAD 541
#define LOCAL 542
#define LOCALTIME 543
#define LOCALTIMESTAMP 544
#define LOCATION 545
#define LOCK_P 546
#define MAPPING 547
#define MATCH 548
#define MAXVALUE 549
#define MINUTE_P 550
#define MINVALUE 551
#define MODE 552
#define MONTH_P 553
#define MOVE 554
#define NAME_P 555
#define NAMES 556
#define NATIONAL 557
#define NATURAL 558
#define NCHAR 559
#define NEXT 560
#define NO 561
#define NONE 562
#define NOT 563
#define NOTHING 564
#define NOTIFY 565
#define NOTNULL 566
#define NOWAIT 567
#define NULL_P 568
#define NULLIF 569
#define NULLS_P 570
#define NUMERIC 571
#define OBJECT_P 572
#define OF 573
#define OFF 574
#define OFFSET 575
#define OIDS 576
#define ON 577
#define ONLY 578
#define OPERATOR 579
#define OPTION 580
#define OPTIONS 581
#define OR 582
#define ORDER 583
#define OUT_P 584
#define OUTER_P 585
#define OVER 586
#define OVERLAPS 587
#define OVERLAY 588
#define OWNED 589
#define OWNER 590
#define PARSER 591
#define PARTIAL 592
#define PARTITION 593
#define PASSING 594
#define PASSWORD 595
#define PLACING 596
#define PLANS 597
#define POSITION 598
#define PRECEDING 599
#define PRECISION 600
#define PRESERVE 601
#define PREPARE 602
#define PREPARED 603
#define PRIMARY 604
#define PRIOR 605
#define PRIVILEGES 606
#define PROCEDURAL 607
#define PROCEDURE 608
#define QUOTE 609
#define RANGE 610
#define READ 611
#define REAL 612
#define REASSIGN 613
#define RECHECK 614
#define RECURSIVE 615
#define REF 616
#define REFERENCES 617
#define REINDEX 618
#define RELATIVE_P 619
#define RELEASE 620
#define RENAME 621
#define REPEATABLE 622
#define REPLACE 623
#define REPLICA 624
#define RESET 625
#define RESTART 626
#define RESTRICT 627
#define RETURNING 628
#define RETURNS 629
#define REVOKE 630
#define RIGHT 631
#define ROLE 632
#define ROLLBACK 633
#define ROW 634
#define ROWS 635
#define RULE 636
#define SAVEPOINT 637
#define SCHEMA 638
#define SCROLL 639
#define SEARCH 640
#define SECOND_P 641
#define SECURITY 642
#define SELECT 643
#define SEQUENCE 644
#define SEQUENCES 645
#define SERIALIZABLE 646
#define SERVER 647
#define SESSION 648
#define SESSION_USER 649
#define SET 650
#define SETOF 651
#define SHARE 652
#define SHOW 653
#define SIMILAR 654
#define SIMPLE 655
#define SMALLINT 656
#define SOME 657
#define STABLE 658
#define STANDALONE_P 659
#define START 660
#define STATEMENT 661
#define STATISTICS 662
#define STDIN 663
#define STDOUT 664
#define STORAGE 665
#define STRICT_P 666
#define STRIP_P 667
#define SUBSTRING 668
#define SYMMETRIC 669
#define SYSID 670
#define SYSTEM_P 671
#define TABLE 672
#define TABLES 673
#define TABLESPACE 674
#define TEMP 675
#define TEMPLATE 676
#define TEMPORARY 677
#define TEXT_P 678
#define THEN 679
#define TIME 680
#define TIMESTAMP 681
#define TO 682
#define TRAILING 683
#define TRANSACTION 684
#define TREAT 685
#define TRIGGER 686
#define TRIM 687
#define TRUE_P 688
#define TRUNCATE 689
#define TRUSTED 690
#define TYPE_P 691
#define UNBOUNDED 692
#define UNCOMMITTED 693
#define UNENCRYPTED 694
#define UNION 695
#define UNIQUE 696
#define UNKNOWN 697
#define UNLISTEN 698
#define UNLOGGED 699
#define UNTIL 700
#define UPDATE 701
#define USER 702
#define USING 703
#define VACUUM 704
#define VALID 705
#define VALIDATE 706
#define VALIDATOR 707
#define VALUE_P 708
#define VALUES 709
#define VARCHAR 710
#define VARIADIC 711
#define VARYING 712
#define VERBOSE 713
#define VERSION_P 714
#define VIEW 715
#define VOLATILE 716
#define WHEN 717
#define WHERE 718
#define WHITESPACE_P 719
#define WINDOW 720
#define WITH 721
#define WITHOUT 722
#define WORK 723
#define WRAPPER 724
#define WRITE 725
#define XML_P 726
#define XMLATTRIBUTES 727
#define XMLCONCAT 728
#define XMLELEMENT 729
#define XMLEXISTS 730
#define XMLFOREST 731
#define XMLPARSE 732
#define XMLPI 733
#define XMLROOT 734
#define XMLSERIALIZE 735
#define YEAR_P 736
#define YES_P 737
#define ZONE 738
#define NULLS_FIRST 739
#define NULLS_LAST 740
#define WITH_TIME 741
#define POSTFIXOP 742
#define UMINUS 743




/* Copy the first part of user declarations.  */
#line 5 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"
#include "ecpg_config.h"
#include <unistd.h>

/* Location tracking support --- simpler than bison's default */
#define YYLLOC_DEFAULT(Current, Rhs, N) \
	do { \
                if (N) \
			(Current) = (Rhs)[1]; \
		else \
		        (Current) = (Rhs)[0]; \
	} while (0)

/*
 * The %name-prefix option below will make bison call base_yylex, but we
 * really want it to call filtered_base_yylex (see parser.c).
 */
#define base_yylex filtered_base_yylex

/*
 * This is only here so the string gets into the POT.  Bison uses it
 * internally.
 */
#define bison_gettext_dummy gettext_noop("syntax error")

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
char *current_function;
int ecpg_internal_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	FoundInto = 0;
static int	initializer = 0;
static int	pacounter = 1;
static char     pacounter_buffer[sizeof(int) * CHAR_BIT * 10 / 3]; /* a rough guess at the size we need */
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];
static int 	varchar_counter = 1;

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, NULL, NULL, NULL, {NULL}, 0};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, NULL, NULL, NULL, {NULL}, 0};

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, const char *error, ...)
{
	va_list ap;

	/* internationalize the error message string */
	error = _(error);

	fprintf(stderr, "%s:%d: ", input_filename, yylineno);

	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, _("WARNING: "));
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, _("ERROR: "));
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);

	fprintf(stderr, "\n");

	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			if (yyin)
				fclose(yyin);
			if (yyout)
				fclose(yyout);

			if (strcmp(output_filename, "-") != 0 && unlink(output_filename) != 0)
			        fprintf(stderr, _("could not remove output file \"%s\"\n"), output_filename);
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	if (strlen(str1) != 0 && strlen(str2) != 0)
		strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	return mm_strdup(yytext);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct
	 * An array is only allowed together with an element argument
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else
	 * so we don't have to worry here. */

	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
	{
		sprintf(pacounter_buffer, "$%d", pacounter++);
		result = cat_str(3, result, mm_strdup(pacounter_buffer), mm_strdup(" , "));
	}

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_outofscope_cursor_vars(struct cursor *cur)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
	 * For instance you can DECLARE a cursor in one function, and OPEN/FETCH/CLOSE
	 * it in other functions. This is very useful for e.g. event-driver programming,
	 * but may also lead to dangerous programming. The limitation when this is allowed
	 * and doesn's cause problems have to be documented, like the allocated variables
	 * must not be realloc()'ed.
	 *
	 * We have to change the variables to our own struct and just store the pointer
	 * instead of the variable. Do it only for local variables, not for globals.
	 */

	char *result = mm_strdup("");
	int insert;

	for (insert = 1; insert >= 0; insert--)
	{
		struct arguments *list;
		struct arguments *ptr;
		struct arguments *newlist = NULL;
		struct variable *newvar, *newind;

		list = (insert ? cur->argsinsert : cur->argsresult);

		for (ptr = list; ptr != NULL; ptr = ptr->next)
		{
			char temp[20];
			char *original_var;
			bool skip_set_var = false;

			/* change variable name to "ECPGget_var(<counter>)" */
			original_var = ptr->variable->name;
			sprintf(temp, "%d))", ecpg_internal_var);

			/* Don't emit ECPGset_var() calls for global variables */
			if (ptr->variable->brace_level == 0)
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type == ECPGt_char_variable) && (!strncmp(ptr->variable->name, "ECPGprepared_statement", strlen("ECPGprepared_statement"))))
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type != ECPGt_varchar && ptr->variable->type->type != ECPGt_char && ptr->variable->type->type != ECPGt_unsigned_char && ptr->variable->type->type != ECPGt_string) && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, mm_strdup("("), mm_strdup(ecpg_type_name(ptr->variable->type->u.element->type)), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, mm_strdup("1"), ptr->variable->type->u.element->counter), ptr->variable->type->size), 0);
				sprintf(temp, "%d, (", ecpg_internal_var++);
			}
			else if ((ptr->variable->type->type == ECPGt_varchar || ptr->variable->type->type == ECPGt_char || ptr->variable->type->type == ECPGt_unsigned_char || ptr->variable->type->type == ECPGt_string) && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, mm_strdup("("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->counter), 0);
				if (ptr->variable->type->type == ECPGt_varchar)
					sprintf(temp, "%d, &(", ecpg_internal_var++);
				else
					sprintf(temp, "%d, (", ecpg_internal_var++);
			}
			else if (ptr->variable->type->type == ECPGt_struct || ptr->variable->type->type == ECPGt_union)
			{
				sprintf(temp, "%d)))", ecpg_internal_var);
				newvar = new_variable(cat_str(4, mm_strdup("(*("), mm_strdup(ptr->variable->type->type_name), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_struct_type(ptr->variable->type->u.members, ptr->variable->type->type, ptr->variable->type->type_name, ptr->variable->type->struct_sizeof), 0);
				sprintf(temp, "%d, &(", ecpg_internal_var++);
			}
			else if (ptr->variable->type->type == ECPGt_array)
			{
				if (ptr->variable->type->u.element->type == ECPGt_struct || ptr->variable->type->u.element->type == ECPGt_union)
				{
					sprintf(temp, "%d)))", ecpg_internal_var);
					newvar = new_variable(cat_str(4, mm_strdup("(*("), mm_strdup(ptr->variable->type->u.element->type_name), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_struct_type(ptr->variable->type->u.element->u.members, ptr->variable->type->u.element->type, ptr->variable->type->u.element->type_name, ptr->variable->type->u.element->struct_sizeof), 0);
					sprintf(temp, "%d, (", ecpg_internal_var++);
				}
				else
				{
					newvar = new_variable(cat_str(4, mm_strdup("("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, ptr->variable->type->u.element->size, ptr->variable->type->u.element->counter), ptr->variable->type->size), 0);
					sprintf(temp, "%d, &(", ecpg_internal_var++);
				}
			}
			else
			{
				newvar = new_variable(cat_str(4, mm_strdup("*("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->counter), 0);
				sprintf(temp, "%d, &(", ecpg_internal_var++);
			}

			/* create call to "ECPGset_var(<counter>, <pointer>. <line number>)" */
			if (!skip_set_var)
				result = cat_str(5, result, mm_strdup("ECPGset_var("), mm_strdup(temp), mm_strdup(original_var), mm_strdup("), __LINE__);\n"));

			/* now the indicator if there is one and it's not a global variable */
			if ((ptr->indicator->type->type == ECPGt_NO_INDICATOR) || (ptr->indicator->brace_level == 0))
			{
				newind = ptr->indicator;
			}
			else
			{
				/* change variable name to "ECPGget_var(<counter>)" */
				original_var = ptr->indicator->name;
				sprintf(temp, "%d))", ecpg_internal_var);

				if (ptr->indicator->type->type == ECPGt_struct || ptr->indicator->type->type == ECPGt_union)
				{
					sprintf(temp, "%d)))", ecpg_internal_var);
					newind = new_variable(cat_str(4, mm_strdup("(*("), mm_strdup(ptr->indicator->type->type_name), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_struct_type(ptr->indicator->type->u.members, ptr->indicator->type->type, ptr->indicator->type->type_name, ptr->indicator->type->struct_sizeof), 0);
					sprintf(temp, "%d, &(", ecpg_internal_var++);
				}
				else if (ptr->indicator->type->type == ECPGt_array)
				{
					if (ptr->indicator->type->u.element->type == ECPGt_struct || ptr->indicator->type->u.element->type == ECPGt_union)
					{
						sprintf(temp, "%d)))", ecpg_internal_var);
						newind = new_variable(cat_str(4, mm_strdup("(*("), mm_strdup(ptr->indicator->type->u.element->type_name), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_struct_type(ptr->indicator->type->u.element->u.members, ptr->indicator->type->u.element->type, ptr->indicator->type->u.element->type_name, ptr->indicator->type->u.element->struct_sizeof), 0);
						sprintf(temp, "%d, (", ecpg_internal_var++);
					}
					else
					{
						newind = new_variable(cat_str(4, mm_strdup("("), mm_strdup(ecpg_type_name(ptr->indicator->type->u.element->type)), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->indicator->type->u.element->type, ptr->indicator->type->u.element->size, ptr->indicator->type->u.element->counter), ptr->indicator->type->size), 0);
						sprintf(temp, "%d, &(", ecpg_internal_var++);
					}
				}
				else if (atoi(ptr->indicator->type->size) > 1)
				{
					newind = new_variable(cat_str(4, mm_strdup("("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->counter), 0);
					sprintf(temp, "%d, (", ecpg_internal_var++);
				}
				else
				{
					newind = new_variable(cat_str(4, mm_strdup("*("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->counter), 0);
					sprintf(temp, "%d, &(", ecpg_internal_var++);
				}

				/* create call to "ECPGset_var(<counter>, <pointer>. <line number>)" */
				result = cat_str(5, result, mm_strdup("ECPGset_var("), mm_strdup(temp), mm_strdup(original_var), mm_strdup("), __LINE__);\n"));
			}

			add_variable_to_tail(&newlist, newvar, newind);
		}

		if (insert)
			cur->argsinsert_oos = newlist;
		else
			cur->argsresult_oos = newlist;
	}

	return result;
}

/* This tests whether the cursor was declared and opened in the same function. */
#define SAMEFUNC(cur)	\
	((cur->function == NULL) ||		\
	 (cur->function != NULL && !strcmp(cur->function, current_function)))

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;
	int (* strcmp_fn)(const char *, const char *) = (name[0] == ':' ? strcmp : pg_strcasecmp);

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp_fn(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "cursor \"%s\" does not exist", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier
		 * note that we have to append here but have to keep the existing order */
		for (p = (SAMEFUNC(ptr) ? ptr->argsinsert : ptr->argsinsert_oos); p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = (SAMEFUNC(ptr) ? ptr->argsresult : ptr->argsresult_oos); p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);

	return ptr;
}

static void
add_typedef(char *name, char * dimension, char * length, enum ECPGttype type_enum, char *type_dimension, char *type_index, int initializer, int array)
{
	/* add entry to list */
	struct typedefs *ptr, *this;

	if ((type_enum == ECPGt_struct ||
	     type_enum == ECPGt_union) &&
	    initializer == 1)
		mmerror(PARSE_ERROR, ET_ERROR, "initializer not allowed in type definition");
	else if (INFORMIX_MODE && strcmp(name, "string") == 0)
		mmerror(PARSE_ERROR, ET_ERROR, "type name \"string\" is reserved in Informix mode");
	else
	{
		for (ptr = types; ptr != NULL; ptr = ptr->next)
		{
			if (strcmp(name, ptr->name) == 0)
				/* re-definition is a bug */
				mmerror(PARSE_ERROR, ET_ERROR, "type \"%s\" is already defined", name);
		}
		adjust_array(type_enum, &dimension, &length, type_dimension, type_index, array, true);

		this = (struct typedefs *) mm_alloc(sizeof(struct typedefs));

		/* initial definition */
		this->next = types;
		this->name = name;
		this->brace_level = braces_open;
		this->type = (struct this_type *) mm_alloc(sizeof(struct this_type));
		this->type->type_enum = type_enum;
		this->type->type_str = mm_strdup(name);
		this->type->type_dimension = dimension; /* dimension of array */
		this->type->type_index = length;	/* length of string */
		this->type->type_sizeof = ECPGstruct_sizeof;
		this->struct_member_list = (type_enum == ECPGt_struct || type_enum == ECPGt_union) ?
		ECPGstruct_member_dup(struct_member_list[struct_level]) : NULL;

		if (type_enum != ECPGt_varchar &&
			type_enum != ECPGt_char &&
			type_enum != ECPGt_unsigned_char &&
			type_enum != ECPGt_string &&
			atoi(this->type->type_index) >= 0)
			mmerror(PARSE_ERROR, ET_ERROR, "multidimensional arrays for simple data types are not supported");

		types = this;
	}
}


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 463 "preproc.y"
typedef union YYSTYPE {
	double	dval;
	char	*str;
	int     ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
	struct	prep		prep;
} YYSTYPE;
/* Line 186 of yacc.c.  */
#line 1529 "preproc.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif

#if ! defined (YYLTYPE) && ! defined (YYLTYPE_IS_DECLARED)
typedef struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} YYLTYPE;
# define yyltype YYLTYPE /* obsolescent; will be withdrawn */
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 1553 "preproc.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYLTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
    YYLTYPE yyls;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE) + sizeof (YYLTYPE))	\
      + 2 * YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   98211

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  508
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  687
/* YYNRULES -- Number of rules. */
#define YYNRULES  2690
/* YYNRULES -- Number of states. */
#define YYNSTATES  4829

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   743

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   495,     2,     2,
     500,   501,   493,   491,   503,   492,   502,   494,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   505,   504,
     488,   487,   489,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   498,     2,   499,   496,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   506,     2,   507,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   490,   497
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     7,     9,    11,    13,    15,    17,
      19,    21,    23,    25,    27,    29,    31,    33,    35,    37,
      39,    41,    43,    45,    47,    49,    51,    53,    55,    57,
      59,    61,    63,    65,    67,    69,    71,    73,    75,    77,
      79,    81,    83,    85,    87,    89,    91,    93,    95,    97,
      99,   101,   103,   105,   107,   109,   111,   113,   115,   117,
     119,   121,   123,   125,   127,   129,   131,   133,   135,   137,
     139,   141,   143,   145,   147,   149,   151,   153,   155,   157,
     159,   161,   163,   165,   167,   169,   171,   173,   175,   177,
     179,   181,   183,   185,   187,   189,   191,   193,   195,   197,
     199,   201,   203,   205,   207,   209,   211,   213,   215,   217,
     219,   221,   223,   225,   227,   229,   231,   233,   235,   237,
     239,   241,   243,   245,   247,   249,   251,   253,   255,   257,
     259,   261,   263,   264,   270,   272,   273,   276,   277,   280,
     281,   284,   287,   291,   295,   297,   301,   305,   308,   310,
     312,   315,   318,   321,   325,   329,   335,   341,   342,   346,
     352,   358,   363,   367,   373,   377,   383,   389,   396,   398,
     400,   404,   410,   417,   422,   424,   425,   428,   429,   431,
     433,   435,   437,   439,   441,   444,   448,   452,   456,   460,
     464,   468,   472,   476,   479,   485,   488,   491,   494,   497,
     501,   505,   509,   511,   515,   517,   521,   523,   525,   528,
     531,   534,   536,   538,   540,   542,   544,   546,   548,   552,
     559,   561,   563,   565,   567,   569,   570,   572,   574,   577,
     581,   586,   590,   593,   596,   598,   602,   607,   613,   618,
     621,   626,   628,   630,   632,   634,   636,   639,   642,   645,
     648,   653,   658,   663,   668,   670,   674,   677,   681,   686,
     693,   700,   707,   713,   719,   726,   733,   738,   747,   750,
     754,   761,   766,   770,   774,   778,   782,   786,   791,   796,
     800,   804,   808,   812,   816,   820,   825,   830,   834,   837,
     841,   844,   847,   851,   855,   858,   861,   863,   867,   870,
     872,   874,   875,   878,   879,   882,   883,   887,   890,   891,
     893,   897,   901,   903,   909,   913,   918,   920,   924,   929,
     936,   941,   950,   953,   956,   967,   974,   976,   978,   980,
     982,   984,   986,   990,   993,   994,   996,   998,  1002,  1006,
    1008,  1010,  1014,  1018,  1022,  1026,  1031,  1034,  1036,  1037,
    1040,  1041,  1045,  1046,  1048,  1049,  1051,  1055,  1058,  1060,
    1062,  1064,  1068,  1069,  1071,  1075,  1077,  1089,  1104,  1115,
    1129,  1131,  1133,  1136,  1139,  1142,  1145,  1147,  1148,  1150,
    1151,  1155,  1156,  1158,  1162,  1164,  1168,  1170,  1172,  1174,
    1176,  1178,  1182,  1187,  1190,  1191,  1195,  1197,  1199,  1202,
    1205,  1207,  1211,  1216,  1221,  1224,  1230,  1232,  1235,  1238,
    1241,  1245,  1249,  1253,  1254,  1256,  1258,  1260,  1262,  1264,
    1266,  1270,  1272,  1278,  1286,  1290,  1299,  1304,  1314,  1326,
    1339,  1343,  1344,  1346,  1350,  1352,  1355,  1358,  1361,  1362,
    1364,  1368,  1372,  1379,  1384,  1385,  1387,  1389,  1392,  1395,
    1396,  1400,  1404,  1407,  1409,  1411,  1414,  1417,  1422,  1423,
    1426,  1429,  1432,  1433,  1437,  1442,  1447,  1448,  1451,  1452,
    1457,  1458,  1462,  1468,  1472,  1473,  1475,  1479,  1481,  1484,
    1488,  1489,  1495,  1500,  1502,  1503,  1505,  1508,  1511,  1513,
    1516,  1520,  1523,  1526,  1529,  1532,  1536,  1540,  1542,  1546,
    1548,  1549,  1551,  1554,  1556,  1558,  1562,  1569,  1580,  1582,
    1583,  1585,  1588,  1591,  1592,  1595,  1598,  1600,  1601,  1607,
    1615,  1617,  1618,  1625,  1628,  1629,  1633,  1639,  1645,  1654,
    1657,  1658,  1661,  1664,  1667,  1673,  1676,  1677,  1680,  1688,
    1699,  1706,  1713,  1720,  1727,  1735,  1743,  1753,  1763,  1770,
    1777,  1786,  1795,  1804,  1813,  1820,  1827,  1835,  1844,  1851,
    1858,  1866,  1869,  1872,  1875,  1878,  1880,  1883,  1885,  1886,
    1893,  1902,  1910,  1917,  1922,  1923,  1925,  1929,  1934,  1936,
    1940,  1942,  1945,  1948,  1951,  1954,  1956,  1958,  1969,  1972,
    1973,  1976,  1979,  1981,  1982,  1987,  1994,  2000,  2005,  2010,
    2019,  2031,  2035,  2038,  2040,  2044,  2046,  2052,  2061,  2063,
    2065,  2067,  2075,  2085,  2094,  2110,  2131,  2133,  2135,  2138,
    2140,  2144,  2146,  2148,  2150,  2154,  2156,  2160,  2161,  2163,
    2164,  2166,  2168,  2173,  2174,  2176,  2180,  2181,  2183,  2185,
    2187,  2189,  2192,  2193,  2195,  2198,  2200,  2203,  2204,  2207,
    2209,  2212,  2215,  2222,  2231,  2240,  2245,  2251,  2256,  2261,
    2266,  2270,  2278,  2287,  2294,  2301,  2308,  2315,  2320,  2326,
    2330,  2332,  2336,  2340,  2342,  2344,  2346,  2348,  2350,  2352,
    2356,  2360,  2364,  2366,  2370,  2374,  2376,  2377,  2379,  2383,
    2390,  2399,  2408,  2422,  2424,  2428,  2434,  2441,  2446,  2454,
    2457,  2459,  2460,  2463,  2464,  2467,  2472,  2473,  2475,  2476,
    2483,  2492,  2501,  2503,  2507,  2513,  2519,  2527,  2537,  2545,
    2555,  2561,  2568,  2575,  2580,  2582,  2584,  2586,  2588,  2591,
    2593,  2595,  2597,  2599,  2601,  2603,  2607,  2611,  2615,  2619,
    2621,  2625,  2627,  2630,  2633,  2637,  2643,  2646,  2649,  2650,
    2657,  2665,  2673,  2681,  2690,  2699,  2706,  2715,  2725,  2735,
    2743,  2754,  2762,  2771,  2780,  2789,  2798,  2800,  2802,  2804,
    2806,  2808,  2810,  2812,  2814,  2816,  2818,  2820,  2822,  2824,
    2826,  2829,  2831,  2835,  2837,  2839,  2848,  2858,  2868,  2878,
    2888,  2891,  2892,  2894,  2897,  2899,  2901,  2903,  2905,  2907,
    2909,  2911,  2913,  2916,  2919,  2923,  2928,  2934,  2939,  2945,
    2949,  2954,  2958,  2963,  2965,  2968,  2972,  2976,  2980,  2984,
    2989,  2994,  2998,  3002,  3007,  3012,  3017,  3022,  3024,  3026,
    3028,  3029,  3037,  3045,  3056,  3058,  3060,  3063,  3068,  3074,
    3076,  3080,  3083,  3086,  3089,  3092,  3094,  3097,  3100,  3105,
    3109,  3112,  3115,  3118,  3122,  3125,  3128,  3134,  3140,  3146,
    3148,  3152,  3154,  3157,  3161,  3162,  3164,  3168,  3171,  3178,
    3185,  3195,  3199,  3200,  3204,  3205,  3211,  3214,  3215,  3219,
    3223,  3227,  3235,  3243,  3254,  3256,  3258,  3260,  3275,  3277,
    3278,  3280,  3281,  3283,  3284,  3287,  3288,  3290,  3294,  3300,
    3306,  3314,  3317,  3318,  3320,  3323,  3324,  3326,  3328,  3329,
    3331,  3333,  3334,  3344,  3357,  3365,  3368,  3369,  3373,  3376,
    3378,  3382,  3386,  3389,  3391,  3395,  3399,  3403,  3406,  3409,
    3411,  3413,  3415,  3417,  3420,  3422,  3424,  3426,  3428,  3433,
    3439,  3441,  3445,  3449,  3451,  3454,  3459,  3465,  3467,  3469,
    3471,  3473,  3477,  3481,  3484,  3487,  3490,  3493,  3495,  3498,
    3501,  3503,  3505,  3507,  3511,  3514,  3515,  3518,  3520,  3524,
    3530,  3532,  3535,  3537,  3538,  3544,  3552,  3558,  3566,  3572,
    3580,  3584,  3590,  3596,  3602,  3604,  3608,  3611,  3613,  3616,
    3618,  3621,  3633,  3644,  3655,  3658,  3661,  3662,  3672,  3675,
    3676,  3681,  3686,  3691,  3693,  3695,  3697,  3698,  3706,  3713,
    3720,  3727,  3734,  3741,  3749,  3759,  3769,  3776,  3783,  3790,
    3797,  3804,  3812,  3821,  3831,  3840,  3847,  3854,  3861,  3867,
    3873,  3882,  3891,  3900,  3909,  3916,  3926,  3928,  3929,  3932,
    3933,  3941,  3948,  3955,  3962,  3969,  3976,  3984,  3994,  4004,
    4011,  4020,  4029,  4038,  4047,  4054,  4061,  4069,  4076,  4084,
    4091,  4098,  4105,  4112,  4119,  4127,  4135,  4143,  4153,  4163,
    4170,  4177,  4184,  4193,  4202,  4211,  4218,  4232,  4234,  4236,
    4240,  4244,  4246,  4248,  4250,  4252,  4254,  4256,  4258,  4259,
    4261,  4263,  4265,  4267,  4269,  4271,  4272,  4279,  4288,  4292,
    4295,  4296,  4299,  4302,  4305,  4308,  4312,  4316,  4319,  4322,
    4325,  4328,  4332,  4335,  4341,  4346,  4350,  4354,  4358,  4360,
    4362,  4363,  4367,  4370,  4373,  4375,  4378,  4380,  4384,  4387,
    4389,  4390,  4399,  4410,  4414,  4419,  4424,  4425,  4428,  4434,
    4437,  4438,  4442,  4446,  4450,  4454,  4458,  4462,  4466,  4470,
    4474,  4478,  4482,  4486,  4490,  4495,  4499,  4503,  4505,  4506,
    4512,  4519,  4524,  4527,  4528,  4533,  4537,  4543,  4550,  4555,
    4562,  4569,  4575,  4583,  4585,  4586,  4593,  4605,  4617,  4629,
    4643,  4653,  4665,  4676,  4681,  4684,  4690,  4693,  4694,  4699,
    4705,  4711,  4716,  4723,  4725,  4729,  4731,  4733,  4735,  4737,
    4740,  4745,  4747,  4749,  4751,  4752,  4754,  4755,  4757,  4758,
    4762,  4763,  4766,  4771,  4775,  4781,  4783,  4785,  4787,  4789,
    4791,  4793,  4795,  4797,  4801,  4804,  4806,  4808,  4810,  4812,
    4814,  4815,  4821,  4826,  4830,  4831,  4833,  4835,  4837,  4839,
    4844,  4853,  4857,  4858,  4865,  4867,  4872,  4875,  4877,  4881,
    4884,  4888,  4889,  4897,  4900,  4901,  4907,  4911,  4912,  4915,
    4918,  4921,  4925,  4927,  4931,  4933,  4936,  4938,  4939,  4948,
    4950,  4954,  4956,  4958,  4962,  4968,  4971,  4973,  4977,  4985,
    4987,  4989,  4990,  4994,  4997,  5000,  5003,  5004,  5007,  5010,
    5012,  5014,  5018,  5022,  5024,  5027,  5032,  5037,  5040,  5044,
    5050,  5056,  5058,  5060,  5070,  5072,  5075,  5080,  5085,  5090,
    5093,  5097,  5099,  5103,  5110,  5112,  5113,  5116,  5118,  5119,
    5123,  5127,  5132,  5137,  5142,  5147,  5151,  5154,  5156,  5158,
    5159,  5161,  5163,  5164,  5166,  5172,  5174,  5175,  5177,  5178,
    5182,  5184,  5188,  5193,  5197,  5200,  5203,  5205,  5207,  5209,
    5210,  5213,  5218,  5224,  5227,  5231,  5233,  5235,  5237,  5239,
    5243,  5244,  5246,  5248,  5250,  5252,  5254,  5258,  5259,  5262,
    5263,  5265,  5269,  5271,  5272,  5274,  5277,  5282,  5287,  5290,
    5291,  5294,  5298,  5301,  5302,  5304,  5308,  5310,  5313,  5315,
    5318,  5324,  5331,  5337,  5339,  5342,  5344,  5349,  5353,  5358,
    5364,  5369,  5375,  5380,  5386,  5389,  5394,  5396,  5399,  5402,
    5405,  5407,  5409,  5410,  5415,  5418,  5420,  5423,  5426,  5431,
    5433,  5437,  5439,  5442,  5446,  5448,  5451,  5452,  5455,  5460,
    5461,  5463,  5464,  5466,  5470,  5474,  5477,  5481,  5487,  5494,
    5497,  5501,  5505,  5510,  5511,  5513,  5515,  5517,  5519,  5521,
    5524,  5530,  5532,  5534,  5536,  5538,  5541,  5545,  5549,  5550,
    5552,  5554,  5556,  5558,  5560,  5563,  5566,  5569,  5572,  5575,
    5577,  5581,  5582,  5584,  5586,  5588,  5590,  5596,  5599,  5601,
    5603,  5605,  5607,  5613,  5616,  5619,  5622,  5624,  5628,  5632,
    5635,  5637,  5638,  5642,  5643,  5649,  5652,  5658,  5661,  5663,
    5666,  5670,  5671,  5673,  5675,  5677,  5679,  5681,  5683,  5687,
    5691,  5695,  5699,  5703,  5707,  5711,  5712,  5714,  5719,  5721,
    5725,  5729,  5735,  5738,  5741,  5745,  5749,  5753,  5757,  5761,
    5765,  5769,  5773,  5777,  5781,  5784,  5787,  5791,  5795,  5798,
    5802,  5808,  5813,  5820,  5824,  5830,  5835,  5842,  5847,  5854,
    5860,  5868,  5872,  5875,  5880,  5883,  5887,  5891,  5896,  5900,
    5905,  5909,  5914,  5920,  5927,  5934,  5942,  5949,  5957,  5964,
    5972,  5976,  5981,  5986,  5993,  5996,  6000,  6005,  6007,  6011,
    6014,  6017,  6021,  6025,  6029,  6033,  6037,  6041,  6045,  6049,
    6053,  6057,  6060,  6063,  6069,  6076,  6083,  6091,  6095,  6100,
    6102,  6104,  6107,  6112,  6114,  6116,  6118,  6121,  6124,  6127,
    6129,  6134,  6140,  6147,  6156,  6163,  6171,  6179,  6185,  6187,
    6189,  6194,  6196,  6201,  6203,  6208,  6210,  6215,  6217,  6219,
    6221,  6223,  6225,  6227,  6234,  6239,  6244,  6249,  6254,  6261,
    6267,  6273,  6279,  6284,  6291,  6296,  6301,  6306,  6311,  6317,
    6325,  6333,  6343,  6349,  6354,  6361,  6367,  6375,  6383,  6391,
    6394,  6398,  6402,  6406,  6411,  6412,  6417,  6419,  6423,  6427,
    6429,  6431,  6433,  6436,  6439,  6440,  6443,  6448,  6453,  6460,
    6463,  6464,  6466,  6470,  6474,  6477,  6480,  6481,  6488,  6490,
    6491,  6495,  6496,  6499,  6502,  6503,  6505,  6510,  6513,  6516,
    6519,  6522,  6525,  6530,  6534,  6540,  6542,  6544,  6546,  6548,
    6550,  6552,  6554,  6556,  6558,  6560,  6562,  6564,  6566,  6568,
    6570,  6575,  6577,  6582,  6584,  6589,  6591,  6594,  6596,  6599,
    6601,  6605,  6607,  6611,  6613,  6617,  6619,  6623,  6627,  6631,
    6634,  6636,  6640,  6644,  6645,  6647,  6649,  6651,  6653,  6655,
    6657,  6659,  6661,  6666,  6670,  6673,  6677,  6678,  6682,  6686,
    6689,  6692,  6694,  6695,  6698,  6701,  6705,  6708,  6710,  6712,
    6716,  6722,  6724,  6727,  6732,  6735,  6736,  6738,  6739,  6741,
    6744,  6747,  6750,  6754,  6760,  6762,  6765,  6766,  6769,  6771,
    6772,  6774,  6776,  6778,  6782,  6786,  6788,  6792,  6796,  6799,
    6801,  6803,  6805,  6809,  6811,  6814,  6816,  6820,  6822,  6824,
    6826,  6828,  6830,  6832,  6834,  6837,  6839,  6841,  6843,  6845,
    6847,  6850,  6856,  6859,  6863,  6870,  6872,  6874,  6876,  6878,
    6880,  6882,  6884,  6886,  6888,  6891,  6894,  6896,  6898,  6900,
    6902,  6904,  6906,  6908,  6910,  6912,  6914,  6916,  6918,  6920,
    6922,  6924,  6926,  6928,  6930,  6932,  6934,  6936,  6938,  6940,
    6942,  6944,  6946,  6948,  6950,  6952,  6954,  6956,  6958,  6960,
    6962,  6964,  6966,  6968,  6970,  6972,  6974,  6976,  6978,  6980,
    6982,  6984,  6986,  6988,  6990,  6992,  6994,  6996,  6998,  7000,
    7002,  7004,  7006,  7008,  7010,  7012,  7014,  7016,  7018,  7020,
    7022,  7024,  7026,  7028,  7030,  7032,  7034,  7036,  7038,  7040,
    7042,  7044,  7046,  7048,  7050,  7052,  7054,  7056,  7058,  7060,
    7062,  7064,  7066,  7068,  7070,  7072,  7074,  7076,  7078,  7080,
    7082,  7084,  7086,  7088,  7090,  7092,  7094,  7096,  7098,  7100,
    7102,  7104,  7106,  7108,  7110,  7112,  7114,  7116,  7118,  7120,
    7122,  7124,  7126,  7128,  7130,  7132,  7134,  7136,  7138,  7140,
    7142,  7144,  7146,  7148,  7150,  7152,  7154,  7156,  7158,  7160,
    7162,  7164,  7166,  7168,  7170,  7172,  7174,  7176,  7178,  7180,
    7182,  7184,  7186,  7188,  7190,  7192,  7194,  7196,  7198,  7200,
    7202,  7204,  7206,  7208,  7210,  7212,  7214,  7216,  7218,  7220,
    7222,  7224,  7226,  7228,  7230,  7232,  7234,  7236,  7238,  7240,
    7242,  7244,  7246,  7248,  7250,  7252,  7254,  7256,  7258,  7260,
    7262,  7264,  7266,  7268,  7270,  7272,  7274,  7276,  7278,  7280,
    7282,  7284,  7286,  7288,  7290,  7292,  7294,  7296,  7298,  7300,
    7302,  7304,  7306,  7308,  7310,  7312,  7314,  7316,  7318,  7320,
    7322,  7324,  7326,  7328,  7330,  7332,  7334,  7336,  7338,  7340,
    7342,  7344,  7346,  7348,  7350,  7352,  7354,  7356,  7358,  7360,
    7362,  7364,  7366,  7368,  7370,  7372,  7374,  7376,  7378,  7380,
    7382,  7384,  7386,  7388,  7390,  7392,  7394,  7396,  7398,  7400,
    7402,  7404,  7406,  7408,  7410,  7412,  7414,  7416,  7418,  7420,
    7422,  7424,  7426,  7428,  7430,  7432,  7434,  7436,  7438,  7440,
    7442,  7444,  7446,  7448,  7450,  7452,  7454,  7456,  7458,  7460,
    7462,  7464,  7466,  7468,  7470,  7472,  7474,  7476,  7478,  7480,
    7482,  7484,  7486,  7488,  7490,  7492,  7494,  7496,  7498,  7500,
    7502,  7504,  7506,  7508,  7510,  7512,  7514,  7516,  7518,  7520,
    7522,  7524,  7526,  7528,  7530,  7532,  7534,  7536,  7538,  7540,
    7542,  7544,  7546,  7548,  7550,  7552,  7554,  7556,  7558,  7560,
    7562,  7564,  7566,  7568,  7570,  7572,  7574,  7576,  7578,  7580,
    7582,  7584,  7586,  7588,  7590,  7592,  7594,  7596,  7598,  7600,
    7602,  7604,  7606,  7608,  7610,  7612,  7614,  7616,  7618,  7620,
    7622,  7624,  7626,  7628,  7630,  7632,  7634,  7636,  7638,  7640,
    7642,  7644,  7646,  7648,  7650,  7652,  7653,  7656,  7661,  7665,
    7668,  7670,  7672,  7674,  7676,  7678,  7679,  7688,  7691,  7697,
    7701,  7704,  7707,  7711,  7719,  7721,  7723,  7725,  7726,  7729,
    7732,  7734,  7735,  7737,  7741,  7743,  7746,  7747,  7750,  7751,
    7754,  7755,  7757,  7761,  7766,  7770,  7772,  7774,  7776,  7778,
    7781,  7782,  7785,  7790,  7791,  7794,  7797,  7800,  7802,  7804,
    7812,  7816,  7818,  7820,  7822,  7824,  7827,  7828,  7830,  7834,
    7838,  7842,  7846,  7847,  7852,  7858,  7864,  7865,  7867,  7869,
    7871,  7874,  7877,  7879,  7882,  7883,  7891,  7892,  7898,  7899,
    7904,  7907,  7910,  7911,  7914,  7916,  7918,  7920,  7922,  7924,
    7926,  7928,  7930,  7932,  7934,  7936,  7942,  7945,  7947,  7951,
    7954,  7957,  7961,  7962,  7968,  7970,  7971,  7977,  7980,  7983,
    7985,  7987,  7989,  7992,  7995,  7999,  8001,  8004,  8007,  8011,
    8015,  8020,  8023,  8025,  8028,  8030,  8032,  8035,  8038,  8042,
    8044,  8046,  8048,  8050,  8051,  8053,  8057,  8063,  8064,  8067,
    8068,  8070,  8073,  8077,  8080,  8082,  8084,  8086,  8087,  8089,
    8091,  8093,  8095,  8097,  8100,  8103,  8107,  8108,  8110,  8113,
    8115,  8120,  8124,  8129,  8133,  8136,  8138,  8142,  8144,  8146,
    8148,  8150,  8153,  8156,  8158,  8161,  8164,  8166,  8168,  8170,
    8175,  8180,  8185,  8190,  8195,  8197,  8198,  8202,  8206,  8211,
    8213,  8217,  8221,  8226,  8228,  8232,  8236,  8238,  8240,  8242,
    8249,  8251,  8255,  8259,  8266,  8268,  8272,  8276,  8278,  8280,
    8283,  8286,  8288,  8290,  8292,  8294,  8296,  8298,  8300,  8302,
    8304,  8306,  8308,  8310,  8312,  8314,  8316,  8318,  8323,  8328,
    8330,  8332,  8337,  8342,  8346,  8347,  8355,  8357,  8358,  8359,
    8367,  8371,  8376,  8380,  8382,  8384,  8386,  8389,  8393,  8399,
    8402,  8408,  8411,  8413,  8415,  8417,  8419,  8421,  8423,  8425,
    8427,  8429,  8431,  8433,  8435,  8437,  8439,  8441,  8443,  8445,
    8447,  8449,  8451,  8453,  8455,  8457,  8459,  8461,  8463,  8465,
    8467,  8469,  8471,  8473,  8475,  8477,  8479,  8481,  8483,  8485,
    8487,  8489,  8491,  8493,  8495,  8497,  8499,  8501,  8503,  8505,
    8507,  8509,  8511,  8513,  8515,  8517,  8519,  8521,  8523,  8525,
    8527,  8529,  8531,  8533,  8535,  8537,  8539,  8541,  8543,  8545,
    8547,  8549,  8551,  8553,  8555,  8557,  8559,  8561,  8563,  8565,
    8567,  8569,  8571,  8573,  8575,  8577,  8579,  8581,  8583,  8585,
    8587,  8589,  8591,  8593,  8595,  8597,  8599,  8601,  8603,  8605,
    8607,  8611,  8613,  8614,  8616,  8619,  8621,  8624,  8626,  8628,
    8630,  8633,  8636,  8638,  8640,  8642,  8644,  8646,  8648,  8650,
    8652,  8654,  8656,  8658,  8660,  8662,  8664,  8666,  8668,  8671,
    8675,  8677,  8680,  8682,  8686,  8688,  8692,  8694,  8696,  8698,
    8700,  8702,  8704,  8706,  8708,  8710,  8712,  8714,  8716,  8718,
    8720,  8722,  8724,  8726,  8728,  8730,  8732,  8734,  8736,  8738,
    8740,  8742,  8744,  8746,  8748,  8750,  8752,  8754,  8756,  8758,
    8760,  8762,  8764,  8766,  8768,  8770,  8772,  8774,  8776,  8778,
    8780,  8782,  8784,  8786,  8788,  8790,  8792,  8794,  8796,  8798,
    8800,  8802,  8804,  8806,  8808,  8810,  8812,  8814,  8817,  8821,
    8824,  8828,  8830,  8834,  8838,  8842,  8846,  8850,  8854,  8856,
    8858,  8859,  8862,  8865,  8867,  8869,  8872,  8874,  8876,  8878,
    8879
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     509,     0,    -1,  1046,    -1,   836,    -1,   837,    -1,   754,
      -1,   842,    -1,   705,    -1,   644,    -1,   647,    -1,   653,
      -1,   667,    -1,   672,    -1,   789,    -1,   526,    -1,   810,
      -1,   811,    -1,   623,    -1,   551,    -1,   562,    -1,   520,
      -1,   518,    -1,   845,    -1,   844,    -1,   676,    -1,   522,
      -1,   521,    -1,   852,    -1,   549,    -1,   565,    -1,   847,
      -1,   728,    -1,   546,    -1,   566,    -1,  1048,    -1,   692,
      -1,   800,    -1,   846,    -1,   841,    -1,   641,    -1,   648,
      -1,   662,    -1,   668,    -1,   770,    -1,   525,    -1,   706,
      -1,   713,    -1,   714,    -1,   630,    -1,   529,    -1,   622,
      -1,   581,    -1,   638,    -1,   677,    -1,   511,    -1,   517,
      -1,   673,    -1,   832,    -1,  1189,    -1,   887,    -1,   694,
      -1,   874,    -1,   550,    -1,   797,    -1,   693,    -1,   802,
      -1,   652,    -1,   666,    -1,   528,    -1,   717,    -1,   718,
      -1,   719,    -1,   636,    -1,   819,    -1,   721,    -1,   640,
      -1,   691,    -1,   523,    -1,   524,    -1,   675,    -1,   840,
      -1,   867,    -1,   858,    -1,   735,    -1,   739,    -1,   750,
      -1,   759,    -1,   869,    -1,   822,    -1,   831,    -1,   876,
      -1,   820,    -1,   864,    -1,   720,    -1,   804,    -1,   793,
      -1,   792,    -1,   794,    -1,   807,    -1,   740,    -1,   751,
      -1,   812,    -1,   731,    -1,   891,    -1,   824,    -1,   726,
      -1,   823,    -1,   880,    -1,   849,    -1,   543,    -1,   533,
      -1,   545,    -1,   829,    -1,  1125,    -1,  1051,    -1,  1068,
      -1,  1126,    -1,  1108,    -1,  1123,    -1,  1109,    -1,  1069,
      -1,  1113,    -1,  1135,    -1,  1127,    -1,  1114,    -1,  1143,
      -1,  1145,    -1,  1138,    -1,  1130,    -1,  1146,    -1,  1149,
      -1,  1151,    -1,    -1,   160,   377,  1040,   512,   513,    -1,
     466,    -1,    -1,   513,   516,    -1,    -1,   514,   515,    -1,
      -1,   340,  1179,    -1,   340,   313,    -1,   202,   340,  1179,
      -1,   439,   340,  1179,    -1,   252,    -1,   152,   284,  1041,
      -1,   450,   445,  1179,    -1,   447,  1030,    -1,  1181,    -1,
     515,    -1,   415,  1039,    -1,    96,  1030,    -1,   377,  1030,
      -1,   247,   377,  1030,    -1,   247,   235,  1030,    -1,   160,
     447,  1040,   512,   513,    -1,   101,   377,  1040,   512,   514,
      -1,    -1,   247,   174,  1032,    -1,   101,   377,  1040,   519,
     544,    -1,   101,   447,  1040,   512,   514,    -1,   101,   447,
    1040,   544,    -1,   197,   377,  1030,    -1,   197,   377,   242,
     211,  1030,    -1,   197,   447,  1030,    -1,   197,   447,   242,
     211,  1030,    -1,   160,   235,  1040,   512,   513,    -1,   101,
     235,  1040,   527,   447,  1030,    -1,    95,    -1,   197,    -1,
     197,   235,  1030,    -1,   197,   235,   242,   211,  1030,    -1,
     160,   383,   530,   115,  1040,   531,    -1,   160,   383,  1159,
     531,    -1,  1159,    -1,    -1,   531,   532,    -1,    -1,   581,
      -1,   759,    -1,   622,    -1,   677,    -1,   739,    -1,   829,
      -1,   395,   534,    -1,   395,   287,   534,    -1,   395,   393,
     534,    -1,   535,   427,   536,    -1,   535,   487,   536,    -1,
     535,   427,   180,    -1,   535,   487,   180,    -1,   535,   227,
     163,    -1,   425,   483,   540,    -1,   429,   827,    -1,   393,
     136,   108,   429,   827,    -1,   132,  1179,    -1,   383,  1179,
      -1,   301,   541,    -1,   377,   542,    -1,   393,   115,   542,
      -1,   393,   115,   180,    -1,   471,   325,   977,    -1,  1158,
      -1,   535,   502,  1159,    -1,   537,    -1,   536,   503,   537,
      -1,   539,    -1,   628,    -1,   356,   438,    -1,   356,   149,
      -1,   367,   356,    -1,   391,    -1,   433,    -1,   216,    -1,
     322,    -1,   542,    -1,  1179,    -1,  1181,    -1,   964,  1179,
     966,    -1,   964,   500,  1039,   501,  1179,   966,    -1,   628,
      -1,   180,    -1,   287,    -1,  1179,    -1,   180,    -1,    -1,
    1159,    -1,  1179,    -1,   370,   535,    -1,   370,   425,   483,
      -1,   370,   429,   270,   282,    -1,   370,   393,   115,    -1,
     370,    99,    -1,   395,   534,    -1,   543,    -1,   398,   535,
    1192,    -1,   398,   425,   483,  1192,    -1,   398,   429,   270,
     282,  1192,    -1,   398,   393,   115,  1192,    -1,   398,    99,
      -1,   395,   154,   547,   548,    -1,    99,    -1,  1028,    -1,
     183,    -1,   244,    -1,   138,    -1,   191,    99,    -1,   191,
     420,    -1,   191,   422,    -1,   191,   342,    -1,   101,   417,
     935,   552,    -1,   101,   250,  1029,   552,    -1,   101,   389,
    1029,   552,    -1,   101,   460,  1029,   552,    -1,   553,    -1,
     552,   503,   553,    -1,    95,   589,    -1,    95,   145,   589,
      -1,   101,   808,  1159,   554,    -1,   101,   808,  1159,   197,
     308,   313,    -1,   101,   808,  1159,   395,   308,   313,    -1,
     101,   808,  1159,   395,   407,  1041,    -1,   101,   808,  1159,
     395,   558,    -1,   101,   808,  1159,   370,   558,    -1,   101,
     808,  1159,   395,   410,  1159,    -1,   197,   808,   242,   211,
    1159,   555,    -1,   197,   808,  1159,   555,    -1,   101,   808,
    1159,   809,   436,   944,   556,   557,    -1,    95,   598,    -1,
     451,   153,  1031,    -1,   197,   153,   242,   211,  1031,   555,
      -1,   197,   153,  1031,   555,    -1,   395,   466,   321,    -1,
     395,   467,   321,    -1,   141,   322,  1031,    -1,   395,   467,
     141,    -1,   200,   431,  1031,    -1,   200,   102,   431,  1031,
      -1,   200,   369,   431,  1031,    -1,   200,   431,    99,    -1,
     200,   431,   447,    -1,   190,   431,  1031,    -1,   190,   431,
      99,    -1,   190,   431,   447,    -1,   200,   381,  1031,    -1,
     200,   102,   381,  1031,    -1,   200,   369,   381,  1031,    -1,
     190,   381,  1031,    -1,   252,  1029,    -1,   306,   252,  1029,
      -1,   318,   724,    -1,   308,   318,    -1,   335,   427,  1040,
      -1,   395,   419,  1031,    -1,   395,   558,    -1,   370,   558,
      -1,   656,    -1,   395,   180,   968,    -1,   197,   180,    -1,
     128,    -1,   372,    -1,    -1,   143,   724,    -1,    -1,   448,
     968,    -1,    -1,   500,   560,   501,    -1,   466,   558,    -1,
      -1,   561,    -1,   560,   503,   561,    -1,  1161,   487,   698,
      -1,  1161,    -1,  1161,   502,  1161,   487,   698,    -1,  1161,
     502,  1161,    -1,   101,   436,   724,   563,    -1,   564,    -1,
     563,   503,   564,    -1,    95,   114,   943,   555,    -1,   197,
     114,   242,   211,  1159,   555,    -1,   197,   114,  1159,   555,
      -1,   101,   114,  1159,   809,   436,   944,   556,   555,    -1,
     140,   888,    -1,   140,    99,    -1,   158,   572,  1029,   600,
     573,   567,   568,   574,   512,   569,    -1,   158,   892,   427,
     568,   512,   569,    -1,   227,    -1,   427,    -1,  1179,    -1,
     408,    -1,   409,    -1,   570,    -1,   500,   576,   501,    -1,
     570,   571,    -1,    -1,   121,    -1,   321,    -1,   186,   843,
    1179,    -1,   313,   843,  1179,    -1,   162,    -1,   238,    -1,
     354,   843,  1179,    -1,   205,   843,  1179,    -1,   223,   354,
     601,    -1,   223,   354,   493,    -1,   223,   308,   313,   601,
      -1,   201,  1179,    -1,   121,    -1,    -1,   466,   321,    -1,
      -1,   575,   187,  1179,    -1,    -1,   448,    -1,    -1,   577,
      -1,   576,   503,   577,    -1,  1161,   578,    -1,   539,    -1,
     628,    -1,   493,    -1,   500,   579,   501,    -1,    -1,   580,
      -1,   579,   503,   580,    -1,   539,    -1,   160,   582,   417,
    1029,   500,   583,   501,   611,   612,   613,   614,    -1,   160,
     582,   417,   242,   308,   211,  1029,   500,   583,   501,   611,
     612,   613,   614,    -1,   160,   582,   417,  1029,   318,   724,
     584,   612,   613,   614,    -1,   160,   582,   417,   242,   308,
     211,  1029,   318,   724,   584,   612,   613,   614,    -1,   422,
      -1,   420,    -1,   287,   422,    -1,   287,   420,    -1,   231,
     422,    -1,   231,   420,    -1,   444,    -1,    -1,   585,    -1,
      -1,   500,   586,   501,    -1,    -1,   587,    -1,   585,   503,
     587,    -1,   588,    -1,   586,   503,   588,    -1,   589,    -1,
     595,    -1,   598,    -1,   590,    -1,   598,    -1,  1159,   944,
     591,    -1,  1159,   466,   326,   591,    -1,   591,   592,    -1,
      -1,   153,  1031,   593,    -1,   593,    -1,   594,    -1,   143,
     724,    -1,   308,   313,    -1,   313,    -1,   441,   786,   615,
      -1,   349,   272,   786,   615,    -1,   137,   500,   968,   501,
      -1,   180,   969,    -1,   362,  1029,   600,   603,   607,    -1,
     182,    -1,   308,   182,    -1,   254,   183,    -1,   254,   244,
      -1,   283,  1029,   596,    -1,   596,   248,   597,    -1,   596,
     208,   597,    -1,    -1,   181,    -1,   154,    -1,   251,    -1,
     410,    -1,   147,    -1,    99,    -1,   153,  1031,   599,    -1,
     599,    -1,   137,   500,   968,   501,   688,    -1,   441,   500,
     601,   501,   786,   615,   688,    -1,   441,   616,   688,    -1,
     349,   272,   500,   601,   501,   786,   615,   688,    -1,   349,
     272,   616,   688,    -1,   207,   763,   500,   604,   501,   786,
     615,   606,   688,    -1,   224,   272,   500,   601,   501,   362,
    1029,   600,   603,   607,   688,    -1,   224,   272,   500,   601,
     501,   362,  1029,   600,   603,   607,   308,   450,    -1,   500,
     601,   501,    -1,    -1,   602,    -1,   601,   503,   602,    -1,
    1159,    -1,   293,   228,    -1,   293,   337,    -1,   293,   400,
      -1,    -1,   605,    -1,   604,   503,   605,    -1,   765,   466,
     796,    -1,   765,   466,   324,   500,   796,   501,    -1,   463,
     500,   968,   501,    -1,    -1,   608,    -1,   609,    -1,   608,
     609,    -1,   609,   608,    -1,    -1,   322,   446,   610,    -1,
     322,   185,   610,    -1,   306,    94,    -1,   372,    -1,   128,
      -1,   395,   313,    -1,   395,   180,    -1,   253,   500,  1028,
     501,    -1,    -1,   466,   558,    -1,   466,   321,    -1,   467,
     321,    -1,    -1,   322,   148,   197,    -1,   322,   148,   185,
     380,    -1,   322,   148,   346,   380,    -1,    -1,   419,  1031,
      -1,    -1,   448,   250,   419,  1031,    -1,    -1,   448,   250,
    1035,    -1,  1029,   618,   612,   613,   614,    -1,   500,   619,
     501,    -1,    -1,   620,    -1,   619,   503,   620,    -1,  1159,
      -1,   466,   173,    -1,   466,   306,   173,    -1,    -1,   160,
     582,   389,  1029,   624,    -1,   101,   389,  1029,   625,    -1,
     625,    -1,    -1,   626,    -1,   625,   626,    -1,   126,   628,
      -1,   172,    -1,   306,   172,    -1,   249,   627,   628,    -1,
     294,   628,    -1,   296,   628,    -1,   306,   294,    -1,   306,
     296,    -1,   334,   125,   724,    -1,   405,   512,   628,    -1,
     371,    -1,   371,   512,   628,    -1,   125,    -1,    -1,  1178,
      -1,   492,  1178,    -1,  1041,    -1,   628,    -1,   629,   503,
     628,    -1,   160,   771,   631,   637,   274,   542,    -1,   160,
     771,   631,   637,   274,   542,   236,   632,   633,   635,    -1,
     435,    -1,    -1,  1031,    -1,  1031,   725,    -1,   255,   632,
      -1,    -1,   452,   632,    -1,   306,   452,    -1,   634,    -1,
      -1,   197,   637,   274,   542,   555,    -1,   197,   637,   274,
     242,   211,   542,   555,    -1,   352,    -1,    -1,   160,   419,
    1031,   639,   290,  1179,    -1,   335,  1031,    -1,    -1,   197,
     419,  1031,    -1,   197,   419,   242,   211,  1031,    -1,   160,
     213,  1031,   512,   642,    -1,   160,   213,   242,   308,   211,
    1031,   512,   642,    -1,   642,   643,    -1,    -1,   383,  1031,
      -1,   459,   542,    -1,   227,   542,    -1,   101,   213,  1031,
     446,   645,    -1,   645,   646,    -1,    -1,   427,   542,    -1,
     101,   213,  1031,   527,    98,  1037,   699,    -1,   101,   213,
    1031,   527,   131,   500,   944,   108,   944,   501,    -1,   101,
     213,  1031,   527,   144,   724,    -1,   101,   213,  1031,   527,
     157,   724,    -1,   101,   213,  1031,   527,   195,   724,    -1,
     101,   213,  1031,   527,   229,   749,    -1,   101,   213,  1031,
     527,   637,   274,  1031,    -1,   101,   213,  1031,   527,   324,
     796,   795,    -1,   101,   213,  1031,   527,   324,   139,   724,
     448,  1033,    -1,   101,   213,  1031,   527,   324,   217,   724,
     448,  1033,    -1,   101,   213,  1031,   527,   383,  1031,    -1,
     101,   213,  1031,   527,   417,   724,    -1,   101,   213,  1031,
     527,   423,   385,   336,   724,    -1,   101,   213,  1031,   527,
     423,   385,   189,   724,    -1,   101,   213,  1031,   527,   423,
     385,   421,   724,    -1,   101,   213,  1031,   527,   423,   385,
     151,   724,    -1,   101,   213,  1031,   527,   389,   724,    -1,
     101,   213,  1031,   527,   460,   724,    -1,   101,   213,  1031,
     527,   224,   417,   724,    -1,   101,   213,  1031,   527,   224,
     173,   469,  1031,    -1,   101,   213,  1031,   527,   392,  1031,
      -1,   101,   213,  1031,   527,   436,   724,    -1,   160,   224,
     173,   469,  1031,   651,   654,    -1,   236,   632,    -1,   306,
     236,    -1,   452,   632,    -1,   306,   452,    -1,   649,    -1,
     650,   649,    -1,   650,    -1,    -1,   197,   224,   173,   469,
    1031,   555,    -1,   197,   224,   173,   469,   242,   211,  1031,
     555,    -1,   101,   224,   173,   469,  1031,   651,   656,    -1,
     101,   224,   173,   469,  1031,   650,    -1,   326,   500,   655,
     501,    -1,    -1,   659,    -1,   655,   503,   659,    -1,   326,
     500,   657,   501,    -1,   658,    -1,   657,   503,   658,    -1,
     659,    -1,   395,   659,    -1,    95,   659,    -1,   197,   660,
      -1,   660,   661,    -1,  1161,    -1,  1179,    -1,   160,   392,
    1031,   663,   665,   224,   173,   469,  1031,   654,    -1,   436,
    1179,    -1,    -1,   459,  1179,    -1,   459,   313,    -1,   664,
      -1,    -1,   197,   392,  1031,   555,    -1,   197,   392,   242,
     211,  1031,   555,    -1,   101,   392,  1031,   664,   656,    -1,
     101,   392,  1031,   664,    -1,   101,   392,  1031,   656,    -1,
     160,   224,   417,  1029,   669,   392,  1031,   654,    -1,   160,
     224,   417,   242,   308,   211,  1029,   669,   392,  1031,   654,
      -1,   500,   670,   501,    -1,   500,   501,    -1,   671,    -1,
     670,   503,   671,    -1,   589,    -1,   101,   224,   417,   935,
     552,    -1,   160,   447,   292,   222,   674,   392,  1031,   654,
      -1,   170,    -1,   447,    -1,  1040,    -1,   197,   447,   292,
     222,   674,   392,  1031,    -1,   197,   447,   292,   242,   211,
     222,   674,   392,  1031,    -1,   101,   447,   292,   222,   674,
     392,  1031,   656,    -1,   160,   431,  1031,   678,   679,   322,
    1029,   681,   684,   210,   353,  1037,   500,   685,   501,    -1,
     160,   153,   431,  1031,    97,   679,   322,  1029,   687,   688,
     222,   198,   379,   684,   210,   353,  1037,   500,   685,   501,
      -1,   117,    -1,    97,    -1,   261,   318,    -1,   680,    -1,
     679,   327,   680,    -1,   260,    -1,   185,    -1,   446,    -1,
     446,   318,   601,    -1,   434,    -1,   222,   682,   683,    -1,
      -1,   198,    -1,    -1,   379,    -1,   406,    -1,   462,   500,
     968,   501,    -1,    -1,   686,    -1,   685,   503,   686,    -1,
      -1,  1039,    -1,  1178,    -1,  1179,    -1,  1161,    -1,   227,
    1029,    -1,    -1,   689,    -1,   689,   690,    -1,   690,    -1,
     690,   689,    -1,    -1,   308,   182,    -1,   182,    -1,   254,
     244,    -1,   254,   183,    -1,   197,   431,  1031,   322,  1029,
     555,    -1,   197,   431,   242,   211,  1031,   322,  1029,   555,
      -1,   160,   110,  1031,   137,   500,   968,   501,   688,    -1,
     197,   110,  1031,   555,    -1,   160,    98,  1037,   699,   695,
      -1,   160,    98,  1037,   700,    -1,   160,   324,   796,   695,
      -1,   160,   436,   724,   695,    -1,   160,   436,   724,    -1,
     160,   436,   724,   108,   500,   941,   501,    -1,   160,   436,
     724,   108,   204,   500,   703,   501,    -1,   160,   423,   385,
     336,   724,   695,    -1,   160,   423,   385,   189,   724,   695,
      -1,   160,   423,   385,   421,   724,   695,    -1,   160,   423,
     385,   151,   724,   695,    -1,   160,   144,   724,   695,    -1,
     160,   144,   724,   227,   724,    -1,   500,   696,   501,    -1,
     697,    -1,   696,   503,   697,    -1,  1161,   487,   698,    -1,
    1161,    -1,   780,    -1,  1045,    -1,   995,    -1,   628,    -1,
    1179,    -1,   500,  1000,   501,    -1,   500,   493,   501,    -1,
     500,   701,   501,    -1,   702,    -1,   701,   503,   702,    -1,
    1181,   487,   698,    -1,   704,    -1,    -1,  1179,    -1,   704,
     503,  1179,    -1,   101,   436,   724,    95,   453,  1179,    -1,
     101,   436,   724,    95,   453,  1179,   117,  1179,    -1,   101,
     436,   724,    95,   453,  1179,    97,  1179,    -1,   160,   324,
     139,   724,   709,   222,   436,   944,   448,  1033,   710,   108,
     707,    -1,   708,    -1,   707,   503,   708,    -1,   324,  1039,
     796,   711,   712,    -1,   324,  1039,   796,   795,   711,   712,
      -1,   229,  1039,  1037,   772,    -1,   229,  1039,   500,  1000,
     501,  1037,   772,    -1,   410,   944,    -1,   180,    -1,    -1,
     217,   724,    -1,    -1,   222,   385,    -1,   222,   328,   125,
     724,    -1,    -1,   359,    -1,    -1,   160,   324,   217,   724,
     448,  1033,    -1,   101,   324,   217,   724,   448,  1033,    95,
     707,    -1,   101,   324,   217,   724,   448,  1033,   197,   715,
      -1,   716,    -1,   715,   503,   716,    -1,   324,  1039,   500,
    1000,   501,    -1,   229,  1039,   500,  1000,   501,    -1,   197,
     324,   139,   724,   448,  1033,   555,    -1,   197,   324,   139,
     242,   211,   724,   448,  1033,   555,    -1,   197,   324,   217,
     724,   448,  1033,   555,    -1,   197,   324,   217,   242,   211,
     724,   448,  1033,   555,    -1,   197,   334,   125,  1030,   555,
      -1,   358,   334,   125,  1030,   427,  1031,    -1,   197,   722,
     242,   211,   723,   555,    -1,   197,   722,   723,   555,    -1,
     417,    -1,   389,    -1,   460,    -1,   250,    -1,   224,   417,
      -1,   436,    -1,   195,    -1,   144,    -1,   157,    -1,   383,
      -1,   213,    -1,   423,   385,   336,    -1,   423,   385,   189,
      -1,   423,   385,   421,    -1,   423,   385,   151,    -1,   724,
      -1,   723,   503,   724,    -1,  1159,    -1,  1159,   725,    -1,
     502,  1034,    -1,   725,   502,  1034,    -1,   434,   902,   936,
     727,   555,    -1,   156,   241,    -1,   371,   241,    -1,    -1,
     146,   322,   729,   724,   268,   730,    -1,   146,   322,    98,
    1037,   699,   268,   730,    -1,   146,   322,   229,  1037,   772,
     268,   730,    -1,   146,   322,   324,   796,   795,   268,   730,
      -1,   146,   322,   153,  1031,   322,   724,   268,   730,    -1,
     146,   322,   381,  1031,   322,   724,   268,   730,    -1,   146,
     322,   381,  1031,   268,   730,    -1,   146,   322,   431,  1031,
     322,   724,   268,   730,    -1,   146,   322,   324,   139,   724,
     448,  1033,   268,   730,    -1,   146,   322,   324,   217,   724,
     448,  1033,   268,   730,    -1,   146,   322,   275,   317,   628,
     268,   730,    -1,   146,   322,   131,   500,   944,   108,   944,
     501,   268,   730,    -1,   146,   322,   637,   274,   724,   268,
     730,    -1,   146,   322,   423,   385,   336,   724,   268,   730,
      -1,   146,   322,   423,   385,   189,   724,   268,   730,    -1,
     146,   322,   423,   385,   421,   724,   268,   730,    -1,   146,
     322,   423,   385,   151,   724,   268,   730,    -1,   145,    -1,
     174,    -1,   383,    -1,   250,    -1,   389,    -1,   417,    -1,
     195,    -1,   436,    -1,   460,    -1,   144,    -1,   157,    -1,
     419,    -1,   213,    -1,   377,    -1,   224,   417,    -1,   392,
      -1,   224,   173,   469,    -1,  1179,    -1,   313,    -1,   387,
     273,   732,   322,   733,   724,   268,   734,    -1,   387,   273,
     732,   322,    98,  1037,   699,   268,   734,    -1,   387,   273,
     732,   322,   229,  1037,   772,   268,   734,    -1,   387,   273,
     732,   322,   275,   317,   628,   268,   734,    -1,   387,   273,
     732,   322,   637,   274,   724,   268,   734,    -1,   222,   542,
      -1,    -1,   145,    -1,   224,   417,    -1,   383,    -1,   389,
      -1,   417,    -1,   195,    -1,   436,    -1,   460,    -1,  1179,
      -1,   313,    -1,   218,   736,    -1,   299,   736,    -1,   218,
     736,  1193,    -1,   218,   225,   888,  1194,    -1,   218,   225,
     737,   888,  1194,    -1,   218,   116,   888,  1194,    -1,   218,
     116,   737,   888,  1194,    -1,   299,   225,   888,    -1,   299,
     225,   737,   888,    -1,   299,   116,   888,    -1,   299,   116,
     737,   888,    -1,   888,    -1,   737,   888,    -1,   305,   738,
     888,    -1,   350,   738,   888,    -1,   219,   738,   888,    -1,
     276,   738,   888,    -1,    92,  1041,   738,   888,    -1,   364,
    1041,   738,   888,    -1,  1041,   738,   888,    -1,    99,   738,
     888,    -1,   225,  1041,   738,   888,    -1,   225,    99,   738,
     888,    -1,   116,  1041,   738,   888,    -1,   116,    99,   738,
     888,    -1,   227,    -1,   247,    -1,   737,    -1,    -1,   232,
     741,   322,   744,   427,   745,   747,    -1,   375,   741,   322,
     744,   227,   745,   555,    -1,   375,   232,   325,   222,   741,
     322,   744,   227,   745,   555,    -1,   742,    -1,    99,    -1,
      99,   351,    -1,    99,   500,   601,   501,    -1,    99,   351,
     500,   601,   501,    -1,   743,    -1,   742,   503,   743,    -1,
     388,   600,    -1,   362,   600,    -1,   160,   600,    -1,  1159,
     600,    -1,  1028,    -1,   417,  1028,    -1,   389,  1028,    -1,
     224,   173,   469,  1030,    -1,   224,   392,  1030,    -1,   229,
     748,    -1,   174,  1030,    -1,   274,  1030,    -1,   275,   317,
     629,    -1,   383,  1030,    -1,   419,  1030,    -1,    99,   418,
     247,   383,  1030,    -1,    99,   390,   247,   383,  1030,    -1,
      99,   230,   247,   383,  1030,    -1,   746,    -1,   745,   503,
     746,    -1,  1040,    -1,   235,  1040,    -1,   466,   232,   325,
      -1,    -1,   749,    -1,   748,   503,   749,    -1,  1037,   772,
      -1,   232,   742,   427,  1030,   752,   753,    -1,   375,   742,
     227,  1030,   753,   555,    -1,   375,    96,   325,   222,   742,
     227,  1030,   753,   555,    -1,   466,    96,   325,    -1,    -1,
     233,   125,  1040,    -1,    -1,   101,   180,   351,   755,   757,
      -1,   755,   756,    -1,    -1,   247,   383,  1030,    -1,   222,
     377,  1030,    -1,   222,   447,  1030,    -1,   232,   741,   322,
     758,   427,   745,   747,    -1,   375,   741,   322,   758,   227,
     745,   555,    -1,   375,   232,   325,   222,   741,   322,   758,
     227,   745,   555,    -1,   418,    -1,   230,    -1,   390,    -1,
     160,   760,   250,   761,   762,   322,  1029,   763,   500,   764,
     501,   559,   614,   939,    -1,   441,    -1,    -1,   150,    -1,
      -1,  1035,    -1,    -1,   448,  1033,    -1,    -1,   765,    -1,
     764,   503,   765,    -1,  1159,   766,   767,   768,   769,    -1,
     971,   766,   767,   768,   769,    -1,   500,   968,   501,   766,
     767,   768,   769,    -1,   143,   724,    -1,    -1,   724,    -1,
     448,   724,    -1,    -1,   109,    -1,   188,    -1,    -1,   484,
      -1,   485,    -1,    -1,   160,   771,   229,  1037,   774,   374,
     779,   782,   786,    -1,   160,   771,   229,  1037,   774,   374,
     417,   500,   788,   501,   782,   786,    -1,   160,   771,   229,
    1037,   774,   782,   786,    -1,   327,   368,    -1,    -1,   500,
     773,   501,    -1,   500,   501,    -1,   776,    -1,   773,   503,
     776,    -1,   500,   775,   501,    -1,   500,   501,    -1,   781,
      -1,   775,   503,   781,    -1,   777,   778,   780,    -1,   778,
     777,   780,    -1,   778,   780,    -1,   777,   780,    -1,   780,
      -1,   247,    -1,   329,    -1,   257,    -1,   247,   329,    -1,
     456,    -1,  1160,    -1,   780,    -1,   944,    -1,  1160,   725,
     495,   436,    -1,   396,  1160,   725,   495,   436,    -1,   776,
      -1,   776,   180,   968,    -1,   776,   487,   968,    -1,   784,
      -1,   782,   784,    -1,   127,   322,   313,   258,    -1,   374,
     313,   322,   313,   258,    -1,   411,    -1,   245,    -1,   403,
      -1,   461,    -1,   214,   387,   184,    -1,   214,   387,   267,
      -1,   387,   184,    -1,   387,   267,    -1,   159,   628,    -1,
     380,   628,    -1,   544,    -1,   108,   785,    -1,   274,   542,
      -1,   465,    -1,   783,    -1,  1179,    -1,  1179,   503,  1179,
      -1,   466,   695,    -1,    -1,   778,   780,    -1,   787,    -1,
     788,   503,   787,    -1,   101,   229,   749,   790,   791,    -1,
     783,    -1,   790,   783,    -1,   372,    -1,    -1,   197,   229,
    1037,   772,   555,    -1,   197,   229,   242,   211,  1037,   772,
     555,    -1,   197,    98,  1037,   699,   555,    -1,   197,    98,
     242,   211,  1037,   699,   555,    -1,   197,   324,   796,   795,
     555,    -1,   197,   324,   242,   211,   796,   795,   555,    -1,
     500,   944,   501,    -1,   500,   944,   503,   944,   501,    -1,
     500,   307,   503,   944,   501,    -1,   500,   944,   503,   307,
     501,    -1,   992,    -1,  1159,   502,   796,    -1,   193,   798,
      -1,   799,    -1,   798,   799,    -1,  1179,    -1,   274,   542,
      -1,   160,   131,   500,   944,   108,   944,   501,   466,   229,
     749,   801,    -1,   160,   131,   500,   944,   108,   944,   501,
     467,   229,   801,    -1,   160,   131,   500,   944,   108,   944,
     501,   466,   257,   801,    -1,   108,   246,    -1,   108,   111,
      -1,    -1,   197,   131,   803,   500,   944,   108,   944,   501,
     555,    -1,   242,   211,    -1,    -1,   363,   805,  1029,   806,
      -1,   363,   416,  1031,   806,    -1,   363,   174,  1031,   806,
      -1,   250,    -1,   417,    -1,   223,    -1,    -1,   101,    98,
    1037,   699,   366,   427,  1031,    -1,   101,   144,   724,   366,
     427,  1031,    -1,   101,   157,   724,   366,   427,  1031,    -1,
     101,   174,  1032,   366,   427,  1032,    -1,   101,   229,   749,
     366,   427,  1031,    -1,   101,   235,  1040,   366,   427,  1040,
      -1,   101,   637,   274,  1031,   366,   427,  1031,    -1,   101,
     324,   139,   724,   448,  1033,   366,   427,  1031,    -1,   101,
     324,   217,   724,   448,  1033,   366,   427,  1031,    -1,   101,
     383,  1031,   366,   427,  1031,    -1,   101,   417,   935,   366,
     427,  1031,    -1,   101,   389,  1029,   366,   427,  1031,    -1,
     101,   460,  1029,   366,   427,  1031,    -1,   101,   250,  1029,
     366,   427,  1031,    -1,   101,   224,   417,   935,   366,   427,
    1031,    -1,   101,   417,   935,   366,   808,  1031,   427,  1031,
      -1,   101,   224,   417,   935,   366,   808,  1031,   427,  1031,
      -1,   101,   431,  1031,   322,  1029,   366,   427,  1031,    -1,
     101,   377,  1040,   366,   427,  1040,    -1,   101,   447,  1040,
     366,   427,  1040,    -1,   101,   419,  1031,   366,   427,  1031,
      -1,   101,   419,  1031,   395,   558,    -1,   101,   419,  1031,
     370,   558,    -1,   101,   423,   385,   336,   724,   366,   427,
    1031,    -1,   101,   423,   385,   189,   724,   366,   427,  1031,
      -1,   101,   423,   385,   421,   724,   366,   427,  1031,    -1,
     101,   423,   385,   151,   724,   366,   427,  1031,    -1,   101,
     436,   724,   366,   427,  1031,    -1,   101,   436,   724,   366,
     114,  1031,   427,  1031,   555,    -1,   145,    -1,    -1,   395,
     173,    -1,    -1,   101,    98,  1037,   699,   395,   383,  1031,
      -1,   101,   144,   724,   395,   383,  1031,    -1,   101,   157,
     724,   395,   383,  1031,    -1,   101,   195,   724,   395,   383,
    1031,    -1,   101,   213,   724,   395,   383,  1031,    -1,   101,
     229,   749,   395,   383,  1031,    -1,   101,   324,   796,   795,
     395,   383,  1031,    -1,   101,   324,   139,   724,   448,  1033,
     395,   383,  1031,    -1,   101,   324,   217,   724,   448,  1033,
     395,   383,  1031,    -1,   101,   417,   935,   395,   383,  1031,
      -1,   101,   423,   385,   336,   724,   395,   383,  1031,    -1,
     101,   423,   385,   189,   724,   395,   383,  1031,    -1,   101,
     423,   385,   421,   724,   395,   383,  1031,    -1,   101,   423,
     385,   151,   724,   395,   383,  1031,    -1,   101,   389,  1029,
     395,   383,  1031,    -1,   101,   460,  1029,   395,   383,  1031,
      -1,   101,   224,   417,   935,   395,   383,  1031,    -1,   101,
     436,   724,   395,   383,  1031,    -1,   101,    98,  1037,   699,
     335,   427,  1040,    -1,   101,   144,   724,   335,   427,  1040,
      -1,   101,   157,   724,   335,   427,  1040,    -1,   101,   174,
    1032,   335,   427,  1040,    -1,   101,   195,   724,   335,   427,
    1040,    -1,   101,   229,   749,   335,   427,  1040,    -1,   101,
     637,   274,  1031,   335,   427,  1040,    -1,   101,   275,   317,
     628,   335,   427,  1040,    -1,   101,   324,   796,   795,   335,
     427,  1040,    -1,   101,   324,   139,   724,   448,  1033,   335,
     427,  1040,    -1,   101,   324,   217,   724,   448,  1033,   335,
     427,  1040,    -1,   101,   383,  1031,   335,   427,  1040,    -1,
     101,   436,   724,   335,   427,  1040,    -1,   101,   419,  1031,
     335,   427,  1040,    -1,   101,   423,   385,   189,   724,   335,
     427,  1040,    -1,   101,   423,   385,   151,   724,   335,   427,
    1040,    -1,   101,   224,   173,   469,  1031,   335,   427,  1040,
      -1,   101,   392,  1031,   335,   427,  1040,    -1,   160,   771,
     381,  1031,   108,   322,   817,   427,  1029,   939,   193,   818,
     813,    -1,   309,    -1,   815,    -1,   500,   814,   501,    -1,
     814,   504,   816,    -1,   816,    -1,   891,    -1,   869,    -1,
     880,    -1,   874,    -1,   820,    -1,   815,    -1,    -1,   388,
      -1,   446,    -1,   185,    -1,   260,    -1,   261,    -1,   100,
      -1,    -1,   197,   381,  1031,   322,  1029,   555,    -1,   197,
     381,   242,   211,  1031,   322,  1029,   555,    -1,   310,  1159,
     821,    -1,   503,  1179,    -1,    -1,   285,  1159,    -1,   443,
    1159,    -1,   443,   493,    -1,    91,   825,    -1,   118,   825,
     828,    -1,   405,   429,   828,    -1,   148,   825,    -1,   203,
     825,    -1,   378,   825,    -1,   382,  1159,    -1,   365,   382,
    1159,    -1,   365,  1159,    -1,   378,   825,   427,   382,  1159,
      -1,   378,   825,   427,  1159,    -1,   347,   429,  1179,    -1,
     148,   348,  1179,    -1,   378,   348,  1179,    -1,   468,    -1,
     429,    -1,    -1,   270,   282,   538,    -1,   356,   323,    -1,
     356,   470,    -1,   182,    -1,   308,   182,    -1,   826,    -1,
     827,   503,   826,    -1,   827,   826,    -1,   827,    -1,    -1,
     160,   582,   460,  1029,   600,   108,   891,   830,    -1,   160,
     327,   368,   582,   460,  1029,   600,   108,   891,   830,    -1,
     466,   137,   325,    -1,   466,   129,   137,   325,    -1,   466,
     287,   137,   325,    -1,    -1,   286,  1036,    -1,   160,   174,
    1032,   512,   833,    -1,   833,   834,    -1,    -1,   419,   835,
    1031,    -1,   419,   835,   180,    -1,   290,   835,  1179,    -1,
     290,   835,   180,    -1,   421,   835,  1031,    -1,   421,   835,
     180,    -1,   201,   835,  1179,    -1,   201,   835,  1039,    -1,
     201,   835,   180,    -1,   277,   835,  1179,    -1,   277,   835,
     180,    -1,   278,   835,  1179,    -1,   278,   835,   180,    -1,
     152,   284,   835,  1041,    -1,   335,   835,  1031,    -1,   335,
     835,   180,    -1,   487,    -1,    -1,   101,   174,  1032,   512,
     838,    -1,   101,   174,  1032,   395,   419,  1031,    -1,   101,
     174,  1032,   544,    -1,   838,   839,    -1,    -1,   152,   284,
     835,  1041,    -1,   197,   174,  1032,    -1,   197,   174,   242,
     211,  1032,    -1,   160,   195,   724,   843,   944,   591,    -1,
     101,   195,   724,   554,    -1,   101,   195,   724,   197,   308,
     313,    -1,   101,   195,   724,   395,   308,   313,    -1,   101,
     195,   724,    95,   598,    -1,   101,   195,   724,   197,   153,
    1031,   555,    -1,   108,    -1,    -1,   101,   423,   385,   189,
     724,   695,    -1,   101,   423,   385,   151,   724,    95,   292,
     222,  1030,   466,   723,    -1,   101,   423,   385,   151,   724,
     101,   292,   222,  1030,   466,   723,    -1,   101,   423,   385,
     151,   724,   101,   292,   368,   724,   466,   724,    -1,   101,
     423,   385,   151,   724,   101,   292,   222,  1030,   368,   724,
     466,   724,    -1,   101,   423,   385,   151,   724,   197,   292,
     222,  1030,    -1,   101,   423,   385,   151,   724,   197,   292,
     242,   211,   222,  1030,    -1,   160,   709,   157,   724,   222,
    1179,   427,  1179,   227,   724,    -1,   141,   854,  1029,   848,
      -1,   141,   854,    -1,   141,   854,  1035,   322,  1029,    -1,
     448,  1035,    -1,    -1,   449,   855,   856,   854,    -1,   449,
     855,   856,   854,  1029,    -1,   449,   855,   856,   854,   852,
      -1,   449,   500,   850,   501,    -1,   449,   500,   850,   501,
    1029,   857,    -1,   851,    -1,   850,   503,   851,    -1,   853,
      -1,   458,    -1,   226,    -1,   228,    -1,   853,   854,    -1,
     853,   854,  1029,   857,    -1,   104,    -1,   103,    -1,   458,
      -1,    -1,   228,    -1,    -1,   226,    -1,    -1,   500,  1030,
     501,    -1,    -1,   212,   859,    -1,   212,   853,   854,   859,
      -1,   212,   458,   859,    -1,   212,   500,   860,   501,   859,
      -1,   891,    -1,   869,    -1,   880,    -1,   874,    -1,   887,
      -1,  1048,    -1,   867,    -1,   861,    -1,   860,   503,   861,
      -1,   862,   863,    -1,  1159,    -1,   853,    -1,   458,    -1,
     539,    -1,   628,    -1,    -1,   347,  1067,   865,   108,   866,
      -1,   347,  1067,   227,  1112,    -1,   500,  1000,   501,    -1,
      -1,   891,    -1,   869,    -1,   880,    -1,   874,    -1,   210,
    1067,   868,  1191,    -1,   160,   582,   417,   617,   108,   210,
    1067,   868,    -1,   500,   997,   501,    -1,    -1,   899,   260,
     266,  1029,   870,   873,    -1,   891,    -1,   500,   871,   501,
     891,    -1,   180,   454,    -1,   872,    -1,   871,   503,   872,
      -1,  1159,  1021,    -1,   373,  1026,  1192,    -1,    -1,   899,
     185,   227,   937,   875,   940,   873,    -1,   448,   928,    -1,
      -1,   291,   902,   936,   877,   879,    -1,   247,   878,   297,
      -1,    -1,    93,   397,    -1,   379,   397,    -1,   379,   209,
      -1,   397,   446,   209,    -1,   397,    -1,   397,   379,   209,
      -1,   209,    -1,    93,   209,    -1,   312,    -1,    -1,   899,
     446,   937,   395,   881,   927,   940,   873,    -1,   882,    -1,
     881,   503,   882,    -1,   883,    -1,   884,    -1,   885,   487,
    1023,    -1,   500,   886,   501,   487,  1025,    -1,  1159,  1021,
      -1,   885,    -1,   886,   503,   885,    -1,   179,   888,   889,
     171,   890,   222,   891,    -1,  1031,    -1,  1172,    -1,    -1,
     889,   306,   384,    -1,   889,   384,    -1,   889,   121,    -1,
     889,   259,    -1,    -1,   466,   239,    -1,   467,   239,    -1,
     893,    -1,   892,    -1,   500,   893,   501,    -1,   500,   892,
     501,    -1,   895,    -1,   894,   906,    -1,   894,   905,   921,
     910,    -1,   894,   905,   909,   922,    -1,   896,   894,    -1,
     896,   894,   906,    -1,   896,   894,   905,   921,   910,    -1,
     896,   894,   905,   909,   922,    -1,   895,    -1,   892,    -1,
     388,   904,  1026,   900,   927,   939,   919,   920,   980,    -1,
     926,    -1,   417,   935,    -1,   894,   440,   903,   894,    -1,
     894,   264,   903,   894,    -1,   894,   206,   903,   894,    -1,
     466,   897,    -1,   466,   360,   897,    -1,   898,    -1,   897,
     503,   898,    -1,  1031,   857,   108,   500,   866,   501,    -1,
     896,    -1,    -1,   266,   901,    -1,  1192,    -1,    -1,   422,
     902,  1029,    -1,   420,   902,  1029,    -1,   287,   422,   902,
    1029,    -1,   287,   420,   902,  1029,    -1,   231,   422,   902,
    1029,    -1,   231,   420,   902,  1029,    -1,   444,   902,  1029,
      -1,   417,  1029,    -1,  1029,    -1,   417,    -1,    -1,    99,
      -1,   192,    -1,    -1,   192,    -1,   192,   322,   500,   997,
     501,    -1,    99,    -1,    -1,   906,    -1,    -1,   328,   125,
     907,    -1,   908,    -1,   907,   503,   908,    -1,   968,   448,
     995,   769,    -1,   968,   768,   769,    -1,   911,   912,    -1,
     912,   911,    -1,   911,    -1,   912,    -1,   909,    -1,    -1,
     284,   913,    -1,   284,   913,   503,   914,    -1,   218,   918,
     915,   917,   323,    -1,   320,   914,    -1,   320,   916,   917,
      -1,   968,    -1,    99,    -1,   968,    -1,  1041,    -1,   500,
     968,   501,    -1,    -1,   970,    -1,   379,    -1,   380,    -1,
     219,    -1,   305,    -1,   235,   125,   997,    -1,    -1,   237,
     968,    -1,    -1,   923,    -1,   222,   356,   323,    -1,   921,
      -1,    -1,   924,    -1,   923,   924,    -1,   222,   446,   925,
     879,    -1,   222,   397,   925,   879,    -1,   318,  1028,    -1,
      -1,   454,  1025,    -1,   926,   503,  1025,    -1,   227,   928,
      -1,    -1,   929,    -1,   928,   503,   929,    -1,   935,    -1,
     935,   931,    -1,   938,    -1,   938,   931,    -1,   938,   108,
     500,   942,   501,    -1,   938,   108,  1159,   500,   942,   501,
      -1,   938,  1159,   500,   942,   501,    -1,   892,    -1,   892,
     931,    -1,   930,    -1,   500,   930,   501,   931,    -1,   500,
     930,   501,    -1,   929,   161,   271,   929,    -1,   929,   932,
     271,   929,   934,    -1,   929,   271,   929,   934,    -1,   929,
     303,   932,   271,   929,    -1,   929,   303,   271,   929,    -1,
     108,  1159,   500,  1030,   501,    -1,   108,  1159,    -1,  1159,
     500,  1030,   501,    -1,  1159,    -1,   228,   933,    -1,   281,
     933,    -1,   376,   933,    -1,   256,    -1,   330,    -1,    -1,
     448,   500,  1030,   501,    -1,   322,   968,    -1,  1029,    -1,
    1029,   493,    -1,   323,  1029,    -1,   323,   500,  1029,   501,
      -1,   935,    -1,   936,   503,   935,    -1,   935,    -1,   935,
    1159,    -1,   935,   108,  1159,    -1,   971,    -1,   463,   968,
      -1,    -1,   463,   968,    -1,   463,   163,   318,   888,    -1,
      -1,   942,    -1,    -1,   943,    -1,   942,   503,   943,    -1,
    1159,   944,   556,    -1,   946,   945,    -1,   396,   946,   945,
      -1,   946,   107,   498,  1039,   499,    -1,   396,   946,   107,
     498,  1039,   499,    -1,   946,   107,    -1,   396,   946,   107,
      -1,   945,   498,   499,    -1,   945,   498,  1190,   499,    -1,
      -1,   948,    -1,   950,    -1,   952,    -1,   956,    -1,   963,
      -1,   964,   966,    -1,   964,   500,  1039,   501,   966,    -1,
     950,    -1,   953,    -1,   957,    -1,   963,    -1,  1160,   949,
      -1,  1160,   725,   949,    -1,   500,   997,   501,    -1,    -1,
     262,    -1,   263,    -1,   401,    -1,   120,    -1,   357,    -1,
     220,   951,    -1,   196,   345,    -1,   178,   949,    -1,   177,
     949,    -1,   316,   949,    -1,   123,    -1,   500,  1039,   501,
      -1,    -1,   954,    -1,   955,    -1,   954,    -1,   955,    -1,
     122,   961,   500,   997,   501,    -1,   122,   961,    -1,   958,
      -1,   959,    -1,   958,    -1,   959,    -1,   960,   500,  1039,
     501,   962,    -1,   960,   962,    -1,   135,   961,    -1,   134,
     961,    -1,   455,    -1,   302,   135,   961,    -1,   302,   134,
     961,    -1,   304,   961,    -1,   457,    -1,    -1,   135,   395,
    1159,    -1,    -1,   426,   500,  1039,   501,   965,    -1,   426,
     965,    -1,   425,   500,  1039,   501,   965,    -1,   425,   965,
      -1,   265,    -1,   486,   483,    -1,   467,   425,   483,    -1,
      -1,   481,    -1,   298,    -1,   175,    -1,   240,    -1,   295,
      -1,   967,    -1,   481,   427,   298,    -1,   175,   427,   240,
      -1,   175,   427,   295,    -1,   175,   427,   967,    -1,   240,
     427,   295,    -1,   240,   427,   967,    -1,   295,   427,   967,
      -1,    -1,   386,    -1,   386,   500,  1039,   501,    -1,   970,
      -1,   968,    88,   944,    -1,   968,   143,   724,    -1,   968,
     113,   425,   483,   968,    -1,   491,   968,    -1,   492,   968,
      -1,   968,   491,   968,    -1,   968,   492,   968,    -1,   968,
     493,   968,    -1,   968,   494,   968,    -1,   968,   495,   968,
      -1,   968,   496,   968,    -1,   968,   488,   968,    -1,   968,
     489,   968,    -1,   968,   487,   968,    -1,   968,   994,   968,
      -1,   994,   968,    -1,   968,   994,    -1,   968,   105,   968,
      -1,   968,   327,   968,    -1,   308,   968,    -1,   968,   283,
     968,    -1,   968,   283,   968,   205,   968,    -1,   968,   308,
     283,   968,    -1,   968,   308,   283,   968,   205,   968,    -1,
     968,   243,   968,    -1,   968,   243,   968,   205,   968,    -1,
     968,   308,   243,   968,    -1,   968,   308,   243,   968,   205,
     968,    -1,   968,   399,   427,   968,    -1,   968,   399,   427,
     968,   205,   968,    -1,   968,   308,   399,   427,   968,    -1,
     968,   308,   399,   427,   968,   205,   968,    -1,   968,   268,
     313,    -1,   968,   269,    -1,   968,   268,   308,   313,    -1,
     968,   311,    -1,   990,   332,   990,    -1,   968,   268,   433,
      -1,   968,   268,   308,   433,    -1,   968,   268,   216,    -1,
     968,   268,   308,   216,    -1,   968,   268,   442,    -1,   968,
     268,   308,   442,    -1,   968,   268,   192,   227,   968,    -1,
     968,   268,   308,   192,   227,   968,    -1,   968,   268,   318,
     500,  1000,   501,    -1,   968,   268,   308,   318,   500,  1000,
     501,    -1,   968,   119,  1022,   969,   105,   969,    -1,   968,
     308,   119,  1022,   969,   105,   969,    -1,   968,   119,   414,
     969,   105,   969,    -1,   968,   308,   119,   414,   969,   105,
     969,    -1,   968,   247,  1012,    -1,   968,   308,   247,  1012,
      -1,   968,   996,   991,   892,    -1,   968,   996,   991,   500,
     968,   501,    -1,   441,   892,    -1,   968,   268,   194,    -1,
     968,   268,   308,   194,    -1,   970,    -1,   969,    88,   944,
      -1,   491,   969,    -1,   492,   969,    -1,   969,   491,   969,
      -1,   969,   492,   969,    -1,   969,   493,   969,    -1,   969,
     494,   969,    -1,   969,   495,   969,    -1,   969,   496,   969,
      -1,   969,   488,   969,    -1,   969,   489,   969,    -1,   969,
     487,   969,    -1,   969,   994,   969,    -1,   994,   969,    -1,
     969,   994,    -1,   969,   268,   192,   227,   969,    -1,   969,
     268,   308,   192,   227,   969,    -1,   969,   268,   318,   500,
    1000,   501,    -1,   969,   268,   308,   318,   500,  1000,   501,
      -1,   969,   268,   194,    -1,   969,   268,   308,   194,    -1,
    1018,    -1,  1038,    -1,  1176,  1021,    -1,   500,   968,   501,
    1021,    -1,  1013,    -1,   971,    -1,   892,    -1,   211,   892,
      -1,   107,   892,    -1,   107,  1001,    -1,   990,    -1,  1037,
     500,   501,   983,    -1,  1037,   500,   998,   501,   983,    -1,
    1037,   500,   456,   999,   501,   983,    -1,  1037,   500,   998,
     503,   456,   999,   501,   983,    -1,  1037,   500,   998,   906,
     501,   983,    -1,  1037,   500,    99,   998,   905,   501,   983,
      -1,  1037,   500,   192,   998,   905,   501,   983,    -1,  1037,
     500,   493,   501,   983,    -1,   165,    -1,   168,    -1,   168,
     500,  1039,   501,    -1,   169,    -1,   169,   500,  1039,   501,
      -1,   288,    -1,   288,   500,  1039,   501,    -1,   289,    -1,
     289,   500,  1039,   501,    -1,   166,    -1,   170,    -1,   394,
      -1,   447,    -1,   164,    -1,   167,    -1,   131,   500,   968,
     108,   944,   501,    -1,   215,   500,  1003,   501,    -1,   333,
     500,  1005,   501,    -1,   343,   500,  1007,   501,    -1,   413,
     500,  1008,   501,    -1,   430,   500,   968,   108,   944,   501,
      -1,   432,   500,   124,  1011,   501,    -1,   432,   500,   279,
    1011,   501,    -1,   432,   500,   428,  1011,   501,    -1,   432,
     500,  1011,   501,    -1,   314,   500,   968,   503,   968,   501,
      -1,   142,   500,   997,   501,    -1,   234,   500,   997,   501,
      -1,   280,   500,   997,   501,    -1,   473,   500,   997,   501,
      -1,   474,   500,   300,  1161,   501,    -1,   474,   500,   300,
    1161,   503,   974,   501,    -1,   474,   500,   300,  1161,   503,
     997,   501,    -1,   474,   500,   300,  1161,   503,   974,   503,
     997,   501,    -1,   475,   500,   970,   979,   501,    -1,   476,
     500,   975,   501,    -1,   477,   500,   977,   968,   978,   501,
      -1,   478,   500,   300,  1161,   501,    -1,   478,   500,   300,
    1161,   503,   968,   501,    -1,   479,   500,   968,   503,   972,
     973,   501,    -1,   480,   500,   977,   968,   108,   946,   501,
      -1,   459,   968,    -1,   459,   306,   453,    -1,   503,   404,
     482,    -1,   503,   404,   306,    -1,   503,   404,   306,   453,
      -1,    -1,   472,   500,   975,   501,    -1,   976,    -1,   975,
     503,   976,    -1,   968,   108,  1161,    -1,   968,    -1,   194,
      -1,   155,    -1,   346,   464,    -1,   412,   464,    -1,    -1,
     339,   970,    -1,   339,   970,   125,   361,    -1,   339,   125,
     361,   970,    -1,   339,   125,   361,   970,   125,   361,    -1,
     465,   981,    -1,    -1,   982,    -1,   981,   503,   982,    -1,
    1159,   108,   984,    -1,   331,   984,    -1,   331,  1159,    -1,
      -1,   500,   985,   986,   905,   987,   501,    -1,  1159,    -1,
      -1,   338,   125,   997,    -1,    -1,   355,   988,    -1,   380,
     988,    -1,    -1,   989,    -1,   119,   989,   105,   989,    -1,
     437,   344,    -1,   437,   221,    -1,   163,   379,    -1,   968,
     344,    -1,   968,   221,    -1,   379,   500,   997,   501,    -1,
     379,   500,   501,    -1,   500,   997,   503,   968,   501,    -1,
     106,    -1,   402,    -1,    99,    -1,    85,    -1,   993,    -1,
     491,    -1,   492,    -1,   493,    -1,   494,    -1,   495,    -1,
     496,    -1,   488,    -1,   489,    -1,   487,    -1,    85,    -1,
     324,   500,   796,   501,    -1,   992,    -1,   324,   500,   796,
     501,    -1,   992,    -1,   324,   500,   796,   501,    -1,   283,
      -1,   308,   283,    -1,   243,    -1,   308,   243,    -1,   968,
      -1,   997,   503,   968,    -1,   999,    -1,   998,   503,   999,
      -1,   968,    -1,   778,    90,   968,    -1,   944,    -1,  1000,
     503,   944,    -1,   498,   997,   499,    -1,   498,  1002,   499,
      -1,   498,   499,    -1,  1001,    -1,  1002,   503,  1001,    -1,
    1004,   227,   968,    -1,    -1,  1181,    -1,   481,    -1,   298,
      -1,   175,    -1,   240,    -1,   295,    -1,   386,    -1,  1179,
      -1,   968,  1006,  1009,  1010,    -1,   968,  1006,  1009,    -1,
     341,   968,    -1,   969,   247,   969,    -1,    -1,   968,  1009,
    1010,    -1,   968,  1010,  1009,    -1,   968,  1009,    -1,   968,
    1010,    -1,   997,    -1,    -1,   227,   968,    -1,   222,   968,
      -1,   968,   227,   997,    -1,   227,   997,    -1,   997,    -1,
     892,    -1,   500,   997,   501,    -1,   130,  1017,  1014,  1016,
     203,    -1,  1015,    -1,  1014,  1015,    -1,   462,   968,   424,
     968,    -1,   199,   968,    -1,    -1,   968,    -1,    -1,  1159,
      -1,  1159,  1020,    -1,   502,  1034,    -1,   502,   493,    -1,
     498,   968,   499,    -1,   498,   968,   505,   968,   499,    -1,
    1019,    -1,  1020,  1019,    -1,    -1,  1021,  1019,    -1,   112,
      -1,    -1,   968,    -1,   180,    -1,  1023,    -1,  1024,   503,
    1023,    -1,   500,  1024,   501,    -1,  1027,    -1,  1026,   503,
    1027,    -1,   968,   108,  1161,    -1,   968,  1181,    -1,   968,
      -1,   493,    -1,  1029,    -1,  1028,   503,  1029,    -1,  1159,
      -1,  1159,  1020,    -1,  1031,    -1,  1030,   503,  1031,    -1,
    1159,    -1,  1159,    -1,  1159,    -1,  1161,    -1,  1159,    -1,
    1179,    -1,  1160,    -1,  1159,  1020,    -1,  1039,    -1,  1178,
      -1,  1179,    -1,  1177,    -1,    84,    -1,  1037,  1179,    -1,
    1037,   500,   998,   501,  1179,    -1,   947,  1179,    -1,   964,
    1179,   966,    -1,   964,   500,  1039,   501,  1179,   966,    -1,
     433,    -1,   216,    -1,   313,    -1,  1173,    -1,  1171,    -1,
      86,    -1,  1159,    -1,  1039,    -1,  1173,    -1,   491,  1039,
      -1,   492,  1039,    -1,    91,    -1,    92,    -1,    93,    -1,
      94,    -1,    95,    -1,    96,    -1,    97,    -1,    98,    -1,
     100,    -1,   101,    -1,   102,    -1,   110,    -1,   111,    -1,
     113,    -1,   114,    -1,   116,    -1,   117,    -1,   118,    -1,
     125,    -1,   126,    -1,   127,    -1,   128,    -1,   129,    -1,
     132,    -1,   133,    -1,   136,    -1,   138,    -1,   139,    -1,
     140,    -1,   141,    -1,   144,    -1,   146,    -1,   147,    -1,
     148,    -1,   149,    -1,   151,    -1,   154,    -1,   155,    -1,
     156,    -1,   157,    -1,   158,    -1,   159,    -1,   162,    -1,
     171,    -1,   172,    -1,   173,    -1,   174,    -1,   176,    -1,
     179,    -1,   181,    -1,   183,    -1,   184,    -1,   185,    -1,
     186,    -1,   187,    -1,   189,    -1,   190,    -1,   191,    -1,
     194,    -1,   195,    -1,   196,    -1,   197,    -1,   198,    -1,
     200,    -1,   201,    -1,   202,    -1,   204,    -1,   205,    -1,
     207,    -1,   208,    -1,   209,    -1,   210,    -1,   212,    -1,
     213,    -1,   214,    -1,   217,    -1,   219,    -1,   221,    -1,
     223,    -1,   225,    -1,   229,    -1,   230,    -1,   231,    -1,
     233,    -1,   236,    -1,   238,    -1,   239,    -1,   241,    -1,
     242,    -1,   244,    -1,   245,    -1,   246,    -1,   248,    -1,
     249,    -1,   250,    -1,   251,    -1,   252,    -1,   253,    -1,
     255,    -1,   259,    -1,   260,    -1,   261,    -1,   267,    -1,
     270,    -1,   272,    -1,   273,    -1,   274,    -1,   275,    -1,
     276,    -1,   277,    -1,   278,    -1,   282,    -1,   285,    -1,
     286,    -1,   287,    -1,   290,    -1,   291,    -1,   292,    -1,
     293,    -1,   294,    -1,   296,    -1,   297,    -1,   299,    -1,
     300,    -1,   301,    -1,   305,    -1,   306,    -1,   309,    -1,
     310,    -1,   312,    -1,   315,    -1,   317,    -1,   318,    -1,
     319,    -1,   321,    -1,   324,    -1,   325,    -1,   326,    -1,
     334,    -1,   335,    -1,   336,    -1,   337,    -1,   338,    -1,
     339,    -1,   340,    -1,   342,    -1,   344,    -1,   347,    -1,
     348,    -1,   346,    -1,   350,    -1,   351,    -1,   352,    -1,
     353,    -1,   354,    -1,   355,    -1,   356,    -1,   358,    -1,
     359,    -1,   360,    -1,   361,    -1,   363,    -1,   364,    -1,
     365,    -1,   366,    -1,   367,    -1,   368,    -1,   369,    -1,
     370,    -1,   371,    -1,   372,    -1,   374,    -1,   375,    -1,
     377,    -1,   378,    -1,   380,    -1,   381,    -1,   382,    -1,
     383,    -1,   384,    -1,   385,    -1,   387,    -1,   389,    -1,
     390,    -1,   391,    -1,   392,    -1,   393,    -1,   395,    -1,
     397,    -1,   398,    -1,   400,    -1,   403,    -1,   404,    -1,
     405,    -1,   406,    -1,   407,    -1,   408,    -1,   409,    -1,
     410,    -1,   411,    -1,   412,    -1,   415,    -1,   416,    -1,
     418,    -1,   419,    -1,   420,    -1,   421,    -1,   422,    -1,
     423,    -1,   429,    -1,   431,    -1,   434,    -1,   435,    -1,
     436,    -1,   437,    -1,   438,    -1,   439,    -1,   442,    -1,
     443,    -1,   444,    -1,   445,    -1,   446,    -1,   449,    -1,
     450,    -1,   451,    -1,   452,    -1,   453,    -1,   457,    -1,
     459,    -1,   460,    -1,   461,    -1,   464,    -1,   467,    -1,
     468,    -1,   469,    -1,   470,    -1,   471,    -1,   482,    -1,
     483,    -1,   119,    -1,   120,    -1,   122,    -1,   123,    -1,
     135,    -1,   142,    -1,   177,    -1,   178,    -1,   211,    -1,
     215,    -1,   220,    -1,   234,    -1,   257,    -1,   263,    -1,
     265,    -1,   280,    -1,   302,    -1,   304,    -1,   307,    -1,
     314,    -1,   316,    -1,   329,    -1,   333,    -1,   343,    -1,
     345,    -1,   357,    -1,   379,    -1,   396,    -1,   401,    -1,
     413,    -1,   425,    -1,   426,    -1,   430,    -1,   432,    -1,
     455,    -1,   472,    -1,   473,    -1,   474,    -1,   475,    -1,
     476,    -1,   477,    -1,   478,    -1,   479,    -1,   480,    -1,
     115,    -1,   121,    -1,   150,    -1,   161,    -1,   167,    -1,
     226,    -1,   228,    -1,   243,    -1,   256,    -1,   268,    -1,
     269,    -1,   271,    -1,   281,    -1,   283,    -1,   303,    -1,
     311,    -1,   330,    -1,   331,    -1,   332,    -1,   376,    -1,
     399,    -1,   458,    -1,    99,    -1,   103,    -1,   104,    -1,
     105,    -1,   106,    -1,   107,    -1,   108,    -1,   109,    -1,
     112,    -1,   124,    -1,   130,    -1,   131,    -1,   137,    -1,
     143,    -1,   145,    -1,   153,    -1,   160,    -1,   164,    -1,
     165,    -1,   166,    -1,   168,    -1,   169,    -1,   170,    -1,
     180,    -1,   182,    -1,   188,    -1,   192,    -1,   193,    -1,
     199,    -1,   203,    -1,   206,    -1,   216,    -1,   218,    -1,
     222,    -1,   224,    -1,   227,    -1,   232,    -1,   235,    -1,
     237,    -1,   247,    -1,   254,    -1,   264,    -1,   266,    -1,
     279,    -1,   284,    -1,   288,    -1,   289,    -1,   308,    -1,
     313,    -1,   320,    -1,   322,    -1,   323,    -1,   327,    -1,
     328,    -1,   341,    -1,   349,    -1,   362,    -1,   373,    -1,
     388,    -1,   394,    -1,   402,    -1,   414,    -1,   417,    -1,
     424,    -1,   428,    -1,   433,    -1,   441,    -1,   447,    -1,
     448,    -1,   456,    -1,   462,    -1,   463,    -1,   465,    -1,
     466,    -1,    -1,  1046,  1047,    -1,  1168,  1050,   510,   504,
      -1,  1168,   510,   504,    -1,  1168,  1070,    -1,  1075,    -1,
    1187,    -1,    73,    -1,   506,    -1,   507,    -1,    -1,   160,
     582,   417,   617,   108,  1049,   891,   621,    -1,   113,  1111,
      -1,     9,   427,  1052,  1059,  1060,    -1,     9,   427,   180,
      -1,     9,  1061,    -1,   174,  1052,    -1,  1053,  1056,  1058,
      -1,  1054,   505,  1055,  1058,   494,  1053,  1064,    -1,  1063,
      -1,  1179,    -1,  1032,    -1,    -1,  1181,  1175,    -1,    85,
    1057,    -1,  1055,    -1,    -1,  1159,    -1,  1159,   502,  1057,
      -1,    74,    -1,   505,  1039,    -1,    -1,   108,  1111,    -1,
      -1,   447,  1061,    -1,    -1,  1062,    -1,  1062,   494,  1062,
      -1,  1062,    21,   125,  1062,    -1,  1062,   448,  1062,    -1,
    1040,    -1,  1179,    -1,  1173,    -1,  1175,    -1,    85,  1065,
      -1,    -1,  1159,  1066,    -1,  1159,  1066,    85,  1065,    -1,
      -1,   487,  1039,    -1,   487,  1181,    -1,   487,  1173,    -1,
    1031,    -1,  1063,    -1,   179,   888,   889,   171,   890,   222,
    1067,    -1,   210,   244,  1112,    -1,  1071,    -1,  1082,    -1,
    1084,    -1,   628,    -1,   503,   628,    -1,    -1,   966,    -1,
     481,   427,   295,    -1,   481,   427,   386,    -1,   175,   427,
     175,    -1,   298,   427,   298,    -1,    -1,  1077,  1076,  1079,
    1078,    -1,  1168,   118,   179,    34,   504,    -1,  1168,   203,
     179,    34,   504,    -1,    -1,  1080,    -1,  1071,    -1,    73,
      -1,  1080,  1071,    -1,  1080,    73,    -1,  1084,    -1,  1081,
    1084,    -1,    -1,    70,  1083,  1091,  1107,  1163,   945,   504,
      -1,    -1,  1088,  1091,  1085,  1104,   504,    -1,    -1,  1091,
    1086,  1104,   504,    -1,  1094,   504,    -1,   505,  1039,    -1,
      -1,  1089,  1090,    -1,  1089,    -1,  1090,    -1,    56,    -1,
      67,    -1,    65,    -1,    50,    -1,    51,    -1,    69,    -1,
    1100,    -1,  1096,    -1,  1092,    -1,  1163,   500,  1072,  1073,
     501,    -1,  1163,  1074,    -1,  1098,    -1,   204,  1157,  1093,
      -1,   204,  1093,    -1,   204,  1157,    -1,   506,  1185,   507,
      -1,    -1,  1098,  1095,   506,  1081,   507,    -1,  1094,    -1,
      -1,  1099,  1097,   506,  1081,   507,    -1,    43,  1157,    -1,
     440,  1157,    -1,    43,    -1,   440,    -1,  1101,    -1,  1103,
    1102,    -1,    44,    35,    -1,    44,    35,   262,    -1,    44,
      -1,    44,   262,    -1,    44,    25,    -1,    44,    25,   262,
      -1,    44,    25,    25,    -1,    44,    25,    25,   262,    -1,
      44,   134,    -1,    35,    -1,    35,   262,    -1,   262,    -1,
      25,    -1,    25,   262,    -1,    25,    25,    -1,    25,    25,
     262,    -1,     5,    -1,   134,    -1,   196,    -1,    36,    -1,
      -1,  1105,    -1,  1104,   503,  1105,    -1,  1107,  1162,   945,
    1087,  1106,    -1,    -1,   487,  1186,    -1,    -1,   493,    -1,
     493,   493,    -1,   179,   406,  1181,    -1,    15,  1110,    -1,
    1111,    -1,   163,    -1,    99,    -1,    -1,  1032,    -1,   180,
      -1,  1063,    -1,  1063,    -1,    71,    -1,    17,   888,    -1,
      17,    99,    -1,    28,   888,  1115,    -1,    -1,  1116,    -1,
     448,  1120,    -1,  1117,    -1,   448,    37,    14,  1182,    -1,
     448,    14,  1031,    -1,   266,    37,    14,  1182,    -1,   266,
      14,  1031,    -1,   266,  1031,    -1,  1121,    -1,  1121,   503,
    1120,    -1,  1122,    -1,  1173,    -1,  1171,    -1,  1039,    -1,
     491,  1039,    -1,   492,  1039,    -1,  1178,    -1,   491,  1178,
      -1,   492,  1178,    -1,  1179,    -1,  1177,    -1,  1180,    -1,
      13,   258,  1067,  1117,    -1,    13,  1124,  1067,  1117,    -1,
      13,  1124,  1067,  1118,    -1,    13,   258,  1067,  1119,    -1,
      13,  1124,  1067,  1119,    -1,    29,    -1,    -1,     3,    14,
    1182,    -1,   176,    14,  1182,    -1,    18,    14,  1182,  1128,
      -1,  1129,    -1,  1128,   503,  1129,    -1,  1175,   487,  1134,
      -1,   395,    14,  1182,  1131,    -1,  1132,    -1,  1131,   503,
    1132,    -1,  1134,   487,  1133,    -1,  1039,    -1,  1175,    -1,
      10,    -1,    18,    14,  1182,   453,  1133,  1136,    -1,  1137,
      -1,  1136,   503,  1137,    -1,  1175,   487,  1142,    -1,   395,
      14,  1182,   453,  1133,  1139,    -1,  1140,    -1,  1139,   503,
    1140,    -1,  1142,   487,  1141,    -1,  1178,    -1,  1133,    -1,
     492,  1178,    -1,   492,  1039,    -1,  1179,    -1,     8,    -1,
     173,    -1,    11,    -1,    12,    -1,    22,    -1,    23,    -1,
      24,    -1,   300,    -1,    26,    -1,    27,    -1,   345,    -1,
      31,    -1,    32,    -1,    33,    -1,   436,    -1,   395,     4,
     487,  1144,    -1,   395,     4,   427,  1144,    -1,   322,    -1,
     319,    -1,   395,   152,   427,  1111,    -1,   395,   152,   487,
    1111,    -1,   395,   152,  1111,    -1,    -1,   436,  1147,  1163,
     268,  1091,   945,  1148,    -1,    30,    -1,    -1,    -1,    45,
    1150,  1161,   268,  1091,   945,  1148,    -1,    46,    38,  1152,
      -1,    46,   308,    16,  1152,    -1,    46,    40,  1152,    -1,
     156,    -1,    39,    -1,    42,    -1,    20,  1031,    -1,    19,
     427,  1031,    -1,   193,  1031,   500,  1169,   501,    -1,   193,
       6,    -1,     7,  1031,   500,  1169,   501,    -1,     7,  1031,
      -1,  1154,    -1,  1155,    -1,     6,    -1,     7,    -1,     8,
      -1,    10,    -1,    11,    -1,    12,    -1,    16,    -1,    19,
      -1,    20,    -1,    21,    -1,    22,    -1,    23,    -1,    24,
      -1,    26,    -1,    27,    -1,    31,    -1,    32,    -1,    33,
      -1,    34,    -1,    37,    -1,    38,    -1,    39,    -1,    40,
      -1,    42,    -1,     9,    -1,    13,    -1,    15,    -1,    28,
      -1,    45,    -1,    46,    -1,     5,    -1,    25,    -1,    29,
      -1,    35,    -1,    43,    -1,    36,    -1,    44,    -1,  1161,
      -1,  1181,    -1,  1042,    -1,  1043,    -1,  1166,    -1,  1153,
      -1,  1164,    -1,   134,    -1,   454,    -1,  1181,    -1,  1165,
      -1,  1043,    -1,  1153,    -1,  1164,    -1,   134,    -1,   454,
      -1,  1181,    -1,  1165,    -1,  1044,    -1,  1153,    -1,  1164,
      -1,  1156,    -1,  1162,    -1,  1156,    -1,   134,    -1,   163,
      -1,   258,    -1,   262,    -1,   427,    -1,   440,    -1,   454,
      -1,  1164,    -1,  1166,    -1,  1163,    -1,  1042,    -1,  1045,
      -1,  1155,    -1,   152,    -1,  1181,    -1,  1043,    -1,  1044,
      -1,  1154,    -1,    50,    -1,    51,    -1,    56,    -1,    65,
      -1,    67,    -1,    70,    -1,    69,    -1,  1042,    -1,  1166,
      -1,   152,    -1,   175,    -1,   240,    -1,   295,    -1,   298,
      -1,   386,    -1,   481,    -1,  1170,    -1,  1167,   503,  1170,
      -1,    41,    -1,    -1,  1185,    -1,  1175,  1174,    -1,  1175,
      -1,  1175,  1174,    -1,  1063,    -1,  1175,    -1,  1175,    -1,
      22,  1175,    -1,    22,  1031,    -1,    72,    -1,    87,    -1,
      83,    -1,    81,    -1,    82,    -1,    76,    -1,    77,    -1,
      78,    -1,    75,    -1,    84,    -1,    80,    -1,    71,    -1,
      79,    -1,  1031,    -1,  1063,    -1,  1188,    -1,   500,   501,
      -1,   500,  1184,   501,    -1,  1183,    -1,  1184,  1183,    -1,
    1186,    -1,  1185,   503,  1186,    -1,  1184,    -1,   506,  1185,
     507,    -1,  1188,    -1,   500,    -1,   501,    -1,   503,    -1,
     504,    -1,  1181,    -1,  1039,    -1,  1178,    -1,  1179,    -1,
     493,    -1,   491,    -1,   492,    -1,   494,    -1,   495,    -1,
     313,    -1,    47,    -1,    48,    -1,    49,    -1,    50,    -1,
      51,    -1,    52,    -1,    53,    -1,    54,    -1,    55,    -1,
      56,    -1,    57,    -1,    58,    -1,    60,    -1,    59,    -1,
      61,    -1,    62,    -1,    63,    -1,    64,    -1,    65,    -1,
      66,    -1,    67,    -1,    68,    -1,    70,    -1,    69,    -1,
       5,    -1,   204,    -1,   240,    -1,   262,    -1,    25,    -1,
     295,    -1,   298,    -1,   386,    -1,    35,    -1,    36,    -1,
      43,    -1,    44,    -1,   481,    -1,   134,    -1,   220,    -1,
     427,    -1,   440,    -1,   455,    -1,   498,    -1,   499,    -1,
     487,    -1,   505,    -1,   176,  1067,    -1,   176,   347,  1067,
      -1,   176,    99,    -1,   176,   347,    99,    -1,  1039,    -1,
     500,  1190,   501,    -1,  1190,   491,  1190,    -1,  1190,   492,
    1190,    -1,  1190,   493,  1190,    -1,  1190,   494,  1190,    -1,
    1190,   495,  1190,    -1,  1179,    -1,  1159,    -1,    -1,  1116,
    1192,    -1,  1192,  1116,    -1,  1116,    -1,  1192,    -1,   266,
    1167,    -1,  1118,    -1,  1192,    -1,  1117,    -1,    -1,  1193,
      -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,  1364,  1364,  1367,  1369,  1371,  1373,  1375,  1377,  1379,
    1381,  1383,  1385,  1387,  1389,  1391,  1393,  1395,  1397,  1399,
    1401,  1403,  1405,  1407,  1409,  1411,  1413,  1415,  1417,  1419,
    1437,  1439,  1441,  1443,  1445,  1447,  1449,  1451,  1453,  1455,
    1457,  1459,  1461,  1463,  1465,  1467,  1469,  1471,  1473,  1475,
    1477,  1479,  1481,  1483,  1485,  1487,  1489,  1491,  1493,  1500,
    1502,  1504,  1506,  1508,  1510,  1512,  1514,  1516,  1518,  1520,
    1522,  1524,  1526,  1528,  1530,  1532,  1534,  1536,  1538,  1540,
    1542,  1544,  1546,  1548,  1550,  1552,  1554,  1556,  1558,  1560,
    1562,  1564,  1566,  1573,  1575,  1577,  1579,  1581,  1583,  1585,
    1587,  1589,  1591,  1593,  1595,  1601,  1603,  1605,  1607,  1609,
    1611,  1613,  1615,  1617,  1623,  1633,  1637,  1645,  1649,  1659,
    1669,  1670,  1684,  1691,  1697,  1708,  1714,  1723,  1730,  1736,
    1745,  1752,  1760,  1765,  1773,  1778,  1784,  1789,  1795,  1800,
    1806,  1810,  1814,  1818,  1822,  1826,  1830,  1834,  1838,  1846,
    1850,  1854,  1858,  1862,  1866,  1874,  1882,  1891,  1893,  1901,
    1909,  1917,  1925,  1929,  1937,  1941,  1949,  1957,  1965,  1969,
    1977,  1981,  1989,  1993,  2001,  2006,  2012,  2017,  2023,  2027,
    2031,  2035,  2039,  2043,  2051,  2055,  2059,  2067,  2071,  2075,
    2079,  2083,  2087,  2091,  2095,  2099,  2104,  2108,  2112,  2116,
    2120,  2124,  2132,  2136,  2144,  2148,  2156,  2160,  2174,  2178,
    2182,  2186,  2194,  2198,  2202,  2206,  2214,  2218,  2222,  2226,
    2230,  2234,  2238,  2246,  2250,  2255,  2261,  2265,  2273,  2277,
    2281,  2285,  2289,  2297,  2301,  2309,  2313,  2317,  2321,  2325,
    2334,  2342,  2346,  2354,  2358,  2366,  2374,  2378,  2382,  2386,
    2394,  2398,  2402,  2406,  2414,  2418,  2426,  2430,  2434,  2438,
    2442,  2446,  2450,  2454,  2458,  2462,  2466,  2470,  2474,  2478,
    2482,  2486,  2490,  2494,  2498,  2502,  2506,  2510,  2514,  2518,
    2522,  2526,  2530,  2534,  2538,  2542,  2546,  2550,  2554,  2558,
    2562,  2566,  2570,  2574,  2578,  2582,  2586,  2594,  2598,  2606,
    2610,  2615,  2621,  2626,  2632,  2637,  2643,  2651,  2656,  2662,
    2666,  2674,  2678,  2682,  2686,  2694,  2702,  2706,  2714,  2718,
    2722,  2726,  2734,  2739,  2747,  2758,  2769,  2773,  2781,  2785,
    2789,  2797,  2801,  2809,  2814,  2820,  2824,  2828,  2832,  2836,
    2840,  2844,  2848,  2852,  2856,  2860,  2864,  2872,  2877,  2883,
    2888,  2894,  2899,  2905,  2910,  2916,  2920,  2928,  2936,  2940,
    2944,  2948,  2953,  2959,  2963,  2971,  2979,  2983,  2987,  2991,
    2999,  3003,  3007,  3011,  3015,  3019,  3023,  3028,  3034,  3039,
    3045,  3050,  3056,  3060,  3068,  3072,  3080,  3084,  3088,  3096,
    3100,  3108,  3116,  3124,  3129,  3135,  3139,  3143,  3147,  3155,
    3159,  3163,  3167,  3171,  3175,  3179,  3187,  3191,  3195,  3199,
    3207,  3215,  3219,  3224,  3230,  3234,  3238,  3242,  3246,  3250,
    3258,  3262,  3270,  3275,  3279,  3283,  3287,  3291,  3295,  3299,
    3307,  3312,  3318,  3322,  3330,  3338,  3342,  3347,  3352,  3358,
    3362,  3370,  3374,  3382,  3387,  3393,  3397,  3401,  3405,  3410,
    3416,  3424,  3432,  3436,  3440,  3444,  3448,  3456,  3461,  3467,
    3471,  3475,  3480,  3486,  3490,  3494,  3499,  3505,  3510,  3516,
    3521,  3527,  3535,  3543,  3548,  3554,  3558,  3566,  3574,  3578,
    3583,  3589,  3597,  3605,  3610,  3616,  3620,  3628,  3632,  3636,
    3640,  3644,  3648,  3652,  3656,  3660,  3664,  3668,  3672,  3680,
    3685,  3691,  3695,  3699,  3707,  3711,  3719,  3723,  3731,  3736,
    3742,  3746,  3754,  3759,  3765,  3769,  3777,  3782,  3788,  3792,
    3800,  3805,  3811,  3819,  3824,  3830,  3834,  3842,  3846,  3854,
    3859,  3865,  3869,  3873,  3881,  3889,  3894,  3900,  3908,  3912,
    3916,  3920,  3924,  3928,  3932,  3936,  3940,  3944,  3948,  3952,
    3956,  3960,  3964,  3968,  3972,  3976,  3980,  3984,  3988,  3992,
    4000,  4008,  4012,  4016,  4020,  4028,  4032,  4040,  4045,  4051,
    4055,  4063,  4067,  4075,  4080,  4086,  4090,  4098,  4106,  4110,
    4118,  4122,  4126,  4130,  4138,  4146,  4154,  4162,  4170,  4175,
    4181,  4185,  4193,  4198,  4204,  4208,  4216,  4220,  4224,  4232,
    4236,  4244,  4248,  4256,  4260,  4268,  4276,  4284,  4292,  4296,
    4300,  4308,  4312,  4320,  4328,  4332,  4340,  4344,  4348,  4356,
    4360,  4368,  4372,  4376,  4380,  4384,  4392,  4397,  4403,  4408,
    4414,  4418,  4426,  4431,  4437,  4441,  4446,  4452,  4456,  4460,
    4464,  4472,  4477,  4483,  4487,  4494,  4498,  4506,  4512,  4516,
    4524,  4528,  4536,  4540,  4548,  4557,  4566,  4570,  4574,  4578,
    4582,  4586,  4590,  4594,  4598,  4602,  4606,  4610,  4614,  4622,
    4630,  4634,  4642,  4646,  4654,  4658,  4662,  4666,  4670,  4678,
    4682,  4690,  4698,  4702,  4710,  4718,  4723,  4729,  4733,  4741,
    4745,  4749,  4757,  4765,  4769,  4777,  4781,  4785,  4789,  4793,
    4801,  4806,  4812,  4817,  4823,  4827,  4832,  4838,  4844,  4850,
    4858,  4862,  4870,  4874,  4882,  4886,  4894,  4898,  4906,  4910,
    4918,  4926,  4934,  4938,  4946,  4950,  4954,  4958,  4962,  4966,
    4970,  4974,  4978,  4982,  4986,  4990,  4994,  4998,  5002,  5010,
    5014,  5022,  5026,  5034,  5038,  5046,  5054,  5058,  5063,  5069,
    5073,  5077,  5081,  5085,  5089,  5093,  5097,  5101,  5105,  5109,
    5113,  5117,  5121,  5125,  5129,  5133,  5141,  5145,  5149,  5153,
    5157,  5161,  5165,  5169,  5173,  5177,  5181,  5185,  5189,  5193,
    5197,  5201,  5205,  5213,  5217,  5225,  5229,  5233,  5237,  5241,
    5249,  5254,  5260,  5264,  5268,  5272,  5276,  5280,  5284,  5288,
    5296,  5300,  5308,  5312,  5316,  5320,  5326,  5332,  5338,  5344,
    5350,  5356,  5362,  5372,  5383,  5394,  5405,  5416,  5427,  5438,
    5454,  5470,  5486,  5497,  5513,  5524,  5540,  5555,  5559,  5567,
    5572,  5578,  5586,  5590,  5598,  5602,  5606,  5610,  5614,  5622,
    5626,  5634,  5638,  5642,  5646,  5654,  5658,  5662,  5666,  5670,
    5674,  5678,  5682,  5686,  5690,  5694,  5698,  5702,  5706,  5714,
    5718,  5726,  5730,  5738,  5743,  5749,  5753,  5761,  5769,  5777,
    5781,  5789,  5794,  5800,  5805,  5811,  5819,  5824,  5830,  5834,
    5838,  5846,  5850,  5854,  5862,  5866,  5870,  5878,  5886,  5891,
    5897,  5902,  5908,  5913,  5919,  5924,  5930,  5934,  5942,  5946,
    5950,  5958,  5963,  5969,  5973,  5978,  5984,  5988,  5993,  5999,
    6003,  6008,  6014,  6018,  6022,  6030,  6035,  6041,  6045,  6053,
    6057,  6065,  6069,  6077,  6081,  6089,  6093,  6097,  6101,  6105,
    6113,  6117,  6121,  6125,  6129,  6137,  6145,  6153,  6157,  6161,
    6169,  6173,  6177,  6185,  6189,  6197,  6201,  6205,  6209,  6213,
    6217,  6221,  6225,  6229,  6233,  6237,  6241,  6245,  6253,  6257,
    6261,  6265,  6273,  6277,  6285,  6290,  6296,  6304,  6308,  6316,
    6324,  6328,  6336,  6341,  6347,  6351,  6359,  6363,  6371,  6375,
    6383,  6387,  6391,  6395,  6403,  6407,  6415,  6423,  6427,  6435,
    6439,  6447,  6451,  6455,  6463,  6467,  6472,  6478,  6486,  6491,
    6497,  6501,  6505,  6513,  6517,  6525,  6530,  6536,  6540,  6544,
    6548,  6552,  6556,  6560,  6564,  6568,  6572,  6576,  6580,  6584,
    6588,  6592,  6596,  6600,  6604,  6608,  6612,  6616,  6620,  6624,
    6628,  6632,  6636,  6640,  6644,  6648,  6656,  6661,  6667,  6672,
    6678,  6682,  6686,  6690,  6694,  6698,  6702,  6706,  6710,  6714,
    6718,  6722,  6726,  6730,  6734,  6738,  6742,  6746,  6754,  6758,
    6762,  6766,  6770,  6774,  6778,  6782,  6786,  6790,  6794,  6798,
    6802,  6806,  6810,  6814,  6818,  6822,  6830,  6838,  6842,  6846,
    6854,  6858,  6866,  6870,  6874,  6878,  6882,  6890,  6895,  6901,
    6905,  6909,  6913,  6921,  6925,  6930,  6936,  6940,  6948,  6956,
    6961,  6967,  6975,  6979,  6987,  6991,  6995,  6999,  7003,  7007,
    7011,  7015,  7019,  7023,  7027,  7031,  7035,  7039,  7047,  7051,
    7056,  7062,  7066,  7070,  7074,  7078,  7086,  7090,  7094,  7102,
    7107,  7113,  7117,  7125,  7130,  7135,  7141,  7147,  7155,  7163,
    7168,  7174,  7178,  7182,  7186,  7190,  7194,  7198,  7202,  7206,
    7210,  7214,  7218,  7222,  7226,  7230,  7234,  7242,  7247,  7253,
    7257,  7265,  7273,  7278,  7284,  7292,  7296,  7304,  7312,  7316,
    7320,  7324,  7328,  7336,  7341,  7347,  7355,  7359,  7363,  7367,
    7371,  7375,  7383,  7391,  7395,  7399,  7407,  7412,  7418,  7422,
    7426,  7430,  7434,  7442,  7446,  7454,  7458,  7462,  7466,  7474,
    7478,  7486,  7490,  7498,  7503,  7509,  7514,  7520,  7525,  7531,
    7536,  7542,  7546,  7550,  7554,  7562,  7566,  7570,  7574,  7578,
    7582,  7586,  7594,  7598,  7606,  7614,  7618,  7622,  7630,  7634,
    7639,  7645,  7651,  7661,  7666,  7672,  7676,  7680,  7684,  7692,
    7694,  7702,  7707,  7713,  7721,  7725,  7729,  7737,  7741,  7749,
    7757,  7762,  7768,  7776,  7781,  7787,  7795,  7800,  7806,  7810,
    7814,  7818,  7822,  7826,  7830,  7834,  7842,  7847,  7853,  7861,
    7865,  7873,  7877,  7885,  7893,  7901,  7909,  7913,  7921,  7974,
    7978,  7991,  7993,  7997,  8001,  8005,  8014,  8020,  8024,  8032,
    8036,  8044,  8048,  8056,  8060,  8064,  8068,  8072,  8076,  8080,
    8084,  8092,  8096,  8104,  8108,  8112,  8116,  8120,  8124,  8132,
    8136,  8144,  8148,  8156,  8164,  8169,  8175,  8180,  8182,  8188,
    8192,  8196,  8200,  8204,  8208,  8212,  8216,  8220,  8228,  8233,
    8239,  8243,  8248,  8254,  8258,  8262,  8267,  8273,  8278,  8284,
    8292,  8296,  8304,  8308,  8316,  8320,  8324,  8328,  8336,  8341,
    8347,  8351,  8356,  8364,  8368,  8376,  8380,  8388,  8396,  8400,
    8405,  8411,  8419,  8423,  8431,  8435,  8443,  8448,  8454,  8459,
    8465,  8469,  8477,  8482,  8488,  8492,  8500,  8504,  8512,  8517,
    8523,  8527,  8535,  8540,  8546,  8550,  8558,  8562,  8566,  8570,
    8574,  8578,  8582,  8586,  8592,  8596,  8600,  8608,  8612,  8616,
    8620,  8624,  8628,  8636,  8640,  8644,  8648,  8656,  8660,  8664,
    8668,  8676,  8681,  8687,  8691,  8699,  8703,  8707,  8711,  8719,
    8723,  8731,  8735,  8739,  8747,  8755,  8760,  8766,  8770,  8776,
    8782,  8787,  8793,  8797,  8805,  8813,  8815,  8817,  8821,  8825,
    8829,  8837,  8847,  8858,  8867,  8871,  8875,  8879,  8883,  8887,
    8891,  8899,  8903,  8907,  8911,  8919,  8923,  8931,  8936,  8942,
    8946,  8950,  8954,  8958,  8962,  8966,  8970,  8974,  8978,  8982,
    8990,  8995,  9001,  9005,  9013,  9017,  9025,  9033,  9041,  9045,
    9053,  9057,  9065,  9073,  9081,  9085,  9089,  9093,  9097,  9101,
    9109,  9114,  9120,  9125,  9131,  9135,  9139,  9143,  9151,  9159,
    9163,  9168,  9174,  9178,  9182,  9186,  9190,  9194,  9198,  9202,
    9206,  9210,  9214,  9218,  9222,  9227,  9233,  9237,  9245,  9249,
    9253,  9257,  9261,  9265,  9269,  9273,  9277,  9281,  9285,  9289,
    9293,  9297,  9301,  9305,  9309,  9313,  9317,  9321,  9325,  9329,
    9333,  9337,  9341,  9345,  9349,  9353,  9357,  9361,  9365,  9369,
    9373,  9377,  9381,  9385,  9389,  9393,  9397,  9401,  9405,  9409,
    9413,  9417,  9421,  9425,  9429,  9433,  9437,  9441,  9445,  9449,
    9453,  9457,  9461,  9465,  9469,  9474,  9478,  9486,  9490,  9494,
    9498,  9502,  9506,  9510,  9514,  9518,  9522,  9526,  9530,  9534,
    9538,  9542,  9546,  9550,  9554,  9558,  9562,  9566,  9570,  9578,
    9582,  9586,  9590,  9594,  9598,  9602,  9606,  9610,  9614,  9618,
    9626,  9630,  9634,  9638,  9642,  9646,  9650,  9654,  9658,  9662,
    9666,  9670,  9674,  9678,  9682,  9686,  9690,  9694,  9698,  9702,
    9706,  9710,  9714,  9718,  9722,  9726,  9730,  9734,  9738,  9742,
    9746,  9750,  9754,  9758,  9762,  9766,  9770,  9774,  9778,  9782,
    9786,  9790,  9794,  9798,  9802,  9806,  9810,  9814,  9818,  9826,
    9830,  9838,  9842,  9846,  9851,  9857,  9865,  9869,  9877,  9881,
    9889,  9893,  9901,  9905,  9910,  9916,  9920,  9924,  9928,  9936,
    9941,  9947,  9951,  9959,  9967,  9971,  9976,  9982,  9990,  9994,
   10001, 10006, 10012, 10017, 10022, 10028, 10032, 10040, 10044, 10048,
   10052, 10056, 10064, 10068, 10072, 10080, 10084, 10088, 10096, 10100,
   10108, 10112, 10116, 10120, 10124, 10128, 10132, 10136, 10140, 10148,
   10152, 10160, 10164, 10172, 10176, 10180, 10184, 10188, 10192, 10200,
   10204, 10212, 10216, 10224, 10228, 10236, 10240, 10248, 10252, 10256,
   10264, 10268, 10276, 10281, 10287, 10291, 10295, 10299, 10303, 10307,
   10311, 10315, 10323, 10327, 10335, 10343, 10348, 10354, 10358, 10362,
   10366, 10370, 10375, 10381, 10389, 10397, 10401, 10405, 10413, 10417,
   10425, 10433, 10437, 10445, 10453, 10458, 10464, 10469, 10475, 10479,
   10487, 10491, 10495, 10499, 10507, 10511, 10520, 10522, 10530, 10535,
   10541, 10545, 10553, 10557, 10565, 10573, 10577, 10585, 10589, 10593,
   10597, 10605, 10609, 10617, 10621, 10629, 10633, 10641, 10649, 10657,
   10665, 10673, 10681, 10689, 10693, 10701, 10705, 10709, 10713, 10717,
   10721, 10725, 10729, 10733, 10737, 10741, 10745, 10749, 10753, 10754,
   10759, 10765, 10773, 10777, 10778, 10782, 10790, 10794, 10798, 10802,
   10806, 10810, 10814, 10818, 10822, 10826, 10830, 10834, 10838, 10842,
   10846, 10850, 10854, 10858, 10862, 10866, 10870, 10874, 10878, 10882,
   10886, 10890, 10894, 10898, 10902, 10906, 10910, 10914, 10918, 10922,
   10926, 10930, 10934, 10938, 10942, 10946, 10950, 10954, 10958, 10962,
   10966, 10970, 10974, 10978, 10982, 10986, 10990, 10994, 10998, 11002,
   11006, 11010, 11014, 11018, 11022, 11026, 11030, 11034, 11038, 11042,
   11046, 11050, 11054, 11058, 11062, 11066, 11070, 11074, 11078, 11082,
   11086, 11090, 11094, 11098, 11102, 11106, 11110, 11114, 11118, 11122,
   11126, 11130, 11134, 11138, 11142, 11146, 11150, 11154, 11158, 11162,
   11166, 11170, 11174, 11178, 11182, 11186, 11190, 11194, 11198, 11202,
   11206, 11210, 11214, 11218, 11222, 11226, 11230, 11234, 11238, 11242,
   11246, 11250, 11254, 11258, 11262, 11266, 11270, 11274, 11278, 11282,
   11286, 11290, 11294, 11298, 11302, 11306, 11310, 11314, 11318, 11322,
   11326, 11330, 11334, 11338, 11342, 11346, 11350, 11354, 11358, 11362,
   11366, 11370, 11374, 11378, 11382, 11386, 11390, 11394, 11398, 11402,
   11406, 11410, 11414, 11418, 11422, 11426, 11430, 11434, 11438, 11442,
   11446, 11450, 11454, 11458, 11462, 11466, 11470, 11474, 11478, 11482,
   11486, 11490, 11494, 11498, 11502, 11506, 11510, 11514, 11518, 11522,
   11526, 11530, 11534, 11538, 11542, 11546, 11550, 11554, 11558, 11562,
   11566, 11570, 11574, 11578, 11582, 11586, 11590, 11594, 11598, 11602,
   11606, 11610, 11614, 11618, 11622, 11626, 11630, 11634, 11638, 11642,
   11646, 11650, 11654, 11658, 11662, 11666, 11670, 11674, 11678, 11682,
   11686, 11690, 11694, 11698, 11702, 11706, 11710, 11714, 11718, 11722,
   11726, 11730, 11734, 11738, 11742, 11750, 11754, 11758, 11762, 11766,
   11770, 11774, 11778, 11782, 11786, 11790, 11794, 11798, 11802, 11806,
   11810, 11814, 11818, 11822, 11826, 11830, 11834, 11838, 11842, 11846,
   11850, 11854, 11858, 11862, 11866, 11870, 11874, 11878, 11882, 11886,
   11890, 11894, 11898, 11902, 11906, 11910, 11914, 11918, 11922, 11930,
   11934, 11938, 11942, 11946, 11950, 11954, 11958, 11962, 11966, 11970,
   11974, 11978, 11982, 11986, 11990, 11994, 11998, 12002, 12006, 12010,
   12014, 12022, 12026, 12030, 12034, 12038, 12042, 12046, 12050, 12054,
   12058, 12062, 12066, 12070, 12074, 12078, 12082, 12086, 12090, 12094,
   12098, 12102, 12106, 12110, 12114, 12118, 12122, 12126, 12130, 12134,
   12138, 12142, 12146, 12150, 12154, 12158, 12162, 12166, 12170, 12174,
   12178, 12182, 12186, 12190, 12194, 12198, 12202, 12206, 12210, 12214,
   12218, 12222, 12226, 12230, 12234, 12238, 12242, 12246, 12250, 12254,
   12258, 12262, 12266, 12270, 12274, 12278, 12282, 12286, 12290, 12294,
   12298, 12302, 12306, 12310, 12314, 12324, 12325, 12328, 12329, 12330,
   12336, 12337, 12338, 12339, 12340, 12353, 12353, 12362, 12378, 12380,
   12383, 12385, 12389, 12401, 12417, 12421, 12432, 12433, 12436, 12448,
   12457, 12458, 12461, 12462, 12463, 12466, 12467, 12470, 12471, 12474,
   12475, 12478, 12480, 12482, 12484, 12488, 12495, 12502, 12518, 12552,
   12562, 12565, 12567, 12580, 12581, 12583, 12585, 12589, 12602, 12609,
   12670, 12679, 12681, 12682, 12685, 12687, 12688, 12691, 12692, 12693,
   12694, 12695, 12702, 12701, 12711, 12713, 12715, 12716, 12719, 12720,
   12721, 12722, 12725, 12726, 12730, 12729, 12746, 12744, 12760, 12759,
   12773, 12779, 12780, 12783, 12785, 12786, 12789, 12790, 12791, 12792,
   12795, 12796, 12799, 12807, 12824, 12832, 12855, 12961, 12995, 12997,
   12999, 13003, 13007, 13006, 13057, 13059, 13058, 13073, 13079, 13086,
   13091, 13094, 13095, 13098, 13099, 13100, 13101, 13102, 13103, 13104,
   13112, 13120, 13123, 13124, 13125, 13126, 13127, 13128, 13136, 13144,
   13145, 13146, 13149, 13150, 13153, 13155, 13159, 13247, 13248, 13255,
   13256, 13257, 13263, 13272, 13275, 13276, 13277, 13278, 13281, 13282,
   13283, 13286, 13288, 13296, 13297, 13303, 13311, 13312, 13315, 13316,
   13319, 13324, 13331, 13336, 13343, 13350, 13350, 13352, 13359, 13360,
   13363, 13364, 13365, 13366, 13367, 13368, 13369, 13370, 13371, 13377,
   13384, 13396, 13402, 13409, 13417, 13418, 13430, 13441, 13452, 13456,
   13457, 13460, 13465, 13469, 13470, 13473, 13479, 13487, 13490, 13497,
   13501, 13502, 13505, 13508, 13512, 13513, 13516, 13522, 13530, 13531,
   13540, 13549, 13561, 13562, 13563, 13564, 13565, 13566, 13567, 13568,
   13569, 13570, 13571, 13572, 13573, 13574, 13575, 13582, 13583, 13586,
   13587, 13594, 13595, 13596, 13603, 13602, 13619, 13620, 13627, 13626,
   13696, 13702, 13708, 13716, 13722, 13728, 13734, 13740, 13746, 13752,
   13758, 13764, 13775, 13776, 13779, 13780, 13781, 13782, 13783, 13784,
   13785, 13786, 13787, 13788, 13789, 13790, 13791, 13792, 13793, 13794,
   13795, 13796, 13797, 13798, 13799, 13800, 13801, 13802, 13805, 13806,
   13807, 13808, 13809, 13810, 13814, 13815, 13816, 13817, 13818, 13819,
   13820, 13823, 13826, 13827, 13828, 13829, 13830, 13831, 13832, 13833,
   13846, 13847, 13848, 13849, 13850, 13851, 13852, 13857, 13858, 13859,
   13860, 13861, 13862, 13868, 13869, 13870, 13871, 13872, 13873, 13874,
   13875, 13876, 13877, 13878, 13881, 13882, 13883, 13884, 13885, 13888,
   13889, 13890, 13891, 13894, 13895, 13896, 13897, 13898, 13899, 13900,
   13917, 13918, 13919, 13922, 13923, 13924, 13925, 13926, 13927, 13931,
   13931, 13934, 13940, 13941, 13944, 13946, 13951, 13961, 13972, 13979,
   13980, 13981, 13984, 14017, 14019, 14021, 14024, 14034, 14044, 14054,
   14055, 14058, 14060, 14061, 14062, 14065, 14067, 14075, 14076, 14077,
   14081, 14082, 14086, 14087, 14090, 14091, 14094, 14095, 14096, 14097,
   14098, 14101, 14102, 14103, 14104, 14105, 14106, 14107, 14108, 14109,
   14110, 14111, 14112, 14113, 14114, 14115, 14116, 14117, 14118, 14119,
   14120, 14121, 14122, 14123, 14124, 14125, 14126, 14127, 14128, 14129,
   14130, 14131, 14132, 14133, 14134, 14135, 14136, 14137, 14138, 14139,
   14140, 14141, 14142, 14143, 14144, 14145, 14146, 14147, 14148, 14149,
   14150, 14151, 14152, 14153, 14154, 14155, 14156, 14159, 14160, 14161,
   14162, 14165, 14166, 14167, 14168, 14169, 14170, 14171, 14172, 14173,
   14176, 14177, 14178, 14179, 14180, 14183, 14184, 14187, 14188, 14199,
   14200
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT", 
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT", 
  "SQL_COUNT", "SQL_DATETIME_INTERVAL_CODE", 
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR", 
  "SQL_DISCONNECT", "SQL_FOUND", "SQL_FREE", "SQL_GET", "SQL_GO", 
  "SQL_GOTO", "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER", 
  "SQL_LENGTH", "SQL_LONG", "SQL_NULLABLE", "SQL_OCTET_LENGTH", 
  "SQL_OPEN", "SQL_OUTPUT", "SQL_REFERENCE", "SQL_RETURNED_LENGTH", 
  "SQL_RETURNED_OCTET_LENGTH", "SQL_SCALE", "SQL_SECTION", "SQL_SHORT", 
  "SQL_SIGNED", "SQL_SQL", "SQL_SQLERROR", "SQL_SQLPRINT", 
  "SQL_SQLWARNING", "SQL_START", "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED", 
  "SQL_VAR", "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO", 
  "S_CONST", "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN", 
  "S_INC", "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL", 
  "S_NEQUAL", "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB", 
  "S_VOLATILE", "S_TYPEDEF", "CSTRING", "CVARIABLE", "CPP_LINE", "IP", 
  "DOLCONST", "ECONST", "NCONST", "UCONST", "UIDENT", "IDENT", "FCONST", 
  "SCONST", "BCONST", "XCONST", "Op", "ICONST", "PARAM", "TYPECAST", 
  "DOT_DOT", "COLON_EQUALS", "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION", 
  "ADD_P", "ADMIN", "AFTER", "AGGREGATE", "ALL", "ALSO", "ALTER", 
  "ALWAYS", "ANALYSE", "ANALYZE", "AND", "ANY", "ARRAY", "AS", "ASC", 
  "ASSERTION", "ASSIGNMENT", "ASYMMETRIC", "AT", "ATTRIBUTE", 
  "AUTHORIZATION", "BACKWARD", "BEFORE", "BEGIN_P", "BETWEEN", "BIGINT", 
  "BINARY", "BIT", "BOOLEAN_P", "BOTH", "BY", "CACHE", "CALLED", 
  "CASCADE", "CASCADED", "CASE", "CAST", "CATALOG_P", "CHAIN", "CHAR_P", 
  "CHARACTER", "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CLASS", "CLOSE", 
  "CLUSTER", "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMENT", 
  "COMMENTS", "COMMIT", "COMMITTED", "CONCURRENTLY", "CONFIGURATION", 
  "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONTENT_P", "CONTINUE_P", 
  "CONVERSION_P", "COPY", "COST", "CREATE", "CROSS", "CSV", "CURRENT_P", 
  "CURRENT_CATALOG", "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_SCHEMA", 
  "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CYCLE", 
  "DATA_P", "DATABASE", "DAY_P", "DEALLOCATE", "DEC", "DECIMAL_P", 
  "DECLARE", "DEFAULT", "DEFAULTS", "DEFERRABLE", "DEFERRED", "DEFINER", 
  "DELETE_P", "DELIMITER", "DELIMITERS", "DESC", "DICTIONARY", 
  "DISABLE_P", "DISCARD", "DISTINCT", "DO", "DOCUMENT_P", "DOMAIN_P", 
  "DOUBLE_P", "DROP", "EACH", "ELSE", "ENABLE_P", "ENCODING", "ENCRYPTED", 
  "END_P", "ENUM_P", "ESCAPE", "EXCEPT", "EXCLUDE", "EXCLUDING", 
  "EXCLUSIVE", "EXECUTE", "EXISTS", "EXPLAIN", "EXTENSION", "EXTERNAL", 
  "EXTRACT", "FALSE_P", "FAMILY", "FETCH", "FIRST_P", "FLOAT_P", 
  "FOLLOWING", "FOR", "FORCE", "FOREIGN", "FORWARD", "FREEZE", "FROM", 
  "FULL", "FUNCTION", "FUNCTIONS", "GLOBAL", "GRANT", "GRANTED", 
  "GREATEST", "GROUP_P", "HANDLER", "HAVING", "HEADER_P", "HOLD", 
  "HOUR_P", "IDENTITY_P", "IF_P", "ILIKE", "IMMEDIATE", "IMMUTABLE", 
  "IMPLICIT_P", "IN_P", "INCLUDING", "INCREMENT", "INDEX", "INDEXES", 
  "INHERIT", "INHERITS", "INITIALLY", "INLINE_P", "INNER_P", "INOUT", 
  "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", "INT_P", "INTEGER", 
  "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", "ISNULL", "ISOLATION", 
  "JOIN", "KEY", "LABEL", "LANGUAGE", "LARGE_P", "LAST_P", "LC_COLLATE_P", 
  "LC_CTYPE_P", "LEADING", "LEAST", "LEFT", "LEVEL", "LIKE", "LIMIT", 
  "LISTEN", "LOAD", "LOCAL", "LOCALTIME", "LOCALTIMESTAMP", "LOCATION", 
  "LOCK_P", "MAPPING", "MATCH", "MAXVALUE", "MINUTE_P", "MINVALUE", 
  "MODE", "MONTH_P", "MOVE", "NAME_P", "NAMES", "NATIONAL", "NATURAL", 
  "NCHAR", "NEXT", "NO", "NONE", "NOT", "NOTHING", "NOTIFY", "NOTNULL", 
  "NOWAIT", "NULL_P", "NULLIF", "NULLS_P", "NUMERIC", "OBJECT_P", "OF", 
  "OFF", "OFFSET", "OIDS", "ON", "ONLY", "OPERATOR", "OPTION", "OPTIONS", 
  "OR", "ORDER", "OUT_P", "OUTER_P", "OVER", "OVERLAPS", "OVERLAY", 
  "OWNED", "OWNER", "PARSER", "PARTIAL", "PARTITION", "PASSING", 
  "PASSWORD", "PLACING", "PLANS", "POSITION", "PRECEDING", "PRECISION", 
  "PRESERVE", "PREPARE", "PREPARED", "PRIMARY", "PRIOR", "PRIVILEGES", 
  "PROCEDURAL", "PROCEDURE", "QUOTE", "RANGE", "READ", "REAL", "REASSIGN", 
  "RECHECK", "RECURSIVE", "REF", "REFERENCES", "REINDEX", "RELATIVE_P", 
  "RELEASE", "RENAME", "REPEATABLE", "REPLACE", "REPLICA", "RESET", 
  "RESTART", "RESTRICT", "RETURNING", "RETURNS", "REVOKE", "RIGHT", 
  "ROLE", "ROLLBACK", "ROW", "ROWS", "RULE", "SAVEPOINT", "SCHEMA", 
  "SCROLL", "SEARCH", "SECOND_P", "SECURITY", "SELECT", "SEQUENCE", 
  "SEQUENCES", "SERIALIZABLE", "SERVER", "SESSION", "SESSION_USER", "SET", 
  "SETOF", "SHARE", "SHOW", "SIMILAR", "SIMPLE", "SMALLINT", "SOME", 
  "STABLE", "STANDALONE_P", "START", "STATEMENT", "STATISTICS", "STDIN", 
  "STDOUT", "STORAGE", "STRICT_P", "STRIP_P", "SUBSTRING", "SYMMETRIC", 
  "SYSID", "SYSTEM_P", "TABLE", "TABLES", "TABLESPACE", "TEMP", 
  "TEMPLATE", "TEMPORARY", "TEXT_P", "THEN", "TIME", "TIMESTAMP", "TO", 
  "TRAILING", "TRANSACTION", "TREAT", "TRIGGER", "TRIM", "TRUE_P", 
  "TRUNCATE", "TRUSTED", "TYPE_P", "UNBOUNDED", "UNCOMMITTED", 
  "UNENCRYPTED", "UNION", "UNIQUE", "UNKNOWN", "UNLISTEN", "UNLOGGED", 
  "UNTIL", "UPDATE", "USER", "USING", "VACUUM", "VALID", "VALIDATE", 
  "VALIDATOR", "VALUE_P", "VALUES", "VARCHAR", "VARIADIC", "VARYING", 
  "VERBOSE", "VERSION_P", "VIEW", "VOLATILE", "WHEN", "WHERE", 
  "WHITESPACE_P", "WINDOW", "WITH", "WITHOUT", "WORK", "WRAPPER", "WRITE", 
  "XML_P", "XMLATTRIBUTES", "XMLCONCAT", "XMLELEMENT", "XMLEXISTS", 
  "XMLFOREST", "XMLPARSE", "XMLPI", "XMLROOT", "XMLSERIALIZE", "YEAR_P", 
  "YES_P", "ZONE", "NULLS_FIRST", "NULLS_LAST", "WITH_TIME", "'='", "'<'", 
  "'>'", "POSTFIXOP", "'+'", "'-'", "'*'", "'/'", "'%'", "'^'", "UMINUS", 
  "'['", "']'", "'('", "')'", "'.'", "','", "';'", "':'", "'{'", "'}'", 
  "$accept", "prog", "stmt", "CreateRoleStmt", "opt_with", "OptRoleList", 
  "AlterOptRoleList", "AlterOptRoleElem", "CreateOptRoleElem", 
  "CreateUserStmt", "AlterRoleStmt", "opt_in_database", 
  "AlterRoleSetStmt", "AlterUserStmt", "AlterUserSetStmt", "DropRoleStmt", 
  "DropUserStmt", "CreateGroupStmt", "AlterGroupStmt", "add_drop", 
  "DropGroupStmt", "CreateSchemaStmt", "OptSchemaName", 
  "OptSchemaEltList", "schema_stmt", "VariableSetStmt", "set_rest", 
  "var_name", "var_list", "var_value", "iso_level", 
  "opt_boolean_or_string", "zone_value", "opt_encoding", 
  "ColId_or_Sconst", "VariableResetStmt", "SetResetClause", 
  "VariableShowStmt", "ConstraintsSetStmt", "constraints_set_list", 
  "constraints_set_mode", "CheckPointStmt", "DiscardStmt", 
  "AlterTableStmt", "alter_table_cmds", "alter_table_cmd", 
  "alter_column_default", "opt_drop_behavior", "opt_collate_clause", 
  "alter_using", "reloptions", "opt_reloptions", "reloption_list", 
  "reloption_elem", "AlterCompositeTypeStmt", "alter_type_cmds", 
  "alter_type_cmd", "ClosePortalStmt", "CopyStmt", "copy_from", 
  "copy_file_name", "copy_options", "copy_opt_list", "copy_opt_item", 
  "opt_binary", "opt_oids", "copy_delimiter", "opt_using", 
  "copy_generic_opt_list", "copy_generic_opt_elem", 
  "copy_generic_opt_arg", "copy_generic_opt_arg_list", 
  "copy_generic_opt_arg_list_item", "CreateStmt", "OptTemp", 
  "OptTableElementList", "OptTypedTableElementList", "TableElementList", 
  "TypedTableElementList", "TableElement", "TypedTableElement", 
  "columnDef", "columnOptions", "ColQualList", "ColConstraint", 
  "ColConstraintElem", "ConstraintAttr", "TableLikeClause", 
  "TableLikeOptionList", "TableLikeOption", "TableConstraint", 
  "ConstraintElem", "opt_column_list", "columnList", "columnElem", 
  "key_match", "ExclusionConstraintList", "ExclusionConstraintElem", 
  "ExclusionWhereClause", "key_actions", "key_update", "key_delete", 
  "key_action", "OptInherit", "OptWith", "OnCommitOption", 
  "OptTableSpace", "OptConsTableSpace", "ExistingIndex", 
  "create_as_target", "OptCreateAs", "CreateAsList", "CreateAsElement", 
  "opt_with_data", "CreateSeqStmt", "AlterSeqStmt", "OptSeqOptList", 
  "SeqOptList", "SeqOptElem", "opt_by", "NumericOnly", "NumericOnly_list", 
  "CreatePLangStmt", "opt_trusted", "handler_name", "opt_inline_handler", 
  "validator_clause", "opt_validator", "DropPLangStmt", "opt_procedural", 
  "CreateTableSpaceStmt", "OptTableSpaceOwner", "DropTableSpaceStmt", 
  "CreateExtensionStmt", "create_extension_opt_list", 
  "create_extension_opt_item", "AlterExtensionStmt", 
  "alter_extension_opt_list", "alter_extension_opt_item", 
  "AlterExtensionContentsStmt", "CreateFdwStmt", "fdw_option", 
  "fdw_options", "opt_fdw_options", "DropFdwStmt", "AlterFdwStmt", 
  "create_generic_options", "generic_option_list", 
  "alter_generic_options", "alter_generic_option_list", 
  "alter_generic_option_elem", "generic_option_elem", 
  "generic_option_name", "generic_option_arg", "CreateForeignServerStmt", 
  "opt_type", "foreign_server_version", "opt_foreign_server_version", 
  "DropForeignServerStmt", "AlterForeignServerStmt", 
  "CreateForeignTableStmt", "OptForeignTableElementList", 
  "ForeignTableElementList", "ForeignTableElement", 
  "AlterForeignTableStmt", "CreateUserMappingStmt", "auth_ident", 
  "DropUserMappingStmt", "AlterUserMappingStmt", "CreateTrigStmt", 
  "TriggerActionTime", "TriggerEvents", "TriggerOneEvent", 
  "TriggerForSpec", "TriggerForOptEach", "TriggerForType", "TriggerWhen", 
  "TriggerFuncArgs", "TriggerFuncArg", "OptConstrFromTable", 
  "ConstraintAttributeSpec", "ConstraintDeferrabilitySpec", 
  "ConstraintTimeSpec", "DropTrigStmt", "CreateAssertStmt", 
  "DropAssertStmt", "DefineStmt", "definition", "def_list", "def_elem", 
  "def_arg", "aggr_args", "old_aggr_definition", "old_aggr_list", 
  "old_aggr_elem", "opt_enum_val_list", "enum_val_list", "AlterEnumStmt", 
  "CreateOpClassStmt", "opclass_item_list", "opclass_item", "opt_default", 
  "opt_opfamily", "opclass_purpose", "opt_recheck", "CreateOpFamilyStmt", 
  "AlterOpFamilyStmt", "opclass_drop_list", "opclass_drop", 
  "DropOpClassStmt", "DropOpFamilyStmt", "DropOwnedStmt", 
  "ReassignOwnedStmt", "DropStmt", "drop_type", "any_name_list", 
  "any_name", "attrs", "TruncateStmt", "opt_restart_seqs", "CommentStmt", 
  "comment_type", "comment_text", "SecLabelStmt", "opt_provider", 
  "security_label_type", "security_label", "FetchStmt", "fetch_args", 
  "from_in", "opt_from_in", "GrantStmt", "RevokeStmt", "privileges", 
  "privilege_list", "privilege", "privilege_target", "grantee_list", 
  "grantee", "opt_grant_grant_option", "function_with_argtypes_list", 
  "function_with_argtypes", "GrantRoleStmt", "RevokeRoleStmt", 
  "opt_grant_admin_option", "opt_granted_by", 
  "AlterDefaultPrivilegesStmt", "DefACLOptionList", "DefACLOption", 
  "DefACLAction", "defacl_privilege_target", "IndexStmt", "opt_unique", 
  "opt_concurrently", "opt_index_name", "access_method_clause", 
  "index_params", "index_elem", "opt_collate", "opt_class", 
  "opt_asc_desc", "opt_nulls_order", "CreateFunctionStmt", 
  "opt_or_replace", "func_args", "func_args_list", 
  "func_args_with_defaults", "func_args_with_defaults_list", "func_arg", 
  "arg_class", "param_name", "func_return", "func_type", 
  "func_arg_with_default", "createfunc_opt_list", "common_func_opt_item", 
  "createfunc_opt_item", "func_as", "opt_definition", "table_func_column", 
  "table_func_column_list", "AlterFunctionStmt", "alterfunc_opt_list", 
  "opt_restrict", "RemoveFuncStmt", "RemoveAggrStmt", "RemoveOperStmt", 
  "oper_argtypes", "any_operator", "DoStmt", "dostmt_opt_list", 
  "dostmt_opt_item", "CreateCastStmt", "cast_context", "DropCastStmt", 
  "opt_if_exists", "ReindexStmt", "reindex_type", "opt_force", 
  "RenameStmt", "opt_column", "opt_set_data", "AlterObjectSchemaStmt", 
  "AlterOwnerStmt", "RuleStmt", "RuleActionList", "RuleActionMulti", 
  "RuleActionStmt", "RuleActionStmtOrEmpty", "event", "opt_instead", 
  "DropRuleStmt", "NotifyStmt", "notify_payload", "ListenStmt", 
  "UnlistenStmt", "TransactionStmt", "opt_transaction", 
  "transaction_mode_item", "transaction_mode_list", 
  "transaction_mode_list_or_empty", "ViewStmt", "opt_check_option", 
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item", 
  "opt_equal", "AlterDatabaseStmt", "AlterDatabaseSetStmt", 
  "alterdb_opt_list", "alterdb_opt_item", "DropdbStmt", 
  "CreateDomainStmt", "AlterDomainStmt", "opt_as", 
  "AlterTSDictionaryStmt", "AlterTSConfigurationStmt", 
  "CreateConversionStmt", "ClusterStmt", "cluster_index_specification", 
  "VacuumStmt", "vacuum_option_list", "vacuum_option_elem", "AnalyzeStmt", 
  "analyze_keyword", "opt_verbose", "opt_full", "opt_freeze", 
  "opt_name_list", "ExplainStmt", "ExplainableStmt", 
  "explain_option_list", "explain_option_elem", "explain_option_name", 
  "explain_option_arg", "PrepareStmt", "prep_type_clause", 
  "PreparableStmt", "ExecuteStmt", "execute_param_clause", "InsertStmt", 
  "insert_rest", "insert_column_list", "insert_column_item", 
  "returning_clause", "DeleteStmt", "using_clause", "LockStmt", 
  "opt_lock", "lock_type", "opt_nowait", "UpdateStmt", "set_clause_list", 
  "set_clause", "single_set_clause", "multiple_set_clause", "set_target", 
  "set_target_list", "DeclareCursorStmt", "cursor_name", "cursor_options", 
  "opt_hold", "SelectStmt", "select_with_parens", "select_no_parens", 
  "select_clause", "simple_select", "with_clause", "cte_list", 
  "common_table_expr", "opt_with_clause", "into_clause", 
  "OptTempTableName", "opt_table", "opt_all", "opt_distinct", 
  "opt_sort_clause", "sort_clause", "sortby_list", "sortby", 
  "select_limit", "opt_select_limit", "limit_clause", "offset_clause", 
  "select_limit_value", "select_offset_value", 
  "opt_select_fetch_first_value", "select_offset_value2", "row_or_rows", 
  "first_or_next", "group_clause", "having_clause", "for_locking_clause", 
  "opt_for_locking_clause", "for_locking_items", "for_locking_item", 
  "locked_rels_list", "values_clause", "from_clause", "from_list", 
  "table_ref", "joined_table", "alias_clause", "join_type", "join_outer", 
  "join_qual", "relation_expr", "relation_expr_list", 
  "relation_expr_opt_alias", "func_table", "where_clause", 
  "where_or_current_clause", "OptTableFuncElementList", 
  "TableFuncElementList", "TableFuncElement", "Typename", 
  "opt_array_bounds", "SimpleTypename", "ConstTypename", "GenericType", 
  "opt_type_modifiers", "Numeric", "opt_float", "Bit", "ConstBit", 
  "BitWithLength", "BitWithoutLength", "Character", "ConstCharacter", 
  "CharacterWithLength", "CharacterWithoutLength", "character", 
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval", 
  "opt_timezone", "opt_interval", "interval_second", "a_expr", "b_expr", 
  "c_expr", "func_expr", "xml_root_version", "opt_xml_root_standalone", 
  "xml_attributes", "xml_attribute_list", "xml_attribute_el", 
  "document_or_content", "xml_whitespace_option", "xmlexists_argument", 
  "window_clause", "window_definition_list", "window_definition", 
  "over_clause", "window_specification", "opt_existing_window_name", 
  "opt_partition_clause", "opt_frame_clause", "frame_extent", 
  "frame_bound", "row", "sub_type", "all_Op", "MathOp", "qual_Op", 
  "qual_all_Op", "subquery_Op", "expr_list", "func_arg_list", 
  "func_arg_expr", "type_list", "array_expr", "array_expr_list", 
  "extract_list", "extract_arg", "overlay_list", "overlay_placing", 
  "position_list", "substr_list", "substr_from", "substr_for", 
  "trim_list", "in_expr", "case_expr", "when_clause_list", "when_clause", 
  "case_default", "case_arg", "columnref", "indirection_el", 
  "indirection", "opt_indirection", "opt_asymmetric", "ctext_expr", 
  "ctext_expr_list", "ctext_row", "target_list", "target_el", 
  "qualified_name_list", "qualified_name", "name_list", "name", 
  "database_name", "access_method", "attr_name", "index_name", 
  "file_name", "func_name", "AexprConst", "Iconst", "RoleId", 
  "SignedIconst", "unreserved_keyword", "col_name_keyword", 
  "type_func_name_keyword", "reserved_keyword", "statements", "statement", 
  "CreateAsStmt", "@1", "at", "ECPGConnect", "connection_target", 
  "opt_database_name", "db_prefix", "server", "opt_server", "server_name", 
  "opt_port", "opt_connection_name", "opt_user", "ora_user", "user_name", 
  "char_variable", "opt_options", "connect_options", "opt_opt_value", 
  "prepared_name", "ECPGCursorStmt", "ECPGExecuteImmediateStmt", 
  "ECPGVarDeclaration", "single_vt_declaration", "precision", "opt_scale", 
  "ecpg_interval", "ECPGDeclaration", "@2", "sql_startdeclare", 
  "sql_enddeclare", "var_type_declarations", "vt_declarations", 
  "variable_declarations", "type_declaration", "@3", "var_declaration", 
  "@4", "@5", "opt_bit_field", "storage_declaration", "storage_clause", 
  "storage_modifier", "var_type", "enum_type", "enum_definition", 
  "struct_union_type_with_symbol", "@6", "struct_union_type", "@7", 
  "s_struct_union_symbol", "s_struct_union", "simple_type", 
  "unsigned_type", "signed_type", "opt_signed", "variable_list", 
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare", 
  "ECPGDisconnect", "dis_name", "connection_object", "execstring", 
  "ECPGFree", "ECPGOpen", "opt_ecpg_using", "ecpg_using", 
  "using_descriptor", "into_descriptor", "into_sqlda", "using_list", 
  "UsingValue", "UsingConst", "ECPGDescribe", "opt_output", 
  "ECPGAllocateDescr", "ECPGDeallocateDescr", "ECPGGetDescriptorHeader", 
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem", 
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems", 
  "ECPGSetDescHeaderItem", "IntConstVar", "desc_header_item", 
  "ECPGGetDescriptor", "ECPGGetDescItems", "ECPGGetDescItem", 
  "ECPGSetDescriptor", "ECPGSetDescItems", "ECPGSetDescItem", 
  "AllConstVar", "descriptor_item", "ECPGSetAutocommit", "on_off", 
  "ECPGSetConnection", "ECPGTypedef", "@8", "opt_reference", "ECPGVar", 
  "@9", "ECPGWhenever", "action", "ECPGKeywords", "ECPGKeywords_vanames", 
  "ECPGKeywords_rest", "ECPGTypeName", "symbol", "ECPGColId", "ColId", 
  "type_function_name", "ColLabel", "ECPGColLabel", "ECPGColLabelCommon", 
  "ECPGCKeywords", "all_unreserved_keyword", "ECPGunreserved_interval", 
  "into_list", "ecpgstart", "c_args", "coutputvariable", "civarind", 
  "char_civar", "civar", "indicator", "cvariable", "ecpg_param", 
  "ecpg_bconst", "ecpg_fconst", "ecpg_sconst", "ecpg_xconst", 
  "ecpg_ident", "quoted_ident_stringvar", "c_stuff_item", "c_stuff", 
  "c_list", "c_term", "c_thing", "c_anything", "DeallocateStmt", 
  "Iresult", "execute_rest", "ecpg_into", "ecpg_fetch_into", 
  "opt_ecpg_fetch_into", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,    61,    60,    62,
     742,    43,    45,    42,    47,    37,    94,   743,    91,    93,
      40,    41,    46,    44,    59,    58,   123,   125
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   508,   509,   510,   510,   510,   510,   510,   510,   510,
     510,   510,   510,   510,   510,   510,   510,   510,   510,   510,
     510,   510,   510,   510,   510,   510,   510,   510,   510,   510,
     510,   510,   510,   510,   510,   510,   510,   510,   510,   510,
     510,   510,   510,   510,   510,   510,   510,   510,   510,   510,
     510,   510,   510,   510,   510,   510,   510,   510,   510,   510,
     510,   510,   510,   510,   510,   510,   510,   510,   510,   510,
     510,   510,   510,   510,   510,   510,   510,   510,   510,   510,
     510,   510,   510,   510,   510,   510,   510,   510,   510,   510,
     510,   510,   510,   510,   510,   510,   510,   510,   510,   510,
     510,   510,   510,   510,   510,   510,   510,   510,   510,   510,
     510,   510,   510,   510,   510,   510,   510,   510,   510,   510,
     510,   510,   510,   510,   510,   510,   510,   510,   510,   510,
     510,   510,   510,   511,   512,   512,   513,   513,   514,   514,
     515,   515,   515,   515,   515,   515,   515,   515,   515,   516,
     516,   516,   516,   516,   516,   517,   518,   519,   519,   520,
     521,   522,   523,   523,   524,   524,   525,   526,   527,   527,
     528,   528,   529,   529,   530,   530,   531,   531,   532,   532,
     532,   532,   532,   532,   533,   533,   533,   534,   534,   534,
     534,   534,   534,   534,   534,   534,   534,   534,   534,   534,
     534,   534,   535,   535,   536,   536,   537,   537,   538,   538,
     538,   538,   539,   539,   539,   539,   540,   540,   540,   540,
     540,   540,   540,   541,   541,   541,   542,   542,   543,   543,
     543,   543,   543,   544,   544,   545,   545,   545,   545,   545,
     546,   547,   547,   548,   548,   549,   550,   550,   550,   550,
     551,   551,   551,   551,   552,   552,   553,   553,   553,   553,
     553,   553,   553,   553,   553,   553,   553,   553,   553,   553,
     553,   553,   553,   553,   553,   553,   553,   553,   553,   553,
     553,   553,   553,   553,   553,   553,   553,   553,   553,   553,
     553,   553,   553,   553,   553,   553,   553,   554,   554,   555,
     555,   555,   556,   556,   557,   557,   558,   559,   559,   560,
     560,   561,   561,   561,   561,   562,   563,   563,   564,   564,
     564,   564,   565,   565,   566,   566,   567,   567,   568,   568,
     568,   569,   569,   570,   570,   571,   571,   571,   571,   571,
     571,   571,   571,   571,   571,   571,   571,   572,   572,   573,
     573,   574,   574,   575,   575,   576,   576,   577,   578,   578,
     578,   578,   578,   579,   579,   580,   581,   581,   581,   581,
     582,   582,   582,   582,   582,   582,   582,   582,   583,   583,
     584,   584,   585,   585,   586,   586,   587,   587,   587,   588,
     588,   589,   590,   591,   591,   592,   592,   592,   592,   593,
     593,   593,   593,   593,   593,   593,   594,   594,   594,   594,
     595,   596,   596,   596,   597,   597,   597,   597,   597,   597,
     598,   598,   599,   599,   599,   599,   599,   599,   599,   599,
     600,   600,   601,   601,   602,   603,   603,   603,   603,   604,
     604,   605,   605,   606,   606,   607,   607,   607,   607,   607,
     608,   609,   610,   610,   610,   610,   610,   611,   611,   612,
     612,   612,   612,   613,   613,   613,   613,   614,   614,   615,
     615,   616,   617,   618,   618,   619,   619,   620,   621,   621,
     621,   622,   623,   624,   624,   625,   625,   626,   626,   626,
     626,   626,   626,   626,   626,   626,   626,   626,   626,   627,
     627,   628,   628,   628,   629,   629,   630,   630,   631,   631,
     632,   632,   633,   633,   634,   634,   635,   635,   636,   636,
     637,   637,   638,   639,   639,   640,   640,   641,   641,   642,
     642,   643,   643,   643,   644,   645,   645,   646,   647,   647,
     647,   647,   647,   647,   647,   647,   647,   647,   647,   647,
     647,   647,   647,   647,   647,   647,   647,   647,   647,   647,
     648,   649,   649,   649,   649,   650,   650,   651,   651,   652,
     652,   653,   653,   654,   654,   655,   655,   656,   657,   657,
     658,   658,   658,   658,   659,   660,   661,   662,   663,   663,
     664,   664,   665,   665,   666,   666,   667,   667,   667,   668,
     668,   669,   669,   670,   670,   671,   672,   673,   674,   674,
     674,   675,   675,   676,   677,   677,   678,   678,   678,   679,
     679,   680,   680,   680,   680,   680,   681,   681,   682,   682,
     683,   683,   684,   684,   685,   685,   685,   686,   686,   686,
     686,   687,   687,   688,   688,   688,   688,   688,   689,   689,
     690,   690,   691,   691,   692,   693,   694,   694,   694,   694,
     694,   694,   694,   694,   694,   694,   694,   694,   694,   695,
     696,   696,   697,   697,   698,   698,   698,   698,   698,   699,
     699,   700,   701,   701,   702,   703,   703,   704,   704,   705,
     705,   705,   706,   707,   707,   708,   708,   708,   708,   708,
     709,   709,   710,   710,   711,   711,   711,   712,   712,   713,
     714,   714,   715,   715,   716,   716,   717,   717,   718,   718,
     719,   720,   721,   721,   722,   722,   722,   722,   722,   722,
     722,   722,   722,   722,   722,   722,   722,   722,   722,   723,
     723,   724,   724,   725,   725,   726,   727,   727,   727,   728,
     728,   728,   728,   728,   728,   728,   728,   728,   728,   728,
     728,   728,   728,   728,   728,   728,   729,   729,   729,   729,
     729,   729,   729,   729,   729,   729,   729,   729,   729,   729,
     729,   729,   729,   730,   730,   731,   731,   731,   731,   731,
     732,   732,   733,   733,   733,   733,   733,   733,   733,   733,
     734,   734,   735,   735,   735,   735,   735,   735,   735,   735,
     735,   735,   735,   736,   736,   736,   736,   736,   736,   736,
     736,   736,   736,   736,   736,   736,   736,   737,   737,   738,
     738,   739,   740,   740,   741,   741,   741,   741,   741,   742,
     742,   743,   743,   743,   743,   744,   744,   744,   744,   744,
     744,   744,   744,   744,   744,   744,   744,   744,   744,   745,
     745,   746,   746,   747,   747,   748,   748,   749,   750,   751,
     751,   752,   752,   753,   753,   754,   755,   755,   756,   756,
     756,   757,   757,   757,   758,   758,   758,   759,   760,   760,
     761,   761,   762,   762,   763,   763,   764,   764,   765,   765,
     765,   766,   766,   767,   767,   767,   768,   768,   768,   769,
     769,   769,   770,   770,   770,   771,   771,   772,   772,   773,
     773,   774,   774,   775,   775,   776,   776,   776,   776,   776,
     777,   777,   777,   777,   777,   778,   779,   780,   780,   780,
     781,   781,   781,   782,   782,   783,   783,   783,   783,   783,
     783,   783,   783,   783,   783,   783,   783,   783,   784,   784,
     784,   784,   785,   785,   786,   786,   787,   788,   788,   789,
     790,   790,   791,   791,   792,   792,   793,   793,   794,   794,
     795,   795,   795,   795,   796,   796,   797,   798,   798,   799,
     799,   800,   800,   800,   801,   801,   801,   802,   803,   803,
     804,   804,   804,   805,   805,   806,   806,   807,   807,   807,
     807,   807,   807,   807,   807,   807,   807,   807,   807,   807,
     807,   807,   807,   807,   807,   807,   807,   807,   807,   807,
     807,   807,   807,   807,   807,   807,   808,   808,   809,   809,
     810,   810,   810,   810,   810,   810,   810,   810,   810,   810,
     810,   810,   810,   810,   810,   810,   810,   810,   811,   811,
     811,   811,   811,   811,   811,   811,   811,   811,   811,   811,
     811,   811,   811,   811,   811,   811,   812,   813,   813,   813,
     814,   814,   815,   815,   815,   815,   815,   816,   816,   817,
     817,   817,   817,   818,   818,   818,   819,   819,   820,   821,
     821,   822,   823,   823,   824,   824,   824,   824,   824,   824,
     824,   824,   824,   824,   824,   824,   824,   824,   825,   825,
     825,   826,   826,   826,   826,   826,   827,   827,   827,   828,
     828,   829,   829,   830,   830,   830,   830,   831,   832,   833,
     833,   834,   834,   834,   834,   834,   834,   834,   834,   834,
     834,   834,   834,   834,   834,   834,   834,   835,   835,   836,
     836,   837,   838,   838,   839,   840,   840,   841,   842,   842,
     842,   842,   842,   843,   843,   844,   845,   845,   845,   845,
     845,   845,   846,   847,   847,   847,   848,   848,   849,   849,
     849,   849,   849,   850,   850,   851,   851,   851,   851,   852,
     852,   853,   853,   854,   854,   855,   855,   856,   856,   857,
     857,   858,   858,   858,   858,   859,   859,   859,   859,   859,
     859,   859,   860,   860,   861,   862,   862,   862,   863,   863,
     863,   864,   864,   865,   865,   866,   866,   866,   866,   867,
     867,   868,   868,   869,   870,   870,   870,   871,   871,   872,
     873,   873,   874,   875,   875,   876,   877,   877,   878,   878,
     878,   878,   878,   878,   878,   878,   879,   879,   880,   881,
     881,   882,   882,   883,   884,   885,   886,   886,   887,   888,
     888,   889,   889,   889,   889,   889,   890,   890,   890,   891,
     891,   892,   892,   893,   893,   893,   893,   893,   893,   893,
     893,   894,   894,   895,   895,   895,   895,   895,   895,   896,
     896,   897,   897,   898,   899,   899,   900,   900,   900,   901,
     901,   901,   901,   901,   901,   901,   901,   901,   902,   902,
     903,   903,   903,   904,   904,   904,   904,   905,   905,   906,
     907,   907,   908,   908,   909,   909,   909,   909,   910,   910,
     911,   911,   911,   912,   912,   913,   913,   914,   915,   915,
     915,   916,   917,   917,   918,   918,   919,   919,   920,   920,
     921,   921,   922,   922,   923,   923,   924,   924,   925,   925,
     926,   926,   927,   927,   928,   928,   929,   929,   929,   929,
     929,   929,   929,   929,   929,   929,   929,   930,   930,   930,
     930,   930,   930,   931,   931,   931,   931,   932,   932,   932,
     932,   933,   933,   934,   934,   935,   935,   935,   935,   936,
     936,   937,   937,   937,   938,   939,   939,   940,   940,   940,
     941,   941,   942,   942,   943,   944,   944,   944,   944,   944,
     944,   945,   945,   945,   946,   946,   946,   946,   946,   946,
     946,   947,   947,   947,   947,   948,   948,   949,   949,   950,
     950,   950,   950,   950,   950,   950,   950,   950,   950,   950,
     951,   951,   952,   952,   953,   953,   954,   955,   956,   956,
     957,   957,   958,   959,   960,   960,   960,   960,   960,   960,
     961,   961,   962,   962,   963,   963,   963,   963,   964,   965,
     965,   965,   966,   966,   966,   966,   966,   966,   966,   966,
     966,   966,   966,   966,   966,   966,   967,   967,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   969,   969,   969,
     969,   969,   969,   969,   969,   969,   969,   969,   969,   969,
     969,   969,   969,   969,   969,   969,   969,   969,   969,   970,
     970,   970,   970,   970,   970,   970,   970,   970,   970,   970,
     971,   971,   971,   971,   971,   971,   971,   971,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   971,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   971,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   971,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   971,   971,   972,
     972,   973,   973,   973,   973,   974,   975,   975,   976,   976,
     977,   977,   978,   978,   978,   979,   979,   979,   979,   980,
     980,   981,   981,   982,   983,   983,   983,   984,   985,   985,
     986,   986,   987,   987,   987,   988,   988,   989,   989,   989,
     989,   989,   990,   990,   990,   991,   991,   991,   992,   992,
     993,   993,   993,   993,   993,   993,   993,   993,   993,   994,
     994,   995,   995,   996,   996,   996,   996,   996,   996,   997,
     997,   998,   998,   999,   999,  1000,  1000,  1001,  1001,  1001,
    1002,  1002,  1003,  1003,  1004,  1004,  1004,  1004,  1004,  1004,
    1004,  1004,  1005,  1005,  1006,  1007,  1007,  1008,  1008,  1008,
    1008,  1008,  1008,  1009,  1010,  1011,  1011,  1011,  1012,  1012,
    1013,  1014,  1014,  1015,  1016,  1016,  1017,  1017,  1018,  1018,
    1019,  1019,  1019,  1019,  1020,  1020,  1021,  1021,  1022,  1022,
    1023,  1023,  1024,  1024,  1025,  1026,  1026,  1027,  1027,  1027,
    1027,  1028,  1028,  1029,  1029,  1030,  1030,  1031,  1032,  1033,
    1034,  1035,  1036,  1037,  1037,  1038,  1038,  1038,  1038,  1038,
    1038,  1038,  1038,  1038,  1038,  1038,  1038,  1038,  1038,  1038,
    1039,  1040,  1041,  1041,  1041,  1041,  1042,  1042,  1042,  1042,
    1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,
    1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,
    1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,
    1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,
    1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,
    1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,
    1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,
    1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,
    1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,
    1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,
    1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,
    1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,
    1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,
    1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,
    1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,
    1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,
    1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,
    1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,
    1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,
    1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,
    1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,
    1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,
    1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,
    1042,  1042,  1042,  1042,  1042,  1043,  1043,  1043,  1043,  1043,
    1043,  1043,  1043,  1043,  1043,  1043,  1043,  1043,  1043,  1043,
    1043,  1043,  1043,  1043,  1043,  1043,  1043,  1043,  1043,  1043,
    1043,  1043,  1043,  1043,  1043,  1043,  1043,  1043,  1043,  1043,
    1043,  1043,  1043,  1043,  1043,  1043,  1043,  1043,  1043,  1044,
    1044,  1044,  1044,  1044,  1044,  1044,  1044,  1044,  1044,  1044,
    1044,  1044,  1044,  1044,  1044,  1044,  1044,  1044,  1044,  1044,
    1044,  1045,  1045,  1045,  1045,  1045,  1045,  1045,  1045,  1045,
    1045,  1045,  1045,  1045,  1045,  1045,  1045,  1045,  1045,  1045,
    1045,  1045,  1045,  1045,  1045,  1045,  1045,  1045,  1045,  1045,
    1045,  1045,  1045,  1045,  1045,  1045,  1045,  1045,  1045,  1045,
    1045,  1045,  1045,  1045,  1045,  1045,  1045,  1045,  1045,  1045,
    1045,  1045,  1045,  1045,  1045,  1045,  1045,  1045,  1045,  1045,
    1045,  1045,  1045,  1045,  1045,  1045,  1045,  1045,  1045,  1045,
    1045,  1045,  1045,  1045,  1045,  1046,  1046,  1047,  1047,  1047,
    1047,  1047,  1047,  1047,  1047,  1049,  1048,  1050,  1051,  1051,
    1051,  1051,  1052,  1052,  1052,  1052,  1053,  1053,  1054,  1055,
    1056,  1056,  1057,  1057,  1057,  1058,  1058,  1059,  1059,  1060,
    1060,  1061,  1061,  1061,  1061,  1062,  1062,  1062,  1063,  1064,
    1064,  1065,  1065,  1066,  1066,  1066,  1066,  1067,  1067,  1068,
    1069,  1070,  1071,  1071,  1072,  1073,  1073,  1074,  1074,  1074,
    1074,  1074,  1076,  1075,  1077,  1078,  1079,  1079,  1080,  1080,
    1080,  1080,  1081,  1081,  1083,  1082,  1085,  1084,  1086,  1084,
    1084,  1087,  1087,  1088,  1088,  1088,  1089,  1089,  1089,  1089,
    1090,  1090,  1091,  1091,  1091,  1091,  1091,  1091,  1092,  1092,
    1092,  1093,  1095,  1094,  1096,  1097,  1096,  1098,  1098,  1099,
    1099,  1100,  1100,  1101,  1101,  1101,  1101,  1101,  1101,  1101,
    1101,  1101,  1102,  1102,  1102,  1102,  1102,  1102,  1102,  1102,
    1102,  1102,  1103,  1103,  1104,  1104,  1105,  1106,  1106,  1107,
    1107,  1107,  1108,  1109,  1110,  1110,  1110,  1110,  1111,  1111,
    1111,  1112,  1112,  1113,  1113,  1114,  1115,  1115,  1116,  1116,
    1117,  1117,  1118,  1118,  1119,  1120,  1120,  1121,  1121,  1121,
    1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1123,
    1123,  1123,  1123,  1123,  1124,  1124,  1125,  1126,  1127,  1128,
    1128,  1129,  1130,  1131,  1131,  1132,  1133,  1133,  1134,  1135,
    1136,  1136,  1137,  1138,  1139,  1139,  1140,  1141,  1141,  1141,
    1141,  1141,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,
    1142,  1142,  1142,  1142,  1142,  1142,  1142,  1143,  1143,  1144,
    1144,  1145,  1145,  1145,  1147,  1146,  1148,  1148,  1150,  1149,
    1151,  1151,  1151,  1152,  1152,  1152,  1152,  1152,  1152,  1152,
    1152,  1152,  1153,  1153,  1154,  1154,  1154,  1154,  1154,  1154,
    1154,  1154,  1154,  1154,  1154,  1154,  1154,  1154,  1154,  1154,
    1154,  1154,  1154,  1154,  1154,  1154,  1154,  1154,  1155,  1155,
    1155,  1155,  1155,  1155,  1156,  1156,  1156,  1156,  1156,  1156,
    1156,  1157,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,
    1159,  1159,  1159,  1159,  1159,  1159,  1159,  1160,  1160,  1160,
    1160,  1160,  1160,  1161,  1161,  1161,  1161,  1161,  1161,  1161,
    1161,  1161,  1161,  1161,  1162,  1162,  1162,  1162,  1162,  1163,
    1163,  1163,  1163,  1164,  1164,  1164,  1164,  1164,  1164,  1164,
    1165,  1165,  1165,  1166,  1166,  1166,  1166,  1166,  1166,  1167,
    1167,  1168,  1169,  1169,  1170,  1170,  1171,  1172,  1173,  1174,
    1174,  1174,  1175,  1176,  1177,  1178,  1179,  1179,  1179,  1179,
    1179,  1180,  1181,  1181,  1181,  1182,  1182,  1183,  1183,  1183,
    1184,  1184,  1185,  1185,  1186,  1186,  1187,  1187,  1187,  1187,
    1187,  1188,  1188,  1188,  1188,  1188,  1188,  1188,  1188,  1188,
    1188,  1188,  1188,  1188,  1188,  1188,  1188,  1188,  1188,  1188,
    1188,  1188,  1188,  1188,  1188,  1188,  1188,  1188,  1188,  1188,
    1188,  1188,  1188,  1188,  1188,  1188,  1188,  1188,  1188,  1188,
    1188,  1188,  1188,  1188,  1188,  1188,  1188,  1188,  1188,  1188,
    1188,  1188,  1188,  1188,  1188,  1188,  1188,  1189,  1189,  1189,
    1189,  1190,  1190,  1190,  1190,  1190,  1190,  1190,  1190,  1190,
    1191,  1191,  1191,  1191,  1191,  1192,  1192,  1193,  1193,  1194,
    1194
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     5,     1,     0,     2,     0,     2,     0,
       2,     2,     3,     3,     1,     3,     3,     2,     1,     1,
       2,     2,     2,     3,     3,     5,     5,     0,     3,     5,
       5,     4,     3,     5,     3,     5,     5,     6,     1,     1,
       3,     5,     6,     4,     1,     0,     2,     0,     1,     1,
       1,     1,     1,     1,     2,     3,     3,     3,     3,     3,
       3,     3,     3,     2,     5,     2,     2,     2,     2,     3,
       3,     3,     1,     3,     1,     3,     1,     1,     2,     2,
       2,     1,     1,     1,     1,     1,     1,     1,     3,     6,
       1,     1,     1,     1,     1,     0,     1,     1,     2,     3,
       4,     3,     2,     2,     1,     3,     4,     5,     4,     2,
       4,     1,     1,     1,     1,     1,     2,     2,     2,     2,
       4,     4,     4,     4,     1,     3,     2,     3,     4,     6,
       6,     6,     5,     5,     6,     6,     4,     8,     2,     3,
       6,     4,     3,     3,     3,     3,     3,     4,     4,     3,
       3,     3,     3,     3,     3,     4,     4,     3,     2,     3,
       2,     2,     3,     3,     2,     2,     1,     3,     2,     1,
       1,     0,     2,     0,     2,     0,     3,     2,     0,     1,
       3,     3,     1,     5,     3,     4,     1,     3,     4,     6,
       4,     8,     2,     2,    10,     6,     1,     1,     1,     1,
       1,     1,     3,     2,     0,     1,     1,     3,     3,     1,
       1,     3,     3,     3,     3,     4,     2,     1,     0,     2,
       0,     3,     0,     1,     0,     1,     3,     2,     1,     1,
       1,     3,     0,     1,     3,     1,    11,    14,    10,    13,
       1,     1,     2,     2,     2,     2,     1,     0,     1,     0,
       3,     0,     1,     3,     1,     3,     1,     1,     1,     1,
       1,     3,     4,     2,     0,     3,     1,     1,     2,     2,
       1,     3,     4,     4,     2,     5,     1,     2,     2,     2,
       3,     3,     3,     0,     1,     1,     1,     1,     1,     1,
       3,     1,     5,     7,     3,     8,     4,     9,    11,    12,
       3,     0,     1,     3,     1,     2,     2,     2,     0,     1,
       3,     3,     6,     4,     0,     1,     1,     2,     2,     0,
       3,     3,     2,     1,     1,     2,     2,     4,     0,     2,
       2,     2,     0,     3,     4,     4,     0,     2,     0,     4,
       0,     3,     5,     3,     0,     1,     3,     1,     2,     3,
       0,     5,     4,     1,     0,     1,     2,     2,     1,     2,
       3,     2,     2,     2,     2,     3,     3,     1,     3,     1,
       0,     1,     2,     1,     1,     3,     6,    10,     1,     0,
       1,     2,     2,     0,     2,     2,     1,     0,     5,     7,
       1,     0,     6,     2,     0,     3,     5,     5,     8,     2,
       0,     2,     2,     2,     5,     2,     0,     2,     7,    10,
       6,     6,     6,     6,     7,     7,     9,     9,     6,     6,
       8,     8,     8,     8,     6,     6,     7,     8,     6,     6,
       7,     2,     2,     2,     2,     1,     2,     1,     0,     6,
       8,     7,     6,     4,     0,     1,     3,     4,     1,     3,
       1,     2,     2,     2,     2,     1,     1,    10,     2,     0,
       2,     2,     1,     0,     4,     6,     5,     4,     4,     8,
      11,     3,     2,     1,     3,     1,     5,     8,     1,     1,
       1,     7,     9,     8,    15,    20,     1,     1,     2,     1,
       3,     1,     1,     1,     3,     1,     3,     0,     1,     0,
       1,     1,     4,     0,     1,     3,     0,     1,     1,     1,
       1,     2,     0,     1,     2,     1,     2,     0,     2,     1,
       2,     2,     6,     8,     8,     4,     5,     4,     4,     4,
       3,     7,     8,     6,     6,     6,     6,     4,     5,     3,
       1,     3,     3,     1,     1,     1,     1,     1,     1,     3,
       3,     3,     1,     3,     3,     1,     0,     1,     3,     6,
       8,     8,    13,     1,     3,     5,     6,     4,     7,     2,
       1,     0,     2,     0,     2,     4,     0,     1,     0,     6,
       8,     8,     1,     3,     5,     5,     7,     9,     7,     9,
       5,     6,     6,     4,     1,     1,     1,     1,     2,     1,
       1,     1,     1,     1,     1,     3,     3,     3,     3,     1,
       3,     1,     2,     2,     3,     5,     2,     2,     0,     6,
       7,     7,     7,     8,     8,     6,     8,     9,     9,     7,
      10,     7,     8,     8,     8,     8,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     1,     3,     1,     1,     8,     9,     9,     9,     9,
       2,     0,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     2,     3,     4,     5,     4,     5,     3,
       4,     3,     4,     1,     2,     3,     3,     3,     3,     4,
       4,     3,     3,     4,     4,     4,     4,     1,     1,     1,
       0,     7,     7,    10,     1,     1,     2,     4,     5,     1,
       3,     2,     2,     2,     2,     1,     2,     2,     4,     3,
       2,     2,     2,     3,     2,     2,     5,     5,     5,     1,
       3,     1,     2,     3,     0,     1,     3,     2,     6,     6,
       9,     3,     0,     3,     0,     5,     2,     0,     3,     3,
       3,     7,     7,    10,     1,     1,     1,    14,     1,     0,
       1,     0,     1,     0,     2,     0,     1,     3,     5,     5,
       7,     2,     0,     1,     2,     0,     1,     1,     0,     1,
       1,     0,     9,    12,     7,     2,     0,     3,     2,     1,
       3,     3,     2,     1,     3,     3,     3,     2,     2,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     4,     5,
       1,     3,     3,     1,     2,     4,     5,     1,     1,     1,
       1,     3,     3,     2,     2,     2,     2,     1,     2,     2,
       1,     1,     1,     3,     2,     0,     2,     1,     3,     5,
       1,     2,     1,     0,     5,     7,     5,     7,     5,     7,
       3,     5,     5,     5,     1,     3,     2,     1,     2,     1,
       2,    11,    10,    10,     2,     2,     0,     9,     2,     0,
       4,     4,     4,     1,     1,     1,     0,     7,     6,     6,
       6,     6,     6,     7,     9,     9,     6,     6,     6,     6,
       6,     7,     8,     9,     8,     6,     6,     6,     5,     5,
       8,     8,     8,     8,     6,     9,     1,     0,     2,     0,
       7,     6,     6,     6,     6,     6,     7,     9,     9,     6,
       8,     8,     8,     8,     6,     6,     7,     6,     7,     6,
       6,     6,     6,     6,     7,     7,     7,     9,     9,     6,
       6,     6,     8,     8,     8,     6,    13,     1,     1,     3,
       3,     1,     1,     1,     1,     1,     1,     1,     0,     1,
       1,     1,     1,     1,     1,     0,     6,     8,     3,     2,
       0,     2,     2,     2,     2,     3,     3,     2,     2,     2,
       2,     3,     2,     5,     4,     3,     3,     3,     1,     1,
       0,     3,     2,     2,     1,     2,     1,     3,     2,     1,
       0,     8,    10,     3,     4,     4,     0,     2,     5,     2,
       0,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     4,     3,     3,     1,     0,     5,
       6,     4,     2,     0,     4,     3,     5,     6,     4,     6,
       6,     5,     7,     1,     0,     6,    11,    11,    11,    13,
       9,    11,    10,     4,     2,     5,     2,     0,     4,     5,
       5,     4,     6,     1,     3,     1,     1,     1,     1,     2,
       4,     1,     1,     1,     0,     1,     0,     1,     0,     3,
       0,     2,     4,     3,     5,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     2,     1,     1,     1,     1,     1,
       0,     5,     4,     3,     0,     1,     1,     1,     1,     4,
       8,     3,     0,     6,     1,     4,     2,     1,     3,     2,
       3,     0,     7,     2,     0,     5,     3,     0,     2,     2,
       2,     3,     1,     3,     1,     2,     1,     0,     8,     1,
       3,     1,     1,     3,     5,     2,     1,     3,     7,     1,
       1,     0,     3,     2,     2,     2,     0,     2,     2,     1,
       1,     3,     3,     1,     2,     4,     4,     2,     3,     5,
       5,     1,     1,     9,     1,     2,     4,     4,     4,     2,
       3,     1,     3,     6,     1,     0,     2,     1,     0,     3,
       3,     4,     4,     4,     4,     3,     2,     1,     1,     0,
       1,     1,     0,     1,     5,     1,     0,     1,     0,     3,
       1,     3,     4,     3,     2,     2,     1,     1,     1,     0,
       2,     4,     5,     2,     3,     1,     1,     1,     1,     3,
       0,     1,     1,     1,     1,     1,     3,     0,     2,     0,
       1,     3,     1,     0,     1,     2,     4,     4,     2,     0,
       2,     3,     2,     0,     1,     3,     1,     2,     1,     2,
       5,     6,     5,     1,     2,     1,     4,     3,     4,     5,
       4,     5,     4,     5,     2,     4,     1,     2,     2,     2,
       1,     1,     0,     4,     2,     1,     2,     2,     4,     1,
       3,     1,     2,     3,     1,     2,     0,     2,     4,     0,
       1,     0,     1,     3,     3,     2,     3,     5,     6,     2,
       3,     3,     4,     0,     1,     1,     1,     1,     1,     2,
       5,     1,     1,     1,     1,     2,     3,     3,     0,     1,
       1,     1,     1,     1,     2,     2,     2,     2,     2,     1,
       3,     0,     1,     1,     1,     1,     5,     2,     1,     1,
       1,     1,     5,     2,     2,     2,     1,     3,     3,     2,
       1,     0,     3,     0,     5,     2,     5,     2,     1,     2,
       3,     0,     1,     1,     1,     1,     1,     1,     3,     3,
       3,     3,     3,     3,     3,     0,     1,     4,     1,     3,
       3,     5,     2,     2,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     2,     2,     3,     3,     2,     3,
       5,     4,     6,     3,     5,     4,     6,     4,     6,     5,
       7,     3,     2,     4,     2,     3,     3,     4,     3,     4,
       3,     4,     5,     6,     6,     7,     6,     7,     6,     7,
       3,     4,     4,     6,     2,     3,     4,     1,     3,     2,
       2,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     2,     2,     5,     6,     6,     7,     3,     4,     1,
       1,     2,     4,     1,     1,     1,     2,     2,     2,     1,
       4,     5,     6,     8,     6,     7,     7,     5,     1,     1,
       4,     1,     4,     1,     4,     1,     4,     1,     1,     1,
       1,     1,     1,     6,     4,     4,     4,     4,     6,     5,
       5,     5,     4,     6,     4,     4,     4,     4,     5,     7,
       7,     9,     5,     4,     6,     5,     7,     7,     7,     2,
       3,     3,     3,     4,     0,     4,     1,     3,     3,     1,
       1,     1,     2,     2,     0,     2,     4,     4,     6,     2,
       0,     1,     3,     3,     2,     2,     0,     6,     1,     0,
       3,     0,     2,     2,     0,     1,     4,     2,     2,     2,
       2,     2,     4,     3,     5,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       4,     1,     4,     1,     4,     1,     2,     1,     2,     1,
       3,     1,     3,     1,     3,     1,     3,     3,     3,     2,
       1,     3,     3,     0,     1,     1,     1,     1,     1,     1,
       1,     1,     4,     3,     2,     3,     0,     3,     3,     2,
       2,     1,     0,     2,     2,     3,     2,     1,     1,     3,
       5,     1,     2,     4,     2,     0,     1,     0,     1,     2,
       2,     2,     3,     5,     1,     2,     0,     2,     1,     0,
       1,     1,     1,     3,     3,     1,     3,     3,     2,     1,
       1,     1,     3,     1,     2,     1,     3,     1,     1,     1,
       1,     1,     1,     1,     2,     1,     1,     1,     1,     1,
       2,     5,     2,     3,     6,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     2,     4,     3,     2,
       1,     1,     1,     1,     1,     0,     8,     2,     5,     3,
       2,     2,     3,     7,     1,     1,     1,     0,     2,     2,
       1,     0,     1,     3,     1,     2,     0,     2,     0,     2,
       0,     1,     3,     4,     3,     1,     1,     1,     1,     2,
       0,     2,     4,     0,     2,     2,     2,     1,     1,     7,
       3,     1,     1,     1,     1,     2,     0,     1,     3,     3,
       3,     3,     0,     4,     5,     5,     0,     1,     1,     1,
       2,     2,     1,     2,     0,     7,     0,     5,     0,     4,
       2,     2,     0,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     5,     2,     1,     3,     2,
       2,     3,     0,     5,     1,     0,     5,     2,     2,     1,
       1,     1,     2,     2,     3,     1,     2,     2,     3,     3,
       4,     2,     1,     2,     1,     1,     2,     2,     3,     1,
       1,     1,     1,     0,     1,     3,     5,     0,     2,     0,
       1,     2,     3,     2,     1,     1,     1,     0,     1,     1,
       1,     1,     1,     2,     2,     3,     0,     1,     2,     1,
       4,     3,     4,     3,     2,     1,     3,     1,     1,     1,
       1,     2,     2,     1,     2,     2,     1,     1,     1,     4,
       4,     4,     4,     4,     1,     0,     3,     3,     4,     1,
       3,     3,     4,     1,     3,     3,     1,     1,     1,     6,
       1,     3,     3,     6,     1,     3,     3,     1,     1,     2,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     4,     4,     1,
       1,     4,     4,     3,     0,     7,     1,     0,     0,     7,
       3,     4,     3,     1,     1,     1,     2,     3,     5,     2,
       5,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     1,     0,     1,     2,     1,     2,     1,     1,     1,
       2,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     3,
       1,     2,     1,     3,     1,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     3,     2,
       3,     1,     3,     3,     3,     3,     3,     3,     1,     1,
       0,     2,     2,     1,     1,     2,     1,     1,     1,     0,
       1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
    2215,     0,     2,     1,  2645,  2649,  2653,  2654,  2571,  2655,
    2656,  2621,  2622,  2623,  2624,  2625,  2626,  2627,  2628,  2629,
    2630,  2631,  2632,  2634,  2633,  2635,  2636,  2637,  2638,  2639,
    2640,  2641,  2642,  2644,  2643,  2593,  2222,  2590,  2587,  2588,
    2589,  2594,  2592,  2585,  2586,  1830,  2658,  2646,  2659,  2647,
    2648,  2650,  2651,  2620,  2652,  2660,  2661,  2662,  2657,  2665,
    2616,  2617,  2615,  2618,  2619,  2663,  2664,  2607,  2608,  2609,
    2610,  2666,  2223,  2224,  2612,  2216,  2220,  2282,  2353,  2613,
    2614,  2611,  2221,  2606,  2353,     0,  2474,  2475,  2476,     0,
    2477,  2478,  2479,  2405,  2367,  2480,     0,     0,  2481,  2482,
    2483,  2484,  2485,  2486,  2487,  2488,     0,  2489,  2490,  2491,
    2492,  2352,  2493,  2494,  2495,  2496,  2497,  2329,  2335,  2458,
       0,  2309,  2310,  2306,  2308,  2307,  2311,  2294,  1120,   521,
    1202,  1201,     0,  2119,  1120,  2075,  2076,  2120,  2077,  2078,
    2079,   245,     0,  1204,  2080,     0,  1120,  2121,   348,   916,
    2122,  2123,  2237,     0,  2081,  2082,     0,     0,     0,   521,
    1120,     0,     0,  2083,  1315,  2084,     0,  2085,  2124,  2125,
       0,  2086,  2126,  2127,  2087,  2088,  2089,  2128,  2129,  2130,
    2090,  2131,  2132,     0,     0,  1329,     0,  2091,  2133,  2092,
    2093,     0,  2134,  2094,  2095,  2096,  2135,  2136,  2137,  2097,
    2098,  2099,     0,  2100,     0,     0,     0,     0,     0,  2138,
    1120,  2101,     0,     0,  1336,     0,  2102,     0,  2139,  2103,
       0,  2104,     0,  2105,  2106,  2107,  2108,  1329,  2454,  2330,
       0,  1206,     0,  2109,  2140,     0,  2110,  2111,  2112,  2113,
    2114,  2115,  2116,  2117,  2118,     0,     0,    54,    55,    21,
      20,    26,    25,    77,    78,    44,    14,    68,    49,   110,
     109,   111,    32,    28,    62,    18,    19,    29,    33,    51,
      50,    17,    48,    72,    52,    75,    39,     8,     9,    40,
      66,    10,    41,    67,    11,    42,    12,    56,    79,    24,
      53,    76,    35,    64,    60,     7,    45,    46,    47,    69,
      70,    71,    93,    74,   105,    31,   102,    83,    84,    99,
      85,   100,     5,    86,    43,    13,    96,    95,    97,    63,
      36,    65,    94,    98,    15,    16,   101,    73,    91,    88,
     106,   104,   112,    89,    57,     3,     4,    80,    38,     6,
      23,    22,    37,    30,   108,    27,  1204,    82,    92,    81,
      87,    61,    90,   107,    59,   103,  1302,  1289,  1338,  1301,
    1314,     0,  1304,  2550,  2551,    34,  1315,   114,   115,   120,
    2219,  2271,  2272,  2273,  2353,  2304,  2305,  2298,  2314,  2324,
    2313,  2317,  2325,  2312,  2331,     0,   117,   119,   121,   124,
     118,   113,   116,   123,   128,   122,   127,   125,   126,   129,
     130,   131,  2552,  1515,  2549,    58,  2289,  2288,     0,  2353,
       0,  2498,  2499,  2500,  2501,  2502,  2503,  2553,  2554,  2555,
    2556,  2557,  2559,  2558,  2582,  1836,  1837,  1838,  1839,  1840,
    1841,  1842,  1843,  1844,  1845,  1846,  1847,  1848,  1849,  1850,
    1851,  1852,  1853,  1854,  1855,  1856,  1857,  1858,  1859,  1860,
    2525,  1861,  1862,  1863,  1864,  1865,  1866,  1867,  1868,  1869,
    1870,  1871,  2562,  1872,  1873,  1874,  1875,  1876,  1877,  1878,
    1879,  1880,  1881,  1882,  2563,  1883,  1884,  1885,  1886,  1887,
    1888,  1889,  1890,  1891,  1892,  1893,  1894,  1895,  1896,  1897,
    1898,  1899,  1900,  1901,  1902,  1903,  1904,  1905,  1906,  1907,
    1908,  1909,  1910,  1911,  1912,  1913,  1914,  1915,  1916,  1917,
    1918,  1919,  1920,  1921,  1922,  2564,  1923,  1924,  1925,  1926,
    1927,  1928,  1929,  1930,  1931,  1932,  1933,  1934,  1935,  1936,
    1937,  1938,  1939,  1940,  1941,  1942,  1943,  1944,  1945,  1946,
    1947,  1948,  1949,  1950,  1951,  1952,  1953,  1954,  1955,  2565,
    1956,  1957,  2566,  1958,  1959,  1960,  1961,  1962,  1963,  1964,
    1965,  1966,  1967,  1968,  1969,  1970,  1971,  1972,  1973,  1974,
    1975,  1976,  1977,  1978,  1979,  1980,  1981,  1982,  1985,  1983,
    1984,  1986,  1987,  1988,  1989,  1990,  1991,  1992,  1993,  1994,
    1995,  1996,  1997,  1998,  1999,  2000,  2001,  2002,  2003,  2004,
    2005,  2006,  2007,  2008,  2009,  2010,  2011,  2012,  2013,  2014,
    2015,  2016,  2567,  2017,  2018,  2019,  2020,  2021,  2022,  2023,
    2024,  2025,  2026,  2027,  2028,  2029,  2030,  2031,  2032,  2033,
    2034,  2035,  2036,  2037,  2038,  2039,  2040,  2041,  2042,  2043,
    2044,  2237,  2045,  2046,  2047,  2048,  2049,  2050,  2051,  2052,
    2053,  2054,  2055,  2056,  2057,  2058,  2059,  2060,  2061,  2062,
    2526,  2063,  2064,  2065,  2066,  2067,  2068,  2069,  2070,  2071,
    2072,  2568,  2073,  2074,  2255,  2560,  2522,  2230,  2251,  2523,
    2472,  2473,  1831,  2524,  2521,  2561,  2257,  2578,  2256,  2520,
    2404,     0,     0,  2366,  2365,  2369,  2368,  2370,  2363,  2364,
    1808,  2258,  2374,  2373,  1279,  2577,  1807,  1280,     0,  2376,
    2504,  2505,  2506,  2507,  2509,  2508,  2510,  2141,  2142,  2143,
    2144,  2145,  2146,  2147,  2148,  2149,  2150,  2151,  2152,  2535,
    2153,  2154,  2155,  2548,  2156,  2157,  2536,  2158,  2159,  2160,
    2161,  2162,  2163,  2164,  2165,  2166,  2167,  2168,  2169,  2170,
    2171,  2172,  2173,  2174,  2175,  2176,  2177,  2178,  2179,  2180,
    2181,  2537,  2538,  2182,  2183,  2184,  2185,  2186,  2187,  2188,
    2189,  2190,  2191,  2192,  2193,  2194,  2195,  2196,  2197,  2198,
    2199,  2200,  2201,  2202,  2203,  2204,  2539,  2205,  2206,  2540,
    2207,  2208,  2209,  2541,  2210,  2211,  2212,  2213,  2214,  2545,
    2546,  2547,  2534,  2327,  2511,  2533,  2544,  2542,  2543,  2337,
    2333,  2341,  2336,     0,     0,     0,     0,  2353,  1119,  1118,
    1104,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   520,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2227,     0,  1130,
     323,   322,  1203,  1184,   521,     0,  1107,   347,     0,     0,
       0,     0,     0,     0,     0,     0,   700,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   175,     0,     0,   371,
     370,     0,     0,     0,   888,   376,     0,     0,     0,     0,
     509,  2236,  2231,  2241,     0,  2234,  2235,  2520,     0,  2669,
    1983,  2267,  2268,  2667,  2030,  1281,   246,   249,   247,   248,
       0,   986,   987,   989,     0,     0,   999,   731,   732,     0,
     730,   734,     0,     0,     0,   727,     0,     0,     0,     0,
     733,   725,     0,   724,     0,     0,     0,   729,     0,   726,
       0,     0,  1108,     0,  2319,  2320,  1925,  1242,   377,     0,
       0,  1315,     0,  1204,  1211,  1221,  1216,  1218,  1217,  1219,
    1215,  1220,  1837,   830,  1851,   830,  1915,   827,   828,   830,
     830,   830,  1998,     0,     0,   802,     0,   813,  1832,   830,
    1833,  2578,   835,   431,   431,   431,     0,   834,   839,   431,
    1101,  1137,  1812,  1328,     0,  1851,  1915,   803,  1100,  2045,
    1234,     0,     0,  1003,     0,  1004,     0,  2013,  1112,   232,
    2518,  2022,  2105,  2045,  2519,   228,  2513,  2514,  2516,   202,
    2517,  2515,  2512,  1841,     0,     0,   834,     0,  1109,  1110,
     791,  1335,  1333,     0,     0,     0,  1859,     0,  1872,  1950,
     225,  2009,  2014,  2022,  2105,  2045,  2072,   184,     0,   239,
    2022,  2105,  2045,     0,  1130,     0,  1305,  1415,  1803,     0,
       0,  2328,  1103,  1102,  1205,     0,  1208,     0,  1380,  1995,
    1309,  1311,  1210,  1302,     0,     0,  2218,  1199,  1332,  1332,
       0,  1332,     0,  1294,  1302,  1297,  1301,     0,     0,     0,
       0,  1120,     0,  2296,  2324,  2303,  2359,  2300,     0,     0,
    2349,  2345,  2342,  2350,  2351,  2344,  2332,  1504,  1505,  1506,
    1503,  1516,  1502,     0,  2277,  1507,  2316,  2283,     0,  2291,
    2290,  2595,  2596,  2406,  2229,  2248,     0,     0,     0,     0,
       0,     0,     0,  2375,  2377,  2379,  2339,  2338,  2334,     0,
       0,     0,     0,  2464,  2465,  2463,     0,  2460,  2462,     0,
    2359,     0,  2529,  2523,  2532,     0,  1813,  2524,  2521,  2520,
       0,   741,     0,   135,   877,     0,     0,     0,  1807,     0,
       0,     0,     0,     0,     0,     0,  1708,  1863,  1911,  1718,
    1716,  1717,  1710,  1711,  1712,  1713,  1714,  1715,     0,   984,
    1709,     0,   135,     0,     0,     0,     0,     0,     0,     0,
       0,  1953,   135,     0,     0,     0,  1124,     0,     0,     0,
    1126,  1129,  1105,  1187,     0,  1803,     0,     0,   775,   766,
       0,   776,   767,   772,   778,     0,     0,   769,     0,     0,
     779,     0,   768,   770,   781,   771,   777,     0,     0,   773,
     774,     0,     0,  1116,   431,     0,     0,     0,     0,     0,
       0,   135,  1174,  1924,   135,     0,     0,   375,   374,   135,
     373,   372,  1863,  1911,     0,   915,   135,     0,   177,   589,
     524,     0,     0,   660,  1953,   135,     0,     0,     0,     0,
     891,     0,     0,   508,   521,     0,  2240,  2246,     0,  2238,
    2407,  2670,  2668,  2362,     0,   990,   226,   227,   988,  1924,
       0,   301,     0,     0,  1924,  1165,     0,   728,  1924,     0,
    1924,   170,  1805,  1863,  1911,  1924,     0,     0,  1924,   162,
    1924,     0,  1924,   301,  1924,   525,     0,  1924,     0,  1924,
    1953,   164,     0,  1924,   301,   739,     0,     0,  2600,  2604,
       0,  2602,  2597,  2318,  2372,  2371,  2270,     0,  2680,     0,
    1281,  1213,  2526,  1227,  1226,     0,  1222,  1230,  1225,  1315,
     830,   829,     0,   830,     0,  2689,   830,     0,   830,     0,
    2689,   830,     0,     0,     0,   830,  1834,  1835,     0,     0,
    2688,  2686,  2687,   804,   814,     0,   836,     0,     0,   843,
     842,   841,     0,     0,     0,   844,  1419,  1257,     0,   811,
       0,   809,     0,  1098,  1115,     0,     0,     0,     0,  1006,
    1006,  1006,  1111,   231,   229,     0,     0,     0,     0,     0,
       0,  1117,     0,     0,     0,     0,  2584,  1819,  1719,  2583,
       0,  2076,  2077,  2078,  1777,     0,  2525,  2079,  2080,  1631,
    1618,  1627,  1632,  1619,  1621,  1628,  2081,  2082,  1896,  2083,
    2084,  1826,  2085,  2086,  1459,  2088,  2089,  2090,  1623,  1625,
    2091,  2092,     0,  1827,  2094,  2095,  1971,  2097,  2098,  2100,
    2101,  1629,  2103,  2104,  2105,  2106,  2107,  2108,  1825,     0,
    1630,  2109,  2111,  2112,  2113,  2114,  2115,  2116,  2117,  2118,
       0,     0,  1800,     0,  1605,     0,  1451,  1452,  1474,  1475,
    1453,  1480,  1481,  1493,  1454,     0,  1799,  1518,  1604,  1609,
       0,  1603,  1599,  1318,  1795,     0,  1600,  1815,  1778,  1829,
    1828,  2578,  1786,  1818,  1816,  1817,     0,     0,     0,   195,
       0,     0,  2453,   241,     0,   242,  1801,  2022,   185,   224,
     197,   223,   198,   196,     0,  1861,   186,     0,   193,     0,
       0,     0,     0,     0,     0,     0,   235,  1106,     0,  1417,
    1416,     0,     0,  1784,  1804,   748,     0,  1197,  1198,  1196,
       0,  1193,  1195,  1207,  1204,  1791,  1790,  1792,     0,  1310,
       0,     0,     0,  1292,  1291,  1210,  1330,  1331,     0,     0,
       0,     0,     0,     0,     0,     0,  1373,  1346,  1347,  1349,
    1370,  1374,     0,  1298,     0,     0,  1421,     0,  1381,  2217,
    2359,  2360,     0,  2354,     0,  2353,  2353,  2347,  2346,  2343,
       0,     0,     0,     0,     0,     0,     0,  2274,   503,  2276,
     501,     0,     0,  2250,     0,  2254,  2252,     0,  2399,  2402,
       0,  2400,  2401,  2403,     0,  2408,  2409,     0,     0,     0,
    2591,     0,     0,  2390,  2378,  2385,  2387,  2389,  2388,  2397,
    2393,  2396,  2398,  2340,  2353,  2471,     0,  2466,  2469,     0,
    2461,     0,     0,     0,  1814,     0,     0,     0,     0,   742,
       0,     0,     0,     0,     0,     0,   134,  1163,   234,  1161,
       0,     0,     0,     0,     0,  1168,     0,   168,   169,   536,
     521,     0,     0,     0,     0,     0,   948,     0,     0,     0,
       0,     0,     0,   949,   947,   950,   957,   970,   973,     0,
     867,     0,     0,     0,  1037,     0,     0,  1037,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   251,
     254,   296,     0,     0,     0,     0,     0,     0,     0,     0,
     139,     0,     0,     0,     0,   488,   500,     0,     0,     0,
       0,     0,   497,     0,   135,   252,   482,   485,     0,     0,
     598,   597,  1037,     0,   250,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     315,   316,     0,     0,     0,   139,   161,     0,     0,   253,
       0,  2284,     0,  1125,  1122,  1123,     0,  1128,     0,  1183,
       0,     0,     0,     0,     0,   780,     0,     0,  1863,  1911,
       0,     0,     0,     0,     0,     0,   350,   329,   330,   135,
     328,     0,     0,   657,     0,  1462,  1491,  1469,  1491,  1491,
    1458,  1458,  1471,  1460,  1498,     0,  1491,  1458,  1463,     0,
    1461,  1501,  1501,  1486,     0,  1443,  1444,  1445,  1446,  1472,
    1473,  1447,  1478,  1479,  1448,  1515,  2530,  1458,  2531,  2528,
    2527,     0,     0,   667,     0,  1140,  1173,     0,     0,   530,
       0,  1924,     0,   137,   701,     0,   658,     0,   137,     0,
     173,     0,   593,     0,     0,     0,     0,     0,     0,   617,
     616,     0,     0,     0,   659,     0,   137,   484,  1924,     0,
     474,   431,     0,   890,   893,     0,     0,     0,  2244,  2239,
    2242,     0,  2232,  2246,  1284,  1286,  1285,     0,  1283,     0,
     301,   299,   300,   655,   998,     0,     0,     0,     0,   301,
       0,     0,  1924,     0,  1924,     0,     0,   301,   301,     0,
       0,     0,     0,   594,     0,   738,   736,   735,   737,     0,
       0,     0,     0,     0,  1924,   301,     0,     0,   723,  2598,
       0,     0,  2601,     0,  2321,  1729,     0,  2683,  1239,  2684,
       0,     0,  1315,     0,   213,   214,   212,  1228,   215,  1229,
    1224,  1212,     0,   822,     0,  2689,  2690,   807,     0,   817,
       0,  2689,   805,     0,   818,   815,   816,     0,     0,     0,
    2685,  2569,  2575,   821,     0,     0,   432,   434,     0,     0,
    1882,     0,  1916,  1942,  1943,  2014,  2018,     0,  2040,     0,
     845,   872,   840,     0,     0,  1267,   812,   810,  1099,  1232,
    1735,     0,  1315,     0,  1005,  1002,  1001,  1000,   230,   203,
       0,     0,     0,   874,  2013,  1114,   790,   521,     0,     0,
    1607,  1608,  1490,  1477,  1776,     0,     0,  1485,  1484,     0,
       0,     0,     0,  1467,  1466,  1465,  1606,  1743,     0,  1464,
       0,     0,     0,     0,  1491,  1491,  1489,  1538,     0,  1468,
       0,     0,  1756,     0,  1762,     0,     0,     0,  1497,     0,
    1495,     0,     0,  1574,     0,     0,     0,     0,     0,     0,
       0,     0,  1522,  1523,  1605,  1729,     0,  1822,     0,     0,
    1483,     0,  1515,  1719,     0,     0,     0,     0,  1789,     0,
    1727,     0,     0,  1552,  1725,     0,  1554,     0,     0,     0,
    1718,  1716,  1717,  1710,  1711,  1712,  1713,  1714,  1715,  1723,
    1535,     0,  1798,     0,  1534,     0,     0,  1383,  1317,     0,
    1820,  1779,     0,  2576,  2579,  1601,  2450,  2449,  2448,  2447,
    2418,     0,  2412,  2413,     0,  2451,  2452,   243,   244,   240,
       0,     0,   200,   199,     0,   221,   222,   192,   220,     0,
     216,   217,  1671,  1670,   201,   191,   189,   187,   204,   206,
     207,   190,   188,   238,   236,     0,     0,     0,  1781,  1780,
    1810,  1785,     0,     0,   301,  2353,  1191,     0,  1188,  1794,
       0,  1312,     0,     0,  1200,  1308,  1307,  1339,  1340,   908,
    1306,  1364,  1365,  1360,     0,  1379,  1379,  1356,  1350,  1355,
    1353,     0,  1357,  1518,  1372,  1296,  1344,  1345,  1348,  1295,
       0,  1375,  1373,  1349,  1254,     0,     0,  1422,     0,     0,
    2361,  2359,  2299,  1443,  2353,  2292,  2353,  2348,  2280,  1509,
    1510,  1511,  1512,  1513,  1514,  2281,     0,  2278,  1508,  2279,
     502,     0,     0,     0,  2247,     0,  2228,  2253,  2384,  2493,
    2416,     0,  2417,     0,     0,  2381,     0,  2391,  2394,  2392,
    2395,     0,  1443,  2572,  2467,  2572,  1443,     0,     0,     0,
       0,     0,     0,     0,     0,   743,     0,     0,     0,     0,
       0,     0,  2040,   233,  1159,     0,     0,     0,     0,   876,
     875,     0,     0,   895,     0,     0,     0,  1171,   421,     0,
     298,     0,     0,     0,     0,     0,     0,   534,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   568,  1037,     0,   606,     0,   955,
       0,     0,     0,     0,   956,   953,   954,  2014,   972,   971,
     969,   930,   932,   931,     0,   934,   918,     0,   919,     0,
       0,   929,   937,   935,     0,     0,     0,  1904,   256,   268,
       0,  1036,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   288,     0,   291,   290,     0,     0,     0,     0,
     295,     0,     0,     0,   294,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   985,     0,     0,   156,   159,     0,
       0,   487,   499,     0,   491,   492,   489,   493,   494,     0,
       0,     0,     0,     0,     0,   486,     0,   591,   590,   596,
       0,     0,     0,     0,     0,  1029,  1028,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   608,   609,     0,   610,     0,   160,     0,     0,     0,
       0,     0,     0,   211,  1121,  1127,  1186,  1811,  1185,     0,
       0,     0,   782,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   334,
       0,   682,  2527,   656,     0,  1443,     0,  1439,  1435,  1504,
    1503,  1502,     0,  1449,  1458,  1455,   668,     0,   670,   673,
       0,  1138,   394,     0,   527,   568,     0,     0,     0,   166,
       0,     0,     0,   133,   177,   377,     0,   176,   178,   180,
     181,   182,   179,   183,   588,   592,     0,   523,     0,     0,
       0,     0,     0,   618,   622,   621,   625,   623,     0,   619,
       0,  1431,     0,   155,   481,   483,     0,  2225,     0,   379,
     462,     0,     0,     0,   892,     0,     0,     0,     0,     0,
    2245,     0,     0,     0,     0,  1282,     0,   976,     0,  1166,
    1924,   301,     0,   974,   171,  1806,     0,     0,     0,     0,
       0,   978,   720,   163,     0,   301,   301,   526,     0,   301,
     165,     0,     0,     0,   518,   301,   740,  2599,  2605,  2603,
    1241,     0,  2681,  2682,   474,  1286,  1214,  1223,   819,   826,
     808,   825,   824,   806,   823,   820,  2383,     0,     0,  2574,
       0,   837,     0,   430,     0,     0,     0,   851,     0,     0,
     850,   865,   852,     0,   854,   847,   846,   855,     0,     0,
     874,     0,  1264,     0,  1262,     0,  1420,  1266,  1255,  1233,
       0,  1231,  1236,  1238,  1237,  1235,     0,     0,     0,   834,
       0,     0,   301,  1113,     0,   792,   797,     0,     0,     0,
     794,   795,   796,   798,   799,     0,     0,     0,  1739,     0,
    1740,     0,     0,     0,  1775,  1771,     0,     0,     0,     0,
       0,  1747,  1748,  1749,  1746,  1750,  1745,     0,     0,  1751,
    1744,     0,     0,     0,     0,     0,  1488,  1487,     0,     0,
       0,     0,     0,     0,     0,  1577,  1609,     0,     0,  1703,
       0,  1729,  1761,     0,     0,  1499,     0,     0,     0,     0,
       0,     0,     0,  1729,  1767,     0,     0,     0,     0,  1669,
       0,  1666,     0,     0,     0,     0,  1786,     0,     0,     0,
       0,  1823,  1519,  1536,  1797,     0,  1788,     0,     0,  1520,
    1543,     0,  1768,  1570,     0,  1575,  1558,     0,  1551,     0,
    1556,  1560,  1539,  1789,  1728,     0,  1726,     0,     0,  1537,
       0,  1532,  1530,  1531,  1524,  1525,  1526,  1527,  1528,  1529,
    1533,  1707,  1705,  1706,     0,     0,     0,  1555,  1918,  1950,
       0,  1329,  1329,  1329,  1316,  1327,  1796,     0,  1426,     0,
       0,     0,     0,  1686,     0,  1733,     0,  1731,  1813,  2581,
    2580,  1787,     0,     0,     0,  1802,     0,     0,  1515,     0,
     237,  1418,  1782,     0,   746,   747,   745,  1443,  1210,  1194,
    1190,  1189,  1793,  1209,  1315,     0,   906,   907,     0,   911,
       0,     0,  1358,  1371,     0,  1267,  1267,     0,  1362,  1363,
    1354,  1300,  1299,     0,  1429,     0,     0,  1251,  1244,  1423,
       0,  1383,  1269,  1271,  1272,     0,  1786,  2297,  2355,  2302,
    2323,  2293,  2326,  1517,  2275,  2315,     0,  2249,  2419,  2420,
       0,  2410,  2411,  2380,  2386,  2457,     0,  2573,     0,     0,
     680,   679,     0,     0,     0,  1059,  1008,  1041,   744,  1060,
    1009,  1042,  1061,  1010,  1160,     0,  1162,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   647,   301,  1169,  1062,   297,  1170,  1043,  1044,     0,
     535,     0,     0,   540,   541,   542,     0,     0,   543,  1863,
    1911,     0,   548,   554,   558,   549,     0,   559,   555,     0,
       0,     0,     0,     0,   565,   567,     0,     0,     0,     0,
       0,   951,   952,  1063,  1011,     0,  1045,   933,  1458,   917,
       0,     0,   928,     0,   927,  1458,  1458,  1012,   167,   257,
     394,  1039,   274,   287,   282,   283,   281,  1924,   301,  1924,
     301,     0,     0,     0,     0,   284,   279,   280,   276,   289,
    1840,  1897,  2023,     0,   578,   580,     0,   585,   292,  1020,
       0,   309,   312,   293,   272,   275,   273,   269,   255,     0,
       0,  1809,     0,     0,   980,     0,     0,     0,   158,  1025,
       0,     0,   144,     0,     0,     0,     0,   138,   148,  1069,
    1016,   490,   495,  1018,   498,  1054,   496,  1075,  1017,     0,
    1049,  1071,  1027,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1175,     0,     0,     0,     0,     0,   301,     0,
     689,  1039,  1924,   301,  1070,     0,  1034,  1057,     0,   317,
       0,  1026,  1019,  1055,     0,     0,   209,   208,   210,     0,
       0,     0,     0,     0,     0,     0,     0,   784,   755,   783,
       0,     0,     0,     0,     0,     0,     0,   749,   349,   326,
     327,     0,     0,   325,   331,   681,     0,     0,     0,  1440,
    1436,     0,     0,     0,     0,     0,     0,  1456,   669,     0,
       0,     0,     0,  1158,  1158,  1158,  1158,  1158,  1158,  1158,
    1139,  1167,   135,     0,     0,     0,   529,   567,   574,     0,
     602,   605,     0,   603,     0,     0,     0,     0,     0,   149,
     136,     0,   709,   431,   172,     0,     0,     0,   522,   666,
     664,   663,   665,     0,     0,     0,   686,     0,  1430,  1432,
       0,     0,     0,     0,   381,     0,     0,   378,   382,   386,
     387,   388,     0,   475,   477,     0,     0,   466,     0,     0,
       0,   922,     0,   940,   923,     0,     0,     0,   960,   965,
     961,   943,     0,   506,  2243,  2237,  1287,  1288,     0,   301,
       0,     0,   569,   301,     0,   301,     0,   301,   301,     0,
    1096,   595,     0,   652,     0,     0,   301,   722,  1730,     0,
       0,  2382,  2570,   838,   433,     0,     0,     0,     0,   849,
       0,   504,   853,     0,   864,   859,   861,     0,   868,  1265,
    1258,  1260,  1259,     0,     0,  1256,  1736,   721,     0,     0,
     301,     0,   869,     0,   793,     0,     0,     0,     0,  1334,
    1737,  1738,     0,     0,     0,     0,  1772,     0,     0,  1644,
    1620,  1622,  1457,  1634,     0,  1470,  1645,  1646,  1624,  1626,
       0,  1720,     0,     0,  1635,  1579,  1580,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1592,  1591,  1636,  1702,     0,     0,  1759,  1760,  1637,  1500,
    1501,  1501,     0,     0,  1766,     0,     0,     0,  1642,  1647,
       0,     0,     0,     0,  1653,     0,  1674,     0,     0,     0,
    1602,  1730,  1492,  1493,     0,     0,     0,     0,     0,     0,
       0,     0,  1576,  1559,  1553,     0,  1557,  1561,     0,     0,
       0,     0,  1545,  1571,  1541,     0,     0,  1547,     0,  1572,
    1329,  1329,  1329,  1329,  1326,     0,     0,     0,     0,  1393,
    1382,  1384,  1395,  1386,  1388,  1424,     0,  1803,     0,  1367,
    1338,  1338,     0,  1686,     0,  1610,     0,  1686,     0,     0,
    2432,  2434,  2435,  2436,  2437,  2438,  2440,  2441,  2443,  2444,
    2445,  2433,  2439,  2442,  2446,  2423,  2424,     0,  2414,  2415,
     194,     0,   218,   205,     0,  2457,  1192,     0,  1341,     0,
    1721,   911,   909,   910,  1343,     0,     0,  1378,  1377,  1376,
    1351,  1253,     0,  1251,  1246,     0,  1247,  1786,     0,  1243,
    1276,     0,     0,  1429,     0,  1275,     0,  2357,  2285,     0,
       0,  2456,  2459,  2470,  2468,  2295,  1058,  1007,  1040,  1158,
     879,   880,     0,   878,     0,     0,     0,   420,   894,     0,
       0,     0,   647,     0,     0,   649,     0,     0,   424,   643,
     645,  1172,   537,   538,     0,     0,   556,     0,     0,   545,
       0,     0,     0,     0,   544,   561,   510,   562,   564,     0,
     563,   566,   571,  1021,     0,  1056,   945,     0,  1458,   920,
     925,   926,     0,   391,     0,     0,     0,   258,     0,     0,
     271,     0,   266,   285,   277,   286,   278,   582,   583,   581,
     577,     0,   584,   586,   306,     0,     0,     0,  1065,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1066,  1046,     0,     0,   141,   140,     0,   147,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   318,   303,     0,     0,     0,     0,
       0,   320,     0,     0,  1064,  1013,   750,     0,     0,   751,
     759,     0,     0,   752,     0,     0,     0,     0,     0,     0,
     761,   352,     0,   355,   362,   335,   339,  1174,     0,  1174,
       0,   340,  1174,   336,  1174,   333,   683,     0,  1971,  1710,
    1711,   677,   684,   674,   676,   675,   678,   647,     0,     0,
       0,  1441,     0,  2671,  2679,  2678,     0,  1515,   671,   672,
       0,  1158,  1157,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   406,     0,     0,   400,     0,     0,
     965,   393,   396,   397,   530,   533,   531,   532,     0,   560,
       0,   601,     0,   574,   151,     0,     0,   152,   150,     0,
       0,   377,     0,     0,   624,   627,   620,     0,   685,   687,
     661,     0,   574,     0,  1242,   480,     0,   462,   413,   458,
       0,   473,     0,   460,   459,   461,     0,   468,  1136,     0,
     895,   921,     0,     0,     0,   958,   962,   959,     0,     0,
     936,     0,   944,   914,  1091,  1092,  1089,  1090,     0,     0,
    2260,  1278,  2269,   977,     0,   301,   975,     0,   716,     0,
     718,   979,   301,   301,   611,     0,   519,   477,     0,     0,
       0,     0,   848,   866,     0,   862,     0,     0,   831,   871,
    1263,  1261,   874,     0,   832,   873,     0,     0,     0,     0,
       0,  1741,  1476,     0,  1774,  1770,     0,  1742,     0,  1754,
    1753,  1578,  1755,     0,  1597,     0,     0,  1589,  1587,  1588,
    1581,  1582,  1583,  1584,  1585,  1586,  1590,  1764,  1763,  1757,
    1758,  1496,  1494,     0,  1639,  1640,  1641,  1765,  1648,     0,
    1854,  1675,  1652,  1668,  1667,     0,     0,     0,  1655,     0,
       0,  1664,     0,  1704,  1482,  1515,  1521,     0,     0,  1544,
    1769,  1562,     0,     0,     0,  1540,     0,     0,     0,     0,
    1549,  1720,     0,     0,     0,     0,     0,     0,  1320,  1319,
    1325,  1302,     0,  1395,     0,  1394,  1406,     0,     0,  1412,
    1410,     0,  1412,     0,  1412,     0,  1387,     0,  1389,  1406,
       0,  1804,  1425,     0,  1369,     0,     0,  1337,     0,  1686,
    1617,  1689,  1684,  1685,  1734,  1611,  1821,     0,  1732,  1686,
       0,     0,     0,  1783,  2455,  1313,     0,  1342,  1359,  1352,
       0,  1427,  1252,     0,     0,  1249,     0,     0,     0,  1270,
    1251,  1273,  2301,     0,  2356,  2421,  2422,     0,   885,   886,
     884,     0,     0,     0,   647,     0,     0,   439,     0,   902,
     902,     0,     0,   426,   471,   965,   651,   650,   648,   644,
     646,     0,   557,     0,     0,   553,   551,   550,   552,   511,
    1074,     0,   946,     0,   938,     0,   263,  1038,     0,     0,
       0,   262,     0,   301,   301,   579,   310,   311,   314,     0,
       0,     0,     0,     0,     0,   710,   693,     0,     0,   711,
     712,     0,     0,     0,   982,   983,   981,   145,   142,   143,
     146,  1022,     0,     0,     0,     0,     0,  1073,  1033,  1053,
    1072,  1031,  1051,  1030,  1050,  1032,  1052,  1024,     0,  1434,
     691,   690,     0,   301,   301,   613,     0,   753,     0,     0,
     754,   765,   763,   762,   764,   756,   353,   135,     0,   332,
       0,   360,     0,   358,   357,   359,     0,   346,     0,     0,
       0,     0,     0,   654,     0,     0,     0,  1437,     0,     0,
       0,     0,     0,     0,  1442,  1450,   642,     0,  1149,  1148,
    1147,  1151,  1150,  1153,  1152,  1144,  1143,  1156,  1155,  1142,
    1141,  1146,  1145,     0,   398,     0,   404,   408,   409,   407,
     399,   965,   431,   470,   528,     0,     0,   604,   599,   154,
     153,     0,     0,     0,     0,   629,   633,   662,     0,  1433,
     607,     0,   379,  1240,     0,  2226,     0,   384,   389,   390,
       0,   466,   410,     0,   462,   383,   476,     0,     0,   472,
       0,  1131,     0,     0,   924,   941,   942,     0,     0,   965,
     964,     0,   513,     0,  2233,   301,   570,   301,   301,  1097,
     653,     0,   858,   857,   856,   505,     0,   860,   301,     0,
       0,     0,     0,     0,   801,   785,   800,  1773,  1633,  1643,
    1752,     0,     0,  1598,     0,     0,  1638,  2110,     0,     0,
       0,     0,  1672,  1673,  1654,     0,  1962,  1659,     0,     0,
       0,  1824,  1568,  1566,  1563,     0,  1564,     0,     0,  1546,
    1542,     0,  1548,  1573,  1324,  1323,  1322,  1321,  1397,  1404,
       0,  1385,     0,  1411,  1407,     0,  1408,     0,     0,  1409,
       0,     0,  1404,     0,     0,     0,     0,  1680,  1686,  1686,
    1612,  1691,  1688,     0,  1614,  2425,     0,  2428,  2426,  2427,
    2431,  1515,     0,     0,  1245,  1248,  1250,     0,  1277,  1268,
    2358,  1164,     0,     0,     0,   422,     0,   965,     0,     0,
       0,   905,   905,     0,   965,   470,     0,   546,   547,  1023,
     939,   259,   260,   261,   264,   303,   270,   265,     0,  1067,
    1014,  1047,     0,     0,   699,     0,     0,     0,     0,  1068,
    1015,  1048,     0,     0,     0,  1180,     0,   302,   303,   319,
    1035,     0,   757,   758,   334,     0,   356,   365,     0,   363,
     337,   342,     0,   344,   343,   338,   341,  1438,     0,   996,
     996,  2672,  2673,  2674,  2675,  2676,  2677,     0,   647,  1154,
       0,     0,   395,   470,   438,     0,   401,     0,   575,     0,
       0,  1136,   379,   574,   628,     0,     0,     0,   688,   381,
       0,   478,     0,   380,     0,     0,   468,     0,     0,     0,
     466,     0,   463,     0,   467,     0,     0,     0,     0,     0,
     963,     0,   967,     0,   935,   912,  1426,     0,   517,  2259,
    2263,   997,   717,   719,   612,   863,   870,   301,   786,   787,
     788,   789,  1593,     0,     0,     0,     0,  1649,     0,  1650,
    1677,  1676,  1656,  1660,     0,  1657,  1658,  1565,  1569,  1567,
    1550,  1396,     0,     0,  1398,     0,     0,  1400,  1402,     0,
       0,     0,     0,     0,  1807,  1686,  1366,  1368,     0,  1303,
    1615,  1616,     0,  1338,  1686,  2430,  2429,   219,  1722,  1428,
    1274,   864,     0,   301,   902,   470,   440,  1971,   441,   901,
       0,   903,   908,   908,     0,   470,   647,   539,   305,   313,
       0,     0,   706,   694,     0,     0,   713,     0,     0,     0,
       0,     0,   301,   760,   324,   351,   361,     0,   345,   996,
       0,   993,   992,   641,     0,   403,   402,     0,   449,     0,
     573,     0,   574,   703,  1132,   587,   630,   631,   626,     0,
       0,   462,   458,   479,   385,   394,   368,   419,   418,   415,
     414,   416,   417,   412,   411,     0,   468,   464,   465,     0,
    1133,     0,  1182,     0,   896,   966,     0,     0,     0,   512,
       0,     0,   516,   507,     0,  2261,   833,  1594,     0,  1595,
       0,     0,     0,  1662,  1661,     0,  1405,  1414,     0,  1401,
    1399,  1390,     0,  1392,  1679,  1681,     0,     0,  1694,  1613,
     881,     0,   882,   905,   444,     0,   904,   911,   911,   431,
     647,   423,     0,   267,     0,   697,     0,   708,   706,     0,
       0,  1176,     0,  1177,  1178,  1181,   321,   364,   991,   995,
     994,     0,   435,   436,   437,     0,   405,   445,   446,     0,
     576,   600,     0,     0,     0,     0,   466,   462,   392,   457,
     366,  1134,  1135,   308,     0,   965,   968,  1095,   515,   514,
    2264,  2266,  2265,     0,  1596,  1665,  1651,  1678,  1663,  1403,
       0,  1391,     0,     0,  1690,     0,     0,     0,     0,   908,
       0,   647,     0,   899,   898,   438,   425,   304,     0,     0,
     704,   707,   695,   708,   715,   714,     0,     0,     0,     0,
       0,   447,     0,   448,   469,   702,     0,   632,     0,   468,
     466,     0,   468,   897,   913,  1094,  1093,  1315,  2262,  1413,
    1682,  1683,  2075,     0,  2050,     0,  1692,  1695,  1693,  1687,
     301,   911,     0,   427,   442,   449,     0,     0,   696,  1179,
     633,   454,     0,   453,     0,   451,   450,   692,   636,   369,
     468,   307,  1426,  1077,  1315,  1076,  1078,  1086,  1083,  1085,
    1084,  1082,     0,  1699,  1698,  1697,  1701,  1700,   883,   900,
       0,   647,   698,   705,     0,   452,   456,   455,     0,   634,
     637,   640,   638,   639,   367,   887,     0,  1087,  1081,  1302,
    1289,     0,   443,     0,   428,     0,   614,     0,  1079,  1315,
    1696,   429,     0,   635,  1080,     0,   636,     0,   615
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,   246,   247,  1687,  2549,  2437,  3209,  3210,   248,
     249,  1751,   250,   251,   252,   253,   254,   255,   256,  1700,
     257,   258,  1267,  1890,  2557,   259,  2323,  1048,  2197,  2198,
    2494,  2199,  2187,  1540,  1988,  1688,  1716,   261,   262,  1534,
    2179,   263,   264,   265,  1739,  1740,  1695,  1933,  4079,  4633,
    2424,  4732,  3060,  3061,   266,  1790,  1791,   267,   268,  3161,
    1829,  3163,  3164,  3685,   858,  2518,  4097,  4098,  3672,  3673,
    4104,  4368,  4369,   269,  1887,  3236,  3767,  3237,  4176,  3238,
    4177,  3239,  4178,  3191,  3731,  3732,  3733,  3240,  4182,  4573,
    3241,  2338,  1389,  2015,  2016,  4548,  3996,  3997,  4701,  4656,
    4657,  4658,  4765,  4184,  3247,  3777,  4189,  4396,  2971,  1909,
    2590,  3242,  3243,  4175,   270,   271,  2584,  1766,  1767,  2443,
    3691,  3302,   272,  1284,  3565,  4438,  4592,  4593,   273,   846,
     274,  1894,   275,   276,  2544,  3196,   277,  2347,  2980,   278,
     279,  3004,  3005,  3006,   280,   281,  3739,  4397,  1741,  3053,
    3054,  3055,  3056,  3602,   282,  1892,  1771,  2566,   283,   284,
     285,  2548,  3202,  3203,   286,   287,  2483,   288,   289,   290,
    1902,  2578,  2579,  4166,  4405,  4558,  4407,  4798,  4799,  4388,
    3548,  3549,  3550,   291,   292,   293,   294,  1873,  2537,  2538,
    3692,  1673,  1833,  2520,  2521,  3757,  3758,   295,   296,  4045,
    4046,   888,  4663,  4637,  4712,   297,   298,  4049,  4050,   299,
     300,   301,   302,   303,   941,  1334,  1335,  1679,   304,  2214,
     305,  1242,  3148,   306,  1424,  2716,  4225,   307,   975,  1361,
    1362,   308,   309,   986,  2699,   988,  2029,  3304,  3305,  3828,
    2670,  1171,   310,   311,  2680,  2702,   312,  1690,  2329,  2330,
    3991,   313,   889,  1914,  2593,  2966,  4583,  3998,  4321,  4512,
    2889,  3494,   314,   890,  1720,  2387,  2596,  3252,  3253,  2389,
    2854,  3789,  2391,  3254,  3259,  3260,  3261,  3785,  3793,  4432,
    4433,   315,  1718,  2380,   316,   317,   318,  1746,  1188,   319,
     911,   912,   320,  4541,   321,  1303,   322,  1006,  2045,   323,
    2402,  3588,   324,   325,   326,  4775,  4806,  4807,  4808,  3798,
    4737,   327,  4777,  1403,   329,   330,   331,   849,  1210,  1211,
    1212,   332,  4191,   333,   334,  2541,  3190,  3713,   335,   336,
    2324,  2956,   337,   338,   339,  1877,   340,   341,   342,   343,
    1809,   344,  1570,  1571,   345,   346,   853,  1066,  1574,  1582,
     347,   954,  1355,  1356,  1357,  1990,   348,  1407,  2691,   955,
    1348,   956,  2907,  3505,  3506,  3509,   957,  2904,   352,  2035,
    2685,  2688,   958,  2911,  2912,  2913,  2914,  2915,  3511,   959,
     977,  1294,  2604,   960,  1494,   357,   358,   359,  1075,  1070,
    1071,   361,  2157,  2844,   994,  1588,  1033,  1082,  3947,  2227,
    2228,  2248,  2249,  1597,  1598,  2238,  2240,  2891,  2241,  2900,
    2233,  3944,  4287,  2244,  2245,  1600,  1601,  2895,   362,  2848,
    3440,  3441,  3442,  3925,  3935,  4274,  4477,  3443,  1397,  1607,
    3444,  3449,  3503,  3227,  3228,  3229,  2392,  2528,  1855,  1495,
    1856,  2535,  1496,  2079,  1858,  1497,  1498,  1499,  1861,  1500,
    1501,  1502,  1503,  2063,  2120,  1504,  1505,  2098,  1114,  1115,
    1975,  2754,  1507,  1508,  3891,  4249,  4238,  2780,  2781,  2194,
    3887,  3392,  4489,  4614,  4615,  3955,  3952,  4291,  4493,  4697,
    4746,  4747,  1509,  2834,  2149,  1190,  1510,  3694,  2151,  2774,
    2856,  2857,  2308,  2061,  2721,  2737,  2738,  2751,  3353,  2758,
    2763,  3376,  3377,  2775,  2803,  1511,  2724,  2725,  3337,  2065,
    1512,  1563,  1564,  2165,  2798,  1577,  1578,  1068,  1513,  1514,
    2030,  1057,  4473,  1312,   696,  3070,  2209,  1214,   991,  1515,
    1516,  1517,  3306,  1628,   675,   676,  1152,   800,     2,    75,
     961,  3233,   366,   367,   892,   893,   894,  1286,  1287,  1919,
    1922,  1633,  2286,   677,   678,   705,  4204,  4439,  4595,   947,
     368,   369,   370,   371,  1629,  2282,  1116,    76,    84,    77,
    1117,   408,   409,  2264,   372,   817,   373,  1610,  1096,  3517,
     374,   375,   376,   377,   378,   944,   379,  1098,   380,  1099,
     381,   382,   383,   384,  1106,   385,  1612,  1613,  3984,  1614,
     386,   387,   698,   699,  1346,   388,   389,  1133,  1134,  1380,
    1381,  1639,  1654,  1655,  1656,   390,   692,   391,   392,   393,
    1645,  1646,   394,  2172,  2173,  2291,  2174,   395,  2928,  2929,
     396,  3475,  3476,  4298,  3477,   397,  2168,   398,   399,  1060,
    3522,   400,   813,   401,  1147,   679,   680,   681,  1154,   803,
    1019,   706,  1156,  3057,   805,   806,   683,   684,   685,  2010,
      78,  2936,  2011,  1519,   707,  1520,  2163,  1521,  1522,  1523,
    1524,  1525,  1662,   689,  1123,  1338,  1339,  2937,  1341,    82,
    1342,   405,  3706,  1978,  1382,  1996,  1997
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -4239
static const int yypact[] =
{
   -4239,   389, 10070, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, 21575, -4239,
   -4239, -4239, -4239, -4239, 95831,   297, -4239, -4239, -4239, 60459,
   -4239, -4239, -4239,   718, 65717, -4239, 69063,   789, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, 72887, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, 53277,  1206, -4239,
     685, -4239, -4239, -4239, -4239, -4239, -4239, -4239,   708, 14715,
   -4239, -4239, 69541, -4239,   243, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, 70019,   411, -4239,   553,  1179, -4239,   111,  8161,
   -4239, -4239, 61415, 66673, -4239, -4239, 73365,   415,  1497,  6352,
     708, 21094, 73843, -4239,  2515, -4239, 49889, -4239, -4239, -4239,
   66195, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, 80057,  2330,   505, 50376, -4239, -4239, -4239,
   -4239, 80057, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, 74321, -4239,   599,   877, 80535, 81013, 63327, -4239,
    1338, -4239, 80057,   827,   214, 52319, -4239, 81491, -4239, -4239,
     955, -4239, 74799, -4239, -4239, -4239, -4239,   505, -4239, 53277,
   47470,    26,   976, -4239, -4239, 81969, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239,  1785,   714, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239,   411, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239,   504, -4239,   728,   644,
    1827,   752,  1064, -4239, -4239, -4239, 14868, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, 97256,  1756, -4239, -4239, -4239,  1019,
   -4239,  1184, -4239, -4239, -4239,  1670, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239,   986, -4239, -4239, -4239, -4239,  1745, 96306,
   72887, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, 60937, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,   155, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, 72887, 72887, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, 72887,  1350,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,   484,
    1593, -4239, -4239, 53277,  2703,  2703,  1882, 97256, -4239, -4239,
   -4239, 54235, 80057, 80057, 80057,  1640, 80057, 80057,   284, 54235,
   80057, 80057,  1598, 43074, -4239, 80057, 80057, 80057, 80057, 74799,
   80057,  1562, 80057, 80057, 82447, 80057,  1762, -4239,  1996,  1500,
   -4239, -4239, -4239, 80057, 14305,  2330, -4239, -4239, 80057,  1656,
   54235, 80057,  1546, 80057,  1700, 80057, -4239, 80057, 82925,   299,
    1770, 80057,  2005, 43565,  1752, 80057, 80057, 80057, 80057, -4239,
   -4239,  1784, 80057, 80057, -4239, -4239, 83403,  1194,  2018,  1961,
      56, -4239, -4239,  2138,  1743, -4239, -4239,  2188, 72887, -4239,
   70497, -4239, -4239, -4239,  2249, -4239, -4239, -4239, -4239, -4239,
   63805,  1497, -4239, -4239, 54714, 80057,  2032, -4239, -4239, 83881,
   -4239, -4239,   531, 55193, 84359, -4239, 44056,  2141, 84837, 85315,
   -4239, -4239, 85793, -4239, 86271,  1897, 86749, -4239, 87227, -4239,
    2043, 87705, -4239, 16045, -4239,  1817,  1526,  1837,  1619, 72887,
   72887,  1311, 38727,   411, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239,   174,  1624, 50863,   769, 51350, -4239, -4239,   988,
    1254,  1335,   174,  2267,  2267,   588, 72887, -4239, -4239,  1624,
   -4239,   546,   756,  1848,  1848,  1848,  2052,   -98, -4239,  1848,
   -4239, -4239, -4239, -4239, 74799, 50863, 51350, -4239,  1876,  2330,
       1,  2264, 80057, -4239, 80057, -4239, 80057, 80057, -4239, -4239,
   -4239,  2278,  1916,  2140, -4239,  1913, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239,  2109,  2177,  2081,   137,  2330,  2080, -4239,
    2248, -4239,  2176, 26452,  1198, 72887,  2330, 51837, 75277, 93919,
     142, 63805,  2330, 88183,  2035,  1500,  2227, -4239,   429, -4239,
    2414,  2054,  2288,   581,  1500, 40655, -4239,  2073,  1506, 74799,
   97731, -4239, -4239, -4239, -4239,   183,  2353, 26948, -4239, 80057,
    2092, -4239,  2091,  2111,  2119,  1827, -4239, 80057,  1232,  1232,
    2517,  1232,  1787,  1797, -4239,  1956, -4239,  2422,  2394, 74799,
     976,   708,  2149, -4239, -4239, -4239,  2161, -4239,  2164,  2168,
   -4239,   809,  2405, -4239, -4239, -4239, -4239,  2253,  2265,  2274,
    2277,  2217,  2291,   125, -4239, -4239, -4239, -4239,  2521, -4239,
   -4239, -4239, -4239, -4239, -4239,  2625,  2609, 61415, 61415,   596,
     649,   123,   261, -4239, -4239, -4239,  2476, -4239, -4239,  2471,
   80057,  2317, 80057, -4239, -4239, -4239, 88661, -4239, -4239,  2703,
    2161,  2254, -4239,   309, -4239,  1506, -4239,   318,   398,   408,
    1468,  2251,  1569,  1891, -4239,   801,  2398,   138,   -81,  2279,
   74799,  3184,  2282,   246,  4077,   125, -4239, 80057, 80057, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,  2305, -4239,
   -4239,  2295,  1667,  1575,  6072,  1464,  4168,  1637,   758,  2497,
     876,  2601,  2050,  5534, 80057,  2327, -4239,  2553,  2660,   -28,
   -4239,   643, -4239,  2395,  2530,   952, 54235,  2360, -4239, -4239,
   80057, -4239, -4239, -4239, -4239,   542, 54235, -4239,  2544, 44547,
   -4239, 80057, -4239, -4239, -4239, -4239, -4239,  2479, 80057, -4239,
   -4239,  2596, 80057, -4239,  1848,   440,  2397,  2742, 57588,   203,
   80057,  2427,  2805,  2590,  2427,  2455, 89139, -4239, -4239,  2427,
   -4239, -4239, 80057, 80057,  2430,  2004,  2427,  2822,  2827,  2551,
    2623,  1136,   204,    79,  2740,  2427, 80057, 89617, 80057, 80057,
    2817, 54235, 80057, -4239,  2634, 75755, -4239,  2494,  2138, -4239,
   -4239, -4239, -4239, -4239,  1325, -4239, -4239, -4239, -4239,  2783,
    2254,   602,  2784,  2507,  2799, -4239,  2555, -4239,  2836,  2282,
    2844,  2554, -4239, 90095, 90573,  2845,  2305, 80057,  2847,  2554,
    2848,  2698,  2849,   602,  2850, -4239,  1144,  2851,  2741,  2853,
    1838,  2554, 64283,  2854,   106, -4239, 17370, 16045, -4239, 20231,
    1591, -4239, -4239, -4239, -4239, -4239, -4239, 30420,   677,  2649,
   -4239, -4239,   976, -4239, -4239,  2024, -4239, 49402, -4239,  1311,
    1624, -4239, 72887,  1624, 72887,   588,  1624, 72887,  1624, 72887,
     588,  1624, 72887, 72887, 72887,  1624, -4239, -4239,  2284,  1710,
   -4239, -4239, -4239, -4239, -4239, 72887,  2567, 80057, 80057, -4239,
   -4239, -4239, 67151, 80057, 67629, -4239, -4239,    20, 72887, -4239,
   72887, -4239,  2330, -4239, -4239,  1526, 57588,  2960, 80057,  2852,
    2852,  2852, -4239, -4239, -4239,  2792, 80057,  2855,  2856, 67151,
   80057, -4239, 91051, 63805,  2750,  2576, -4239, -4239, -4239, -4239,
    2036,  2391,   188,  2621, 30420,  2579,   175,   175,  2580, -4239,
   -4239, -4239,   488,  2581,  2585, -4239,   249,   249,  2745,  2586,
    2587, -4239,   342,  2591, -4239,  2762,   417,  2592,  2597,  2598,
    2071,   175, 30420, -4239,  2600,   249,  2603,  2605,  2607,  2790,
    2608, -4239,  2809,  2610,   350,   371,  2611,  2612, -4239,  2586,
   -4239,   281,  2613,  2614,  2615,  2616,  2628,  2630,  2633,  2639,
   30420, 30420, -4239, 25460, -4239,  2330, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239,    61, -4239,   510,  4920, -4239, -4239,  2769,
   30420, -4239, -4239,   575, -4239,   520, -4239, -4239,  1506, -4239,
   -4239,  1308, -4239, -4239, -4239, -4239,  2173,  2173,   172, -4239,
   69541, 69541, -4239, -4239,  1122,  2618, -4239,   215, -4239, -4239,
   -4239, -4239, -4239, -4239, 61893,  3023, -4239,   811,   643,  1149,
    2979, 48428, 48915,  2879,  2879,  2864, -4239, -4239, 80057, -4239,
   -4239, 30420, 46512, -4239,  1506,   116,  2881, -4239, -4239, -4239,
    2047, -4239, -4239, -4239,   411, -4239, 14108, -4239,  2056,  2092,
   80057, 80057,  3039, -4239, -4239,  2091, -4239, -4239,  1827,  1827,
   30420,  1827,    78,  1444, 27444, 30420,  2929,  2832,  1260,  1596,
    2931, -4239,  1787,  1797, 74799, 80057, 91529,  2759, -4239, -4239,
    2161,  2662,  1725, -4239, 59503, 96781, 96781,  2894, -4239, -4239,
    1434,    12,  2771,  2861,  2267,  1389,  1911, -4239, -4239,  2659,
   -4239,  2987, 69541,  2720, 61415, -4239, -4239, 80057, -4239, -4239,
   76233, -4239, -4239, -4239,  1986,  2666, -4239,  2683, 80057,  3157,
   -4239,  1911,  1911, -4239, -4239,  2669, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, 97256,  2674, 80057, -4239,  2675,  2679,
   -4239, 97731, 46991,  1921,  1506,  2753,  2756,  2801, 53277,  2685,
    2758,  2764,  2815,  2765,  2772, 94397, -4239, -4239, -4239, -4239,
    1516,  1278,   715,  2774,   603, -4239,  2819, -4239, -4239, -4239,
    2070, 80057,  5570,  2882,   125,  2816, -4239,  2778,  2780,  2895,
     125,   162, 94875, -4239, -4239, -4239, -4239, -4239,  1539, 23998,
   -4239,  2782,  2766, 62371,  3067,  2892,   961,  2093,   100, 80057,
    2963,  2898, 80057,  2717,  2795,  2800,  2719,  1559,  3075,  2727,
   -4239, -4239,  2897,  2785,  2786, 56630,  1302, 45038,  3061,  2811,
   -4239,  1603,  2812,  2813,   125, -4239,  3111,   125,   125,  1601,
    3118,  2818,   144,  1477,  2427,  2727,  1902, -4239,  2824,  1906,
   -4239,  2918,   132,  1693,  2727,  2825,  2829,  2719,  2719, 80057,
   80057, 80057, 80057, 80057,   121,  3132,  3139,  2830,    93,  2871,
    2755, -4239, 70975,  2833, 93919, -4239, -4239,  2835,  1767,  2727,
    1585, -4239,  1758, -4239, -4239, -4239,  1500, -4239, 80057, -4239,
   80057,  2254, 57588,  2937,  2794, -4239,  2282,   125, 80057, 80057,
    2305,    60,  1169,  2942, 80057,  2998,  2803, -4239, -4239,  2427,
   -4239, 46991,  2430, -4239,  2767, -4239,  2814, -4239,  2814,  2814,
    2770,  2770,  2773, -4239, -4239,  2071,  2814,  2770, -4239, 58546,
   -4239,  1802,  1863, -4239,  3164,  3167, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239,  1383, -4239,  2082, -4239, -4239,
   -4239, 80057, 53277, -4239,  3178, -4239, -4239, 57588,  3069, -4239,
   80057,  2970,  2781, -4239,  3103,  2834, -4239,  2837, -4239, 80057,
    1115,  2330,  2831, 80057,  2994, 80057, 80057, 80057, 80057, -4239,
   -4239,  2967,   747,     8, -4239, 70975, -4239,  1902,  2978,  3179,
     639,  1848,  3066, -4239, 80057,  2793,  3188,  3018, -4239, -4239,
    2797,  2267, -4239,  2494, -4239,  1826, -4239,  2916, -4239, 54235,
     602, -4239, -4239, -4239, -4239, 57588, 80057, 92007, 54235,   602,
   80057, 80057,  3093,  2857,  3095,  2862, 45038,   602,   128, 80057,
   80057, 80057, 80057, -4239, 80057, -4239, -4239, -4239, -4239, 80057,
   80057, 80057, 70975,  3098,  3101,   602, 80057, 80057, -4239, -4239,
   18581,  1746, -4239, 16045, -4239, 14108,  2095,  2879, -4239,  1350,
   80057,  1405,  1311, 68107, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, 72887, -4239, 72887,   588, -4239, -4239, 72887, -4239,
   72887,   588, -4239, 72887, -4239, -4239, -4239, 72887, 80057,  3309,
    2823, -4239,  1308, -4239, 80057,  2110, -4239, -4239,  2114,   548,
   80057,   622, 54235, 80057,  3010, 80057, 80057, 80057, 80057,  2901,
    2618,  1176, -4239,   321, 74799,  3017, -4239, -4239, -4239, -4239,
   -4239,  2126,  1785,   432, -4239, -4239, -4239, -4239, -4239, -4239,
   67629, 66195,  3104,    22, 80057, -4239, -4239,  1465, 30420, 25956,
   -4239, -4239, -4239,  2838, 14108,  2868, 30420, -4239, -4239, 30420,
    2267,  2267, 30420, -4239, -4239, -4239, -4239,  1363,  2267, -4239,
   30420, 30420,  2267,  2267,  2814,  2814, -4239,  5062, 30420, -4239,
   45038, 30420, 31908, 23501, 30420,  2907,  2858,  2267, -4239,  2267,
   -4239, 30420, 24964, -4239, 30420,  3034, 32900, 30420,  1149,  3035,
   30420,  1149,  3251,  3251,  1498,  5940,  2841, -4239,  2945,  2267,
   -4239,  2267,   938,   255, 57588, 30420, 53277,  2920,   114, 80057,
   30420,  2846,  1560, -4239, 30420,   956, -4239,  2869, 30420,  2922,
   30420, 30420, 30420, 30420, 30420, 30420, 30420, 30420, 30420, -4239,
   33864,   267, -4239,   759,  2170, 68585, 26452,  3124, -4239, 23004,
   -4239,   241, 72887, -4239, -4239,  1506, -4239, -4239, -4239, -4239,
   -4239,  1986,  2872, -4239,  2865, -4239, -4239, -4239, -4239, -4239,
   80057,  3023, -4239, -4239,  2924, -4239, -4239, -4239, -4239,   585,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239,  2874, -4239, -4239,
   -4239, -4239,  2874, -4239, -4239,  2879,  2870,  5119, -4239, -4239,
   -4239, -4239,  3116,  3117,   602, 97256, 80057,   183, 71453, -4239,
   26948, -4239,  2142,  2878, -4239,  3110, -4239,  2876, -4239, 10627,
    3110, -4239, -4239,   122,  3058,  3064,  3064, -4239,  2880, 14108,
   -4239,  1990, 14108,  2063, -4239, -4239, -4239, -4239, -4239, -4239,
    1438, -4239,  2929,  1596,  2936,   686, 80057, -4239, 41137,  1951,
   -4239,  2161, -4239, -4239, 22050, -4239, 22527, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239,  2885, -4239, -4239, -4239,
   -4239,   125,  2886,  3354, -4239, 61415, -4239, -4239, -4239,  3309,
   -4239,  2188, -4239,  2188,  3380, -4239, 72887, -4239, -4239, -4239,
   -4239,   971, -4239, 16045, -4239, 16045, -4239,  2891,  2145,  2968,
    2972,  3014, 80057, 80057, 80057, -4239, 53277, 80057, 80057, 80057,
   80057, 80057, 80057, -4239,  3248,   -69, 66195,  3024, 64761, -4239,
   -4239,  2909, 80057,  2953,  3141,  3142,  1191, -4239, -4239, 80057,
   -4239,  3108, 80057, 30420,  3114, 80057, 80057,  2988, 54235,  2930,
   80057, 80057, 80057,   589, 54235, 45529, 80057, 80057, 80057, 80057,
    3046, 80057, 80057,  3150,   913,   167,  1858,  2727,  3119, -4239,
    1003, 80057, 80057,  3112, -4239, -4239, -4239, 63805, -4239, -4239,
   -4239,  3106, -4239, -4239, 58546, -4239, -4239,  2204, -4239, 58067,
   55672, -4239, -4239,   798, 80057, 80057, 80057,  1193, -4239, -4239,
   57588, -4239, 80057, 80057, 80057, 71931, 92485, 92963,  1400,  1564,
   80057, 72409, -4239, 80057, -4239, -4239, 53756, 80057, 80057, 53277,
   -4239, 80057,  3120,   683, -4239, 80057,  2594,  3006, 80057, 80057,
    2934,  2208,  3011,  3056, -4239, 80057, 80057,   642, -4239, 80057,
   80057, -4239, -4239,   125, -4239, -4239, -4239, -4239, -4239, 80057,
   80057,   125, 80057,   125,  1203, -4239, 80057, -4239, -4239, -4239,
   80057, 80057, 80057, 80057, 80057, -4239, -4239,  1052,  1470,    15,
    1249,  3074, 80057,  2330, 80057, 93441, 80057, 80057, 80057, 80057,
    1056, -4239, -4239,  3050, -4239, 80057,   642, 80057, 80057,  3016,
    3020,   134,  3088, -4239, -4239, -4239, -4239, -4239, -4239,  3177,
    3340, 80057, -4239,  3181,  3182,  3003,  3004,  3187,  2088, 80057,
   80057, 80057, 80057, 80057, 80057,  3191,  2088,  3140,   652,  2962,
    2212, -4239,  2973, -4239, 30420,  3356, 57588,  2966,  2971,  3038,
   -4239,  3041,  2267, -4239,  2171, -4239, -4239,  2246, -4239,  2983,
     747,  1467, -4239, 80057,   773,    44,  3260, 37267,  3083,  3476,
    3255, 80057, 80057,  3476, -4239,  1662, 66195, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239,  3254, -4239,  2330,  2430,
    2430,  2430,  2430, -4239, -4239, -4239, -4239,  3165,  1799, -4239,
    2984, 80057,  3094,  3476, -4239,  1902,  3274,  3277, 80057, 62849,
    2078,  3383,  2330,  3166, -4239, 24481,  3825,  3170, 63805, 75755,
   -4239,  2999,  3256,  3257,  3272, -4239,  2254, -4239,  3390, -4239,
    3288,   602,  2282, -4239,  2554, -4239, 80057, 80057, 80057, 80057,
    2305, -4239, -4239,  2554,  3180,   602,   602, -4239,  3186,   602,
    2554,  3109,  3281, 63805, -4239,   106, -4239, -4239, -4239, -4239,
   -4239, 30420, -4239, -4239,  3009,  1826, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, 72887,  2188, -4239,
    2257, -4239, 80057, -4239,  3264,  3267,  3268,  2554,  3047, 80057,
    3001, -4239,  2554,   125,  2554,  2618,  2618,  2554, 76711,  3421,
    3285,    59, -4239,   705,   409,  3223, -4239, -4239, -4239, -4239,
   57588, -4239, -4239, -4239, -4239, -4239, 80057,   235,  3199,  3022,
   76711,  3398,   602, -4239, 54235, -4239, -4239,  3113, 54235,  3210,
   -4239, -4239, -4239, -4239, -4239,  3259, 80057,  2261, -4239,  1751,
   -4239,  1823, 30420, 30420,    85, -4239, 11479,  2262,  3027,  3028,
    2270, -4239, -4239, -4239, -4239, -4239, -4239,  3030,  3307, -4239,
   -4239,  3040,  2271,  2286,  3043,  3044, -4239, -4239,  2509,  3045,
   12095,  3048, 31908, 31908,   819, -4239, -4239, 31908,  3051, -4239,
    2287,  9589,  3032,  3052,  3057, -4239,  3059,  3065, 12534, 27940,
   30420, 27940, 27940, 12579,  3032,  3068,  2297, 53277,  3203, 12646,
    2300, -4239, 30420, 53277,  5512, 30420, -4239, 30420, 80057,  3072,
    3073, -4239, -4239,  5062, -4239,  3076, -4239, 31908, 31908, -4239,
    2333, 25460, -4239, -4239,  3321, -4239, -4239,  1903, -4239,  3062,
   -4239, -4239,  3554,   146, 30420,  2846, 30420,  3138, 45038,  5052,
   30420,  6754,  6603,  6603,   566,   566,   156,   156,   156,  1699,
    2170, -4239, -4239, -4239,  3070,  2608, 30420, -4239,  2388,  2393,
   80057,  5024,  8726,  9482, -4239, -4239, -4239, 35338,  3115, 30420,
   30420, 30420,  3080,  3220,  3492, 14108,   934, -4239,  3493, -4239,
   -4239, -4239,   428,  3380,  1986, -4239,  1500,  2267,   938, 49402,
   -4239, -4239, -4239, 30420, -4239, -4239, -4239, -4239,  2091, -4239,
   -4239, -4239, -4239, -4239,  1785, 30420, -4239, -4239,  1059,  2101,
   30420,  1990, -4239, -4239, 80057,  3017,  3017, 30420, -4239, -4239,
   -4239, -4239, -4239, 35338,  3123,  3134, 40173,  3216, -4239, -4239,
   80057,   421, -4239, -4239, -4239,  3105, -4239, -4239, -4239,   977,
   -4239, -4239, -4239, -4239, -4239, -4239,  3086, -4239,  3091, -4239,
    3122, -4239, -4239, -4239, -4239,   153,  3090,  3097,  3096,  1433,
   -4239, -4239, 80057, 80057, 80057, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239,  3314, -4239, 80057, 80057,  3279,
   80057,  3286,  3284, 30420,   660, 80057,  3125,  3127,  1518,  3362,
   80057,  1171,   602, -4239, -4239, 14108, -4239, -4239, -4239, 63805,
   -4239,  2254, 57588, -4239, -4239, -4239,  3145, 80057, -4239, 80057,
   80057,  2305, -4239, -4239, -4239, -4239,  1181, -4239, -4239, 80057,
   80057,   529,  3189, 80057, -4239,  1083,  2918, 80057, 80057, 80057,
    3360, -4239, -4239, -4239, -4239,  3310, -4239, -4239,  2082, -4239,
   55672, 58067, -4239, 58067, -4239,  2082,  1949, -4239,  2554, -4239,
   -4239,   891, -4239, -4239, -4239, -4239, -4239,  3411,   602,  3418,
     602, 80057, 80057, 80057, 80057, -4239, -4239, -4239, -4239, -4239,
   53277, 53277, 53277,  2329, -4239, -4239,  2330, -4239, -4239, -4239,
    2374, -4239,  1650, -4239, -4239, -4239, -4239, -4239, -4239, 80057,
    1977, -4239,   806, 57588, -4239, 57109, 80057, 80057, -4239, -4239,
    3346,  3291, -4239,  2106,  3292, 80057,  3190, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,  3206,
   -4239, -4239, -4239,  3357,  3358,  3359,  3211,  3219,  3265,  3225,
    3226,  3271, -4239,  3228,  3276,  3233,  3278,  3239,   602, 57588,
    1971,  3275,  3458,   602, -4239,  3244, -4239, -4239,  3558, -4239,
   80057, -4239, -4239, -4239, 80057, 80057, -4239, -4239, -4239,  2088,
   57588,  3409,  2088,  2088, 80057, 80057,  2088, -4239, -4239, -4239,
    3412,  3414,  3415,  3416,  3417,  3420,  2088, -4239, -4239, -4239,
   -4239,   440, 53277, -4239,  2387, -4239,  2249, 42583,  6049,  3192,
    2971,  3185,  2267, 38245,  1340,  3391,  3194, -4239, -4239, 53277,
   42583,  1831,  3408,  3212,  3212,  3212,  3212,  3212,  3212,  3212,
   -4239,  2042,  2427, 63805, 80057, 63805, -4239,    44,  3372, 80057,
   -4239, -4239,  2379, -4239, 80057, 80057,   835, 80057,  2267, -4239,
   -4239,  3266, -4239,  1848,  1115,  3332,  1432,  3528, -4239, -4239,
   -4239, -4239, -4239, 80057, 80057,   747,  2330,  3202,  3204, -4239,
   80057, 80057, 72887,  1785,  3205, 80057,  3208,  3207, -4239, -4239,
   -4239, -4239,  2389, -4239, 57588,   -42,  3385,  3389,  1785,  3287,
   80057, -4239,  2403,   140, -4239,  2330, 63805, 56151, -4239,  3102,
   -4239, -4239,   812,  3477, -4239, 80057, -4239, -4239, 39691,   602,
   57588, 80057, -4239,   602,  3269,   602,  3270,   602,   602, 80057,
   -4239, -4239, 80057, -4239, 80057, 70975,   602, -4239, 14108, 80057,
    3490, -4239, -4239, -4239, -4239,  3333,  3341,  3342, 80057,  2554,
   54235, -4239,  3227, 80057,  1211, -4239, -4239,  3401, -4239, -4239,
   -4239, -4239, -4239,  3506,  3520, -4239, -4239, -4239, 80057, 67151,
     181, 80057, -4239,  2254, -4239,  2282,   125, 80057,  3464, -4239,
   -4239, -4239,  3236,  2406, 13212, 30420, -4239,  3532, 57588, -4239,
   -4239, -4239, -4239, -4239, 30420, -4239, -4239, -4239, -4239, -4239,
   30420, -4239, 30420,  3509, -4239,  3649,  3649, 57588, 31908,  1599,
    2603, 31908, 31908, 31908, 31908, 31908, 31908, 31908, 31908, 31908,
   34360,   638, -4239, -4239, 30420, 30420,  3516,  3509, -4239, -4239,
    1648,  1648, 57588,  3238,  3032,  3247,  3250, 30420, -4239, -4239,
    2415, 33382,  3253, 53277, -4239, 30420,  9949,  2416,  3290, 13752,
    1506,  6206, -4239,  3610,  2330, 30420,  2631,  2826, 30420,  2420,
   30420,  3531, -4239, -4239, -4239,  3261, -4239, -4239, 57588, 30420,
   31908, 31908,  4236, -4239,  7112, 30420,  3273,  7710, 25460, -4239,
     505,   505,   505,   505, -4239, 80057, 80057, 80057, 34856, 77189,
    3252,  2201, -4239, 77189, 77667, -4239,  3262,  1506, 30420,  3530,
     443,   443,  3282,  3220, 41619, -4239, 30420,  1719, 28436,  3283,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239,  3263, -4239,  3298, -4239, -4239,
     643,  3289, -4239, -4239,  9511,   153, -4239,  3293, -4239,  3295,
   -4239,  2101, -4239, -4239, -4239,  6566,  3445,  2618, -4239, -4239,
   -4239,  3252, 28932,  3216, -4239,  2424, -4239, -4239, 26452, -4239,
   -4239,  2432, 41137,  3123, 26948,  1506,  2267,  3300, -4239,  2188,
     428, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,  3212,
    2554,  2554,   879,  2554,  3547,   879,  7027, -4239, -4239, 35820,
   80057, 80057,  1171, 80057,  2433, -4239,  1312,  3589, -4239,  3518,
    1070, -4239, -4239, -4239,  3665, 80057, -4239,  3327,  3329, -4239,
   80057, 80057, 80057, 80057, -4239, -4239,  2251, -4239, -4239, 80057,
   -4239, -4239, -4239, -4239,  3351, -4239, -4239,  3521,  1994, -4239,
   -4239, -4239,  3352,  2042,   592,  2719,   518, -4239,  3353, 80057,
   -4239, 80057, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, 53756, -4239, -4239, -4239, 53277, 42583, 53277, -4239,  3364,
    3369,  3419,   866,    73,  3371,  3373,  3424,  3302,  3313,  3316,
   -4239, -4239,   174,  2330, -4239, -4239,  2330,  2554,  2330, 80057,
    3577,   767,  1925, 80057, 80057, 80057, 80057, 80057, 80057, 80057,
   80057, 80057, 80057, 80057, -4239,  3672,  2330,  2330,  3646,  3384,
   80057, -4239, 80057,  2918, -4239, -4239, -4239,  3320,  2088, -4239,
   -4239,  3556,  3557, -4239,  2088,  2088,  2088,  2088,  2088,  2088,
   -4239,   512,  2437, -4239, 37750, -4239, -4239,  2805,  2330,  2805,
     524, -4239,  2805, -4239,  2805, -4239, -4239,  2973,  3295,  2267,
    1911, -4239, -4239, -4239, -4239, -4239, -4239,  1171,  2267,  2133,
    3328, -4239, 39209, -4239, -4239, -4239,  2363,   938, -4239, -4239,
   80057,  3212, -4239,  2355,  2308,  2478,  2492, 78145, 78623, 79101,
    3326, 80057, 80057, 31908, -4239,  1347,  1058, -4239,  3562, 80057,
    3363, -4239, -4239, -4239, -4239, -4239, -4239, -4239,  3330, -4239,
    2781, -4239, 80057,  3372,  2554, 80057, 80057,  2554, -4239, 57588,
    3720,  1619, 89617,  3366,  3336,  3621, -4239,  3343,  3344, -4239,
   -4239, 80057,  3372,   669,  1837,  3379, 65239,  2078, -4239,  3593,
   62849, -4239, 80057, -4239, -4239, -4239,  3700,  3430,  3388,  2330,
    2953, -4239, 55672, 30420, 30420, -4239,  3347, -4239,  3355,  3878,
   -4239,  2430, -4239, -4239, -4239, -4239, -4239, -4239,  3429, 80057,
    3766, -4239, -4239, -4239,  3361,   602, -4239, 80057, -4239, 80057,
   -4239, -4239,   602,   602, -4239,  3465, -4239, -4239,  1785, 80057,
   80057, 80057,  2554, -4239,   125, -4239,  3626, 76711, -4239, -4239,
   -4239, -4239,    22,  3632, -4239, -4239,  3592,  3595,  3596,  3598,
    2233, -4239, -4239, 30420, 14108, -4239,  3367, 14108,  7386, 14108,
    3516, -4239,  2190,  3634, -4239,  1514,  3370,  2190,   671,   671,
     327,   327,   103,   103,   103,  3649,   638, 14108, 14108, -4239,
   -4239, -4239, -4239,  3374, -4239, -4239, -4239,  3032, -4239, 30916,
    3510,  3742, -4239, -4239, -4239,  3410,  3422,  3375, -4239, 30420,
   31412,  3376, 58546, -4239, -4239,   938,   260, 31908, 31908,  2112,
   -4239,   533, 30420, 57588,  2442,  2112,  3317,  3508, 30420, 30420,
    7771,   269, 30420,  7837, 80057, 80057, 80057, 80057, -4239, -4239,
   -4239, 36784,  2201,  3381, 80057, -4239,  3392, 35338,  3601,  3550,
   -4239, 35338,  3550,  1485,  3550,  3612, -4239, 42101, -4239,  3393,
   23004,  1689, 14108,  3756,  3647, 30420,  3396, -4239,  3402,  3220,
   -4239, 95353, -4239, -4239, 14108, -4239, -4239, 30420, -4239,  3220,
     428,   464,  2330, -4239, -4239, -4239, 45038, -4239, -4239, -4239,
    3567, 14108, -4239,  1785, 80057,  1506,   577,  3425, 80057, -4239,
    3216, -4239, -4239, 16045, -4239, -4239, -4239,   174, -4239, -4239,
   -4239,  3462, 66195,  3675,  1171, 30420,  2445, -4239,  3433,  3761,
     102,  2446,  2449, -4239, -4239,  3363, -4239, -4239, -4239, -4239,
   -4239, 57588, -4239, 80057, 80057, -4239, -4239, -4239, -4239,  2685,
   -4239, 80057, -4239,  3473, -4239,  3600, -4239, -4239,  3603,   174,
   80057, -4239, 57588,   602,   602, -4239, -4239, -4239,  3427, 80057,
   80057, 80057,  2267,  2267, 57588,  3428, -4239,  2267,  2267,  3431,
   -4239, 80057, 80057, 80057, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, 80057, 80057, 80057, 80057,  3706, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, 80057, -4239,
   -4239, -4239, 57588,   602,   602, -4239,  3643, -4239,  2088,  2088,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239,  2427,  3732, -4239,
   53277, -4239, 59981, -4239, -4239, -4239,  2330, -4239,  2330,  3607,
   47949,  2330,  2330, -4239,  3423,  1757,  3692, -4239,  2236, 39209,
   39209, 39209, 39209, 39209, -4239, -4239,  3697,   174, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, 30420, -4239,   842,  2190, -4239, -4239, -4239,
   -4239,  3363,  1848,  3479,   773, 53277,  3538, -4239, -4239,  2554,
    2554,  3484,  1785,   727, 80057,  3737,  3474, -4239,  2330, -4239,
   -4239, 80057, 62849, -4239,   127, -4239,  2450, -4239, -4239, -4239,
    3471,  3389,   906,  3439,  2078, -4239, -4239,  1334, 80057, -4239,
     724, -4239,  3713,  3441, -4239, 14108, 14108,  2330, 59025,  3102,
   -4239, 80057,  3687, 80057, -4239,   602, -4239,   602,   602, -4239,
   -4239, 80057,  2554,  2554,  2554, -4239,  3619, -4239,   602, 76711,
    2233,  2233,  2233,  2233, -4239, -4239, -4239, 14108, -4239, -4239,
   -4239, 31908,  3718, -4239,  3446, 57588, -4239,  3447,  2456,  2462,
   32900,  3587, -4239, -4239, -4239,  8169,  3496, 14108,  3546,  3450,
    3453, -4239,  1020,  1020,   533,  2465, -4239, 31908, 31908,  2112,
    2112, 30420,  2112, -4239, -4239, -4239, -4239, -4239, 77189,  3456,
   80057,  2201, 35338, -4239, -4239,  1618, -4239, 35338,  3686, -4239,
   35338, 80057,  3459, 80057,  1170, 30420, 30420,  3495,  3220,  3220,
   -4239,  3624, -4239,  3463, -4239, -4239,  1911, -4239, -4239, -4239,
   -4239,   938,  3467, 72887, -4239, -4239, -4239,   976, -4239, -4239,
   -4239, -4239, 76711,  3641, 76711, -4239,  8525,  3363, 35820, 46020,
   80057, 79579, 79579,  3604,  3363,  3479,  3468, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239,  3672, -4239, -4239, 42583, -4239,
   -4239, -4239, 36302, 45038, -4239,   866,  3470,  3472,    73, -4239,
   -4239, -4239,  1452,  1164,  3507,  2554,  3752, -4239,  3672, -4239,
   -4239,  2088, -4239, -4239,  2962,  2330, -4239, -4239,  2469, -4239,
   -4239, -4239, 80057, -4239,  3336, -4239, -4239, -4239, 54235,  3867,
    3867, -4239,  1984,  1984, -4239, -4239, -4239, 80057,  1171, -4239,
    8594,  3663, -4239,  3479,  3684,  3728, -4239,  2474, -4239, 80057,
   80057,  3388, 62849,  3372, -4239,  1239,  3482,  3769, -4239,  3205,
    3486, -4239,  3810, -4239, 65239,  3659,  3430,   782,   782, 80057,
    3389,  3609, -4239,  3611, -4239,  3855,  3669,  3861, 80057, 35820,
   -4239, 58067, -4239,  2475, -4239, -4239,  3115, 80057,   865, -4239,
    3519, -4239, -4239, -4239, -4239, -4239, -4239,   181, -4239, -4239,
   -4239, -4239,   772, 31908, 57588,  2481, 30420, -4239, 30420, -4239,
    3882, -4239, -4239, -4239,   -12, -4239, -4239, -4239,  1020,  1020,
    2112, -4239, 80057,  2482, -4239, 30420,  3511, -4239, -4239, 35338,
    1618,  2489, 80057,  2490, 57588,  3220,  3032, 14108, 80057, -4239,
   -4239, -4239,  3883,  3682,  3220, -4239, -4239, -4239, -4239, -4239,
   -4239,  1211,   879,   181,  3761,  3479, -4239,  3512, -4239, -4239,
   80057, -4239,   225,   225, 80057,  3479,  1171, -4239,  3565, -4239,
   57588,  2282,    27, -4239, 57588, 57588, -4239, 80057, 80057, 80057,
   80057, 80057,   602, -4239, -4239, -4239, -4239, 59981,  3336,  3867,
     975, -4239, -4239, -4239,  3792, -4239, -4239,    64,  3693,  3597,
   -4239, 53277,  3372,  3800, -4239, -4239, -4239, -4239, -4239, 30420,
    3666,  2078,  3593, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239,  2510,  3430, -4239, -4239,  3695,
   -4239,  3696, -4239,  2513, -4239, -4239,  3878, 59025,  3829, -4239,
    3566, 80057, -4239, -4239,  2561,  3938, -4239,   772,  2522, -4239,
    2526,  2527,  3664,  3571, -4239,  2531, -4239, 14108, 80057, -4239,
   -4239, -4239,  2532, -4239,  3523, -4239,  3919, 30420,  1655, -4239,
   -4239,  3801, -4239, 79579,  3569, 45038, -4239,  2101,  2101,  1848,
    1171, -4239, 30420, -4239,  2535, -4239,  1201,  3670,  3811,  2536,
    2539,  3533,  3568,  3533, -4239,  2554, -4239, -4239, -4239, -4239,
   -4239,  3837, -4239, -4239, -4239,   527, -4239,  3716,  3719, 80057,
   -4239, -4239, 80057,  3932,  8950, 54235,  3389,  2078,  2042, -4239,
   -4239, -4239, -4239,  3578, 35820,  3102, -4239,   205, -4239, -4239,
   -4239, -4239, -4239, 80057, -4239, -4239, -4239, -4239, -4239, -4239,
    2540, -4239, 80057,  3543,  3032, 29428, 29428,  3551, 76711,   225,
    3555,  1171,  3553, -4239, -4239,  3684, -4239, 14108, 54235,  3926,
   -4239, -4239, -4239,  3670, -4239, -4239, 80057,  3677,  1320,  1320,
    3872, -4239,  3616, -4239, -4239, -4239,   866, -4239,  3563,  3430,
    3389,  2719,  3430, -4239, -4239, -4239, -4239,  1040, -4239, -4239,
   -4239, -4239, 32404,  3679,  1205, 11203, -4239, -4239, -4239, -4239,
     181,  2101, 30420, -4239, -4239,  3693,  2282, 80057, -4239, -4239,
    3474, -4239,  3972, -4239,   931, -4239, -4239,  3428, 52798, -4239,
    3430, -4239,  3115, -4239,  2155, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239,  3962, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
    9157,  1351, -4239, -4239,  3858, -4239, -4239, -4239,  2543, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239,  2011, -4239, -4239,  2016,
    2119, 29924, -4239,    32, -4239,  3721, -4239, 52798, -4239,  2155,
   -4239, -4239, 54235, -4239, -4239,  3572, 52798,  2550, -4239
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
   -4239, -4239,  3705, -4239, -1171,   311,  2280,  -592, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239, -4239,  2900,
   -4239, -4239, -4239,  1522, -4239, -4239,   -71,  1129,  2525,  1209,
   -4239, -1343, -4239, -4239,  -861,   262, -1014, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -1022,  1653,  1050,  2828, -2345, -4239,
   -1709, -4239, -4239,   477, -4239, -4239,  1604, -4239, -4239, -4239,
     924,  -278, -4239, -4239, -4239, -4239, -4239, -4239, -4239,   -10,
   -4239, -4239,  -449, -1798,  -115,   -83,  -318, -4239, -4239,   323,
    -320, -1677, -4239, -2949, -4239,   -50, -4239, -4239, -4239,  -322,
   -1653,  1133,  -966, -1364,  1439,  -603, -4239,  -218, -4239,  -652,
    -554,  -552,  -613,  -454, -3635, -4028, -4227, -2934,  1141, -4239,
   -4239, -4239,   338, -4239, -1797, -4239, -4239,  2205, -1633, -4239,
   -1084, -4239, -4239, -4239, -2919, -4239, -4239, -4239, -4239,  -104,
   -4239, -4239, -4239, -4239,   377, -4239, -4239, -4239, -4239, -4239,
   -4239, -2159,  1570,  1571, -4239, -4239, -3598, -4239, -1163, -4239,
     513, -2947,  1066, -4239, -4239, -4239,  2226, -4239, -4239, -4239,
   -4239,   379, -4239,   378, -4239, -4239, -1815, -4239, -4239, -1793,
   -4239,  1581,   897, -4239, -4239, -4239,  -627,  -692,  -682, -4239,
   -3423,   586,   593, -4239, -4239, -4239, -4239, -1208, -4239,   958,
   -3058, -1193, -4239, -4239,   978, -4239, -4239, -4239, -4239,  -583,
    -200,  2266, -4239,  -492,  -564, -4239, -4239, -4239,  -194, -4239,
   -4239, -4239, -4239, -4239, -4239, -1940,  8591, -1788, -4239, -4239,
   -4239, -4239, -1933, -4239, -4239, -4239, -1681, -4239,  3969,   -11,
      98, -1792, -4239,  -199,  -122,  2763, -1357, -2649,   329,  -343,
   -4239, -1978, -4239, -4239, -4239, -2560, -4239, -4239, -4239, -4239,
   -3406, -1784, -4239, -4239, -4239,   380, -4239, -4059, -3823, -4041,
   -3422, -3377, -4239, -4239, -1303, -4239, -4239, -4239, -1617,  1771,
   -1672, -4239, -2315,   381, -3659, -1013, -3165, -4239, -3593,  -423,
   -4239, -4239, -4239, -4239, -4239, -4239, -4239, -1291,  -862, -4239,
   -4239,  3280, -4239, -4137, -4239, -4239, -4239, -4239,  1220, -4239,
   -1573,  1053, -4239, -4239, -4239, -4239, -4239,  -561,  -642, -4239,
   -4239, -4239,   277, -4239, -4239, -4239, -4239,  1901, -1183,  -987,
    3126, -1781,  -220, -4239, -4239, -4239, -4239, -2948, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -1344, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239,  1965,  1966,  -121,  -233, -4239, -4239, -1468,
   -4239,  -824, -4239,  2200, -4239, -4239, -4239, -4239,  1301,   302,
     423,   -73, -4239, -4239,   218, -3325,   -63, -4239, -4239, -4239,
   -4239,  -258,   -62, -4239,   678, -4239, -4239, -2784, -4239,   312,
     -46,  2839,  1548,   -75,  2131,  -238,  -212,  -203,   -77,  3128,
    2622, -4239, -4239, -4239,  -207,  1612, -4239, -1073,  -356, -4239,
    1313,  -920,  1948,  2606,  2624, -4239,  1309, -4239, -4239,  1316,
   -4239, -4239, -4239,  -915,  1957, -4239,  2619,  1972, -4239,  1300,
    1310, -3297,   784, -3304,   290,  -880,  -256,  -149,  3168,  2626,
   -4239, -4238,   712, -4239, -3993, -2347,  4458, -2102, -1807, -4239,
   -4239, -1406,  9834, -4239, -4239, -4239, 10220, 13233, -4239, -4239,
   16159, 16433, -4239, -1271,   823, 16658,  9483, -1421, -1826, -1521,
   15378, -2246,  1573, -2711, -4239, -4239, -4239,  -225,   837,   420,
   -4239, -4239, -4239, -4239,  -458, -2764,  -456, -4239, -4239, -4239,
    -461, -3382, -1968, -4239,  -717, -4239, 15613,  1352, -4239, -1314,
   -2715, -2723, -1384, -1951, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -1326, -3203,  -405,  1424, -4239, -4239,  1517, -4239, -4239,
   -4239, -1528, -1147, -2634,  1429, -2109, -4239, -1086,   735,  2090,
   -1025, 10221,   319, 13190,  -117, -2358, -1518, -1730, -4239,   828,
   -4239,  1537,  5677,  -156,  1417,   145,   360, -3049, -4239, -4239,
     326, -4239, -4239, -4239,  3606,   979, -4239,  2961, -4239,  1651,
    2328, -4239, -4239,  1968,  -957,    69, -4239,  -429, -4239,  -136,
   -4239, -4239, -4239,   164, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239, -4239, -4239,  2644, -4239, -4239, -1473, -4239, -4239, -4239,
   -4239, -4239,  3886,  -313, -4239,  3319,  -307, -4239, -4239, -4239,
   -4239, -4239, -4239, -4239, -4239, -4239,  2658,  2010, -4239,  3129,
   -4239, -4239, -4239,   -47,  2867, -4239, -4239, -4239, -1180,  -597,
    3146,  3152,  1987, -4239, -4239, -4239, -4239, -4239, -4239, -4239,
   -4239,  1992, -4239, -4239,  1430, -2094,  1993, -4239, -4239,   775,
   -4239, -4239,   332, -4239,   776, -4239,  2775, -4239, -4239, -4239,
     813, -4239, -4239, -4239,  -605, 10395,   690,  1009,  1348,   216,
   -4239,  4865, 12271,    86,  2687,   -21,  7826, 13871,   525, -4239,
    3891,  1998,  1646, -1011, -4239,  4221,  2293,  9381, -4239, -1009,
      70,   501, -4239,    -2,  -656, -1170,  2975,  -757, -1928, -4239,
    4304, -4239, -3426, -4239, -1016,  3337, -1219
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2532
static const short yytable[] =
{
      81,   360,  1083,   355,  1608,   350,  1939,  1074,  1674,  1025,
     979,  1264,  1602,  1535,  1987,   351,   353,   903,  1390,  1391,
    1059,  1750,  2041,  1395,  2018,  1947,  2635,  2420,  1807,  1627,
     979,  1795,  1770,  1976,   887,   891,  2211,  1556,  2337,  2533,
    2073,  2074,  2525,   953,  2671,  2639,  2398,  2390,   987,  1295,
     703,  3320,  1131,  1832,  2100,   940,  1886,   403,  1548,  2089,
     709,  1093,  2052,   403,  1316,  1904,  1000,  1094,  2465,  2466,
    2399,  3072,    79,  1056,  3022,  3024,   404,  2862,  2496,  2534,
    1875,  3583,   404,  1879,  3570,   847,  1026,   360,  1883,  3455,
    2582,  1742,  2558,  2559,  3792,  1888,   851,  2560,  2561,  2271,
    2273,  2274,  2388,  3597,  1906,  3599,  2562,  1930,  2720,  2563,
     905,  2882,  1135,  1077,  3967,   404,  1189,  2224,  3695,  4003,
    3308,  1657,  3709,  1659,  2756,  3118,  3510,  1351,  3452,  3993,
    4199,  3695,  4181,  2455,  3450,  3451,  3445,  4153,  2756,  3936,
    3938,  3922,  2265,  2265,  1047,  4158,  2211,  2631,  1085,  1689,
     897,  2002,  3400,  4416,  2407,   976,  1189,  1086,  1717,   404,
    2315,  2919,  1596,   697,  4170,  2067,  2068,  1599,  1977,  1972,
    1635,  1636,  1765,  3869,  1774,   976,  1126,  4322,  3972,  2116,
    1542,  1799,  2170,  3521,  2594,  2837,  1340,  1903,  1796,  4566,
    2086,  3357,  3445,  3212,   424,   424,  2118,   424,  4588,  2461,
    2935,   697,  2408,   804,  2939,  1022,    43,  2477,    45,  1189,
    1148,    45,  2580,  1022,  4008,  1022,  -135,    37,    38,    39,
      40,   895,   902,   363,    44,  -135,  2796,   404,  1405,   363,
    -135,   902,   857,  1697,  1931,  2472,  3714,  3715,  3716,  3717,
    3718,  3719,  1290,  4542,  2124,  4320,   424,   804,   407,  4636,
   -1491, -1491, -1491, -1491,  1064,  2701,  1931, -1491,  2796,  3275,
      45,  3277,   363, -1491, -1491, -1491, -1491,  2033,  3309,  2127,
   -1491,   902,  2212,  1989,  4113,  1648,  4118,  2401,  1826,  3773,
    3000,  4513,  3515,  3136,  3335,  1281,   130,   131,  4481,   360,
    4483,   355,  4652,   350,  4603,  1804,  2791,  2231,  1649,  2129,
    4411,  1899,  4047,   351,   353,  4735,   363,  2272,  2957,  1931,
   -1491,   410,  2401,  1031,  -741,   804, -1814, -1814, -1814, -1814,
    3783,  1900,  1539, -1814, -1458, -1458, -1458, -1458,  2508,  1393,
    1544, -1458,  1979,   424,  2886,  1698,    37,    38,    39,    40,
     260,  1697,    43,    44,  1426,  1650,  2375,    45,  2124,  4670,
    3001,  2181,  1017,   403, -1708,   328, -1486, -1486, -1486, -1486,
    1017, -1708,  1017, -1486,  1420,  1807,  2831,  1820, -1724, -1960,
    4584,  2161,   404,  2832,   363, -1724,  2988,   945,  2958,  1528,
     349,  3113,  2509,  2232, -2530, -2530, -2530, -2530,   403,     3,
     354, -2530,  4576, -2531, -2531, -2531, -2531,  4048,  1111, -2530,
   -2531,  4653,  4648,  2129,   365,  1394,  1032,   404, -2531,  1567,
    3114,  1568,  4325,  2887,  2681,  3357, -1486, -1471, -1471, -1471,
   -1471,  1678,   848,  3170, -1471, -1501, -1501, -1501, -1501,  2376,
    1871,  2100, -1501,  4412,  2073,  2074,  3460,  1282,   364,  3461,
    3462,  2089,  1805,  1698,   364,  1061, -1501, -1501, -1501, -1501,
    3463,  3464,  3465, -1501,  3466,  3467,  3310,  1169,  2419,  3468,
    3469,  3470,  3318,  2188,  4654,  1901,  4736,  2200,  2200,  2409,
    4604,  1965,  1255, -2528, -2528, -2528, -2528,   364,  1932,  1122,
   -2528,  2410,  4821, -2527, -2527, -2527, -2527,  2213, -2528,  4612,
   -2527,  1283, -1498, -1498, -1498, -1498,  3003,  2158, -2527, -1498,
    1932,  1406,  4769,    80,  1150,  4772,  3355,  3356,  2581,  1136,
    1094,  3371,  1189,  2503,   906,    37,    38,    39,    40,   363,
    2478,   364,    44,  2034,   891,  1941,  1065,  1745,  2797,  2507,
    2682,  2411,  1638,  1641,  4805,  1991,   424,  2203,  2204,    37,
      38,    39,    40,  4804,  1670,    43,    44,  2723,  4037,  4420,
      45,  3406,  3407,  1932,   363,  1129,  1130,  3695,  4393,  2460,
    3420,  2119,  2056, -2123, -2123, -2123, -2123,  2067,  2068, -1960,
   -2123,  4315,  3137,  1120,  2473,  2086,  1644,  2525, -2123,  1872,
    1971,  3987,  4699,  3157,  1699,    37,    38,    39,    40,   364,
     688,  2451,    44,  2453,  3007,    37,    38,    39,    40,  3369,
    1561,  3471,    44,  1127,  1562,  3026,  4435,  3538,  2459,  1967,
    1686,   245,  1721,   973,   974,  4733,   973,  1626,  2499,  2034,
    2369,  2124,  2890,  2495,  2523,  2171,  2374,  3784,   260, -1960,
    4271,  1941,  2062,  2211,  4275,  -135,  -135,  2861,  4729,   897,
    1394,  1569,   808,   328, -1960,  2062,  2127,  4230,  2847,  1128,
    2660,  3173,  2148,   896,  2124,  4309,  1550, -1708,  2519,   913,
      37,    38,    39,    40, -1290,   973,   974,    44,   349,  2833,
    2441, -1724,   818,  2444,  2445, -1491,  2129,  2287,   354,  2127,
    2367,  4623,  2252,  2183,  3827,   992,   808,  2253, -1491,  3950,
    1196,  4027,   365,  4382,  4383,  4384,  4385,  4386,  2343,  -354,
    2683,  1170,  4770,  1872,  1306,  2379,  3580,  1163,  3581,  2129,
     895,   819,  4718,    35,  1074,  1814,  1256,  3021,  2684,  3029,
    1359,    41,    42,   814,  4505,   815,  3357,  3445,  3472,  1603,
    1931,  4515,  1021,  2504,   364,  3958, -1290,  2438,  1394,  1561,
    1021, -1814,  1021,  1562,  2717,  2719,  1137,   690,  1251,  2072,
    1241,  1135,  1651,  1652,   808,  2727,  1428,   907,  2730,  3357,
     902,   902,  2986,  4127,  1292,  3567,  2742,  2743,   402,   364,
    3479,  1080,  2340,  3473,   402,  3485,  2650,  1122,  2664,  2760,
    2762, -1486,  2653,  2343,  2756,  2756,  3661,  3662,  3313,  2756,
    2776,  2921,  3008,  2921,  3080,  2668,   403,  2331,  2948,  2643,
    1972, -2532,  1305,   708, -1293,  4555,  1360,   402,  1366, -2530,
    1371,   404, -2258,  2746,  2747,   404,  1375,  2095, -2531,  1159,
    3366,  3367,  3368,  3369,  3065,  1206,  4028,  1159,  3999,  2756,
    2756,  1354,  4109,  1349,  1617,   908,  2096,   909,  2095,  1366,
    1371,  2155,  2078,  1378,  3081,  1396,  3571,  1378,  1827,  1828,
    2097,   402,  3693,  4425,  1378,  3314,  1551,  2096,  1159,  2696,
    3357,  4426,  1637,  1085,  3474,  3693,  2905,  2333,  2339,   852,
    3201,  2099,  1086,  3975,   360,   854, -1293, -1290,  4110,  3159,
    4202,  4567,    35,   424,  2334,  2434,    37,    38,    39,    40,
      41,    42,    43,    44,  3082,  2340,  1691,    45, -2528,  1139,
    4025,  3612,  1293,  1350,  1428, -1458,  3359,  3357, -2527,  1779,
    1396,  2344,  1159,  1207,  3311,  1640,  1552, -1498,  1365,   402,
    1370,  1159,   993,  2390,  3512,  4029,  4666,  4675,  4030,  4568,
    1384,  1416,  2574,  1001,  1078,  1941,  4569,  1087,  2665,  3359,
    1606,    81,  3790,  1378,  1572,  2591,  3945,  1780,  1307,  1399,
    1401,  1208,  2455,  1364,  4661,  1369,  4296,  2588,   363,  1815,
    4096,  2642,   363,  4570,  4471,  4544,  2666,  1122,  1538,   902,
   -1290,  1784,  1546,  4719,  1932,  4474,   691,  1785, -1458,  3720,
    4478,  3568,  3083,  4480,  1398,  1400,  2345,  4171, -2123,  4063,
    1532,  2185,  1079,   816, -2258,  3360,   967,  3794,  1692,  1209,
    3193,  2675,  2676,  3613,  3066, -1290,  2987,  2575, -1290,  2335,
    2121,  4427,  1088,    79,  2669,  1345,   968, -1293,  2419,   902,
    2159,  1702,  3723,  2341,  2143,  2144,  2145,  2146,  2147,  2148,
    1189,  1159,  4730,  4571,  3792, -1912,  1379,  1022,  3571,  1566,
   -2532,  1022,  3482,   424,  1379,  2588,    37,    38,    39,    40,
   -2258,  1002,    43,    44,  1426,  1650,  1080,    45,   404,  2145,
    2146,  2147,  2148,  1367,   402,  1159,  3358,  1372,  1373,  1374,
    3745,  1618,  3795,  1786,   214,  2813,  1844,  1385,  2156,  3160,
    2156,  3084,  4734,  1416,  2620,  2867,  4649,  3359,  3584,  3085,
    4627,  4628,  3086,  4631,  1781,  4042,  4621,  1379,  2186,   402,
    1030,  2336,  3312,   222,  1122,  1428,   697,  1386,  3357,  3988,
   -1293,  4796,  3852,  2529,  4417,  3857,  3858,  3859,  3860,  3861,
    3862,  3863,  3864,  3865,  3866,  1132,   801,  1003,  3177,  3364,
    3365,  3366,  3367,  3368,  3369,  4064,  1693,   818,  2835,  2589,
     232,  3614,   896,  3360,  1176, -1293,  1806,  3103, -1293,  3000,
    4391,  3128,   235,  3104,  4418,  3727,  3194,  1785,  2646, -2532,
   -2532,  1107,  3364,  3365,  3366,  3367,  3368,  3369,  1081,  4172,
     801,  4590,  3615,   364,  3906,  3907,   819,   364,  1108,  1782,
    1917,  2576,  4609,  1630,  1017,  4290,  2906,  3011,  1017,  2870,
    4043,  3728,  4572,  2577,  4308,  4294,  1694,  2924,  1089,  2814,
    3796,  3616,  1660,  2815,  3729,   363,  3656,  4706,  4398,  3659,
    3660,  1787,  3746,  3663,  1159,   967,  3445, -1912,  1076,  3001,
    3445,  4650,  3958,  3670,  1159,  4284,  1108,  4402,  2749,  1189,
    3578,   809,  3195,  1109,  4293,   968,  2530,  3026,   801,  2816,
    4149,   810,  1788,  1311,  4797,  1630,  1870,  1319,  3002,  3105,
    4703,  4704,  3545,  1786, -1944,  1074,  1387,  1331,  3797,  2836,
    3112,  3585,  1080,  3364,  3365,  3366,  3367,  3368,  3369,  3989,
    3012,  1789,  4218, -1912, -1811,  2555,  4044,  4751,  4753,  1159,
    4519,  1109,   360,  3730,  1110, -1458,  3586,  1895,  3359,  3695,
    1657,  3693,  1659,  1004,  1005,  1955, -1458,  3990,  2072, -1458,
    1678, -1458,   973,  1626,  2192,  2177,  3361,  3362,  3363,  3273,
    3364,  3365,  3366,  3367,  3368,  3369,  1993,  4591,  1995,  3000,
    2510,  1999,  3823,  2001,  1111,  1896,  2004,  2005,  2006,  3278,
    2162,  1586,  3560,  1956,    81,    81,  1015,    81,   808,  2013,
     811,  2218,  2404,  2193,  3360,  1159,  1053,  2556,  2390,  4773,
     191,  2302,  2036,  3545,  2037,  2817,  1243,  1094,  2511,  3091,
    4782,  3219,  3220,  3221,  3222,  3003,  2178,  3094,  4814,  3096,
    3561,  4150,  1111,  1189,  4789,  2446,  2225,  2226,  3547,  2230,
     424,  3841,  1135,  3489,  1054,  1086,  1086,  3106,  1086,  3001,
    2756,  4516,  2405,  2756,  2756,  2756,  2756,  2756,  2756,  2756,
    2756,  2756,  2756,  3579,  1870,  3981,    79,    79,  3333,    79,
    3486,  1297,   913,  3269,  4169,  2331,  2558,  2559,  3107,  2531,
     364,  2560,  2561,  2756,  1587,  3546,  4784,  1630,   214,  4820,
    2562,  2332,  1159,  2563,    35,  3457, -1944,  3458,    37,    38,
      39,    40,    41,    42,    80,    44,  1924,  3108,  4761,  4207,
    1561,  4208,  2756,  2756,  1562,  1606,  3384,   222,  1992,  4546,
    1159,  1994,  1651,  1652,  1998,   802,  2000,  1112,   812,  2003,
    3815,   948,  1897,  2007,  1345,  3173,  1067,  4146,  1592,  3547,
    1957,   967,  3516,  2175,  2176,  2333,  1113,  3409,  1159,  1159,
     949,  1159, -1944,  2991,   232,  4006,  1925,  2447,  1080,  2448,
    1404,   968,  2334,   402,  2152,  2512,   235,   402,  1159,   802,
    3792,  3364,  3365,  3366,  3367,  3368,  3369,  3562,  4589,  4421,
   -1961,   950,  2116,  1097,  4490,  4491,  1924,   855,  1421,  4709,
    4147,  4422,  4528,  3545,   799,  3003,  3774,  1529,  2731,    74,
    4774,  1541,  1297,  1543,  1594,  2191,  1179,  1180,  1181,  4785,
    1182,  1183,  1184,  1185,  1186,  1187,  4007,  1898,  2529,  1159,
     404,  3445,   967,  2704,  1021,  1958,  3445,  1090,  1021,  3445,
    4447,  4624,    37,    38,    39,    40,  2645,   802,   799,    44,
    2269,  4630,   968,  1276,  1926,  2284,  4710,  -572,  1159,  3301,
    2513,  4148,  1159,  1159,   403,   403,  2363,  1344,   424,   697,
     697, -1986,  3563,  2732,  4660,  3546,  3544,  3999,   818,  2268,
    2705,  1277,   404,   404,   404,  3115,  4668,  1630,  4556,  3182,
    3177,  1630,  1630,  1108,  1016,  1526,  4762,  2335,   688,   688,
    4529,  1927,  1016,  1661,  1016,  2270,  1948,  2432,  1189,  2969,
    2933,  2965,  2679,   403,  3116,  4557,   799,   819,  2210,  1151,
    2306,  4252,  4253,  2271,  1278,  4327,  4328,  1172,  2733,  4813,
    2706,  2734,   404,  4501,  1926,  4503,  1703,  1941,  3183,   404,
    1870,  4485,  4679,  3458,  2269,  1100,   404,  3826,  1109,  1941,
    4423,  2530,  1206,  1022,  2277,  1527,  1027,  2278,  1246,  2707,
   -2322,  2970,  4763,  -895,  2708,  1101,  2280,  2433,  1704,   214,
    3559,   697, -1961,   978, -1302,  1102,  4232,   363,  4233,  1928,
    1022,  1927,  2031,  3929,  3827,  4764, -1302,  1870,  3999,  2336,
   -1302,  2298,  2300,   978,  1648,  4087,  1111,  2043,   222,  2270,
    4619,  4090,  4091,  4092,  4093,  4094,  4095,  3263,  2325,  2053,
    2709,  3930,  1300,  1870,  3184,  3185,  1830,  1649,  2326,  2735,
     402,  1309,  2804,  1705,  2805,  2756,  4277,  3186, -1961,   363,
     363,   363, -1302,  2327,  2210,   232,  3932,   818,  3445,  1111,
    1207,   910,  3286,  2446,  1630,  2279,  2806,   235,  4019,  3928,
    1630,  3041, -1302, -1986,  1706,  2200,     8,  2124,  3553,  1928,
    1733,  3853,  1022,  3854,    37,    38,    39,    40,  1132,  1768,
    2234,    44,  3187,  1675,  1103,  3109,   819,   122,  1208,   363,
    1870,   245,  2127,  4004,  1592,   864,   363,   834, -1302,  2609,
    1111,  1276,   801,   363,  1630,   126, -1302,  1630,  1630,  2522,
    1017,  3042,  4234,  1297,  1676,  2235,  3110,    80,    80, -1986,
      80,  2235,  2129,  3572,  2736,  3087,  3929,  1870,  2710,  3752,
     870,   967,  2698,  2413,  2711,  1138,  1209,  1017,  1297,  3754,
    2452,  3934,  1354,  1677,  2531,  3111,  1104,  4297,  2807,  3497,
     404,   968,  2861,  2808,  3930,  1870,  4026,  4031,  2809,  3480,
    1594,  4125,  2712,  2532,  2236,  2686,  3188,  1630,  3189,  3931,
    2236,  2328,  1278,   870,  3087,  2447,  2421,  2448,  1149,  3932,
    2222,  2713,  2877,  2038,  1680,   360,   872,  3855,  1094,   207,
    1752,  2378,  -889,  1709,  1748,  1175,  1595,  3856,  4527,  1710,
    2489,  3933,   364,  1769,  1297,  2714,  1711,  1159,  2697,  2756,
    2756,  3173,  1105,  1870,  1794,  1681,  1159,  3525, -1302,  1017,
    4475,  1753,  1713,  2422,  2423,  3043,  2648,  1198,  2649,   872,
    1714,  2490,  2651,  2715,  2652,  1941,  3426,  2654,  2539,  3871,
    3872,  2655,  3833,  3999,  1682,   360,  2969,  2695,    81,  2692,
    1872,    81,  1775,   207,   364,   364,   364,  2419,  2421,  2693,
    2694,    37,    38,    39,    40,  4452,  4378,  2861,    44,  3215,
    4518,  1164,    43,  2810,  3934,  3044,  2117,    45,  1794,  1583,
    1715,  3291,  2811,  1776,  1561,  1592,  2122,  1777,  1562,  1593,
    4695,  4468,  4469,  4532,  4379, -1337,  2160,   363,  3541, -1337,
    1159,  3734,  3837,  3693,   364,  2422,  2423,  3850,  1754,   820,
    1205,   364,  1778,  1749,  3904,  4696,  1204,  -157,   364,   879,
      79,   880,  4553,    79,  1811,  1297,  1248,   856,  2190,  4750,
    3454,  3870,  1297,  1297,  1816,  4310,  1159,  1159,   424,  2419,
    1962,   942,  -157,   885,  1159,  3201,  4476,  1159,  3646,  4251,
    1159,  1594,    45,  3877,  1755,  2740,  2462,  2892,  1159,  1159,
    1963, -1337,   879,  1245,   880,  4250,  1159,   808,  3647,  1159,
    1159,  1159,  1159,   882,  1973,  3411,  1572,  3412,  1974,  1159,
    1159,  1189,  1159,   884,  1159,  1159,   885,  1595,  1159,  1915,
    2390,  1028,  2421,  4179,  2491,  2095,  4585, -1337,  3552,  3413,
    1265,  3224,  1870,  1159,   404,  2492,  3225,  2959,  1159,  2962,
    3836,  1250,  1159,  1686,  2096,   688,  1159,  3606,  1159,  1159,
    1159,  1159,  1159,  1159,  1159,  1159,  1159,  4065,  1159,  2493,
    2488,  1756,  3607,  3710,  1159,  4362,  4363,  1159,  3225,  2422,
    2423,   802,  1078,    37,    38,    39,    40,  4066,  2348,  1271,
      44,  3490,  3177,   214, -1338,  1279,  4001,  4002, -1338,  3720,
    2908,    37,    38,    39,    40,  3721,  2421,  1561,    44, -1814,
    1257,  1562,  1258,  2419,   403,  3722,  1757,  2123,  1758,  2553,
    2124,  2349,   222,   808,  2953,  2084,  2085,  4597,  2454,   356,
    1021,  1280,  2794,   404,  2350,   214,  3414,  2583,  1159,  2457,
    1079,  3415,  3723,  1285,  3724,  2127,  1683,  2351,  2261,  2262,
     799,  2128,   364,  2422,  2423,   870,  1760,  1021,  2401,   232,
   -1338,  3009,  3838,   403,   222,   403,  2406,  3750,  1288,  1973,
    3330,   235,   402,  2638,  2641,  2129,  2309,  1684,  2124,  2614,
     424,   207,   404,  2756,   404,  2352,  1317,  2419,  2623,  2095,
    2458,   363,  2756,  1762,  1302,  1428, -1338,  2421,  3357,   859,
    2630,   232,  1326,  2127,  1080,   245,  1685,  2310,  2096,  2756,
    2756,   872,  2602,  2603,  2353,   356,  3725,  1807,  2008,  2354,
    3941,    81,  2097,    81,   402,   402,   402,  1764,    37,    38,
      39,    40,  3609,  2129,   404,    44,  2311,  1332,  3078,  1021,
      35,  2009,  3331,   943,  2422,  2423,  3332,   245,    41,    42,
    2095,  4103,  3735,  4106,  3737,  4108,  3416,  1347,  4111,  2667,
    4112,  1159,  2672,  3610,  2674,  3417,  1159,  2677,  1388,  2096,
    3726,  1630,  1159,    45,   402,  3727,   424,  1686,  2419,  2131,
     363,   402,  3928,  2099,  3383,  1122,  3385,  3386,   402,  2898,
    2899,  1660,  3611,    79,  1392,    79,  1073,  3946,  3948,  1402,
    2132,  2133,  1870,    37,    38,    39,    40,  1870,  1870,  1408,
      44,  3728,  2564,  1413,  2355,  3787,  1081,   808,  1870,  1414,
    4539,  3147,  2210,  1419,  3729,    37,    38,    39,    40,   363,
    1415,   363,    44,  2211,   404,  1416,  1793,   404,  2123,  3624,
     207,  2124,   834,  2136,   879,  1260,   880,  1261,  4533,  3929,
      37,    38,    39,    40,  1417,  3088,  2137,    44,  2132,  2133,
    3216,    45, -1361, -1361,  3582,  1794,  2127,  2861,   885,  2072,
    3490,  2316,  2128,  2356,  2261,  2917,  1016,  3930,  3359,  2357,
    1016,   363,  2358,  3490,  -377,   191, -1462, -1462, -1462, -1462,
    1423,    80,  3931, -1462,    80,  4497,  2129,  4121,  4122,  4123,
      74,  2136,  3932,  3730,  3088,  2756,   364,  2359,  4131,  4023,
    4085,  1084,  2166,  2360,  2072,  2167,  2316,   356,  1425,   978,
    3459,   978,  1418,   978,  3933,  3062,  2361,  1422,  3675,   978,
    1376,  1377,  4818,  1630,  3360,  4819,  1686,  1583,  1547,  4255,
   -1290,  1630,  1159,  1630,  1870,  1982,  4431,  1983,  2782,  1553,
    2362,  2785,   978,   978,  2059,  4128,   245,  1554,  3408,  4448,
    4449,  4450,  4451,   214,  3245,  3246,  4224,  3088,  2216,  3676,
    2217,  3088,  1549,    37,    38,    39,    40,  2219,  1555,  2220,
      44,   363,   402,  1074,   363,  4239,  1560,    37,    38,    39,
      40,   801,   222,  3677,    44,   364, -2532,  3934,  2739,  1573,
    2131,  3088,  2072,  4200,  1678,  3492,  3493,  4641,  3678,  4643,
    4105,  1581,  3679,  1870,  2123,  1580,  2640,  2124,  2641,  4115,
    4116,  2132,  2133,  2143,  2144,  2145,  2146,  2147,  2148,   232,
    3680,  2661,  1583,  2662,  2125,  2663, -2532,  2662,   130,   131,
    1584,   235,  2127,   801,   364,  3681,   364,  2689,  2128,  2690,
    2046,  2047,    35,   424,  3435,  3436,  3437,  3498,  3499,  1159,
      41,    42,  1590,  2883,  2136,  1941,  2941,    45,  2690,  1604,
     978,   808,  2129,  1609,  1611,   245, -1088,  2137,  4133, -1088,
    1605,  2143,  2144,  2145,  2146,  2147,  2148,  1619,  1074,  1653,
    1615,  2072,  4135,  2316,  1616,   948,   364,  3361,  3362,  3363,
    1620,  3364,  3365,  3366,  3367,  3368,  3369,   801,  1870,  1723,
    2868,  1589,  1621,  1591,   949,  1724, -1469, -1469, -1469, -1469,
    3682,  1622,  1159, -1469,  1623,  3019,  1159,  3020,  3683,  3074,
    1140,  3075,   978,  3165,  3028,  3166,  1428,  1624,  1625,  3357,
    1159,  1159,  1141,  1142,  1631,   950,  1122,  4119,  4120,  4121,
    4122,  4123, -2532,  1632,  1634,  1725,  3897,  4381,  1663,  1664,
    4215,  3684,  1143,  1630,  1666,  1144,  4374,  3178,  1701,  3179,
    1159,  1159,  2130,  1678,  1672,  1159,  2131,  2606,  3293,  4367,
    2662,  4179,  3329,  3339,  2641,  2641,  2612,  1159,  1159,  1159,
    1159,  3342,  3346,  2641,  2641,   404,   364,  2132,  2133,   364,
    1159,   404,  1719,  1159,  1726,  1159,   688,  3347,  3373,  2641,
    2641,  1727,  2134,  1696,  1728,  1159,  1159,  1747,  3389,  1159,
    2641,  3394,  1661,  3395,    80,  1745,    80,   360,  3430,  2695,
    3431,  2692,  1159,  3432,  1159,  3433,   402,  2135,  1159,  1783,
    2136,  2693,  2694,  1792,  2143,  2144,  2145,  2146,  2147,  2148,
    3600,  1801,  3601,  2137,  1159,  1802,  2138, -1460, -1460, -1460,
   -1460,   808,  1803,  1808, -1460,  1159,  1729,  1159,  1159,  1159,
    1172,  4455,  1810,  1674,  4119,  4120,  4121,  4122,  4123,  1145,
    1812,  1817,  4124,  3390,  1822, -1463, -1463, -1463, -1463,  3397,
    1824,  1159, -1463,    74,    74,  3604,    74,  3605,  1543,  1834,
    3741,   801,  3742,  1159, -1461, -1461, -1461, -1461,  1159,  3490,
    3771, -1461,  3772,  1686,   978,  1159,  1146,  1831,  1878,  3359,
    1730,  1159,  1731,   214,  3781,   402,  3782,  3842,  2139,  2641,
     802,  1428,  1732,  1876,  3357,  4431,  3878,  3888,  3879,  3889,
    1733,  3900,   363,  2641,  1880,  3973,  4364,  3974,   363,  1734,
    1872,  3898,   222,  3977,  4005,  3978,  2662,  1889,  4099,  1630,
    4100,   808,  -174,  4256,   808,  2690,  4317,  4323,  4318,  2662,
    4324,  4413,  2662,  4414,   402,  3360,   402,  4457,  1893,  4458,
    4306,  1159,  1905,  4459,  1736,  2641,  4467,  1913,  2690,   232,
    4536,  4486,  4537,   951,  3120,  4550,  4586,  4551,  4587,   799,
    1870,   235,  4599,  4606,  2690,  1941,   834,  1891,  3299,  1737,
    4611,  4613,  3761,  3761,  1929,  1934,  2140,  2141,  2142,  1921,
    2143,  2144,  2145,  2146,  2147,  2148,   402,  1935,  4538,  3149,
    1936,  4669,  3350,  2180,  4673,   952,  4674,  3149,  1870,  1870,
    1951,  1870,  4771,  4684,  1937,  2690,   802,  4685,  4686,  3395,
    2641,   799,  4689,  4691,  1941,  3761,  4708,  4714,  2690,  2690,
    4715,  4739,  2690,  1941,  4816,  1738,  4817,  1938,   404,   404,
     404,  4828,  4276,  4817,  4279,  1940,  1946,  1941,  1949,  1950,
    1952,  1954,  1959,  1960,  1961,  1966,  1980,  2014,  2042,  3218,
    4598,  1870,  2057,  1870,  2048,  2044,  2058,  2050,  2051,  2066,
    2069,  2070,   356,  1073,   978,  2071,   245,  2077,   978,   978,
    2075,  2080,  2081,  3249,  3359,   799,  3764,  2082,  2083,  1297,
    2088,  2153,  1016,  2090,  4302,  2091,   402,  2092,  2093,   402,
    2094,  2101,  2102,  2104,  2105,  2106,  2107,  1870,  3361,  3362,
    3363,  2180,  3364,  3365,  3366,  3367,  3368,  3369,  2108,  1016,
    2109,  2184,  3802,  2110,  1297,   801,  4634,   364,  1870,  2111,
    4639,  4640,  2195,   364,  4601,  1378,  2205,  2223,   891,  2215,
    3360,  1593,  1595,  2250,  2258,  2260,  2267,  1111,  3765,  2275,
     404,  2276,  2281,  1377,  3687,  1870,  2283,  2285,  2243,  2293,
    2294,  2296,  2301,  3778,  2303, -2474,  2981,   404,  1870,  2305,
    2312,  2290,  1172,  2313,  2314,  2317,  4394,  2316,  2297,  2299,
    1074,  2318,  2320,  3801,  4367,   363,   363,   363,  2319,  2321,
    1074,  2342,  2346,  2370,  2368,  2371,  1084,  2372,  2373,  2394,
    3255,  1016,  2401,  2395,  2403,  2413,  2414,  2416,  4635,  2419,
     802,  4500,  2417,  3914,  3915,  3916,  3917,  2418,  2425,  1703,
    2426,  4638,  2427,  2428,  2429,  2435,  2442,  1630,  2436,  2439,
    2440,   978,  1870,  2449,  1733,  2450,  2474,   978,  3674,  1189,
    1630,  2456,  2463,  2475,  2479,  1870,  2464,  2476,  2480,  2501,
    2485,  1704,  2487,  2502,  2514,  2539,  2516,  2524,  1870,  2517,
    2072,  2062,  2526,  2078,  2527,  2540,  3530,  3531,  2546,  3533,
    2543,  2547,  2551,   866,  2568,  2573,  2586,  2587,  2592,   799,
    1769,   978,  2598,  2595,   978,   978,  2597,  2552,  1159,  2599,
    2605,   902,   808,  4694,  2616,  2617,  2618,   363,   808,  2632,
    2619,  1703,  2633,  3361,  3362,  3363,  1705,  3364,  3365,  3366,
    3367,  3368,  3369,  2657,   363,   801,  2658,  2673,  2678,  2687,
    2723,  2700,  2764,  1159,  2777,  2783,  1870,   902,  2722,  2124,
    2788,  2765,  1159,  1704,  2787,  2795,  2801,  1706,  1159,  2820,
    1159,  2847,  2864,  2866,   978,  1870,  1159,  2874,  2875,  1159,
    1159,  1159,  1159,  1159,  1159,  1159,  1159,  1159,  1159,  2818,
    1297,  2871,  1159,  1159,  1079,  2863,  3256,  2869,  2884,  2885,
    1870,  2893,  2894,  2897,  2903,  1159,  2923,  2925,  2926,  1159,
    2170,   404,  2940,  1159,  4575,  2942,  1630,  2944,  1705,  2943,
    2955,  2965,  1428,  1159,  3627,  3357,  1159,  2960,  1159,  2963,
     364,   364,   364,  2967,  2968,  2979,  1870,  1159,  1159,  1159,
    4618,  2973,  4257,  1159,  2999,   801,  1159,  2976,   801,  1706,
    2982,  2996,  3010,  3069,  3015,  3017,  1159,  3073,  3076,  3077,
    3117,  3064,  3130,  3134,  3138,  3139,  1159,  3135,  3140,  3142,
    3143,  3144,  3145,  4792,  1159,  3146,  1159,  4508,  2600,  3156,
    3167,  3158,  3162,  3169,  3172,  3174,  4057,   402,  3175,  3173,
    3180,  3199,   207,   402,   802,  3204,  1709,  3211,  3217,  3883,
    1297,  4522,  1710,  3223,  3226,  3231,  3230,  3232,  3250,  1711,
     356,  3248,  3262,  3265,  3268,  3266,  3267,  1794,  3270,  3271,
    1159,  3284,  3279,  3285,  3300,  1713,  1159,    74,  3282,  3289,
      74,  3295,  1159,  1714,  3296,  3297,  3298,  3307,  2701,  1707,
    3315,  3319,   364,  3321,  3744,  1394,  3747,  3326,  3340,  3341,
    3324,  3343,  3323,  3327,  3344,  2641,  3325,  1159,   363,   364,
    3379,  3345,  3391,   799,  3348,  3349,  3351,    35,  3410,  3354,
    1708,  3454,  3372,  3378,   207,    41,    42,  3603,  1709,  3405,
    3380,  2060,  3418,  1715,  1710,  3425,  3381,  3258,  3791,  3388,
    3428,  1711,  3205,  3403,  3404,   808,   808,   808,  3448,  1712,
    2076,  3453,  3456,  -935,  3625,  3359,  3502,  1713,  3504,  3508,
    3518,  3523,  3514,  1428,  3519,  1714,  3357,  3524,  3529,   404,
    1973,  3532,  1189,   404,  1870,   404,  3535,  2728,  2729,  3520,
    2103,  3534,  3543,  4258,  3555,  2741,  3569,  3822,  3576,  2744,
    2745,  3490,  3589,  3577,  2114,  3539,  1189,  3540,  3080,  3591,
    3622,  3623,  3626,  3629,  2766,  3628,  2767,  3832,  3633,  2123,
    3149,  3360,  2124,  3149,  3149,  1715,  3634,  3149,  3635,  3630,
    3631,  3632,  3636,  3637,  3638,  3639,  2789,  3149,  2790,  3640,
    3641,  3642,  1830,  4705,   802,  2755,  3643,  2127,  3696,  3650,
    3648,  3652,  2472,  2128,  3705,  3446,  1630,  3658,  3081,  2778,
    3664,  3696,  3665,  3666,  3667,  3668,  3699,   808,  3669,  2278,
    3698,  3062,  3711,  4038,  1297,  3707,  1297,  2129,  3738,  3712,
    3751,  3753,  3749,  3760,   808,  3766,  3775,  3761,  2290,  3769,
    3770,  3776,  3818,  3799,  3779,  3830,  3819,  3807,  3809,  1084,
    1084,  1159,  1084,  3206,  3820,  3821,  3829,  3759,  3082,  3831,
    3824,  3446,  3840,   799,  2059,  3845,  3375,  3357,  3374,  3874,
     402,   402,   402,  3801,  1630,  2118,   363,  1870,  3875,  3890,
     363,  3876,   363,   364,  3882,  3927,  3786,  1297,  3902,  3419,
    2280,  3903,  3940,  4702,   802,  3943,  3960,   802,  3969,  3992,
     978,  4008,  3546,  4011,  3911,  4013,  3359,  4014,  4021,  4022,
    1870,  1159,  1159,  3949,  3959,  3961,   801,  3983,  4024,  4032,
    3962,  4039,   801,  4313,  3965,  3966,  4040, -2532,  4051,  4062,
    4052,  2131,  4041,  4054,  3361,  3362,  3363,  4053,  3364,  3365,
    3366,  3367,  3368,  3369,  4055,  4078,  3083,  4056,   978,  4027,
    4082,  4086,  2132,  2133,  4088,  4089,  4143,  4117,  4162,  3791,
    4155,  4311,  3360,   799,  4151,  4164,   799, -2532,  1653,  2662,
      74,  1159,    74,  4165,  4167,  4174,  4183,  4168,  4187,  4188,
    4197,  4203,   402,  3207,  4190,  4198,  4201,  4211,  4216,  4219,
    4220,  4231,  4205,  4221,  4222,  2136,  4223,  4241,  4228,   402,
    4235,  4240,  4272,  4333,  4242,  4236,  4244,  1159,  2137,  4248,
    4273,  4285,  4268,  4280,  4286,  4303,  4243,  1159,  1159,  4312,
    1870,  3208,  4270,  4283,  1630,  1159,  1159,  4288,  4304,  4319,
    1159,  1870,  4314,  4289,  4320,  3895,  1159,  1159,  1189,  4330,
    1159,  4361,  4307,  4331,  4338,  3084,  4332,  4356,   808,  4365,
    4372,  4380,  4377,  3085,  4387,  1159,  3086,  4395,  3459,  1159,
    4399,  4345,  4400,  3255,  4348,  4404,  4406,  4415,  1159,  4419,
    4428,  4429,  4437,  1159,  4445,  4453,  4454,  4456,  4461,  4463,
    4464,  4465,  1703, -2532,  4466,  1159,  4472,  4479,  3956,  4482,
    4488,   364,  4492,  4502,  4494,   364,  4514,   364,  4498,  4517,
    4524,  4389,  4525,  4530,  4531,  4540,  4150,  4547,  4549,  4560,
     978,    81,  4559,  4563,  1704,  4565,  3255,  4562,   978,  4577,
     978,  4578,  4579,  1159,  4580,  3361,  3362,  3363,  4581,  3364,
    3365,  3366,  3367,  3368,  3369,  1703,  4594,  4602,  4617,  1870,
    1080,  4608,  4625,  4632,  4651,  4655,  4659,  4662,  4678,  4665,
    4671,  4672,  4677,  4683,  4688,  4687,  4692,  4693,  4698,  4711,
    1870,  4299,  4700,  4636,  4716,  4717,  1967,  1704,  4720,  1705,
    4726,  4722,  1870,  3951,  4731,  2143,  2144,  2145,  2146,  2147,
    2148,  4757,  4749,    79,  4754,  4752,  4760,  4718,  4783,   801,
     801,   801,  4719,  4768,  4159,  4160,  4795,  4811,  4815,  3176,
    1706,  1092,  4826,  1722,  4822,  2486,  3214,  2202,  3483,  3068,
    1870,  3587,  4036,   402,  3129,  3671,  4534,  4401,  4647,  4410,
    4366,  4561,  1705,  4185,  4564,  4392,  4574,  3537,   404,  3256,
    4506,  3294,  4755,  4791,  4723,  4721,  4766,  3696,  4667,  3542,
    4186,  4154,  2585,   356,  4035,  3197,  3198,  3598,  2565,  4156,
    4157,  3181,  3756,  1706,  4058,   802,   808,  4059,  1172,  4060,
     808,   802,   808,  4794,  4827,  4823,  4010,  3708,  4212,  4213,
    4214,  1159,  4009,  4767,  3686,  4523,  4713,  4080,  4081,  4758,
    2550,  1953,  3256,   404,  4526,   997,  4217,  2032,  4620,  3149,
    4193,  3023,  1968,  4194,  4676,  3149,  3149,  3149,  3149,  3149,
    3149,   801,  1723,   356,  3649,  1297,  4776,  4824,  1724,  4107,
    1557,  4554,  2879,  2647,  2880,  3487,  3674,  4173,   801,  1981,
    3979,  1298,  4305,  3290,   799,   207,  1870,  1579,  3488,  3257,
     799,  2902,  2221,  3705,  2247,  1710,  3500,  3496,  2896,  2901,
     978,  3513,  1711,  3501,  4130,  4132,  4134,  4136,  1725,  2251,
    1794,  2246,  3923,  4278,  4610,  3980,  3894,  1565,  1713,  1159,
    2254,  4600,  3884,  1870,  4740,  4748,  1714,  4741,  1159,  3423,
    3491,  3336,  3421,  3976,  3800,   363,  2846,  1125,   207,  1923,
    3264,  2601,  1709,  2927,  4738,  1159,  1159,  4499,  1710,  1159,
    2266,  1095,  2802,  1723,  1343,  1711,  3446,  1726,  2259,  1724,
    1159,  2918,  2039,  1794,  1727,  1159,  1642,  1728,  1159,  1671,
    4192,  1713,  1643,  1159,  1159,  2931,  1715,  2932,  2934,  1714,
    3258,   402,  4295,  3478,  3985,   402,  3986,   402,  3964,  1118,
     363,  2263,  2169,  2938,  3292,  2659,    83,     0,     0,  1725,
     686,  1970,  1383,     0,     0,     0,  1159,     0,     0,     0,
       0,  2123,     0,     0,  2124,  2755,  2755,     0,     0,  1729,
    2755,     0,     0,     0,     0,     0,  1870,     0,     0,  1715,
    1159,  4226,     0,  3258,     0,     0,     0,     0,     0,  2127,
       0,     0,     0,     0,     0,  2128,     0,     0,  1726,     0,
       0,     0,     0,     0,     0,  1727,  4496,  3446,  1728,     0,
    2755,  2755,     0,     0,     0,     0,  1159,     0,     0,  2129,
       0,  4352,  4353,  1730,  4355,  1731,   356,   980,     0,     0,
       0,     0,     0,     0,     0,  1732,     0,     0,   802,   802,
     802,  2290,   801,  1733,  3481,     0,   978,   980,  1630,     0,
       0,     0,  1734,     0,     0,     0,     0,     0,     0,     0,
    1729,     0,     0,     0,     0,     0,     0,  1159,     0,  1870,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3908,     0,  1735,     0,     0,     0,  1736,     0,     0,
       0,  1159,  1870,     0,  1159,     0,  1159,     0,     0,     0,
     364,     0,  4300,  4301,     0,     0,     0,   799,   799,   799,
       0,     0,  1737,  1159,  1730,     0,  1731,  1159,     0, -2532,
       0,     0,  1870,  2131,    80,     0,  1732,     0,     0,     0,
       0,     0,     0,     0,  1733,     0,     0,     0,     0,     0,
       0,     0,     0,  1734,  2132,  2133,     0,     0,     0,     0,
     802,     0,     0,     0,     0,   364,     0,     0,  1870, -2532,
       0,     0,  1870,  1870,     0,     0,     0,   802,  1738,     0,
       0,     0,     0,     0,  1772,     0,  4810,     0,  1736,     0,
       0,     0,     0,     0,     0,     0,     0,  2136,     0,   404,
       0,     0,     0,     0,     0,     0,     0,  1159,     0,     0,
    2137,     0,     0,  1773,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   799,
       0,     0,     0,     0,     0,  1870,     0,     0,     0,  3149,
    3149,     0,  4682,     0,     0,     0,   799,     0,     0,     0,
       0,     0,     0,  1297,     0,     0,     0,  4370,     0,  4371,
     801,     0,  4375,  4376,   801,  1159,   801,     0,     0,  1738,
    3705,  3705,  3705,  3705,  3705,   808,     0,     0,     0,     0,
    1159,     0,     0,     0,     0, -2532,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     360,     0,  4781,  1159,  4778,     0,     0,     0,     0,  4408,
       0,     0,  1159,     0,  4779,  4780,     0,     0,     0,     0,
     808,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1159,  1159,     0,   363,   360,  4430,  4781,
       0,  4778,     0,     0,   978,     0,  1159,     0,     0,  3700,
    3703,  4779,  4780,     0,     0,     0,     0,   978,     0,     0,
       0,  4226,  4226,  4226,  4226,     0,     0,  2143,  2144,  2145,
    2146,  2147,  2148,     0,     0,     0,     0,     0,     0,     0,
    1159,   802,   360,     0,  4781,  3748,  4778,     0,     0,     0,
    1159,     0,     0,     0,     0,  3446,  4779,  4780,  2607,  3446,
       0,     0,     0,     0,     0,     0,   404,  2613,     0,     0,
       0,     0,     0,     0,     0,  2621,  2622,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     402,  4605,     0,  2634,     0,     0,     0,     0,     0,     0,
       0,  4605,     0,     0,     0,     0,     0,     0,     0,  1159,
     799,     0,     0,     0,     0,   404,     0,     0,     0,     0,
    1159,     0,     0,     0,   404,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4802,  3696,
       0,     0,     0,     0,     0,   402,     0,     0,     0,     0,
    4645,     0,     0,     0,  4801,     0,     0,     0,     0,     0,
       0,     0,  3149,   978,     0,     0,  4535,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4802,     0,     0,
       0,     0,     0,     0,     0,     0,  4802,     0,     0,     0,
       0,     0,     0,  4801,     0,     0,     0,     0,     0,     0,
       0,   364,  4801,   363,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4690,     0,     0,
       0,  2755,  2114,     0,  2755,  2755,  2755,  2755,  2755,  2755,
    2755,  2755,  2755,  2755,     0,     0,  2802,     0,     0,   802,
       0,     0,     0,   802,   682,   802,     0,     0,     0,   700,
       0,     0,   363,     0,  3881,  3429,     0,     0,     0,     0,
       0,   363,     0,     0,     0,     0,     0,     0,  3439,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    35,     0,  2755,  2755,     0,     0,   700,     0,    41,
      42,     0,     0,     0,     0,  2123,     0,     0,  2124,     0,
       0,     0,     0,     0,     0,   356,     0,   700,   799,     0,
       0,     0,   799,     0,   799,  2125,     0,     0,  2126,     0,
       0,     0,     0,  2127,  3439,   989,     0,  1073,  1297,  2128,
       0,     0,  2876,     0,     0,     0,     0,     0,   990,     0,
       0,     0,     0,  3982,     0,     0,   998,     0,     0,     0,
       0,     0,     0,  2129,     0,     0,     0,     0,     0,     0,
       0,  1008,     0,   989,     0,     0,   808,  1029,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1058,     0,     0,
       0,     0,     0,     0,     0,  1063,     0,     0,     0,     0,
    3446,     0,     0,     0,     0,  3446,     0,     0,  3446,   801,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   364,     0,
       0,     0,     0,     0,     0,     0,     0,  2123,     0,     0,
    2124,     0,     0,   978,     0,     0,  3446,  2123,     0,     0,
    2124,     0,     0,     0,     0,     0,     0,  2125,     0,   978,
       0,     0,     0,  2130,   801,  2127,     0,  2131,     0,     0,
    4521,  2128,     0,     0,     0,  2127,     0,   364,     0,     0,
       0,  2128,     0,   980, -2041,   980,   364,   980,  2132,  2133,
       0,     0,     0,   980,     0,  2129,     0,     0,     0,     0,
       0,     0,     0,  2134,  2123,  2129,  1172,  2124,     0,     0,
       0,   978,     0,     0,     0,     0,   980,   980,     0,     0,
       0,     0,     0,     0,  2125,     0,  1376,  1377,  2135,     0,
   -2041,  2136,  2127,     0,     0,  4114,     0,     0,  2128,  3703,
       0,   402, -2041,     0,  2137,     0, -2041,  2138,     0,     0,
    4129, -2041,     0,     0,     0,     0, -2041,  3446,     0, -2041,
       0, -2041,  2129,     0,     0,     0,     0,     0,     0,  4803,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -2041,     0,
       0,     0,     0,   808,     0,  2130,  2755,     0,     0,  2131,
       0,     0,     0,     0,     0,  2130,     0,  3446, -2041,  2131,
       0,     0,     0,     0,     0,     0,     0,     0,  4803,  2139,
    2132,  2133,     0,     0,     0,     0,     0,  4803,     0,     0,
    2132,  2133,     0,     0,   980,  2134,     0,     0,     0,     0,
       0,     0,   808,     0, -2041,  2134,     0,     0,   686,   686,
       0,   808, -2041,  1658,     0,     0,     0,     0,     0,     0,
    2135,   978,  2130,  2136,   356,     0,  2131,     0,     0,     0,
    2135,     0,     0,  2136,     0,     0,  2137,     0,     0,   356,
       0,     0,     0,     0,     0,     0,  2137,  2132,  2133,     0,
       0,     0,     0,     0,     0,     0,   980, -2041,     0,   356,
       0,     0,  2134,     0,     0,     0,     0,  2140,  2141,  2142,
       0,  2143,  2144,  2145,  2146,  2147,  2148,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2135,     0,     0,
    2136,     0,     0,     0,     0,     0,     0,     0,     0,  3272,
       0,   993,     0,  2137,     0,     0,  2138,     0,   802,     0,
       0,  2139,     0,  3280,  3281,     0,     0,  3283,   402,     0,
       0,  2139,     0,  3287, -2041,     0,     0,     0,     0,     0,
    2755,  2755,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2041,     0, -2041,
   -2041,     0,     0,  4728,     0,     0,     0,     0,  2290,     0,
       0,     0,  3446,   802,     0,     0,   700,   402,     0,     0,
       0,     0,     0,     0,     0,     0,   402,   799,  2139,     0,
      74,     0, -2041,     0,   978, -2041, -2041,     0, -2041,     0,
    3322,     0,     0,     0,     0,     0,  4756,     0,     0,  2140,
    2141,  2142,     0,  2143,  2144,  2145,  2146,  2147,  2148,  2140,
    2141,  2142,     0,  2143,  2144,  2145,  2146,  2147,  2148,  2114,
     801,     0,     0,     0,     0,     0,   978,     0,     0,  3921,
       0,     0,   799,     0,     0,     0,     0,     0,   980,  4342,
    4343,     0,     0,     0,  4346,  4347,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2123,     0,     0,
    2124,     0,     0,     0,     0,     0,  2140,  2141,  2142,     0,
    2143,  2144,  2145,  2146,  2147,  2148,     0,  2125,  2872,     0,
       0,     0,     0,     0,  2873,  2127,     0,     0,     0,  1723,
       0,  2128,     0,     0,     0,  1724,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4825,     0,     0,     0,     0,  2129,  3703,  3703,  3703,  3703,
    3703,     0,     0,     0,   978,  1723,     0,     0,     0,     0,
       0,  1724,     0,     0,     0,  1725,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1155,  1161,  1161,   700,
       0,  1161,  1168,     0,  1155,   682,  1058,     0,  1191,     0,
     682,     0,  1058,     0,  1058,     0,  1854,     0,  1161,   682,
    1058,  1725,     0,     0,     0,     0,     0,     0,  1215,     0,
       0,     0,     0,  1058,  1726,  1155,     0,     0,  1161,     0,
     700,  1727,  1161,     0,  1728,     0,   682,     0,  1191,     0,
     682,  1268,     0,     0,     0,     0,     0,     0,  1161,     0,
       0,   682,     0,     0,     0,  2130,     0,     0,     0,  2131,
    1726,     0,     0,     0,     0,     0,   674,  1727,   980,     0,
    1728,     0,   980,   980,     0,  1296,     0,   801,     0,  1155,
    2132,  2133,     0,     0,   700,     0,  1729,     0,  1155,     0,
       0,  1191,     0,     0,     0,  2134,     0,     0,     0,     0,
    3551,     0,     0,     0,  2755,     0,  1161,     0,     0,     0,
       0,     0,     0,  4460,     0,     0,     0,  1358,     0,     0,
    2135,     0,  1729,  2136,     0,     0,   801,     0,     0,     0,
    2755,  2755,     0,  4495,     0,   801,  2137,     0,     0,  2138,
    1730,     0,  1731,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1732,     0,     0,   686,     0,     0,     0,  1058,
    1733,     0,     0,     0,  2040,     0,  3590,     0,  3592,  1734,
       0,  1058,  1412,     0,     0,   978,  1730,     0,  1731,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1732,     0,
       0,     0,     0,     0,     0,     0,  1733,     0,  1518,   802,
    1797,     0,   700,  1058,  1736,  1734,  1296,     0,     0,     0,
       0,  2139,     0,     0,     0,     0,     0,     0,     0,     0,
    1058,     0,     0,     0,  1058,   980,     0,     0,     0,  1798,
       0,   980,  1518,     0,     0,     0,  2365,     0,     0,     0,
    1736,     0,  1058,     0,     0,     0,  3644,     0,     0,   356,
       0,  3651,     0,     0,  1058,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2366,     0,     0,   799,     0,
       0,     0,     0,     0,     0,   980,     0,     0,   980,   980,
       0,     0,     0,     0,     0,  1738,     0,     0,     0,     0,
       0,     0,   682,   682,     0,     0,     0,     0,     0,  2140,
    2141,  2142,     0,  2143,  2144,  2145,  2146,  2147,  2148,     0,
       0,     0,     0,     0,     0,  3398,     0,     0,     0,     0,
       0,  1738,     0,     0,     0,  2123,  2755,     0,  2124,     0,
       0,     0,     0,     0,     0,  1058,     0,     0,   980,     0,
       0,     0,  1161,  1161,     0,  2125,     0,     0,     0,     0,
       0,     0,     0,  2127,     0,     0,     0,     0,  3439,  2128,
       0,     0,  3439,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1155,     0,  2129,     0,     0,     0,     0,     0,     0,
       0,  1155,     0,     0,  1191,     0,     0,  3803,     0,     0,
       0,  3806,     0,  3808,   356,  3810,  3811,  1161,     0,     0,
       0,     0,     0,     0,  3816,     0,   802,     0,     0,     0,
       0,  1058,     0,     0,     0,     0,     0,  1161,  1161,     0,
    2040,  4680,     0,     0,  2123,     0,     0,  2124,     0,     0,
       0,  1058,  1058,  1058,  1161,     0,  1155,     0,  3834,     0,
    1920,     0,     0,     0,  2125,     0,     0,     0,     0,     0,
       0,     0,  2127,     0,     0,   802,     0,  1723,  2128,     0,
       0,     0,     0,  1724,   802,     0,     0,     0,  1161,  1161,
       0,     0,     0,  2130,     0,   799,     0,  2131,     0,     0,
       0,     0,  2129,     0,     0,     0,     0,  1296,  1754,     0,
       0,     0,     0,  2431,     0,     0,     0,     0,  2132,  2133,
       0,     0,  1518,  1725,     0,     0,     0,     0,     0,     0,
       0,     0,  1296,  2134,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   799,     0,     0,     0,     0,     0,
       0,     0,     0,   799,  1755,     0,     0,     0,  2135,     0,
       0,  2136,  2017,  2017,     0,     0,     0,  1058,     0,   989,
       0,     0,  1726,     0,  2137,     0,     0,  2138,     0,  1727,
    2500,     0,  1728,     0,     0,     0,     0,     0,     0,     0,
       0,  2049,     0,     0,  1058,     0,     0,  2055,  1296,  2040,
       0,  2123,  2130,   356,  2124,     0,  2131,     0,     0,  1518,
       0,     0,     0,     0,     0,  4800,     0,     0,     0,     0,
       0,  2125,     0,     0,     0,     0,     0,  2132,  2133,  2127,
       0,  1756,     0,     0,  1729,  2128,     0,  1518,     0,     0,
       0,     0,  2134,     0,     0,  2542,     0,     0,     0,  2139,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2129,
       0,     0,     0,     0,  4800,  1518,  1518,  2135,  1518,     0,
    2136,     0,     0,  4800,     0,     0,  1757,     0,  1758,     0,
       0,     0,     0,  2137,     0,  1518,  2138,     0,  1759,     0,
    1731,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1732,     0,     0,  2608,     0,   700,   700,     0,  1733,     0,
       0,     0,     0,  3439,     0,     0,  1760,  1734,  3439,  1296,
       0,  3439,     0,     0,     0,     0,  1296,  1296,     0,     0,
       0,     0,     0,  1058,     0,     0,  1518,  2140,  2141,  2142,
       0,  2143,  2144,  2145,  2146,  2147,  2148,     0,  1761,     0,
       0,  2786,  1736,  1762,     0,     0,     0,     0,  2139,  2130,
     914,     0,     0,  2131,   980,  1518,     0,     0,     0,  1518,
    1518,     0,   915,     0,     0,     0,     0,  1763,     0,  1058,
    1058,  2257,     0,     0,  2132,  2133,     0,  1764,     0,     0,
       0,     0,     0,   916,     0,     0,     0,     0,     0,  2134,
       0,     0,     0,     0,     0,     0,   917,   700,     0,   682,
       0,     0,   980,     0,     0,     0,   686,  1173,     0,   918,
       0,     0,  1192,     0,  2135,     0,     0,  2136,     0,     0,
       0,  1202,  1658,  1738,     0,     0,   919,     0,     0,     0,
    2137,     0,     0,  2138,     0,     0,  2140,  2141,  2142,     0,
    2143,  2144,  2145,  2146,  2147,  2148,     0,   920,  1259,     0,
    3697,     0,  1266,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1275,     0,   921,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   922,     0,     0,     0,
       0,   923,  2792,     0,     0,     0,     0,   924,  2400,     0,
       0,     0,     0,     0,  1058,     0,     0,  1161,     0,     0,
       0,     0,   925,     0,     0,  2139,     0,     0,     0,     0,
    3439,     0,  1191,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4206,     0,     0,     0,     0,     0,     0,
    4209,  4210,     0,     0,  1161,  1161,  1161,  1161,  1058,     0,
       0,  2123,     0,     0,  2124,     0,     0,   682,     0,     0,
       0,     0,     0,     0,   980,     0,     0,     0,     0,     0,
       0,  2125,   980,  2497,   980,  1058,   926,     0,     0,  2127,
       0,     0,     0,  1161,  1161,  2128,   927,     0,  2123,  1161,
       0,  2124,     0,  2140,  2141,  2142,     0,  2143,  2144,  2145,
    2146,  2147,  2148,     0,   834,     0,     0,  3893,     0,  2129,
       0,     0,     0,     0,     0,     0,  2127,     0,     0,     0,
       0,     0,  2128,     0,     0,     0,     0,     0,     0,   928,
       0,     0,     0,   929,     0,   930,  1161,     0,     0,     0,
       0,   931,     0,     0,   932,     0,  2129,     0,     0,     0,
       0,     0,     0,     0,   682,     0,     0,     0,     0,     0,
    1161,  1161,  1161,  1161,     0,     0,     0,     0,     0,   933,
     682,   934,     0,     0,     0,   935,     0,     0,     0,  2497,
       0,     0,     0,   936,     0,     0,     0,     0,   937,     0,
       0,     0,     0,     0,  1155,     0,     0,     0,     0,   938,
       0,   700,     0,  1155,   674,   674,     0,     0,     0,  2130,
       0,  1191,   939,  2131,     0,     0,  1058,     0,     0,     0,
       0,     0,     0,     0,     0,  1058,     0,   682,     0,     0,
       0,  1161,  1161,     0,  2132,  2133,     0,     0,     0,  2123,
       0,     0,  2124,     0,     0,  1058,  2130,     0,  1358,  2134,
    2131,     0,     0,     0,     0,     0,     0,     0,  3030,     0,
       0,  4336,  4337,     0,     0,     0,     0,  2127,   356,     0,
       0,  2132,  2133,  2128,  2135,     0,     0,  2136,     0,  2017,
       0,     0,     0,     0,     0,     0,  2134,  1155,     0,     0,
    2137,  1058,  1058,  2138,   980,     0,     0,  2129,     0,  1058,
       0,     0,     0,     0,     0,  4809,     0,     0,     0,     0,
       0,  4359,  4360,     0,  2136,   989,   989,     0,     0,  2703,
       0,     0,     0,  1518,  1518,     0,     0,  2137,     0,     0,
       0,  1518,     0,     0,  1518,     0,     0,  1518,     0,     0,
       0,     0,     0,     0,     0,  1518,  1518,     0,     0,     0,
     356,     0,     0,  1518,     0,  1191,  1518,  1518,  1518,  1518,
       0,     0,     0,     0,     0,  2139,  1518,  1518,     0,  1518,
       0,  1518,  1518,     0,     0,  1518,     0,     0,     0,     0,
       0,     0,     0,     0,  3171,     0,     0,     0,     0,     0,
    1518,     0,     0,     0,  1161,  1518,     0,  2130,     0,  1518,
       0,  2131,  2139,  1518,     0,  1518,  1518,  1518,  1518,  1518,
    1518,  1518,  1518,  1518,     0,  1518,     0,     0,     0,     0,
    1058,  1518,  2132,  2133,  1518,     0,     0,     0,     0,     0,
       0,     0,     0,  4441,     0,  4442,  4443,  2134,     0,     0,
       0,     0,     0,     0,     0,  1058,  4446,     0,     0,     0,
       0,     0,     0,  2140,  2141,  2142,     0,  2143,  2144,  2145,
    2146,  2147,  2148,     0,     0,  2136,     0,  3968,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2137,     0,
       0,  1058,     0,  1058,     0,  1518,     0,     0,     0,     0,
     980, -2532, -2532,     0,  2143,  2144,  2145,  2146,  2147,  2148,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2123,     0,     0,  2124,     0,     0,     0,     0,
       0,  2909,     0,  2916,     0,     0,     0,     0,     0,     0,
       0,     0,  2125,     0,     0,     0,     0,     0,     0,     0,
    2127,     0,     0,     0,     0,     0,  2128,     0,  3316,     0,
     682,     0,     0,  2139,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2129,     0,     0,     0,     0,     0,     0,   682,     0,     0,
       0,     0,   682,     0,     0,   682,   700,     0,     0,     0,
       0,   989,     0,   989,     0,     0,     0,  2123,     0,     0,
    2124,     0,     0,     0,     0,     0,     0,   682,  1518,     0,
       0,     0,     0,  1155,     0,  1161,  1161,  1161,     0,  1155,
    1191,     0,  1161,     0,  1161,  2127,  1161,  1161,     0,     0,
       0,  2128,     0,     0,     0,     0,   682,     0,     0,     0,
       0,  2140,  2141,  2142,     0,  2143,  2144,  2145,  2146,  2147,
    2148,     0,     0,     0,     0,  2129,     0,     0,     0,   682,
       0,  2400,     0,     0,     0,     0,     0,  3031,     0,     0,
    2130,     0,  3040,     0,  2131,  4596,     0,     0,  1058,     0,
       0,     0,   682,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3071,  3071,  2132,  2133,     0,     0,     0,
     700,   682,     0,     0,   682,     0,     0,     0,     0,     0,
    2134,   674,     0,     0,  1161,     0,     0,  3909,     0,     0,
       0,   682,     0,     0,     0,     0,     0,     0,   682,     0,
       0,  4622,     0,     0,     0,  2135,     0,  3119,  2136,  3121,
    3123,   682,     0,     0,     0,     0,     0,     0,     0,     0,
     682,  2137,     0,     0,  2138, -2532,     0,     0,     0,  2131,
    4646,     0,     0,     0,     0,     0,  1161,     0,     0,     0,
       0,     0,     0,     0,  1161,  1161,  1161,  1161,  1161,  1161,
    2132,  2133,     0,     0,     0,     0,     0,     0,   980,  1518,
       0,     0,     0,     0,     0, -2532,     0,     0,     0,     0,
       0,   980,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2400,     0,     0,     0,  3071,  1058,     0,     0,
       0,   989,     0,  2136,     0,     0,  2139,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2137,     0,     0,     0,
    3554,     0,     0,     0,     0,     0,  3119,     0,     0,     0,
       0,     0,     0,  1161,  3244,     0,     0,     0,     0,     0,
       0,     0,     0,  1296,  1920,     0,     0,     0,     0,  2484,
       0,  2123,     0,     0,  2124,     0,     0,     0,     0,     0,
       0,  1161,  3071,  1161,  3071,     0,     0,     0,     0,     0,
       0,  2125,     0,     0,     0,     0,     0,     0,  1296,  2127,
       0,     0,     0,     0,     0,  2128,  1518,     0,     0,     0,
       0, -2532,     0,     0,  2140,  2141,  2142,     0,  2143,  2144,
    2145,  2146,  2147,  2148,     0,     0,     0,  2017,  3994,  2129,
       0,  3617,     0,  3619,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   682,     0,     0,     0,   980,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   682,  2554,     0,     0,  1155,
       0,     0,     0,  1155,     0,     0,     0,  3645,  4788,     0,
       0,  1161,  2484,     0,     0,     0,     0,  1518,  1518,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3657,     0,
       0,     0,     0,  2143,  2144,  2145,  2146,  2147,  2148,     0,
       0,     0,     0,     0,     0,     0,     0,  1518,  1518,     0,
       0,     0,  1518,     0,     0,     0,     0,     0,     0,  2130,
       0,     0,     0,  2131,  1518,  1518,  1518,  1518,     0,  2484,
       0,     0,     0,     0,     0,     0,     0,  1518,     0,     0,
    1518,     0,  1518,  3402,  2132,  2133,     0,     0,     0,     0,
       0,     0,  1518,  1518,     0,     0,  1518,     0,     0,  2134,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1518,
       0,  1518,     0,  1191,     0,  1518,     0,     0,     0,     0,
       0,     0,     0,     0,  2135,     0,     0,  2136,     0,     0,
       0,  1518,  3030,     0,     0,  1058,     0,     0,     0,     0,
    2137,     0,  3447,  2138,  1518,  1518,  1518,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3804,     0,
       0,     0,     0,     0,  1296,     0,     0,     0,  1518,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1518,     0,     0,     0,     0,  1518,     0,     0,     0,  1058,
       0,     0,  1518,     0,     0,     0,     0,     0,  3447,     0,
       0,  3507,     0,     0,     0,  2916,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2139,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2123,  3846,     0,  2124,     0,
       0,     0,     0,     0,     0,     0,     0,   682,     0,     0,
       0,     0,     0,     0,     0,  3851,     0,     0,     0,     0,
       0,     0,     0,  2127,     0,     0,     0,   980,  1518,  2128,
    3071,     0,     0,     0,     0,  2017,     0,     0,     0,     0,
    3873,     0,     0,   980,  1296,     0,     0,     0,     0,     0,
       0,     0,  1161,  2129,  1161,  1161,  2123,     0,     0,  2124,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2140,  2141,  2142,  2040,  2143,  2144,  2145,
    2146,  2147,  2148,     0,  2127,     0,     0,  4229,     0,     0,
    2128,     0,     0,     0,     0,   980,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2129,  3912,     0,     0,     0,     0,
       0,     0,  2123,     0,     0,  2124,     0,     0,     0,     0,
       0,     0,     0,     0,   682,     0,     0,     0,     0,     0,
       0,   682,  2125,   807,     0,     0,     0,     0,     0,     0,
    2127,     0,     0, -2532,     0,     0,  2128,  2131,     0,     0,
       0,     0,   674,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4261,     0,  2132,  2133,
    2129,     0,     0,     0,     0,     0,     0,   807,     0,  2945,
       0,     0,     0, -2532,  2949,     0,     0,  2952,     0,   682,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3071,
    3071,     0,     0,     0, -2532,     0,     0,     0,  2131,  2974,
       0,  2136,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1020,  2137,     0,     0,     0,  3704,  2132,
    2133,  1020,     0,  1020,     0,   980,     0,     0,  3013,     0,
       0,     0,     0,     0, -2532,   807,     0,     0,  1296,     0,
    1296,     0,     0,     0,  1058,     0,     0,     0,     0,     0,
       0,  3027,     0,     0,     0,     0,     0,     0,     0,     0,
    2130,     0,  2136,     0,  2131,     0,     0,     0,  2017,  1058,
       0,     0,     0,     0,  3058,  2137,  1058,     0,     0,     0,
    1058,     0,     0,     0,     0,  2132,  2133,     0,     0, -2532,
       0,     0,     0,  3079,     0,  1058,  3089,     0,     0,     0,
    2134,  1296,     0,     0,     0,     0,     0,     0,     0,     0,
     700,     0,     0,  3097,     0,     0,     0,     0,     0,     0,
    3101,     0,     0,     0,  1058,  2135,     0,  1058,  2136,     0,
     682,     0,     0,  3124,  3817,     0,     0,     0,     0,     0,
       0,  2137,  3131,     0,  2138,  1155,     0,     0,   682,     0,
   -2532,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1058,     0,   682,     0,     0,     0,
       0,     0,  1161,     0,     0,     0,     0,     0,     0,     0,
    1518,  2143,  2144,  2145,  2146,  2147,  2148,  4161,   980,  1518,
       0,     0,     0,     0,     0,  1518,     0,  1518,     0,     0,
       0,     0,     0,  1518,     0,     0,  1518,  1518,  1518,  1518,
    1518,  1518,  1518,  1518,  1518,  1518,  2139,     0,     0,  1518,
    1518,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     980,     0,  1518,     0,  2123,     0,  1518,  2124,     0,   860,
    1518,     0,  2143,  2144,  2145,  2146,  2147,  2148,     0,     0,
    1518,   861,     0,  1518,  2125,  1518,     0,     0,     0,     0,
       0,     0,  2127,     0,  1518,  1518,  1518,     0,  2128,     0,
    1518,     0,   862,  1518,     0,     0,     0,     0,     0,     0,
    1058,  1058,  1058,  3447,  3926,   863,     0,     0,  3926,  3939,
       0,     0,  2129,  1518,   864,     0,     0,     0,  -701,  3953,
       0,  1518,     0,  1518,  2140,  2141,  2142,     0,  2143,  2144,
    2145,  2146,  2147,  2148,     0,   865,     0,     0,  4263,     0,
       0,   866,     0,     0,     0,     0,     0,     0,   980,     0,
       0,     0,     0,     0,     0,     0,   867,     0,     0,     0,
       0,  2040,     0,     0,     0,     0,     0,  1518,     0,     0,
       0,     0,     0,  1518,   868,     0,     0,  2916,     0,  1518,
       0,     0,     0,     0,     0,   869,     0,     0,     0,     0,
       0,     0,   870,     0,     0,     0,   871,     0,     0,     0,
       0,     0,     0,     0,  4000,  2017,  2017,     0,  2497,     0,
       0,  -889,  2130,     0,     0,     0,  2131,     0,     0,     0,
       0,     0,     0,     0,     0,  1161,  1161,  1161,  1161,     0,
       0,     0,     0,     0,   682,     0,     0,  2132,  2133,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   872,     0,
       0,     0,  2134,     0,     0,     0,  4034,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4326,
       0,     0,     0,     0,     0,     0,     0,  2135,     0,     0,
    2136,     0,     0,     0,     0,   873,     0,     0,   874,     0,
    4335,     0,     0,  2137,     0,     0,  2138,     0,   682,     0,
       0,   682,  4344,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4083,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   875,  1296,
    4358,     0,     0,     0,   876,     0,     0,     0,     0,     0,
    -377,     0,     0,   877,     0,     0,     0,     0,     0,   980,
       0,     0,     0,     0,     0,     0,     0,  3704,  2139,     0,
       0,     0,     0,     0,     0,  1058,     0,     0,  -377,     0,
     878,   879,     0,   880,   881,     0,  1161,     0,  1518,     0,
       0,     0,   882,     0,  1058,     0,     0,   883,     0,     0,
       0,     0,   884,     0,     0,   885,     0,  2400,   886,     0,
    2123,     0,     0,  2124,     0,     0,     0,  1058,     0,  3526,
       0,  -377,     0,     0,     0,     0,  3119,     0,     0,     0,
    2125,  4180,     0,     0,     0,  2400,     0,  3817,  2127,   807,
       0,     0,     0,     0,  2128,     0,     0,  1157,  1518,  1518,
       0,     0,     0,     0,     0,  1157,  2140,  2141,  2142,     0,
    2143,  2144,  2145,  2146,  2147,  2148,     0,     0,  2129,     0,
    4462,     0,  3071,     0,  3071,     0,     0,     0,     0,  2123,
       0,     0,  2124,     0,     0,     0,  1157,     0,     0,     0,
       0,     0,   682,  2040,     0,     0,     0,     0,     0,  2125,
       0,     0,     0,     0,     0,     0,     0,  2127,  1518,     0,
       0,     0,     0,  2128,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2129,     0,     0,
    1157,     0,     0,     0,  1518,     0,  3608,     0,     0,  1157,
       0,     0,     0,  3620,  1518,  1518,     0,     0,     0,     0,
       0,     0,  1518,  1518,     0,     0,     0,  1518,  2130,     0,
       0,     0,  2131,  1518,  1518,     0,     0,  1518,     0,  1058,
    1058,  1058,  1058,     0,     0,     0,  3926,     0,     0,  4269,
       0,     0,  3447,  2132,  2133,     0,  3447,     0,     0,     0,
       0,     0,  4282,     0,     0,  1518,     0,     0,  2134,     0,
    1518,  3654,     0,     0,     0,  4681,  4292,     0,     0,     0,
       0,     0,  1518,     0,     0,     0,     0,     0,     0,     0,
       0,  1191,     0,  2135,     0,     0,  2136,  2130,     0,  3507,
       0,  2131,     0,  2916,     0,     0,     0,     0,     0,  2137,
       0,     0,  2138,     0,     0,     0,     0,   989,     0,  1157,
    1518,     0,  2132,  2133,     0,  1020,     0,     0,     0,  1020,
       0,     0,     0,     0,     0,     0,     0,  2134,  3071,  3071,
       0,     0,     0,     0,     0,     0, -2043,     0,     0,     0,
       0,     0,     0,  1157,     0,  4334,     0,     0,     0,     0,
       0,     0,  2135,     0,   682,  2136,     0,     0,     0,     0,
       0,     0,  2040,     0,     0,     0,   682,     0,  2137,     0,
       0,  2138,     0,     0,  2139,     0,     0,     0,     0,  1161,
       0,     0, -2043,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3645,  1161, -2043,     0,     0,     0, -2043,     0,
       0,     0,     0, -2043,     0,     0,     0,     0, -2043,     0,
       0, -2043,  2484, -2043,     0,     0,     0,  1296,     0,     0,
       0,     0,     0,     0,     0,  2017,     0,     0,  2040,     0,
    3825,     0,  2040,  2040,  3704,  3704,  3704,  3704,  3704,     0,
   -2043,     0,     0,  2139,     0,     0,     0,     0,  3835,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1518,     0,
   -2043,     0,  2140,  2141,  2142,     0,  2143,  2144,  2145,  2146,
    2147,  2148,     0,     0,     0,     0,  4504,     0,     0,     0,
       0,     0,     0,     0,     0,  2123,  1161,  2400,  2124,     0,
       0,     0,  1157,     0,     0,     0, -2043,     0,     0,     0,
       0,     0,  1157,     0, -2043,  2125,     0,     0,     0,     0,
       0,     0,     0,  2127,     0,     0,  1058,     0,  4440,  2128,
       0,     0,     0,     0,  1868,     0,     0,     0,     0,     0,
       0,  2140,  2141,  2142,   682,  2143,  2144,  2145,  2146,  2147,
    2148,     0,     0,  2129,     0,  4545,  1518,     0,     0, -2043,
       0,     0,     0,     0,     0,  1518,     0,  1157,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1518,  1518,     0,     0,  1518,     0,     0,     0,
       0,     0,     0,  3926,     0,     0,     0,  3447,     0,     0,
       0,     0,  3447,   993,     0,  3447,  3119,     0,  4484,     0,
    1518,  1518,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2043,     0,     0,     0,
       0,     0,     0,  1157,     0,     0,     0,   682,     0,   682,
       0,     0,     0,  4000,  1191,  1161,  1161,  1161,     0, -2043,
       0, -2043, -2043,  2130,     0,     0,     0,  2131,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1155,  1191,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2132,  2133,
       0,     0,     0,     0, -2043,     0,     0, -2043, -2043,     0,
   -2043,     0,  1868,  2134,     0,     0,     0,  2017,     0,     0,
       0,     0,  2123,  1155,     0,  2124,  4020,     0,     0,     0,
       0,     0,  1058,     0,     0,     0,     0,     0,  2135,     0,
    1157,  2136,  2125,     0,     0,  3071,     0,  2400,     0,     0,
    2127,     0,     0,     0,  2137,     0,  2128,  2138,     0,  4180,
       0,     0,     0,     0,  1058,     0,     0,     0,  1157,     0,
       0,     0,     0,  1161,  4000,     0,     0,     0,     0,     0,
    2129,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4067,     0,     0,  4070,     0,     0,  1157,  1157,  1518,  1157,
       0,  1518,     0,  1518,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1157,     0,     0,     0,
    1518,     0,     0,     0,  3447,     0,     0,  4484,     0,  2139,
       0,     0,     0,  4616,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1161,     0,     0,     0,  1058,
       0,     0,     0,     0,     0,     0,     0,  1157,   807,     0,
       0,     0,  1161,  1161,  1161,  1161,     0,     0,     0,     0,
    2130,     0,  1296,     0,  2131,     0,     0,     0,     0,     0,
       0,     0,     0,  1160,  1162,     0,  1157,  1165,  1166,     0,
    1157,  1157,     0,     0,  1518,  2132,  2133,     0,     0,     0,
       0,     0,     0,     0,  1200,     0,     0,  2140,  2141,  2142,
    2134,  2143,  2144,  2145,  2146,  2147,  2148,     0,     0,     0,
       0,  4727,     0,     0,  1249,     0,     0,     0,  1252,     0,
       0,     0,     0,     0,     0,  2135,     0,     0,  2136,     0,
     687,     0,     0,     0,  1273,   701,     0,   701,     0,     0,
       0,  2137,  1518,     0,  2138,     0,     0,   701,  1161,     0,
    1191,     0,     0,     0,     0,     0,     0,  1518,  1868,     0,
       0,     0,     0,     0,   807,     0,     0,     0,     0,     0,
       0,  1020,     0,   701,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   701,     0,     0,     0,  1161,     0,     0,
    1155,     0,     0,   701,   701,     0,     0,   701,  1020,  4000,
       0,     0,     0,   701,     0,  1868,     0,   981,  4440,     0,
       0,     0,     0,     0,     0,     0,  2139,  4616,     0,     0,
    1518,  1518,     0,   682,     0,     0,     0,   981,     0,     0,
       0,  1868,     0,  1155,     0,     0,     0,     0,     0,     0,
       0,  1161,     0,   701,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2123,     0,     0,  2124,
       0,     0,     0,     0,     0,     0,     0,  1518,     0,     0,
       0,     0,     0,     0,     0,     0,  2125,  1518,     0,     0,
    1020,     0,  1161,     0,  2127,     0,     0,     0,     0,     0,
    2128,     0,     0,     0,     0,     0,     0,     0,  1868,     0,
       0,     0, -2055,     0,  2140,  2141,  2142,     0,  2143,  2144,
    2145,  2146,  2147,  2148,  2129,     0,     0,  1868,  4812,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2123,  1868,  1518,  2124,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1155, -2055,     0,
       0,     0,     0,     0,  2125,     0,     0,     0,   807,     0,
   -2055,     0,  2127,  1868, -2055,     0,     0,     0,  2128, -2055,
       0,     0,     0,     0, -2055,     0,  4339, -2055,     0, -2055,
       0,     0,     0,     0,     0,     0,     0,     0,  4349,     0,
       0,     0,  2129,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2055,     0,     0,     0,
       0,     0,     0,     0,  2130,  1157,     0,     0,  2131,     0,
       0,  1868,     0,     0,  1157,     0, -2055,     0,  1743,  1744,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2132,
    2133,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   701,     0,     0,  2134,     0,     0,     0,     0,     0,
       0,     0, -2055,     0,     0,     0,     0,     0,     0,     0,
   -2055,  3374,     0,     0,     0,     0,  3375,     0,     0,  2135,
       0,     0,  2136,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2130,  1825,     0,  2137,  2131,     0,  2138,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1157,     0,
       0,     0,     0,  1884,  1885, -2055,     0,  2132,  2133,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1912,     0,  2134,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1157,  1157,     0,     0,     0,     0,
       0,     0,  1157,     0,     0,  1157,     0,  2135,  1157,   993,
    2136,     0,     0,     0,  1943,  1945,  1157,  1157,     0,     0,
    2139,     0,     0,  2137,  1157,     0,  2138,  1157,  1157,  1157,
    1157,     0, -2055,     0,     0,     0,     0,  1157,  1157,     0,
    1157,     0,  1157,  1157,     0,     0,  1157,     0,     0,     0,
       0,     0,     0,     0,     0, -2055,     0, -2055, -2055,     0,
    1868,  1157,   807,     0,     0,     0,  1157,     0,     0,     0,
    1157,     0,     0,     0,  1157,     0,  1157,  1157,  1157,  1157,
    1157,  1157,  1157,  1157,  1157,     0,  1157,     0,     0,     0,
   -2055,     0,  1157, -2055, -2055,  1157, -2055,     0,  2139,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2140,  2141,
    2142,     0,  2143,  2144,  2145,  2146,  2147,  2148,     0,     0,
    3963,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   701,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2123,     0,     0,  2124,     0,     0,
       0,     0,     0,     0,     0,     0,  1157,     0,     0,     0,
       0,     0,     0,     0,  2125,     0,     0,     0,     0,     0,
       0,     0,  2127,     0,     0,     0,     0,     0,  2128,     0,
       0,     0,   701,   701,     0,     4,  2140,  2141,  2142,     0,
    2143,  2144,  2145,  2146,  2147,  2148,     0,     0,     0,   701,
       0,     0,  2129,     0,     0,     5,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     6,     7,     0,     0,     0,
       0,     8,     0,     9,    10,     0,     0,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,   807,    36,     0,    37,    38,    39,    40,    41,
      42,    43,    44,     0,     0,     0,    45,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1157,
       0,     0,     0,     0,  1157,     0,     0,     0,     0,     0,
    1157,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2130,     0,     0,     0,  2131,     0,     0,     0,
       0,     0,     0,     0,    46,     0,     0,     0,     0,     0,
    1868,     0,     0,     0,     0,  1868,  1868,  2132,  2133,     0,
       0,     0,     0,     0,     0,     0,  1868,     0,     0,     0,
       0,     0,  2134,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   807,     0,     0,   807,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2135,     0,     0,
    2136,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2137,    47,     0,  2138,     0,  1289,   701,
       0,   701,     0,     0,     0,     0,     0,     0,     0,     0,
      48,     0,     0,     0,     0,  3885,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2415,     0,     0,     0,   701,     0,     0,
     701,   701,    50,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   981,     0,   981,  2139,     0,
    1157,     0,  1868,   687,     0,     0,     0,   701,     0,     0,
       0,  3886,     0,     0,     0,    51,     0,     0,    52,     0,
    2467,  2468,  2469,  2470,     0,     0,   981,   981,     0,     0,
       0,     0,     0,    53,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2505,
    2506,     0,     0,     0,     0,  2515,   701,     0,   701,     0,
       0,  1868,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2140,  2141,  2142,     0,
    2143,  2144,  2145,  2146,  2147,  2148,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    54,     0,     0,     0,
       0,     0,  2536,     0,     0,     0,     0,  1157,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2569,  2570,  2571,  2572,
       0,     0,     0,     0,   687,     0,     0,    55,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   687,   687,
      56,     0,  1647,     0,     0,     0,  1868,     0,     0,     0,
       0,     0,     0,     0,     0,    57,     0,     0,     0,     0,
    1157,     0,     0,     0,  1157,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1157,  1157,
       0,    58,     0,     0,     0,     0,   687,    59,  2636,     0,
       0,    60,    61,    62,    63,    64,     0,     0,    65,    66,
      67,    68,     0,    69,    70,    71,    72,    73,  1157,  1157,
       0,     0,     0,  1157,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1157,  1157,  1157,  1157,     0,
       0,     0,  1018,   807,     0,     0,     0,     0,  1157,   807,
    1018,  1157,  1018,  1157,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1157,  1157,     0,     0,  1157,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1157,     0,  1157,     0,     0,     0,  1157,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1157,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1157,     0,  1157,  1157,  1157,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1157,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1157,  2123,     0,     0,  2124,  1157,     0,     0,     0,
    2799,     0,     0,  1157,     0,     0,     0,     0,     0,  1157,
       0,  1865,  2125,     0,     0,     0,  2886,     0,   687,     0,
    2127,     0,     0,   701,     0,   701,  2128,     0,   701,     0,
     701,     0,     0,   701,   701,   701,     0,     0,     0,  2012,
       0,     0,     0,     0,     0,     0,   701,     0,     0,     0,
    2129,     0,     0,     0,     0,     0,     0,     0,     0,   701,
       0,   701,     0,     0,     0,     0,   701,     0,     0,  1157,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1868,     0,
       0,     0,     0,     0,     0,  2887,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1868,  1868,     0,  1868,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2130,     0,     0,     0,  2131,     0,   807,   807,   807,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1865,
       0,     0,     0,     0,     0,  2132,  2133,     0,     0,  1868,
       0,  1868,  2164,     0,     0,     0,     0,     0,     0,     0,
    2134,   701,   701,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
       0,     0,   687,   687,     0,  2135,     0,     0,  2136,     0,
       0,  2983,  2984,  2985,     0,  1868,     0,     0,  2993,     0,
    2995,  2137,  2997,  2998,  2138,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1868,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   807,     0,
       0,     0,     0,  1868,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   807,  1868,     0,     0,     0,
       0,     0,     0,   701,     0,   687,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2292,  2139,     0,     0,     0,
    2189,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3092,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1174,     0,     0,     0,     0,     0,  1194,     0,
       0,     0,     0,     0,     0,     0,  1203,     0,     0,     0,
    1868,     0,     0,     0,  1213,  2888,     0,     0,     0,  1244,
       0,     0,  1857,  1868,     0,   687,     0,     0,     0,     0,
       0,   687,  3141,     0,     0,     0,  1868,     0,     0,     0,
    3150,  3151,  3152,  3153,  3154,  3155,     0,     0,     0,     0,
       0,     0,     0,     0,  2140,  2141,  2142,     0,  2143,  2144,
    2145,  2146,  2147,  2148,     0,     0,  1157,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,     0,   687,   687,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1865,     0,     0,     0,     0,
       0,  1157,     0,     0,  1868,     0,     0,     0,     0,     0,
    1157,     0,     0,     0,     0,     0,  1157,     0,  1157,  3234,
       0,     0,     0,  1868,  1157,     0,     0,  1157,  1157,  1157,
    1157,  1157,  1157,  1157,  1157,  1157,  1157,     0,   687,     0,
    1157,  1157,  1865,     0,     0,     0,     0,  3274,  1868,  3276,
       0,     0,     0,  1157,     0,     0,  1153,  1157,     0,   807,
       0,  1157,     0,     0,  1153,     0,     0,  1411,  1865,     0,
       0,  1157,     0,     0,  1157,     0,  1157,     0,     0,     0,
    1857,     0,     0,     0,  1868,  1157,  1157,  1157,     0,     0,
       0,  1157,     0,     0,  1157,  1153,     0,     0,     0,  1536,
       0,     0,     0,     0,  1157,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1157,     0,  1559,     0,     0,     0,
       0,     0,  1157,     0,  1157,     0,     0,     0,  2123,     0,
       0,  2124,     0,     0,     0,  1865,     0,     0,  1585,     0,
       0,     0,     0,     0,     0,     0,     0,  3328,  2125,  1153,
       0,     0,     0,     0,  1865,     0,  2127,     0,  1153,     0,
       0,     0,  2128,     0,     0,     0,     0,     0,  1157,     0,
       0,     0,  1865,     0,  1157,     0,     0,     0,     0,     0,
    1157,     0,     0,     0,     0,     0,  2129,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1865,     0,     0,     0,     0,  1157,     0,     0,     0,     0,
       0,     0,     0,   701,     0,   701,     0,     0,     0,   701,
       0,   701,     0,     0,   701,     0,     0,     0,   701,     0,
       0,     0,     0,  2164,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1865,     0,
       0,     0,     0,     0,  4786,     0,     0,   807,  1153,     0,
       0,   807,  1868,   807,  1018,     0,     0,     0,  1018,     0,
       0,     0,     0,     0,     0,     0,  2130,     0,     0,     0,
    2131,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1153,     0,     0,     0,     0,     0,  1859,     0,
       0,  2132,  2133,     0,     0,     0,     0,  1882,     0,     0,
       0,     0,     0,     0,     0,     0,  2134,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1907,  1910,  1911,
       0,     0,     0,     0,     0,     0,  1857,     0,     0,     0,
       0,  2135,     0,     0,  2136,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2137,     0,     0,
    2138,     0,     0,     0,     0,     0,  2012,     0,     0,     0,
       0,     0,     0,  2860,     0,     0,     0,  4787,     0,  1157,
       0,     0,  2292,  1857,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2123,     0,     0,  2124,     0,     0,
       0,     0,     0,     0,     0,  1868,     0,     0,  3556,  1857,
    3557,  3558,     0,     0,  2125,     0,     0,  3338,     0,     0,
       0,     0,  2127,     0,     0,     0,     0,     0,  2128,     0,
       0,     0,  2139,     0,     0,     0,     0,  1865,  1868,  1157,
    1157,  1153,     0,  1536,   687,     0,     0,     0,     0,     0,
       0,  1153,  2129,     0,     0,     0,  1859,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1536,     0,     0,  1866,     0,     0,  1857,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,     0,  1857,   687,     0,     0,  1157,
       0,     0,  2930,     0,  1647,     0,  1153,   701,     0,     0,
       0,     0,     0,  1857,     0,     0,     0,     0,     0,     0,
    2140,  2141,  2142,     0,  2143,  2144,  2145,  2146,  2147,  2148,
       0,     0,     0,     0,     0,  1157,     0,     0,     0,     0,
       0,  1857,     0,     0,     0,  1157,  1157,     0,  1868,     0,
       0,     0,  2130,  1157,  1157,     0,  2131,     0,  1157,  1868,
       0,     0,     0,     0,  1157,  1157,     0,     0,  1157,     0,
       0,     0,  1153,     0,     0,     0,     0,  2132,  2133,     0,
       0,     0,     0,  1157,     0,     0,     0,  1157,     0,     0,
       0,     0,  2134,     0,     0,     0,  1157,     0,     0,  1857,
       0,  1157,     0,     0,     0,     0,     0,     0,     0,  2206,
       0,     0,     0,  1157,     0,     0,     0,  2135,     0,     0,
    2136,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1866,     0,  2137,     0,     0,  2138,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1157,     0,     0,   687,     0,  2255,     0,     0,  1153,
       0,     0,   687,     0,   687,     0,     0,  1868,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1153,  1868,     0,
       0,     0,     0,     0,     0,     0,     0,  1865,     0,     0,
    1868,     0,  1865,  1865,     0,     0,     0,     0,  2139,     0,
       0,     0,     0,  1865,     0,  1153,  1153,     0,  1153,     0,
       0,     0,  1859,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1153,     0,     0,  1868,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3839,     0,
       0,     0,     0,     0,     0,     0,   807,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1859,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2412,     0,     0,     0,     0,     0,  1153,     0,  1857,     0,
       0,     0,     0,     0,     0,  1859,  2140,  2141,  2142,  1157,
    2143,  2144,  2145,  2146,  2147,  2148,     0,     0,     0,     0,
       0,   807,     0,     0,     0,  1153,     0,     0,     0,  1153,
    1153,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2471,     0,     0,     0,     0,  1865,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1868,     0,     0,     0,     0,     0,
       0,  2498,  1859,     0,     0,     0,     0,     0,   701,  2012,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1859,     0,     0,   687,     0,     0,  1157,     0,     0,
       0,  1868,     0,     0,     0,     0,  1157,  1866,     0,  1859,
       0,     0,     0,     0,     0,     0,     0,     0,  1865,     0,
    1018,     0,     0,  1157,  1157,     0,     0,  1157,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1859,  1157,     0,
       0,     0,     0,  1157,     0,     0,  1157,  1018,     0,     0,
       0,  1157,  1157,     0,  1866,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1866,     0,     0,     0,  1157,     0,     0,     0,     0,     0,
       0,  4015,  4016,  4017,  4018,  1859,     0,     0,     0,     0,
       0,     0,     0,     0,  1868,     0,     0,     0,  1157,     0,
       0,     0,  2625,  1865,     0,     0,     0,     0,     0,     0,
    2123,  2629,     0,  2124,     0,     0,     0,     0,     0,  1018,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2125,  2644,     0,     0,  1157,     0,     0,  1866,  2127,     0,
       0,     0,     0,     0,  2128,     0,     0,     0,  1857,     0,
       0,     0,     0,  1857,  1857,     0,  1866,     0,     0,     0,
       0,     0,     0,     0,  1857,     0,     0,     0,  2129,     0,
       0,     0,     0,     0,  1866,  2292,     0,  1536,  1536,     0,
     687,     0,     0,     0,     0,  1157,     0,  1868,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1866,     0,     0,     0,     0,     0,     0,  1157,
    1868,     0,  1157,     0,  1157,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1157,     0,     0,     0,  1157,     0,     0,     0,     0,
    1868,     0,  4144,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1153,     0,     0,     0,     0,     0,
    1866,     0,     0,  1153,     0,     0,     0,     0,  2130,     0,
       0,     0,  2131,     0,  1859,     0,  1868,     0,     0,     0,
    1868,  1868,     0,     0,     0,     0,     0,     0,     0,     0,
    1857,     0,     0,  2132,  2133,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2845,   807,  2134,     0,
       0,     0,     0,     0,     0,  1157,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2865,     0,  2135,     0,     0,  2136,     0,     0,     0,
       0,     0,     0,  1868,     0,     0,     0,  1153,     0,  2137,
       0,     0,  2138,     0,     0,     0,     0,     0,     0,  1857,
       0,     0,     0,     0,     0,     0,  3352,  2878,     0,  2881,
       0,     0,     0,  1157,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1153,  1153,     0,     0,     0,  1157,     0,
       0,  1153,     0,     0,  1153,  1865,     0,  1153,     0,     0,
       0,     0,     0,     0,     0,  1153,  1153,     0,     0,     0,
       0,     0,     0,  1153,     0,     0,  1153,  1153,  1153,  1153,
       0,  1157,     0,     0,  2139,     0,  1153,  1153,     0,  1153,
    1157,  1153,  1153,  1865,  1865,  1153,  1865,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1866,
    1153,  1157,  1157,     0,  1857,  1153,     0,     0,     0,  1153,
       0,     0,     0,  1153,  1157,  1153,  1153,  1153,  1153,  1153,
    1153,  1153,  1153,  1153,     0,  1153,     0,     0,   687,     0,
       0,  1153,     0,     0,  1153,     0,  1865,     0,  1865,     0,
       0,   687,     0,     0,     0,     0,     0,     0,  1157,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1157,     0,
       0,     0,  2140,  2141,  2142,     0,  2143,  2144,  2145,  2146,
    2147,  2148,     0,     0,   807,     0,     0,     0,     0,     0,
       0,     0,  1865,     0,  1859,     0,     0,     0,     0,  1859,
    1859,     0,     0,   701,     0,  1153,     0,     0,     0,  2123,
    1859,     0,  2124,  1865,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3049,     0,     0,  1157,     0,  2125,
       0,     0,  3382,   807,     0,     0,     0,  2127,  1157,   701,
    1865,     0,   807,  2128,     0,  4354,     0,     0,     0,     0,
       0,     0,     0,  1865,  2123,     0,     0,  2124,     0,  4357,
       0,     0,     0,     0,     0,     0,     0,  2129,     0,     0,
       0,     0,     0,     0,  2125,     0,     0,     0,     0,     0,
       0,     0,  2127,     0,     0,     0,     0,     0,  2128,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2129,     0,     0,     0,     0,  1865,     0,     0,
       0,  2123,     0,     0,  2124,     0,     0,     0,  1153,     0,
    1865,     0,     0,  1153,     0,     0,  1859,     0,     0,  1153,
       0,  2125,     0,  1865,  3393,     0,     0,     0,     0,  2127,
       0,     0,  4409,     0,     0,  2128,     0,     0,     0,     0,
       0,     0,     0,  3213,     0,     0,     0,  2130,     0,  1866,
       0,  2131,     0,     0,  1866,  1866,     0,     0,     0,  2129,
       0,     0,     0,     0,     0,  1866,     0,     0,     0,     0,
       0,     0,  2132,  2133,     0,     0,  3387,     0,     0,     0,
       0,     0,     0,     0,     0,  1859,  1857,  2134,     0,     0,
       0,  1865,  2130,     0,     0,     0,  2131,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1865,     0,  2135,     0,     0,  2136,     0,  2132,  2133,     0,
       0,     0,     0,     0,  1857,  1857,     0,  1857,  2137,     0,
       0,  2138,  2134,     0,     0,  1865,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2135,     0,  2130,
    2136,     0,     0,  2131,     0,     0,     0,     0,     0,     0,
    2930,  1865,     0,  2137,     0,     0,  2138,  1857,     0,  1857,
    1859,  4509,  4511,  4511,  2132,  2133,     0,     0,     0,  1153,
       0,  1866,     0,     0,     0,     0,     0,     0,     0,  2134,
       0,     0,     0,  2139,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1857,  2135,     0,     0,  2136,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2137,     0,     0,  2138,  1857,     0,     0,     0,  2139,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,     0,
    1866,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1857,     0,   687,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1857,     0,     0,     0,     0,  4582,
       0,  2140,  2141,  2142,     0,  2143,  2144,  2145,  2146,  2147,
    2148,     0,     0,     0,     0,     0,  1153,     0,     0,     0,
       0,     0,     0,     0,     0,  2139,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,     0,     0,     0,
       0,  3434,     0,     0,     0,     0,  2140,  2141,  2142,     0,
    2143,  2144,  2145,  2146,  2147,  2148,     0,     0,  1857,     0,
       0,     0,     0,     0,     0,  1866,     0,     0,     0,  1865,
       0,  1857,     0,     0,     0,     0,     0,     0,     0,  1153,
       0,  4626,     0,  1153,  1857,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1536,     0,  1153,  1153,  4642,
       0,  4644,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2140,  2141,  2142,     0,  2143,  2144,  2145,
    2146,  2147,  2148,     0,     0,     0,     0,  1153,  1153,     0,
       0,     0,  1153,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1153,  1153,  1153,  1153,     0,     0,
       0,     0,  1857,     0,     0,     0,     0,  1153,     0,     0,
    1153,     0,  1153,     0,     0,     0,     0,     0,     0,     0,
       0,  1857,  1153,  1153,     0,     0,  1153,     0,     0,     0,
       0,     0,  1859,     0,     0,   687,     0,     0,     0,  1153,
       0,  1153,     0,     0,  4511,  1153,  1857,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1153,  1865,     0,     0,     0,     0,     0,     0,     0,
    1859,  1859,  1153,  1859,  1153,  1153,  1153,     0,     0,     0,
       0,     0,  1857,  4725,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1865,     0,     0,  1153,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1153,     0,     0,     0,     0,  1153,   704,     0,     0,     0,
       0,     0,  1153,  1859,     0,  1859,   704,  2123,  1153,     0,
    2124,     0,     0,     0,     0,     0,     0,  4759,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2125,     0,     0,
       0,     0,     0,     0,     0,  2127,     0,     0,     0,     0,
       0,  2128,   704,     0,     0,     0,     0,     0,     0,  1859,
       0,     0,  2292,   901,     0,     0,   704,     0,  4793,     0,
       0,     0,   901,     0,     0,  2129,   704,     0,  1153,     0,
    1859,     0,     0,     0,     0,     0,     0,     0,   687,     0,
       0,     0,     0,     0,     0,  1865,   704,  1866,     0,     0,
       0,     0,     0,     0,     0,     0,  1865,  1859,     0,     0,
       0,     0,   901,     0,     0,     0,     0,     0,     0,     0,
    1859,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,     0,     0,     0,  1866,  1866,     0,  1866,     0,
    3740,     0,     0,     0,     0,  1072,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1857,     0,     0,     0,     0,  3755,     0,     0,     0,     0,
       0,     0,  3763,     0,     0,  2130,  3768,     0,     0,  2131,
       0,     0,     0,     0,  1859,     0,     0,     0,  1866,     0,
    1866,  3780,     0,     0,     0,     0,     0,  1859,     0,     0,
    2132,  2133,     0,     0,     0,     0,     0,     0,     0,     0,
    1859,     0,     0,     0,  1865,  2134,     0,     0,     0,     0,
    3812,     0,     0,  3813,     0,     0,     0,     0,   687,     0,
       0,     0,     0,     0,  1866,  1865,     0,     0,     0,  1867,
    2135,     0,     0,  2136,     0,     0,     0,  1865,     0,     0,
       0,     0,     0,     0,     0,  1866,  2137,     0,     0,  2138,
    1536,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1859,     0,
       0,     0,  1866,     0,     0,  1865,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1866,     0,  1859,     0,     0,
       0,     0,     0,  1857,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1121,     0,  1859,     0,     0,     0,     0,     0,     0,     0,
       0,  2139,     0,     0,     0,     0,  1857,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3843,     0,  1859,  1866,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1866,     0,     0,     0,  3918,  3919,  3920,     0,
       0,     0,     0,     0,     0,  1866,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1867,     0,     0,
       0,     0,     0,     0,   701,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1153,     0,     0,     0,  2140,
    2141,  2142,     0,  2143,  2144,  2145,  2146,  2147,  2148,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1865,   687,
       0,     0,     0,     0,     0,     0,  1857,     0,     0,     0,
    1153,     0,     0,  1866,     0,     0,     0,  1857,     0,  1153,
       0,     0,     0,     0,     0,  1153,     0,  1153,     0,     0,
       0,     0,  1866,  1153,     0,     0,  1153,  1153,  1153,  1153,
    1153,  1153,  1153,  1153,  1153,  1153,     0,     0,     0,  1153,
    1153,     0,     0,     0,     0,     0,     0,  1866,     0,     0,
       0,     0,  1153,     0,     0,     0,  1153,     0,     0,     0,
    1153,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1153,     0,     0,  1153,     0,  1153,     0,     0,     0,     0,
       0,     0,     0,  1866,  1153,  1153,  1153,     0,     0,     0,
    1153,  1865,     0,  1153,     0,     0,  1859,     0,     0,     0,
       0,     0,     0,  1153,     0,     0,     0,  2123,     0,     0,
    2124,     0,     0,  1153,     0,  1857,     0,     0,     0,     0,
       0,  1153,     0,  1153,     0,     0,     0,  2125,     0,     0,
    3892,     0,     0,     0,     0,  2127,  1857,     0,     0,     0,
       0,  2128,     0,     0,     0,     0,     0,     0,  1857,     0,
       0,   901,   901,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2129,     0,  1153,  1121,     0,
       0,     0,     0,  1153,     0,     0,     0,     0,     0,  1153,
       0,     0,     0,     0,  1865,     0,  1857,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4126,     0,     0,  1153,     0,     0,  1865,     0,     0,
       0,     0,     0,  1867,     0,     0,     0,     0,     0,     0,
    4152,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1865,     0,  1859,
       0,     0,     0,  4163,     0,   687,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2393,     0,     0,     0,     0,  2130,     0,     0,     0,  2131,
       0,  1866,  1859,  1865,     0,     0,     0,  1865,  1865,     0,
       0,     0,     0,     0,     0,     0,  1867,  1167,     0,     0,
    2132,  2133,     0,     0,     0,     0,  1193,     0,  1195,     0,
    1197,     0,  1199,     0,     0,  2134,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1247,     0,     0,     0,     0,     0,     0,  1254,     0,
    2135,     0,     0,  2136,     0,     0,     0,  1269,  1270,  1857,
       0,     0,  1272,     0,     0,     0,  2137,     0,     0,  2138,
       0,     0,     0,  1867,     0,     0,     0,     0,  1121,     0,
     901,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1867,     0,     0,  1301,     0,     0,     0,     0,
       0,     0,  1859,     0,     0,     0,     0,     0,  1153,  1321,
    1867,     0,  1323,  1859,  1325,     0,  1328,     0,     0,     0,
       0,     0,     0,     0,     0,  4264,  4265,  4266,  4267,   704,
     901,     0,     0,     0,  1866,     0,     0,     0,  1867,     0,
       0,  2139,     0,     0,   704,     0,   704,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   704,     0,     0,     0,
       0,     0,  1857,     0,     0,     0,     0,  1866,  1153,  1153,
       0,     0,     0,     0,     0,   704,   704,     0,     0,     0,
       0,     0,  1409,  2123,  1410,     0,  2124,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1867,     0,     0,     0,
       0,     0,     0,  2125,     0,     0,     0,     0,     0,     0,
       0,  2127,     0,     0,     0,  1121,     0,  2128,     0,     0,
       0,  1859,     0,     0,     0,     0,     0,     0,  1153,  2140,
    2141,  2142,     0,  2143,  2144,  2145,  2146,  2147,  2148,     0,
       0,  2129,  1859,     0,     0,     0,     0,     0,     0,  1072,
       0,     0,     0,     0,  1859,  1857,     0,     0,     0,     0,
       0,     0,     0,     0,  1153,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1153,  1153,     0,  1866,  1857,     0,
       0,     0,  1153,  1153,     0,     0,     0,  1153,  1866,     0,
       0,     0,  1859,  1153,  1153,     0,     0,  1153,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1857,     0,
       0,     0,  1153,     0,     0,     0,  1153,     0,     0,     0,
    1665,     0,  1667,     0,     0,  1153,  1669,     0,     0,     0,
    1153,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2130,  1153,     0,  1857,  2131,     0,     0,  1857,  1857,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2132,  2133,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1153,  2134,     0,     0,  1800,  1867,     0,     0,     0,     0,
       0,     0,     0,  1216,     0,     0,  1866,     0,     0,     0,
    1813,     0,     0,     0,     0,     0,  2135,     0,     0,  2136,
       0,  1821,  4436,     0,     0,     0,     0,  1866,  1823,     0,
    2858,     0,  2137,     0,     0,  2138,  1217,     0,     0,  1866,
    1874,     0,     0,     0,     0,     0,     0,     0,     0,  1218,
    1219,     0,     0,     0,     0,  1859,     0,     0,  1220,     0,
       0,     0,  1221,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1916,     0,     0,     0,     0,  1866,     0,  1222,
       0,  1860,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1223,     0,     0,     0,     0,     0,     0,  2139,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1224,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1225,
       0,     0,     0,     0,  1226,     0,     0,     0,  1153,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   704,     0,   704,  1227,     0,   704,  1859,   704,
       0,     0,   704,   704,   704,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   704,     0,     0,     0,     0,
    1228,     0,     0,     0,     0,     0,     0,     0,   704,     0,
     704,     0,     0,  1866,     0,  2140,  2141,  2142,     0,  2143,
    2144,  2145,  2146,  2147,  2148,     0,     0,     0,  4543,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1153,     0,     0,  1229,
    1866,     0,     0,     0,     0,  1153,     0,     0,     0,  1860,
    1536,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1859,  1153,  1153,     0,  3018,  1153,   834,     0,     0,
    2393,  3025,     0,     0,     0,     0,     0,  1153,     0,     0,
       0,  1867,  1153,     0,  1859,  1153,     0,     0,     0,     0,
    1153,  1153,  1230,     0,     0,     0,  1231,     0,  1232,     0,
       0,     0,  1158,     0,  1233,     0,     0,  1234,     0,     0,
    1158,     0,     0,     0,  1859,     0,     0,     0,     0,     0,
       0,     0,     0,  1153,     0,     0,     0,     0,     0,     0,
       0,     0,  1235,     0,  1236,     0,     0,     0,  1237,     0,
       0,  1158,     0,  1866,     0,  4629,  1238,  1153,     0,     0,
    1859,  1239,     0,     0,  1859,  1859,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1240,     0,     0,     0,     0,
    1072,     0,     0,  1153,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1158,     0,     0,     0,     0,
       0,     0,     0,     0,  1158,     0,     0,  1867,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   821,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1153,     0,  1866,  2288,     0,     0,
    2288,     0,     0,     0,     0,     0,     0,     0,  2295,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1153,  1866,
       0,  1153,     0,  1153,     0,     0,  2304,     0,     0,   822,
       0,     0,     0,     0,     0,     0,  2393,     0,     0,     0,
    1153,    85,   823,     0,  1153,     0,     0,    89,     0,  1866,
       0,    93,     0,    94,     0,    96,    97,     0,     0,   824,
       0,  2364,     0,     0,     0,   825,   106,     0,     0,     0,
       0,     0,     0,     0,  1158,  1860,     0,     0,     0,     0,
     826,     0,     0,   119,   120,  1866,     0,     0,     0,  1866,
    1866,     0,     0,     0,     0,     0,     0,     0,   827,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1158,   828,
       0,     0,     0,     0,   829,     0,     0,     0,     0,     0,
     830,     0,  1860,     0,  1153,     0,     0,     0,     0,   128,
       0,  1867,     0,     0,     0,   831,     0,     0,     0,   129,
       0,   130,   131,     0,     0,     0,     0,     0,  1860,     0,
       0,     0,  1866,     0,     0,     0,  1091,     0,     0,     0,
     832,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   141,     0,   142,   143,
       0,     0,  1153,     0,   145,     0,   146,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   148,  1153,   149,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   833,
       0,     0,   152,     0,   153,  1860,     0,   156,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   157,
    1153,   158,     0,     0,  1860,   159,     0,   834,     0,  1153,
    2545,   160,     0,     0,     0,     0,     0,     0,   162,     0,
     164,     0,  1860,  2567,     0,     0,   166,  1158,     0,     0,
    1153,  1153,   835,     0,     0,     0,     0,  1158,   836,     0,
     170,     0,     0,  1153,   837,     0,     0,   838,     0,     0,
    1860,     0,     0,     0,     0,     0,     0,     0,     0,  1869,
    2858,  2858,  2858,     0,     0,     0,     0,  2611,     0,     0,
       0,  2615,   839,     0,   840,     0,     0,  1153,   841,     0,
    2624,     0,  2626,     0,  2627,     0,   842,  1153,     0,  2628,
       0,   843,  1158,   183,   184,     0,     0,     0,     0,   185,
       0,     0,   844,     0,     0,     0,     0,   186,  1860,     0,
       0,     0,     0,     0,     0,   845,     0,     0,   191,     0,
       0,     0,   704,     0,   704,     0,     0,     0,   704,     0,
     704,     0,     0,   704,     0,     0,     0,   704,  2656,     0,
       0,     0,     0,     0,     0,     0,  1153,     0,     0,     0,
       0,     0,     0,     0,     0,   202,     0,  1153,  1158,     0,
       0,     0,     0,     0,     0,     0,   204,     0,     0,     0,
       0,   205,     0,   206,     0,     0,     0,     0,   207,     0,
       0,     0,     0,   208,     0,     0,   210,     0,     0,     0,
     212,     0,     0,  1867,     0,   213,   214,     0,     0,     0,
       0,     0,     0,   215,     0,     0,   217,     0,     0,     0,
       0,     0,     0,   220,     0,     0,     0,  1869,     0,     0,
       0,     0,     0,     0,     0,   222,     0,     0,     0,     0,
       0,  2393,  3025,     0,  3025,     0,     0,     0,     0,     0,
       0,     0,   227,     0,   228,  1158,     0,     0,     0,     0,
       0,   230,     0,     0,     0,     0,     0,   231,     0,     0,
       0,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1158,   235,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1867,     0,  1867,     0,     0,     0,
       0,     0,  2859,     0,     0,     0,     0,  1860,     0,     0,
       0,  1158,  1158,     0,  1158,     0,     0,     0,   245,     0,
       0,     0,  -132,     0,     0,     0,     0,     0,     0,     0,
       0,  1158,     0,     0,     0,     0,     0,     0,     0,     0,
    1867,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1867,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1158,     0,     0,     0,     0,     0,  3025,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3025,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1158,     0,     0,     0,  1158,  1158,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1121,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2946,  2947,     0,     0,     0,  2950,  2951,
       0,     0,  2954,     0,     0,  1867,     0,     0,     0,     0,
       0,     0,  2964,     0,     0,     0,     0,     0,  3025,  2972,
       0,     0,     0,     0,     0,  2977,  2978,     0,     0,     0,
       0,  1867,     0,  1869,     0,     0,  2992,     0,  2994,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3014,     0,     0,     0,     0,  3016,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1869,     0,     0,  3032,  3033,  3036,  3038,     0,     0,     0,
    3045,  3048,     0,     0,     0,     0,     0,     0,  3059,  1867,
       0,  3063,     0,     0,     0,  3067,  1869,  1860,     0,     0,
       0,     0,  1860,  1860,     0,     0,     0,     0,  1867,     0,
    3090,     0,     0,  1860,     0,     0,     0,     0,     0,     0,
    3093,     0,  3095,     0,     0,     0,     0,     0,     0,     0,
    3098,  3099,  3100,  1867,  3102,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3125,  3126,  3127,
       0,     0,     0,     0,     0,     0,     0,  3132,  3133,     0,
       0,     0,     0,  1869,     0,     0,     0,     0,     0,  1867,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1869,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1869,     0,     0,     0,     0,     0,     0,     0,     0,  2858,
       0,     0,     0,  3192,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1869,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1860,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1158,     0,     0,     0,     0,     0,  1869,     0,     0,  1158,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1860,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1121,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3025,     0,     0,
       0,     0,     0,     0,     0,     0,  3317,     0,     0,     0,
       0,     0,     0,  1158,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1860,     0,     0,     0,     0,     0,  1158,
    1158,     0,     0,     0,     0,     0,     0,  1158,     0,     0,
    1158,     0,     0,  1158,     0,     0,     0,     0,     0,     0,
       0,  1158,  1158,     0,     0,     0,     0,     0,     0,  1158,
       0,     0,  1158,  1158,  1158,  1158,     0,     0,     0,     0,
       0,     0,  1158,  1158,     0,  1158,     0,  1158,  1158,     0,
       0,  1158,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1869,  1158,     0,     0,     0,
       0,  1158,     0,     0,     0,  1158,     0,     0,     0,  1158,
       0,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,
    1867,  1158,     0,     0,     0,     0,     0,  1158,     0,     0,
    1158,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       4,     0,     0,  2393,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       5,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       6,     7,     0,     0,     0,     0,     0,     0,     9,    10,
       0,  1158,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,     0,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,     0,     0,
       0,    45,     0,  3527,  3528,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1867,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1867,     0,     0,     0,     0,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3564,
    3566,     0,     0,  3566,     0,     0,     0,  3573,  3574,  3575,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2858,     0,     0,  1158,  1860,  2858,     0,     0,  1158,
       0,     0,     0,     0,     0,  1158,     0,     0,  2858,     0,
       0,  3593,  3594,  3595,  3596,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
       0,     0,     0,  1860,  1860,  1869,  1860,     0,     0,     0,
    1869,  1869,     0,     0,     0,    48,     0,  3621,     0,     0,
       0,  1869,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1867,     0,     0,    49,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1867,     0,     0,  1860,    50,  1860,     0,
       0,     0,     0,     0,     0,  1867,     0,     0,     0,     0,
    3653,     0,     0,     0,     0,  3655,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      51,     0,     0,    52,     0,     0,     0,     0,     0,     0,
       0,     0,  1860,  1867,     0,     0,     0,     0,    53,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1860,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3736,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3743,  1158,     0,  1869,     0,     0,
    1860,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1506,     0,  1860,     0,     0,     0,     0,     0,     0,
    3762,     0,   901,     0,     0,     0,     0,     0,     0,     0,
       0,    54,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1576,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   901,     0,
       0,  3805,     0,     0,     0,     0,  1869,     0,     0,  4434,
       0,     0,    55,     0,  3814,     0,     0,  1860,     0,     0,
       0,     0,     0,     0,     0,    56,     0,     0,     0,     0,
    1860,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      57,     0,     0,  1860,     0,     0,  1867,     0,     0,     0,
       0,     0,  1158,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    58,     0,     0,     0,
       0,     0,    59,     0,     0,     0,    60,    61,    62,    63,
      64,     0,     0,    65,    66,  1336,     0,     0,     0,     0,
      71,  1337,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1869,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1860,     0,     0,     0,  1158,     0,     0,     0,  1158,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1860,     0,     0,  1158,  1158,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3025,
       0,     0,     0,     0,     0,  1860,     0,     0,     0,     0,
       0,     0,     0,  1158,  1158,     0,     0,     0,  1158,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1158,  1158,  1158,  1158,     0,     0,     0,     0,     0,     0,
       0,  1860,     0,  1158,     0,     0,  1158,     0,  1158,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1158,  1158,
       0,     0,  1158,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1158,     0,  1158,     0,     0,
       0,  1158,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3025,     0,     0,     0,     0,  1158,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1158,     0,
    1158,  1158,  1158,     0,     0,  1867,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1158,  4012,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1867,  1158,     0,     0,     0,
       0,  1158,     0,     0,     0,     0,     0,     0,  1158,     0,
       0,     0,     0,     0,  1158,     0,     0,     0,     0,  4033,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1867,     0,     0,     0,  1867,  1867,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2064,     0,     0,     0,     0,     0,     0,  4061,
       0,     0,     0,     0,  4068,  4069,     0,  4071,  4072,  4073,
    4074,  4075,  4076,  4077,  1158,     0,     0,     0,     0,  1860,
    2087,     0,  4084,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1869,     0,     0,     0,     0,  4434,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2112,  2113,
       0,  2115,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2154,     0,
       0,  1869,  1869,     0,  1869,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4138,  4140,  4142,
       0,     0,  4145,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2207,
       0,     0,     0,     0,  1869,     0,  1869,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2229,     0,
       0,     0,  2239,  2242,     0,     0,     0,     0,     0,     0,
       0,     0,  1860,     0,     0,     0,     0,     0,     0,  3566,
    1869,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1869,     0,     0,     0,  1860,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1869,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1869,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1869,     0,     0,     0,  2150,
       0,     0,     0,     0,     0,  1860,     0,     0,  1869,     0,
       0,     0,     0,     0,     0,     0,  1860,     0,     0,     0,
       0,  1869,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1158,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2150,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1158,     0,     0,  1869,
       0,  4329,     0,     0,     0,  1158,     0,     0,     0,     0,
       0,  1158,     0,  1158,     0,     0,     0,     0,  1869,  1158,
    4340,  4341,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,
    1158,  1158,  4350,  4351,  1860,  1158,  1158,     0,     0,     0,
       0,     0,     0,  1869,     0,     0,     0,     0,  1158,     0,
       0,     0,  1158,     0,     0,  1860,  1158,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1158,  1860,     0,  1158,
       0,  1158,     0,     0,     0,     0,     0,     0,     0,  1869,
    1158,  1158,  1158,     0,     0,     0,  1158,     0,     0,  1158,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1158,
       0,     0,     0,     0,     0,  1860,     0,     0,     0,  1158,
       0,     0,     0,     0,     0,     0,     0,  1158,     0,  1158,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4403,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1158,     0,     4,     0,     0,  4424,  1158,
       0,     0,     0,     0,     0,  1158,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     5,     0,     0,     0,     0,
       0,  4444,     0,     0,     0,     6,     7,  1862,     0,     0,
    1158,     0,     0,     9,    10,     0,     0,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,     0,     0,  2726,    37,    38,    39,    40,    41,
      42,    43,    44,     0,     0,     0,    45,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2748,     0,  1860,  2750,
       0,     0,  2761,     0,     0,     0,     0,  1869,     0,  2768,
    2773,     0,     0,     0,     0,  2779,     0,     0,  2784,     0,
       0,     0,     0,   704,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2793,    46,     0,     0,     0,  2800,     0,
       0,     0,  2812,     0,     0,     0,  2819,     0,  2821,  2822,
    2823,  2824,  2825,  2826,  2827,  2828,  2829,     0,  2830,     0,
       0,     0,     0,     0,  1506,     0,     0,  2855,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1862,     0,     0,     0,     0,
       0,  1860,     0,     0,    47,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2150,  4552,
      48,     0,     0,     0,  1158,     0,     0,     0,  1576,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1869,     0,     0,     0,     0,     0,     0,  3566,     0,     0,
       0,     0,    50,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1869,  1158,  1158,     0,     0,     0,     0,
       0,     0,     0,     0,  1860,    51,     0,     0,    52,     0,
       0,     0,     0,     0,     0,     0,     0,  2150,     0,     0,
       0,  1863,     0,    53,     0,     0,     0,  1860,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2150,     0,     0,     0,     0,  2757,     0,     0,     0,     0,
       0,     0,     0,     0,  1158,     0,     0,  1860,     0,     0,
       0,  2975,     0,     0,     0,  2150,  2150,     0,  2150,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1158,     0,     0,  1860,     0,     0,    54,  1860,  1860,     0,
    1158,  1158,     0,  1869,     0,     0,     0,  2150,  1158,  1158,
       0,     0,     0,  1158,  1869,     0,     0,     0,     0,  1158,
    1158,  3566,     0,  1158,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    55,  1158,     0,
       0,     0,  1158,     0,     0,     0,     0,     0,     0,     0,
      56,  1158,     0,     0,     0,     0,  1158,     0,     0,     0,
    2150,     0,     0,     0,     0,    57,     0,     0,  1158,     0,
       0,  1862,     0,     0,     0,     0,     0,     0,     0,  1863,
       0,     0,  2150,     0,     0,     0,     0,     0,     0,  4724,
       0,    58,  2150,     0,     0,  2150,     0,    59,     0,     0,
       0,    60,    61,    62,    63,    64,  1158,     0,    65,    66,
    1336,  1969,     0,     0,     0,    71,     0,     0,  1862,     0,
       0,     0,  1869,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3168,  1869,  1862,     0,  1864,     0,     0,     0,
       0,     0,     0,     0,     0,  1869,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1869,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1862,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1862,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1862,     0,
       0,     0,     0,     0,  1158,     0,     0,     0,     0,  3288,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1862,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1864,     0,     0,     0,     0,  1869,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1862,     0,     0,     0,     0,     0,
       0,  3334,  1158,     0,     0,  1863,  1869,     0,     0,     0,
       0,  1158,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1158,  1158,
       0,     0,  1158,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1158,     0,     0,     0,  2773,  1158,  2773,
    2773,  1158,  1863,     0,     0,     0,  1158,  1158,     0,     0,
    3396,     0,     0,  3399,     0,  3401,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1863,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1158,
       0,     0,  3422,     0,  3424,     0,     0,     0,  3427,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1869,
       0,     0,     0,  1158,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2855,  2855,  2855,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1863,     0,     0,     0,  1158,
       0,  3484,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2229,  1863,     0,     0,     0,  3495,     0,
       0,     0,     0,     0,     0,  2242,     0,     0,     0,     0,
       0,     0,  1863,  1862,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1158,     0,  1869,     0,     0,     0,     0,     0,     0,     0,
    1863,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1158,  1869,     0,  1158,     0,  1158,
    1864,     0,     0,     0,     0,     0,     0,     0,     0,  2150,
       0,  3536,     0,     0,     0,     0,  1158,     0,     0,     0,
    1158,     0,     0,     0,     0,  1869,     0,     0,     0,     0,
       0,  2150,     0,  2150,     0,  2757,  2757,  3370,  1863,     0,
    2757,     0,     0,     0,  2150,     0,     0,  1864,     0,     0,
       0,  2150,     0,     0,     0,     0,  2150,     0,     0,     0,
       0,  1869,  2150,     0,     0,  1869,  1869,  2150,     0,     0,
       0,     0,     0,  1864,     0,     0,  2150,     0,     0,     0,
    2757,  2757,     0,  2150,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2150,     0,     0,     0,     0,
    1158,     0,  2150,     0,  2150,  2150,  2150,  2150,  2150,  2150,
    2150,  2150,  2150,  2150,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1869,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2150,     0,
    1864,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1158,  1864,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1158,     0,     0,     0,  1864,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1864,  1158,     0,     0,     0,
       0,     0,     0,  1862,     0,  1158,     0,     0,  1862,  1862,
       0,     0,     0,     0,     0,     0,     0,  1863,     0,  1862,
       0,     0,     0,     0,     0,     0,  1158,  1158,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1158,
       0,     0,     0,     0,     0,     0,     4,     0,  2150,     0,
       0,     0,     0,  1864,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     5,     0,     0,     0,
       0,     0,     0,  1158,     0,     0,     6,     7,     0,     0,
       0,     0,     0,  1158,     9,    10,     0,     0,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,     0,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,     0,     0,     0,    45,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1158,     0,     0,  1862,     0,     0,     0,     0,
       0,     0,     0,  1158,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3844,     0,    46,     0,     0,     0,     0,
       0,     0,  3847,     0,     0,     0,     0,     0,  3848,     0,
    3849,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3867,  3868,  1862,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2779,     0,     0,     0,     0,     0,     0,
       0,  2150,  1864,  3896,     0,    47,  3899,     0,  3901,     0,
       0,     0,     0,     0,     0,     0,     0,  3905,     0,     0,
       0,    48,     0,  3910,     0,     0,  3913,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1863,     0,     0,
       0,    49,  1863,  1863,     0,     0,  3942,     0,     0,     0,
       0,     0,     0,  1863,  3954,     0,  2855,     0,     0,     0,
       0,     0,     0,    50,     0,     0,     0,     0,     0,  1862,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    51,     0,     0,    52,
    3971,     0,     0,     0,     0,     0,  1506,     0,     0,     0,
       0,     0,  1576,     0,    53,     0,     0,     0,     0,     0,
       0,  2150,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2150,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1863,
       0,     0,     0,     0,     0,     0,     0,    54,  3370,  3370,
       0,  2757,     0,     0,  2757,  2757,  2757,  2757,  2757,  2757,
    2757,  2757,  2757,  2757,  3370,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    55,  2150,
       0,     0,  2150,     0,  2150,     0,     0,     0,     0,  3370,
    3370,    56,     0,     0,     0,     0,     0,     0,  1863,     0,
       0,     0,     0,  2757,  2757,  2150,    57,  2150,     0,     0,
    2150,     0,  1864,     0,     0,     0,     0,  1864,  1864,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1864,     0,
       0,     0,    58,     0,     0,     0,     0,     0,    59,     0,
       0,     0,    60,    61,    62,    63,    64,     0,     0,    65,
      66,  1336,  2637,     0,     0,     0,    71,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2150,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2150,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1863,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1862,     0,     0,     0,     0,     0,     0,     0,  2150,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4195,  4196,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1862,
    1862,     0,  1862,     0,  1864,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4227,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1862,     0,  1862,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1864,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4245,  4247,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1862,     0,
    4254,     0,     0,     0,     0,     0,  4259,  4260,     0,     0,
    4262,     0,     0,     0,     0,     0,     0,     0,     0,  1862,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2855,     0,
       0,     0,     0,  2855,     0,     0,  1862,     0,     0,     0,
       0,     0,     0,     0,     0,  2855,  2757,     0,     0,  1862,
       0,     0,     0,     0,     0,     0,     0,     0,  1864,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4316,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1862,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1863,  1862,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1862,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1863,  1863,     0,  1863,  2150,     0,     0,
    2150,  2150,  2150,     0,     0,  3370,     0,     0,     0,     0,
    3370,  3370,  3370,  3370,  3370,  3370,  3370,  3370,  3370,  3370,
    2150,  2150,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1862,     0,     0,
       0,     0,     0,     0,     0,     0,  1863,     0,  1863,  2150,
    2757,  2757,  2150,     0,  2150,     0,  1862,     0,  2150,  3370,
    3370,  4390,     0,  2150,     0,     0,  2150,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1862,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1863,     0,     0,  2150,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2150,     0,     0,
       0,     0,     0,  1863,     0,     0,     0,  1862,     0,     0,
       0,     0,     0,     0,  2150,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1863,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1863,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4470,
    1864,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4487,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1863,  1864,  1864,
       0,  1864,     0,     0,     0,     0,     0,     0,     0,     0,
    1863,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1863,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1864,     0,  1864,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3370,
       0,     0,     0,     0,     0,  1862,     0,     0,     0,     0,
       0,  1863,     0,     0,     0,     0,     0,  1864,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1863,     0,     0,     0,     0,     0,     0,     0,  1864,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2150,  2150,
       0,     0,     0,     0,     0,  1863,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1864,     0,     0,     0,     0,
       0,     0,     0,     0,  2779,     0,     0,     0,  1864,     0,
    2150,     0,     0,     0,  2757,     0,     0,     0,     0,     0,
       0,  1863,     0,  4607,     0,     0,     0,     0,  2150,     0,
    2150,     0,     0,     0,     0,  3370,  3370,  2150,     0,     0,
    2757,  2757,  2150,  2150,     0,  2150,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1864,     0,     0,     0,     0,     0,  1862,     0,
       0,     0,     0,     0,     0,  1864,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1864,  2150,
       0,     0,     0,     0,     0,     0,     0,  4664,     0,     0,
       0,  1862,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1864,     0,     0,     0,
       0,     0,     0,  2150,     0,     0,     0,     0,     0,     0,
    4707,     0,     0,     0,     0,  1864,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1863,
    1864,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1862,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1862,     0,     0,  3370,  2757,     0,     0,     0,
       0,     0,     0,  4745,  4745,     0,  1864,     0,     0,     0,
       0,  3370,  3370,  2150,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2150,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4745,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4790,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1862,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1863,     0,     0,     0,     0,     0,     0,  4745,
       0,  1862,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1862,     0,     0,     0,     0,     0,     0,
    3370,     0,     0,     0,     0,  1863,     0,     0,     0,     0,
    2150,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     4,     0,     0,     0,
       0,  1862,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     5,     0,     0,     0,
       0,     0,     0,     0,  1864,     0,     6,     7,     0,     0,
       0,     0,     0,     0,     9,    10,     0,  2150,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,     0,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,     0,     0,     0,    45,     0,     0,
    2150,     0,     0,     0,     0,  1863,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1863,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2150,     0,
       0,     0,     0,     0,     0,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1862,     0,     0,     0,     0,     0,
       0,     0,     0,  2150,     0,     0,     0,  1864,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,     0,     0,     0,     0,
    1864,     0,     0,     0,  1863,     0,     0,     0,     0,     0,
       0,    48,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1863,     0,     0,     0,     0,
       0,    49,     0,     0,     0,     0,     0,  1863,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    50,     0,     0,     0,  1862,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1863,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    51,     0,     0,    52,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    53,     0,     0,     0,     0,     0,
    1864,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1864,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1862,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1862,     0,     0,     0,    54,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1862,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    55,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1863,  1864,
       0,    56,     0,     0,     0,     0,     0,     0,     0,  1862,
       0,     0,     0,  1862,  1862,     0,    57,     0,     0,     0,
    1864,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1864,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    58,     0,     0,     0,     0,     0,    59,     0,
       0,     0,    60,    61,    62,    63,    64,     0,     0,    65,
      66,  1336,     0,     0,     0,     0,    71,     0,     0,     0,
    1864,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1863,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1863,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1863,     0,     0,
       0,     0,     0,  1864,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1863,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1863,     0,     0,     0,  1863,  1863,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1864,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1864,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   710,
      86,    87,    88,   411,    90,    91,    92,   412,     0,   413,
      95,     0,  1864,    98,    99,   100,   101,   102,   103,   711,
     104,   105,   414,   712,     0,   107,   108,   109,   110,   713,
     714,   112,   113,   114,   115,     0,   116,   715,   716,   415,
     416,     0,  1864,     0,   417,   418,     0,     0,     0,     0,
     419,     0,     0,     0,     0,     0,     0,     0,     0,   420,
       0,   421,     0,   422,   423,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,  1864,     0,
       0,     0,  1864,  1864,     0,   425,   426,   427,   428,   429,
     430,   431,   432,   717,   433,   434,   435,   718,   719,   720,
     721,   722,   723,   724,   436,   437,   725,   438,   439,   133,
     440,   441,   442,   135,   136,   137,   138,   139,   726,   443,
     444,   445,   446,   447,   727,   728,   448,   449,   729,   140,
     451,   730,   452,   453,   454,   455,   144,   731,   456,   732,
     457,   458,   459,   460,   147,   461,   733,   734,   463,   464,
     465,   466,   467,   468,   735,   150,   469,   736,   737,   738,
     739,   151,   740,   741,   742,   470,   471,   472,   473,   474,
     475,   154,   155,   476,   743,   477,   744,   478,   479,   480,
     481,   482,   745,   483,   484,   485,   746,   747,   486,   487,
     488,   489,   490,   748,   491,   492,   493,   749,   494,   495,
     750,   496,   497,   498,   499,   163,   500,   501,   502,   165,
     751,   503,   752,   504,   167,   505,   753,   506,   754,   507,
     168,   755,   169,   508,   509,   510,   756,   511,   171,   757,
     512,   758,   513,   514,   515,   516,   517,   172,   518,   519,
     520,   759,   521,   522,   523,   524,   525,   526,   760,   527,
     173,   174,   761,   528,   529,   530,   762,   175,   763,   176,
     764,   531,   177,   178,   532,   179,   533,   534,   535,   536,
     537,   538,   539,   765,   180,   181,   540,   182,   766,   541,
     542,   543,   767,   768,   544,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,   555,   187,   188,   189,   556,
     557,   190,   769,   558,   559,   192,   560,   770,   193,   561,
     194,   562,   563,   564,   771,   565,   772,   773,   566,   567,
     568,   774,   775,   195,   196,   197,   198,   199,   569,   570,
     571,   572,   573,   574,   575,   776,   576,   200,   577,   201,
     578,   579,   580,   777,   581,   582,   583,   584,   585,   586,
     587,   203,   588,   589,   590,   591,   778,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   779,   602,   603,
     209,   604,   605,   211,   606,   607,   608,   609,   610,   611,
     612,   613,   780,   614,   615,   616,   617,   618,   781,   619,
     216,   620,   621,   218,   622,   219,   782,   623,   624,   625,
     626,   627,   628,   629,   630,   631,   632,   221,   783,   633,
     634,   784,   635,   636,   637,   638,   639,   640,   785,   223,
     224,   786,   787,   642,   225,   643,   226,   788,   644,   645,
     646,   647,   648,   649,   789,   790,   650,   651,   652,   653,
     654,   791,   792,   655,   656,   657,   658,   659,   793,   233,
     794,   661,   234,   662,   663,   664,   795,   796,   665,   797,
     798,   666,   667,   668,   669,   670,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   671,   672,   673,    85,     0,
       0,    86,    87,    88,    89,    90,    91,    92,    93,     0,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     943,   104,   105,   106,     0,     0,   107,   108,   109,   110,
       0,   111,   112,   113,   114,   115,     0,   116,   117,   118,
     119,   120,     0,     0,     0,   121,   122,     0,     0,     0,
       0,   123,     0,     0,     0,     0,     0,     0,     0,     0,
     124,     0,   125,     0,   126,   127,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   129,     0,   130,   131,
       0,     0,     0,     0,     0,     0,     0,     0,   132,     0,
     133,     0,     0,   134,   135,   136,   137,   138,   139,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     140,     0,     0,   141,     0,   142,   143,   144,     0,     0,
       0,   145,     0,   146,     0,   147,     0,     0,     0,     0,
       0,     0,     0,   148,     0,   149,   150,     0,     0,     0,
       0,     0,   151,     0,     0,     0,     0,     0,     0,   152,
       0,   153,   154,   155,   156,     0,     0,     0,     0,     0,
   -1315,     0,     0,     0,     0,     0,   157,     0,   158,     0,
       0,     0,   159,     0,     0,     0,     0,     0,   160,   161,
       0,     0,     0,     0,     0,   162,   163,   164,     0,     0,
     165,     0,     0,   166,     0,   167,     0,     0,     0,     0,
       0,   168,     0,   169,     0,     0,     0,   170,     0,   171,
       0,     0,     0,     0,     0,     0,     0,     0,   172,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   173,   174,     0,     0, -1315,     0,     0,   175,     0,
     176,     0,     0,   177,   178,     0,   179,     0,     0,     0,
       0,     0,     0,     0,     0,   180,   181,     0,   182,     0,
     183,   184,     0,     0,     0,     0,   185,     0,     0,     0,
       0,     0,     0,     0,   186,     0,     0,   187,   188,   189,
       0,     0,   190,     0,     0,   191,   192,     0,     0,   193,
       0,   194,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   195,   196,   197,   198,   199,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   200,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   203,   204,     0,     0,     0,     0,   205,     0,
     206,     0,     0,     0,     0,   207,     0,     0,     0,     0,
     208,   209,     0,   210,   211,     0,     0,   212,     0,     0,
       0,     0,   213,   214,     0,     0,     0,     0,     0,     0,
     215,   216,     0,   217,   218,     0,   219,     0,     0,     0,
     220,     0,     0,     0,     0,     0,     0,     0,   221,     0,
       0,     0,   222,     0,     0,     0,     0,     0,     0,     0,
     223,   224,     0,     0,     0,   225,     0,   226,     0,   227,
       0,   228,     0,     0,     0,   229,     0,     0,   230,     0,
       0, -1315,     0,     0,   231,     0,     0,     0,     0,   232,
     233,     0,     0,   234,     0,     0,     0,     0,     0,     0,
       0,   235,     0,     0,     0,     0,     0,   236,   237,   238,
     239,   240,   241,   242,   243,   244,    86,    87,    88,     0,
      90,    91,    92,     0,     0,     0,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   245,   104,   105,     0,  -132,
       0,   107,   108,   109,   110,     0,   111,   112,   113,   114,
     115,     0,   116,   117,   118,     0,     0,     0,     0,     0,
     121,   122,     0,     0,     0,     0,   123,     0,     0,     0,
       0,     0,     0,     0,     0,   124,     0,   125,     0,   126,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   133,     0,     0,     0,   135,
     136,   137,   138,   139,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   140,     0,     0,     0,     0,
       0,     0,   144,     0,     0,     0,     0,     0,     0,     0,
     147,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   150,     0,     0,     0,     0,     0,   151,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   154,   155,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   161,     0,     0,     0,     0,     0,
       0,   163,     0,     0,     0,   165,     0,     0,     0,     0,
     167,     0,     0,     0,     0,     0,   168,     0,   169,     0,
       0,     0,     0,     0,   171,     0,     0,     0,     0,     0,
       0,     0,     0,   172,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   173,   174,     0,     0,
       0,     0,     0,   175,     0,   176,     0,     0,   177,   178,
       0,   179,     0,     0,     0,     0,     0,     0,     0,     0,
     180,   181,     0,   182,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   187,   188,   189,     0,     0,   190,     0,     0,
       0,   192,     0,     0,   193,     0,   194,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   195,
     196,   197,   198,   199,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   200,     0,   201,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   203,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   209,     0,     0,   211,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   216,     0,     0,   218,
       0,   219,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   221,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   223,   224,     0,     0,     0,
     225,     0,   226,     0,     0,     0,     0,     0,     0,     0,
     229,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   233,     0,     0,   234,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   236,   237,   238,   239,   240,   241,   242,   243,
     244,     0,     0,    86,    87,    88,     0,    90,    91,    92,
       0,     0,     0,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,     0,     0,  2920,   107,   108,
     109,   110,     0,   111,   112,   113,   114,   115,     0,   116,
     117,   118,     0,     0,     0,     0,     0,   121,   122,     0,
       0,     0,     0,   123,     0,     0,     0,     0,     0,     0,
       0,     0,   124,     0,   125,     0,   126,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   133,     0,     0,     0,   135,   136,   137,   138,
     139,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   140,     0,     0,     0,     0,     0,     0,   144,
       0,     0,     0,     0,     0,     0,     0,   147,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   150,     0,
       0,     0,     0,     0,   151,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   154,   155,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   161,     0,     0,     0,     0,     0,     0,   163,     0,
       0,     0,   165,     0,     0,     0,     0,   167,     0,     0,
       0,     0,     0,   168,     0,   169,     0,     0,     0,     0,
       0,   171,     0,     0,     0,     0,     0,     0,     0,     0,
     172,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   173,   174,     0,     0,     0,     0,     0,
     175,     0,   176,     0,     0,   177,   178,     0,   179,     0,
       0,     0,     0,     0,     0,     0,     0,   180,   181,     0,
     182,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   187,
     188,   189,     0,     0,   190,     0,     0,     0,   192,     0,
       0,   193,     0,   194,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   195,   196,   197,   198,
     199,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     200,     0,   201,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   203,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   209,     0,     0,   211,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   216,     0,     0,   218,     0,   219,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     221,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   223,   224,     0,     0,     0,   225,     0,   226,
       0,     0,     0,     0,     0,     0,     0,   229,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,     0,     0,   234,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   236,
     237,   238,   239,   240,   241,   242,   243,   244,     0,   710,
      86,    87,    88,   411,    90,    91,    92,   412,     0,   413,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   711,
     104,   105,   414,   712,  2922,   107,   108,   109,   110,   713,
     714,   112,   113,   114,   115,     0,   116,   715,   716,   415,
     416,     0,     0,     0,   417,   418,     0,     0,     0,     0,
     419,     0,     0,     0,     0,     0,     0,     0,     0,   420,
       0,   421,     0,   422,   423,    35,   424,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1426,  1427,  1428,
      45,  1429,     0,     0,     0,   425,   426,   427,   428,   429,
     430,   431,   432,  2849,   433,   434,   435,     0,     0,     0,
       0,  1430,     0,     0,   436,   437,     0,   438,   439,   133,
     440,   441,   442,   135,  1431,   137,  1432,  1433,     0,   443,
     444,   445,   446,   447,  1434,  1435,   448,   449,  1436,  1437,
     451,     0,   452,   453,   454,   455,  1438,     0,   456,     0,
     457,   458,   459,   460,   147,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,   150,   469,     0,  1439,  1440,
    1441,  1442,  1443,  1444,  1445,   470,   471,   472,   473,   474,
     475,  1446,  1447,   476,     0,   477,     0,   478,   479,   480,
     481,   482,     0,   483,   484,   485,  2850,     0,   486,   487,
    1448,   489,   490,     0,   491,   492,   493,     0,   494,   495,
       0,   496,   497,   498,   499,  1449,   500,   501,   502,  1450,
    1451,   503,     0,   504,  1452,   505,     0,   506,     0,   507,
     168,     0,   169,   508,   509,   510,     0,   511,  1453,     0,
     512,     0,   513,   514,   515,   516,   517,   172,   518,   519,
     520,     0,   521,   522,   523,   524,   525,   526,     0,   527,
     173,   174,     0,   528,   529,   530,  1454,  1455,     0,  1456,
       0,   531,   177,   178,   532,   179,   533,   534,   535,   536,
     537,   538,   539,     0,  1457,   181,   540,   182,     0,   541,
     542,   543,  1458,  1459,   544,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,   555,  1460,   188,  1461,   556,
     557,   190,  1462,   558,   559,   192,   560,  1463,  1464,   561,
    1465,   562,   563,   564,     0,   565,     0,     0,  1466,   567,
     568,     0,     0,   195,   196,   197,   198,  1467,   569,   570,
     571,   572,   573,   574,   575,     0,   576,  1468,   577,   201,
     578,   579,   580,     0,   581,   582,   583,   584,   585,   586,
     587,  1469,   588,   589,   590,   591,     0,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,     0,   602,   603,
     209,   604,   605,  1470,   606,   607,   608,   609,   610,   611,
     612,   613,     0,   614,   615,   616,   617,   618,  1471,   619,
     216,   620,   621,   218,   622,  1472,     0,   623,   624,   625,
     626,   627,   628,   629,   630,   631,   632,  1473,     0,   633,
     634,     0,   635,   636,   637,   638,   639,   640,     0,  1474,
    1475,     0,     0,   642,  1476,   643,  1477,  1478,   644,   645,
     646,   647,   648,   649,     0,  1479,   650,   651,   652,   653,
     654,  1480,     0,   655,   656,   657,   658,   659,   660,  1481,
    2851,   661,   234,   662,   663,   664,     0,     0,   665,     0,
       0,   666,   667,   668,   669,   670,   236,  1482,  1483,  1484,
    1485,  1486,  1487,  1488,  1489,   671,   672,   673,     0,     0,
       0,     0,     0,     0,     0,  1490,  1491,  2852,     0,     0,
       0,     0,     0,     0,  1493,  2853,   710,    86,    87,    88,
     411,    90,    91,    92,   412,     0,   413,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   711,   104,   105,   414,
     712,     0,   107,   108,   109,   110,   713,   714,   112,   113,
     114,   115,     0,   116,   715,   716,   415,   416,     0,     0,
       0,   417,   418,     0,     0,     0,     0,   419,     0,     0,
       0,     0,     0,     0,     0,     0,   420,     0,   421,     0,
     422,   423,    35,   424,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1426,  1427,  1428,    45,  1429,     0,
       0,     0,   425,   426,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,     0,     0,     0,     0,  1430,     0,
       0,   436,   437,     0,   438,   439,   133,   440,   441,   442,
     135,  1431,   137,  1432,  1433,     0,   443,   444,   445,   446,
     447,  1434,  1435,   448,   449,  1436,  1437,   451,     0,   452,
     453,   454,   455,  1438,     0,   456,     0,   457,   458,   459,
     460,   147,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,   150,   469,     0,  1439,  1440,  1441,  1442,  1443,
    1444,  1445,   470,   471,   472,   473,   474,   475,  1446,  1447,
     476,     0,   477,     0,   478,   479,   480,   481,   482,     0,
     483,   484,   485,     0,     0,   486,   487,  1448,   489,   490,
       0,   491,   492,   493,     0,   494,   495,     0,   496,   497,
     498,   499,  1449,   500,   501,   502,  1450,  1451,   503,     0,
     504,  1452,   505,     0,   506,     0,   507,   168,     0,   169,
     508,   509,   510,     0,   511,  1453,     0,   512,     0,   513,
     514,   515,   516,   517,   172,   518,   519,   520,     0,   521,
     522,   523,   524,   525,   526,     0,   527,   173,   174,     0,
     528,   529,   530,  1454,  1455,     0,  1456,     0,   531,   177,
     178,   532,   179,   533,   534,   535,   536,   537,   538,   539,
       0,  1457,   181,   540,   182,     0,   541,   542,   543,  1458,
    1459,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,  1460,   188,  1461,   556,   557,   190,  1462,
     558,   559,   192,   560,  1463,  1464,   561,  1465,   562,   563,
     564,     0,   565,     0,     0,  1466,   567,   568,     0,     0,
     195,   196,   197,   198,  1467,   569,   570,   571,   572,   573,
     574,   575,     0,   576,  1468,   577,   201,   578,   579,   580,
       0,   581,   582,   583,   584,   585,   586,   587,  1469,   588,
     589,   590,   591,     0,   592,   593,   594,   595,   596,   597,
     598,   599,   600,   601,     0,   602,   603,   209,   604,   605,
    1470,   606,   607,   608,   609,   610,   611,   612,   613,     0,
     614,   615,   616,   617,   618,  1471,   619,   216,   620,   621,
     218,   622,  1472,     0,   623,   624,   625,   626,   627,   628,
     629,   630,   631,   632,  1473,     0,   633,   634,     0,   635,
     636,   637,   638,   639,   640,     0,  1474,  1475,     0,     0,
     642,  1476,   643,  1477,  1478,   644,   645,   646,   647,   648,
     649,     0,  1479,   650,   651,   652,   653,   654,  1480,     0,
     655,   656,   657,   658,   659,   660,  1481,     0,   661,   234,
     662,   663,   664,     0,     0,   665,     0,     0,   666,   667,
     668,   669,   670,   236,  1482,  1483,  1484,  1485,  1486,  1487,
    1488,  1489,   671,   672,   673,     0,     0,     0,     0,     0,
       0,     0,  1490,  1491,     0,     0,     0,     0,     0,     0,
       0,  1493,  2759,   710,    86,    87,    88,   411,    90,    91,
      92,   412,     0,   413,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   711,   104,   105,   414,   712,     0,   107,
     108,   109,   110,   713,   714,   112,   113,   114,   115,     0,
     116,   715,   716,   415,   416,     0,     0,     0,   417,   418,
       0,     0,     0,     0,   419,     0,     0,     0,     0,     0,
       0,     0,     0,   420,     0,   421,     0,   422,   423,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   425,
     426,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,     0,     0,     0,     0,     0,     0,     0,   436,   437,
       0,   438,   439,   133,   440,   441,   442,     0,  1835,   137,
    1836,  1837,     0,   443,   444,   445,   446,   447,     0,     0,
     448,   449,  1838,  1839,   451,     0,   452,   453,   454,   455,
       0,     0,   456,     0,   457,   458,   459,   460,   147,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,   150,
     469,     0,     0,     0,     0,   151,     0,     0,     0,   470,
     471,   472,   473,   474,   475,  1840,  1841,   476,     0,   477,
       0,   478,   479,   480,   481,   482,     0,   483,   484,   485,
       0,     0,   486,   487,  1448,   489,   490,     0,   491,   492,
     493,     0,   494,   495,     0,   496,   497,   498,   499,     0,
     500,   501,   502,     0,     0,   503,     0,   504,  1842,   505,
       0,   506,     0,   507,   168,     0,   169,   508,   509,   510,
       0,   511,     0,     0,   512,     0,   513,   514,   515,   516,
     517,   172,   518,   519,   520,  2381,   521,   522,   523,   524,
     525,   526,     0,   527,   173,  2382,     0,   528,   529,   530,
    1454,  1843,     0,  1844,     0,   531,   177,   178,   532,   179,
     533,   534,   535,   536,   537,   538,   539,     0,     0,   181,
     540,   182,     0,   541,   542,   543,     0,     0,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,   555,
    1845,   188,  1846,   556,   557,     0,     0,   558,   559,   192,
     560,     0,     0,   561,  1847,   562,   563,   564,     0,   565,
       0,     0,   566,   567,   568,     0,     0,  2383,   196,   197,
     198,     0,   569,   570,   571,   572,   573,   574,   575,     0,
     576,     0,   577,     0,   578,   579,   580,     0,   581,   582,
     583,   584,   585,   586,   587,  1848,   588,   589,   590,   591,
       0,   592,   593,   594,   595,   596,   597,   598,   599,   600,
     601,     0,   602,   603,   209,   604,   605,     0,   606,   607,
     608,   609,   610,   611,   612,   613,     0,   614,   615,   616,
     617,   618,     0,   619,  2384,   620,   621,   218,   622,  1850,
       0,   623,   624,   625,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,     0,   635,   636,   637,   638,
     639,   640,     0,  1851,  1852,     0,     0,   642,     0,   643,
       0,     0,   644,   645,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,   654,     0,     0,   655,   656,   657,
     658,   659,     0,  1853,  2385,   661,   234,   662,   663,   664,
       0,     0,   665,     0,     0,   666,   667,   668,   669,   670,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   671,
     672,   673,     0,     0,     0,     0,   710,    86,    87,    88,
     411,    90,    91,    92,   412,     0,   413,    95,     0,  2386,
      98,    99,   100,   101,   102,   103,   711,   104,   105,   414,
     712,     0,   107,   108,   109,   110,   713,   714,   112,   113,
     114,   115,     0,   116,   715,   716,   415,   416,     0,     0,
       0,   417,   418,     0,     0,     0,     0,   419,     0,     0,
       0,     0,     0,     0,     0,     0,   420,     0,   421,     0,
     422,   423,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   425,   426,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,     0,     0,     0,     0,     0,     0,
       0,   436,   437,     0,   438,   439,   133,   440,   441,   442,
       0,  1835,   137,  1836,  1837,     0,   443,   444,   445,   446,
     447,     0,     0,   448,   449,  1838,  1839,   451,     0,   452,
     453,   454,   455,     0,     0,   456,     0,   457,   458,   459,
     460,   147,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,   150,   469,     0,     0,     0,     0,   151,     0,
       0,     0,   470,   471,   472,   473,   474,   475,  1840,  1841,
     476,     0,   477,     0,   478,   479,   480,   481,   482,     0,
     483,   484,   485,     0,     0,   486,   487,  1448,   489,   490,
       0,   491,   492,   493,     0,   494,   495,     0,   496,   497,
     498,   499,     0,   500,   501,   502,     0,     0,   503,     0,
     504,  1842,   505,     0,   506,     0,   507,   168,     0,   169,
     508,   509,   510,     0,   511,     0,     0,   512,     0,   513,
     514,   515,   516,   517,   172,   518,   519,   520,  2381,   521,
     522,   523,   524,   525,   526,     0,   527,   173,  2382,     0,
     528,   529,   530,  1454,  1843,     0,  1844,     0,   531,   177,
     178,   532,   179,   533,   534,   535,   536,   537,   538,   539,
       0,     0,   181,   540,   182,     0,   541,   542,   543,     0,
       0,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,  1845,   188,  1846,   556,   557,     0,     0,
     558,   559,   192,   560,     0,     0,   561,  1847,   562,   563,
     564,     0,   565,     0,     0,   566,   567,   568,     0,     0,
    2383,   196,   197,   198,     0,   569,   570,   571,   572,   573,
     574,   575,     0,   576,     0,   577,     0,   578,   579,   580,
       0,   581,   582,   583,   584,   585,   586,   587,  1848,   588,
     589,   590,   591,     0,   592,   593,   594,   595,   596,   597,
     598,   599,   600,   601,     0,   602,   603,   209,   604,   605,
       0,   606,   607,   608,   609,   610,   611,   612,   613,     0,
     614,   615,   616,   617,   618,     0,   619,  2384,   620,   621,
     218,   622,  1850,     0,   623,   624,   625,   626,   627,   628,
     629,   630,   631,   632,     0,     0,   633,   634,     0,   635,
     636,   637,   638,   639,   640,     0,  1851,  1852,     0,     0,
     642,     0,   643,     0,     0,   644,   645,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,     0,     0,
     655,   656,   657,   658,   659,     0,  1853,  2385,   661,   234,
     662,   663,   664,     0,     0,   665,     0,     0,   666,   667,
     668,   669,   670,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   671,   672,   673,     0,     0,     0,     0,   710,
      86,    87,    88,   411,    90,    91,    92,   412,     0,   413,
      95,     0,  3251,    98,    99,   100,   101,   102,   103,   711,
     104,   105,   414,   712,     0,   107,   108,   109,   110,   713,
     714,   112,   113,   114,   115,     0,   116,   715,   716,   415,
     416,     0,     0,     0,   417,   418,     0,     0,     0,     0,
     419,     0,     0,     0,     0,     0,     0,     0,     0,   420,
       0,   421,     0,   422,   423,    35,   424,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1426,  1427,  1428,
      45,  1429,     0,     0,     0,   425,   426,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,     0,     0,     0,
       0,  1430,     0,     0,   436,   437,     0,   438,   439,   133,
     440,   441,   442,   135,  1431,   137,  1432,  1433,  2769,   443,
     444,   445,   446,   447,  1434,  1435,   448,   449,  1436,  1437,
     451,     0,   452,   453,   454,   455,  1438,     0,   456,     0,
     457,   458,   459,   460,   147,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,   150,   469,     0,  1439,  1440,
    1441,  1442,  1443,  1444,  1445,   470,   471,   472,   473,   474,
     475,  1446,  1447,   476,     0,   477,     0,   478,   479,   480,
     481,   482,     0,   483,   484,   485,     0,     0,   486,   487,
    1448,   489,   490,     0,   491,   492,   493,     0,   494,   495,
       0,   496,   497,   498,   499,  1449,   500,   501,   502,  1450,
    1451,   503,     0,   504,  1452,   505,     0,   506,     0,   507,
     168,  2770,   169,   508,   509,   510,     0,   511,  1453,     0,
     512,     0,   513,   514,   515,   516,   517,   172,   518,   519,
     520,     0,   521,   522,   523,   524,   525,   526,     0,   527,
     173,   174,     0,   528,   529,   530,  1454,  1455,     0,  1456,
       0,   531,   177,   178,   532,   179,   533,   534,   535,   536,
     537,   538,   539,  2771,  1457,   181,   540,   182,     0,   541,
     542,   543,  1458,  1459,   544,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,   555,  1460,   188,  1461,   556,
     557,   190,  1462,   558,   559,   192,   560,  1463,  1464,   561,
    1465,   562,   563,   564,     0,   565,     0,     0,  1466,   567,
     568,     0,     0,   195,   196,   197,   198,  1467,   569,   570,
     571,   572,   573,   574,   575,     0,   576,  1468,   577,   201,
     578,   579,   580,     0,   581,   582,   583,   584,   585,   586,
     587,  1469,   588,   589,   590,   591,     0,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,     0,   602,   603,
     209,   604,   605,  1470,   606,   607,   608,   609,   610,   611,
     612,   613,     0,   614,   615,   616,   617,   618,  1471,   619,
     216,   620,   621,   218,   622,  1472,     0,   623,   624,   625,
     626,   627,   628,   629,   630,   631,   632,  1473,     0,   633,
     634,     0,   635,   636,   637,   638,   639,   640,     0,  1474,
    1475,     0,  2772,   642,  1476,   643,  1477,  1478,   644,   645,
     646,   647,   648,   649,     0,  1479,   650,   651,   652,   653,
     654,  1480,     0,   655,   656,   657,   658,   659,   660,  1481,
       0,   661,   234,   662,   663,   664,     0,     0,   665,     0,
       0,   666,   667,   668,   669,   670,   236,  1482,  1483,  1484,
    1485,  1486,  1487,  1488,  1489,   671,   672,   673,     0,     0,
       0,     0,     0,     0,     0,  1490,  1491,     0,     0,     0,
       0,     0,     0,     0,  1493,   710,    86,    87,    88,   411,
      90,    91,    92,   412,     0,   413,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   711,   104,   105,   414,   712,
       0,   107,   108,   109,   110,   713,   714,   112,   113,   114,
     115,     0,   116,   715,   716,   415,   416,     0,     0,     0,
     417,   418,     0,     0,     0,     0,   419,     0,     0,     0,
       0,     0,     0,     0,     0,   420,     0,   421,     0,   422,
     423,    35,   424,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1426,  1427,  1428,    45,  1429,     0,     0,
       0,   425,   426,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,     0,     0,     0,     0,  1430,     0,     0,
     436,   437,     0,   438,   439,   133,   440,   441,   442,   135,
    1431,   137,  1432,  1433,     0,   443,   444,   445,   446,   447,
    1434,  1435,   448,   449,  1436,  1437,   451,     0,   452,   453,
     454,   455,  1438,     0,   456,     0,   457,   458,   459,   460,
     147,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,   150,   469,     0,  1439,  1440,  1441,  1442,  1443,  1444,
    1445,   470,   471,   472,   473,   474,   475,  1446,  1447,   476,
       0,   477,     0,   478,   479,   480,   481,   482,     0,   483,
     484,   485,     0,     0,   486,   487,  1448,   489,   490,     0,
     491,   492,   493,     0,   494,   495,     0,   496,   497,   498,
     499,  1449,   500,   501,   502,  1450,  1451,   503,     0,   504,
    1452,   505,     0,   506,     0,   507,   168,     0,   169,   508,
     509,   510,     0,   511,  1453,     0,   512,     0,   513,   514,
     515,   516,   517,   172,   518,   519,   520,     0,   521,   522,
     523,   524,   525,   526,     0,   527,   173,   174,     0,   528,
     529,   530,  1454,  1455,     0,  1456,     0,   531,   177,   178,
     532,   179,   533,   534,   535,   536,   537,   538,   539,     0,
    1457,   181,   540,   182,     0,   541,   542,   543,  1458,  1459,
     544,   545,   546,   547,   548,   549,   550,   551,   552,   553,
     554,   555,  1460,   188,  1461,   556,   557,   190,  1462,   558,
     559,   192,   560,  1463,  1464,   561,  1465,   562,   563,   564,
       0,   565,     0,     0,  1466,   567,   568,     0,     0,   195,
     196,   197,   198,  1467,   569,   570,   571,   572,   573,   574,
     575,     0,   576,  1468,   577,   201,   578,   579,   580,     0,
     581,   582,   583,   584,   585,   586,   587,  1469,   588,   589,
     590,   591,     0,   592,   593,   594,   595,   596,   597,   598,
     599,   600,   601,     0,   602,   603,   209,   604,   605,  1470,
     606,   607,   608,   609,   610,   611,   612,   613,   214,   614,
     615,   616,   617,   618,  1471,   619,   216,   620,   621,   218,
     622,  1472,     0,   623,   624,   625,   626,   627,   628,   629,
     630,   631,   632,  1473,     0,   633,   634,   222,   635,   636,
     637,   638,   639,   640,     0,  1474,  1475,     0,     0,   642,
    1476,   643,  1477,  1478,   644,   645,   646,   647,   648,   649,
       0,  1479,   650,   651,   652,   653,   654,  1480,     0,   655,
     656,   657,   658,   659,  1352,  1481,     0,   661,   234,   662,
     663,   664,     0,     0,   665,     0,   235,   666,   667,   668,
     669,   670,   236,  1482,  1483,  1484,  1485,  1486,  1487,  1488,
    1489,   671,   672,   673,     0,     0,     0,     0,     0,     0,
       0,  1490,  1491,     0,     0,     0,     0,     0,     0,     0,
    1493,   710,    86,    87,    88,   411,    90,    91,    92,   412,
       0,   413,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   711,   104,   105,   414,   712,     0,   107,   108,   109,
     110,   713,   714,   112,   113,   114,   115,     0,   116,   715,
     716,   415,   416,     0,     0,     0,   417,   418,     0,     0,
       0,     0,   419,     0,     0,     0,     0,     0,     0,     0,
       0,   420,     0,   421,     0,   422,   423,    35,   424,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1426,
    1427,  1428,    45,  1429,     0,     0,     0,   425,   426,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,     0,
       0,     0,     0,  1430,     0,     0,   436,   437,     0,   438,
     439,   133,   440,   441,   442,   135,  1431,   137,  1432,  1433,
       0,   443,   444,   445,   446,   447,  1434,  1435,   448,   449,
    1436,  1437,   451,     0,   452,   453,   454,   455,  1438,     0,
     456,     0,   457,   458,   459,   460,   147,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,   150,   469,     0,
    1439,  1440,  1441,  1442,  1443,  1444,  1445,   470,   471,   472,
     473,   474,   475,  1446,  1447,   476,     0,   477,     0,   478,
     479,   480,   481,   482,     0,   483,   484,   485,     0,     0,
     486,   487,  1448,   489,   490,     0,   491,   492,   493,     0,
     494,   495,     0,   496,   497,   498,   499,  1449,   500,   501,
     502,  1450,  1451,   503,     0,   504,  1452,   505,     0,   506,
       0,   507,   168,     0,   169,   508,   509,   510,     0,   511,
    1453,     0,   512,     0,   513,   514,   515,   516,   517,   172,
     518,   519,   520,     0,   521,   522,   523,   524,   525,   526,
       0,   527,   173,   174,     0,   528,   529,   530,  1454,  1455,
       0,  1456,     0,   531,   177,   178,   532,   179,   533,   534,
     535,   536,   537,   538,   539,     0,  1457,   181,   540,   182,
       0,   541,   542,   543,  1458,  1459,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,   555,  1460,   188,
    1461,   556,   557,   190,  1462,   558,   559,   192,   560,  1463,
    1464,   561,  1465,   562,   563,   564,     0,   565,     0,     0,
    1466,   567,   568,     0,     0,   195,   196,   197,   198,  1467,
     569,   570,   571,   572,   573,   574,   575,     0,   576,  1468,
     577,   201,   578,   579,   580,     0,   581,   582,   583,   584,
     585,   586,   587,  1469,   588,   589,   590,   591,     0,   592,
     593,   594,   595,   596,   597,   598,   599,   600,   601,     0,
     602,   603,   209,   604,   605,  1470,   606,   607,   608,   609,
     610,   611,   612,   613,     0,   614,   615,   616,   617,   618,
    1471,   619,   216,   620,   621,   218,   622,  1472,     0,   623,
     624,   625,   626,   627,   628,   629,   630,   631,   632,  1473,
       0,   633,   634,     0,   635,   636,   637,   638,   639,   640,
       0,  1474,  1475,     0,     0,   642,  1476,   643,  1477,  1478,
     644,   645,   646,   647,   648,   649,     0,  1479,   650,   651,
     652,   653,   654,  1480,     0,   655,   656,   657,   658,   659,
     660,  1481,     0,   661,   234,   662,   663,   664,     0,     0,
     665,     0,     0,   666,   667,   668,   669,   670,   236,  1482,
    1483,  1484,  1485,  1486,  1487,  1488,  1489,   671,   672,   673,
       0,     0,     0,     0,     0,     0,     0,  1490,  1491,     0,
       0,     0,     0,     0,  2059,  2718,  1493,   710,    86,    87,
      88,   411,    90,    91,    92,   412,     0,   413,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   711,   104,   105,
     414,   712,     0,   107,   108,   109,   110,   713,   714,   112,
     113,   114,   115,     0,   116,   715,   716,   415,   416,     0,
       0,     0,   417,   418,     0,     0,     0,     0,   419,     0,
       0,     0,     0,     0,     0,     0,     0,   420,     0,   421,
       0,   422,   423,    35,   424,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1426,  1427,  1428,    45,  1429,
       0,     0,     0,   425,   426,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,     0,     0,     0,     0,  1430,
       0,     0,   436,   437,     0,   438,   439,   133,   440,   441,
     442,   135,  1431,   137,  1432,  1433,     0,   443,   444,   445,
     446,   447,  1434,  1435,   448,   449,  1436,  1437,   451,     0,
     452,   453,   454,   455,  1438,     0,   456,     0,   457,   458,
     459,   460,   147,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,   150,   469,     0,  1439,  1440,  1441,  1442,
    1443,  1444,  1445,   470,   471,   472,   473,   474,   475,  1446,
    1447,   476,     0,   477,     0,   478,   479,   480,   481,   482,
       0,   483,   484,   485,     0,     0,   486,   487,  1448,   489,
     490,     0,   491,   492,   493,     0,   494,   495,     0,   496,
     497,   498,   499,  1449,   500,   501,   502,  1450,  1451,   503,
       0,   504,  1452,   505,     0,   506,     0,   507,   168,     0,
     169,   508,   509,   510,     0,   511,  1453,     0,   512,     0,
     513,   514,   515,   516,   517,   172,   518,   519,   520,     0,
     521,   522,   523,   524,   525,   526,     0,   527,   173,   174,
       0,   528,   529,   530,  1454,  1455,     0,  1456,     0,   531,
     177,   178,   532,   179,   533,   534,   535,   536,   537,   538,
     539,     0,  1457,   181,   540,   182,     0,   541,   542,   543,
    1458,  1459,   544,   545,   546,   547,   548,   549,   550,   551,
     552,   553,   554,   555,  1460,   188,  1461,   556,   557,   190,
    1462,   558,   559,   192,   560,  1463,  1464,   561,  1465,   562,
     563,   564,     0,   565,     0,     0,  1466,   567,   568,     0,
       0,   195,   196,   197,   198,  1467,   569,   570,   571,   572,
     573,   574,   575,     0,   576,  1468,   577,   201,   578,   579,
     580,     0,   581,   582,   583,   584,   585,   586,   587,  1469,
     588,   589,   590,   591,     0,   592,   593,   594,   595,   596,
     597,   598,   599,   600,   601,     0,   602,   603,   209,   604,
     605,  1470,   606,   607,   608,   609,   610,   611,   612,   613,
       0,   614,   615,   616,   617,   618,  1471,   619,   216,   620,
     621,   218,   622,  1472,     0,   623,   624,   625,   626,   627,
     628,   629,   630,   631,   632,  1473,     0,   633,   634,     0,
     635,   636,   637,   638,   639,   640,     0,  1474,  1475,     0,
       0,   642,  1476,   643,  1477,  1478,   644,   645,   646,   647,
     648,   649,     0,  1479,   650,   651,   652,   653,   654,  1480,
       0,   655,   656,   657,   658,   659,   660,  1481,     0,   661,
     234,   662,   663,   664,     0,     0,   665,     0,     0,   666,
     667,   668,   669,   670,   236,  1482,  1483,  1484,  1485,  1486,
    1487,  1488,  1489,   671,   672,   673,     0,     0,     0,     0,
       0,     0,     0,  1490,  1491,  1492,     0,     0,     0,     0,
       0,     0,  1493,   710,    86,    87,    88,   411,    90,    91,
      92,   412,     0,   413,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   711,   104,   105,   414,   712,     0,   107,
     108,   109,   110,   713,   714,   112,   113,   114,   115,     0,
     116,   715,   716,   415,   416,     0,     0,     0,   417,   418,
       0,     0,     0,     0,   419,     0,     0,     0,     0,     0,
       0,     0,     0,   420,     0,   421,     0,   422,   423,    35,
     424,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1426,  1427,  1428,    45,  1429,     0,     0,     0,   425,
     426,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,     0,     0,     0,     0,  1430,     0,     0,   436,   437,
       0,   438,   439,   133,   440,   441,   442,   135,  1431,   137,
    1432,  1433,     0,   443,   444,   445,   446,   447,  1434,  1435,
     448,   449,  1436,  1437,   451,     0,   452,   453,   454,   455,
    1438,     0,   456,     0,   457,   458,   459,   460,   147,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,   150,
     469,     0,  1439,  1440,  1441,  1442,  1443,  1444,  1445,   470,
     471,   472,   473,   474,   475,  1446,  1447,   476,  1575,   477,
       0,   478,   479,   480,   481,   482,     0,   483,   484,   485,
       0,     0,   486,   487,  1448,   489,   490,     0,   491,   492,
     493,     0,   494,   495,     0,   496,   497,   498,   499,  1449,
     500,   501,   502,  1450,  1451,   503,     0,   504,  1452,   505,
       0,   506,     0,   507,   168,     0,   169,   508,   509,   510,
       0,   511,  1453,     0,   512,     0,   513,   514,   515,   516,
     517,   172,   518,   519,   520,     0,   521,   522,   523,   524,
     525,   526,     0,   527,   173,   174,     0,   528,   529,   530,
    1454,  1455,     0,  1456,     0,   531,   177,   178,   532,   179,
     533,   534,   535,   536,   537,   538,   539,     0,  1457,   181,
     540,   182,     0,   541,   542,   543,  1458,  1459,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,   555,
    1460,   188,  1461,   556,   557,   190,  1462,   558,   559,   192,
     560,  1463,  1464,   561,  1465,   562,   563,   564,     0,   565,
       0,     0,  1466,   567,   568,     0,     0,   195,   196,   197,
     198,  1467,   569,   570,   571,   572,   573,   574,   575,     0,
     576,  1468,   577,   201,   578,   579,   580,     0,   581,   582,
     583,   584,   585,   586,   587,  1469,   588,   589,   590,   591,
       0,   592,   593,   594,   595,   596,   597,   598,   599,   600,
     601,     0,   602,   603,   209,   604,   605,  1470,   606,   607,
     608,   609,   610,   611,   612,   613,     0,   614,   615,   616,
     617,   618,  1471,   619,   216,   620,   621,   218,   622,  1472,
       0,   623,   624,   625,   626,   627,   628,   629,   630,   631,
     632,  1473,     0,   633,   634,     0,   635,   636,   637,   638,
     639,   640,     0,  1474,  1475,     0,     0,   642,  1476,   643,
    1477,  1478,   644,   645,   646,   647,   648,   649,     0,  1479,
     650,   651,   652,   653,   654,  1480,     0,   655,   656,   657,
     658,   659,   660,  1481,     0,   661,   234,   662,   663,   664,
       0,     0,   665,     0,     0,   666,   667,   668,   669,   670,
     236,  1482,  1483,  1484,  1485,  1486,  1487,  1488,  1489,   671,
     672,   673,     0,     0,     0,     0,     0,     0,     0,  1490,
    1491,     0,     0,     0,     0,     0,     0,     0,  1493,   710,
      86,    87,    88,   411,    90,    91,    92,   412,     0,   413,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   711,
     104,   105,   414,   712,     0,   107,   108,   109,   110,   713,
     714,   112,   113,   114,   115,     0,   116,   715,   716,   415,
     416,     0,     0,     0,   417,   418,     0,     0,     0,     0,
     419,     0,     0,     0,     0,     0,     0,     0,     0,   420,
       0,   421,     0,   422,   423,    35,   424,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1426,  1427,  1428,
      45,  1429,     0,     0,     0,   425,   426,   427,   428,   429,
     430,   431,   432,  2237,   433,   434,   435,     0,     0,     0,
       0,  1430,     0,     0,   436,   437,     0,   438,   439,   133,
     440,   441,   442,   135,  1431,   137,  1432,  1433,     0,   443,
     444,   445,   446,   447,  1434,  1435,   448,   449,  1436,  1437,
     451,     0,   452,   453,   454,   455,  1438,     0,   456,     0,
     457,   458,   459,   460,   147,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,   150,   469,     0,  1439,  1440,
    1441,  1442,  1443,  1444,  1445,   470,   471,   472,   473,   474,
     475,  1446,  1447,   476,     0,   477,     0,   478,   479,   480,
     481,   482,     0,   483,   484,   485,     0,     0,   486,   487,
    1448,   489,   490,     0,   491,   492,   493,     0,   494,   495,
       0,   496,   497,   498,   499,  1449,   500,   501,   502,  1450,
    1451,   503,     0,   504,  1452,   505,     0,   506,     0,   507,
     168,     0,   169,   508,   509,   510,     0,   511,  1453,     0,
     512,     0,   513,   514,   515,   516,   517,   172,   518,   519,
     520,     0,   521,   522,   523,   524,   525,   526,     0,   527,
     173,   174,     0,   528,   529,   530,  1454,  1455,     0,  1456,
       0,   531,   177,   178,   532,   179,   533,   534,   535,   536,
     537,   538,   539,     0,  1457,   181,   540,   182,     0,   541,
     542,   543,  1458,  1459,   544,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,   555,  1460,   188,  1461,   556,
     557,   190,  1462,   558,   559,   192,   560,  1463,  1464,   561,
    1465,   562,   563,   564,     0,   565,     0,     0,  1466,   567,
     568,     0,     0,   195,   196,   197,   198,  1467,   569,   570,
     571,   572,   573,   574,   575,     0,   576,  1468,   577,   201,
     578,   579,   580,     0,   581,   582,   583,   584,   585,   586,
     587,  1469,   588,   589,   590,   591,     0,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,     0,   602,   603,
     209,   604,   605,  1470,   606,   607,   608,   609,   610,   611,
     612,   613,     0,   614,   615,   616,   617,   618,  1471,   619,
     216,   620,   621,   218,   622,  1472,     0,   623,   624,   625,
     626,   627,   628,   629,   630,   631,   632,  1473,     0,   633,
     634,     0,   635,   636,   637,   638,   639,   640,     0,  1474,
    1475,     0,     0,   642,  1476,   643,  1477,  1478,   644,   645,
     646,   647,   648,   649,     0,  1479,   650,   651,   652,   653,
     654,  1480,     0,   655,   656,   657,   658,   659,   660,  1481,
       0,   661,   234,   662,   663,   664,     0,     0,   665,     0,
       0,   666,   667,   668,   669,   670,   236,  1482,  1483,  1484,
    1485,  1486,  1487,  1488,  1489,   671,   672,   673,     0,     0,
       0,     0,     0,     0,     0,  1490,  1491,     0,     0,     0,
       0,     0,     0,     0,  1493,   710,    86,    87,    88,   411,
      90,    91,    92,   412,     0,   413,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   711,   104,   105,   414,   712,
       0,   107,   108,   109,   110,   713,   714,   112,   113,   114,
     115,     0,   116,   715,   716,   415,   416,     0,     0,     0,
     417,   418,     0,     0,     0,     0,   419,     0,     0,     0,
       0,     0,     0,     0,     0,   420,     0,   421,     0,   422,
     423,    35,   424,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1426,  1427,  1428,    45,  1429,     0,     0,
       0,   425,   426,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,     0,     0,     0,     0,  1430,     0,     0,
     436,   437,     0,   438,   439,   133,   440,   441,   442,   135,
    1431,   137,  1432,  1433,     0,   443,   444,   445,   446,   447,
    1434,  1435,   448,   449,  1436,  1437,   451,     0,   452,   453,
     454,   455,  1438,     0,   456,     0,   457,   458,   459,   460,
     147,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,   150,   469,     0,  1439,  1440,  1441,  1442,  1443,  1444,
    1445,   470,   471,   472,   473,   474,   475,  1446,  1447,   476,
       0,   477,     0,   478,   479,   480,   481,   482,     0,   483,
     484,   485,     0,     0,   486,   487,  1448,   489,   490,     0,
     491,   492,   493,     0,   494,   495,     0,   496,   497,   498,
     499,  1449,   500,   501,   502,  1450,  1451,   503,     0,   504,
    1452,   505,     0,   506,     0,   507,   168,  2770,   169,   508,
     509,   510,     0,   511,  1453,     0,   512,     0,   513,   514,
     515,   516,   517,   172,   518,   519,   520,     0,   521,   522,
     523,   524,   525,   526,     0,   527,   173,   174,     0,   528,
     529,   530,  1454,  1455,     0,  1456,     0,   531,   177,   178,
     532,   179,   533,   534,   535,   536,   537,   538,   539,     0,
    1457,   181,   540,   182,     0,   541,   542,   543,  1458,  1459,
     544,   545,   546,   547,   548,   549,   550,   551,   552,   553,
     554,   555,  1460,   188,  1461,   556,   557,   190,  1462,   558,
     559,   192,   560,  1463,  1464,   561,  1465,   562,   563,   564,
       0,   565,     0,     0,  1466,   567,   568,     0,     0,   195,
     196,   197,   198,  1467,   569,   570,   571,   572,   573,   574,
     575,     0,   576,  1468,   577,   201,   578,   579,   580,     0,
     581,   582,   583,   584,   585,   586,   587,  1469,   588,   589,
     590,   591,     0,   592,   593,   594,   595,   596,   597,   598,
     599,   600,   601,     0,   602,   603,   209,   604,   605,  1470,
     606,   607,   608,   609,   610,   611,   612,   613,     0,   614,
     615,   616,   617,   618,  1471,   619,   216,   620,   621,   218,
     622,  1472,     0,   623,   624,   625,   626,   627,   628,   629,
     630,   631,   632,  1473,     0,   633,   634,     0,   635,   636,
     637,   638,   639,   640,     0,  1474,  1475,     0,     0,   642,
    1476,   643,  1477,  1478,   644,   645,   646,   647,   648,   649,
       0,  1479,   650,   651,   652,   653,   654,  1480,     0,   655,
     656,   657,   658,   659,   660,  1481,     0,   661,   234,   662,
     663,   664,     0,     0,   665,     0,     0,   666,   667,   668,
     669,   670,   236,  1482,  1483,  1484,  1485,  1486,  1487,  1488,
    1489,   671,   672,   673,     0,     0,     0,     0,     0,     0,
       0,  1490,  1491,     0,     0,     0,     0,     0,     0,     0,
    1493,   710,    86,    87,    88,   411,    90,    91,    92,   412,
       0,   413,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   711,   104,   105,   414,   712,     0,   107,   108,   109,
     110,   713,   714,   112,   113,   114,   115,     0,   116,   715,
     716,   415,   416,     0,     0,     0,   417,   418,     0,     0,
       0,     0,   419,     0,     0,     0,     0,     0,     0,     0,
       0,   420,     0,   421,     0,   422,   423,    35,   424,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1426,
    1427,  1428,    45,  1429,     0,     0,     0,   425,   426,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,     0,
       0,     0,     0,  1430,     0,     0,   436,   437,     0,   438,
     439,   133,   440,   441,   442,   135,  1431,   137,  1432,  1433,
       0,   443,   444,   445,   446,   447,  1434,  1435,   448,   449,
    1436,  1437,   451,     0,   452,   453,   454,   455,  1438,     0,
     456,     0,   457,   458,   459,   460,   147,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,   150,   469,     0,
    1439,  1440,  1441,  1442,  1443,  1444,  1445,   470,   471,   472,
     473,   474,   475,  1446,  1447,   476,     0,   477,     0,   478,
     479,   480,   481,   482,     0,   483,   484,   485,     0,     0,
     486,   487,  1448,   489,   490,     0,   491,   492,   493,     0,
     494,   495,     0,   496,   497,   498,   499,  1449,   500,   501,
     502,  1450,  1451,   503,     0,   504,  1452,   505,     0,   506,
       0,   507,   168,     0,   169,   508,   509,   510,     0,   511,
    1453,     0,   512,     0,   513,   514,   515,   516,   517,   172,
     518,   519,   520,     0,   521,   522,   523,   524,   525,   526,
       0,   527,   173,   174,     0,   528,   529,   530,  1454,  1455,
       0,  1456,     0,   531,   177,   178,   532,   179,   533,   534,
     535,   536,   537,   538,   539,     0,  1457,   181,   540,   182,
       0,   541,   542,   543,  1458,  1459,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,   555,  1460,   188,
    1461,   556,   557,   190,  1462,   558,   559,   192,   560,  1463,
    1464,   561,  1465,   562,   563,   564,     0,   565,     0,     0,
    1466,   567,   568,     0,     0,   195,   196,   197,   198,  1467,
     569,   570,   571,   572,   573,   574,   575,     0,   576,  1468,
     577,   201,   578,   579,   580,     0,   581,   582,   583,   584,
     585,   586,   587,  1469,   588,   589,   590,   591,     0,   592,
     593,   594,   595,   596,   597,   598,   599,   600,   601,     0,
     602,   603,   209,   604,   605,  1470,   606,   607,   608,   609,
     610,   611,   612,   613,     0,   614,   615,   616,   617,   618,
    1471,   619,   216,   620,   621,   218,   622,  1472,     0,   623,
     624,   625,   626,   627,   628,   629,   630,   631,   632,  1473,
       0,   633,   634,     0,   635,   636,   637,   638,   639,   640,
       0,  1474,  1475,     0,     0,   642,  1476,   643,  1477,  1478,
     644,   645,   646,   647,   648,   649,     0,  1479,   650,   651,
     652,   653,   654,  1480,     0,   655,   656,   657,   658,   659,
     660,  1481,  3957,   661,   234,   662,   663,   664,     0,     0,
     665,     0,     0,   666,   667,   668,   669,   670,   236,  1482,
    1483,  1484,  1485,  1486,  1487,  1488,  1489,   671,   672,   673,
       0,     0,     0,     0,     0,     0,     0,  1490,  1491,     0,
       0,     0,     0,     0,     0,     0,  1493,   710,    86,    87,
      88,   411,    90,    91,    92,   412,     0,   413,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   711,   104,   105,
     414,   712,     0,   107,   108,   109,   110,   713,   714,   112,
     113,   114,   115,     0,   116,   715,   716,   415,   416,     0,
       0,     0,   417,   418,     0,     0,     0,     0,   419,     0,
       0,     0,     0,     0,     0,     0,     0,   420,     0,   421,
       0,   422,   423,    35,   424,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1426,  1427,  1428,    45,  1429,
       0,     0,     0,   425,   426,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,     0,     0,     0,     0,  1430,
       0,     0,   436,   437,     0,   438,   439,   133,   440,   441,
     442,   135,  1431,   137,  1432,  1433,     0,   443,   444,   445,
     446,   447,  1434,  1435,   448,   449,  1436,  1437,   451,     0,
     452,   453,   454,   455,  1438,     0,   456,     0,   457,   458,
     459,   460,   147,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,   150,   469,  3970,  1439,  1440,  1441,  1442,
    1443,  1444,  1445,   470,   471,   472,   473,   474,   475,  1446,
    1447,   476,     0,   477,     0,   478,   479,   480,   481,   482,
       0,   483,   484,   485,     0,     0,   486,   487,  1448,   489,
     490,     0,   491,   492,   493,     0,   494,   495,     0,   496,
     497,   498,   499,  1449,   500,   501,   502,  1450,  1451,   503,
       0,   504,  1452,   505,     0,   506,     0,   507,   168,     0,
     169,   508,   509,   510,     0,   511,  1453,     0,   512,     0,
     513,   514,   515,   516,   517,   172,   518,   519,   520,     0,
     521,   522,   523,   524,   525,   526,     0,   527,   173,   174,
       0,   528,   529,   530,  1454,  1455,     0,  1456,     0,   531,
     177,   178,   532,   179,   533,   534,   535,   536,   537,   538,
     539,     0,  1457,   181,   540,   182,     0,   541,   542,   543,
    1458,  1459,   544,   545,   546,   547,   548,   549,   550,   551,
     552,   553,   554,   555,  1460,   188,  1461,   556,   557,   190,
    1462,   558,   559,   192,   560,  1463,  1464,   561,  1465,   562,
     563,   564,     0,   565,     0,     0,  1466,   567,   568,     0,
       0,   195,   196,   197,   198,  1467,   569,   570,   571,   572,
     573,   574,   575,     0,   576,  1468,   577,   201,   578,   579,
     580,     0,   581,   582,   583,   584,   585,   586,   587,  1469,
     588,   589,   590,   591,     0,   592,   593,   594,   595,   596,
     597,   598,   599,   600,   601,     0,   602,   603,   209,   604,
     605,  1470,   606,   607,   608,   609,   610,   611,   612,   613,
       0,   614,   615,   616,   617,   618,  1471,   619,   216,   620,
     621,   218,   622,  1472,     0,   623,   624,   625,   626,   627,
     628,   629,   630,   631,   632,  1473,     0,   633,   634,     0,
     635,   636,   637,   638,   639,   640,     0,  1474,  1475,     0,
       0,   642,  1476,   643,  1477,  1478,   644,   645,   646,   647,
     648,   649,     0,  1479,   650,   651,   652,   653,   654,  1480,
       0,   655,   656,   657,   658,   659,   660,  1481,     0,   661,
     234,   662,   663,   664,     0,     0,   665,     0,     0,   666,
     667,   668,   669,   670,   236,  1482,  1483,  1484,  1485,  1486,
    1487,  1488,  1489,   671,   672,   673,     0,     0,     0,     0,
       0,     0,     0,  1490,  1491,     0,     0,     0,     0,     0,
       0,     0,  1493,   710,    86,    87,    88,   411,    90,    91,
      92,   412,     0,   413,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   711,   104,   105,   414,   712,     0,   107,
     108,   109,   110,   713,   714,   112,   113,   114,   115,     0,
     116,   715,   716,   415,   416,     0,     0,     0,   417,   418,
       0,     0,     0,     0,   419,     0,     0,     0,     0,     0,
       0,     0,     0,   420,     0,   421,     0,   422,   423,    35,
     424,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1426,  1427,  1428,    45,  1429,     0,     0,     0,   425,
     426,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,     0,     0,     0,     0,  1430,     0,     0,   436,   437,
       0,   438,   439,   133,   440,   441,   442,  4742,  1431,   137,
    1432,  1433,     0,   443,   444,   445,   446,   447,  1434,  1435,
     448,   449,  1436,  1437,   451,     0,   452,   453,   454,   455,
    1438,     0,   456,     0,   457,   458,   459,   460,   147,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,   150,
     469,  4743,  1439,  1440,  1441,  1442,  1443,  1444,  1445,   470,
     471,   472,   473,   474,   475,  1446,  1447,   476,     0,   477,
       0,   478,   479,   480,   481,   482,     0,   483,   484,   485,
       0,     0,   486,   487,  1448,   489,   490,     0,   491,   492,
     493,     0,   494,   495,     0,   496,   497,   498,   499,  1449,
     500,   501,   502,  1450,  1451,   503,     0,   504,  1452,   505,
       0,   506,     0,   507,   168,     0,   169,   508,   509,   510,
       0,   511,  1453,     0,   512,     0,   513,   514,   515,   516,
     517,   172,   518,   519,   520,     0,   521,   522,   523,   524,
     525,   526,     0,   527,   173,   174,     0,   528,   529,   530,
    1454,  1455,     0,  1456,     0,   531,   177,   178,   532,   179,
     533,   534,   535,   536,   537,   538,   539,     0,  1457,   181,
     540,   182,     0,   541,   542,   543,  1458,  1459,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,   555,
    1460,   188,  1461,   556,   557,   190,  1462,   558,   559,   192,
     560,  1463,  1464,   561,  1465,   562,   563,   564,     0,   565,
       0,     0,  1466,   567,   568,     0,     0,   195,   196,   197,
     198,  1467,   569,   570,   571,   572,   573,   574,   575,     0,
     576,  1468,   577,   201,   578,   579,   580,     0,   581,   582,
     583,   584,   585,   586,   587,  1469,   588,   589,   590,   591,
       0,   592,   593,   594,   595,   596,   597,   598,   599,   600,
     601,     0,   602,   603,   209,   604,   605,  1470,   606,   607,
     608,   609,   610,   611,   612,   613,     0,   614,   615,   616,
     617,   618,  1471,   619,   216,   620,   621,   218,   622,  1472,
       0,   623,   624,   625,   626,   627,   628,   629,   630,   631,
     632,  1473,     0,   633,   634,     0,   635,   636,   637,   638,
     639,   640,     0,  1474,  1475,     0,     0,   642,  1476,   643,
    1477,  1478,   644,   645,   646,  4744,   648,   649,     0,  1479,
     650,   651,   652,   653,   654,  1480,     0,   655,   656,   657,
     658,   659,   660,  1481,     0,   661,   234,   662,   663,   664,
       0,     0,   665,     0,     0,   666,   667,   668,   669,   670,
     236,  1482,  1483,  1484,  1485,  1486,  1487,  1488,  1489,   671,
     672,   673,     0,     0,     0,     0,     0,     0,     0,  1490,
    1491,     0,     0,     0,     0,     0,     0,     0,  1493,   710,
      86,    87,    88,   411,    90,    91,    92,   412,     0,   413,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   711,
     104,   105,   414,   712,     0,   107,   108,   109,   110,   713,
     714,   112,   113,   114,   115,     0,   116,   715,   716,   415,
     416,     0,     0,     0,   417,   418,     0,     0,     0,     0,
     419,     0,     0,     0,     0,     0,     0,     0,     0,   420,
       0,   421,     0,   422,   423,    35,   424,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1426,  1427,  1428,
      45,  1429,     0,     0,     0,   425,   426,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,     0,     0,     0,
       0,  1430,     0,     0,   436,   437,     0,   438,   439,   133,
     440,   441,   442,   135,  1431,   137,  1432,  1433,     0,   443,
     444,   445,   446,   447,  1434,  1435,   448,   449,  1436,  1437,
     451,     0,   452,   453,   454,   455,  1438,     0,   456,     0,
     457,   458,   459,   460,   147,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,   150,   469,  4743,  1439,  1440,
    1441,  1442,  1443,  1444,  1445,   470,   471,   472,   473,   474,
     475,  1446,  1447,   476,     0,   477,     0,   478,   479,   480,
     481,   482,     0,   483,   484,   485,     0,     0,   486,   487,
    1448,   489,   490,     0,   491,   492,   493,     0,   494,   495,
       0,   496,   497,   498,   499,  1449,   500,   501,   502,  1450,
    1451,   503,     0,   504,  1452,   505,     0,   506,     0,   507,
     168,     0,   169,   508,   509,   510,     0,   511,  1453,     0,
     512,     0,   513,   514,   515,   516,   517,   172,   518,   519,
     520,     0,   521,   522,   523,   524,   525,   526,     0,   527,
     173,   174,     0,   528,   529,   530,  1454,  1455,     0,  1456,
       0,   531,   177,   178,   532,   179,   533,   534,   535,   536,
     537,   538,   539,     0,  1457,   181,   540,   182,     0,   541,
     542,   543,  1458,  1459,   544,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,   555,  1460,   188,  1461,   556,
     557,   190,  1462,   558,   559,   192,   560,  1463,  1464,   561,
    1465,   562,   563,   564,     0,   565,     0,     0,  1466,   567,
     568,     0,     0,   195,   196,   197,   198,  1467,   569,   570,
     571,   572,   573,   574,   575,     0,   576,  1468,   577,   201,
     578,   579,   580,     0,   581,   582,   583,   584,   585,   586,
     587,  1469,   588,   589,   590,   591,     0,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,     0,   602,   603,
     209,   604,   605,  1470,   606,   607,   608,   609,   610,   611,
     612,   613,     0,   614,   615,   616,   617,   618,  1471,   619,
     216,   620,   621,   218,   622,  1472,     0,   623,   624,   625,
     626,   627,   628,   629,   630,   631,   632,  1473,     0,   633,
     634,     0,   635,   636,   637,   638,   639,   640,     0,  1474,
    1475,     0,     0,   642,  1476,   643,  1477,  1478,   644,   645,
     646,  4744,   648,   649,     0,  1479,   650,   651,   652,   653,
     654,  1480,     0,   655,   656,   657,   658,   659,   660,  1481,
       0,   661,   234,   662,   663,   664,     0,     0,   665,     0,
       0,   666,   667,   668,   669,   670,   236,  1482,  1483,  1484,
    1485,  1486,  1487,  1488,  1489,   671,   672,   673,     0,     0,
       0,     0,     0,     0,     0,  1490,  1491,     0,     0,     0,
       0,     0,     0,     0,  1493,   710,    86,    87,    88,   411,
      90,    91,    92,   412,     0,   413,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   711,   104,   105,   414,   712,
       0,   107,   108,   109,   110,   713,   714,   112,   113,   114,
     115,     0,   116,   715,   716,   415,   416,     0,     0,     0,
     417,   418,     0,     0,     0,     0,   419,     0,     0,     0,
       0,     0,     0,     0,     0,   420,     0,   421,     0,   422,
     423,    35,   424,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1426,  1427,  1428,    45,  1429,     0,     0,
       0,   425,   426,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,     0,     0,     0,     0,  1430,     0,     0,
     436,   437,     0,   438,   439,   133,   440,   441,   442,   135,
    1431,   137,  1432,  1433,     0,   443,   444,   445,   446,   447,
    1434,  1435,   448,   449,  1436,  1437,   451,     0,   452,   453,
     454,   455,  1438,     0,   456,     0,   457,   458,   459,   460,
     147,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,   150,   469,     0,  1439,  1440,  1441,  1442,  1443,  1444,
    1445,   470,   471,   472,   473,   474,   475,  1446,  1447,   476,
       0,   477,     0,   478,   479,   480,   481,   482,     0,   483,
     484,   485,     0,     0,   486,   487,  1448,   489,   490,     0,
     491,   492,   493,     0,   494,   495,     0,   496,   497,   498,
     499,  1449,   500,   501,   502,  1450,  1451,   503,     0,   504,
    1452,   505,     0,   506,     0,   507,   168,     0,   169,   508,
     509,   510,     0,   511,  1453,     0,   512,     0,   513,   514,
     515,   516,   517,   172,   518,   519,   520,     0,   521,   522,
     523,   524,   525,   526,     0,   527,   173,   174,     0,   528,
     529,   530,  1454,  1455,     0,  1456,     0,   531,   177,   178,
     532,   179,   533,   534,   535,   536,   537,   538,   539,     0,
    1457,   181,   540,   182,     0,   541,   542,   543,  1458,  1459,
     544,   545,   546,   547,   548,   549,   550,   551,   552,   553,
     554,   555,  1460,   188,  1461,   556,   557,   190,  1462,   558,
     559,   192,   560,  1463,  1464,   561,  1465,   562,   563,   564,
       0,   565,     0,     0,  1466,   567,   568,     0,     0,   195,
     196,   197,   198,  1467,   569,   570,   571,   572,   573,   574,
     575,     0,   576,  1468,   577,   201,   578,   579,   580,     0,
     581,   582,   583,   584,   585,   586,   587,  1469,   588,   589,
     590,   591,     0,   592,   593,   594,   595,   596,   597,   598,
     599,   600,   601,     0,   602,   603,   209,   604,   605,  1470,
     606,   607,   608,   609,   610,   611,   612,   613,     0,   614,
     615,   616,   617,   618,  1471,   619,   216,   620,   621,   218,
     622,  1472,     0,   623,   624,   625,   626,   627,   628,   629,
     630,   631,   632,  1473,     0,   633,   634,     0,   635,   636,
     637,   638,   639,   640,     0,  1474,  1475,     0,     0,   642,
    1476,   643,  1477,  1478,   644,   645,   646,   647,   648,   649,
       0,  1479,   650,   651,   652,   653,   654,  1480,     0,   655,
     656,   657,   658,   659,   660,  1481,     0,   661,   234,   662,
     663,   664,     0,     0,   665,     0,     0,   666,   667,   668,
     669,   670,   236,  1482,  1483,  1484,  1485,  1486,  1487,  1488,
    1489,   671,   672,   673,     0,     0,     0,     0,     0,     0,
       0,  1490,  1491,     0,     0,     0,     0,     0,     0,     0,
    1493,   710,    86,    87,    88,   411,    90,    91,    92,   412,
       0,   413,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   711,   104,   105,   414,   712,     0,   107,   108,   109,
     110,   713,   714,   112,   113,   114,   115,     0,   116,   715,
     716,   415,   416,     0,     0,     0,   417,   418,     0,     0,
       0,     0,   419,     0,     0,     0,     0,     0,     0,     0,
       0,   420,     0,   421,     0,   422,   423,    35,   424,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1426,
    1427,  1428,    45,  1429,     0,     0,     0,   425,   426,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,     0,
       0,     0,     0,  1430,     0,     0,   436,   437,     0,   438,
     439,   133,   440,   441,   442,   135,  1431,   137,  1432,  1433,
       0,   443,   444,   445,   446,   447,  1434,  1435,   448,   449,
    1436,  1437,   451,     0,   452,   453,   454,   455,  1438,     0,
     456,     0,   457,   458,   459,   460,   147,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,   150,   469,     0,
    1439,  1440,  1441,  1442,  1443,  1444,  1445,   470,   471,   472,
     473,   474,   475,  1446,  1447,   476,     0,   477,     0,   478,
     479,   480,   481,   482,     0,   483,   484,   485,     0,     0,
     486,   487,  1448,   489,   490,     0,   491,   492,   493,     0,
     494,   495,     0,   496,   497,   498,   499,  1449,   500,   501,
     502,  1450,  1451,   503,     0,   504,  1452,   505,     0,   506,
       0,   507,   168,     0,   169,   508,   509,   510,     0,   511,
    1453,     0,   512,     0,   513,   514,   515,   516,   517,   172,
     518,   519,   520,     0,   521,   522,   523,   524,   525,   526,
       0,   527,   173,   174,     0,   528,   529,   530,  1454,  1455,
       0,  1456,     0,   531,   177,   178,   532,   179,   533,   534,
     535,   536,   537,   538,   539,     0,  1457,   181,   540,   182,
       0,   541,   542,   543,  1458,  1459,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,   555,  1460,   188,
    1461,   556,   557,   190,  1462,   558,   559,   192,   560,  1463,
    1464,   561,  1465,   562,   563,   564,     0,   565,     0,     0,
    1466,   567,   568,     0,     0,   195,   196,   197,   198,  1467,
     569,   570,   571,   572,   573,   574,   575,     0,   576,  1468,
     577,   201,   578,   579,   580,     0,   581,   582,   583,   584,
     585,   586,   587,  1469,   588,   589,   590,   591,     0,   592,
     593,   594,   595,   596,   597,   598,   599,   600,   601,     0,
     602,   603,   209,   604,   605,  1470,   606,   607,   608,   609,
     610,   611,   612,   613,     0,   614,   615,   616,   617,   618,
    1471,   619,   216,   620,   621,   218,   622,  1472,     0,   623,
     624,   625,   626,   627,   628,   629,   630,   631,   632,  1473,
       0,   633,   634,     0,   635,   636,   637,   638,   639,   640,
       0,  1474,  1475,     0,     0,   642,  1476,   643,  1477,  1478,
     644,   645,   646,   647,   648,   649,     0,  1479,   650,   651,
     652,   653,   654,  1480,     0,   655,   656,   657,   658,   659,
     660,  1481,     0,   661,   234,   662,   663,   664,     0,     0,
     665,     0,     0,   666,   667,   668,   669,   670,  4237,  1482,
    1483,  1484,  1485,  1486,  1487,  1488,  1489,   671,   672,   673,
       0,     0,     0,     0,     0,     0,     0,  1490,  1491,     0,
       0,     0,     0,     0,     0,     0,  1493,   710,    86,    87,
      88,   411,    90,    91,    92,   412,     0,   413,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   711,   104,   105,
     414,   712,     0,   107,   108,   109,   110,   713,   714,   112,
     113,   114,   115,     0,   116,   715,   716,   415,   416,     0,
       0,     0,   417,   418,     0,     0,     0,     0,   419,     0,
       0,     0,     0,     0,     0,     0,     0,   420,     0,   421,
       0,   422,   423,    35,   424,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1426,  1427,  1428,    45,  1429,
       0,     0,     0,   425,   426,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,     0,     0,     0,     0,  1430,
       0,     0,   436,   437,     0,   438,   439,   133,   440,   441,
     442,   135,  1431,   137,  1432,  1433,     0,   443,   444,   445,
     446,   447,  1434,  1435,   448,   449,  1436,  1437,   451,     0,
     452,   453,   454,   455,  1438,     0,   456,     0,   457,   458,
     459,   460,   147,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,   150,   469,     0,  1439,  1440,  1441,  1442,
    1443,  1444,  1445,   470,   471,   472,   473,   474,   475,  1446,
    1447,   476,     0,   477,     0,   478,   479,   480,   481,   482,
       0,   483,   484,   485,     0,     0,   486,   487,  1448,   489,
     490,     0,   491,   492,   493,     0,   494,   495,     0,   496,
     497,   498,   499,  1449,   500,   501,   502,  1450,  1451,   503,
       0,   504,  1452,   505,     0,   506,     0,   507,   168,     0,
     169,   508,   509,   510,     0,   511,  1453,     0,   512,     0,
     513,   514,   515,   516,   517,   172,   518,   519,   520,     0,
     521,   522,   523,   524,   525,   526,     0,   527,   173,   174,
       0,   528,   529,   530,  1454,  1455,     0,  1456,     0,   531,
     177,   178,   532,   179,   533,   534,   535,   536,   537,   538,
     539,     0,  1457,   181,   540,   182,     0,   541,   542,   543,
    1458,  1459,   544,   545,   546,   547,   548,   549,   550,   551,
     552,   553,   554,   555,  1460,   188,  1461,   556,  4246,   190,
    1462,   558,   559,   192,   560,  1463,  1464,   561,  1465,   562,
     563,   564,     0,   565,     0,     0,  1466,   567,   568,     0,
       0,   195,   196,   197,   198,  1467,   569,   570,   571,   572,
     573,   574,   575,     0,   576,  1468,   577,   201,   578,   579,
     580,     0,   581,   582,   583,   584,   585,   586,   587,  1469,
     588,   589,   590,   591,     0,   592,   593,   594,   595,   596,
     597,   598,   599,   600,   601,     0,   602,   603,   209,   604,
     605,  1470,   606,   607,   608,   609,   610,   611,   612,   613,
       0,   614,   615,   616,   617,   618,  1471,   619,   216,   620,
     621,   218,   622,  1472,     0,   623,   624,   625,   626,   627,
     628,   629,   630,   631,   632,  1473,     0,   633,   634,     0,
     635,   636,   637,   638,   639,   640,     0,  1474,  1475,     0,
       0,   642,  1476,   643,  1477,  1478,   644,   645,   646,   647,
     648,   649,     0,  1479,   650,   651,   652,   653,   654,  1480,
       0,   655,   656,   657,   658,   659,   660,  1481,     0,   661,
     234,   662,   663,   664,     0,     0,   665,     0,     0,   666,
     667,   668,   669,   670,   236,  1482,  1483,  1484,  1485,  1486,
    1487,  1488,  1489,   671,   672,   673,     0,     0,     0,     0,
       0,     0,     0,  1490,  1491,     0,     0,     0,     0,     0,
       0,     0,  1493,   710,    86,    87,    88,   411,    90,    91,
      92,   412,     0,   413,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   711,   104,   105,   414,   712,     0,   107,
     108,   109,   110,   713,   714,   112,   113,   114,   115,     0,
     116,   715,   716,   415,   416,     0,     0,     0,   417,   418,
       0,     0,     0,     0,   419,     0,     0,     0,     0,     0,
       0,     0,     0,   420,     0,   421,     0,   422,   423,    35,
     424,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1426,  1427,  1428,    45,  1429,     0,     0,     0,   425,
     426,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,     0,     0,     0,     0,  1430,     0,     0,   436,   437,
       0,   438,   439,   133,   440,   441,   442,   135,  1431,   137,
    1432,  1433,     0,   443,   444,   445,   446,   447,  1434,  1435,
     448,   449,  1436,  1437,   451,     0,   452,   453,   454,   455,
    1438,     0,   456,     0,   457,   458,   459,   460,   147,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,   150,
     469,     0,  1439,  1440,  1441,  1442,  1443,  1444,  1445,   470,
     471,   472,   473,   474,   475,  1446,  1447,   476,     0,   477,
       0,   478,   479,   480,   481,   482,     0,   483,   484,   485,
       0,     0,   486,   487,  1448,   489,   490,     0,   491,   492,
     493,     0,   494,   495,     0,   496,   497,   498,   499,  1449,
     500,   501,   502,  1450,  1451,   503,     0,   504,  1452,   505,
       0,   506,     0,   507,   168,     0,   169,   508,   509,   510,
       0,   511,  1453,     0,   512,     0,   513,   514,   515,   516,
     517,   172,   518,   519,   520,     0,   521,   522,   523,   524,
     525,   526,     0,   527,   173,   174,     0,   528,   529,   530,
    1454,  1455,     0,  1456,     0,   531,   177,   178,   532,   179,
     533,   534,   535,   536,   537,   538,   539,     0,  1457,   181,
     540,   182,     0,   541,   542,   543,  1458,  1459,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,   555,
    1460,   188,  1461,   556,   557,   190,     0,   558,   559,   192,
     560,  1463,  1464,   561,  1465,   562,   563,   564,     0,   565,
       0,     0,  1466,   567,   568,     0,     0,   195,   196,   197,
     198,  1467,   569,   570,   571,   572,   573,   574,   575,     0,
     576,  1468,   577,   201,   578,   579,   580,     0,   581,   582,
     583,   584,   585,   586,   587,  1469,   588,   589,   590,   591,
       0,   592,   593,   594,   595,   596,   597,   598,   599,   600,
     601,     0,   602,   603,   209,   604,   605,  1470,   606,   607,
     608,   609,   610,   611,   612,   613,     0,   614,   615,   616,
     617,   618,  1471,   619,   216,   620,   621,   218,   622,  1472,
       0,   623,   624,   625,   626,   627,   628,   629,   630,   631,
     632,  1473,     0,   633,   634,     0,   635,   636,   637,   638,
     639,   640,     0,  1474,  1475,     0,     0,   642,  1476,   643,
    1477,  1478,   644,   645,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,   654,  1480,     0,   655,   656,   657,
     658,   659,   660,  1481,     0,   661,   234,   662,   663,   664,
       0,     0,   665,     0,     0,   666,   667,   668,   669,   670,
     236,  1482,  1483,  1484,  1485,  1486,  1487,  1488,  1489,   671,
     672,   673,     0,     0,     0,     0,     0,     0,     0,  2752,
    2753,     0,     0,     0,     0,     0,     0,     0,  1493,   710,
      86,    87,    88,   411,    90,    91,    92,   412,     0,   413,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   711,
     104,   105,   414,   712,     0,   107,   108,   109,   110,   713,
     714,   112,   113,   114,   115,     0,   116,   715,   716,   415,
     416,     0,     0,     0,   417,   418,     0,     0,     0,     0,
     419,     0,     0,     0,     0,     0,     0,     0,     0,   420,
       0,   421,     0,   422,   423,    35,   424,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1426,  1427,  1428,
      45,  1429,     0,     0,     0,   425,   426,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,     0,     0,     0,
       0,  1430,     0,     0,   436,   437,     0,   438,   439,   133,
     440,   441,   442, -2532,  1431,   137,  1432,  1433,     0,   443,
     444,   445,   446,   447,  1434,  1435,   448,   449,  1436,  1437,
     451,     0,   452,   453,   454,   455,  1438,     0,   456,     0,
     457,   458,   459,   460,   147,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,   150,   469,  4743,  1439,  1440,
    1441,  1442,  1443,  1444,  1445,   470,   471,   472,   473,   474,
     475,  1446,  1447,   476,     0,   477,     0,   478,   479,   480,
     481,   482,     0,   483,   484,   485,     0,     0,   486,   487,
    1448,   489,   490,     0,   491,   492,   493,     0,   494,   495,
       0,   496,   497,   498,   499,  1449,   500,   501,   502,  1450,
    1451,   503,     0,   504,  1452,   505,     0,   506,     0,   507,
     168,     0,   169,   508,   509,   510,     0,   511,  1453,     0,
     512,     0,   513,   514,   515,   516,   517,     0,   518,   519,
     520,     0,   521,   522,   523,   524,   525,   526,     0,   527,
     173,   174,     0,   528,   529,   530,  1454,  1455,     0,  1456,
       0,   531,   177,   178,   532,   179,   533,   534,   535,   536,
     537,   538,   539,     0,  1457,   181,   540,     0,     0,   541,
     542,   543,  1458,  1459,   544,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,   555,  1460,   188,  1461,   556,
     557,   190,     0,   558,   559,   192,   560,  1463,  1464,   561,
    1465,   562,   563,   564,     0,   565,     0,     0,  1466,   567,
     568,     0,     0,   195,   196,   197,   198,  1467,   569,   570,
     571,   572,   573,   574,   575,     0,   576,  1468,   577,   201,
     578,   579,   580,     0,   581,   582,   583,   584,   585,   586,
     587,  1469,   588,   589,   590,   591,     0,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,     0,   602,   603,
     209,   604,   605,  1470,   606,   607,   608,   609,   610,   611,
     612,   613,     0,   614,   615,   616,   617,   618,  1471,   619,
     216,   620,   621,     0,   622,  1472,     0,   623,   624,   625,
     626,   627,   628,   629,   630,   631,   632,  1473,     0,   633,
     634,     0,   635,   636,   637,   638,   639,   640,     0,  1474,
    1475,     0,     0,   642,  1476,   643,  1477,  1478,   644,   645,
     646,  4744,   648,   649,     0,  1479,   650,   651,   652,   653,
     654,  1480,     0,   655,   656,   657,   658,   659,   660,  1481,
       0,   661,   234,   662,   663,   664,     0,     0,   665,     0,
       0,   666,   667,   668,   669,   670,   236,  1482,  1483,  1484,
    1485,  1486,  1487,  1488,  1489,   671,   672,   673,     0,     0,
       0,     0,     0,     0,     0,  1490,  1491,     0,     0,     0,
       0,     0,     0,     0,  1493,   710,    86,    87,    88,   411,
      90,    91,    92,   412,     0,   413,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   711,   104,   105,   414,   712,
       0,   107,   108,   109,   110,   713,   714,   112,   113,   114,
     115,     0,   116,   715,   716,   415,   416,     0,     0,     0,
     417,   418,     0,     0,     0,     0,   419,     0,     0,     0,
       0,     0,     0,     0,     0,   420,     0,   421,     0,   422,
     423,    35,   424,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1426,  1427,     0,    45,  1429,     0,     0,
       0,   425,   426,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,     0,     0,     0,     0,  1430,     0,     0,
     436,   437,     0,   438,   439,   133,   440,   441,   442,   135,
    1431,   137,  1432,  1433,     0,   443,   444,   445,   446,   447,
    1434,  1435,   448,   449,  1436,  1437,   451,     0,   452,   453,
     454,   455,  1438,     0,   456,     0,   457,   458,   459,   460,
     147,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,   150,   469,     0,  1439,  1440,  1441,  1442,  1443,  1444,
    1445,   470,   471,   472,   473,   474,   475,  1446,  1447,   476,
       0,   477,     0,   478,   479,   480,   481,   482,     0,   483,
     484,   485,     0,     0,   486,   487,  1448,   489,   490,     0,
     491,   492,   493,     0,   494,   495,     0,   496,   497,   498,
     499,  1449,   500,   501,   502,  1450,  1451,   503,     0,   504,
    1452,   505,     0,   506,     0,   507,   168,     0,   169,   508,
     509,   510,     0,   511,  1453,     0,   512,     0,   513,   514,
     515,   516,   517,   172,   518,   519,   520,     0,   521,   522,
     523,   524,   525,   526,     0,   527,   173,   174,     0,   528,
     529,   530,  1454,  1455,     0,  1456,     0,   531,   177,   178,
     532,   179,   533,   534,   535,   536,   537,   538,   539,     0,
    1457,   181,   540,   182,     0,   541,   542,   543,  1458,  1459,
     544,   545,   546,   547,   548,   549,   550,   551,   552,   553,
     554,   555,  1460,   188,  1461,   556,   557,   190,     0,   558,
     559,   192,   560,  1463,  1464,   561,  1465,   562,   563,   564,
       0,   565,     0,     0,   566,   567,   568,     0,     0,   195,
     196,   197,   198,  1467,   569,   570,   571,   572,   573,   574,
     575,     0,   576,  1468,   577,   201,   578,   579,   580,     0,
     581,   582,   583,   584,   585,   586,   587,  1469,   588,   589,
     590,   591,     0,   592,   593,   594,   595,   596,   597,   598,
     599,   600,   601,     0,   602,   603,   209,   604,   605,  1470,
     606,   607,   608,   609,   610,   611,   612,   613,     0,   614,
     615,   616,   617,   618,  1471,   619,   216,   620,   621,   218,
     622,  1472,     0,   623,   624,   625,   626,   627,   628,   629,
     630,   631,   632,  1473,     0,   633,   634,     0,   635,   636,
     637,   638,   639,   640,     0,  1474,  1475,     0,     0,   642,
    1476,   643,  1477,  1478,   644,   645,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,   654,  1480,     0,   655,
     656,   657,   658,   659,   660,  1481,     0,   661,   234,   662,
     663,   664,     0,     0,   665,     0,     0,   666,   667,   668,
     669,   670,   236,  1482,  1483,  1484,  1485,  1486,  1487,  1488,
    1489,   671,   672,   673,     0,     0,     0,   710,    86,    87,
      88,   411,    90,    91,    92,   412,     0,   413,    95,     0,
    1493,    98,    99,   100,   101,   102,   103,   711,   104,   105,
     414,   712,     0,   107,   108,   109,   110,   713,   714,   112,
     113,   114,   115,     0,   116,   715,   716,   415,   416,     0,
       0,     0,   417,   418,     0,     0,     0,     0,   419,     0,
       0,     0,     0,     0,     0,     0,     0,   420,     0,   421,
       0,   422,   423,    35,   424,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1426,  1427,     0,    45,  1429,
       0,     0,     0,   425,   426,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,     0,     0,     0,     0,  1430,
       0,     0,   436,   437,     0,   438,   439,   133,   440,   441,
     442,   135,  1431,   137,  1432,  1433,     0,  3880,   444,   445,
     446,   447,  1434,  1435,   448,   449,  1436,  1437,   451,     0,
     452,   453,   454,   455,  1438,     0,   456,     0,   457,   458,
     459,   460,   147,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,   150,   469,     0,  1439,  1440,  1441,  1442,
    1443,  1444,  1445,   470,   471,   472,   473,   474,   475,  1446,
    1447,   476,     0,   477,     0,   478,   479,   480,   481,   482,
       0,   483,   484,   485,     0,     0,   486,   487,  1448,   489,
     490,     0,   491,   492,   493,     0,   494,   495,     0,   496,
     497,   498,   499,  1449,   500,   501,   502,  1450,  1451,   503,
       0,   504,  1452,   505,     0,   506,     0,   507,   168,     0,
     169,   508,   509,   510,     0,   511,  1453,     0,   512,     0,
     513,   514,   515,   516,   517,   172,   518,   519,   520,     0,
     521,   522,   523,   524,   525,   526,     0,   527,   173,   174,
       0,   528,   529,   530,  1454,  1455,     0,  1456,     0,   531,
     177,   178,   532,   179,   533,   534,   535,   536,   537,   538,
     539,     0,  1457,   181,   540,   182,     0,   541,   542,   543,
    1458,  1459,   544,   545,   546,   547,   548,   549,   550,   551,
     552,   553,   554,   555,  1460,   188,  1461,   556,   557,   190,
       0,   558,   559,   192,   560,  1463,  1464,   561,  1465,   562,
     563,   564,     0,   565,     0,     0,   566,   567,   568,     0,
       0,   195,   196,   197,   198,  1467,   569,   570,   571,   572,
     573,   574,   575,     0,   576,  1468,   577,   201,   578,   579,
     580,     0,   581,   582,   583,   584,   585,   586,   587,  1469,
     588,   589,   590,   591,     0,   592,   593,   594,   595,   596,
     597,   598,   599,   600,   601,     0,   602,   603,   209,   604,
     605,  1470,   606,   607,   608,   609,   610,   611,   612,   613,
       0,   614,   615,   616,   617,   618,  1471,   619,   216,   620,
     621,   218,   622,  1472,     0,   623,   624,   625,   626,   627,
     628,   629,   630,   631,   632,  1473,     0,   633,   634,     0,
     635,   636,   637,   638,   639,   640,     0,  1474,  1475,     0,
       0,   642,  1476,   643,  1477,  1478,   644,   645,   646,   647,
     648,   649,     0,     0,   650,   651,   652,   653,   654,  1480,
       0,   655,   656,   657,   658,   659,   660,  1481,     0,   661,
     234,   662,   663,   664,     0,     0,   665,     0,     0,   666,
     667,   668,   669,   670,   236,  1482,  1483,  1484,  1485,  1486,
    1487,  1488,  1489,   671,   672,   673,     0,     0,     0,   710,
      86,    87,    88,   411,    90,    91,    92,   412,     0,   413,
      95,     0,  1493,    98,    99,   100,   101,   102,   103,   711,
     104,   105,   414,   712,     0,   107,   108,   109,   110,   713,
     714,   112,   113,   114,   115,     0,   116,   715,   716,   415,
     416,     0,     0,     0,   417,   418,     0,     0,     0,     0,
     419,     0,     0,     0,     0,     0,     0,     0,     0,   420,
       0,   421,     0,   422,   423,    35,   424,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1426,  1427,  1428,
      45,  1429,     0,     0,     0,   425,   426,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,     0,     0,     0,
       0,  1430,     0,     0,   436,   437,     0,   438,   439,   133,
     440,   441,   442,     0,  1431,   137,  1432,  1433,     0,   443,
     444,   445,   446,   447,  1434,  1435,   448,   449,  1436,  1437,
     451,     0,   452,   453,   454,   455,  1438,     0,   456,     0,
     457,   458,   459,   460,   147,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,   150,   469,     0,  1439,  1440,
    1441,  1442,  1443,  1444,  1445,   470,   471,   472,   473,   474,
     475,  1446,  1447,   476,     0,   477,     0,   478,   479,   480,
     481,   482,     0,   483,   484,   485,     0,     0,   486,   487,
    1448,   489,   490,     0,   491,   492,   493,     0,   494,     0,
       0,   496,   497,   498,   499,  1449,   500,   501,   502,  1450,
    1451,   503,     0,   504,  1452,   505,     0,   506,     0,   507,
     168,     0,   169,   508,   509,   510,     0,   511,  1453,     0,
     512,     0,   513,   514,   515,   516,   517,     0,   518,   519,
     520,     0,   521,   522,   523,   524,   525,   526,     0,   527,
     173,   174,     0,   528,   529,   530,  1454,  1455,     0,  1456,
       0,   531,   177,   178,   532,   179,   533,   534,   535,   536,
     537,   538,   539,     0,  1457,   181,   540,     0,     0,   541,
     542,   543,  1458,  1459,   544,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,   555,  1460,   188,  1461,   556,
     557,   190,     0,   558,   559,   192,   560,  1463,  1464,   561,
    1465,   562,   563,   564,     0,   565,     0,     0,  1466,   567,
     568,     0,     0,   195,   196,   197,   198,  1467,   569,   570,
     571,   572,   573,   574,   575,     0,   576,  1468,   577,   201,
     578,   579,   580,     0,   581,   582,   583,   584,   585,   586,
     587,  1469,   588,   589,   590,   591,     0,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,     0,   602,   603,
     209,   604,   605,  1470,   606,   607,   608,   609,   610,   611,
     612,   613,     0,   614,   615,   616,   617,   618,  1471,   619,
     216,   620,   621,     0,   622,  1472,     0,   623,   624,   625,
     626,   627,   628,   629,   630,   631,   632,  1473,     0,   633,
     634,     0,   635,   636,   637,   638,   639,   640,     0,  1474,
    1475,     0,     0,   642,  1476,   643,  1477,  1478,   644,   645,
     646,   647,   648,   649,     0,  1479,   650,   651,   652,   653,
     654,  1480,     0,   655,   656,   657,   658,   659,   660,  1481,
       0,   661,   234,   662,   663,   664,     0,     0,   665,     0,
       0,   666,   667,   668,   669,   670,   236,  1482,  1483,  1484,
    1485,  1486,  1487,  1488,  1489,   671,   672,   673,     0,     0,
       0,     0,     0,     0,     0,  1490,  1491,     0,     0,     0,
       0,     0,     0,     0,  1493,   710,    86,    87,    88,   411,
      90,    91,    92,   412,     0,   413,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   711,   104,   105,   414,   712,
       0,   107,   108,   109,   110,   713,   714,   112,   113,   114,
     115,     0,   116,   715,   716,   415,   416,     0,     0,     0,
     417,   418,     0,     0,     0,     0,   419,     0,     0,     0,
       0,     0,     0,     0,     0,   420,     0,   421,     0,   422,
     423,    35,   424,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1426,  1427,  1428,    45,  1429,     0,     0,
       0,   425,   426,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,     0,     0,     0,     0,  1430,     0,     0,
     436,   437,     0,   438,   439,   133,   440,   441,   442,     0,
    1431,   137,  1432,  1433,     0,   443,   444,   445,   446,   447,
    1434,  1435,   448,   449,  1436,  1437,   451,     0,   452,   453,
     454,   455,  1438,     0,   456,     0,   457,   458,   459,   460,
     147,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,   150,   469,     0,  1439,  1440,  1441,  1442,  1443,  1444,
    1445,   470,   471,   472,   473,   474,   475,  1446,  1447,   476,
       0,   477,     0,   478,   479,   480,   481,   482,     0,   483,
     484,   485,     0,     0,   486,   487,  1448,   489,   490,     0,
     491,   492,   493,     0,   494,     0,     0,   496,   497,   498,
     499,  1449,   500,   501,   502,  1450,  1451,   503,     0,   504,
    1452,   505,     0,   506,     0,   507,   168,     0,   169,   508,
     509,   510,     0,   511,  1453,     0,   512,     0,   513,   514,
     515,   516,   517,     0,   518,   519,   520,     0,   521,   522,
     523,   524,   525,   526,     0,   527,   173,   174,     0,   528,
     529,   530,  1454,  1455,     0,  1456,     0,   531,   177,   178,
     532,   179,   533,   534,   535,   536,   537,   538,   539,     0,
    1457,   181,   540,     0,     0,   541,   542,   543,  1458,  1459,
     544,   545,   546,   547,   548,   549,   550,   551,   552,   553,
     554,   555,  1460,   188,  1461,   556,   557,   190,     0,   558,
     559,   192,   560,  1463,  1464,   561,  1465,   562,   563,   564,
       0,   565,     0,     0,  1466,   567,   568,     0,     0,   195,
     196,   197,   198,  1467,   569,   570,   571,   572,   573,   574,
     575,     0,   576,  1468,   577,   201,   578,   579,   580,     0,
     581,   582,   583,   584,   585,   586,   587,  1469,   588,   589,
     590,   591,     0,   592,   593,   594,   595,   596,   597,   598,
     599,   600,   601,     0,   602,   603,   209,   604,   605,  1470,
     606,   607,   608,   609,   610,   611,   612,   613,     0,   614,
     615,   616,   617,   618,  1471,   619,   216,   620,   621,     0,
     622,  1472,     0,   623,   624,   625,   626,   627,   628,   629,
     630,   631,   632,  1473,     0,   633,   634,     0,   635,   636,
     637,   638,   639,   640,     0,  1474,  1475,     0,     0,   642,
    1476,   643,  1477,  1478,   644,   645,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,   654,  1480,     0,   655,
     656,   657,   658,   659,   660,  1481,     0,   661,   234,   662,
     663,   664,     0,     0,   665,     0,     0,   666,   667,   668,
     669,   670,   236,  1482,  1483,  1484,  1485,  1486,  1487,  1488,
    1489,   671,   672,   673,     0,     0,     0,     0,     0,     0,
       0,  2752,  2753,     0,     0,     0,     0,     0,     0,     0,
    1493,   710,    86,    87,    88,   411,    90,    91,    92,   412,
       0,   413,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   711,   104,   105,   414,   712,     0,   107,   108,   109,
     110,   713,   714,   112,   113,   114,   115,     0,   116,   715,
     716,   415,   416,     0,     0,     0,   417,   418,     0,     0,
       0,     0,   419,     0,     0,     0,     0,     0,     0,     0,
       0,   420,     0,   421,     0,   422,   423,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   425,   426,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,     0,
       0,     0,     0,     0,     0,     0,   436,   437,     0,   438,
     439,   133,   440,   441,   442,   135,   136,   137,   138,   139,
       0,   443,   444,   445,   446,   447,     0,  1435,   448,   449,
     450,   140,   451,     0,   452,   453,   454,   455,  1438,     0,
     456,     0,   457,   458,   459,   460,   147,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,   150,   469,     0,
    1439,  1440,  1441,  1442,  1443,  1444,  1445,   470,   471,   472,
     473,   474,   475,   154,   155,   476,     0,   477,     0,   478,
     479,   480,   481,   482,     0,   483,   484,   485,     0,     0,
     486,   487,   488,   489,   490,     0,   491,   492,   493,     0,
     494,   495,     0,   496,   497,   498,   499,   163,   500,   501,
     502,  1450,     0,   503,     0,   504,   167,   505,     0,   506,
       0,   507,   168,     0,   169,   508,   509,   510,     0,   511,
    1453,     0,   512,     0,   513,   514,   515,   516,   517,   172,
     518,   519,   520,     0,   521,   522,   523,   524,   525,   526,
       0,   527,   173,   174,     0,   528,   529,   530,     0,   175,
       0,   176,     0,   531,   177,   178,   532,   179,   533,   534,
     535,   536,   537,   538,   539,     0,  1457,   181,   540,   182,
       0,   541,   542,   543,  1458,  1459,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,   555,   187,   188,
     189,   556,   557,   190,     0,   558,   559,   192,   560,     0,
    1464,   561,   194,   562,   563,   564,     0,   565,     0,  1055,
     566,   567,   568,     0,     0,   195,   196,   197,   198,  1467,
     569,   570,   571,   572,   573,   574,   575,     0,   576,  1468,
     577,   201,   578,   579,   580,     0,   581,   582,   583,   584,
     585,   586,   587,   203,   588,   589,   590,   591,     0,   592,
     593,   594,   595,   596,   597,   598,   599,   600,   601,     0,
     602,   603,   209,   604,   605,   211,   606,   607,   608,   609,
     610,   611,   612,   613,   214,   614,   615,   616,   617,   618,
    1471,   619,   216,   620,   621,   218,   622,   219,     0,   623,
     624,   625,   626,   627,   628,   629,   630,   631,   632,  1473,
       0,   633,   634,   222,   635,   636,   637,   638,   639,   640,
       0,   223,   224,     0,     0,   642,  1476,   643,  1477,     0,
     644,   645,   646,   647,   648,   649,     0,     0,   650,   651,
     652,   653,   654,  1480,     0,   655,   656,   657,   658,   659,
    1352,   233,     0,   661,   234,   662,   663,   664,     0,     0,
     665,     0,   235,   666,   667,   668,   669,   670,   236,  1482,
    1483,  1484,  1485,  1486,  1487,  1488,  1489,   671,   672,   673,
       0,     0,     0,   710,    86,    87,    88,   411,    90,    91,
      92,   412,     0,   413,    95,     0,  3438,    98,    99,   100,
     101,   102,   103,   711,   104,   105,   414,   712,     0,   107,
     108,   109,   110,   713,   714,   112,   113,   114,   115,     0,
     116,   715,   716,   415,   416,     0,     0,     0,   417,   418,
       0,     0,     0,     0,   419,     0,     0,     0,     0,     0,
       0,     0,     0,   420,     0,   421,     0,   422,   423,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   425,
     426,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,     0,     0,     0,     0,     0,     0,     0,   436,   437,
       0,   438,   439,   133,   440,   441,   442,   135,   136,   137,
     138,   139,     0,   443,   444,   445,   446,   447,     0,  1435,
     448,   449,   450,   140,   451,     0,   452,   453,   454,   455,
    1438,     0,   456,     0,   457,   458,   459,   460,   147,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,   150,
     469,     0,  1439,  1440,  1441,  1442,  1443,  1444,  1445,   470,
     471,   472,   473,   474,   475,   154,   155,   476,     0,   477,
       0,   478,   479,   480,   481,   482,     0,   483,   484,   485,
       0,     0,   486,   487,   488,   489,   490,     0,   491,   492,
     493,     0,   494,   495,     0,   496,   497,   498,   499,   163,
     500,   501,   502,  1450,     0,   503,     0,   504,   167,   505,
       0,   506,     0,   507,   168,     0,   169,   508,   509,   510,
       0,   511,  1453,     0,   512,     0,   513,   514,   515,   516,
     517,   172,   518,   519,   520,     0,   521,   522,   523,   524,
     525,   526,     0,   527,   173,   174,     0,   528,   529,   530,
       0,   175,     0,   176,     0,   531,   177,   178,   532,   179,
     533,   534,   535,   536,   537,   538,   539,     0,  1457,   181,
     540,   182,     0,   541,   542,   543,  1458,  1459,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,   555,
     187,   188,   189,   556,   557,   190,     0,   558,   559,   192,
     560,     0,  1464,   561,   194,   562,   563,   564,     0,   565,
       0,  1055,   566,   567,   568,     0,     0,   195,   196,   197,
     198,  1467,   569,   570,   571,   572,   573,   574,   575,     0,
     576,  1468,   577,   201,   578,   579,   580,     0,   581,   582,
     583,   584,   585,   586,   587,   203,   588,   589,   590,   591,
       0,   592,   593,   594,   595,   596,   597,   598,   599,   600,
     601,     0,   602,   603,   209,   604,   605,   211,   606,   607,
     608,   609,   610,   611,   612,   613,     0,   614,   615,   616,
     617,   618,  1471,   619,   216,   620,   621,   218,   622,   219,
       0,   623,   624,   625,   626,   627,   628,   629,   630,   631,
     632,  1473,     0,   633,   634,     0,   635,   636,   637,   638,
     639,   640,     0,   223,   224,     0,     0,   642,  1476,   643,
    1477,     0,   644,   645,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,   654,  1480,     0,   655,   656,   657,
     658,   659,   660,   233,     0,   661,   234,   662,   663,   664,
       0,     0,   665,     0,     0,   666,   667,   668,   669,   670,
     236,  1482,  1483,  1484,  1485,  1486,  1487,  1488,  1489,   671,
     672,   673,     0,     0,     0,   710,    86,    87,    88,   411,
      90,    91,    92,   412,     0,   413,    95,     0,  3438,    98,
      99,   100,   101,   102,   103,   711,   104,   105,   414,   712,
       0,   107,   108,   109,   110,   713,   714,   112,   113,   114,
     115,     0,   116,   715,   716,   415,   416,     0,     0,     0,
     417,   418,     0,     0,     0,     0,   419,     0,     0,     0,
       0,     0,     0,     0,     0,   420,     0,   421,     0,   422,
     423,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,     0,     0,     0,     0,     0,     0,     0,
     436,   437,     0,   438,   439,   133,   440,   441,   442,   135,
     136,   137,   138,   139,     0,   443,   444,   445,   446,   447,
       0,  1435,   448,   449,   450,   140,   451,     0,   452,   453,
     454,   455,  1438,     0,   456,     0,   457,   458,   459,   460,
     147,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,   150,   469,     0,  1439,  1440,  1441,  1442,  1443,  1444,
    1445,   470,   471,   472,   473,   474,   475,   154,   155,   476,
       0,   477,     0,   478,   479,   480,   481,   482,     0,   483,
     484,   485,     0,     0,   486,   487,   488,   489,   490,     0,
     491,   492,   493,     0,   494,   495,     0,   496,   497,   498,
     499,   163,   500,   501,   502,  1450,     0,   503,     0,   504,
     167,   505,     0,   506,     0,   507,   168,     0,   169,   508,
     509,   510,     0,   511,  1453,     0,   512,     0,   513,   514,
     515,   516,   517,   172,   518,   519,   520,     0,   521,   522,
     523,   524,   525,   526,     0,   527,   173,   174,     0,   528,
     529,   530,     0,   175,     0,   176,     0,   531,   177,   178,
     532,   179,   533,   534,   535,   536,   537,   538,   539,     0,
    1457,   181,   540,   182,     0,   541,   542,   543,  1458,  1459,
     544,   545,   546,   547,   548,   549,   550,   551,   552,   553,
     554,   555,   187,   188,   189,   556,   557,   190,     0,   558,
     559,   192,   560,     0,  1464,   561,   194,   562,   563,   564,
       0,   565,     0,     0,   566,   567,   568,     0,     0,   195,
     196,   197,   198,  1467,   569,   570,   571,   572,   573,   574,
     575,     0,   576,  1468,   577,   201,   578,   579,   580,     0,
     581,   582,   583,   584,   585,   586,   587,   203,   588,   589,
     590,   591,     0,   592,   593,   594,   595,   596,   597,   598,
     599,   600,   601,     0,   602,   603,   209,   604,   605,   211,
     606,   607,   608,   609,   610,   611,   612,   613,     0,   614,
     615,   616,   617,   618,  1471,   619,   216,   620,   621,   218,
     622,   219,     0,   623,   624,   625,   626,   627,   628,   629,
     630,   631,   632,  1473,     0,   633,   634,     0,   635,   636,
     637,   638,   639,   640,     0,   223,   224,     0,     0,   642,
    1476,   643,  1477,     0,   644,   645,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,   654,  1480,     0,   655,
     656,   657,   658,   659,   660,   233,     0,   661,   234,   662,
     663,   664,     0,     0,   665,     0,     0,   666,   667,   668,
     669,   670,   236,  1482,  1483,  1484,  1485,  1486,  1487,  1488,
    1489,   671,   672,   673,     0,     0,     0,   710,    86,    87,
      88,   411,    90,    91,    92,   412,     0,   413,    95,     0,
    3995,    98,    99,   100,   101,   102,   103,   711,   104,   105,
     414,   712,     0,   107,   108,   109,   110,   713,   714,   112,
     113,   114,   115,     0,   116,   715,   716,   415,   416,     0,
       0,     0,   417,   418,     0,     0,     0,     0,   419,     0,
       0,     0,     0,     0,     0,     0,     0,   420,     0,   421,
       0,   422,   423,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   425,   426,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,     0,     0,     0,     0,     0,
       0,     0,   436,   437,     0,   438,   439,   133,   440,   441,
     442,   135,   136,   137,   138,   139,     0,   443,   444,   445,
     446,   447,     0,     0,   448,   449,   450,   140,   451,     0,
     452,   453,   454,   455,   144,     0,   456,     0,   457,   458,
     459,   460,   147,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,   150,   469,     0,     0,     0,     0,   151,
       0,     0,     0,   470,   471,   472,   473,   474,   475,   154,
     155,   476,     0,   477,     0,   478,   479,   480,   481,   482,
       0,   483,   484,   485,     0,     0,   486,   487,   488,   489,
     490,     0,   491,   492,   493,     0,   494,   495,     0,   496,
     497,   498,   499,   163,   500,   501,   502,   165,     0,   503,
       0,   504,   167,   505,     0,   506,     0,   507,   168,     0,
     169,   508,   509,   510,     0,   511,   171,     0,   512,     0,
     513,   514,   515,   516,   517,   172,   518,   519,   520,     0,
     521,   522,   523,   524,   525,   526,     0,   527,   173,   174,
       0,   528,   529,   530,     0,   175,     0,   176,     0,   531,
     177,   178,   532,   179,   533,   534,   535,   536,   537,   538,
     539,     0,   180,   181,   540,   182,     0,   541,   542,   543,
       0,     0,   544,   545,   546,   547,   548,   549,   550,   551,
     552,   553,   554,   555,   187,   188,   189,   556,   557,   190,
       0,   558,   559,   192,   560,     0,   193,   561,   194,   562,
     563,   564,     0,   565,     0,     0,   566,   567,   568,     0,
       0,   195,   196,   197,   198,   199,   569,   570,   571,   572,
     573,   574,   575,     0,   576,   200,   577,   201,   578,   579,
     580,     0,   581,   582,   583,   584,   585,   586,   587,   203,
     588,   589,   590,   591,     0,   592,   593,   594,   595,   596,
     597,   598,   599,   600,   601,     0,   602,   603,   209,   604,
     605,   211,   606,   607,   608,   609,   610,   611,   612,   613,
       0,   614,   615,   616,   617,   618,     0,   619,   216,   620,
     621,   218,   622,   219,     0,   623,   624,   625,   626,   627,
     628,   629,   630,   631,   632,   221,     0,   633,   634,     0,
     635,   636,   637,   638,   639,   640,     0,   223,   224,     0,
       0,   642,   225,   643,   226,     0,   644,   645,   646,   647,
     648,   649,     0,     0,   650,   651,   652,   653,   654,     0,
       0,   655,   656,   657,   658,   659,   660,   233,     0,   661,
     234,   662,   663,   664,     0,     0,   665,     0,     0,   666,
     667,   668,   669,   670,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   671,   672,   673,     0,     0,     0,     0,
      86,    87,    88,   411,    90,    91,    92,   412,     0,   413,
      95,     0,  4520,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   414,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   415,
     416,     0,     0,     0,   417,   418,     0,     0,     0,     0,
     419,     0,     0,     0,     0,     0,     0,     0,     0,   420,
       0,   421,     0,   422,   423,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   425,   426,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,     0,     0,     0,
       0,     0,  3924,     0,   436,   437,     0,   438,   439,     0,
     440,   441,   442,   135,   136,     0,   138,   139,     0,   443,
     444,   445,   446,   447,     0,     0,   448,   449,   450,   140,
     451,     0,   452,   453,   454,   455,   144,     0,   456,     0,
     457,   458,   459,   460,     0,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0, -1393,   469,     0,     0,     0,
       0,     0,     0,     0,     0,   470,   471,   472,   473,   474,
     475,   154,   155,   476,     0,   477,     0,   478,   479,   480,
     481,   482,     0,   483,   484,   485,     0,     0,   486,   487,
     488,   489,   490,     0,   491,   492,   493,     0,   494,   495,
       0,   496,   497,   498,   499,   163,   500,   501,   502,   165,
       0,   503,     0,   504,   167,   505,     0,   506,     0,   507,
       0,     0, -1393,   508,   509,   510,     0,   511,   171,     0,
     512,     0,   513,   514,   515,   516,   517,     0,   518,   519,
     520,     0,   521,   522,   523,   524,   525,   526,     0,   527,
   -1393,   174,     0,   528,   529,   530,     0,   175,     0,   176,
       0,   531,     0,     0,   532, -1393,   533,   534,   535,   536,
     537,   538,   539,     0,   180, -1393,   540,     0,     0,   541,
     542,   543,     0,     0,   544,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,   555,   187, -1393,   189,   556,
     557,   190,     0,   558,   559,     0,   560,     0,   193,   561,
     194,   562,   563,   564,     0,   565,     0,     0,   566,   567,
     568,     0,     0,   195,     0,     0,     0,   199,   569,   570,
     571,   572,   573,   574,   575,     0,   576,   200,   577,   201,
     578,   579,   580,     0,   581,   582,   583,   584,   585,   586,
     587,   203,   588,   589,   590,   591,     0,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,     0,   602,   603,
   -1393,   604,   605,   211,   606,   607,   608,   609,   610,   611,
     612,   613,     0,   614,   615,   616,   617,   618,     0,   619,
     216,   620,   621,     0,   622,   219,     0,   623,   624,   625,
     626,   627,   628,   629,   630,   631,   632,   221,     0,   633,
     634,     0,   635,   636,   637,   638,   639,   640,     0,   223,
     224,     0,     0,   642,   225,   643,   226,     0,   644,   645,
     646,   647,   648,   649,     0,     0,   650,   651,   652,   653,
     654,     0,     0,   655,   656,   657,   658,   659,   660,   233,
       0,   661,     0,   662,   663,   664,     0,     0,   665,     0,
       0,   666,   667,   668,   669,   670,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   671,   672,   673,     0,     0,
       0,     0,     0,    86,    87,    88,   411,    90,    91,    92,
     412,     0,   413,    95,     0,  1583,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   414,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   415,   416,     0,     0,     0,   417,   418,     0,
       0,     0,     0,   419,     0,     0,     0,     0,     0,     0,
       0,     0,   420,     0,   421,     0,   422,   423,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
       0,     0,     0,     0,     0,     0,     0,   436,   437,     0,
     438,   439,     0,   440,   441,   442,   135,   136,     0,   138,
     139,     0,   443,   444,   445,   446,   447,     0,     0,   448,
     449,   450,   140,   451,     0,   452,   453,   454,   455,   144,
       0,   456,     0,   457,   458,   459,   460,     0,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   469,
       0,     0,     0,     0,     0,     0,     0,     0,   470,   471,
     472,   473,   474,   475,   154,   155,   476,     0,   477,     0,
     478,   479,   480,   481,   482,     0,   483,   484,   485,     0,
       0,   486,   487,   488,   489,   490,     0,   491,   492,   493,
       0,   494,   495,     0,   496,   497,   498,   499,   163,   500,
     501,   502,   165,     0,   503,     0,   504,   167,   505,     0,
     506,     0,   507,     0,     0,     0,   508,   509,   510,     0,
     511,   171,     0,   512,     0,   513,   514,   515,   516,   517,
       0,   518,   519,   520,     0,   521,   522,   523,   524,   525,
     526,     0,   527,     0,   174,     0,   528,   529,   530,     0,
     175,     0,   176,     0,   531,     0,     0,   532,     0,   533,
     534,   535,   536,   537,   538,   539,     0,   180,     0,   540,
       0,     0,   541,   542,   543,     0,     0,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,   187,
       0,   189,   556,   557,   190,     0,   558,   559,     0,   560,
       0,   193,   561,   194,   562,   563,   564,     0,   565,     0,
       0,   566,   567,   568,     0,     0,   195,     0,     0,     0,
     199,   569,   570,   571,   572,   573,   574,   575,     0,   576,
     200,   577,   201,   578,   579,   580,     0,   581,   582,   583,
     584,   585,   586,   587,   203,   588,   589,   590,   591,     0,
     592,   593,   594,   595,   596,   597,   598,   599,   600,   601,
       0,   602,   603,     0,   604,   605,   211,   606,   607,   608,
     609,   610,   611,   612,   613,     0,   614,   615,   616,   617,
     618,     0,   619,   216,   620,   621,     0,   622,   219,     0,
     623,   624,   625,   626,   627,   628,   629,   630,   631,   632,
     221,     0,   633,   634,     0,   635,   636,   637,   638,   639,
     640,     0,   223,   224,     0,     0,   642,   225,   643,   226,
       0,   644,   645,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,     0,     0,   655,   656,   657,   658,
     659,   660,   233,     0,   661,     0,   662,   663,   664,     0,
       0,   665,     0,     0,   666,   667,   668,   669,   670,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   671,   672,
     673,     0,     0,     0,     0,     0,    86,    87,    88,   411,
      90,    91,    92,   412,     0,   413,    95,     0,  3200,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   414,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   415,   416,     0,     0,     0,
     417,   418,     0,     0,     0,     0,   419,     0,     0,     0,
       0,     0,     0,     0,     0,   420,     0,   421,     0,   422,
     423,    35,   424,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,     0,     0,     0,    45,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,     0,     0,     0,     0,     0,     0,     0,
     436,   437,     0,   438,   439,     0,   440,   441,   442,   135,
     136,     0,   138,   139,     0,   443,   444,   445,   446,   447,
       0,     0,   448,   449,   450,   140,   451,     0,   452,   453,
     454,   455,   144,     0,   456,     0,   457,   458,   459,   460,
       0,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,     0,   469,     0,     0,     0,     0,     0,     0,     0,
       0,   470,   471,   472,   473,   474,   475,   154,   155,   476,
       0,   477,     0,   478,   479,   480,   481,   482,     0,   483,
     484,   485,     0,     0,   486,   487,   488,   489,   490,     0,
     491,   492,   493,     0,   494,   495,     0,   496,   497,   498,
     499,   163,   500,   501,   502,   165,  1984,   503,     0,   504,
     167,   505,     0,   506,     0,   507,     0,     0,     0,   508,
     509,   510,     0,   511,   171,     0,   512,     0,   513,   514,
     515,   516,   517,     0,   518,   519,   520,     0,   521,   522,
     523,   524,   525,   526,     0,   527,     0,   174,     0,   528,
     529,   530,     0,   175,     0,   176,     0,   531,     0,     0,
     532,     0,   533,   534,   535,   536,   537,   538,   539,     0,
     180,     0,   540,     0,     0,   541,   542,   543,     0,     0,
     544,   545,   546,   547,   548,   549,   550,   551,   552,   553,
     554,   555,   187,     0,   189,   556,   557,   190,     0,   558,
     559,     0,   560,     0,   193,   561,   194,   562,   563,   564,
       0,   565,  1985,     0,   566,   567,   568,     0,     0,   195,
       0,     0,     0,   199,   569,   570,   571,   572,   573,   574,
     575,     0,   576,   200,   577,   201,   578,   579,   580,     0,
     581,   582,   583,   584,   585,   586,   587,   203,   588,   589,
     590,   591,     0,   592,   593,   594,   595,   596,   597,   598,
     599,   600,   601,     0,   602,   603,     0,   604,   605,   211,
     606,   607,   608,   609,   610,   611,   612,   613,     0,   614,
     615,   616,   617,   618,     0,   619,   216,   620,   621,     0,
     622,   219,     0,   623,   624,   625,   626,   627,   628,   629,
     630,   631,   632,   221,     0,   633,   634,     0,   635,   636,
     637,   638,   639,   640,     0,   223,   224,     0,     0,   642,
     225,   643,   226,  1986,   644,   645,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,   654,     0,     0,   655,
     656,   657,   658,   659,   660,   233,     0,   661,     0,   662,
     663,   664,     0,     0,   665,     0,     0,   666,   667,   668,
     669,   670,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   671,   672,   673,     0,     0,     0,     0,     0,     0,
       0,   973,  1626,  4101,     0,     0,     0,     0,     0,     0,
    4102,    86,    87,    88,   411,    90,    91,    92,   412,     0,
     413,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   414,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     415,   416,     0,     0,     0,   417,   418,     0,     0,     0,
       0,   419,     0,     0,     0,     0,     0,     0,     0,     0,
     420,     0,   421,     0,   422,   423,    35,     0,     0,     0,
      37,    38,    39,    40,    41,    42,     0,    44,     0,     0,
       0,    45,     0,     0,     0,     0,   425,   426,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,     0,     0,
       0,     0,     0,     0,     0,   436,   437,     0,   438,   439,
       0,   440,   441,   442,   135,   136,     0,   138,   139,     0,
     443,   444,   445,   446,   447,     0,     0,   448,   449,   450,
     140,   451,     0,   452,   453,   454,   455,   144,     0,   456,
       0,   457,   458,   459,   460,     0,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   469,     0,     0,
       0,     0,     0,     0,     0,     0,   470,   471,   472,   473,
     474,   475,   154,   155,   476,     0,   477,     0,   478,   479,
     480,   481,   482,     0,   483,   484,   485,     0,     0,   486,
     487,   488,   489,   490,     0,   491,   492,   493,     0,   494,
     495,     0,   496,   497,   498,   499,   163,   500,   501,   502,
     165,     0,   503,     0,   504,   167,   505,     0,   506,     0,
     507,     0,     0,     0,   508,   509,   510,     0,   511,   171,
       0,   512,     0,   513,   514,   515,   516,   517,     0,   518,
     519,   520,     0,   521,   522,   523,   524,   525,   526,     0,
     527,     0,   174,     0,   528,   529,   530,     0,   175,     0,
     176,     0,   531,     0,     0,   532,     0,   533,   534,   535,
     536,   537,   538,   539,     0,   180,     0,   540,     0,     0,
     541,   542,   543,     0,     0,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,   555,   187,     0,   189,
     556,   557,   190,     0,   558,   559,     0,   560,     0,   193,
     561,   194,   562,   563,   564,     0,   565,     0,     0,   566,
     567,   568,     0,     0,   195,     0,     0,     0,   199,   569,
     570,   571,   572,   573,   574,   575,     0,   576,   200,   577,
     201,   578,   579,   580,     0,   581,   582,   583,   584,   585,
     586,   587,   203,   588,   589,   590,   591,     0,   592,   593,
     594,   595,   596,   597,   598,   599,   600,   601,     0,   602,
     603,     0,   604,   605,   211,   606,   607,   608,   609,   610,
     611,   612,   613,     0,   614,   615,   616,   617,   618,     0,
     619,   216,   620,   621,     0,   622,   219,     0,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   221,     0,
     633,   634,     0,   635,   636,   637,   638,   639,   640,     0,
     223,   224,     0,     0,   642,   225,   643,   226,     0,   644,
     645,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,   654,     0,     0,   655,   656,   657,   658,   659,   660,
     233,     0,   661,     0,   662,   663,   664,     0,     0,   665,
       0,     0,   666,   667,   668,   669,   670,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   671,   672,   673,     0,
       0,     0,     0,    86,    87,    88,   411,    90,    91,    92,
     412,     0,   413,    95,  3701,  3702,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   414,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   415,   416,     0,     0,     0,   417,   418,     0,
       0,     0,     0,   419,     0,     0,     0,     0,     0,     0,
       0,     0,   420,     0,   421,     0,   422,   423,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
     130,   131,     0,     0,     0,     0,     0,   436,   437,     0,
     438,   439,     0,   440,   441,   442,   135,   136,     0,   138,
     139,     0,   443,   444,   445,   446,   447,     0,     0,   448,
     449,   450,   140,   451,     0,   452,   453,   454,   455,   144,
       0,   456,     0,   457,   458,   459,   460,     0,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   469,
       0,     0,     0,     0,     0,     0,     0,     0,   470,   471,
     472,   473,   474,   475,   154,   155,   476,     0,   477,     0,
     478,   479,   480,   481,   482,     0,   483,   484,   485,     0,
       0,   486,   487,   488,   489,   490,     0,   491,   492,   493,
       0,   494,   495,     0,   496,   497,   498,   499,   163,   500,
     501,   502,   165,     0,   503,     0,   504,   167,   505,     0,
     506,     0,   507,     0,     0,     0,   508,   509,   510,     0,
     511,   171,     0,   512,     0,   513,   514,   515,   516,   517,
       0,   518,   519,   520,     0,   521,   522,   523,   524,   525,
     526,     0,   527,     0,   174,     0,   528,   529,   530,     0,
     175,     0,   176,     0,   531,     0,     0,   532,     0,   533,
     534,   535,   536,   537,   538,   539,     0,   180,     0,   540,
       0,     0,   541,   542,   543,     0,     0,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,   187,
       0,   189,   556,   557,   190,     0,   558,   559,     0,   560,
       0,   193,   561,   194,   562,   563,   564,     0,   565,     0,
       0,   566,   567,   568,     0,     0,   195,     0,     0,     0,
     199,   569,   570,   571,   572,   573,   574,   575,     0,   576,
     200,   577,   201,   578,   579,   580,     0,   581,   582,   583,
     584,   585,   586,   587,   203,   588,   589,   590,   591,     0,
     592,   593,   594,   595,   596,   597,   598,   599,   600,   601,
       0,   602,   603,     0,   604,   605,   211,   606,   607,   608,
     609,   610,   611,   612,   613,   214,   614,   615,   616,   617,
     618,     0,   619,   216,   620,   621,     0,   622,   219,     0,
     623,   624,   625,   626,   627,   628,   629,   630,   631,   632,
     221,     0,   633,   634,   222,   635,   636,   637,   638,   639,
     640,     0,   223,   224,     0,     0,   642,   225,   643,   226,
       0,   644,   645,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,     0,     0,   655,   656,   657,   658,
     659,  1352,   233,     0,   661,  1353,   662,   663,   664,     0,
       0,   665,     0,   235,   666,   667,   668,   669,   670,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   671,   672,
     673,     0,     0,     0,     0,    86,    87,    88,   411,    90,
      91,    92,   412,     0,   413,    95,     0,   245,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   414,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   415,   416,     0,     0,     0,   417,
     418,     0,     0,     0,     0,   419,     0,     0,     0,     0,
       0,     0,     0,     0,   420,     0,   421,     0,   422,   423,
      35,     0,     0,     0,    37,    38,    39,    40,    41,    42,
       0,    44,     0,     0,     0,    45,     0,     0,     0,     0,
     425,   426,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,     0,     0,     0,     0,     0,     0,     0,   436,
     437,     0,   438,   439,     0,   440,   441,   442,   135,   136,
       0,   138,   139,     0,   443,   444,   445,   446,   447,     0,
       0,   448,   449,   450,   140,   451,     0,   452,   453,   454,
     455,   144,     0,   456,     0,   457,   458,   459,   460,     0,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
       0,   469,     0,     0,     0,     0,     0,     0,     0,     0,
     470,   471,   472,   473,   474,   475,   154,   155,   476,     0,
     477,     0,   478,   479,   480,   481,   482,     0,   483,   484,
     485,     0,     0,   486,   487,   488,   489,   490,     0,   491,
     492,   493,     0,   494,   495,     0,   496,   497,   498,   499,
     163,   500,   501,   502,   165,     0,   503,     0,   504,   167,
     505,     0,   506,     0,   507,     0,     0,     0,   508,   509,
     510,     0,   511,   171,     0,   512,     0,   513,   514,   515,
     516,   517,     0,   518,   519,   520,     0,   521,   522,   523,
     524,   525,   526,     0,   527,     0,   174,     0,   528,   529,
     530,     0,   175,     0,   176,     0,   531,     0,     0,   532,
       0,   533,   534,   535,   536,   537,   538,   539,     0,   180,
       0,   540,     0,     0,   541,   542,   543,     0,     0,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   187,     0,   189,   556,   557,   190,     0,   558,   559,
       0,   560,     0,   193,   561,   194,   562,   563,   564,     0,
     565,     0,     0,   566,   567,   568,     0,     0,   195,     0,
       0,     0,   199,   569,   570,   571,   572,   573,   574,   575,
       0,   576,   200,   577,   201,   578,   579,   580,     0,   581,
     582,   583,   584,   585,   586,   587,   203,   588,   589,   590,
     591,     0,   592,   593,   594,   595,   596,   597,   598,   599,
     600,   601,     0,   602,   603,     0,   604,   605,   211,   606,
     607,   608,   609,   610,   611,   612,   613,     0,   614,   615,
     616,   617,   618,     0,   619,   216,   620,   621,     0,   622,
     219,     0,   623,   624,   625,   626,   627,   628,   629,   630,
     631,   632,   221,     0,   633,   634,     0,   635,   636,   637,
     638,   639,   640,     0,   223,   224,     0,     0,   642,   225,
     643,   226,     0,   644,   645,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,     0,     0,   655,   656,
     657,   658,   659,   660,   233,     0,   661,     0,   662,   663,
     664,     0,     0,   665,     0,     0,   666,   667,   668,   669,
     670,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     671,   672,   673,     0,     0,     0,     0,    86,    87,    88,
     411,    90,    91,    92,   412,     0,   413,    95,     0,  3702,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   414,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   415,   416,     0,     0,
       0,   417,   418,     0,     0,     0,     0,   419,     0,     0,
       0,     0,     0,     0,     0,     0,   420,     0,   421,     0,
     422,   423,    35,   424,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   425,   426,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,     0,     0,     0,     0,     0,     0,
       0,   436,   437,     0,   438,   439,     0,   440,   441,   442,
     135,   136,     0,   138,   139,     0,   443,   444,   445,   446,
     447,     0,     0,   448,   449,   450,   140,   451,     0,   452,
     453,   454,   455,   144,     0,   456,     0,   457,   458,   459,
     460,     0,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,     0,   469,     0,     0,     0,     0,     0,     0,
       0,     0,   470,   471,   472,   473,   474,   475,   154,   155,
     476,     0,   477,     0,   478,   479,   480,   481,   482,     0,
     483,   484,   485,     0,     0,   486,   487,   488,   489,   490,
       0,   491,   492,   493,     0,   494,   495,     0,   496,   497,
     498,   499,   163,   500,   501,   502,   165,     0,   503,     0,
     504,   167,   505,     0,   506,     0,   507,     0,     0,     0,
     508,   509,   510,     0,   511,   171,     0,   512,     0,   513,
     514,   515,   516,   517,     0,   518,   519,   520,     0,   521,
     522,   523,   524,   525,   526,     0,   527,     0,   174,     0,
     528,   529,   530,     0,   175,     0,   176,     0,   531,     0,
       0,   532,     0,   533,   534,   535,   536,   537,   538,   539,
       0,   180,     0,   540,     0,     0,   541,   542,   543,     0,
       0,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,   187,     0,   189,   556,   557,   190,     0,
     558,   559,     0,   560,     0,   193,   561,   194,   562,   563,
     564,     0,   565,     0,     0,   566,   567,   568,     0,     0,
     195,     0,     0,     0,   199,   569,   570,   571,   572,   573,
     574,   575,     0,   576,   200,   577,   201,   578,   579,   580,
       0,   581,   582,   583,   584,   585,   586,   587,   203,   588,
     589,   590,   591,     0,   592,   593,   594,   595,   596,   597,
     598,   599,   600,   601,     0,   602,   603,     0,   604,   605,
     211,   606,   607,   608,   609,   610,   611,   612,   613,   214,
     614,   615,   616,   617,   618,     0,   619,   216,   620,   621,
       0,   622,   219,     0,   623,   624,   625,   626,   627,   628,
     629,   630,   631,   632,   221,     0,   633,   634,   222,   635,
     636,   637,   638,   639,   640,     0,   223,   224,     0,     0,
     642,   225,   643,   226,     0,   644,   645,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,     0,     0,
     655,   656,   657,   658,   659,  1352,   233,     0,   661,     0,
     662,   663,   664,     0,     0,   665,     0,   235,   666,   667,
     668,   669,   670,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   671,   672,   673,     0,     0,     0,     0,    86,
      87,    88,   411,    90,    91,    92,   412,     0,   413,    95,
       0,   245,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   414,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   415,   416,
       0,     0,     0,   417,   418,     0,     0,     0,     0,   419,
       0,     0,     0,     0,     0,     0,     0,     0,   420,     0,
     421,     0,   422,   423,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   425,   426,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,     0,     0,     0,     0,
       0,     0,     0,   436,   437,     0,   438,   439,     0,   440,
     441,   442,   135,   136,     0,   138,   139,     0,   443,   444,
     445,   446,   447,     0,     0,   448,   449,   450,   140,   451,
       0,   452,   453,   454,   455,   144,     0,   456,     0,   457,
     458,   459,   460,     0,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   469,     0,     0,     0,     0,
       0,     0,     0,     0,   470,   471,   472,   473,   474,   475,
     154,   155,   476,     0,   477,     0,   478,   479,   480,   481,
     482,     0,   483,   484,   485,     0,     0,   486,   487,   488,
     489,   490,     0,   491,   492,   493,     0,   494,   495,     0,
     496,   497,   498,   499,   163,   500,   501,   502,   165,     0,
     503,     0,   504,   167,   505,     0,   506,     0,   507,     0,
       0,     0,   508,   509,   510,     0,   511,   171,     0,   512,
       0,   513,   514,   515,   516,   517,     0,   518,   519,   520,
       0,   521,   522,   523,   524,   525,   526,     0,   527,     0,
     174,     0,   528,   529,   530,     0,   175,     0,   176,     0,
     531,     0,     0,   532,     0,   533,   534,   535,   536,   537,
     538,   539,     0,   180,     0,   540,     0,     0,   541,   542,
     543,     0,     0,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,   555,   187,     0,   189,   556,   557,
     190,     0,   558,   559,     0,   560,     0,   193,   561,   194,
     562,   563,   564,     0,   565,     0,     0,   566,   567,   568,
       0,     0,   195,     0,     0,     0,   199,   569,   570,   571,
     572,   573,   574,   575,     0,   576,   200,   577,   201,   578,
     579,   580,     0,   581,   582,   583,   584,   585,   586,   587,
     203,   588,   589,   590,   591,     0,   592,   593,   594,   595,
     596,   597,   598,   599,   600,   601,     0,   602,   603,     0,
     604,   605,   211,   606,   607,   608,   609,   610,   611,   612,
     613,   214,   614,   615,   616,   617,   618,     0,   619,   216,
     620,   621,     0,   622,   219,     0,   623,   624,   625,   626,
     627,   628,   629,   630,   631,   632,   221,     0,   633,   634,
     222,   635,   636,   637,   638,   639,   640,     0,   223,   224,
       0,     0,   642,   225,   643,   226,     0,   644,   645,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
       0,     0,   655,   656,   657,   658,   659,  1352,   233,     0,
     661,     0,   662,   663,   664,     0,     0,   665,     0,   235,
     666,   667,   668,   669,   670,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   671,   672,   673,     0,     0,     0,
       0,    86,    87,    88,   411,    90,    91,    92,   412,     0,
     413,    95,     0,   245,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   414,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     415,   416,     0,     0,     0,   417,   418,     0,     0,     0,
       0,   419,     0,     0,     0,     0,     0,     0,     0,     0,
     420,     0,   421,     0,   422,   423,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   425,   426,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,     0,     0,
       0,     0,     0,     0,     0,   436,   437,     0,   438,   439,
       0,   440,   441,   442,   135,   136,     0,   138,   139,     0,
     443,   444,   445,   446,   447,     0,     0,   448,   449,   450,
     140,   451,     0,   452,   453,   454,   455,   144,     0,   456,
       0,   457,   458,   459,   460,     0,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   469,     0,     0,
       0,     0,     0,     0,     0,     0,   470,   471,   472,   473,
     474,   475,   154,   155,   476,     0,   477,     0,   478,   479,
     480,   481,   482,     0,   483,   484,   485,     0,     0,   486,
     487,   488,   489,   490,     0,   491,   492,   493,     0,   494,
     495,     0,   496,   497,   498,   499,   163,   500,   501,   502,
     165,     0,   503,     0,   504,   167,   505,     0,   506,     0,
     507,     0,     0,     0,   508,   509,   510,     0,   511,   171,
       0,   512,     0,   513,   514,   515,   516,   517,     0,   518,
     519,   520,     0,   521,   522,   523,   524,   525,   526,     0,
     527,     0,   174,     0,   528,   529,   530,     0,   175,     0,
     176,     0,   531,     0,     0,   532,     0,   533,   534,   535,
     536,   537,   538,   539,     0,   180,     0,   540,     0,     0,
     541,   542,   543,     0,     0,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,   555,   187,     0,   189,
     556,   557,   190,     0,   558,   559,     0,   560,     0,   193,
     561,   194,   562,   563,   564,     0,   565,     0,     0,   566,
     567,   568,     0,     0,   195,     0,     0,     0,   199,   569,
     570,   571,   572,   573,   574,   575,     0,   576,   200,   577,
     201,   578,   579,   580,     0,   581,   582,   583,   584,   585,
     586,   587,   203,   588,   589,   590,   591,     0,   592,   593,
     594,   595,   596,   597,   598,   599,   600,   601,     0,   602,
     603,     0,   604,   605,   211,   606,   607,   608,   609,   610,
     611,   612,   613,     0,   614,   615,   616,   617,   618,     0,
     619,   216,   620,   621,     0,   622,   219,     0,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   221,     0,
     633,   634,     0,   635,   636,   637,   638,   639,   640,     0,
     223,   224,     0,     0,   642,   225,   643,   226,     0,   644,
     645,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,   654,     0,     0,   655,   656,   657,   658,   659,   660,
     233,     0,   661,     0,   662,   663,   664,     0,     0,   665,
       0,     0,   666,   667,   668,   669,   670,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   671,   672,   673,     0,
       0,     0,     0,    86,    87,    88,   411,    90,    91,    92,
     412,     0,   413,    95,     0,  1558,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   414,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   415,   416,     0,     0,     0,   417,   418,     0,
       0,     0,     0,   419,     0,     0,     0,     0,     0,     0,
       0,     0,   420,     0,   421,     0,   422,   423,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
       0,     0,     0,     0,     0,     0,     0,   436,   437,     0,
     438,   439,     0,   440,   441,   442,   135,   136,     0,   138,
     139,     0,   443,   444,   445,   446,   447,     0,     0,   448,
     449,   450,   140,   451,     0,   452,   453,   454,   455,   144,
       0,   456,     0,   457,   458,   459,   460,     0,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   469,
       0,     0,     0,     0,     0,     0,     0,     0,   470,   471,
     472,   473,   474,   475,   154,   155,   476,     0,   477,     0,
     478,   479,   480,   481,   482,     0,   483,   484,   485,     0,
       0,   486,   487,   488,   489,   490,     0,   491,   492,   493,
       0,   494,   495,     0,   496,   497,   498,   499,   163,   500,
     501,   502,   165,     0,   503,     0,   504,   167,   505,     0,
     506,     0,   507,     0,     0,     0,   508,   509,   510,     0,
     511,   171,     0,   512,     0,   513,   514,   515,   516,   517,
       0,   518,   519,   520,     0,   521,   522,   523,   524,   525,
     526,     0,   527,     0,   174,     0,   528,   529,   530,     0,
     175,     0,   176,     0,   531,     0,     0,   532,     0,   533,
     534,   535,   536,   537,   538,   539,     0,   180,     0,   540,
       0,     0,   541,   542,   543,     0,     0,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,   187,
       0,   189,   556,   557,   190,     0,   558,   559,     0,   560,
       0,   193,   561,   194,   562,   563,   564,     0,   565,     0,
       0,   566,   567,   568,     0,     0,   195,     0,     0,     0,
     199,   569,   570,   571,   572,   573,   574,   575,     0,   576,
     200,   577,   201,   578,   579,   580,     0,   581,   582,   583,
     584,   585,   586,   587,   203,   588,   589,   590,   591,     0,
     592,   593,   594,   595,   596,   597,   598,   599,   600,   601,
       0,   602,   603,     0,   604,   605,   211,   606,   607,   608,
     609,   610,   611,   612,   613,     0,   614,   615,   616,   617,
     618,     0,   619,   216,   620,   621,     0,   622,   219,     0,
     623,   624,   625,   626,   627,   628,   629,   630,   631,   632,
     221,     0,   633,   634,     0,   635,   636,   637,   638,   639,
     640,     0,   223,   224,     0,     0,   642,   225,   643,   226,
       0,   644,   645,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,     0,     0,   655,   656,   657,   658,
     659,   660,   233,     0,   661,     0,   662,   663,   664,     0,
       0,   665,     0,     0,   666,   667,   668,   669,   670,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   671,   672,
     673,     0,     0,     0,     0,    86,    87,    88,   411,    90,
      91,    92,   412,     0,   413,    95,     0,  2910,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   414,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   415,   416,     0,     0,     0,   417,
     418,     0,     0,     0,     0,   419,     0,     0,     0,     0,
       0,     0,     0,     0,   420,     0,   421,     0,   422,   423,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     425,   426,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,     0,     0,     0,     0,     0,     0,     0,   436,
     437,     0,   438,   439,     0,   440,   441,   442,   135,   136,
       0,   138,   139,     0,   443,   444,   445,   446,   447,     0,
       0,   448,   449,   450,   140,   451,     0,   452,   453,   454,
     455,   144,     0,   456,     0,   457,   458,   459,   460,     0,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
       0,   469,     0,     0,     0,     0,     0,     0,     0,     0,
     470,   471,   472,   473,   474,   475,   154,   155,   476,     0,
     477,     0,   478,   479,   480,   481,   482,     0,   483,   484,
     485,     0,     0,   486,   487,   488,   489,   490,     0,   491,
     492,   493,     0,   494,   495,     0,   496,   497,   498,   499,
     163,   500,   501,   502,   165,     0,   503,     0,   504,   167,
     505,     0,   506,     0,   507,     0,     0,     0,   508,   509,
     510,     0,   511,   171,     0,   512,     0,   513,   514,   515,
     516,   517,     0,   518,   519,   520,     0,   521,   522,   523,
     524,   525,   526,     0,   527,     0,   174,     0,   528,   529,
     530,     0,   175,     0,   176,     0,   531,     0,     0,   532,
       0,   533,   534,   535,   536,   537,   538,   539,     0,   180,
       0,   540,     0,     0,   541,   542,   543,     0,     0,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   187,     0,   189,   556,   557,   190,     0,   558,   559,
       0,   560,     0,   193,   561,   194,   562,   563,   564,     0,
     565,     0,     0,   566,   567,   568,     0,     0,   195,     0,
       0,     0,   199,   569,   570,   571,   572,   573,   574,   575,
       0,   576,   200,   577,   201,   578,   579,   580,     0,   581,
     582,   583,   584,   585,   586,   587,   203,   588,   589,   590,
     591,     0,   592,   593,   594,   595,   596,   597,   598,   599,
     600,   601,     0,   602,   603,     0,   604,   605,   211,   606,
     607,   608,   609,   610,   611,   612,   613,     0,   614,   615,
     616,   617,   618,     0,   619,   216,   620,   621,     0,   622,
     219,     0,   623,   624,   625,   626,   627,   628,   629,   630,
     631,   632,   221,     0,   633,   634,     0,   635,   636,   637,
     638,   639,   640,     0,   223,   224,     0,     0,   642,   225,
     643,   226,     0,   644,   645,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,     0,     0,   655,   656,
     657,   658,   659,   660,   233,     0,   661,     0,   662,   663,
     664,     0,     0,   665,     0,     0,   666,   667,   668,   669,
     670,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     671,   672,   673,     0,     0,     0,     0,    86,    87,    88,
     411,    90,    91,    92,   412,     0,   413,    95,     0,  3951,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   414,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   415,   416,     0,     0,
       0,   417,   418,     0,     0,     0,     0,   419,     0,     0,
       0,     0,     0,     0,     0,     0,   420,     0,   421,     0,
     422,   423,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   425,   426,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,     0,     0,     0,     0,     0,     0,
       0,   436,   437,     0,   438,   439,     0,   440,   441,   442,
     135,   136,     0,   138,   139,     0,   443,   444,   445,   446,
     447,     0,     0,   448,   449,   450,   140,   451,     0,   452,
     453,   454,   455,   144,     0,   456,     0,   457,   458,   459,
     460,     0,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,     0,   469,     0,     0,     0,     0,     0,     0,
       0,     0,   470,   471,   472,   473,   474,   475,   154,   155,
     476,     0,   477,     0,   478,   479,   480,   481,   482,     0,
     483,   484,   485,     0,     0,   486,   487,   488,   489,   490,
       0,   491,   492,   493,     0,   494,   495,     0,   496,   497,
     498,   499,   163,   500,   501,   502,   165,     0,   503,     0,
     504,   167,   505,     0,   506,     0,   507,     0,     0,     0,
     508,   509,   510,     0,   511,   171,     0,   512,     0,   513,
     514,   515,   516,   517,     0,   518,   519,   520,     0,   521,
     522,   523,   524,   525,   526,     0,   527,     0,   174,     0,
     528,   529,   530,     0,   175,     0,   176,     0,   531,     0,
       0,   532,     0,   533,   534,   535,   536,   537,   538,   539,
       0,   180,     0,   540,     0,     0,   541,   542,   543,     0,
       0,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,   187,     0,   189,   556,   557,   190,     0,
     558,   559,     0,   560,     0,   193,   561,   194,   562,   563,
     564,     0,   565,     0,     0,   566,   567,   568,     0,     0,
     195,     0,     0,     0,   199,   569,   570,   571,   572,   573,
     574,   575,     0,   576,   200,   577,   201,   578,   579,   580,
       0,   581,   582,   583,   584,   585,   586,   587,   203,   588,
     589,   590,   591,     0,   592,   593,   594,   595,   596,   597,
     598,   599,   600,   601,     0,   602,   603,     0,   604,   605,
     211,   606,   607,   608,   609,   610,   611,   612,   613,     0,
     614,   615,   616,   617,   618,     0,   619,   216,   620,   621,
       0,   622,   219,     0,   623,   624,   625,   626,   627,   628,
     629,   630,   631,   632,   221,     0,   633,   634,     0,   635,
     636,   637,   638,   639,   640,     0,   223,   224,     0,     0,
     642,   225,   643,   226,     0,   644,   645,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,     0,     0,
     655,   656,   657,   658,   659,   660,   233,     0,   661,     0,
     662,   663,   664,     0,     0,   665,     0,     0,   666,   667,
     668,   669,   670,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   671,   672,   673,     0,     0,     0,   710,    86,
      87,    88,   411,    90,    91,    92,   412,     0,   413,    95,
       0,  4281,    98,    99,   100,   101,   102,   103,   711,   104,
     105,   414,   712,     0,   107,   108,   109,   110,   713,   714,
     112,   113,   114,   115,     0,   116,   715,   716,   415,   416,
       0,     0,     0,   417,   418,     0,     0,     0,     0,   419,
       0,     0,     0,     0,     0,     0,     0,     0,   420,     0,
     421,     0,   422,   423,    35,   424,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,     0,     0,  1176,    45,
       0,     0,     0,     0,   425,   426,   427,   428,   429,   430,
     431,   432,   717,   433,   434,   435,   718,   719,   720,   721,
     722,   723,   724,   436,   437,   725,   438,   439,   133,   440,
     441,   442,     0,  1835,   137,  1836,  1837,   726,   443,   444,
     445,   446,   447,   727,   728,   448,   449,  1838,  1839,   451,
     730,   452,   453,   454,   455,     0,   731,   456,   732,   457,
     458,   459,   460,   147,   461,   462,   734,   463,   464,   465,
     466,   467,   468,   735,   150,   469,     0,   737,   738,   739,
     151,   740,   741,   742,   470,   471,   472,   473,   474,   475,
    1840,  1841,   476,   743,   477,   744,   478,   479,   480,   481,
     482,   745,   483,   484,   485,   746,   747,   486,   487,  1448,
     489,   490,   748,   491,   492,   493,   749,   494,   495,   750,
     496,   497,   498,   499,     0,   500,   501,   502,     0,   751,
     503,   752,   504,  1842,   505,   753,   506,   754,   507,   168,
     755,   169,   508,   509,   510,   756,   511,     0,   757,   512,
     758,   513,   514,   515,   516,   517,   172,   518,   519,   520,
     759,   521,   522,   523,   524,   525,   526,   760,   527,   173,
       0,     0,   528,   529,   530,  1454,  1843,   763,  1844,   764,
     531,   177,   178,   532,   179,   533,   534,   535,   536,   537,
     538,   539,   765,     0,   181,   540,   182,   766,   541,   542,
     543,   767,   768,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,   555,  1845,   188,  1846,   556,   557,
       0,   769,   558,   559,   192,   560,   770,     0,   561,  1847,
     562,   563,   564,   771,   565,   772,   773,  3688,   567,   568,
     774,   775,     0,   196,   197,   198,     0,   569,   570,   571,
     572,   573,   574,   575,   776,   576,     0,   577,     0,   578,
     579,   580,   777,   581,   582,   583,   584,   585,   586,   587,
    1848,   588,   589,   590,   591,   778,   592,   593,   594,   595,
     596,   597,   598,   599,   600,   601,   779,   602,   603,   209,
     604,   605,     0,   606,   607,   608,   609,   610,   611,   612,
     613,   780,   614,   615,   616,   617,   618,   781,   619,  2384,
     620,   621,   218,   622,  1850,   782,   623,   624,   625,   626,
     627,   628,   629,   630,   631,   632,     0,   783,   633,   634,
     784,   635,   636,   637,   638,   639,   640,   785,  1851,  1852,
       0,   787,   642,     0,   643,     0,   788,   644,   645,   646,
     647,   648,   649,     0,   790,   650,   651,   652,   653,   654,
     791,   792,   655,   656,   657,   658,   659,     0,  1853,   794,
     661,   234,   662,   663,   664,   795,   796,   665,   797,   798,
     666,   667,   668,   669,   670,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   671,   672,   673,     0,     0,     0,
    1179,  1180,  1181,     0,  3689,  3690,  1184,  1185,  1186,  1187,
      86,    87,    88,   411,    90,    91,    92,   412,     0,   413,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   414,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   415,
     416,     0,     0,     0,   417,   418,     0,     0,     0,     0,
     419,     0,     0,     0,     0,     0,     0,     0,     0,   420,
       0,   421,     0,   422,   423,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,  1176,
       0,     0,     0,     0,     0,   425,   426,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,     0,     0,     0,
       0,     0,     0,     0,   436,   437,     0,   438,   439,     0,
     440,   441,   442,   135,   136,     0,   138,   139,     0,   443,
     444,   445,   446,   447,     0,     0,   448,   449,   450,   140,
     451,     0,   452,  1177,   454,   455,   144,     0,   456,     0,
     457,   458,   459,   460,     0,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,   469,     0,     0,     0,
       0,     0,     0,     0,     0,   470,   471,   472,   473,   474,
     475,   154,   155,   476,     0,   477,     0,   478,   479,   480,
     481,   482,     0,   483,   484,   485,     0,     0,   486,   487,
     488,   489,   490,     0,   491,   492,   493,     0,   494,   495,
       0,   496,   497,   498,   499,   163,   500,   501,   502,   165,
       0,  1178,     0,   504,   167,   505,     0,   506,     0,   507,
       0,     0,     0,   508,   509,   510,     0,   511,   171,     0,
     512,     0,   513,   514,   515,   516,   517,     0,   518,   519,
     520,     0,   521,   522,   523,   524,   525,   526,     0,   527,
       0,   174,     0,   528,   529,   530,     0,   175,     0,   176,
       0,   531,     0,     0,   532,     0,   533,   534,   535,   536,
     537,   538,   539,     0,   180,     0,   540,     0,     0,   541,
     542,   543,     0,     0,   544,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,   555,   187,     0,   189,   556,
     557,   190,     0,   558,   559,     0,   560,     0,   193,   561,
     194,   562,   563,   564,     0,   565,     0,     0,   566,   567,
     568,     0,     0,   195,     0,     0,     0,   199,   569,   570,
     571,   572,   573,   574,   575,     0,   576,   200,   577,   201,
     578,   579,   580,     0,   581,   582,   583,   584,   585,   586,
     587,   203,   588,   589,   590,   591,     0,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,     0,   602,   603,
       0,   604,   605,   211,   606,   607,   608,   609,   610,   611,
     612,   613,     0,   614,   615,   616,   617,   618,     0,   619,
     216,   620,   621,     0,   622,   219,     0,   623,   624,   625,
     626,   627,   628,   629,   630,   631,   632,   221,     0,   633,
     634,     0,   635,   636,   637,   638,   639,   640,     0,   223,
     224,     0,     0,   642,   225,   643,   226,     0,   644,   645,
     646,   647,   648,   649,     0,     0,   650,   651,   652,   653,
     654,     0,     0,   655,   656,   657,   658,   659,   660,   233,
       0,   661,     0,   662,   663,   664,     0,     0,   665,     0,
       0,   666,   667,   668,   669,   670,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   671,   672,   673,     0,     0,
       0,  1179,  1180,  1181,     0,  1182,  1183,  1184,  1185,  1186,
    1187,    86,    87,    88,   411,    90,    91,    92,   412,     0,
     413,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   414,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     415,   416,     0,     0,     0,   417,   418,     0,     0,     0,
       0,   419,     0,     0,     0,     0,     0,     0,     0,     0,
     420,     0,   421,     0,   422,   423,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
    1176,     0,     0,     0,     0,     0,   425,   426,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,     0,     0,
       0,     0,     0,     0,     0,   436,   437,     0,   438,   439,
       0,   440,   441,   442,   135,   136,     0,   138,   139,     0,
     443,   444,   445,   446,   447,     0,     0,   448,   449,   450,
     140,   451,     0,   452,  1262,   454,   455,   144,     0,   456,
       0,   457,   458,   459,   460,     0,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   469,     0,     0,
       0,     0,     0,     0,     0,     0,   470,   471,   472,   473,
     474,   475,   154,   155,   476,     0,   477,     0,   478,   479,
     480,   481,   482,     0,   483,   484,   485,     0,     0,   486,
     487,   488,   489,   490,     0,   491,   492,   493,     0,   494,
     495,     0,   496,   497,   498,   499,   163,   500,   501,   502,
     165,     0,  1263,     0,   504,   167,   505,     0,   506,     0,
     507,     0,     0,     0,   508,   509,   510,     0,   511,   171,
       0,   512,     0,   513,   514,   515,   516,   517,     0,   518,
     519,   520,     0,   521,   522,   523,   524,   525,   526,     0,
     527,     0,   174,     0,   528,   529,   530,     0,   175,     0,
     176,     0,   531,     0,     0,   532,     0,   533,   534,   535,
     536,   537,   538,   539,     0,   180,     0,   540,     0,     0,
     541,   542,   543,     0,     0,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,   555,   187,     0,   189,
     556,   557,   190,     0,   558,   559,     0,   560,     0,   193,
     561,   194,   562,   563,   564,     0,   565,     0,     0,   566,
     567,   568,     0,     0,   195,     0,     0,     0,   199,   569,
     570,   571,   572,   573,   574,   575,     0,   576,   200,   577,
     201,   578,   579,   580,     0,   581,   582,   583,   584,   585,
     586,   587,   203,   588,   589,   590,   591,     0,   592,   593,
     594,   595,   596,   597,   598,   599,   600,   601,     0,   602,
     603,     0,   604,   605,   211,   606,   607,   608,   609,   610,
     611,   612,   613,     0,   614,   615,   616,   617,   618,     0,
     619,   216,   620,   621,     0,   622,   219,     0,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   221,     0,
     633,   634,     0,   635,   636,   637,   638,   639,   640,     0,
     223,   224,     0,     0,   642,   225,   643,   226,     0,   644,
     645,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,   654,     0,     0,   655,   656,   657,   658,   659,   660,
     233,     0,   661,     0,   662,   663,   664,     0,     0,   665,
       0,     0,   666,   667,   668,   669,   670,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   671,   672,   673,     0,
       0,     0,  1179,  1180,  1181,     0,  1182,  1183,  1184,  1185,
    1186,  1187,    86,    87,    88,   411,    90,    91,    92,   412,
       0,   413,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   414,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   415,   416,     0,     0,     0,   417,   418,     0,     0,
       0,     0,   419,     0,     0,     0,     0,     0,     0,     0,
       0,   420,     0,   421,     0,   422,   423,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,  1176,     0,     0,     0,     0,     0,   425,   426,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,     0,
       0,     0,     0,     0,     0,     0,   436,   437,     0,   438,
     439,     0,   440,   441,   442,   135,   136,     0,   138,   139,
       0,   443,   444,   445,   446,   447,     0,     0,   448,   449,
     450,   140,   451,     0,   452,  1313,   454,   455,   144,     0,
     456,     0,   457,   458,   459,   460,     0,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,     0,   469,     0,
       0,     0,     0,     0,     0,     0,     0,   470,   471,   472,
     473,   474,   475,   154,   155,   476,     0,   477,     0,   478,
     479,   480,   481,   482,     0,   483,   484,   485,     0,     0,
     486,   487,   488,   489,   490,     0,   491,   492,   493,     0,
     494,   495,     0,   496,   497,   498,   499,   163,   500,   501,
     502,   165,     0,  1314,     0,   504,   167,   505,     0,   506,
       0,   507,     0,     0,     0,   508,   509,   510,     0,   511,
     171,     0,   512,     0,   513,   514,   515,   516,  1315,     0,
     518,   519,   520,     0,   521,   522,   523,   524,   525,   526,
       0,   527,     0,   174,     0,   528,   529,   530,     0,   175,
       0,   176,     0,   531,     0,     0,   532,     0,   533,   534,
     535,   536,   537,   538,   539,     0,   180,     0,   540,     0,
       0,   541,   542,   543,     0,     0,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,   555,   187,     0,
     189,   556,   557,   190,     0,   558,   559,     0,   560,     0,
     193,   561,   194,   562,   563,   564,     0,   565,     0,     0,
     566,   567,   568,     0,     0,   195,     0,     0,     0,   199,
     569,   570,   571,   572,   573,   574,   575,     0,   576,   200,
     577,   201,   578,   579,   580,     0,   581,   582,   583,   584,
     585,   586,   587,   203,   588,   589,   590,   591,     0,   592,
     593,   594,   595,   596,   597,   598,   599,   600,   601,     0,
     602,   603,     0,   604,   605,   211,   606,   607,   608,   609,
     610,   611,   612,   613,     0,   614,   615,   616,   617,   618,
       0,   619,   216,   620,   621,     0,   622,   219,     0,   623,
     624,   625,   626,   627,   628,   629,   630,   631,   632,   221,
       0,   633,   634,     0,   635,   636,   637,   638,   639,   640,
       0,   223,   224,     0,     0,   642,   225,   643,   226,     0,
     644,   645,   646,   647,   648,   649,     0,     0,   650,   651,
     652,   653,   654,     0,     0,   655,   656,   657,   658,   659,
     660,   233,     0,   661,     0,   662,   663,   664,     0,     0,
     665,     0,     0,   666,   667,   668,   669,   670,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   671,   672,   673,
       0,     0,     0,  1179,  1180,  1181,     0,  1182,  1183,  1184,
    1185,  1186,  1187,    86,    87,    88,   411,    90,    91,    92,
     412,     0,   413,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   414,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   415,   416,     0,     0,     0,   417,   418,     0,
       0,     0,     0,   419,     0,     0,     0,     0,     0,     0,
       0,     0,   420,     0,   421,     0,   422,   423,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,  1176,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
       0,     0,     0,     0,     0,     0,     0,   436,   437,     0,
     438,   439,     0,   440,   441,   442,   135,   136,     0,   138,
     139,     0,   443,   444,   445,   446,   447,     0,     0,   448,
     449,   450,   140,   451,     0,   452,  1818,   454,   455,   144,
       0,   456,     0,   457,   458,   459,   460,     0,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   469,
       0,     0,     0,     0,     0,     0,     0,     0,   470,   471,
     472,   473,   474,   475,   154,   155,   476,     0,   477,     0,
     478,   479,   480,   481,   482,     0,   483,   484,   485,     0,
       0,   486,   487,   488,   489,   490,     0,   491,   492,   493,
       0,   494,   495,     0,   496,   497,   498,   499,   163,   500,
     501,   502,   165,     0,  1819,     0,   504,   167,   505,     0,
     506,     0,   507,     0,     0,     0,   508,   509,   510,     0,
     511,   171,     0,   512,     0,   513,   514,   515,   516,   517,
       0,   518,   519,   520,     0,   521,   522,   523,   524,   525,
     526,     0,   527,     0,   174,     0,   528,   529,   530,     0,
     175,     0,   176,     0,   531,     0,     0,   532,     0,   533,
     534,   535,   536,   537,   538,   539,     0,   180,     0,   540,
       0,     0,   541,   542,   543,     0,     0,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,   187,
       0,   189,   556,   557,   190,     0,   558,   559,     0,   560,
       0,   193,   561,   194,   562,   563,   564,     0,   565,     0,
       0,   566,   567,   568,     0,     0,   195,     0,     0,     0,
     199,   569,   570,   571,   572,   573,   574,   575,     0,   576,
     200,   577,   201,   578,   579,   580,     0,   581,   582,   583,
     584,   585,   586,   587,   203,   588,   589,   590,   591,     0,
     592,   593,   594,   595,   596,   597,   598,   599,   600,   601,
       0,   602,   603,     0,   604,   605,   211,   606,   607,   608,
     609,   610,   611,   612,   613,     0,   614,   615,   616,   617,
     618,     0,   619,   216,   620,   621,     0,   622,   219,     0,
     623,   624,   625,   626,   627,   628,   629,   630,   631,   632,
     221,     0,   633,   634,     0,   635,   636,   637,   638,   639,
     640,     0,   223,   224,     0,     0,   642,   225,   643,   226,
       0,   644,   645,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,     0,     0,   655,   656,   657,   658,
     659,   660,   233,     0,   661,     0,   662,   663,   664,     0,
       0,   665,     0,     0,   666,   667,   668,   669,   670,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   671,   672,
     673,     0,     0,     0,  1179,  1180,  1181,     0,  1182,  1183,
    1184,  1185,  1186,  1187,    86,    87,    88,   411,    90,    91,
      92,   412,     0,   413,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   414,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   415,   416,     0,     0,     0,   417,   418,
       0,     0,     0,     0,   419,     0,     0,     0,     0,     0,
       0,     0,     0,   420,     0,   421,     0,   422,   423,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,  1176,     0,     0,     0,     0,     0,   425,
     426,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,     0,     0,     0,     0,     0,     0,     0,   436,   437,
       0,   438,   439,     0,   440,   441,   442,   135,   136,     0,
     138,   139,     0,   443,   444,   445,   446,   447,     0,     0,
     448,   449,   450,   140,   451,     0,   452,   453,   454,   455,
     144,     0,   456,     0,   457,   458,   459,   460,     0,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,     0,
     469,     0,     0,     0,     0,     0,     0,     0,     0,   470,
     471,   472,   473,   474,   475,   154,   155,   476,     0,   477,
       0,   478,   479,   480,   481,   482,     0,   483,   484,   485,
       0,     0,   486,   487,   488,   489,   490,     0,   491,   492,
     493,     0,   494,   495,     0,   496,   497,   498,   499,   163,
     500,   501,   502,   165,     0,   503,     0,   504,   167,   505,
       0,   506,     0,   507,     0,     0,     0,   508,   509,   510,
       0,   511,   171,     0,   512,     0,   513,   514,   515,   516,
     517,     0,   518,   519,   520,     0,   521,   522,   523,   524,
     525,   526,     0,   527,     0,   174,     0,   528,   529,   530,
       0,   175,     0,   176,     0,   531,     0,     0,   532,     0,
     533,   534,   535,   536,   537,   538,   539,     0,   180,     0,
     540,     0,     0,   541,   542,   543,     0,     0,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,   555,
     187,     0,   189,   556,   557,   190,     0,   558,   559,     0,
     560,     0,   193,   561,   194,   562,   563,   564,     0,   565,
       0,     0,   566,   567,   568,     0,     0,   195,     0,     0,
       0,   199,   569,   570,   571,   572,   573,   574,   575,     0,
     576,   200,   577,   201,   578,   579,   580,     0,   581,   582,
     583,   584,   585,   586,   587,   203,   588,   589,   590,   591,
       0,   592,   593,   594,   595,   596,   597,   598,   599,   600,
     601,     0,   602,   603,     0,   604,   605,   211,   606,   607,
     608,   609,   610,   611,   612,   613,     0,   614,   615,   616,
     617,   618,     0,   619,   216,   620,   621,     0,   622,   219,
       0,   623,   624,   625,   626,   627,   628,   629,   630,   631,
     632,   221,     0,   633,   634,     0,   635,   636,   637,   638,
     639,   640,     0,   223,   224,     0,     0,   642,   225,   643,
     226,     0,   644,   645,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,   654,     0,     0,   655,   656,   657,
     658,   659,   660,   233,     0,   661,     0,   662,   663,   664,
       0,     0,   665,     0,     0,   666,   667,   668,   669,   670,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   671,
     672,   673,     0,     0,     0,  1179,  1180,  1181,     0,  1182,
    1183,  1184,  1185,  1186,  1187,    86,    87,    88,   411,    90,
      91,    92,   412,     0,   413,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   414,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   415,   416,     0,     0,     0,   417,
     418,     0,     0,     0,     0,   419,     0,     0,     0,     0,
       0,     0,     0,     0,   420,     0,   421,     0,   422,   423,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,  1176,     0,     0,     0,     0,     0,
     425,   426,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,     0,     0,     0,     0,     0,     0,     0,   436,
     437,     0,   438,   439,     0,   440,   441,   442,   135,   136,
       0,   138,   139,     0,   443,   444,   445,   446,   447,     0,
       0,   448,   449,   450,   140,   451,     0,   452,  2989,   454,
     455,   144,     0,   456,     0,   457,   458,   459,   460,     0,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
       0,   469,     0,     0,     0,     0,     0,     0,     0,     0,
     470,   471,   472,   473,   474,   475,   154,   155,   476,     0,
     477,     0,   478,   479,   480,   481,   482,     0,   483,   484,
     485,     0,     0,   486,   487,   488,   489,   490,     0,   491,
     492,   493,     0,   494,   495,     0,   496,   497,   498,   499,
     163,   500,   501,   502,   165,     0,  2990,     0,   504,   167,
     505,     0,   506,     0,   507,     0,     0,     0,   508,   509,
     510,     0,   511,   171,     0,   512,     0,   513,   514,   515,
     516,   517,     0,   518,   519,   520,     0,   521,   522,   523,
     524,   525,   526,     0,   527,     0,   174,     0,   528,   529,
     530,     0,   175,     0,   176,     0,   531,     0,     0,   532,
       0,   533,   534,   535,   536,   537,   538,   539,     0,   180,
       0,   540,     0,     0,   541,   542,   543,     0,     0,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   187,     0,   189,   556,   557,   190,     0,   558,   559,
       0,   560,     0,   193,   561,   194,   562,   563,   564,     0,
     565,     0,     0,   566,   567,   568,     0,     0,   195,     0,
       0,     0,   199,   569,   570,   571,   572,   573,   574,   575,
       0,   576,   200,   577,   201,   578,   579,   580,     0,   581,
     582,   583,   584,   585,   586,   587,   203,   588,   589,   590,
     591,     0,   592,   593,   594,   595,   596,   597,   598,   599,
     600,   601,     0,   602,   603,     0,   604,   605,   211,   606,
     607,   608,   609,   610,   611,   612,   613,     0,   614,   615,
     616,   617,   618,     0,   619,   216,   620,   621,     0,   622,
     219,     0,   623,   624,   625,   626,   627,   628,   629,   630,
     631,   632,   221,     0,   633,   634,     0,   635,   636,   637,
     638,   639,   640,     0,   223,   224,     0,     0,   642,   225,
     643,   226,     0,   644,   645,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,     0,     0,   655,   656,
     657,   658,   659,   660,   233,     0,   661,     0,   662,   663,
     664,     0,     0,   665,     0,     0,   666,   667,   668,   669,
     670,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     671,   672,   673,     0,     0,     0,  1179,  1180,  1181,     0,
    1182,  1183,  1184,  1185,  1186,  1187,    86,    87,    88,   411,
      90,    91,    92,   412,     0,   413,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   414,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   415,   416,     0,     0,     0,
     417,   418,     0,     0,     0,     0,   419,     0,     0,     0,
       0,     0,     0,     0,     0,   420,     0,   421,     0,   422,
     423,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,  1176,     0,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,     0,     0,     0,     0,     0,     0,     0,
     436,   437,     0,   438,   439,     0,   440,   441,   442,   135,
     136,     0,   138,   139,     0,   443,   444,   445,   446,   447,
       0,     0,   448,   449,   450,   140,   451,     0,   452,   453,
     454,   455,   144,     0,   456,     0,   457,   458,   459,   460,
       0,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,     0,   469,     0,     0,     0,     0,     0,     0,     0,
       0,   470,   471,   472,   473,   474,   475,   154,   155,   476,
       0,   477,     0,   478,   479,   480,   481,   482,     0,   483,
     484,   485,     0,     0,   486,   487,   488,   489,   490,     0,
     491,   492,   493,     0,   494,   495,     0,   496,   497,   498,
     499,   163,   500,   501,   502,   165,     0,   503,     0,   504,
     167,   505,     0,   506,     0,   507,     0,     0,     0,   508,
     509,   510,     0,   511,   171,     0,   512,     0,   513,   514,
     515,   516,   517,     0,   518,   519,   520,     0,   521,   522,
     523,   524,   525,   526,     0,   527,     0,   174,     0,   528,
     529,   530,     0,   175,     0,   176,     0,   531,     0,     0,
     532,     0,   533,   534,   535,   536,   537,   538,   539,     0,
     180,     0,   540,     0,     0,   541,   542,   543,     0,     0,
     544,   545,   546,   547,   548,   549,   550,   551,   552,   553,
     554,   555,   187,     0,   189,   556,   557,   190,     0,   558,
     559,     0,   560,     0,   193,   561,   194,   562,   563,   564,
       0,   565,     0,     0,  4507,   567,   568,     0,     0,   195,
       0,     0,     0,   199,   569,   570,   571,   572,   573,   574,
     575,     0,   576,   200,   577,   201,   578,   579,   580,     0,
     581,   582,   583,   584,   585,   586,   587,   203,   588,   589,
     590,   591,     0,   592,   593,   594,   595,   596,   597,   598,
     599,   600,   601,     0,   602,   603,     0,   604,   605,   211,
     606,   607,   608,   609,   610,   611,   612,   613,     0,   614,
     615,   616,   617,   618,     0,   619,   216,   620,   621,     0,
     622,   219,     0,   623,   624,   625,   626,   627,   628,   629,
     630,   631,   632,   221,     0,   633,   634,     0,   635,   636,
     637,   638,   639,   640,     0,   223,   224,     0,     0,   642,
     225,   643,   226,     0,   644,   645,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,   654,     0,     0,   655,
     656,   657,   658,   659,   660,   233,     0,   661,     0,   662,
     663,   664,     0,     0,   665,     0,     0,   666,   667,   668,
     669,   670,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   671,   672,   673,     0,     0,     0,  1179,  1180,  1181,
       0,  1182,  1183,  1184,  1185,  1186,  1187,   710,    86,    87,
      88,   411,    90,    91,    92,   412,     0,   413,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   711,   104,   105,
     414,   712,     0,   107,   108,   109,   110,   713,   714,   112,
     113,   114,   115,     0,   116,   715,   716,   415,   416,     0,
       0,     0,   417,   418,     0,     0,     0,     0,   419,     0,
       0,     0,     0,     0,     0,     0,     0,   420,     0,   421,
       0,   422,   423,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   425,   426,   427,   428,   429,   430,   431,
     432,   717,   433,   434,   435,   718,   719,   720,   721,   722,
     723,   724,   436,   437,   725,   438,   439,   133,   440,   441,
     442,   135,   136,   137,   138,   139,   726,   443,   444,   445,
     446,   447,   727,   728,   448,   449,   729,   140,   451,   730,
     452,   453,   454,   455,   144,   731,   456,   732,   457,   458,
     459,   460,   147,   461,   733,   734,   463,   464,   465,   466,
     467,   468,   735,   150,   469,   736,   737,   738,   739,   151,
     740,   741,   742,   470,   471,   472,   473,   474,   475,   154,
     155,   476,   743,   477,   744,   478,   479,   480,   481,   482,
     745,   483,   484,   485,   746,   747,   486,   487,   488,   489,
     490,   748,   491,   492,   493,   749,   494,   495,   750,   496,
     497,   498,   499,   163,   500,   501,   502,   165,   751,   503,
     752,   504,   167,   505,   753,   506,   754,   507,   168,   755,
     169,   508,   509,   510,   756,   511,   171,   757,   512,   758,
     513,   514,   515,   516,   517,   172,   518,   519,   520,   759,
     521,   522,   523,   524,   525,   526,   760,   527,   173,   174,
     761,   528,   529,   530,   762,   175,   763,   176,   764,   531,
     177,   178,   532,   179,   533,   534,   535,   536,   537,   538,
     539,   765,   180,   181,   540,   182,   766,   541,   542,   543,
     767,   768,   544,   545,   546,   547,   548,   549,   550,   551,
     552,   553,   554,   555,   187,   188,   189,   556,   557,   190,
     769,   558,   559,   192,   560,   770,   193,   561,   194,   562,
     563,   564,   771,   565,   772,   773,   566,   567,   568,   774,
     775,   195,   196,   197,   198,   199,   569,   570,   571,   572,
     573,   574,   575,   776,   576,   200,   577,   201,   578,   579,
     580,   777,   581,   582,   583,   584,   585,   586,   587,   203,
     588,   589,   590,   591,   778,   592,   593,   594,   595,   596,
     597,   598,   599,   600,   601,   779,   602,   603,   209,   604,
     605,   211,   606,   607,   608,   609,   610,   611,   612,   613,
     780,   614,   615,   616,   617,   618,   781,   619,   216,   620,
     621,   218,   622,   219,   782,   623,   624,   625,   626,   627,
     628,   629,   630,   631,   632,   221,   783,   633,   634,   784,
     635,   636,   637,   638,   639,   640,   785,   223,   224,   786,
     787,   642,   225,   643,   226,   788,   644,   645,   646,   647,
     648,   649,   789,   790,   650,   651,   652,   653,   654,   791,
     792,   655,   656,   657,   658,   659,   793,   233,   794,   661,
     234,   662,   663,   664,   795,   796,   665,   797,   798,   666,
     667,   668,   669,   670,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   671,   672,   673,   710,    86,    87,    88,
     411,    90,    91,    92,   412,  2208,   413,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   711,   104,   105,   414,
     712,     0,   107,   108,   109,   110,   713,   714,   112,   113,
     114,   115,     0,   116,   715,   716,   415,   416,     0,     0,
       0,   417,   418,     0,     0,     0,     0,   419,     0,     0,
       0,     0,     0,     0,     0,     0,   420,     0,   421,     0,
     422,   423,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   425,   426,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,     0,     0,     0,     0,     0,     0,
       0,   436,   437,     0,   438,   439,   133,   440,   441,   442,
       0,  1835,   137,  1836,  1837,     0,   443,   444,   445,   446,
     447,     0,     0,   448,   449,  1838,  1839,   451,     0,   452,
     453,   454,   455,     0,     0,   456,     0,   457,   458,   459,
     460,   147,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,   150,   469,     0,     0,     0,     0,   151,     0,
       0,     0,   470,   471,   472,   473,   474,   475,  1840,  1841,
     476,     0,   477,     0,   478,   479,   480,   481,   482,     0,
     483,   484,   485,     0,     0,   486,   487,  1448,   489,   490,
       0,   491,   492,   493,     0,   494,   495,     0,   496,   497,
     498,   499,     0,   500,   501,   502,     0,     0,   503,     0,
     504,  1842,   505,     0,   506,     0,   507,   168,     0,   169,
     508,   509,   510,     0,   511,     0,     0,   512,     0,   513,
     514,   515,   516,   517,   172,   518,   519,   520,     0,   521,
     522,   523,   524,   525,   526,     0,   527,   173,     0,     0,
     528,   529,   530,  1454,  1843,     0,  1844,     0,   531,   177,
     178,   532,   179,   533,   534,   535,   536,   537,   538,   539,
       0,     0,   181,   540,   182,     0,   541,   542,   543,     0,
       0,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,  1845,   188,  1846,   556,   557,     0,     0,
     558,   559,   192,   560,     0,     0,   561,  1847,   562,   563,
     564,     0,   565,     0,     0,   566,   567,   568,     0,     0,
       0,   196,   197,   198,     0,   569,   570,   571,   572,   573,
     574,   575,     0,   576,     0,   577,     0,   578,   579,   580,
       0,   581,   582,   583,   584,   585,   586,   587,  1848,   588,
     589,   590,   591,     0,   592,   593,   594,   595,   596,   597,
     598,   599,   600,   601,     0,   602,   603,   209,   604,   605,
       0,   606,   607,   608,   609,   610,   611,   612,   613,     0,
     614,   615,   616,   617,   618,     0,   619,  1849,   620,   621,
     218,   622,  1850,     0,   623,   624,   625,   626,   627,   628,
     629,   630,   631,   632,     0,     0,   633,   634,     0,   635,
     636,   637,   638,   639,   640,     0,  1851,  1852,     0,     0,
     642,     0,   643,     0,     0,   644,   645,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,     0,     0,
     655,   656,   657,   658,   659,     0,  1853,     0,   661,   234,
     662,   663,   664,     0,     0,   665,     0,     0,   666,   667,
     668,   669,   670,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   671,   672,   673,     0,    86,    87,    88,   411,
      90,    91,    92,   412,  2307,   413,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   414,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   415,   416,     0,     0,     0,
     417,   418,     0,     0,     0,     0,   419,     0,     0,     0,
       0,     0,     0,     0,     0,   420,     0,   421,     0,   422,
     423,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,     0,     0,     0,     0,     0,     0,     0,
     436,   437,     0,   438,   439,     0,   440,   441,   442,   135,
     136,     0,   138,   139,     0,   443,   444,   445,   446,   447,
       0,     0,   448,   449,   450,   140,   451,     0,   452,   453,
     454,   455,   144,     0,   456,     0,   457,   458,   459,   460,
       0,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,     0,   469,     0,     0,     0,     0,     0,     0,     0,
       0,   470,   471,   472,   473,   474,   475,   154,   155,   476,
       0,   477,     0,   478,   479,   480,   481,   482,     0,   483,
     484,   485,     0,     0,   486,   487,   488,   489,   490,     0,
     491,   492,   493,     0,   494,   495,     0,   496,   497,   498,
     499,   163,   500,   501,   502,   165,     0,   503,     0,   504,
     167,   505,     0,   506,     0,   507,     0,     0,     0,   508,
     509,   510,     0,   511,   171,     0,   512,     0,   513,   514,
     515,   516,   517,     0,   518,   519,   520,     0,   521,   522,
     523,   524,   525,   526,     0,   527,     0,   174,     0,   528,
     529,   530,     0,   175,     0,   176,     0,   531,     0,     0,
     532,     0,   533,   534,   535,   536,   537,   538,   539,     0,
     180,     0,   540,     0,     0,   541,   542,   543,     0,     0,
     544,   545,   546,   547,   548,   549,   550,   551,   552,   553,
     554,   555,   187,     0,   189,   556,   557,   190,     0,   558,
     559,     0,   560,     0,   193,   561,   194,   562,   563,   564,
       0,   565,     0,     0,   566,   567,   568,     0,     0,   195,
       0,     0,     0,   199,   569,   570,   571,   572,   573,   574,
     575,     0,   576,   200,   577,   201,   578,   579,   580,     0,
     581,   582,   583,   584,   585,   586,   587,   203,   588,   589,
     590,   591,     0,   592,   593,   594,   595,   596,   597,   598,
     599,   600,   601,     0,   602,   603,     0,   604,   605,   211,
     606,   607,   608,   609,   610,   611,   612,   613,     0,   614,
     615,   616,   617,   618,     0,   619,   216,   620,   621,     0,
     622,   219,     0,   623,   624,   625,   626,   627,   628,   629,
     630,   631,   632,   221,     0,   633,   634,     0,   635,   636,
     637,   638,   639,   640,     0,   223,   224,     0,     0,   642,
     225,   643,   226,     0,   644,   645,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,   654,     0,     0,   655,
     656,   657,   658,   659,   660,   233,     0,   661,     0,   662,
     663,   664,     0,     0,   665,     0,     0,   666,   667,   668,
     669,   670,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   671,   672,   673,     0,    86,    87,    88,   411,    90,
      91,    92,   412,  1062,   413,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   414,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   415,   416,     0,     0,     0,   417,
     418,     0,     0,     0,     0,   419,     0,     0,     0,     0,
       0,     0,     0,     0,   420,     0,   421,     0,   422,   423,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     425,   426,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,     0,     0,     0,     0,     0,     0,     0,   436,
     437,     0,   438,   439,     0,   440,   441,   442,   135,   136,
       0,   138,   139,     0,   443,   444,   445,   446,   447,     0,
       0,   448,   449,   450,   140,   451,     0,   452,   453,   454,
     455,   144,     0,   456,     0,   457,   458,   459,   460,     0,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
       0,   469,     0,     0,     0,     0,     0,     0,     0,     0,
     470,   471,   472,   473,   474,   475,   154,   155,   476,     0,
     477,     0,   478,   479,   480,   481,   482,     0,   483,   484,
     485,     0,     0,   486,   487,   488,   489,   490,     0,   491,
     492,   493,     0,   494,   495,     0,   496,   497,   498,   499,
     163,   500,   501,   502,   165,     0,   503,     0,   504,   167,
     505,     0,   506,     0,   507,     0,     0,     0,   508,   509,
     510,     0,   511,   171,     0,   512,     0,   513,   514,   515,
     516,   517,     0,   518,   519,   520,     0,   521,   522,   523,
     524,   525,   526,     0,   527,     0,   174,     0,   528,   529,
     530,     0,   175,     0,   176,     0,   531,     0,     0,   532,
       0,   533,   534,   535,   536,   537,   538,   539,     0,   180,
       0,   540,     0,     0,   541,   542,   543,     0,     0,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   187,     0,   189,   556,   557,   190,     0,   558,   559,
       0,   560,     0,   193,   561,   194,   562,   563,   564,     0,
     565,     0,     0,   566,   567,   568,     0,     0,   195,     0,
       0,     0,   199,   569,   570,   571,   572,   573,   574,   575,
       0,   576,   200,   577,   201,   578,   579,   580,     0,   581,
     582,   583,   584,   585,   586,   587,   203,   588,   589,   590,
     591,     0,   592,   593,   594,   595,   596,   597,   598,   599,
     600,   601,     0,   602,   603,     0,   604,   605,   211,   606,
     607,   608,   609,   610,   611,   612,   613,     0,   614,   615,
     616,   617,   618,     0,   619,   216,   620,   621,     0,   622,
     219,     0,   623,   624,   625,   626,   627,   628,   629,   630,
     631,   632,   221,     0,   633,   634,     0,   635,   636,   637,
     638,   639,   640,     0,   223,   224,     0,     0,   642,   225,
     643,   226,     0,   644,   645,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,     0,     0,   655,   656,
     657,   658,   659,   660,   233,     0,   661,     0,   662,   663,
     664,     0,     0,   665,     0,     0,   666,   667,   668,   669,
     670,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     671,   672,   673,     0,    86,    87,    88,   411,    90,    91,
      92,   412,  4373,   413,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   414,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   415,   416,     0,     0,     0,   417,   418,
       0,     0,     0,     0,   419,     0,     0,     0,     0,     0,
       0,     0,     0,   420,     0,   421,     0,   422,   423,    35,
     424,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,     0,     0,     0,    45,     0,     0,     0,     0,   425,
     426,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,     0,     0,     0,     0,     0,     0,     0,   436,   437,
       0,   438,   439,     0,   440,   441,   442,   135,   136,     0,
     138,   139,     0,   443,   444,   445,   446,   447,     0,     0,
     448,   449,   450,   140,   451,     0,   452,   453,   454,   455,
     144,     0,   456,     0,   457,   458,   459,   460,     0,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,     0,
     469,     0,     0,     0,     0,     0,     0,     0,     0,   470,
     471,   472,   473,   474,   475,   154,   155,   476,  2196,   477,
       0,   478,   479,   480,   481,   482,     0,   483,   484,   485,
       0,     0,   486,   487,   488,   489,   490,     0,   491,   492,
     493,     0,   494,   495,     0,   496,   497,   498,   499,   163,
     500,   501,   502,   165,  1984,   503,     0,   504,   167,   505,
       0,   506,     0,   507,     0,     0,     0,   508,   509,   510,
       0,   511,   171,     0,   512,     0,   513,   514,   515,   516,
     517,     0,   518,   519,   520,     0,   521,   522,   523,   524,
     525,   526,     0,   527,     0,   174,     0,   528,   529,   530,
       0,   175,     0,   176,     0,   531,     0,     0,   532,     0,
     533,   534,   535,   536,   537,   538,   539,     0,   180,     0,
     540,     0,     0,   541,   542,   543,     0,     0,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,   555,
     187,     0,   189,   556,   557,   190,     0,   558,   559,     0,
     560,     0,   193,   561,   194,   562,   563,   564,     0,   565,
    1985,     0,   566,   567,   568,     0,     0,   195,     0,     0,
       0,   199,   569,   570,   571,   572,   573,   574,   575,     0,
     576,   200,   577,   201,   578,   579,   580,     0,   581,   582,
     583,   584,   585,   586,   587,   203,   588,   589,   590,   591,
       0,   592,   593,   594,   595,   596,   597,   598,   599,   600,
     601,     0,   602,   603,     0,   604,   605,   211,   606,   607,
     608,   609,   610,   611,   612,   613,     0,   614,   615,   616,
     617,   618,     0,   619,   216,   620,   621,     0,   622,   219,
       0,   623,   624,   625,   626,   627,   628,   629,   630,   631,
     632,   221,     0,   633,   634,     0,   635,   636,   637,   638,
     639,   640,     0,   223,   224,     0,     0,   642,   225,   643,
     226,  1986,   644,   645,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,   654,     0,     0,   655,   656,   657,
     658,   659,   660,   233,     0,   661,     0,   662,   663,   664,
       0,     0,   665,     0,     0,   666,   667,   668,   669,   670,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   671,
     672,   673,     0,     0,     0,     0,     0,     0,     0,   973,
    1626,    86,    87,    88,   411,    90,    91,    92,   412,     0,
     413,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   414,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     415,   416,     0,     0,     0,   417,   418,     0,     0,     0,
       0,   419,     0,     0,     0,     0,     0,     0,     0,     0,
     420,     0,   421,     0,   422,   423,    35,   424,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,     0,     0,
       0,    45,     0,     0,     0,     0,   425,   426,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,     0,     0,
       0,     0,     0,     0,     0,   436,   437,     0,   438,   439,
       0,   440,   441,   442,   135,   136,     0,   138,   139,     0,
     443,   444,   445,   446,   447,     0,     0,   448,   449,   450,
     140,   451,     0,   452,   453,   454,   455,   144,     0,   456,
       0,   457,   458,   459,   460,     0,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   469,     0,     0,
       0,     0,     0,     0,     0,     0,   470,   471,   472,   473,
     474,   475,   154,   155,   476,  2201,   477,     0,   478,   479,
     480,   481,   482,     0,   483,   484,   485,     0,     0,   486,
     487,   488,   489,   490,     0,   491,   492,   493,     0,   494,
     495,     0,   496,   497,   498,   499,   163,   500,   501,   502,
     165,  1984,   503,     0,   504,   167,   505,     0,   506,     0,
     507,     0,     0,     0,   508,   509,   510,     0,   511,   171,
       0,   512,     0,   513,   514,   515,   516,   517,     0,   518,
     519,   520,     0,   521,   522,   523,   524,   525,   526,     0,
     527,     0,   174,     0,   528,   529,   530,     0,   175,     0,
     176,     0,   531,     0,     0,   532,     0,   533,   534,   535,
     536,   537,   538,   539,     0,   180,     0,   540,     0,     0,
     541,   542,   543,     0,     0,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,   555,   187,     0,   189,
     556,   557,   190,     0,   558,   559,     0,   560,     0,   193,
     561,   194,   562,   563,   564,     0,   565,  1985,     0,   566,
     567,   568,     0,     0,   195,     0,     0,     0,   199,   569,
     570,   571,   572,   573,   574,   575,     0,   576,   200,   577,
     201,   578,   579,   580,     0,   581,   582,   583,   584,   585,
     586,   587,   203,   588,   589,   590,   591,     0,   592,   593,
     594,   595,   596,   597,   598,   599,   600,   601,     0,   602,
     603,     0,   604,   605,   211,   606,   607,   608,   609,   610,
     611,   612,   613,     0,   614,   615,   616,   617,   618,     0,
     619,   216,   620,   621,     0,   622,   219,     0,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   221,     0,
     633,   634,     0,   635,   636,   637,   638,   639,   640,     0,
     223,   224,     0,     0,   642,   225,   643,   226,  1986,   644,
     645,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,   654,     0,     0,   655,   656,   657,   658,   659,   660,
     233,     0,   661,     0,   662,   663,   664,     0,     0,   665,
       0,     0,   666,   667,   668,   669,   670,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   671,   672,   673,     0,
       0,     0,     0,     0,     0,     0,   973,  1626,    86,    87,
      88,   411,    90,    91,    92,   412,     0,   413,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     414,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   415,   416,     0,
       0,     0,   417,   418,     0,     0,     0,     0,   419,     0,
       0,     0,     0,     0,     0,     0,     0,   420,     0,   421,
       0,   422,   423,    35,   424,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,     0,     0,     0,    45,     0,
       0,     0,     0,   425,   426,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,     0,     0,     0,     0,     0,
       0,     0,   436,   437,     0,   438,   439,     0,   440,   441,
     442,   135,   136,     0,   138,   139,     0,   443,   444,   445,
     446,   447,     0,     0,   448,   449,   450,   140,   451,     0,
     452,   453,   454,   455,   144,     0,   456,     0,   457,   458,
     459,   460,     0,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,     0,   469,     0,     0,     0,     0,     0,
       0,     0,     0,   470,   471,   472,   473,   474,   475,   154,
     155,   476,     0,   477,     0,   478,   479,   480,   481,   482,
       0,   483,   484,   485,     0,     0,   486,   487,   488,   489,
     490,     0,   491,   492,   493,     0,   494,   495,     0,   496,
     497,   498,   499,   163,   500,   501,   502,   165,  1984,   503,
       0,   504,   167,   505,     0,   506,     0,   507,     0,     0,
       0,   508,   509,   510,     0,   511,   171,     0,   512,     0,
     513,   514,   515,   516,   517,     0,   518,   519,   520,     0,
     521,   522,   523,   524,   525,   526,     0,   527,     0,   174,
       0,   528,   529,   530,     0,   175,     0,   176,     0,   531,
       0,     0,   532,     0,   533,   534,   535,   536,   537,   538,
     539,     0,   180,     0,   540,     0,     0,   541,   542,   543,
       0,     0,   544,   545,   546,   547,   548,   549,   550,   551,
     552,   553,   554,   555,   187,     0,   189,   556,   557,   190,
       0,   558,   559,     0,   560,     0,   193,   561,   194,   562,
     563,   564,     0,   565,  1985,     0,   566,   567,   568,     0,
       0,   195,     0,     0,     0,   199,   569,   570,   571,   572,
     573,   574,   575,     0,   576,   200,   577,   201,   578,   579,
     580,     0,   581,   582,   583,   584,   585,   586,   587,   203,
     588,   589,   590,   591,     0,   592,   593,   594,   595,   596,
     597,   598,   599,   600,   601,     0,   602,   603,     0,   604,
     605,   211,   606,   607,   608,   609,   610,   611,   612,   613,
       0,   614,   615,   616,   617,   618,     0,   619,   216,   620,
     621,     0,   622,   219,     0,   623,   624,   625,   626,   627,
     628,   629,   630,   631,   632,   221,     0,   633,   634,     0,
     635,   636,   637,   638,   639,   640,     0,   223,   224,     0,
       0,   642,   225,   643,   226,  1986,   644,   645,   646,   647,
     648,   649,     0,     0,   650,   651,   652,   653,   654,     0,
       0,   655,   656,   657,   658,   659,   660,   233,     0,   661,
       0,   662,   663,   664,     0,     0,   665,     0,     0,   666,
     667,   668,   669,   670,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   671,   672,   673,     0,     0,     0,     0,
       0,     0,     0,   973,  1626,    86,    87,    88,   411,    90,
      91,    92,   412,     0,   413,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   414,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   415,   416,     0,     0,     0,   417,
     418,     0,     0,     0,     0,   419,     0,     0,     0,     0,
       0,     0,     0,     0,   420,     0,   421,     0,   422,   423,
      35,   424,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,    45,     0,     0,     0,     0,
     425,   962,   427,   428,   429,   430,   431,   432,   963,   433,
     434,   435,     0,     0,     0,     0,     0,     0,     0,   436,
     437,     0,   438,   439,     0,   964,   441,   442,   135,   136,
       0,   138,   139,     0,   443,   444,   445,   446,   447,     0,
       0,   448,   449,   450,   140,   451,     0,   452,   453,   454,
     455,   144,     0,   456,     0,   457,   458,   459,   460,     0,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
       0,   469,     0,     0,     0,     0,     0,     0,     0,     0,
     470,   471,   472,   473,   474,   475,   154,   155,   476,     0,
     477,     0,   478,   479,   480,   481,   482,     0,   483,   484,
     485,     0,     0,   486,   487,   488,   489,   490,     0,   491,
     492,   493,     0,   494,   495,     0,   496,   497,   498,   499,
     163,   500,   501,   502,   165,     0,   503,     0,   965,   167,
     505,     0,   506,     0,   966,     0,   967,     0,   508,   509,
     510,     0,   511,   171,     0,   512,     0,   513,   514,   515,
     516,   517,     0,   518,   519,   520,   968,   521,   522,   523,
     524,   525,   526,     0,   527,     0,   174,     0,   528,   529,
     530,     0,   175,     0,   176,     0,   531,     0,     0,   532,
       0,   533,   534,   535,   536,   969,   538,   539,     0,   180,
       0,   540,     0,     0,   541,   542,   543,     0,     0,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   187,     0,   189,   970,   557,   190,     0,   558,   559,
       0,   560,     0,   193,   561,   194,   562,   563,   564,     0,
     565,     0,     0,   566,   567,   568,     0,     0,   195,     0,
       0,     0,   199,   569,   570,   571,   572,   573,   574,   575,
       0,   576,   200,   577,   201,   578,   579,   580,     0,   971,
     582,   583,   584,   585,   586,   587,   203,   588,   589,   590,
     591,     0,   592,   972,   594,   595,   596,   597,   598,   599,
     600,   601,     0,   602,   603,     0,   604,   605,   211,   606,
     607,   608,   609,   610,   611,   612,   613,     0,   614,   615,
     616,   617,   618,     0,   619,   216,   620,   621,     0,   622,
     219,     0,   623,   624,   625,   626,   627,   628,   629,   630,
     631,   632,   221,     0,   633,   634,     0,   635,   636,   637,
     638,   639,   640,     0,   223,   224,     0,     0,   642,   225,
     643,   226,     0,   644,   645,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,     0,     0,   655,   656,
     657,   658,   659,   660,   233,     0,   661,     0,   662,   663,
     664,     0,     0,   665,     0,     0,   666,   667,   668,   669,
     670,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     671,   672,   673,     0,     0,     0,     0,     0,     0,     0,
     973,   974,    86,    87,    88,   411,    90,    91,    92,   412,
       0,   413,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   414,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   415,   416,     0,     0,     0,   417,   418,     0,     0,
       0,     0,   419,     0,     0,     0,     0,     0,     0,     0,
       0,   420,     0,   421,     0,   422,   423,    35,   424,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,    45,     0,     0,     0,     0,   425,   962,   427,
     428,   429,   430,   431,   432,   963,   433,   434,   435,     0,
       0,     0,     0,     0,     0,     0,   436,   437,     0,   438,
     439,     0,   995,   441,   442,   135,   136,     0,   138,   139,
       0,   443,   444,   445,   446,   447,     0,     0,   448,   449,
     450,   140,   451,     0,   452,   453,   454,   455,   144,     0,
     456,     0,   457,   458,   459,   460,     0,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,     0,   469,     0,
       0,     0,     0,     0,     0,     0,     0,   470,   471,   472,
     473,   474,   475,   154,   155,   476,     0,   477,     0,   478,
     479,   480,   481,   482,     0,   483,   484,   485,     0,     0,
     486,   487,   488,   489,   490,     0,   491,   492,   493,     0,
     494,   495,     0,   496,   497,   498,   499,   163,   500,   501,
     502,   165,     0,   503,     0,   965,   167,   505,     0,   506,
       0,   996,     0,   967,     0,   508,   509,   510,     0,   511,
     171,     0,   512,     0,   513,   514,   515,   516,   517,     0,
     518,   519,   520,   968,   521,   522,   523,   524,   525,   526,
       0,   527,     0,   174,     0,   528,   529,   530,     0,   175,
       0,   176,     0,   531,     0,     0,   532,     0,   533,   534,
     535,   536,   969,   538,   539,     0,   180,     0,   540,     0,
       0,   541,   542,   543,     0,     0,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,   555,   187,     0,
     189,   970,   557,   190,     0,   558,   559,     0,   560,     0,
     193,   561,   194,   562,   563,   564,     0,   565,     0,     0,
     566,   567,   568,     0,     0,   195,     0,     0,     0,   199,
     569,   570,   571,   572,   573,   574,   575,     0,   576,   200,
     577,   201,   578,   579,   580,     0,   971,   582,   583,   584,
     585,   586,   587,   203,   588,   589,   590,   591,     0,   592,
     972,   594,   595,   596,   597,   598,   599,   600,   601,     0,
     602,   603,     0,   604,   605,   211,   606,   607,   608,   609,
     610,   611,   612,   613,     0,   614,   615,   616,   617,   618,
       0,   619,   216,   620,   621,     0,   622,   219,     0,   623,
     624,   625,   626,   627,   628,   629,   630,   631,   632,   221,
       0,   633,   634,     0,   635,   636,   637,   638,   639,   640,
       0,   223,   224,     0,     0,   642,   225,   643,   226,     0,
     644,   645,   646,   647,   648,   649,     0,     0,   650,   651,
     652,   653,   654,     0,     0,   655,   656,   657,   658,   659,
     660,   233,     0,   661,     0,   662,   663,   664,     0,     0,
     665,     0,     0,   666,   667,   668,   669,   670,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   671,   672,   673,
       0,     0,     0,     0,     0,     0,     0,   973,   974,    86,
      87,    88,   411,    90,    91,    92,   412,     0,   413,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   414,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   415,   416,
       0,     0,     0,   417,   418,     0,     0,     0,     0,   419,
       0,     0,     0,     0,     0,     0,     0,     0,   420,     0,
     421,     0,   422,   423,    35,   424,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,    45,
       0,     0,     0,     0,   425,   426,   427,   428,   429,   430,
     431,   432,  1363,   433,   434,   435,     0,     0,     0,     0,
       0,     0,     0,   436,   437,     0,   438,   439,     0,   440,
     441,   442,   135,   136,     0,   138,   139,     0,   443,   444,
     445,   446,   447,     0,     0,   448,   449,   450,   140,   451,
       0,   452,   453,   454,   455,   144,     0,   456,     0,   457,
     458,   459,   460,     0,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   469,     0,     0,     0,     0,
       0,     0,     0,     0,   470,   471,   472,   473,   474,   475,
     154,   155,   476,     0,   477,     0,   478,   479,   480,   481,
     482,     0,   483,   484,   485,     0,     0,   486,   487,   488,
     489,   490,     0,   491,   492,   493,     0,   494,   495,     0,
     496,   497,   498,   499,   163,   500,   501,   502,   165,     0,
     503,     0,   504,   167,   505,     0,   506,     0,   507,     0,
     967,     0,   508,   509,   510,     0,   511,   171,     0,   512,
       0,   513,   514,   515,   516,   517,     0,   518,   519,   520,
     968,   521,   522,   523,   524,   525,   526,     0,   527,     0,
     174,     0,   528,   529,   530,     0,   175,     0,   176,     0,
     531,     0,     0,   532,     0,   533,   534,   535,   536,   537,
     538,   539,     0,   180,     0,   540,     0,     0,   541,   542,
     543,     0,     0,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,   555,   187,     0,   189,   556,   557,
     190,     0,   558,   559,     0,   560,     0,   193,   561,   194,
     562,   563,   564,     0,   565,     0,     0,   566,   567,   568,
       0,     0,   195,     0,     0,     0,   199,   569,   570,   571,
     572,   573,   574,   575,     0,   576,   200,   577,   201,   578,
     579,   580,     0,   581,   582,   583,   584,   585,   586,   587,
     203,   588,   589,   590,   591,     0,   592,   593,   594,   595,
     596,   597,   598,   599,   600,   601,     0,   602,   603,     0,
     604,   605,   211,   606,   607,   608,   609,   610,   611,   612,
     613,     0,   614,   615,   616,   617,   618,     0,   619,   216,
     620,   621,     0,   622,   219,     0,   623,   624,   625,   626,
     627,   628,   629,   630,   631,   632,   221,     0,   633,   634,
       0,   635,   636,   637,   638,   639,   640,     0,   223,   224,
       0,     0,   642,   225,   643,   226,     0,   644,   645,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
       0,     0,   655,   656,   657,   658,   659,   660,   233,     0,
     661,     0,   662,   663,   664,     0,     0,   665,     0,     0,
     666,   667,   668,   669,   670,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   671,   672,   673,     0,     0,     0,
       0,     0,     0,     0,   973,   974,    86,    87,    88,   411,
      90,    91,    92,   412,     0,   413,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   414,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   415,   416,     0,     0,     0,
     417,   418,     0,     0,     0,     0,   419,     0,     0,     0,
       0,     0,     0,     0,     0,   420,     0,   421,     0,   422,
     423,    35,   424,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,    45,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   430,   431,   432,  1368,
     433,   434,   435,     0,     0,     0,     0,     0,     0,     0,
     436,   437,     0,   438,   439,     0,   440,   441,   442,   135,
     136,     0,   138,   139,     0,   443,   444,   445,   446,   447,
       0,     0,   448,   449,   450,   140,   451,     0,   452,   453,
     454,   455,   144,     0,   456,     0,   457,   458,   459,   460,
       0,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,     0,   469,     0,     0,     0,     0,     0,     0,     0,
       0,   470,   471,   472,   473,   474,   475,   154,   155,   476,
       0,   477,     0,   478,   479,   480,   481,   482,     0,   483,
     484,   485,     0,     0,   486,   487,   488,   489,   490,     0,
     491,   492,   493,     0,   494,   495,     0,   496,   497,   498,
     499,   163,   500,   501,   502,   165,     0,   503,     0,   504,
     167,   505,     0,   506,     0,   507,     0,   967,     0,   508,
     509,   510,     0,   511,   171,     0,   512,     0,   513,   514,
     515,   516,   517,     0,   518,   519,   520,   968,   521,   522,
     523,   524,   525,   526,     0,   527,     0,   174,     0,   528,
     529,   530,     0,   175,     0,   176,     0,   531,     0,     0,
     532,     0,   533,   534,   535,   536,   537,   538,   539,     0,
     180,     0,   540,     0,     0,   541,   542,   543,     0,     0,
     544,   545,   546,   547,   548,   549,   550,   551,   552,   553,
     554,   555,   187,     0,   189,   556,   557,   190,     0,   558,
     559,     0,   560,     0,   193,   561,   194,   562,   563,   564,
       0,   565,     0,     0,   566,   567,   568,     0,     0,   195,
       0,     0,     0,   199,   569,   570,   571,   572,   573,   574,
     575,     0,   576,   200,   577,   201,   578,   579,   580,     0,
     581,   582,   583,   584,   585,   586,   587,   203,   588,   589,
     590,   591,     0,   592,   593,   594,   595,   596,   597,   598,
     599,   600,   601,     0,   602,   603,     0,   604,   605,   211,
     606,   607,   608,   609,   610,   611,   612,   613,     0,   614,
     615,   616,   617,   618,     0,   619,   216,   620,   621,     0,
     622,   219,     0,   623,   624,   625,   626,   627,   628,   629,
     630,   631,   632,   221,     0,   633,   634,     0,   635,   636,
     637,   638,   639,   640,     0,   223,   224,     0,     0,   642,
     225,   643,   226,     0,   644,   645,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,   654,     0,     0,   655,
     656,   657,   658,   659,   660,   233,     0,   661,     0,   662,
     663,   664,     0,     0,   665,     0,     0,   666,   667,   668,
     669,   670,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   671,   672,   673,     0,     0,     0,     0,     0,     0,
       0,   973,   974,    86,    87,    88,   411,    90,    91,    92,
     412,     0,   413,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   414,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   415,   416,     0,     0,     0,   417,   418,     0,
       0,     0,     0,   419,     0,     0,     0,     0,     0,     0,
       0,     0,   420,     0,   421,     0,   422,   423,    35,   424,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
       0,     0,     0,     0,     0,     0,     0,   436,   437,     0,
     438,   439,     0,   440,   441,   442,   135,   136,     0,   138,
     139,     0,   443,   444,   445,   446,   447,     0,     0,   448,
     449,   450,   140,   451,     0,   452,   453,   454,   455,   144,
       0,   456,     0,   457,   458,   459,   460,     0,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   469,
       0,     0,     0,     0,     0,     0,     0,     0,   470,   471,
     472,   473,   474,   475,   154,   155,   476,   695,   477,     0,
     478,   479,   480,   481,   482,     0,   483,   484,   485,     0,
       0,   486,   487,   488,   489,   490,     0,   491,   492,   493,
       0,   494,   495,     0,   496,   497,   498,   499,   163,   500,
     501,   502,   165,     0,   503,     0,   504,   167,   505,     0,
     506,     0,   507,     0,     0,     0,   508,   509,   510,     0,
     511,   171,     0,   512,     0,   513,   514,   515,   516,   517,
       0,   518,   519,   520,     0,   521,   522,   523,   524,   525,
     526,     0,   527,     0,   174,     0,   528,   529,   530,     0,
     175,     0,   176,     0,   531,     0,     0,   532,     0,   533,
     534,   535,   536,   537,   538,   539,     0,   180,     0,   540,
       0,     0,   541,   542,   543,     0,     0,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,   187,
       0,   189,   556,   557,   190,     0,   558,   559,     0,   560,
       0,   193,   561,   194,   562,   563,   564,     0,   565,     0,
       0,   566,   567,   568,     0,     0,   195,     0,     0,     0,
     199,   569,   570,   571,   572,   573,   574,   575,     0,   576,
     200,   577,   201,   578,   579,   580,     0,   581,   582,   583,
     584,   585,   586,   587,   203,   588,   589,   590,   591,     0,
     592,   593,   594,   595,   596,   597,   598,   599,   600,   601,
       0,   602,   603,     0,   604,   605,   211,   606,   607,   608,
     609,   610,   611,   612,   613,     0,   614,   615,   616,   617,
     618,     0,   619,   216,   620,   621,     0,   622,   219,     0,
     623,   624,   625,   626,   627,   628,   629,   630,   631,   632,
     221,     0,   633,   634,     0,   635,   636,   637,   638,   639,
     640,     0,   223,   224,  1530,     0,   642,   225,   643,   226,
       0,   644,   645,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,     0,     0,   655,   656,   657,   658,
     659,   660,   233,     0,   661,     0,   662,   663,   664,     0,
       0,   665,     0,     0,   666,   667,   668,   669,   670,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   671,   672,
     673,     0,     0,  1034,  1531,    86,    87,    88,   411,    90,
      91,    92,   412,  1035,   413,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   414,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   415,   416,     0,     0,     0,   417,
     418,     0,     0,     0,     0,   419,     0,     0,     0,     0,
       0,     0,     0,     0,   420,     0,   421,     0,   422,   423,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     425,   426,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,     0,     0,     0,     0,     0,     0,     0,   436,
     437,     0,   438,   439,     0,   440,   441,   442,   135,   136,
       0,   138,   139,     0,   443,   444,   445,   446,   447,     0,
       0,  1036,   449,  1010,   140,   451,     0,   452,   453,   454,
     455,   144,     0,   456,     0,   457,   458,   459,   460,     0,
     461,  1037,     0,  1038,   464,   465,   466,   467,   468,     0,
       0,   469,     0,     0,     0,     0,     0,     0,     0,     0,
     470,   471,   472,   473,   474,   475,   154,   155,   476,     0,
     477,     0,   478,   479,   480,   481,   482,     0,   483,   484,
     485,     0,     0,   486,   487,   488,   489,   490,     0,   491,
     492,   493,     0,   494,   495,     0,   496,   497,   498,   499,
     163,   500,   501,   502,   165,     0,   503,     0,   504,   167,
     505,     0,   506,     0,   507,     0,     0,     0,   508,   509,
     510,     0,   511,   171,     0,   512,     0,   513,   514,   515,
     516,   517,     0,   518,   519,   520,     0,   521,   522,   523,
     524,   525,   526,     0,   527,     0,   174,     0,   528,   529,
     530,     0,   175,     0,   176,     0,   531,     0,     0,   532,
       0,   533,   534,   535,   536,   537,   538,   539,     0,   180,
       0,   540,     0,     0,   541,   542,  1039,     0,     0,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
    1040,   187,     0,   189,   556,   557,   190,     0,   558,   559,
       0,   560,     0,   193,   561,   194,   562,   563,   564,     0,
     565,     0,     0,   566,   567,   568,     0,     0,   195,     0,
       0,     0,   199,   569,   570,   571,   572,   573,   574,   575,
       0,   576,   200,   577,   201,   578,   579,   580,     0,   581,
     582,   583,   584,   585,   586,   587,   203,   588,   589,   590,
     591,     0,   592,   593,   594,   595,   596,   597,   598,   599,
     600,   601,     0,   602,   603,     0,  1041,   605,   211,   606,
     607,   608,  1042,   610,   611,   612,   613,     0,   614,   615,
     616,   617,  1043,     0,   619,   216,   620,   621,     0,   622,
     219,     0,   623,   624,   625,   626,   627,   628,   629,   630,
     631,   632,   221,     0,   633,   634,     0,   635,   636,   637,
     638,   639,   640,     0,  1044,   224,     0,     0,  1045,   225,
     643,   226,     0,   644,   645,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,     0,     0,   655,   656,
     657,   658,   659,  1014,   233,     0,   661,     0,   662,   663,
     664,     0,     0,   665,     0,     0,   666,   667,   668,   669,
    1046,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     671,   672,   673,   710,    86,    87,    88,   411,    90,    91,
      92,   412,     0,   413,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   711,   104,   105,   414,   712,     0,   107,
     108,   109,   110,   713,   714,   112,   113,   114,   115,     0,
     116,   715,   716,   415,   416,     0,     0,     0,   417,   418,
       0,     0,     0,     0,   419,     0,     0,     0,     0,     0,
       0,     0,     0,   420,     0,   421,     0,   422,   423,    35,
       0,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,     0,     0,     0,    45,     0,     0,     0,     0,   425,
     426,   427,   428,   429,   430,   431,   432,   717,   433,   434,
     435,   718,   719,   720,   721,   722,   723,   724,   436,   437,
     725,   438,   439,   133,   440,   441,   442,   135,   136,   137,
     138,   139,   726,   443,   444,   445,   446,   447,   727,   728,
     448,   449,   729,   140,   451,   730,   452,   453,   454,   455,
     144,   731,   456,   732,   457,   458,   459,   460,   147,   461,
     733,   734,   463,   464,   465,   466,   467,   468,   735,   150,
     469,   736,   737,   738,   739,   151,   740,   741,   742,   470,
     471,   472,   473,   474,   475,   154,   155,   476,   743,   477,
     744,   478,   479,   480,   481,   482,   745,   483,   484,   485,
     746,   747,   486,   487,   488,   489,   490,   748,   491,   492,
     493,   749,   494,   495,   750,   496,   497,   498,   499,   163,
     500,   501,   502,   165,   751,   503,   752,   504,   167,   505,
     753,   506,   754,   507,   168,   755,   169,   508,   509,   510,
     756,   511,   171,   757,   512,   758,   513,   514,   515,   516,
     517,   172,   518,   519,   520,   759,   521,   522,   523,   524,
     525,   526,   760,   527,   173,   174,   761,   528,   529,   530,
     762,   175,   763,   176,   764,   531,   177,   178,   532,   179,
     533,   534,   535,   536,   537,   538,   539,   765,   180,   181,
     540,   182,   766,   541,   542,   543,   767,   768,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,   555,
     187,   188,   189,   556,   557,   190,   769,   558,   559,   192,
     560,   770,   193,   561,   194,   562,   563,   564,   771,   565,
     772,   773,   566,   567,   568,   774,   775,   195,   196,   197,
     198,   199,   569,   570,   571,   572,   573,   574,   575,   776,
     576,   200,   577,   201,   578,   579,   580,   777,   581,   582,
     583,   584,   585,   586,   587,   203,   588,   589,   590,   591,
     778,   592,   593,   594,   595,   596,   597,   598,   599,   600,
     601,   779,   602,   603,   209,   604,   605,   211,   606,   607,
     608,   609,   610,   611,   612,   613,   780,   614,   615,   616,
     617,   618,   781,   619,   216,   620,   621,   218,   622,   219,
     782,   623,   624,   625,   626,   627,   628,   629,   630,   631,
     632,   221,   783,   633,   634,   784,   635,   636,   637,   638,
     639,   640,   785,   223,   224,   786,   787,   642,   225,   643,
     226,   788,   644,   645,   646,   647,   648,   649,   789,   790,
     650,   651,   652,   653,   654,   791,   792,   655,   656,   657,
     658,   659,   793,   233,   794,   661,   234,   662,   663,   664,
     795,   796,   665,   797,   798,   666,   667,   668,   669,   670,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   671,
     672,   673,   710,    86,    87,    88,   411,    90,    91,    92,
     412,     0,   413,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   711,   104,   105,   414,   712,     0,   107,   108,
     109,   110,   713,   714,   112,   113,   114,   115,     0,   116,
     715,   716,   415,   416,     0,     0,     0,   417,   418,     0,
       0,     0,     0,   419,     0,     0,     0,     0,     0,     0,
       0,     0,   420,     0,   421,     0,   422,   423,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,   430,   431,   432,   717,   433,   434,   435,
     718,   719,   720,   721,   722,   723,   724,   436,   437,   725,
     438,   439,   133,   440,   441,   442,   135,   136,   137,   138,
     139,   726,   443,   444,   445,   446,   447,   727,   728,   448,
     449,   729,   140,   451,   730,   452,   453,   454,   455,   144,
     731,   456,   732,   457,   458,   459,   460,   147,   461,   733,
     734,   463,   464,   465,   466,   467,   468,   735,   150,   469,
     736,   737,   738,   739,   151,   740,   741,   742,   470,   471,
     472,   473,   474,   475,   154,   155,   476,   743,   477,   744,
     478,   479,   480,   481,   482,   745,   483,   484,   485,   746,
     747,   486,   487,   488,   489,   490,   748,   491,   492,   493,
     749,   494,   495,   750,   496,   497,   498,   499,   163,   500,
     501,   502,   165,   751,   503,   752,   504,   167,   505,   753,
     506,   754,   507,   168,   755,   169,   508,   509,   510,   756,
     511,   171,   757,   512,   758,   513,   514,   515,   516,   517,
     172,   518,   519,   520,   759,   521,   522,   523,   524,   525,
     526,   760,   527,   173,   174,   761,   528,   529,   530,   762,
     175,   763,   176,   764,   531,   177,   178,   532,   179,   533,
     534,   535,   536,   537,   538,   539,   765,   180,   181,   540,
     182,   766,   541,   542,   543,   767,   768,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,   187,
     188,   189,   556,   557,   190,   769,   558,   559,   192,   560,
     770,   193,   561,   194,   562,   563,   564,   771,   565,   772,
     773,   566,   567,   568,   774,   775,   195,   196,   197,   198,
     199,   569,   570,   571,   572,   573,   574,   575,   776,   576,
     200,   577,   201,   578,   579,   580,   777,   581,   582,   583,
     584,   585,   586,   587,   203,   588,   589,   590,   591,   778,
     592,   593,   594,   595,   596,   597,   598,   599,   600,   601,
     779,   602,   603,   209,   604,   605,   211,   606,   607,   608,
     609,   610,   611,   612,   613,   780,   614,   615,   616,   617,
     618,   781,   619,   216,   620,   621,   218,   622,   219,   782,
     623,   624,   625,   626,   627,   628,   629,   630,   631,   632,
     221,   783,   633,   634,   784,   635,   636,   637,   638,   639,
     640,   785,   223,   224,   786,   787,   642,   225,   643,   226,
     788,   644,   645,   646,   647,   648,   649,   789,   790,   650,
     651,   652,   653,   654,   791,   792,   655,   656,   657,   658,
     659,   793,   233,   794,   661,   234,   662,   663,   664,   795,
     796,   665,   797,   798,   666,   667,   668,   669,   670,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   671,   672,
     673,   710,    86,    87,    88,   411,    90,    91,    92,   412,
       0,   413,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   711,   104,   105,   414,   712,     0,   107,   108,   109,
     110,   713,   714,   112,   113,   114,   115,     0,   116,   715,
     716,   415,   416,     0,     0,     0,   417,   418,     0,     0,
       0,     0,   419,     0,     0,     0,     0,     0,     0,     0,
       0,   420,     0,   421,     0,   422,   423,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   425,   426,   427,
     428,  3050,   430,   431,   432,   717,   433,   434,   435,   718,
     719,   720,   721,   722,   723,   724,   436,   437,   725,   438,
     439,   133,   440,   441,   442,   135,   136,   137,   138,   139,
     726,   443,   444,   445,   446,   447,   727,   728,   448,   449,
     729,   140,   451,   730,   452,   453,   454,   455,   144,   731,
     456,   732,   457,   458,   459,   460,   147,   461,   733,   734,
     463,   464,   465,   466,   467,   468,   735,   150,   469,   736,
     737,   738,   739,   151,   740,   741,   742,   470,   471,   472,
     473,   474,   475,   154,   155,   476,   743,   477,   744,   478,
     479,   480,   481,   482,   745,   483,   484,   485,   746,   747,
     486,   487,   488,  3051,   490,   748,   491,   492,   493,   749,
     494,   495,   750,   496,   497,   498,   499,   163,   500,   501,
     502,   165,   751,   503,   752,   504,   167,   505,   753,   506,
     754,   507,   168,   755,   169,   508,   509,   510,   756,   511,
     171,   757,   512,   758,   513,   514,   515,   516,   517,   172,
     518,   519,   520,   759,   521,   522,   523,   524,   525,   526,
     760,   527,   173,   174,   761,   528,   529,   530,   762,   175,
     763,   176,   764,   531,   177,   178,   532,   179,   533,   534,
     535,   536,   537,   538,   539,   765,   180,   181,   540,   182,
     766,   541,   542,   543,   767,   768,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,   555,   187,   188,
     189,   556,   557,   190,   769,   558,   559,   192,   560,   770,
     193,   561,   194,   562,   563,   564,   771,   565,   772,   773,
     566,   567,   568,   774,   775,   195,   196,   197,   198,   199,
     569,   570,   571,   572,   573,   574,   575,   776,   576,   200,
     577,   201,   578,   579,   580,   777,   581,   582,   583,   584,
     585,   586,   587,   203,   588,   589,   590,   591,   778,   592,
     593,   594,   595,   596,   597,   598,   599,   600,   601,   779,
     602,   603,   209,   604,   605,   211,   606,   607,   608,   609,
     610,   611,   612,   613,   780,   614,   615,   616,   617,   618,
     781,  3052,   216,   620,   621,   218,   622,   219,   782,   623,
     624,   625,   626,   627,   628,   629,   630,   631,   632,   221,
     783,   633,   634,   784,   635,   636,   637,   638,   639,   640,
     785,   223,   224,   786,   787,   642,   225,   643,   226,   788,
     644,   645,   646,   647,   648,   649,   789,   790,   650,   651,
     652,   653,   654,   791,   792,   655,   656,   657,   658,   659,
     793,   233,   794,   661,   234,   662,   663,   664,   795,   796,
     665,   797,   798,   666,   667,   668,   669,   670,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   671,   672,   673,
     710,    86,    87,    88,   411,    90,    91,    92,   412,     0,
     413,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     711,   104,   105,   414,   712,     0,   107,   108,   109,   110,
     713,   714,   112,   113,   114,   115,     0,   116,   715,   716,
     415,   416,     0,     0,     0,   417,   418,     0,     0,     0,
       0,   419,     0,     0,     0,     0,     0,     0,     0,     0,
     420,     0,   421,     0,   422,   423,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   425,   426,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,     0,     0,
       0,     0,     0,     0,     0,   436,   437,     0,   438,   439,
     133,   440,   441,   442,   135,   136,   137,   138,   139,     0,
     443,   444,   445,   446,   447,     0,     0,   448,   449,   450,
     140,   451,     0,   452,   453,   454,   455,   144,     0,   456,
       0,   457,   458,   459,   460,   147,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,   150,   469,     0,     0,
       0,     0,   151,     0,     0,     0,   470,   471,   472,   473,
     474,   475,   154,   155,   476,     0,   477,     0,   478,   479,
     480,   481,   482,     0,   483,   484,   485,     0,     0,   486,
     487,   488,   489,   490,     0,   491,   492,   493,     0,   494,
     495,     0,   496,   497,   498,   499,   163,   500,   501,   502,
     165,     0,   503,     0,   504,   167,   505,     0,   506,     0,
     507,   168,     0,   169,   508,   509,   510,     0,   511,   171,
       0,   512,     0,   513,   514,   515,   516,   517,   172,   518,
     519,   520,     0,   521,   522,   523,   524,   525,   526,     0,
     527,   173,   174,     0,   528,   529,   530,     0,   175,     0,
     176,     0,   531,   177,   178,   532,   179,   533,   534,   535,
     536,   537,   538,   539,     0,   180,   181,   540,   182,     0,
     541,   542,   543,     0,     0,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,   555,   187,   188,   189,
     556,   557,   190,     0,   558,   559,   192,   560,     0,   193,
     561,   194,   562,   563,   564,     0,   565,     0,     0,   566,
     567,   568,     0,     0,   195,   196,   197,   198,   199,   569,
     570,   571,   572,   573,   574,   575,     0,   576,   200,   577,
     201,   578,   579,   580,     0,   581,   582,   583,   584,   585,
     586,   587,   203,   588,   589,   590,   591,     0,   592,   593,
     594,   595,   596,   597,   598,   599,   600,   601,     0,   602,
     603,   209,   604,   605,   211,   606,   607,   608,   609,   610,
     611,   612,   613,     0,   614,   615,   616,   617,   618,     0,
     619,   216,   620,   621,   218,   622,   219,     0,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   221,     0,
     633,   634,     0,   635,   636,   637,   638,   639,   640,     0,
     223,   224,     0,     0,   642,   225,   643,   226,     0,   644,
     645,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,   654,     0,     0,   655,   656,   657,   658,   659,   660,
     233,     0,   661,   234,   662,   663,   664,     0,     0,   665,
       0,     0,   666,   667,   668,   669,   670,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   671,   672,   673,   710,
      86,    87,    88,   411,    90,    91,    92,   412,     0,   413,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   711,
     104,   105,   414,   712,     0,   107,   108,   109,   110,   713,
     714,   112,   113,   114,   115,     0,   116,   715,   716,   415,
     416,     0,     0,     0,   417,   418,     0,     0,     0,     0,
     419,     0,     0,     0,     0,     0,     0,     0,     0,   420,
       0,   421,     0,   422,   423,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   425,   426,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,     0,     0,     0,
       0,     0,     0,     0,   436,   437,     0,   438,   439,   133,
     440,   441,   442,   135,   136,   137,   138,   139,     0,   443,
     444,   445,   446,   447,     0,     0,   448,   449,   450,   140,
     451,     0,   452,   453,   454,   455,   144,     0,   456,     0,
     457,   458,   459,   460,   147,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,   150,   469,     0,     0,     0,
       0,   151,     0,     0,     0,   470,   471,   472,   473,   474,
     475,   154,   155,   476,     0,   477,     0,   478,   479,   480,
     481,   482,     0,   483,   484,   485,     0,     0,   486,   487,
     488,   489,   490,     0,   491,   492,   493,     0,   494,   495,
       0,   496,   497,   498,   499,   163,   500,   501,   502,   165,
       0,   503,     0,   504,   167,   505,     0,   506,     0,   507,
     168,     0,   169,   508,   509,   510,     0,   511,   171,     0,
     512,     0,   513,   514,   515,   516,  1299,   172,   518,   519,
     520,     0,   521,   522,   523,   524,   525,   526,     0,   527,
     173,   174,     0,   528,   529,   530,     0,   175,     0,   176,
       0,   531,   177,   178,   532,   179,   533,   534,   535,   536,
     537,   538,   539,     0,   180,   181,   540,   182,     0,   541,
     542,   543,     0,     0,   544,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,   555,   187,   188,   189,   556,
     557,   190,     0,   558,   559,   192,   560,     0,   193,   561,
     194,   562,   563,   564,     0,   565,     0,     0,   566,   567,
     568,     0,     0,   195,   196,   197,   198,   199,   569,   570,
     571,   572,   573,   574,   575,     0,   576,   200,   577,   201,
     578,   579,   580,     0,   581,   582,   583,   584,   585,   586,
     587,   203,   588,   589,   590,   591,     0,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,     0,   602,   603,
     209,   604,   605,   211,   606,   607,   608,   609,   610,   611,
     612,   613,     0,   614,   615,   616,   617,   618,     0,   619,
     216,   620,   621,   218,   622,   219,     0,   623,   624,   625,
     626,   627,   628,   629,   630,   631,   632,   221,     0,   633,
     634,     0,   635,   636,   637,   638,   639,   640,     0,   223,
     224,     0,     0,   642,   225,   643,   226,     0,   644,   645,
     646,   647,   648,   649,     0,     0,   650,   651,   652,   653,
     654,     0,     0,   655,   656,   657,   658,   659,   660,   233,
       0,   661,   234,   662,   663,   664,     0,     0,   665,     0,
       0,   666,   667,   668,   669,   670,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   671,   672,   673,   710,    86,
      87,    88,   411,    90,    91,    92,   412,     0,   413,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   711,   104,
     105,   414,   712,     0,   107,   108,   109,   110,   713,   714,
     112,   113,   114,   115,     0,   116,   715,   716,   415,   416,
       0,     0,     0,   417,   418,     0,     0,     0,     0,   419,
       0,     0,     0,     0,     0,     0,     0,     0,   420,     0,
     421,     0,   422,   423,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   425,   426,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,     0,     0,     0,     0,
       0,     0,     0,   436,   437,     0,   438,   439,   133,   440,
     441,   442,   135,   136,   137,   138,   139,     0,   443,   444,
     445,   446,   447,     0,     0,   448,   449,   450,   140,   451,
       0,   452,   453,   454,   455,   144,     0,   456,     0,   457,
     458,   459,   460,   147,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,   150,   469,     0,     0,     0,     0,
     151,     0,     0,     0,   470,   471,   472,   473,   474,   475,
     154,   155,   476,     0,   477,     0,   478,   479,   480,   481,
     482,     0,   483,   484,   485,     0,     0,   486,   487,   488,
     489,   490,     0,   491,   492,   493,     0,   494,   495,     0,
     496,   497,   498,   499,   163,   500,   501,   502,   165,     0,
     503,     0,   504,   167,   505,     0,   506,     0,   507,   168,
       0,   169,   508,   509,   510,     0,   511,   171,     0,   512,
       0,   513,   514,   515,   516,  1308,   172,   518,   519,   520,
       0,   521,   522,   523,   524,   525,   526,     0,   527,   173,
     174,     0,   528,   529,   530,     0,   175,     0,   176,     0,
     531,   177,   178,   532,   179,   533,   534,   535,   536,   537,
     538,   539,     0,   180,   181,   540,   182,     0,   541,   542,
     543,     0,     0,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,   555,   187,   188,   189,   556,   557,
     190,     0,   558,   559,   192,   560,     0,   193,   561,   194,
     562,   563,   564,     0,   565,     0,     0,   566,   567,   568,
       0,     0,   195,   196,   197,   198,   199,   569,   570,   571,
     572,   573,   574,   575,     0,   576,   200,   577,   201,   578,
     579,   580,     0,   581,   582,   583,   584,   585,   586,   587,
     203,   588,   589,   590,   591,     0,   592,   593,   594,   595,
     596,   597,   598,   599,   600,   601,     0,   602,   603,   209,
     604,   605,   211,   606,   607,   608,   609,   610,   611,   612,
     613,     0,   614,   615,   616,   617,   618,     0,   619,   216,
     620,   621,   218,   622,   219,     0,   623,   624,   625,   626,
     627,   628,   629,   630,   631,   632,   221,     0,   633,   634,
       0,   635,   636,   637,   638,   639,   640,     0,   223,   224,
       0,     0,   642,   225,   643,   226,     0,   644,   645,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
       0,     0,   655,   656,   657,   658,   659,   660,   233,     0,
     661,   234,   662,   663,   664,     0,     0,   665,     0,     0,
     666,   667,   668,   669,   670,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   671,   672,   673,   710,    86,    87,
      88,   411,    90,    91,    92,   412,     0,   413,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   711,   104,   105,
     414,   712,     0,   107,   108,   109,   110,   713,   714,   112,
     113,   114,   115,     0,   116,   715,   716,   415,   416,     0,
       0,     0,   417,   418,     0,     0,     0,     0,   419,     0,
       0,     0,     0,     0,     0,     0,     0,   420,     0,   421,
       0,   422,   423,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   425,   426,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,     0,     0,     0,     0,     0,
       0,     0,   436,   437,     0,   438,   439,   133,   440,   441,
     442,     0,  1835,   137,  1836,  1837,     0,   443,   444,   445,
     446,   447,     0,     0,   448,   449,  1838,  1839,   451,     0,
     452,   453,   454,   455,     0,     0,   456,     0,   457,   458,
     459,   460,   147,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,   150,   469,     0,     0,     0,     0,   151,
       0,     0,     0,   470,   471,   472,   473,   474,   475,  1840,
    1841,   476,     0,   477,     0,   478,   479,   480,   481,   482,
       0,   483,   484,   485,     0,     0,   486,   487,  1448,   489,
     490,     0,   491,   492,   493,     0,   494,   495,     0,   496,
     497,   498,   499,     0,   500,   501,   502,     0,     0,   503,
       0,   504,  1842,   505,     0,   506,     0,   507,   168,     0,
     169,   508,   509,   510,     0,   511,     0,     0,   512,     0,
     513,   514,   515,   516,   517,   172,   518,   519,   520,  2381,
     521,   522,   523,   524,   525,   526,     0,   527,   173,  2382,
       0,   528,   529,   530,  1454,  1843,     0,  1844,     0,   531,
     177,   178,   532,   179,   533,   534,   535,   536,   537,   538,
     539,     0,     0,   181,   540,   182,     0,   541,   542,   543,
       0,     0,   544,   545,   546,   547,   548,   549,   550,   551,
     552,   553,   554,   555,  1845,   188,  1846,   556,   557,     0,
       0,   558,   559,   192,   560,     0,     0,   561,  1847,   562,
     563,   564,     0,   565,     0,     0,   566,   567,   568,     0,
       0,  2383,   196,   197,   198,     0,   569,   570,   571,   572,
     573,   574,   575,     0,   576,     0,   577,     0,   578,   579,
     580,     0,   581,   582,   583,   584,   585,   586,   587,  1848,
     588,   589,   590,   591,     0,   592,   593,   594,   595,   596,
     597,   598,   599,   600,   601,     0,   602,   603,   209,   604,
     605,     0,   606,   607,   608,   609,   610,   611,   612,   613,
       0,   614,   615,   616,   617,   618,     0,   619,  2384,   620,
     621,   218,   622,  1850,     0,   623,   624,   625,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,     0,
     635,   636,   637,   638,   639,   640,     0,  1851,  1852,     0,
       0,   642,     0,   643,     0,     0,   644,   645,   646,   647,
     648,   649,     0,     0,   650,   651,   652,   653,   654,     0,
       0,   655,   656,   657,   658,   659,     0,  1853,  2385,   661,
     234,   662,   663,   664,     0,     0,   665,     0,     0,   666,
     667,   668,   669,   670,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   671,   672,   673,   710,    86,    87,    88,
     411,    90,    91,    92,   412,     0,   413,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   711,   104,   105,   414,
     712,     0,   107,   108,   109,   110,   713,   714,   112,   113,
     114,   115,     0,   116,   715,   716,   415,   416,     0,     0,
       0,   417,   418,     0,     0,     0,     0,   419,     0,     0,
       0,     0,     0,     0,     0,     0,   420,     0,   421,     0,
     422,   423,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   425,   426,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,     0,     0,     0,     0,     0,     0,
       0,   436,   437,     0,   438,   439,   133,   440,   441,   442,
       0,  1835,   137,  1836,  1837,     0,   443,   444,   445,   446,
     447,     0,     0,   448,   449,  1838,  1839,   451,     0,   452,
     453,   454,   455,     0,     0,   456,     0,   457,   458,   459,
     460,   147,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,   150,   469,     0,     0,     0,     0,   151,     0,
       0,     0,   470,   471,   472,   473,   474,   475,  1840,  1841,
     476,     0,   477,     0,   478,   479,   480,   481,   482,     0,
     483,   484,   485,     0,     0,   486,   487,  1448,   489,   490,
       0,   491,   492,   493,     0,   494,   495,     0,   496,   497,
     498,   499,     0,   500,   501,   502,     0,     0,   503,     0,
     504,  1842,   505,     0,   506,     0,   507,   168,     0,   169,
     508,   509,   510,     0,   511,     0,     0,   512,     0,   513,
     514,   515,   516,   517,   172,   518,   519,   520,     0,   521,
     522,   523,   524,   525,   526,     0,   527,   173,     0,     0,
     528,   529,   530,  1454,  1843,     0,  1844,     0,   531,   177,
     178,   532,   179,   533,   534,   535,   536,   537,   538,   539,
       0,     0,   181,   540,   182,     0,   541,   542,   543,     0,
       0,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,  1845,   188,  1846,   556,   557,     0,     0,
     558,   559,   192,   560,  2373,     0,   561,  1847,   562,   563,
     564,     0,   565,     0,     0,   566,   567,   568,     0,     0,
       0,   196,   197,   198,     0,   569,   570,   571,   572,   573,
     574,   575,     0,   576,     0,   577,     0,   578,   579,   580,
       0,   581,   582,   583,   584,   585,   586,   587,  1848,   588,
     589,   590,   591,     0,   592,   593,   594,   595,   596,   597,
     598,   599,   600,   601,     0,   602,   603,   209,   604,   605,
       0,   606,   607,   608,   609,   610,   611,   612,   613,     0,
     614,   615,   616,   617,   618,     0,   619,  2384,   620,   621,
     218,   622,  1850,     0,   623,   624,   625,   626,   627,   628,
     629,   630,   631,   632,     0,     0,   633,   634,  3788,   635,
     636,   637,   638,   639,   640,     0,  1851,  1852,     0,     0,
     642,     0,   643,     0,     0,   644,   645,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,     0,     0,
     655,   656,   657,   658,   659,     0,  1853,     0,   661,   234,
     662,   663,   664,     0,     0,   665,     0,     0,   666,   667,
     668,   669,   670,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   671,   672,   673,   710,    86,    87,    88,   411,
      90,    91,    92,   412,     0,   413,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   711,   104,   105,   414,   712,
       0,   107,   108,   109,   110,   713,   714,   112,   113,   114,
     115,     0,   116,   715,   716,   415,   416,     0,     0,     0,
     417,   418,     0,     0,     0,     0,   419,     0,     0,     0,
       0,     0,     0,     0,     0,   420,     0,   421,     0,   422,
     423,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,     0,     0,     0,     0,     0,     0,     0,
     436,   437,     0,   438,   439,   133,   440,   441,   442,     0,
    1835,   137,  1836,  1837,     0,   443,   444,   445,   446,   447,
       0,     0,   448,   449,  1838,  1839,   451,     0,   452,   453,
     454,   455,     0,     0,   456,     0,   457,   458,   459,   460,
     147,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,   150,   469,     0,     0,     0,     0,   151,     0,     0,
       0,   470,   471,   472,   473,   474,   475,  1840,  1841,   476,
       0,   477,     0,   478,   479,   480,   481,   482,     0,   483,
     484,   485,     0,     0,   486,   487,  1448,   489,   490,     0,
     491,   492,   493,     0,   494,   495,     0,   496,   497,   498,
     499,     0,   500,   501,   502,     0,     0,   503,     0,   504,
    1842,   505,     0,   506,     0,   507,   168,     0,   169,   508,
     509,   510,     0,   511,     0,     0,   512,     0,   513,   514,
     515,   516,   517,   172,   518,   519,   520,     0,   521,   522,
     523,   524,   525,   526,     0,   527,   173,     0,     0,   528,
     529,   530,  1454,  1843,     0,  1844,     0,   531,   177,   178,
     532,   179,   533,   534,   535,   536,   537,   538,   539,     0,
       0,   181,   540,   182,     0,   541,   542,   543,     0,     0,
     544,   545,   546,   547,   548,   549,   550,   551,   552,   553,
     554,   555,  1845,   188,  1846,   556,   557,  2430,     0,   558,
     559,   192,   560,     0,     0,   561,  1847,   562,   563,   564,
       0,   565,     0,     0,   566,   567,   568,     0,     0,     0,
     196,   197,   198,     0,   569,   570,   571,   572,   573,   574,
     575,     0,   576,     0,   577,     0,   578,   579,   580,     0,
     581,   582,   583,   584,   585,   586,   587,  1848,   588,   589,
     590,   591,     0,   592,   593,   594,   595,   596,   597,   598,
     599,   600,   601,     0,   602,   603,   209,   604,   605,     0,
     606,   607,   608,   609,   610,   611,   612,   613,     0,   614,
     615,   616,   617,   618,     0,   619,  1849,   620,   621,   218,
     622,  1850,     0,   623,   624,   625,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,     0,   635,   636,
     637,   638,   639,   640,     0,  1851,  1852,     0,     0,   642,
       0,   643,     0,     0,   644,   645,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,   654,     0,     0,   655,
     656,   657,   658,   659,     0,  1853,     0,   661,   234,   662,
     663,   664,     0,     0,   665,     0,     0,   666,   667,   668,
     669,   670,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   671,   672,   673,   710,    86,    87,    88,   411,    90,
      91,    92,   412,     0,   413,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   711,   104,   105,   414,   712,     0,
     107,   108,   109,   110,   713,   714,   112,   113,   114,   115,
       0,   116,   715,   716,   415,   416,     0,     0,     0,   417,
     418,     0,     0,     0,     0,   419,     0,     0,     0,     0,
       0,     0,     0,     0,   420,     0,   421,     0,   422,   423,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     425,   426,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,     0,     0,     0,     0,     0,     0,     0,   436,
     437,     0,   438,   439,   133,   440,   441,   442,     0,  1835,
     137,  1836,  1837,     0,   443,   444,   445,   446,   447,     0,
       0,   448,   449,  1838,  1839,   451,     0,   452,   453,   454,
     455,     0,     0,   456,     0,   457,   458,   459,   460,   147,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
     150,   469,     0,     0,     0,     0,   151,     0,     0,     0,
     470,   471,   472,   473,   474,   475,  1840,  1841,   476,     0,
     477,     0,   478,   479,   480,   481,   482,     0,   483,   484,
     485,     0,     0,   486,   487,  1448,   489,   490,     0,   491,
     492,   493,     0,   494,   495,     0,   496,   497,   498,   499,
       0,   500,   501,   502,     0,     0,   503,     0,   504,  1842,
     505,     0,   506,     0,   507,   168,     0,   169,   508,   509,
     510,     0,   511,     0,     0,   512,     0,   513,   514,   515,
     516,   517,   172,   518,   519,   520,     0,   521,   522,   523,
     524,   525,   526,     0,   527,   173,     0,     0,   528,   529,
     530,  1454,  1843,     0,  1844,     0,   531,   177,   178,   532,
     179,   533,   534,   535,   536,   537,   538,   539,     0,     0,
     181,   540,   182,     0,   541,   542,   543,     0,     0,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,  1845,   188,  1846,   556,   557,  3618,     0,   558,   559,
     192,   560,     0,     0,   561,  1847,   562,   563,   564,     0,
     565,     0,     0,   566,   567,   568,     0,     0,     0,   196,
     197,   198,     0,   569,   570,   571,   572,   573,   574,   575,
       0,   576,     0,   577,     0,   578,   579,   580,     0,   581,
     582,   583,   584,   585,   586,   587,  1848,   588,   589,   590,
     591,     0,   592,   593,   594,   595,   596,   597,   598,   599,
     600,   601,     0,   602,   603,   209,   604,   605,     0,   606,
     607,   608,   609,   610,   611,   612,   613,     0,   614,   615,
     616,   617,   618,     0,   619,  1849,   620,   621,   218,   622,
    1850,     0,   623,   624,   625,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,     0,   635,   636,   637,
     638,   639,   640,     0,  1851,  1852,     0,     0,   642,     0,
     643,     0,     0,   644,   645,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,     0,     0,   655,   656,
     657,   658,   659,     0,  1853,     0,   661,   234,   662,   663,
     664,     0,     0,   665,     0,     0,   666,   667,   668,   669,
     670,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     671,   672,   673,   710,    86,    87,    88,   411,    90,    91,
      92,   412,     0,   413,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   711,   104,   105,   414,   712,     0,   107,
     108,   109,   110,   713,   714,   112,   113,   114,   115,     0,
     116,   715,   716,   415,   416,     0,     0,     0,   417,   418,
       0,     0,     0,     0,   419,     0,     0,     0,     0,     0,
       0,     0,     0,   420,     0,   421,     0,   422,   423,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   425,
     426,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,     0,     0,     0,     0,     0,     0,     0,   436,   437,
       0,   438,   439,   133,   440,   441,   442,     0,  1835,   137,
    1836,  1837,     0,   443,   444,   445,   446,   447,     0,     0,
     448,   449,  1838,  1839,   451,     0,   452,   453,   454,   455,
       0,     0,   456,     0,   457,   458,   459,   460,   147,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,   150,
     469,     0,     0,     0,     0,   151,     0,     0,     0,   470,
     471,   472,   473,   474,   475,  1840,  1841,   476,     0,   477,
       0,   478,   479,   480,   481,   482,     0,   483,   484,   485,
       0,     0,   486,   487,  1448,   489,   490,     0,   491,   492,
     493,     0,   494,   495,     0,   496,   497,   498,   499,     0,
     500,   501,   502,     0,     0,   503,     0,   504,  1842,   505,
       0,   506,     0,   507,   168,     0,   169,   508,   509,   510,
       0,   511,     0,     0,   512,     0,   513,   514,   515,   516,
     517,   172,   518,   519,   520,     0,   521,   522,   523,   524,
     525,   526,     0,   527,   173,     0,     0,   528,   529,   530,
    1454,  1843,     0,  1844,     0,   531,   177,   178,   532,   179,
     533,   534,   535,   536,   537,   538,   539,     0,     0,   181,
     540,   182,     0,   541,   542,   543,     0,     0,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,   555,
    1845,   188,  1846,   556,   557,     0,     0,   558,   559,   192,
     560,     0,     0,   561,  1847,   562,   563,   564,     0,   565,
       0,     0,   566,   567,   568,     0,     0,     0,   196,   197,
     198,     0,   569,   570,   571,   572,   573,   574,   575,     0,
     576,     0,   577,     0,   578,   579,   580,     0,   581,   582,
     583,   584,   585,   586,   587,  1848,   588,   589,   590,   591,
       0,   592,   593,   594,   595,   596,   597,   598,   599,   600,
     601,     0,   602,   603,   209,   604,   605,     0,   606,   607,
     608,   609,   610,   611,   612,   613,     0,   614,   615,   616,
     617,   618,     0,   619,  1849,   620,   621,   218,   622,  1850,
       0,   623,   624,   625,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,     0,   635,   636,   637,   638,
     639,   640,     0,  1851,  1852,     0,     0,   642,     0,   643,
       0,     0,   644,   645,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,   654,     0,     0,   655,   656,   657,
     658,   659,     0,  1853,     0,   661,   234,   662,   663,   664,
       0,     0,   665,     0,     0,   666,   667,   668,   669,   670,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   671,
     672,   673,   710,    86,    87,    88,   411,    90,    91,    92,
     412,     0,   413,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   711,   104,   105,   414,   712,     0,   107,   108,
     109,   110,   713,   714,   112,   113,   114,   115,     0,   116,
     715,   716,   415,   416,     0,     0,     0,   417,   418,     0,
       0,     0,     0,   419,     0,     0,     0,     0,     0,     0,
       0,     0,   420,     0,   421,     0,   422,   423,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
       0,     0,     0,     0,     0,     0,     0,   436,   437,     0,
     438,   439,   133,   440,   441,   442,     0,  1835,   137,  1836,
    1837,     0,   443,   444,   445,   446,   447,     0,     0,   448,
     449,  1838,  1839,   451,     0,   452,   453,   454,   455,     0,
       0,   456,     0,   457,   458,   459,   460,   147,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,   150,   469,
       0,     0,     0,     0,   151,     0,     0,     0,   470,   471,
     472,   473,   474,   475,  1840,  1841,   476,     0,   477,     0,
     478,   479,   480,   481,   482,     0,   483,   484,   485,     0,
       0,   486,   487,  1448,   489,   490,     0,   491,   492,   493,
       0,   494,   495,     0,   496,   497,   498,   499,     0,   500,
     501,   502,     0,     0,   503,     0,   504,  1842,   505,     0,
     506,     0,   507,   168,     0,   169,   508,   509,   510,     0,
     511,     0,     0,   512,     0,   513,   514,   515,   516,   517,
     172,   518,   519,   520,     0,   521,   522,   523,   524,   525,
     526,     0,   527,   173,     0,     0,   528,   529,   530,  1454,
    1843,     0,  1844,     0,   531,   177,   178,   532,   179,   533,
     534,   535,   536,   537,   538,   539,     0,     0,   181,   540,
     182,     0,   541,   542,   543,     0,     0,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,  1845,
     188,  1846,   556,   557,     0,     0,   558,   559,   192,   560,
       0,     0,   561,  1847,   562,   563,   564,     0,   565,     0,
       0,   566,   567,   568,     0,     0,     0,   196,   197,   198,
       0,   569,   570,   571,   572,   573,   574,   575,     0,   576,
       0,   577,     0,   578,   579,   580,     0,   581,   582,   583,
     584,   585,   586,   587,  1848,   588,   589,   590,   591,     0,
     592,   593,   594,   595,   596,   597,   598,   599,   600,   601,
       0,   602,   603,   209,   604,   605,     0,   606,   607,   608,
     609,   610,   611,   612,   613,     0,   614,   615,   616,   617,
     618,     0,   619,  2384,   620,   621,   218,   622,  1850,     0,
     623,   624,   625,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,     0,   635,   636,   637,   638,   639,
     640,     0,  1851,  1852,     0,     0,   642,     0,   643,     0,
       0,   644,   645,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,     0,     0,   655,   656,   657,   658,
     659,     0,  1853,     0,   661,   234,   662,   663,   664,     0,
       0,   665,     0,     0,   666,   667,   668,   669,   670,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   671,   672,
     673,   710,    86,    87,    88,   411,    90,    91,    92,   412,
       0,   413,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   711,   104,   105,   414,   712,     0,   107,   108,   109,
     110,   713,   714,   112,   113,   114,   115,     0,   116,   715,
     716,   415,   416,     0,     0,     0,   417,   418,     0,     0,
       0,     0,   419,     0,     0,     0,     0,     0,     0,     0,
       0,   420,     0,   421,     0,   422,   423,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   425,   426,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,     0,
       0,     0,     0,     0,     0,     0,   436,   437,     0,   438,
     439,   133,   440,   441,   442,     0,  1835,   137,  1836,  1837,
       0,   443,   444,   445,   446,   447,     0,     0,   448,   449,
    1838,  1839,   451,     0,   452,   453,   454,   455,     0,     0,
     456,     0,   457,   458,   459,   460,   147,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,   150,   469,     0,
       0,     0,     0,   151,     0,     0,     0,   470,   471,   472,
     473,   474,   475,  1840,  1841,   476,     0,   477,     0,   478,
     479,   480,   481,   482,     0,   483,   484,   485,     0,     0,
     486,   487,  1448,   489,   490,     0,   491,   492,   493,     0,
     494,   495,     0,   496,   497,   498,   499,     0,   500,   501,
     502,     0,     0,   503,     0,   504,  1842,   505,     0,   506,
       0,   507,   168,     0,   169,   508,   509,   510,     0,   511,
       0,     0,   512,     0,   513,   514,   515,   516,   517,   172,
     518,   519,   520,     0,   521,   522,   523,   524,   525,   526,
       0,   527,   173,     0,     0,   528,   529,   530,  1454,  1843,
       0,  1844,     0,   531,   177,   178,   532,   179,   533,   534,
     535,   536,   537,   538,   539,     0,     0,   181,   540,   182,
       0,   541,   542,   543,     0,     0,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,   555,  1845,   188,
    1846,   556,   557,     0,     0,   558,   559,   192,   560,     0,
       0,   561,  1847,   562,   563,   564,     0,   565,     0,     0,
     566,   567,   568,     0,     0,     0,   196,   197,   198,     0,
     569,   570,   571,   572,   573,   574,   575,     0,   576,     0,
     577,     0,   578,   579,   580,     0,   581,   582,   583,   584,
     585,   586,   587,  1848,   588,   589,   590,   591,     0,   592,
     593,   594,   595,   596,   597,   598,   599,   600,   601,     0,
     602,   603,   209,   604,   605,     0,   606,   607,   608,   609,
     610,   611,   612,   613,     0,   614,   615,   616,   617,   618,
       0,   619,     0,   620,   621,   218,   622,  1850,     0,   623,
     624,   625,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,     0,   635,   636,   637,   638,   639,   640,
       0,  1851,  1852,     0,     0,   642,     0,   643,     0,     0,
     644,   645,   646,   647,   648,   649,     0,     0,   650,   651,
     652,   653,   654,     0,     0,   655,   656,   657,   658,   659,
       0,  1853,     0,   661,   234,   662,   663,   664,     0,     0,
     665,     0,     0,   666,   667,   668,   669,   670,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   671,   672,   673,
     710,    86,    87,    88,   411,    90,    91,    92,   412,     0,
     413,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     711,   104,   105,   414,   712,     0,   107,   108,   109,   110,
     713,   714,   112,   113,   114,   115,     0,   116,   715,   716,
     415,   416,     0,     0,     0,   417,   418,     0,     0,     0,
       0,   419,     0,     0,     0,     0,     0,     0,     0,     0,
     420,     0,   421,     0,   422,   423,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   425,   426,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,     0,     0,
       0,     0,     0,     0,     0,   436,   437,     0,   438,   439,
     133,   440,   441,   442,     0,     0,   137,     0,     0,     0,
     443,   444,   445,   446,   447,     0,     0,   448,   449,     0,
       0,   451,     0,   452,   453,   454,   455,     0,     0,   456,
       0,   457,   458,   459,   460,   147,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,   150,   469,     0,     0,
       0,     0,   151,     0,     0,     0,   470,   471,   472,   473,
     474,   475,     0,     0,   476,     0,   477,     0,   478,   479,
     480,   481,   482,     0,   483,   484,   485,     0,     0,   486,
     487,   488,   489,   490,     0,   491,   492,   493,     0,   494,
     495,     0,   496,   497,   498,   499,     0,   500,   501,   502,
       0,     0,   503,     0,   504,     0,   505,     0,   506,     0,
     507,   168,     0,   169,   508,   509,   510,     0,   511,     0,
       0,   512,     0,   513,   514,   515,   516,   517,   172,   518,
     519,   520,     0,   521,   522,   523,   524,   525,   526,     0,
     527,   173,     0,     0,   528,   529,   530,     0,     0,     0,
       0,     0,   531,   177,   178,   532,   179,   533,   534,   535,
     536,   537,   538,   539,     0,     0,   181,   540,   182,     0,
     541,   542,   543,     0,     0,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,   555,     0,   188,     0,
     556,   557,     0,     0,   558,   559,   192,   560,     0,     0,
     561,     0,   562,   563,   564,     0,   565,     0,     0,   566,
     567,   568,     0,     0,     0,   196,   197,   198,     0,   569,
     570,   571,   572,   573,   574,   575,     0,   576,     0,   577,
       0,   578,   579,   580,     0,   581,   582,   583,   584,   585,
     586,   587,     0,   588,   589,   590,   591,     0,   592,   593,
     594,   595,   596,   597,   598,   599,   600,   601,     0,   602,
     603,   209,   604,   605,     0,   606,   607,   608,   609,   610,
     611,   612,   613,     0,   614,   615,   616,   617,   618,     0,
     619,     0,   620,   621,   218,   622,     0,     0,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,     0,   635,   636,   637,   638,   639,   640,     0,
       0,     0,     0,     0,   642,     0,   643,     0,     0,   644,
     645,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,   654,     0,     0,   655,   656,   657,   658,   659,     0,
       0,     0,   661,   234,   662,   663,   664,     0,     0,   665,
       0,     0,   666,   667,   668,   669,   670,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   671,   672,   673,    86,
      87,    88,   411,    90,    91,    92,   412,     0,   413,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   414,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   415,   416,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   425,   426,   427,   428,   429,   430,
     431,   432,   717,   433,   434,   435,   718,   719,   720,   721,
     722,   723,   724,   436,   437,   725,   438,   439,   133,   440,
     441,   442,   135,   136,   137,   138,   139,   726,   443,   444,
     445,   446,   447,   727,   728,   448,   449,     0,   140,   451,
     730,   452,   453,   454,   455,   144,   731,   456,   732,   457,
     458,   459,   460,   147,   461,   733,   734,   463,   464,   465,
     466,   467,   468,   735,   150,   469,     0,   737,   738,   739,
     151,   740,   741,   742,   470,   471,   472,   473,     0,   475,
     154,   155,   476,   743,   477,   744,   478,   479,   480,   481,
     482,   745,   483,   484,   485,   746,   747,   486,   487,   488,
     489,   490,   748,   491,   492,   493,   749,   494,   495,   750,
     496,   497,   498,   499,   163,   500,   501,   502,   165,   751,
     503,   752,   504,   167,   505,   753,   506,   754,   507,   168,
     755,   169,   508,   509,   510,   756,   511,   171,   757,   512,
     758,   513,   514,     0,   516,   517,   172,   518,   519,   520,
     759,   521,   522,   523,   524,   525,   526,   760,   527,   173,
     174,     0,   528,   529,   530,     0,   175,   763,   176,   764,
     531,   177,   178,   532,   179,   533,   534,   535,   536,   537,
     538,   539,   765,   180,   181,   540,   182,   766,   541,   542,
     543,   767,   768,   544,   545,   546,   547,   548,     0,   550,
     551,     0,   553,   554,   555,   187,   188,   189,   556,   557,
     190,   769,   558,   559,   192,   560,   770,   193,   561,   194,
     562,   563,   564,   771,   565,   772,   773,   566,   567,   568,
     774,   775,   195,   196,   197,   198,   199,   569,   570,   571,
     572,   573,   574,   575,   776,   576,   200,   577,   201,   578,
     579,   580,   777,   581,   582,   583,   584,   585,   586,   587,
     203,   588,   589,   590,   591,   778,   592,   593,   594,   595,
     596,   597,   598,   599,   600,   601,   779,   602,   603,   209,
     604,   605,   211,   606,   607,   608,   609,   610,   611,     0,
     613,   780,   614,   615,   616,   617,   618,   781,   619,   216,
     620,   621,   218,   622,   219,   782,   623,   624,   625,   626,
     627,   628,   629,   630,   631,   632,   221,   783,   633,   634,
     784,   635,   636,   637,   638,   639,   640,   785,   223,   224,
       0,   787,   642,   225,   643,   226,   788,   644,   645,   646,
     647,   648,   649,     0,   790,   650,   651,   652,   653,   654,
     791,   792,   655,   656,   657,   658,   659,     0,   233,   794,
     661,   234,   662,   663,   664,   795,   796,   665,   797,   798,
     666,   667,   668,   669,   670,   236,   237,   238,   239,   240,
     241,   242,   243,   244,     0,   672,   673,    86,    87,    88,
     411,    90,    91,    92,   412,     0,   413,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   414,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   415,   416,     0,     0,
       0,   417,   418,     0,     0,     0,     0,   419,     0,     0,
       0,     0,     0,     0,     0,     0,   420,     0,   421,     0,
     422,   423,    35,     0,     0,     0,    37,    38,    39,    40,
      41,    42,     0,    44,     0,     0,     0,     0,     0,     0,
       0,     0,   425,   426,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,     0,     0,     0,     0,     0,     0,
       0,   436,   437,     0,   438,   439,     0,   440,   441,   442,
     135,   136,     0,   138,   139,     0,   443,   444,   445,   446,
     447,     0,     0,   448,   449,   450,   140,   451,     0,   452,
     453,   454,   455,   144,     0,   456,     0,   457,   458,   459,
     460,     0,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,     0,   469,     0,     0,     0,     0,     0,     0,
       0,     0,   470,   471,   472,   473,   474,   475,   154,   155,
     476,     0,   477,     0,   478,   479,   480,   481,   482,     0,
     483,   484,   485,     0,     0,   486,   487,   488,   489,   490,
       0,   491,   492,   493,     0,   494,   495,     0,   496,   497,
     498,   499,   163,   500,   501,   502,   165,  1984,   503,     0,
     504,   167,   505,     0,   506,     0,   507,     0,     0,     0,
     508,   509,   510,     0,   511,   171,     0,   512,     0,   513,
     514,   515,   516,   517,     0,   518,   519,   520,     0,   521,
     522,   523,   524,   525,   526,     0,   527,     0,   174,     0,
     528,   529,   530,     0,   175,     0,   176,     0,   531,     0,
       0,   532,     0,   533,   534,   535,   536,   537,   538,   539,
       0,   180,     0,   540,     0,     0,   541,   542,   543,     0,
       0,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,   187,     0,   189,   556,   557,   190,     0,
     558,   559,     0,   560,     0,   193,   561,   194,   562,   563,
     564,     0,   565,  1985,     0,   566,   567,   568,     0,     0,
     195,     0,     0,     0,   199,   569,   570,   571,   572,   573,
     574,   575,     0,   576,   200,   577,   201,   578,   579,   580,
       0,   581,   582,   583,   584,   585,   586,   587,   203,   588,
     589,   590,   591,     0,   592,   593,   594,   595,   596,   597,
     598,   599,   600,   601,     0,   602,   603,     0,   604,   605,
     211,   606,   607,   608,   609,   610,   611,   612,   613,     0,
     614,   615,   616,   617,   618,     0,   619,   216,   620,   621,
       0,   622,   219,     0,   623,   624,   625,   626,   627,   628,
     629,   630,   631,   632,   221,     0,   633,   634,     0,   635,
     636,   637,   638,   639,   640,     0,   223,   224,     0,     0,
     642,   225,   643,   226,  1986,   644,   645,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,     0,     0,
     655,   656,   657,   658,   659,   660,   233,     0,   661,     0,
     662,   663,   664,     0,     0,   665,     0,     0,   666,   667,
     668,   669,   670,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   671,   672,   673,    86,    87,    88,   411,    90,
      91,    92,   412,     0,   413,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   414,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   415,   416,     0,     0,     0,   417,
     418,     0,     0,     0,     0,   419,     0,     0,     0,     0,
       0,     0,     0,     0,   420,     0,   421,     0,   422,   423,
      35,   424,     0,     0,    37,    38,    39,    40,    41,    42,
       0,    44,     0,     0,     0,     0,     0,     0,     0,     0,
     425,   426,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,     0,     0,     0,     0,     0,     0,     0,   436,
     437,     0,   438,   439,     0,   440,   441,   442,   135,   136,
       0,   138,   139,     0,   443,   444,   445,   446,   447,     0,
       0,   448,   449,   450,   140,   451,     0,   452,   453,   454,
     455,   144,     0,   456,     0,   457,   458,   459,   460,     0,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
       0,   469,     0,     0,     0,     0,     0,     0,     0,     0,
     470,   471,   472,   473,   474,   475,   154,   155,   476,     0,
     477,     0,   478,   479,   480,   481,   482,     0,   483,   484,
     485,     0,     0,   486,   487,   488,   489,   490,     0,   491,
     492,   493,     0,   494,   495,     0,   496,   497,   498,   499,
     163,   500,   501,   502,   165,     0,   503,     0,   504,   167,
     505,     0,   506,     0,   507,     0,     0,     0,   508,   509,
     510,     0,   511,   171,     0,   512,     0,   513,   514,   515,
     516,   517,     0,   518,   519,   520,     0,   521,   522,   523,
     524,   525,   526,     0,   527,     0,   174,     0,   528,   529,
     530,     0,   175,     0,   176,     0,   531,     0,     0,   532,
       0,   533,   534,   535,   536,   537,   538,   539,     0,   180,
       0,   540,     0,     0,   541,   542,   543,     0,     0,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   187,     0,   189,   556,   557,   190,     0,   558,   559,
       0,   560,     0,   193,   561,   194,   562,   563,   564,     0,
     565,     0,     0,   566,   567,   568,     0,     0,   195,     0,
       0,     0,   199,   569,   570,   571,   572,   573,   574,   575,
       0,   576,   200,   577,   201,   578,   579,   580,     0,   581,
     582,   583,   584,   585,   586,   587,   203,   588,   589,   590,
     591,     0,   592,   593,   594,   595,   596,   597,   598,   599,
     600,   601,     0,   602,   603,     0,   604,   605,   211,   606,
     607,   608,   609,   610,   611,   612,   613,     0,   614,   615,
     616,   617,   618,     0,   619,   216,   620,   621,     0,   622,
     219,     0,   623,   624,   625,   626,   627,   628,   629,   630,
     631,   632,   221,     0,   633,   634,     0,   635,   636,   637,
     638,   639,   640,     0,   223,   224,   641,     0,   642,   225,
     643,   226,     0,   644,   645,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,     0,     0,   655,   656,
     657,   658,   659,   660,   233,     0,   661,     0,   662,   663,
     664,     0,     0,   665,     0,     0,   666,   667,   668,   669,
     670,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     671,   672,   673,    86,    87,    88,   411,    90,    91,    92,
     412,     0,   413,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   414,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   415,   416,     0,     0,     0,   417,   418,     0,
       0,     0,     0,   419,     0,     0,     0,     0,     0,     0,
       0,     0,   420,     0,   421,     0,   422,   423,    35,   424,
       0,     0,    37,    38,    39,    40,    41,    42,     0,    44,
       0,     0,     0,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
       0,     0,     0,     0,     0,     0,     0,   436,   437,     0,
     438,   439,     0,   440,   441,   442,   135,   136,     0,   138,
     139,     0,   443,   444,   445,   446,   447,     0,     0,   448,
     449,   450,   140,   451,     0,   452,   453,   454,   455,   144,
       0,   456,     0,   457,   458,   459,   460,     0,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   469,
       0,     0,     0,     0,     0,     0,     0,     0,   470,   471,
     472,   473,   474,   475,   154,   155,   476,  1124,   477,     0,
     478,   479,   480,   481,   482,     0,   483,   484,   485,     0,
       0,   486,   487,   488,   489,   490,     0,   491,   492,   493,
       0,   494,   495,     0,   496,   497,   498,   499,   163,   500,
     501,   502,   165,     0,   503,     0,   504,   167,   505,     0,
     506,     0,   507,     0,     0,     0,   508,   509,   510,     0,
     511,   171,     0,   512,     0,   513,   514,   515,   516,   517,
       0,   518,   519,   520,     0,   521,   522,   523,   524,   525,
     526,     0,   527,     0,   174,     0,   528,   529,   530,     0,
     175,     0,   176,     0,   531,     0,     0,   532,     0,   533,
     534,   535,   536,   537,   538,   539,     0,   180,     0,   540,
       0,     0,   541,   542,   543,     0,     0,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,   187,
       0,   189,   556,   557,   190,     0,   558,   559,     0,   560,
       0,   193,   561,   194,   562,   563,   564,     0,   565,     0,
       0,   566,   567,   568,     0,     0,   195,     0,     0,     0,
     199,   569,   570,   571,   572,   573,   574,   575,     0,   576,
     200,   577,   201,   578,   579,   580,     0,   581,   582,   583,
     584,   585,   586,   587,   203,   588,   589,   590,   591,     0,
     592,   593,   594,   595,   596,   597,   598,   599,   600,   601,
       0,   602,   603,     0,   604,   605,   211,   606,   607,   608,
     609,   610,   611,   612,   613,     0,   614,   615,   616,   617,
     618,     0,   619,   216,   620,   621,     0,   622,   219,     0,
     623,   624,   625,   626,   627,   628,   629,   630,   631,   632,
     221,     0,   633,   634,     0,   635,   636,   637,   638,   639,
     640,     0,   223,   224,     0,     0,   642,   225,   643,   226,
       0,   644,   645,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,     0,     0,   655,   656,   657,   658,
     659,   660,   233,     0,   661,     0,   662,   663,   664,     0,
       0,   665,     0,     0,   666,   667,   668,   669,   670,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   671,   672,
     673,    86,    87,    88,   411,    90,    91,    92,   412,     0,
     413,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   414,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     415,   416,     0,     0,     0,   417,   418,     0,     0,     0,
       0,   419,     0,     0,     0,     0,     0,     0,     0,     0,
     420,     0,   421,     0,   422,   423,    35,   424,     0,     0,
      37,    38,    39,    40,    41,    42,     0,    44,     0,     0,
       0,     0,     0,     0,     0,     0,   425,   426,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,     0,     0,
       0,     0,     0,     0,     0,   436,   437,     0,   438,   439,
       0,   440,   441,   442,   135,   136,     0,   138,   139,     0,
     443,   444,   445,   446,   447,     0,     0,   448,   449,   450,
     140,   451,     0,   452,   453,   454,   455,   144,     0,   456,
       0,   457,   458,   459,   460,     0,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   469,     0,     0,
       0,     0,     0,     0,     0,     0,   470,   471,   472,   473,
     474,   475,   154,   155,   476,     0,   477,     0,   478,   479,
     480,   481,   482,     0,   483,   484,   485,     0,     0,   486,
     487,   488,   489,   490,     0,   491,   492,   493,     0,   494,
     495,     0,   496,   497,   498,   499,   163,   500,   501,   502,
     165,     0,   503,     0,   504,   167,   505,     0,   506,     0,
     507,     0,     0,     0,   508,   509,   510,     0,   511,   171,
       0,   512,     0,   513,   514,   515,   516,   517,     0,   518,
     519,   520,     0,   521,   522,   523,   524,   525,   526,     0,
     527,     0,   174,     0,   528,   529,   530,     0,   175,     0,
     176,     0,   531,     0,     0,   532,     0,   533,   534,   535,
     536,   537,   538,   539,     0,   180,     0,   540,     0,     0,
     541,   542,   543,     0,     0,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,   555,   187,     0,   189,
     556,   557,   190,     0,   558,   559,     0,   560,     0,   193,
     561,   194,   562,   563,   564,     0,   565,     0,     0,   566,
     567,   568,     0,     0,   195,     0,     0,     0,   199,   569,
     570,   571,   572,   573,   574,   575,     0,   576,   200,   577,
     201,   578,   579,   580,     0,   581,   582,   583,   584,   585,
     586,   587,   203,   588,   589,   590,   591,     0,   592,   593,
     594,   595,   596,   597,   598,   599,   600,   601,     0,   602,
     603,     0,   604,   605,   211,   606,   607,   608,   609,   610,
     611,   612,   613,     0,   614,   615,   616,   617,   618,     0,
     619,   216,   620,   621,     0,   622,   219,     0,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   221,     0,
     633,   634,     0,   635,   636,   637,   638,   639,   640,     0,
     223,   224,     0,     0,   642,   225,   643,   226,     0,   644,
     645,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,   654,     0,     0,   655,   656,   657,   658,   659,   660,
     233,     0,   661,     0,   662,   663,   664,     0,     0,   665,
       0,     0,   666,   667,   668,   669,   670,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   671,   672,   673,    86,
      87,    88,   411,    90,    91,    92,   412,     0,   413,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   414,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   415,   416,
       0,     0,     0,   417,   418,     0,     0,     0,     0,   419,
       0,     0,     0,     0,     0,     0,     0,     0,   420,     0,
     421,     0,   422,   423,    35,     0,     0,     0,    37,    38,
      39,    40,    41,    42,     0,    44,     0,     0,     0,     0,
       0,     0,     0,     0,   425,   426,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,     0,     0,     0,     0,
       0,     0,     0,   436,   437,     0,   438,   439,     0,   440,
     441,   442,   135,   136,     0,   138,   139,     0,   443,   444,
     445,   446,   447,     0,     0,   448,   449,   450,   140,   451,
       0,   452,   453,   454,   455,   144,     0,   456,     0,   457,
     458,   459,   460,     0,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   469,     0,     0,     0,     0,
       0,     0,     0,     0,   470,   471,   472,   473,   474,   475,
     154,   155,   476,  2182,   477,     0,   478,   479,   480,   481,
     482,     0,   483,   484,   485,     0,     0,   486,   487,   488,
     489,   490,     0,   491,   492,   493,     0,   494,   495,     0,
     496,   497,   498,   499,   163,   500,   501,   502,   165,     0,
     503,     0,   504,   167,   505,     0,   506,     0,   507,     0,
       0,     0,   508,   509,   510,     0,   511,   171,     0,   512,
       0,   513,   514,   515,   516,   517,     0,   518,   519,   520,
       0,   521,   522,   523,   524,   525,   526,     0,   527,     0,
     174,     0,   528,   529,   530,     0,   175,     0,   176,     0,
     531,     0,     0,   532,     0,   533,   534,   535,   536,   537,
     538,   539,     0,   180,     0,   540,     0,     0,   541,   542,
     543,     0,     0,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,   555,   187,     0,   189,   556,   557,
     190,     0,   558,   559,     0,   560,     0,   193,   561,   194,
     562,   563,   564,     0,   565,     0,     0,   566,   567,   568,
       0,     0,   195,     0,     0,     0,   199,   569,   570,   571,
     572,   573,   574,   575,     0,   576,   200,   577,   201,   578,
     579,   580,     0,   581,   582,   583,   584,   585,   586,   587,
     203,   588,   589,   590,   591,     0,   592,   593,   594,   595,
     596,   597,   598,   599,   600,   601,     0,   602,   603,     0,
     604,   605,   211,   606,   607,   608,   609,   610,   611,   612,
     613,     0,   614,   615,   616,   617,   618,     0,   619,   216,
     620,   621,     0,   622,   219,     0,   623,   624,   625,   626,
     627,   628,   629,   630,   631,   632,   221,     0,   633,   634,
       0,   635,   636,   637,   638,   639,   640,     0,   223,   224,
       0,     0,   642,   225,   643,   226,     0,   644,   645,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
       0,     0,   655,   656,   657,   658,   659,   660,   233,     0,
     661,     0,   662,   663,   664,     0,     0,   665,     0,     0,
     666,   667,   668,   669,   670,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   671,   672,   673,    86,    87,    88,
     411,    90,    91,    92,   412,     0,   413,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   414,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   415,   416,     0,     0,
       0,   417,   418,     0,     0,     0,     0,   419,     0,     0,
       0,     0,     0,     0,     0,     0,   420,     0,   421,     0,
     422,   423,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   425,   426,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,     0,     0,     0,     0,     0,     0,
       0,   436,   437,     0,   438,   439,     0,   440,   441,   442,
     135,   136,     0,   138,   139,     0,   443,   444,   445,   446,
     447,     0,     0,   448,   449,   450,   140,   451,  2331,   452,
     453,   454,   455,   144,     0,   456,  2396,   457,   458,   459,
     460,     0,   461,   462,  2332,   463,   464,   465,   466,   467,
     468,     0,     0,   469,     0,     0,     0,     0,     0,     0,
       0,     0,   470,   471,   472,   473,   474,   475,   154,   155,
     476,     0,   477,     0,   478,   479,   480,   481,   482,     0,
     483,   484,   485,     0,     0,   486,   487,   488,   489,   490,
       0,   491,   492,   493,     0,   494,   495,     0,  2397,   497,
     498,   499,   163,   500,   501,   502,   165,     0,   503,     0,
     504,   167,   505,     0,   506,  2334,   507,     0,     0,     0,
     508,   509,   510,     0,   511,   171,     0,   512,     0,   513,
     514,   515,   516,   517,     0,   518,   519,   520,     0,   521,
     522,   523,   524,   525,   526,     0,   527,     0,   174,     0,
     528,   529,   530,     0,   175,     0,   176,     0,   531,     0,
       0,   532,     0,   533,   534,   535,   536,   537,   538,   539,
       0,   180,     0,   540,     0,     0,   541,   542,   543,     0,
       0,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,   187,     0,   189,   556,   557,   190,     0,
     558,   559,     0,   560,     0,   193,   561,   194,   562,   563,
     564,     0,   565,     0,     0,   566,   567,   568,     0,     0,
     195,     0,     0,     0,   199,   569,   570,   571,   572,   573,
     574,   575,     0,   576,   200,   577,   201,   578,   579,   580,
    2335,   581,   582,   583,   584,   585,   586,   587,   203,   588,
     589,   590,   591,     0,   592,   593,   594,   595,   596,   597,
     598,   599,   600,   601,     0,   602,   603,     0,   604,   605,
     211,   606,   607,   608,   609,   610,   611,   612,   613,     0,
     614,   615,   616,   617,   618,     0,   619,   216,   620,   621,
       0,   622,   219,     0,   623,   624,   625,   626,   627,   628,
     629,   630,   631,   632,   221,     0,   633,   634,     0,   635,
     636,   637,   638,   639,   640,     0,   223,   224,     0,     0,
     642,   225,   643,   226,     0,   644,   645,   646,   647,   648,
     649,     0,  2336,   650,   651,   652,   653,   654,     0,     0,
     655,   656,   657,   658,   659,   660,   233,     0,   661,     0,
     662,   663,   664,     0,     0,   665,     0,     0,   666,   667,
     668,   669,   670,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   671,   672,   673,    86,    87,    88,   411,    90,
      91,    92,   412,     0,   413,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   414,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   415,   416,     0,     0,     0,   417,
     418,     0,     0,     0,     0,   419,     0,     0,     0,     0,
       0,     0,     0,     0,   420,     0,   421,     0,   422,   423,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     425,   426,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,     0,     0,     0,     0,     0,     0,     0,   436,
     437,     0,   438,   439,     0,   440,   441,   442,   135,   136,
       0,   138,   139,     0,   443,   444,   445,   446,   447,     0,
       0,   448,   449,   450,   140,   451,  2331,   452,   453,   454,
     455,   144,     0,   456,     0,   457,   458,   459,   460,     0,
     461,   462,  2332,   463,   464,   465,   466,   467,   468,     0,
       0,   469,     0,     0,     0,     0,     0,     0,     0,     0,
     470,   471,   472,   473,   474,   475,   154,   155,   476,     0,
     477,     0,   478,   479,   480,   481,   482,     0,   483,   484,
     485,     0,     0,   486,   487,   488,   489,   490,     0,   491,
     492,   493,     0,   494,   495,     0,  2397,   497,   498,   499,
     163,   500,   501,   502,   165,     0,   503,     0,   504,   167,
     505,     0,   506,  2334,   507,     0,     0,     0,   508,   509,
     510,     0,   511,   171,     0,   512,     0,   513,   514,   515,
     516,   517,     0,   518,   519,   520,     0,   521,   522,   523,
     524,   525,   526,     0,   527,     0,   174,     0,   528,   529,
     530,     0,   175,     0,   176,     0,   531,     0,     0,   532,
       0,   533,   534,   535,   536,   537,   538,   539,     0,   180,
       0,   540,  3235,     0,   541,   542,   543,     0,     0,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   187,     0,   189,   556,   557,   190,     0,   558,   559,
       0,   560,     0,   193,   561,   194,   562,   563,   564,     0,
     565,     0,     0,   566,   567,   568,     0,     0,   195,     0,
       0,     0,   199,   569,   570,   571,   572,   573,   574,   575,
       0,   576,   200,   577,   201,   578,   579,   580,  2335,   581,
     582,   583,   584,   585,   586,   587,   203,   588,   589,   590,
     591,     0,   592,   593,   594,   595,   596,   597,   598,   599,
     600,   601,     0,   602,   603,     0,   604,   605,   211,   606,
     607,   608,   609,   610,   611,   612,   613,     0,   614,   615,
     616,   617,   618,     0,   619,   216,   620,   621,     0,   622,
     219,     0,   623,   624,   625,   626,   627,   628,   629,   630,
     631,   632,   221,     0,   633,   634,     0,   635,   636,   637,
     638,   639,   640,     0,   223,   224,     0,     0,   642,   225,
     643,   226,     0,   644,   645,   646,   647,   648,   649,     0,
    2336,   650,   651,   652,   653,   654,     0,     0,   655,   656,
     657,   658,   659,   660,   233,     0,   661,     0,   662,   663,
     664,     0,     0,   665,     0,     0,   666,   667,   668,   669,
     670,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     671,   672,   673,    86,    87,    88,   411,    90,    91,    92,
     412,     0,   413,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   414,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   415,   416,     0,     0,     0,   417,   418,     0,
       0,     0,     0,   419,     0,     0,     0,     0,     0,     0,
       0,     0,   420,     0,   421,     0,   422,   423,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,  1023,   431,   432,   982,   433,   434,   435,
       0,     0,     0,     0,     0,     0,     0,   436,   437,     0,
     438,   439,     0,   440,   441,   442,   135,   136,     0,   138,
     139,     0,   443,   444,   445,   446,   447,     0,     0,   448,
     449,   450,   140,   451,     0,   452,   453,   454,   455,   144,
       0,   456,     0,   457,   458,   459,   460,     0,   461,   462,
       0,   463,   464,   465,   466,   467,   468,   983,     0,   469,
       0,     0,     0,     0,     0,     0,     0,     0,   470,   471,
     472,   473,   474,   475,   154,   155,   476,     0,   477,     0,
     478,   479,   480,   481,   482,     0,   483,   484,   485,     0,
       0,   486,   487,   488,   489,   490,     0,   491,   492,   493,
       0,   494,   495,     0,   496,   497,   498,   499,   163,   500,
     501,   502,   165,     0,   503,     0,   504,   167,   505,     0,
     506,     0,   507,     0,     0,     0,   508,   509,   510,  1024,
     511,   171,     0,   512,     0,   513,   514,   515,   516,   517,
       0,   518,   519,   520,     0,   521,   522,   523,   524,   525,
     526,     0,   527,     0,   174,     0,   528,   529,   530,     0,
     175,     0,   176,     0,   531,     0,     0,   532,     0,   533,
     534,   535,   536,   537,   538,   539,     0,   180,     0,   540,
       0,     0,   541,   542,   543,     0,     0,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,   187,
       0,   189,   556,   557,   190,     0,   558,   559,     0,   560,
       0,   193,   561,   194,   562,   563,   564,     0,   565,     0,
       0,   566,   567,   568,     0,     0,   195,     0,     0,     0,
     199,   569,   570,   571,   572,   573,   574,   575,     0,   576,
     200,   577,   201,   578,   579,   580,     0,   581,   582,   583,
     584,   585,   586,   587,   203,   588,   589,   590,   591,   984,
     592,   593,   594,   595,   596,   597,   598,   599,   600,   601,
       0,   602,   603,     0,   604,   605,   211,   606,   607,   608,
     609,   610,   611,   612,   613,   985,   614,   615,   616,   617,
     618,     0,   619,   216,   620,   621,     0,   622,   219,     0,
     623,   624,   625,   626,   627,   628,   629,   630,   631,   632,
     221,     0,   633,   634,     0,   635,   636,   637,   638,   639,
     640,     0,   223,   224,     0,     0,   642,   225,   643,   226,
       0,   644,   645,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,     0,     0,   655,   656,   657,   658,
     659,   660,   233,     0,   661,     0,   662,   663,   664,     0,
       0,   665,     0,     0,   666,   667,   668,   669,   670,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   671,   672,
     673,    86,    87,    88,   411,    90,    91,    92,   412,     0,
     413,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   414,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     415,   416,     0,     0,     0,   417,   418,     0,     0,     0,
       0,   419,     0,     0,     0,     0,     0,     0,     0,     0,
     420,     0,   421,     0,   422,   423,    35,     0,     0,     0,
      37,    38,    39,    40,    41,    42,     0,    44,     0,     0,
       0,     0,     0,     0,     0,     0,   425,   426,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,     0,     0,
       0,     0,     0,     0,     0,   436,   437,     0,   438,   439,
       0,   440,   441,   442,   135,   136,     0,   138,   139,     0,
     443,   444,   445,   446,   447,     0,     0,   448,   449,   450,
     140,   451,     0,   452,   453,   454,   455,   144,     0,   456,
       0,   457,   458,   459,   460,     0,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   469,     0,     0,
       0,     0,     0,     0,     0,     0,   470,   471,   472,   473,
     474,   475,   154,   155,   476,     0,   477,     0,   478,   479,
     480,   481,   482,     0,   483,   484,   485,     0,     0,   486,
     487,   488,   489,   490,     0,   491,   492,   493,     0,   494,
     495,     0,   496,   497,   498,   499,   163,   500,   501,   502,
     165,     0,   503,     0,   504,   167,   505,     0,   506,     0,
     507,     0,     0,     0,   508,   509,   510,     0,   511,   171,
       0,   512,     0,   513,   514,   515,   516,   517,     0,   518,
     519,   520,     0,   521,   522,   523,   524,   525,   526,     0,
     527,     0,   174,     0,   528,   529,   530,     0,   175,     0,
     176,     0,   531,     0,     0,   532,     0,   533,   534,   535,
     536,   537,   538,   539,     0,   180,     0,   540,     0,     0,
     541,   542,   543,     0,     0,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,   555,   187,     0,   189,
     556,   557,   190,     0,   558,   559,     0,   560,     0,   193,
     561,   194,   562,   563,   564,     0,   565,     0,     0,   566,
     567,   568,     0,     0,   195,     0,     0,     0,   199,   569,
     570,   571,   572,   573,   574,   575,     0,   576,   200,   577,
     201,   578,   579,   580,     0,   581,   582,   583,   584,   585,
     586,   587,   203,   588,   589,   590,   591,     0,   592,   593,
     594,   595,   596,   597,   598,   599,   600,   601,     0,   602,
     603,     0,   604,   605,   211,   606,   607,   608,   609,   610,
     611,   612,   613,     0,   614,   615,   616,   617,   618,     0,
     619,   216,   620,   621,     0,   622,   219,     0,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   221,     0,
     633,   634,     0,   635,   636,   637,   638,   639,   640,     0,
     223,   224,     0,     0,   642,   225,   643,   226,     0,   644,
     645,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,   654,     0,     0,   655,   656,   657,   658,   659,   660,
     233,     0,   661,     0,   662,   663,   664,     0,     0,   665,
       0,     0,   666,   667,   668,   669,   670,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   671,   672,   673,    86,
      87,    88,   411,    90,    91,    92,   412,     0,   413,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   414,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   415,   416,
       0,     0,     0,   417,   418,     0,     0,     0,     0,   419,
       0,     0,     0,     0,     0,     0,     0,     0,   420,     0,
     421,     0,   422,   423,    35,     0,     0,     0,    37,    38,
      39,    40,    41,    42,     0,    44,     0,     0,     0,     0,
       0,     0,     0,     0,   425,   426,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,     0,     0,     0,     0,
       0,     0,     0,   436,   437,     0,   438,   439,     0,   440,
     441,   442,   135,   136,     0,   138,   139,     0,   443,   444,
     445,   446,   447,     0,     0,   448,   449,   450,   140,   451,
       0,   452,   453,   454,   455,   144,     0,   456,     0,   457,
     458,   459,   460,     0,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   469,     0,     0,     0,     0,
       0,     0,     0,     0,   470,   471,   472,   473,   474,   475,
     154,   155,   476,     0,   477,     0,   478,   479,   480,   481,
     482,     0,   483,   484,   485,     0,     0,   486,   487,   488,
     489,   490,     0,   491,   492,   493,     0,   494,   495,     0,
     496,   497,   498,   499,   163,   500,   501,   502,   165,     0,
     503,     0,   504,   167,   505,     0,   506,     0,   507,     0,
       0,     0,   508,   509,   510,     0,   511,   171,     0,   512,
       0,   513,   514,   515,   516,  1964,     0,   518,   519,   520,
       0,   521,   522,   523,   524,   525,   526,     0,   527,     0,
     174,     0,   528,   529,   530,     0,   175,     0,   176,     0,
     531,     0,     0,   532,     0,   533,   534,   535,   536,   537,
     538,   539,     0,   180,     0,   540,     0,     0,   541,   542,
     543,     0,     0,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,   555,   187,     0,   189,   556,   557,
     190,     0,   558,   559,     0,   560,     0,   193,   561,   194,
     562,   563,   564,     0,   565,     0,     0,   566,   567,   568,
       0,     0,   195,     0,     0,     0,   199,   569,   570,   571,
     572,   573,   574,   575,     0,   576,   200,   577,   201,   578,
     579,   580,     0,   581,   582,   583,   584,   585,   586,   587,
     203,   588,   589,   590,   591,     0,   592,   593,   594,   595,
     596,   597,   598,   599,   600,   601,     0,   602,   603,     0,
     604,   605,   211,   606,   607,   608,   609,   610,   611,   612,
     613,     0,   614,   615,   616,   617,   618,     0,   619,   216,
     620,   621,     0,   622,   219,     0,   623,   624,   625,   626,
     627,   628,   629,   630,   631,   632,   221,     0,   633,   634,
       0,   635,   636,   637,   638,   639,   640,     0,   223,   224,
       0,     0,   642,   225,   643,   226,     0,   644,   645,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
       0,     0,   655,   656,   657,   658,   659,   660,   233,     0,
     661,     0,   662,   663,   664,     0,     0,   665,     0,     0,
     666,   667,   668,   669,   670,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   671,   672,   673,    86,    87,    88,
     411,    90,    91,    92,   412,     0,   413,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   414,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   415,   416,     0,     0,
       0,   417,   418,     0,     0,     0,     0,   419,     0,     0,
       0,     0,     0,     0,     0,     0,   420,     0,   421,     0,
     422,   423,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   425,   426,   427,   428,   429,   430,   431,   432,
     982,   433,   434,   435,     0,     0,     0,     0,     0,     0,
       0,   436,   437,     0,   438,   439,     0,   440,   441,   442,
     135,   136,     0,   138,   139,     0,   443,   444,   445,   446,
     447,     0,     0,   448,   449,   450,   140,   451,     0,   452,
     453,   454,   455,   144,     0,   456,     0,   457,   458,   459,
     460,     0,   461,   462,     0,   463,   464,   465,   466,   467,
     468,   983,     0,   469,     0,     0,     0,     0,     0,     0,
       0,     0,   470,   471,   472,   473,   474,   475,   154,   155,
     476,     0,   477,     0,   478,   479,   480,   481,   482,     0,
     483,   484,   485,     0,     0,   486,   487,   488,   489,   490,
       0,   491,   492,   493,     0,   494,   495,     0,   496,   497,
     498,   499,   163,   500,   501,   502,   165,     0,   503,     0,
     504,   167,   505,     0,   506,     0,   507,     0,     0,     0,
     508,   509,   510,  2961,   511,   171,     0,   512,     0,   513,
     514,   515,   516,   517,     0,   518,   519,   520,     0,   521,
     522,   523,   524,   525,   526,     0,   527,     0,   174,     0,
     528,   529,   530,     0,   175,     0,   176,     0,   531,     0,
       0,   532,     0,   533,   534,   535,   536,   537,   538,   539,
       0,   180,     0,   540,     0,     0,   541,   542,   543,     0,
       0,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,   187,     0,   189,   556,   557,   190,     0,
     558,   559,     0,   560,     0,   193,   561,   194,   562,   563,
     564,     0,   565,     0,     0,   566,   567,   568,     0,     0,
     195,     0,     0,     0,   199,   569,   570,   571,   572,   573,
     574,   575,     0,   576,   200,   577,   201,   578,   579,   580,
       0,   581,   582,   583,   584,   585,   586,   587,   203,   588,
     589,   590,   591,   984,   592,   593,   594,   595,   596,   597,
     598,   599,   600,   601,     0,   602,   603,     0,   604,   605,
     211,   606,   607,   608,   609,   610,   611,   612,   613,   985,
     614,   615,   616,   617,   618,     0,   619,   216,   620,   621,
       0,   622,   219,     0,   623,   624,   625,   626,   627,   628,
     629,   630,   631,   632,   221,     0,   633,   634,     0,   635,
     636,   637,   638,   639,   640,     0,   223,   224,     0,     0,
     642,   225,   643,   226,     0,   644,   645,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,     0,     0,
     655,   656,   657,   658,   659,   660,   233,     0,   661,     0,
     662,   663,   664,     0,     0,   665,     0,     0,   666,   667,
     668,   669,   670,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   671,   672,   673,    86,    87,    88,   411,    90,
      91,    92,   412,     0,   413,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   414,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   415,   416,     0,     0,     0,   417,
     418,     0,     0,     0,     0,   419,     0,     0,     0,     0,
       0,     0,     0,     0,   420,     0,   421,     0,   422,   423,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     425,   426,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,     0,     0,     0,     0,     0,     0,     0,   436,
     437,     0,   438,   439,     0,   440,   441,   442,   135,   136,
       0,   138,   139,     0,   443,   444,   445,   446,   447,     0,
       0,   448,   449,   450,   140,   451,  2331,   452,   453,   454,
     455,   144,     0,   456,     0,   457,   458,   459,   460,     0,
     461,   462,  2332,   463,   464,   465,   466,   467,   468,     0,
       0,   469,     0,     0,     0,     0,     0,     0,     0,     0,
     470,   471,   472,   473,   474,   475,   154,   155,   476,     0,
     477,     0,   478,   479,   480,   481,   482,     0,   483,   484,
     485,     0,     0,   486,   487,   488,   489,   490,     0,   491,
     492,   493,     0,   494,   495,     0,  2397,   497,   498,   499,
     163,   500,   501,   502,   165,     0,   503,     0,   504,   167,
     505,     0,   506,  2334,   507,     0,     0,     0,   508,   509,
     510,     0,   511,   171,     0,   512,     0,   513,   514,   515,
     516,   517,     0,   518,   519,   520,     0,   521,   522,   523,
     524,   525,   526,     0,   527,     0,   174,     0,   528,   529,
     530,     0,   175,     0,   176,     0,   531,     0,     0,   532,
       0,   533,   534,   535,   536,   537,   538,   539,     0,   180,
       0,   540,     0,     0,   541,   542,   543,     0,     0,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   187,     0,   189,   556,   557,   190,     0,   558,   559,
       0,   560,     0,   193,   561,   194,   562,   563,   564,     0,
     565,     0,     0,   566,   567,   568,     0,     0,   195,     0,
       0,     0,   199,   569,   570,   571,   572,   573,   574,   575,
       0,   576,   200,   577,   201,   578,   579,   580,  2335,   581,
     582,   583,   584,   585,   586,   587,   203,   588,   589,   590,
     591,     0,   592,   593,   594,   595,   596,   597,   598,   599,
     600,   601,     0,   602,   603,     0,   604,   605,   211,   606,
     607,   608,   609,   610,   611,   612,   613,     0,   614,   615,
     616,   617,   618,     0,   619,   216,   620,   621,     0,   622,
     219,     0,   623,   624,   625,   626,   627,   628,   629,   630,
     631,   632,   221,     0,   633,   634,     0,   635,   636,   637,
     638,   639,   640,     0,   223,   224,     0,     0,   642,   225,
     643,   226,     0,   644,   645,   646,   647,   648,   649,     0,
    2336,   650,   651,   652,   653,   654,     0,     0,   655,   656,
     657,   658,   659,   660,   233,     0,   661,     0,   662,   663,
     664,     0,     0,   665,     0,     0,   666,   667,   668,   669,
     670,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     671,   672,   673,    86,    87,    88,   411,    90,    91,    92,
     412,     0,   413,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   414,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   415,   416,     0,     0,     0,   417,   418,     0,
       0,     0,     0,   419,     0,     0,     0,     0,     0,     0,
       0,     0,   420,     0,   421,     0,   422,   423,    35,   424,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,   430,   431,   432,   693,   433,   434,   435,
       0,     0,     0,     0,     0,     0,     0,   436,   437,     0,
     438,   439,     0,   440,   441,   442,   135,   136,     0,   138,
     139,     0,   443,   444,   445,   446,   447,     0,     0,   448,
     449,   450,   140,   451,     0,   452,   453,   454,   455,   144,
       0,   456,     0,   457,   458,   459,   460,     0,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   469,
     694,     0,     0,     0,     0,     0,     0,     0,   470,   471,
     472,   473,   474,   475,   154,   155,   476,   695,   477,     0,
     478,   479,   480,   481,   482,     0,   483,   484,   485,     0,
       0,   486,   487,   488,   489,   490,     0,   491,   492,   493,
       0,   494,   495,     0,   496,   497,   498,   499,   163,   500,
     501,   502,   165,     0,   503,     0,   504,   167,   505,     0,
     506,     0,   507,     0,     0,     0,   508,   509,   510,     0,
     511,   171,     0,   512,     0,   513,   514,   515,   516,   517,
       0,   518,   519,   520,     0,   521,   522,   523,   524,   525,
     526,     0,   527,     0,   174,     0,   528,   529,   530,     0,
     175,     0,   176,     0,   531,     0,     0,   532,     0,   533,
     534,   535,   536,   537,   538,   539,     0,   180,     0,   540,
       0,     0,   541,   542,   543,     0,     0,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,   187,
       0,   189,   556,   557,   190,     0,   558,   559,     0,   560,
       0,   193,   561,   194,   562,   563,   564,     0,   565,     0,
       0,   566,   567,   568,     0,     0,   195,     0,     0,     0,
     199,   569,   570,   571,   572,   573,   574,   575,     0,   576,
     200,   577,   201,   578,   579,   580,     0,   581,   582,   583,
     584,   585,   586,   587,   203,   588,   589,   590,   591,     0,
     592,   593,   594,   595,   596,   597,   598,   599,   600,   601,
       0,   602,   603,     0,   604,   605,   211,   606,   607,   608,
     609,   610,   611,   612,   613,     0,   614,   615,   616,   617,
     618,     0,   619,   216,   620,   621,     0,   622,   219,     0,
     623,   624,   625,   626,   627,   628,   629,   630,   631,   632,
     221,     0,   633,   634,     0,   635,   636,   637,   638,   639,
     640,     0,   223,   224,     0,     0,   642,   225,   643,   226,
       0,   644,   645,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,     0,     0,   655,   656,   657,   658,
     659,   660,   233,     0,   661,     0,   662,   663,   664,     0,
       0,   665,     0,     0,   666,   667,   668,   669,   670,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   671,   672,
     673,    86,    87,    88,   411,    90,    91,    92,   412,     0,
     413,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   414,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     415,   416,     0,     0,     0,   417,   418,     0,     0,     0,
       0,   419,     0,     0,     0,     0,     0,     0,     0,     0,
     420,     0,   421,     0,   422,   423,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   425,   426,   427,   428,
     429,   430,   431,   432,   982,   433,   434,   435,     0,     0,
       0,     0,     0,     0,     0,   436,   437,     0,   438,   439,
       0,   440,   441,   442,   135,   136,     0,   138,   139,     0,
     443,   444,   445,   446,   447,     0,     0,   448,   449,   450,
     140,   451,     0,   452,   453,   454,   455,   144,     0,   456,
       0,   457,   458,   459,   460,     0,   461,   462,     0,   463,
     464,   465,   466,   467,   468,   983,     0,   469,     0,     0,
       0,     0,     0,     0,     0,     0,   470,   471,   472,   473,
     474,   475,   154,   155,   476,     0,   477,     0,   478,   479,
     480,   481,   482,     0,   483,   484,   485,     0,     0,   486,
     487,   488,   489,   490,     0,   491,   492,   493,     0,   494,
     495,     0,   496,   497,   498,   499,   163,   500,   501,   502,
     165,     0,   503,     0,   504,   167,   505,     0,   506,     0,
     507,     0,     0,     0,   508,   509,   510,     0,   511,   171,
       0,   512,     0,   513,   514,   515,   516,   517,     0,   518,
     519,   520,     0,   521,   522,   523,   524,   525,   526,     0,
     527,     0,   174,     0,   528,   529,   530,     0,   175,     0,
     176,     0,   531,     0,     0,   532,     0,   533,   534,   535,
     536,   537,   538,   539,     0,   180,     0,   540,     0,     0,
     541,   542,   543,     0,     0,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,   555,   187,     0,   189,
     556,   557,   190,     0,   558,   559,     0,   560,     0,   193,
     561,   194,   562,   563,   564,     0,   565,     0,     0,   566,
     567,   568,     0,     0,   195,     0,     0,     0,   199,   569,
     570,   571,   572,   573,   574,   575,     0,   576,   200,   577,
     201,   578,   579,   580,     0,   581,   582,   583,   584,   585,
     586,   587,   203,   588,   589,   590,   591,   984,   592,   593,
     594,   595,   596,   597,   598,   599,   600,   601,     0,   602,
     603,     0,   604,   605,   211,   606,   607,   608,   609,   610,
     611,   612,   613,   985,   614,   615,   616,   617,   618,     0,
     619,   216,   620,   621,     0,   622,   219,     0,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   221,     0,
     633,   634,     0,   635,   636,   637,   638,   639,   640,     0,
     223,   224,     0,     0,   642,   225,   643,   226,     0,   644,
     645,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,   654,     0,     0,   655,   656,   657,   658,   659,   660,
     233,     0,   661,     0,   662,   663,   664,     0,     0,   665,
       0,     0,   666,   667,   668,   669,   670,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   671,   672,   673,    86,
      87,    88,   411,    90,    91,    92,   412,   898,   413,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   414,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   415,   416,
       0,     0,     0,   417,   418,     0,     0,     0,     0,   419,
       0,     0,     0,     0,     0,     0,     0,     0,   420,     0,
     421,     0,   422,   423,    35,   424,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   425,   426,   427,   428,   429,   430,
     431,   432,   899,   433,   434,   435,     0,     0,     0,     0,
       0,     0,     0,   436,   437,     0,   438,   439,     0,   440,
     441,   442,   135,   136,     0,   138,   139,     0,   443,   444,
     445,   446,   447,     0,     0,   448,   449,   450,   140,   451,
       0,   452,   453,   454,   455,   144,     0,   456,     0,   457,
     458,   459,   460,     0,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   469,     0,     0,     0,     0,
       0,     0,     0,     0,   470,   471,   472,   473,   474,   475,
     154,   155,   476,     0,   477,     0,   478,   479,   480,   481,
     482,     0,   483,   484,   485,     0,     0,   486,   487,   488,
     489,   490,     0,   491,   492,   493,     0,   494,   495,     0,
     496,   497,   498,   499,   163,   500,   501,   502,   165,     0,
     503,     0,   504,   167,   505,     0,   506,     0,   507,     0,
       0,     0,   508,   509,   510,     0,   511,   171,     0,   512,
       0,   513,   514,   515,   516,   517,     0,   518,   519,   520,
       0,   521,   522,   523,   524,   525,   526,     0,   527,     0,
     174,     0,   528,   529,   530,     0,   175,     0,   176,     0,
     531,     0,     0,   532,     0,   533,   534,   535,   536,   537,
     538,   539,     0,   180,     0,   540,     0,     0,   541,   542,
     543,     0,     0,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,   555,   187,     0,   189,   556,   557,
     190,     0,   558,   559,     0,   560,     0,   193,   561,   194,
     562,   563,   564,     0,   565,     0,     0,   566,   567,   568,
       0,     0,   195,     0,     0,     0,   199,   569,   570,   571,
     572,   573,   574,   575,     0,   576,   200,   577,   201,   578,
     900,   580,     0,   581,   582,   583,   584,   585,   586,   587,
     203,   588,   589,   590,   591,     0,   592,   593,   594,   595,
     596,   597,   598,   599,   600,   601,     0,   602,   603,     0,
     604,   605,   211,   606,   607,   608,   609,   610,   611,   612,
     613,     0,   614,   615,   616,   617,   618,     0,   619,   216,
     620,   621,     0,   622,   219,     0,   623,   624,   625,   626,
     627,   628,   629,   630,   631,   632,   221,     0,   633,   634,
       0,   635,   636,   637,   638,   639,   640,     0,   223,   224,
       0,     0,   642,   225,   643,   226,     0,   644,   645,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
       0,     0,   655,   656,   657,   658,   659,   660,   233,     0,
     661,     0,   662,   663,   664,     0,     0,   665,     0,     0,
     666,   667,   668,   669,   670,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   671,   672,   673,    86,    87,    88,
     411,    90,    91,    92,   412,     0,   413,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   414,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   415,   416,     0,     0,
       0,   417,   418,     0,     0,     0,     0,   419,     0,     0,
       0,     0,     0,     0,     0,     0,   420,     0,   421,     0,
     422,   423,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   425,   426,   427,   428,   429,   430,   431,   432,
    2019,   433,   434,   435,     0,     0,     0,     0,     0,     0,
       0,   436,   437,     0,   438,   439,     0,   440,   441,   442,
     135,   136,     0,   138,   139,     0,   443,   444,   445,   446,
     447,     0,     0,   448,   449,   450,   140,   451,     0,   452,
     453,   454,   455,   144,     0,   456,     0,   457,   458,   459,
     460,     0,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,     0,   469,     0,     0,     0,     0,     0,     0,
       0,     0,   470,   471,   472,  2020,   474,   475,   154,   155,
     476,     0,   477,     0,   478,   479,   480,   481,   482,     0,
     483,   484,   485,     0,     0,   486,   487,   488,   489,   490,
       0,   491,   492,   493,     0,   494,   495,     0,   496,   497,
     498,   499,   163,   500,   501,   502,   165,     0,   503,     0,
     504,   167,   505,     0,   506,  2021,   507,     0,     0,     0,
    2022,   509,   510,     0,   511,   171,     0,   512,     0,   513,
     514,   515,   516,   517,     0,   518,   519,   520,     0,   521,
     522,   523,   524,   525,   526,     0,   527,     0,   174,     0,
     528,   529,   530,     0,   175,     0,   176,     0,   531,     0,
       0,   532,     0,   533,   534,  2023,  2024,   537,   538,   539,
       0,   180,     0,   540,     0,     0,   541,   542,   543,     0,
       0,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,   187,     0,   189,   556,   557,   190,     0,
     558,   559,     0,   560,     0,   193,   561,   194,   562,   563,
     564,     0,   565,     0,     0,   566,   567,   568,     0,     0,
     195,     0,     0,     0,   199,   569,   570,   571,   572,   573,
     574,   575,     0,   576,   200,   577,   201,   578,   579,   580,
       0,   581,   582,   583,   584,   585,   586,   587,   203,   588,
     589,   590,   591,     0,   592,   593,   594,   595,   596,   597,
     598,   599,   600,   601,     0,   602,   603,     0,   604,   605,
     211,   606,   607,   608,  2025,   610,   611,   612,   613,     0,
    2026,   615,   616,   617,   618,     0,   619,   216,   620,   621,
       0,   622,   219,     0,   623,   624,   625,   626,   627,   628,
     629,   630,   631,   632,   221,     0,   633,   634,  2027,   635,
    2028,   637,   638,   639,   640,     0,   223,   224,     0,     0,
     642,   225,   643,   226,     0,   644,   645,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,     0,     0,
     655,   656,   657,   658,   659,   660,   233,     0,   661,     0,
     662,   663,   664,     0,     0,   665,     0,     0,   666,   667,
     668,   669,   670,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   671,   672,   673,    86,    87,    88,   411,    90,
      91,    92,   412,     0,   413,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   414,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   415,   416,     0,     0,     0,   417,
     418,     0,     0,     0,     0,   419,     0,     0,     0,     0,
       0,     0,     0,     0,   420,     0,   421,     0,   422,   423,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     425,   426,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,     0,     0,     0,     0,     0,     0,     0,   436,
     437,     0,   438,   439,     0,   440,   441,   442,   135,   136,
       0,   138,   139,     0,   443,   444,   445,   446,   447,     0,
       0,   448,   449,   450,   140,   451,     0,   452,   453,   454,
     455,   144,     0,   456,     0,   457,   458,   459,   460,     0,
     461,   462,     0,   463,   464,   465,   466,   467,   468,   983,
       0,   469,     0,     0,     0,     0,     0,     0,     0,     0,
     470,   471,   472,   473,   474,   475,   154,   155,   476,     0,
     477,     0,   478,   479,   480,   481,   482,     0,   483,   484,
     485,     0,     0,   486,   487,   488,   489,   490,     0,   491,
     492,   493,     0,   494,   495,     0,   496,   497,   498,   499,
     163,   500,   501,   502,   165,     0,   503,     0,   504,   167,
     505,     0,   506,     0,   507,     0,     0,     0,   508,   509,
     510,     0,   511,   171,     0,   512,     0,   513,   514,   515,
     516,   517,     0,   518,   519,   520,     0,   521,   522,   523,
     524,   525,   526,     0,   527,     0,   174,     0,   528,   529,
     530,     0,   175,     0,   176,     0,   531,     0,     0,   532,
       0,   533,   534,   535,   536,   537,   538,   539,     0,   180,
       0,   540,     0,     0,   541,   542,   543,     0,     0,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   187,     0,   189,   556,   557,   190,     0,   558,   559,
       0,   560,     0,   193,   561,   194,   562,   563,   564,     0,
     565,     0,     0,   566,   567,   568,     0,     0,   195,     0,
       0,     0,   199,   569,   570,   571,   572,   573,   574,   575,
       0,   576,   200,   577,   201,   578,   579,   580,     0,   581,
     582,   583,   584,   585,   586,   587,   203,   588,   589,   590,
     591,   984,   592,   593,   594,   595,   596,   597,   598,   599,
     600,   601,     0,   602,   603,     0,   604,   605,   211,   606,
     607,   608,   609,   610,   611,   612,   613,   985,   614,   615,
     616,   617,   618,     0,   619,   216,   620,   621,     0,   622,
     219,     0,   623,   624,   625,   626,   627,   628,   629,   630,
     631,   632,   221,     0,   633,   634,     0,   635,   636,   637,
     638,   639,   640,     0,   223,   224,     0,     0,   642,   225,
     643,   226,     0,   644,   645,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,     0,     0,   655,   656,
     657,   658,   659,   660,   233,     0,   661,     0,   662,   663,
     664,     0,     0,   665,     0,     0,   666,   667,   668,   669,
     670,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     671,   672,   673,    86,    87,    88,   411,    90,    91,    92,
     412,     0,   413,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   414,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   415,   416,     0,     0,     0,   417,   418,     0,
       0,     0,     0,   419,     0,     0,     0,     0,     0,     0,
       0,     0,   420,     0,   421,     0,   422,   423,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
     130,   131,     0,     0,     0,     0,     0,   436,   437,     0,
     438,   439,     0,   440,   441,   442,   135,   136,     0,   138,
     139,     0,   443,   444,   445,   446,   447,     0,     0,   448,
     449,   450,   140,   451,     0,   452,   453,   454,   455,   144,
       0,   456,     0,   457,   458,   459,   460,     0,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   469,
       0,     0,     0,     0,     0,     0,     0,     0,   470,   471,
     472,   473,   474,   475,   154,   155,   476,     0,   477,     0,
     478,   479,   480,   481,   482,     0,   483,   484,   485,     0,
       0,   486,   487,   488,   489,   490,     0,   491,   492,   493,
       0,   494,   495,     0,   496,   497,   498,   499,   163,   500,
     501,   502,   165,     0,   503,     0,   504,   167,   505,     0,
     506,     0,   507,     0,     0,     0,   508,   509,   510,     0,
     511,   171,     0,   512,     0,   513,   514,   515,   516,   517,
       0,   518,   519,   520,     0,   521,   522,   523,   524,   525,
     526,     0,   527,     0,   174,     0,   528,   529,   530,     0,
     175,     0,   176,     0,   531,     0,     0,   532,     0,   533,
     534,   535,   536,   537,   538,   539,     0,   180,     0,   540,
       0,     0,   541,   542,   543,     0,     0,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,   187,
       0,   189,   556,   557,   190,     0,   558,   559,     0,   560,
       0,   193,   561,   194,   562,   563,   564,     0,   565,     0,
       0,   566,   567,   568,     0,     0,   195,     0,     0,     0,
     199,   569,   570,   571,   572,   573,   574,   575,     0,   576,
     200,   577,   201,   578,   579,   580,     0,   581,   582,   583,
     584,   585,   586,   587,   203,   588,   589,   590,   591,     0,
     592,   593,   594,   595,   596,   597,   598,   599,   600,   601,
       0,   602,   603,     0,   604,   605,   211,   606,   607,   608,
     609,   610,   611,   612,   613,     0,   614,   615,   616,   617,
     618,     0,   619,   216,   620,   621,     0,   622,   219,     0,
     623,   624,   625,   626,   627,   628,   629,   630,   631,   632,
     221,     0,   633,   634,     0,   635,   636,   637,   638,   639,
     640,     0,   223,   224,     0,     0,   642,   225,   643,   226,
       0,   644,   645,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,     0,     0,   655,   656,   657,   658,
     659,   660,   233,     0,   661,  1353,   662,   663,   664,     0,
       0,   665,     0,     0,   666,   667,   668,   669,   670,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   671,   672,
     673,    86,    87,    88,   411,    90,    91,    92,   412,  2008,
     413,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   414,     0,     0,   107,   108,   109,   110,
       0,     0,  2289,   113,   114,   115,     0,   116,     0,     0,
     415,   416,     0,     0,     0,   417,   418,     0,     0,     0,
       0,   419,     0,     0,     0,     0,     0,     0,     0,     0,
     420,     0,   421,     0,   422,   423,    35,   424,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   425,   426,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,     0,     0,
       0,     0,     0,     0,     0,   436,   437,     0,   438,   439,
       0,   440,   441,   442,   135,   136,     0,   138,   139,     0,
     443,   444,   445,   446,   447,     0,     0,   448,   449,   450,
     140,   451,     0,   452,   453,   454,   455,   144,     0,   456,
       0,   457,   458,   459,   460,     0,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   469,     0,     0,
       0,     0,     0,     0,     0,     0,   470,   471,   472,   473,
     474,   475,   154,   155,   476,     0,   477,     0,   478,   479,
     480,   481,   482,     0,   483,   484,   485,     0,     0,   486,
     487,   488,   489,   490,     0,   491,   492,   493,     0,   494,
     495,     0,   496,   497,   498,   499,   163,   500,   501,   502,
     165,     0,   503,     0,   504,   167,   505,     0,   506,     0,
     507,     0,     0,     0,   508,   509,  2838,     0,   511,   171,
       0,   512,     0,   513,   514,   515,   516,   517,     0,   518,
     519,   520,     0,   521,   522,   523,   524,   525,   526,     0,
     527,     0,   174,     0,   528,   529,   530,     0,   175,     0,
     176,     0,   531,     0,     0,   532,     0,   533,   534,   535,
     536,   537,   538,   539,     0,   180,     0,   540,     0,     0,
     541,   542,  2839,     0,     0,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,   555,   187,     0,   189,
     556,   557,   190,     0,   558,   559,     0,   560,     0,   193,
     561,   194,   562,   563,   564,     0,   565,     0,     0,   566,
     567,   568,     0,     0,   195,     0,     0,     0,   199,   569,
     570,   571,   572,   573,   574,   575,     0,   576,   200,   577,
     201,   578,   579,   580,     0,   581,   582,   583,   584,   585,
     586,   587,   203,   588,   589,   590,   591,     0,   592,   593,
     594,   595,   596,   597,   598,   599,   600,   601,     0,   602,
     603,     0,   604,   605,   211,   606,   607,   608,   609,   610,
     611,   612,   613,     0,   614,   615,   616,   617,   618,     0,
     619,   216,   620,   621,     0,   622,   219,     0,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   221,     0,
     633,   634,  2840,   635,   636,  2841,   638,  2842,   640,     0,
     223,   224,     0,     0,   642,   225,   643,   226,     0,   644,
     645,   646,   647,   648,   649,     0,     0,   650,   651,  2843,
     653,   654,     0,     0,   655,   656,   657,   658,   659,   660,
     233,     0,   661,     0,   662,   663,   664,     0,     0,   665,
       0,     0,   666,   667,   668,   669,   670,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   671,   672,   673,    86,
      87,    88,   411,    90,    91,    92,   412,     0,   413,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   414,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   415,   416,
       0,     0,     0,   417,   418,     0,     0,     0,     0,   419,
       0,     0,     0,     0,     0,     0,     0,     0,   420,     0,
     421,     0,   422,   423,    35,   424,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   425,   426,   427,   428,   429,   430,
     431,   432,   702,   433,   434,   435,     0,     0,     0,     0,
       0,     0,     0,   436,   437,     0,   438,   439,     0,   440,
     441,   442,   135,   136,     0,   138,   139,     0,   443,   444,
     445,   446,   447,     0,     0,   448,   449,   450,   140,   451,
       0,   452,   453,   454,   455,   144,     0,   456,     0,   457,
     458,   459,   460,     0,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   469,     0,     0,     0,     0,
       0,     0,     0,     0,   470,   471,   472,   473,   474,   475,
     154,   155,   476,     0,   477,     0,   478,   479,   480,   481,
     482,     0,   483,   484,   485,     0,     0,   486,   487,   488,
     489,   490,     0,   491,   492,   493,     0,   494,   495,     0,
     496,   497,   498,   499,   163,   500,   501,   502,   165,     0,
     503,     0,   504,   167,   505,     0,   506,     0,   507,     0,
       0,     0,   508,   509,   510,     0,   511,   171,     0,   512,
       0,   513,   514,   515,   516,   517,     0,   518,   519,   520,
       0,   521,   522,   523,   524,   525,   526,     0,   527,     0,
     174,     0,   528,   529,   530,     0,   175,     0,   176,     0,
     531,     0,     0,   532,     0,   533,   534,   535,   536,   537,
     538,   539,     0,   180,     0,   540,     0,     0,   541,   542,
     543,     0,     0,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,   555,   187,     0,   189,   556,   557,
     190,     0,   558,   559,     0,   560,     0,   193,   561,   194,
     562,   563,   564,     0,   565,     0,     0,   566,   567,   568,
       0,     0,   195,     0,     0,     0,   199,   569,   570,   571,
     572,   573,   574,   575,     0,   576,   200,   577,   201,   578,
     579,   580,     0,   581,   582,   583,   584,   585,   586,   587,
     203,   588,   589,   590,   591,     0,   592,   593,   594,   595,
     596,   597,   598,   599,   600,   601,     0,   602,   603,     0,
     604,   605,   211,   606,   607,   608,   609,   610,   611,   612,
     613,     0,   614,   615,   616,   617,   618,     0,   619,   216,
     620,   621,     0,   622,   219,     0,   623,   624,   625,   626,
     627,   628,   629,   630,   631,   632,   221,     0,   633,   634,
       0,   635,   636,   637,   638,   639,   640,     0,   223,   224,
       0,     0,   642,   225,   643,   226,     0,   644,   645,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
       0,     0,   655,   656,   657,   658,   659,   660,   233,     0,
     661,     0,   662,   663,   664,     0,     0,   665,     0,     0,
     666,   667,   668,   669,   670,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   671,   672,   673,    86,    87,    88,
     411,    90,    91,    92,   412,     0,   413,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   414,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   415,   416,     0,     0,
       0,   417,   418,     0,     0,     0,     0,   419,     0,     0,
       0,     0,     0,     0,     0,     0,   420,     0,   421,     0,
     422,   423,    35,   424,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   425,   426,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,     0,     0,     0,     0,     0,     0,
       0,   436,   437,     0,   438,   439,     0,   440,   441,   442,
     135,   136,     0,   138,   139,     0,   443,   444,   445,   446,
     447,     0,     0,   448,   449,   450,   140,   451,     0,   452,
     453,   454,   455,   144,     0,   456,     0,   457,   458,   459,
     460,     0,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,     0,   469,     0,     0,     0,     0,     0,     0,
       0,     0,   470,   471,   472,   473,   474,   475,   154,   155,
     476,   695,   477,     0,   478,   479,   480,   481,   482,     0,
     483,   484,   485,     0,     0,   486,   487,   488,   489,   490,
       0,   491,   492,   493,     0,   494,   495,     0,   496,   497,
     498,   499,   163,   500,   501,   502,   165,     0,   503,     0,
     504,   167,   505,     0,   506,     0,   507,     0,     0,     0,
     508,   509,   510,     0,   511,   171,     0,   512,     0,   513,
     514,   515,   516,   517,     0,   518,   519,   520,     0,   521,
     522,   523,   524,   525,   526,     0,   527,     0,   174,     0,
     528,   529,   530,     0,   175,     0,   176,     0,   531,     0,
       0,   532,     0,   533,   534,   535,   536,   537,   538,   539,
       0,   180,     0,   540,     0,     0,   541,   542,   543,     0,
       0,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,   187,     0,   189,   556,   557,   190,     0,
     558,   559,     0,   560,     0,   193,   561,   194,   562,   563,
     564,     0,   565,     0,     0,   566,   567,   568,     0,     0,
     195,     0,     0,     0,   199,   569,   570,   571,   572,   573,
     574,   575,     0,   576,   200,   577,   201,   578,   579,   580,
       0,   581,   582,   583,   584,   585,   586,   587,   203,   588,
     589,   590,   591,     0,   592,   593,   594,   595,   596,   597,
     598,   599,   600,   601,     0,   602,   603,     0,   604,   605,
     211,   606,   607,   608,   609,   610,   611,   612,   613,     0,
     614,   615,   616,   617,   618,     0,   619,   216,   620,   621,
       0,   622,   219,     0,   623,   624,   625,   626,   627,   628,
     629,   630,   631,   632,   221,     0,   633,   634,     0,   635,
     636,   637,   638,   639,   640,     0,   223,   224,     0,     0,
     642,   225,   643,   226,     0,   644,   645,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,     0,     0,
     655,   656,   657,   658,   659,   660,   233,     0,   661,     0,
     662,   663,   664,     0,     0,   665,     0,     0,   666,   667,
     668,   669,   670,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   671,   672,   673,    86,    87,    88,   411,    90,
      91,    92,   412,     0,   413,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   414,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   415,   416,     0,     0,     0,   417,
     418,     0,     0,     0,     0,   419,     0,     0,     0,     0,
       0,     0,     0,     0,   420,     0,   421,     0,   422,   423,
      35,   424,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     425,   426,   427,   428,   429,   430,   431,   432,   850,   433,
     434,   435,     0,     0,     0,     0,     0,     0,     0,   436,
     437,     0,   438,   439,     0,   440,   441,   442,   135,   136,
       0,   138,   139,     0,   443,   444,   445,   446,   447,     0,
       0,   448,   449,   450,   140,   451,     0,   452,   453,   454,
     455,   144,     0,   456,     0,   457,   458,   459,   460,     0,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
       0,   469,     0,     0,     0,     0,     0,     0,     0,     0,
     470,   471,   472,   473,   474,   475,   154,   155,   476,     0,
     477,     0,   478,   479,   480,   481,   482,     0,   483,   484,
     485,     0,     0,   486,   487,   488,   489,   490,     0,   491,
     492,   493,     0,   494,   495,     0,   496,   497,   498,   499,
     163,   500,   501,   502,   165,     0,   503,     0,   504,   167,
     505,     0,   506,     0,   507,     0,     0,     0,   508,   509,
     510,     0,   511,   171,     0,   512,     0,   513,   514,   515,
     516,   517,     0,   518,   519,   520,     0,   521,   522,   523,
     524,   525,   526,     0,   527,     0,   174,     0,   528,   529,
     530,     0,   175,     0,   176,     0,   531,     0,     0,   532,
       0,   533,   534,   535,   536,   537,   538,   539,     0,   180,
       0,   540,     0,     0,   541,   542,   543,     0,     0,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   187,     0,   189,   556,   557,   190,     0,   558,   559,
       0,   560,     0,   193,   561,   194,   562,   563,   564,     0,
     565,     0,     0,   566,   567,   568,     0,     0,   195,     0,
       0,     0,   199,   569,   570,   571,   572,   573,   574,   575,
       0,   576,   200,   577,   201,   578,   579,   580,     0,   581,
     582,   583,   584,   585,   586,   587,   203,   588,   589,   590,
     591,     0,   592,   593,   594,   595,   596,   597,   598,   599,
     600,   601,     0,   602,   603,     0,   604,   605,   211,   606,
     607,   608,   609,   610,   611,   612,   613,     0,   614,   615,
     616,   617,   618,     0,   619,   216,   620,   621,     0,   622,
     219,     0,   623,   624,   625,   626,   627,   628,   629,   630,
     631,   632,   221,     0,   633,   634,     0,   635,   636,   637,
     638,   639,   640,     0,   223,   224,     0,     0,   642,   225,
     643,   226,     0,   644,   645,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,     0,     0,   655,   656,
     657,   658,   659,   660,   233,     0,   661,     0,   662,   663,
     664,     0,     0,   665,     0,     0,   666,   667,   668,   669,
     670,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     671,   672,   673,    86,    87,    88,   411,    90,    91,    92,
     412,     0,   413,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   414,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   415,   416,     0,     0,     0,   417,   418,     0,
       0,     0,     0,   419,     0,     0,     0,     0,     0,     0,
       0,     0,   420,     0,   421,     0,   422,   423,    35,   424,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,   430,   431,   432,  1291,   433,   434,   435,
       0,     0,     0,     0,     0,     0,     0,   436,   437,     0,
     438,   439,     0,   440,   441,   442,   135,   136,     0,   138,
     139,     0,   443,   444,   445,   446,   447,     0,     0,   448,
     449,   450,   140,   451,     0,   452,   453,   454,   455,   144,
       0,   456,     0,   457,   458,   459,   460,     0,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   469,
       0,     0,     0,     0,     0,     0,     0,     0,   470,   471,
     472,   473,   474,   475,   154,   155,   476,     0,   477,     0,
     478,   479,   480,   481,   482,     0,   483,   484,   485,     0,
       0,   486,   487,   488,   489,   490,     0,   491,   492,   493,
       0,   494,   495,     0,   496,   497,   498,   499,   163,   500,
     501,   502,   165,     0,   503,     0,   504,   167,   505,     0,
     506,     0,   507,     0,     0,     0,   508,   509,   510,     0,
     511,   171,     0,   512,     0,   513,   514,   515,   516,   517,
       0,   518,   519,   520,     0,   521,   522,   523,   524,   525,
     526,     0,   527,     0,   174,     0,   528,   529,   530,     0,
     175,     0,   176,     0,   531,     0,     0,   532,     0,   533,
     534,   535,   536,   537,   538,   539,     0,   180,     0,   540,
       0,     0,   541,   542,   543,     0,     0,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,   187,
       0,   189,   556,   557,   190,     0,   558,   559,     0,   560,
       0,   193,   561,   194,   562,   563,   564,     0,   565,     0,
       0,   566,   567,   568,     0,     0,   195,     0,     0,     0,
     199,   569,   570,   571,   572,   573,   574,   575,     0,   576,
     200,   577,   201,   578,   579,   580,     0,   581,   582,   583,
     584,   585,   586,   587,   203,   588,   589,   590,   591,     0,
     592,   593,   594,   595,   596,   597,   598,   599,   600,   601,
       0,   602,   603,     0,   604,   605,   211,   606,   607,   608,
     609,   610,   611,   612,   613,     0,   614,   615,   616,   617,
     618,     0,   619,   216,   620,   621,     0,   622,   219,     0,
     623,   624,   625,   626,   627,   628,   629,   630,   631,   632,
     221,     0,   633,   634,     0,   635,   636,   637,   638,   639,
     640,     0,   223,   224,     0,     0,   642,   225,   643,   226,
       0,   644,   645,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,     0,     0,   655,   656,   657,   658,
     659,   660,   233,     0,   661,     0,   662,   663,   664,     0,
       0,   665,     0,     0,   666,   667,   668,   669,   670,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   671,   672,
     673,    86,    87,    88,   411,    90,    91,    92,   412,     0,
     413,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   414,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     415,   416,     0,     0,     0,   417,   418,     0,     0,     0,
       0,   419,     0,     0,     0,     0,     0,     0,     0,     0,
     420,     0,   421,     0,   422,   423,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   425,   426,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,     0,     0,
       0,     0,     0,     0,     0,   436,   437,     0,   438,   439,
       0,   440,   441,   442,   135,   136,     0,   138,   139,     0,
     443,   444,   445,   446,   447,     0,     0,   448,   449,   450,
     140,   451,     0,   452,   453,   454,   455,   144,     0,   456,
       0,   457,   458,   459,   460,     0,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   469,     0,     0,
       0,     0,     0,     0,     0,  2481,   470,   471,   472,   473,
     474,   475,   154,   155,   476,     0,   477,     0,   478,   479,
     480,   481,   482,     0,   483,   484,   485,     0,     0,   486,
     487,   488,   489,   490,     0,   491,   492,   493,     0,   494,
     495,     0,   496,   497,   498,   499,   163,   500,   501,   502,
     165,     0,   503,     0,   504,   167,   505,     0,   506,     0,
     507,     0,     0,     0,   508,   509,   510,     0,   511,   171,
       0,   512,     0,   513,   514,   515,   516,   517,     0,   518,
     519,   520,     0,   521,   522,   523,   524,   525,   526,     0,
     527,     0,   174,     0,   528,   529,   530,     0,   175,     0,
     176,     0,   531,     0,     0,   532,     0,   533,   534,   535,
     536,   537,   538,   539,     0,   180,     0,   540,     0,     0,
     541,   542,   543,     0,     0,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,   555,   187,     0,   189,
     556,   557,   190,     0,   558,   559,     0,   560,     0,   193,
     561,   194,   562,   563,   564,     0,   565,     0,     0,   566,
     567,   568,     0,     0,   195,     0,     0,     0,   199,   569,
     570,   571,   572,   573,   574,   575,     0,   576,   200,   577,
     201,   578,   579,   580,     0,   581,   582,   583,   584,   585,
     586,   587,   203,   588,   589,   590,   591,     0,   592,   593,
     594,   595,   596,   597,   598,   599,   600,   601,     0,   602,
     603,     0,   604,   605,   211,   606,   607,   608,   609,   610,
     611,   612,   613,     0,   614,   615,   616,   617,   618,     0,
     619,   216,   620,   621,     0,   622,   219,     0,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   221,     0,
     633,   634,     0,   635,   636,   637,   638,   639,   640,     0,
     223,   224,     0,     0,   642,   225,   643,   226,     0,   644,
     645,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,   654,  2482,     0,   655,   656,   657,   658,   659,   660,
     233,     0,   661,     0,   662,   663,   664,     0,     0,   665,
       0,     0,   666,   667,   668,   669,   670,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   671,   672,   673,    86,
      87,    88,   411,    90,    91,    92,   412,     0,   413,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   414,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   415,   416,
       0,     0,     0,   417,   418,     0,     0,     0,     0,   419,
       0,     0,     0,     0,     0,     0,     0,     0,   420,     0,
     421,     0,   422,   423,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   425,   426,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,   130,   131,     0,     0,
       0,     0,     0,   436,   437,     0,   438,   439,     0,   440,
     441,   442,   135,   136,     0,   138,   139,     0,   443,   444,
     445,   446,   447,     0,     0,   448,   449,   450,   140,   451,
       0,   452,   453,   454,   455,   144,     0,   456,     0,   457,
     458,   459,   460,     0,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   469,     0,     0,     0,     0,
       0,     0,     0,     0,   470,   471,   472,   473,   474,   475,
     154,   155,   476,     0,   477,     0,   478,   479,   480,   481,
     482,     0,   483,   484,   485,     0,     0,   486,   487,   488,
     489,   490,     0,   491,   492,   493,     0,   494,   495,     0,
     496,   497,   498,   499,   163,   500,   501,   502,   165,     0,
     503,     0,   504,   167,   505,     0,   506,     0,   507,     0,
       0,     0,   508,   509,   510,     0,   511,   171,     0,   512,
       0,   513,   514,   515,   516,   517,     0,   518,   519,   520,
       0,   521,   522,   523,   524,   525,   526,     0,   527,     0,
     174,     0,   528,   529,   530,     0,   175,     0,   176,     0,
     531,     0,     0,   532,     0,   533,   534,   535,   536,   537,
     538,   539,     0,   180,     0,   540,     0,     0,   541,   542,
     543,     0,     0,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,   555,   187,     0,   189,   556,   557,
     190,     0,   558,   559,     0,   560,     0,   193,   561,   194,
     562,   563,   564,     0,   565,     0,     0,   566,   567,   568,
       0,     0,   195,     0,     0,     0,   199,   569,   570,   571,
     572,   573,   574,   575,     0,   576,   200,   577,   201,   578,
     579,   580,     0,   581,   582,   583,   584,   585,   586,   587,
     203,   588,   589,   590,   591,     0,   592,   593,   594,   595,
     596,   597,   598,   599,   600,   601,     0,   602,   603,     0,
     604,   605,   211,   606,   607,   608,   609,   610,   611,   612,
     613,     0,   614,   615,   616,   617,   618,     0,   619,   216,
     620,   621,     0,   622,   219,     0,   623,   624,   625,   626,
     627,   628,   629,   630,   631,   632,   221,     0,   633,   634,
       0,   635,   636,   637,   638,   639,   640,     0,   223,   224,
       0,     0,   642,   225,   643,   226,     0,   644,   645,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
       0,     0,   655,   656,   657,   658,   659,   660,   233,     0,
     661,     0,   662,   663,   664,     0,     0,   665,     0,     0,
     666,   667,   668,   669,   670,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   671,   672,   673,    86,    87,    88,
     411,    90,    91,    92,   412,     0,   413,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   414,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   415,   416,     0,     0,
       0,   417,   418,     0,     0,     0,     0,   419,     0,     0,
       0,     0,     0,     0,     0,     0,   420,     0,   421,     0,
     422,   423,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   425,   426,   427,   428,   429,   430,   431,   432,
    3034,   433,   434,   435,     0,     0,     0,     0,     0,     0,
       0,   436,   437,     0,   438,   439,     0,   440,   441,   442,
     135,   136,     0,   138,   139,     0,   443,   444,   445,   446,
     447,     0,     0,   448,   449,   450,   140,   451,     0,   452,
     453,   454,   455,   144,     0,   456,     0,   457,   458,   459,
     460,     0,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,     0,   469,     0,     0,     0,     0,     0,     0,
       0,     0,   470,   471,   472,   473,   474,   475,   154,   155,
     476,     0,   477,     0,   478,   479,   480,   481,   482,     0,
     483,   484,   485,     0,     0,   486,   487,   488,   489,   490,
       0,   491,   492,   493,     0,   494,   495,     0,   496,   497,
     498,   499,   163,   500,   501,   502,   165,     0,   503,     0,
     504,   167,   505,     0,   506,     0,   507,     0,     0,     0,
     508,   509,   510,     0,   511,   171,     0,   512,     0,   513,
     514,   515,   516,   517,     0,   518,   519,   520,     0,   521,
     522,   523,   524,   525,   526,     0,   527,     0,   174,     0,
     528,   529,   530,     0,   175,     0,   176,     0,   531,     0,
       0,   532,     0,   533,   534,   535,   536,   537,   538,   539,
       0,   180,     0,   540,     0,     0,   541,   542,   543,     0,
       0,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,   187,     0,   189,   556,   557,   190,     0,
     558,   559,     0,   560,     0,   193,   561,   194,   562,   563,
     564,     0,   565,     0,     0,   566,   567,   568,     0,     0,
     195,     0,     0,     0,   199,   569,   570,   571,   572,   573,
     574,   575,     0,   576,   200,   577,   201,   578,   579,   580,
       0,   581,   582,   583,   584,   585,   586,   587,   203,   588,
     589,   590,   591,     0,   592,   593,   594,   595,   596,   597,
     598,   599,   600,   601,     0,   602,   603,     0,   604,   605,
     211,   606,   607,   608,   609,   610,   611,   612,   613,     0,
     614,   615,   616,   617,   618,     0,   619,   216,   620,   621,
       0,   622,   219,     0,   623,   624,   625,   626,   627,   628,
     629,   630,   631,   632,   221,     0,   633,   634,     0,   635,
     636,   637,   638,   639,   640,     0,   223,   224,     0,     0,
     642,   225,   643,   226,     0,   644,   645,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,  3035,     0,
     655,   656,   657,   658,   659,   660,   233,     0,   661,     0,
     662,   663,   664,     0,     0,   665,     0,     0,   666,   667,
     668,   669,   670,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   671,   672,   673,    86,    87,    88,   411,    90,
      91,    92,   412,     0,   413,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   414,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   415,   416,     0,     0,     0,   417,
     418,     0,     0,     0,     0,   419,     0,     0,     0,     0,
       0,     0,     0,     0,   420,     0,   421,     0,   422,   423,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     425,   426,   427,   428,   429,   430,   431,   432,  3046,   433,
     434,   435,     0,     0,     0,     0,     0,     0,     0,   436,
     437,     0,   438,   439,     0,   440,   441,   442,   135,   136,
       0,   138,   139,     0,   443,   444,   445,   446,   447,     0,
       0,   448,   449,   450,   140,   451,     0,   452,   453,   454,
     455,   144,     0,   456,     0,   457,   458,   459,   460,     0,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
       0,   469,     0,     0,     0,     0,     0,     0,     0,     0,
     470,   471,   472,   473,   474,   475,   154,   155,   476,     0,
     477,     0,   478,   479,   480,   481,   482,     0,   483,   484,
     485,     0,     0,   486,   487,   488,   489,   490,     0,   491,
     492,   493,     0,   494,   495,     0,   496,   497,   498,   499,
     163,   500,   501,   502,   165,     0,   503,     0,   504,   167,
     505,     0,   506,     0,   507,     0,     0,     0,   508,   509,
     510,     0,   511,   171,     0,   512,     0,   513,   514,   515,
     516,   517,     0,   518,   519,   520,     0,   521,   522,   523,
     524,   525,   526,     0,   527,     0,   174,     0,   528,   529,
     530,     0,   175,     0,   176,     0,   531,     0,     0,   532,
       0,   533,   534,   535,   536,   537,   538,   539,     0,   180,
       0,   540,     0,     0,   541,   542,   543,     0,     0,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   187,     0,   189,   556,   557,   190,     0,   558,   559,
       0,   560,     0,   193,   561,   194,   562,   563,   564,     0,
     565,     0,     0,   566,   567,   568,     0,     0,   195,     0,
       0,     0,   199,   569,   570,   571,   572,   573,   574,   575,
       0,   576,   200,   577,   201,   578,   579,   580,     0,   581,
     582,   583,   584,   585,   586,   587,   203,   588,   589,   590,
     591,     0,   592,   593,   594,   595,   596,   597,   598,   599,
     600,   601,     0,   602,   603,     0,   604,   605,   211,   606,
     607,   608,   609,   610,   611,   612,   613,     0,   614,   615,
     616,   617,   618,     0,   619,   216,   620,   621,     0,   622,
     219,     0,   623,   624,   625,   626,   627,   628,   629,   630,
     631,   632,   221,     0,   633,   634,     0,   635,   636,   637,
     638,   639,   640,     0,   223,   224,     0,     0,   642,   225,
     643,   226,     0,   644,   645,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,  3047,     0,   655,   656,
     657,   658,   659,   660,   233,     0,   661,     0,   662,   663,
     664,     0,     0,   665,     0,     0,   666,   667,   668,   669,
     670,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     671,   672,   673,    86,    87,    88,   411,    90,    91,    92,
     412,     0,   413,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   414,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   415,   416,     0,     0,     0,   417,   418,     0,
       0,     0,     0,   419,     0,     0,     0,     0,     0,     0,
       0,     0,   420,     0,   421,     0,   422,   423,    35,   424,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
       0,     0,     0,     0,     0,     0,     0,   436,   437,     0,
     438,   439,     0,   440,   441,   442,   135,   136,     0,   138,
     139,     0,   443,   444,   445,   446,   447,     0,     0,   448,
     449,   450,   140,   451,     0,   452,   453,   454,   455,   144,
       0,   456,     0,   457,   458,   459,   460,     0,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   469,
       0,     0,     0,     0,     0,     0,     0,     0,   470,   471,
     472,   473,   474,   475,   154,   155,   476,     0,   477,     0,
     478,   479,   480,   481,   482,     0,   483,   484,   485,     0,
       0,   486,   487,   488,   489,   490,     0,   491,   492,   493,
       0,   494,   495,     0,   496,   497,   498,   499,   163,   500,
     501,   502,   165,     0,   503,     0,   504,   167,   505,     0,
     506,     0,   507,     0,     0,     0,   508,   509,   510,     0,
     511,   171,     0,   512,     0,   513,   514,   515,   516,   517,
       0,   518,   519,   520,     0,   521,   522,   523,   524,   525,
     526,     0,   527,     0,   174,     0,   528,   529,   530,     0,
     175,     0,   176,     0,   531,     0,     0,   532,     0,   533,
     534,   535,   536,   537,   538,   539,     0,   180,     0,   540,
       0,     0,   541,   542,   543,     0,     0,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,   187,
       0,   189,   556,   557,   190,     0,   558,   559,     0,   560,
       0,   193,   561,   194,   562,   563,   564,     0,   565,     0,
       0,   566,   567,   568,     0,     0,   195,     0,     0,     0,
     199,   569,   570,   571,   572,   573,   574,   575,     0,   576,
     200,   577,   201,   578,   579,   580,     0,   581,   582,   583,
     584,   585,   586,   587,   203,   588,   589,   590,   591,     0,
     592,   593,   594,   595,   596,   597,   598,   599,   600,   601,
       0,   602,   603,     0,   604,   605,   211,   606,   607,   608,
     609,   610,   611,   612,   613,     0,   614,   615,   616,   617,
     618,     0,   619,   216,   620,   621,     0,   622,   219,     0,
     623,   624,   625,   626,   627,   628,   629,   630,   631,   632,
     221,     0,   633,   634,     0,   635,   636,   637,   638,   639,
     640,     0,   223,   224,     0,     0,   642,   225,   643,   226,
       0,   644,   645,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,     0,     0,   655,   656,   657,   658,
     659,   660,   233,     0,   661,     0,   662,   663,   664,     0,
       0,   665,     0,     0,   666,   667,   668,   669,   670,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   671,   672,
     673,    86,    87,    88,   411,    90,    91,    92,   412,     0,
     413,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   414,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     415,   416,     0,     0,     0,   417,   418,     0,     0,     0,
       0,   419,     0,     0,     0,     0,     0,     0,     0,     0,
     420,     0,   421,     0,   422,   423,    35,   424,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   425,   426,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,     0,     0,
       0,     0,     0,     0,     0,   436,   437,     0,   438,   439,
       0,   440,   441,   442,   135,   136,     0,   138,   139,     0,
     443,   444,   445,   446,   447,     0,     0,   448,   449,   450,
     140,   451,     0,   452,   453,   454,   455,   144,     0,   456,
       0,   457,   458,   459,   460,     0,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   469,     0,     0,
       0,     0,     0,     0,     0,     0,   470,   471,   472,   473,
     474,   475,   154,   155,   476,     0,   477,     0,   478,   479,
     480,   481,   482,     0,   483,   484,   485,     0,     0,   486,
     487,   488,   489,   490,     0,   491,   492,   493,     0,   494,
     495,     0,   496,   497,   498,   499,   163,   500,   501,   502,
     165,     0,   503,     0,   504,   167,   505,     0,   506,     0,
     507,     0,     0,     0,   508,   509,   510,     0,   511,   171,
       0,   512,     0,   513,   514,   515,   516,   517,     0,   518,
     519,   520,     0,   521,   522,   523,   524,   525,   526,     0,
     527,     0,   174,     0,   528,   529,   530,     0,   175,     0,
     176,     0,   531,     0,     0,   532,     0,   533,   534,   535,
     536,   537,   538,   539,     0,   180,     0,   540,     0,     0,
     541,   542,   543,     0,     0,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,   555,   187,     0,   189,
     556,   557,   190,     0,   558,   559,     0,   560,     0,   193,
     561,   194,   562,   563,   564,     0,   565,     0,     0,   566,
     567,   568,     0,     0,   195,     0,     0,     0,   199,   569,
     570,   571,   572,   573,   574,   575,     0,   576,   200,   577,
     201,   578,   579,   580,     0,   581,   582,   583,   584,   585,
     586,   587,   203,   588,   589,   590,   591,     0,   592,   593,
     594,   595,   596,   597,   598,   599,   600,   601,     0,   602,
     603,     0,   604,   605,   211,   606,   607,   608,   609,   610,
     611,   612,   613,     0,   614,   615,   616,   617,   618,     0,
     619,   216,   620,   621,     0,   622,   219,     0,   623,   624,
     625,   904,   627,   628,   629,   630,   631,   632,   221,     0,
     633,   634,     0,   635,   636,   637,   638,   639,   640,     0,
     223,   224,     0,     0,   642,   225,   643,   226,     0,   644,
     645,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,   654,     0,     0,   655,   656,   657,   658,   659,   660,
     233,     0,   661,     0,   662,   663,   664,     0,     0,   665,
       0,     0,   666,   667,   668,   669,   670,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   671,   672,   673,    86,
      87,    88,   411,    90,    91,    92,   412,     0,   413,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   414,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   415,   416,
       0,     0,     0,   417,   418,     0,     0,     0,     0,   419,
       0,     0,     0,     0,     0,     0,     0,     0,   420,     0,
     421,     0,   422,   423,    35,   424,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   425,   426,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,     0,     0,     0,     0,
       0,     0,     0,   436,   437,     0,   438,   439,     0,   440,
     441,   442,   135,   136,     0,   138,   139,     0,   443,   444,
     445,   446,   447,     0,     0,   448,   449,   450,   140,   451,
       0,   452,   453,   454,   455,   144,     0,   456,     0,   457,
     458,   459,   460,     0,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   469,     0,     0,     0,     0,
       0,     0,     0,     0,   470,   471,   472,   473,   474,   475,
     154,   155,   476,     0,   477,     0,   478,   479,   480,   481,
     482,     0,   483,   484,   485,     0,     0,   486,   487,   488,
     489,   490,     0,   491,   492,   493,     0,   494,   495,     0,
     496,   497,   498,   499,   163,   500,   501,   502,   165,     0,
     503,     0,   504,   167,   505,     0,   506,     0,   507,     0,
       0,     0,   508,   509,   510,     0,   511,   171,     0,   512,
       0,   513,   514,   515,   516,   517,     0,   946,   519,   520,
       0,   521,   522,   523,   524,   525,   526,     0,   527,     0,
     174,     0,   528,   529,   530,     0,   175,     0,   176,     0,
     531,     0,     0,   532,     0,   533,   534,   535,   536,   537,
     538,   539,     0,   180,     0,   540,     0,     0,   541,   542,
     543,     0,     0,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,   555,   187,     0,   189,   556,   557,
     190,     0,   558,   559,     0,   560,     0,   193,   561,   194,
     562,   563,   564,     0,   565,     0,     0,   566,   567,   568,
       0,     0,   195,     0,     0,     0,   199,   569,   570,   571,
     572,   573,   574,   575,     0,   576,   200,   577,   201,   578,
     579,   580,     0,   581,   582,   583,   584,   585,   586,   587,
     203,   588,   589,   590,   591,     0,   592,   593,   594,   595,
     596,   597,   598,   599,   600,   601,     0,   602,   603,     0,
     604,   605,   211,   606,   607,   608,   609,   610,   611,   612,
     613,     0,   614,   615,   616,   617,   618,     0,   619,   216,
     620,   621,     0,   622,   219,     0,   623,   624,   625,   626,
     627,   628,   629,   630,   631,   632,   221,     0,   633,   634,
       0,   635,   636,   637,   638,   639,   640,     0,   223,   224,
       0,     0,   642,   225,   643,   226,     0,   644,   645,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
       0,     0,   655,   656,   657,   658,   659,   660,   233,     0,
     661,     0,   662,   663,   664,     0,     0,   665,     0,     0,
     666,   667,   668,   669,   670,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   671,   672,   673,    86,    87,    88,
     411,    90,    91,    92,   412,     0,   413,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   414,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   415,   416,     0,     0,
       0,   417,   418,     0,     0,     0,     0,   419,     0,     0,
       0,     0,     0,     0,     0,     0,   420,     0,   421,     0,
     422,   423,    35,   424,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   425,   426,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,     0,     0,     0,     0,     0,     0,
       0,   436,   437,     0,   438,   439,     0,   440,   441,   442,
     135,   136,     0,   138,   139,     0,   443,   444,   445,   446,
     447,     0,     0,   448,   449,   450,   140,   451,     0,   452,
     453,   454,   455,   144,     0,   456,     0,   457,   458,   459,
     460,     0,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,     0,   469,     0,     0,     0,     0,     0,     0,
       0,     0,   470,   471,   472,   473,   474,   475,   154,   155,
     476,     0,   477,     0,   478,   479,   480,   481,   482,     0,
     483,   484,   485,     0,     0,   486,   487,   488,   489,   490,
       0,   491,   492,   493,     0,   494,   495,     0,   496,   497,
     498,   499,   163,   500,   501,   502,   165,     0,   503,     0,
     504,   167,   505,     0,   506,     0,   507,     0,     0,     0,
     508,   509,   510,     0,   511,   171,     0,   512,     0,   513,
     514,   515,   516,   517,     0,   518,   519,   520,     0,   521,
     522,   523,   524,   525,   526,     0,   527,     0,   174,     0,
     528,   529,   530,     0,   175,     0,   176,     0,   531,     0,
       0,   532,     0,   533,   534,   535,   536,   537,   538,   539,
       0,   180,     0,   540,     0,     0,   541,   542,   543,     0,
       0,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,   187,     0,   189,   556,   557,   190,     0,
     558,   559,     0,   560,     0,   193,   561,   194,   562,   563,
     564,     0,   565,     0,     0,   566,   567,   568,     0,     0,
     195,     0,     0,     0,   199,   569,   570,   571,   572,   573,
     574,   575,     0,   576,   200,   577,   201,   578,   579,   580,
       0,   581,   582,   583,   584,   585,   586,   587,   203,   588,
     589,   590,   591,     0,   592,   593,   594,   595,   596,   597,
     598,   599,   600,   601,     0,   602,   603,     0,   604,   605,
     211,   606,   607,   608,   609,   610,   611,   612,   613,     0,
     614,   615,   616,   617,   618,     0,   619,   216,   620,   621,
       0,   622,   219,     0,   623,   624,   625,   626,   627,   628,
     629,   630,   631,   632,   221,     0,   633,   634,     0,   635,
     636,   637,   638,   639,   640,     0,   223,   224,     0,     0,
     999,   225,   643,   226,     0,   644,   645,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,     0,     0,
     655,   656,   657,   658,   659,   660,   233,     0,   661,     0,
     662,   663,   664,     0,     0,   665,     0,     0,   666,   667,
     668,   669,   670,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   671,   672,   673,    86,    87,    88,   411,    90,
      91,    92,   412,     0,   413,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   414,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   415,   416,     0,     0,     0,   417,
     418,     0,     0,     0,     0,   419,     0,     0,     0,     0,
       0,     0,     0,     0,   420,     0,   421,     0,   422,   423,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     425,   426,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,     0,     0,     0,     0,     0,     0,     0,   436,
     437,     0,   438,   439,     0,   440,   441,   442,   135,   136,
       0,   138,   139,     0,   443,   444,   445,   446,   447,     0,
       0,   448,   449,   450,   140,   451,     0,   452,   453,   454,
     455,   144,     0,   456,     0,   457,   458,   459,   460,     0,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
       0,   469,     0,     0,     0,     0,     0,     0,     0,     0,
     470,   471,   472,   473,   474,   475,   154,   155,   476,     0,
     477,     0,   478,   479,   480,   481,   482,     0,   483,   484,
     485,     0,     0,   486,   487,   488,   489,   490,     0,   491,
     492,   493,     0,   494,   495,     0,   496,   497,   498,   499,
     163,   500,   501,   502,   165,     0,   503,     0,   504,   167,
     505,     0,   506,     0,   507,     0,     0,     0,   508,   509,
     510,     0,   511,   171,     0,   512,     0,   513,   514,   515,
     516,   517,     0,   518,   519,   520,     0,   521,   522,   523,
     524,   525,   526,     0,   527,     0,   174,     0,   528,   529,
     530,     0,   175,     0,   176,     0,   531,     0,     0,   532,
       0,   533,   534,   535,   536,   537,   538,   539,     0,   180,
       0,   540,     0,     0,   541,   542,   543,     0,     0,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   187,     0,   189,   556,   557,   190,     0,   558,   559,
       0,   560,     0,   193,   561,   194,   562,   563,   564,     0,
     565,     0,  1055,   566,   567,   568,     0,     0,   195,     0,
       0,     0,   199,   569,   570,   571,   572,   573,   574,   575,
       0,   576,   200,   577,   201,   578,   579,   580,     0,   581,
     582,   583,   584,   585,   586,   587,   203,   588,   589,   590,
     591,     0,   592,   593,   594,   595,   596,   597,   598,   599,
     600,   601,     0,   602,   603,     0,   604,   605,   211,   606,
     607,   608,   609,   610,   611,   612,   613,     0,   614,   615,
     616,   617,   618,     0,   619,   216,   620,   621,     0,   622,
     219,     0,   623,   624,   625,   626,   627,   628,   629,   630,
     631,   632,   221,     0,   633,   634,     0,   635,   636,   637,
     638,   639,   640,     0,   223,   224,     0,     0,   642,   225,
     643,   226,     0,   644,   645,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,     0,     0,   655,   656,
     657,   658,   659,   660,   233,     0,   661,     0,   662,   663,
     664,     0,     0,   665,     0,     0,   666,   667,   668,   669,
     670,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     671,   672,   673,    86,    87,    88,   411,    90,    91,    92,
     412,     0,   413,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   414,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   415,   416,     0,     0,     0,   417,   418,     0,
       0,     0,     0,   419,     0,     0,     0,     0,     0,     0,
       0,     0,   420,     0,   421,     0,   422,   423,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,   430,   431,   432,  1533,   433,   434,   435,
       0,     0,     0,     0,     0,     0,     0,   436,   437,     0,
     438,   439,     0,   440,   441,   442,   135,   136,     0,   138,
     139,     0,   443,   444,   445,   446,   447,     0,     0,   448,
     449,   450,   140,   451,     0,   452,   453,   454,   455,   144,
       0,   456,     0,   457,   458,   459,   460,     0,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   469,
       0,     0,     0,     0,     0,     0,     0,     0,   470,   471,
     472,   473,   474,   475,   154,   155,   476,     0,   477,     0,
     478,   479,   480,   481,   482,     0,   483,   484,   485,     0,
       0,   486,   487,   488,   489,   490,     0,   491,   492,   493,
       0,   494,   495,     0,   496,   497,   498,   499,   163,   500,
     501,   502,   165,     0,   503,     0,   504,   167,   505,     0,
     506,     0,   507,     0,     0,     0,   508,   509,   510,     0,
     511,   171,     0,   512,     0,   513,   514,   515,   516,   517,
       0,   518,   519,   520,     0,   521,   522,   523,   524,   525,
     526,     0,   527,     0,   174,     0,   528,   529,   530,     0,
     175,     0,   176,     0,   531,     0,     0,   532,     0,   533,
     534,   535,   536,   537,   538,   539,     0,   180,     0,   540,
       0,     0,   541,   542,   543,     0,     0,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,   187,
       0,   189,   556,   557,   190,     0,   558,   559,     0,   560,
       0,   193,   561,   194,   562,   563,   564,     0,   565,     0,
       0,   566,   567,   568,     0,     0,   195,     0,     0,     0,
     199,   569,   570,   571,   572,   573,   574,   575,     0,   576,
     200,   577,   201,   578,   579,   580,     0,   581,   582,   583,
     584,   585,   586,   587,   203,   588,   589,   590,   591,     0,
     592,   593,   594,   595,   596,   597,   598,   599,   600,   601,
       0,   602,   603,     0,   604,   605,   211,   606,   607,   608,
     609,   610,   611,   612,   613,     0,   614,   615,   616,   617,
     618,     0,   619,   216,   620,   621,     0,   622,   219,     0,
     623,   624,   625,   626,   627,   628,   629,   630,   631,   632,
     221,     0,   633,   634,     0,   635,   636,   637,   638,   639,
     640,     0,   223,   224,     0,     0,   642,   225,   643,   226,
       0,   644,   645,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,     0,     0,   655,   656,   657,   658,
     659,   660,   233,     0,   661,     0,   662,   663,   664,     0,
       0,   665,     0,     0,   666,   667,   668,   669,   670,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   671,   672,
     673,    86,    87,    88,   411,    90,    91,    92,   412,     0,
     413,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   414,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     415,   416,     0,     0,     0,   417,   418,     0,     0,     0,
       0,   419,     0,     0,     0,     0,     0,     0,     0,     0,
     420,     0,   421,     0,   422,   423,    35,     0,     0,  1918,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   425,   426,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,     0,     0,
       0,     0,     0,     0,     0,   436,   437,     0,   438,   439,
       0,   440,   441,   442,   135,   136,     0,   138,   139,     0,
     443,   444,   445,   446,   447,     0,     0,   448,   449,   450,
     140,   451,     0,   452,   453,   454,   455,   144,     0,   456,
       0,   457,   458,   459,   460,     0,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   469,     0,     0,
       0,     0,     0,     0,     0,     0,   470,   471,   472,   473,
     474,   475,   154,   155,   476,     0,   477,     0,   478,   479,
     480,   481,   482,     0,   483,   484,   485,     0,     0,   486,
     487,   488,   489,   490,     0,   491,   492,   493,     0,   494,
     495,     0,   496,   497,   498,   499,   163,   500,   501,   502,
     165,     0,   503,     0,   504,   167,   505,     0,   506,     0,
     507,     0,     0,     0,   508,   509,   510,     0,   511,   171,
       0,   512,     0,   513,   514,   515,   516,   517,     0,   518,
     519,   520,     0,   521,   522,   523,   524,   525,   526,     0,
     527,     0,   174,     0,   528,   529,   530,     0,   175,     0,
     176,     0,   531,     0,     0,   532,     0,   533,   534,   535,
     536,   537,   538,   539,     0,   180,     0,   540,     0,     0,
     541,   542,   543,     0,     0,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,   555,   187,     0,   189,
     556,   557,   190,     0,   558,   559,     0,   560,     0,   193,
     561,   194,   562,   563,   564,     0,   565,     0,     0,   566,
     567,   568,     0,     0,   195,     0,     0,     0,   199,   569,
     570,   571,   572,   573,   574,   575,     0,   576,   200,   577,
     201,   578,   579,   580,     0,   581,   582,   583,   584,   585,
     586,   587,   203,   588,   589,   590,   591,     0,   592,   593,
     594,   595,   596,   597,   598,   599,   600,   601,     0,   602,
     603,     0,   604,   605,   211,   606,   607,   608,   609,   610,
     611,   612,   613,     0,   614,   615,   616,   617,   618,     0,
     619,   216,   620,   621,     0,   622,   219,     0,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   221,     0,
     633,   634,     0,   635,   636,   637,   638,   639,   640,     0,
     223,   224,     0,     0,   642,   225,   643,   226,     0,   644,
     645,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,   654,     0,     0,   655,   656,   657,   658,   659,   660,
     233,     0,   661,     0,   662,   663,   664,     0,     0,   665,
       0,     0,   666,   667,   668,   669,   670,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   671,   672,   673,    86,
      87,    88,   411,    90,    91,    92,   412,  2008,   413,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   414,     0,     0,   107,   108,   109,   110,     0,     0,
    2289,   113,   114,   115,     0,   116,     0,     0,   415,   416,
       0,     0,     0,   417,   418,     0,     0,     0,     0,   419,
       0,     0,     0,     0,     0,     0,     0,     0,   420,     0,
     421,     0,   422,   423,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   425,   426,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,     0,     0,     0,     0,
       0,     0,     0,   436,   437,     0,   438,   439,     0,   440,
     441,   442,   135,   136,     0,   138,   139,     0,   443,   444,
     445,   446,   447,     0,     0,   448,   449,   450,   140,   451,
       0,   452,   453,   454,   455,   144,     0,   456,     0,   457,
     458,   459,   460,     0,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   469,     0,     0,     0,     0,
       0,     0,     0,     0,   470,   471,   472,   473,   474,   475,
     154,   155,   476,     0,   477,     0,   478,   479,   480,   481,
     482,     0,   483,   484,   485,     0,     0,   486,   487,   488,
     489,   490,     0,   491,   492,   493,     0,   494,   495,     0,
     496,   497,   498,   499,   163,   500,   501,   502,   165,     0,
     503,     0,   504,   167,   505,     0,   506,     0,   507,     0,
       0,     0,   508,   509,   510,     0,   511,   171,     0,   512,
       0,   513,   514,   515,   516,   517,     0,   518,   519,   520,
       0,   521,   522,   523,   524,   525,   526,     0,   527,     0,
     174,     0,   528,   529,   530,     0,   175,     0,   176,     0,
     531,     0,     0,   532,     0,   533,   534,   535,   536,   537,
     538,   539,     0,   180,     0,   540,     0,     0,   541,   542,
     543,     0,     0,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,   555,   187,     0,   189,   556,   557,
     190,     0,   558,   559,     0,   560,     0,   193,   561,   194,
     562,   563,   564,     0,   565,     0,     0,   566,   567,   568,
       0,     0,   195,     0,     0,     0,   199,   569,   570,   571,
     572,   573,   574,   575,     0,   576,   200,   577,   201,   578,
     579,   580,     0,   581,   582,   583,   584,   585,   586,   587,
     203,   588,   589,   590,   591,     0,   592,   593,   594,   595,
     596,   597,   598,   599,   600,   601,     0,   602,   603,     0,
     604,   605,   211,   606,   607,   608,   609,   610,   611,   612,
     613,     0,   614,   615,   616,   617,   618,     0,   619,   216,
     620,   621,     0,   622,   219,     0,   623,   624,   625,   626,
     627,   628,   629,   630,   631,   632,   221,     0,   633,   634,
       0,   635,   636,   637,   638,   639,   640,     0,   223,   224,
       0,     0,   642,   225,   643,   226,     0,   644,   645,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
       0,     0,   655,   656,   657,   658,   659,   660,   233,     0,
     661,     0,   662,   663,   664,     0,     0,   665,     0,     0,
     666,   667,   668,   669,   670,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   671,   672,   673,    86,    87,    88,
     411,    90,    91,    92,   412,     0,   413,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   414,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   415,   416,     0,     0,
       0,   417,   418,     0,     0,     0,     0,   419,     0,     0,
       0,     0,     0,     0,     0,     0,   420,     0,   421,     0,
     422,   423,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   425,   426,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,     0,     0,     0,     0,     0,     0,
       0,   436,   437,     0,   438,   439,     0,   440,   441,   442,
     135,   136,     0,   138,   139,     0,   443,   444,   445,   446,
     447,     0,     0,   448,   449,   450,   140,   451,     0,   452,
     453,   454,   455,   144,     0,   456,     0,   457,   458,   459,
     460,     0,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,     0,   469,     0,     0,     0,     0,     0,     0,
       0,     0,   470,   471,   472,   473,   474,   475,   154,   155,
     476,     0,   477,     0,   478,   479,   480,   481,   482,     0,
     483,   484,   485,     0,     0,   486,   487,   488,   489,   490,
       0,   491,   492,   493,     0,   494,   495,     0,   496,   497,
     498,   499,   163,   500,   501,   502,   165,     0,   503,     0,
     504,   167,   505,     0,   506,     0,   507,     0,     0,     0,
     508,   509,   510,     0,   511,   171,  3303,   512,     0,   513,
     514,   515,   516,   517,     0,   518,   519,   520,     0,   521,
     522,   523,   524,   525,   526,     0,   527,     0,   174,     0,
     528,   529,   530,     0,   175,     0,   176,     0,   531,     0,
       0,   532,     0,   533,   534,   535,   536,   537,   538,   539,
       0,   180,     0,   540,     0,     0,   541,   542,   543,     0,
       0,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,   187,     0,   189,   556,   557,   190,     0,
     558,   559,     0,   560,     0,   193,   561,   194,   562,   563,
     564,     0,   565,     0,     0,   566,   567,   568,     0,     0,
     195,     0,     0,     0,   199,   569,   570,   571,   572,   573,
     574,   575,     0,   576,   200,   577,   201,   578,   579,   580,
       0,   581,   582,   583,   584,   585,   586,   587,   203,   588,
     589,   590,   591,     0,   592,   593,   594,   595,   596,   597,
     598,   599,   600,   601,     0,   602,   603,     0,   604,   605,
     211,   606,   607,   608,   609,   610,   611,   612,   613,     0,
     614,   615,   616,   617,   618,     0,   619,   216,   620,   621,
       0,   622,   219,     0,   623,   624,   625,   626,   627,   628,
     629,   630,   631,   632,   221,     0,   633,   634,     0,   635,
     636,   637,   638,   639,   640,     0,   223,   224,     0,     0,
     642,   225,   643,   226,     0,   644,   645,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,     0,     0,
     655,   656,   657,   658,   659,   660,   233,     0,   661,     0,
     662,   663,   664,     0,     0,   665,     0,     0,   666,   667,
     668,   669,   670,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   671,   672,   673,    86,    87,    88,   411,    90,
      91,    92,   412,     0,   413,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   414,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   415,   416,     0,     0,     0,   417,
     418,     0,     0,     0,     0,   419,     0,     0,     0,     0,
       0,     0,     0,     0,   420,     0,   421,     0,   422,   423,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     425,   426,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,     0,     0,     0,     0,     0,  3924,     0,   436,
     437,     0,   438,   439,     0,   440,   441,   442,   135,   136,
       0,   138,   139,     0,   443,   444,   445,   446,   447,     0,
       0,   448,   449,   450,   140,   451,     0,   452,   453,   454,
     455,   144,     0,   456,     0,   457,   458,   459,   460,     0,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
       0,   469,     0,     0,     0,     0,     0,     0,     0,     0,
     470,   471,   472,   473,   474,   475,   154,   155,   476,     0,
     477,     0,   478,   479,   480,   481,   482,     0,   483,   484,
     485,     0,     0,   486,   487,   488,   489,   490,     0,   491,
     492,   493,     0,   494,   495,     0,   496,   497,   498,   499,
     163,   500,   501,   502,   165,     0,   503,     0,   504,   167,
     505,     0,   506,     0,   507,     0,     0,     0,   508,   509,
     510,     0,   511,   171,     0,   512,     0,   513,   514,   515,
     516,   517,     0,   518,   519,   520,     0,   521,   522,   523,
     524,   525,   526,     0,   527,     0,   174,     0,   528,   529,
     530,     0,   175,     0,   176,     0,   531,     0,     0,   532,
       0,   533,   534,   535,   536,   537,   538,   539,     0,   180,
       0,   540,     0,     0,   541,   542,   543,     0,     0,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   187,     0,   189,   556,   557,   190,     0,   558,   559,
       0,   560,     0,   193,   561,   194,   562,   563,   564,     0,
     565,     0,     0,   566,   567,   568,     0,     0,   195,     0,
       0,     0,   199,   569,   570,   571,   572,   573,   574,   575,
       0,   576,   200,   577,   201,   578,   579,   580,     0,   581,
     582,   583,   584,   585,   586,   587,   203,   588,   589,   590,
     591,     0,   592,   593,   594,   595,   596,   597,   598,   599,
     600,   601,     0,   602,   603,     0,   604,   605,   211,   606,
     607,   608,   609,   610,   611,   612,   613,     0,   614,   615,
     616,   617,   618,     0,   619,   216,   620,   621,     0,   622,
     219,     0,   623,   624,   625,   626,   627,   628,   629,   630,
     631,   632,   221,     0,   633,   634,     0,   635,   636,   637,
     638,   639,   640,     0,   223,   224,     0,     0,   642,   225,
     643,   226,     0,   644,   645,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,     0,     0,   655,   656,
     657,   658,   659,   660,   233,     0,   661,     0,   662,   663,
     664,     0,     0,   665,     0,     0,   666,   667,   668,   669,
     670,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     671,   672,   673,    86,    87,    88,   411,    90,    91,    92,
     412,     0,   413,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   414,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   415,   416,     0,     0,     0,   417,   418,     0,
       0,     0,     0,   419,     0,     0,     0,     0,     0,     0,
       0,     0,   420,     0,   421,     0,   422,   423,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
       0,     0,     0,     0,     0,  3937,     0,   436,   437,     0,
     438,   439,     0,   440,   441,   442,   135,   136,     0,   138,
     139,     0,   443,   444,   445,   446,   447,     0,     0,   448,
     449,   450,   140,   451,     0,   452,   453,   454,   455,   144,
       0,   456,     0,   457,   458,   459,   460,     0,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   469,
       0,     0,     0,     0,     0,     0,     0,     0,   470,   471,
     472,   473,   474,   475,   154,   155,   476,     0,   477,     0,
     478,   479,   480,   481,   482,     0,   483,   484,   485,     0,
       0,   486,   487,   488,   489,   490,     0,   491,   492,   493,
       0,   494,   495,     0,   496,   497,   498,   499,   163,   500,
     501,   502,   165,     0,   503,     0,   504,   167,   505,     0,
     506,     0,   507,     0,     0,     0,   508,   509,   510,     0,
     511,   171,     0,   512,     0,   513,   514,   515,   516,   517,
       0,   518,   519,   520,     0,   521,   522,   523,   524,   525,
     526,     0,   527,     0,   174,     0,   528,   529,   530,     0,
     175,     0,   176,     0,   531,     0,     0,   532,     0,   533,
     534,   535,   536,   537,   538,   539,     0,   180,     0,   540,
       0,     0,   541,   542,   543,     0,     0,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,   187,
       0,   189,   556,   557,   190,     0,   558,   559,     0,   560,
       0,   193,   561,   194,   562,   563,   564,     0,   565,     0,
       0,   566,   567,   568,     0,     0,   195,     0,     0,     0,
     199,   569,   570,   571,   572,   573,   574,   575,     0,   576,
     200,   577,   201,   578,   579,   580,     0,   581,   582,   583,
     584,   585,   586,   587,   203,   588,   589,   590,   591,     0,
     592,   593,   594,   595,   596,   597,   598,   599,   600,   601,
       0,   602,   603,     0,   604,   605,   211,   606,   607,   608,
     609,   610,   611,   612,   613,     0,   614,   615,   616,   617,
     618,     0,   619,   216,   620,   621,     0,   622,   219,     0,
     623,   624,   625,   626,   627,   628,   629,   630,   631,   632,
     221,     0,   633,   634,     0,   635,   636,   637,   638,   639,
     640,     0,   223,   224,     0,     0,   642,   225,   643,   226,
       0,   644,   645,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,     0,     0,   655,   656,   657,   658,
     659,   660,   233,     0,   661,     0,   662,   663,   664,     0,
       0,   665,     0,     0,   666,   667,   668,   669,   670,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   671,   672,
     673,    86,    87,    88,   411,    90,    91,    92,   412,     0,
     413,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   414,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     415,   416,     0,     0,     0,   417,   418,     0,     0,     0,
       0,   419,     0,     0,     0,     0,     0,     0,     0,     0,
     420,     0,   421,     0,   422,   423,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   425,   426,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,     0,     0,
       0,     0,     0,     0,     0,   436,   437,     0,   438,   439,
       0,   440,   441,   442,   135,   136,     0,   138,   139,     0,
     443,   444,   445,   446,   447,     0,     0,   448,   449,   450,
     140,   451,     0,   452,   453,   454,   455,   144,     0,   456,
       0,   457,   458,   459,   460,     0,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   469,     0,     0,
       0,     0,     0,     0,     0,     0,   470,   471,   472,   473,
     474,   475,   154,   155,   476,  4137,   477,     0,   478,   479,
     480,   481,   482,     0,   483,   484,   485,     0,     0,   486,
     487,   488,   489,   490,     0,   491,   492,   493,     0,   494,
     495,     0,   496,   497,   498,   499,   163,   500,   501,   502,
     165,     0,   503,     0,   504,   167,   505,     0,   506,     0,
     507,     0,     0,     0,   508,   509,   510,     0,   511,   171,
       0,   512,     0,   513,   514,   515,   516,   517,     0,   518,
     519,   520,     0,   521,   522,   523,   524,   525,   526,     0,
     527,     0,   174,     0,   528,   529,   530,     0,   175,     0,
     176,     0,   531,     0,     0,   532,     0,   533,   534,   535,
     536,   537,   538,   539,     0,   180,     0,   540,     0,     0,
     541,   542,   543,     0,     0,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,   555,   187,     0,   189,
     556,   557,   190,     0,   558,   559,     0,   560,     0,   193,
     561,   194,   562,   563,   564,     0,   565,     0,     0,   566,
     567,   568,     0,     0,   195,     0,     0,     0,   199,   569,
     570,   571,   572,   573,   574,   575,     0,   576,   200,   577,
     201,   578,   579,   580,     0,   581,   582,   583,   584,   585,
     586,   587,   203,   588,   589,   590,   591,     0,   592,   593,
     594,   595,   596,   597,   598,   599,   600,   601,     0,   602,
     603,     0,   604,   605,   211,   606,   607,   608,   609,   610,
     611,   612,   613,     0,   614,   615,   616,   617,   618,     0,
     619,   216,   620,   621,     0,   622,   219,     0,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   221,     0,
     633,   634,     0,   635,   636,   637,   638,   639,   640,     0,
     223,   224,     0,     0,   642,   225,   643,   226,     0,   644,
     645,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,   654,     0,     0,   655,   656,   657,   658,   659,   660,
     233,     0,   661,     0,   662,   663,   664,     0,     0,   665,
       0,     0,   666,   667,   668,   669,   670,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   671,   672,   673,    86,
      87,    88,   411,    90,    91,    92,   412,     0,   413,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   414,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   415,   416,
       0,     0,     0,   417,   418,     0,     0,     0,     0,   419,
       0,     0,     0,     0,     0,     0,     0,     0,   420,     0,
     421,     0,   422,   423,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   425,   426,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,     0,     0,     0,     0,
       0,     0,     0,   436,   437,     0,   438,   439,     0,   440,
     441,   442,   135,   136,     0,   138,   139,     0,   443,   444,
     445,   446,   447,     0,     0,   448,   449,   450,   140,   451,
       0,   452,   453,   454,   455,   144,     0,   456,     0,   457,
     458,   459,   460,     0,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   469,     0,     0,     0,     0,
       0,     0,     0,     0,   470,   471,   472,   473,   474,   475,
     154,   155,   476,  4139,   477,     0,   478,   479,   480,   481,
     482,     0,   483,   484,   485,     0,     0,   486,   487,   488,
     489,   490,     0,   491,   492,   493,     0,   494,   495,     0,
     496,   497,   498,   499,   163,   500,   501,   502,   165,     0,
     503,     0,   504,   167,   505,     0,   506,     0,   507,     0,
       0,     0,   508,   509,   510,     0,   511,   171,     0,   512,
       0,   513,   514,   515,   516,   517,     0,   518,   519,   520,
       0,   521,   522,   523,   524,   525,   526,     0,   527,     0,
     174,     0,   528,   529,   530,     0,   175,     0,   176,     0,
     531,     0,     0,   532,     0,   533,   534,   535,   536,   537,
     538,   539,     0,   180,     0,   540,     0,     0,   541,   542,
     543,     0,     0,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,   555,   187,     0,   189,   556,   557,
     190,     0,   558,   559,     0,   560,     0,   193,   561,   194,
     562,   563,   564,     0,   565,     0,     0,   566,   567,   568,
       0,     0,   195,     0,     0,     0,   199,   569,   570,   571,
     572,   573,   574,   575,     0,   576,   200,   577,   201,   578,
     579,   580,     0,   581,   582,   583,   584,   585,   586,   587,
     203,   588,   589,   590,   591,     0,   592,   593,   594,   595,
     596,   597,   598,   599,   600,   601,     0,   602,   603,     0,
     604,   605,   211,   606,   607,   608,   609,   610,   611,   612,
     613,     0,   614,   615,   616,   617,   618,     0,   619,   216,
     620,   621,     0,   622,   219,     0,   623,   624,   625,   626,
     627,   628,   629,   630,   631,   632,   221,     0,   633,   634,
       0,   635,   636,   637,   638,   639,   640,     0,   223,   224,
       0,     0,   642,   225,   643,   226,     0,   644,   645,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
       0,     0,   655,   656,   657,   658,   659,   660,   233,     0,
     661,     0,   662,   663,   664,     0,     0,   665,     0,     0,
     666,   667,   668,   669,   670,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   671,   672,   673,    86,    87,    88,
     411,    90,    91,    92,   412,     0,   413,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   414,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   415,   416,     0,     0,
       0,   417,   418,     0,     0,     0,     0,   419,     0,     0,
       0,     0,     0,     0,     0,     0,   420,     0,   421,     0,
     422,   423,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   425,   426,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,     0,     0,     0,     0,     0,     0,
       0,   436,   437,     0,   438,   439,     0,   440,   441,   442,
     135,   136,     0,   138,   139,     0,   443,   444,   445,   446,
     447,     0,     0,   448,   449,   450,   140,   451,     0,   452,
     453,   454,   455,   144,     0,   456,     0,   457,   458,   459,
     460,     0,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,     0,   469,     0,     0,     0,     0,     0,     0,
       0,     0,   470,   471,   472,   473,   474,   475,   154,   155,
     476,  4141,   477,     0,   478,   479,   480,   481,   482,     0,
     483,   484,   485,     0,     0,   486,   487,   488,   489,   490,
       0,   491,   492,   493,     0,   494,   495,     0,   496,   497,
     498,   499,   163,   500,   501,   502,   165,     0,   503,     0,
     504,   167,   505,     0,   506,     0,   507,     0,     0,     0,
     508,   509,   510,     0,   511,   171,     0,   512,     0,   513,
     514,   515,   516,   517,     0,   518,   519,   520,     0,   521,
     522,   523,   524,   525,   526,     0,   527,     0,   174,     0,
     528,   529,   530,     0,   175,     0,   176,     0,   531,     0,
       0,   532,     0,   533,   534,   535,   536,   537,   538,   539,
       0,   180,     0,   540,     0,     0,   541,   542,   543,     0,
       0,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,   187,     0,   189,   556,   557,   190,     0,
     558,   559,     0,   560,     0,   193,   561,   194,   562,   563,
     564,     0,   565,     0,     0,   566,   567,   568,     0,     0,
     195,     0,     0,     0,   199,   569,   570,   571,   572,   573,
     574,   575,     0,   576,   200,   577,   201,   578,   579,   580,
       0,   581,   582,   583,   584,   585,   586,   587,   203,   588,
     589,   590,   591,     0,   592,   593,   594,   595,   596,   597,
     598,   599,   600,   601,     0,   602,   603,     0,   604,   605,
     211,   606,   607,   608,   609,   610,   611,   612,   613,     0,
     614,   615,   616,   617,   618,     0,   619,   216,   620,   621,
       0,   622,   219,     0,   623,   624,   625,   626,   627,   628,
     629,   630,   631,   632,   221,     0,   633,   634,     0,   635,
     636,   637,   638,   639,   640,     0,   223,   224,     0,     0,
     642,   225,   643,   226,     0,   644,   645,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,     0,     0,
     655,   656,   657,   658,   659,   660,   233,     0,   661,     0,
     662,   663,   664,     0,     0,   665,     0,     0,   666,   667,
     668,   669,   670,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   671,   672,   673,    86,    87,    88,   411,    90,
      91,    92,   412,     0,   413,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   414,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   415,   416,     0,     0,     0,   417,
     418,     0,     0,     0,     0,   419,     0,     0,     0,     0,
       0,     0,     0,     0,   420,     0,   421,     0,   422,   423,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     425,   426,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,     0,     0,     0,     0,     0,     0,     0,   436,
     437,     0,   438,   439,     0,   440,   441,   442,   135,   136,
       0,   138,   139,     0,   443,   444,   445,   446,   447,     0,
       0,   448,   449,   450,   140,   451,     0,   452,   453,   454,
     455,   144,     0,   456,     0,   457,   458,   459,   460,     0,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
       0,   469,     0,     0,     0,     0,     0,     0,     0,     0,
     470,   471,   472,   473,   474,   475,   154,   155,   476,     0,
     477,     0,   478,   479,   480,   481,   482,     0,   483,   484,
     485,     0,     0,   486,   487,   488,   489,   490,     0,   491,
     492,   493,     0,   494,   495,     0,   496,   497,   498,   499,
     163,   500,   501,   502,   165,     0,   503,     0,   504,   167,
     505,     0,   506,     0,   507,     0,     0,     0,   508,   509,
     510,     0,   511,   171,     0,   512,     0,   513,   514,   515,
     516,   517,     0,   518,   519,   520,     0,   521,   522,   523,
     524,   525,   526,     0,   527,     0,   174,     0,   528,   529,
     530,     0,   175,     0,   176,     0,   531,     0,     0,   532,
       0,   533,   534,   535,   536,   537,   538,   539,     0,   180,
       0,   540,     0,     0,   541,   542,   543,     0,     0,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   187,     0,   189,   556,   557,   190,     0,   558,   559,
       0,   560,     0,   193,   561,   194,   562,   563,   564,     0,
     565,     0,     0,   566,   567,   568,     0,     0,   195,     0,
       0,     0,   199,   569,   570,   571,   572,   573,   574,   575,
       0,   576,   200,   577,   201,   578,   579,   580,     0,   581,
     582,   583,   584,   585,   586,   587,   203,   588,   589,   590,
     591,     0,   592,   593,   594,   595,   596,   597,   598,   599,
     600,   601,     0,   602,   603,     0,   604,   605,   211,   606,
     607,   608,   609,   610,   611,   612,   613,     0,   614,   615,
     616,   617,   618,     0,   619,   216,   620,   621,     0,   622,
     219,     0,   623,   624,   625,   626,   627,   628,   629,   630,
     631,   632,   221,     0,   633,   634,     0,   635,   636,   637,
     638,   639,   640,     0,   223,   224,     0,     0,   642,   225,
     643,   226,     0,   644,   645,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,     0,  4510,   655,   656,
     657,   658,   659,   660,   233,     0,   661,     0,   662,   663,
     664,     0,     0,   665,     0,     0,   666,   667,   668,   669,
     670,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     671,   672,   673,    86,    87,    88,   411,    90,    91,    92,
     412,     0,   413,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   414,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   415,   416,     0,     0,     0,   417,   418,     0,
       0,     0,     0,   419,     0,     0,     0,     0,     0,     0,
       0,     0,   420,     0,   421,     0,   422,   423,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
       0,     0,     0,     0,     0,     0,     0,   436,   437,     0,
     438,   439,     0,   440,   441,   442,   135,   136,     0,   138,
     139,     0,   443,   444,   445,   446,   447,     0,     0,   448,
     449,   450,   140,   451,     0,   452,   453,   454,   455,   144,
       0,   456,     0,   457,   458,   459,   460,     0,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   469,
       0,     0,     0,     0,     0,     0,     0,     0,   470,   471,
     472,   473,   474,   475,   154,   155,   476,     0,   477,     0,
     478,   479,   480,   481,   482,     0,   483,   484,   485,     0,
       0,   486,   487,   488,   489,   490,     0,   491,   492,   493,
       0,   494,   495,     0,   496,   497,   498,   499,   163,   500,
     501,   502,   165,     0,   503,     0,   504,   167,   505,     0,
     506,     0,   507,     0,     0,     0,   508,   509,   510,     0,
     511,   171,     0,   512,     0,   513,   514,   515,   516,   517,
       0,   518,   519,   520,     0,   521,   522,   523,   524,   525,
     526,     0,   527,     0,   174,     0,   528,   529,   530,     0,
     175,     0,   176,     0,   531,     0,     0,   532,     0,   533,
     534,   535,   536,   537,   538,   539,     0,   180,     0,   540,
       0,     0,   541,   542,   543,     0,     0,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,   187,
       0,   189,   556,   557,   190,     0,   558,   559,     0,   560,
       0,   193,   561,   194,   562,   563,   564,     0,   565,     0,
       0,   566,   567,   568,     0,     0,   195,     0,     0,     0,
     199,   569,   570,   571,   572,   573,   574,   575,     0,   576,
     200,   577,   201,   578,   579,   580,     0,   581,   582,   583,
     584,   585,   586,   587,   203,   588,   589,   590,   591,     0,
     592,   593,   594,   595,   596,   597,   598,   599,   600,   601,
       0,   602,   603,     0,   604,   605,   211,   606,   607,   608,
     609,   610,   611,   612,   613,     0,   614,   615,   616,   617,
     618,     0,   619,   216,   620,   621,     0,   622,   219,     0,
     623,   624,   625,   626,   627,   628,   629,   630,   631,   632,
     221,     0,   633,   634,     0,   635,   636,   637,   638,   639,
     640,     0,   223,   224,     0,     0,   642,   225,   643,   226,
       0,   644,   645,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,     0,     0,   655,   656,   657,   658,
     659,   660,   233,     0,   661,     0,   662,   663,   664,     0,
       0,   665,     0,     0,   666,   667,   668,   669,   670,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   671,   672,
     673,    86,    87,    88,   411,    90,    91,    92,   412,     0,
     413,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   414,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     415,   416,     0,     0,     0,   417,   418,     0,     0,     0,
       0,   419,     0,     0,     0,     0,     0,     0,     0,     0,
     420,     0,   421,     0,   422,   423,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   425,   426,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,     0,     0,
       0,     0,     0,     0,     0,   436,   437,     0,   438,   439,
       0,   440,   441,   442,   135,   136,     0,   138,   139,     0,
     443,   444,   445,   446,   447,     0,     0,   448,   449,   450,
     140,   451,     0,   452,   453,   454,   455,   144,     0,   456,
       0,   457,   458,   459,   460,     0,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   469,     0,     0,
       0,     0,     0,     0,     0,     0,   470,   471,   472,   473,
     474,   475,   154,   155,   476,     0,   477,     0,   478,   479,
     480,   481,   482,     0,   483,   484,   485,     0,     0,   486,
     487,   488,   489,   490,     0,   491,   492,   493,     0,   494,
     495,     0,   496,   497,   498,   499,   163,   500,   501,   502,
     165,     0,   503,     0,   504,   167,   505,     0,   506,     0,
     507,     0,     0,     0,   508,   509,   510,     0,   511,   171,
       0,   512,     0,   513,   514,   515,   516,   517,     0,   518,
     519,   520,     0,   521,   522,   523,   524,   525,   526,     0,
     527,     0,   174,     0,   528,   529,   530,     0,   175,     0,
     176,     0,   531,     0,     0,   532,     0,   533,   534,   535,
     536,   537,   538,   539,     0,   180,     0,   540,     0,     0,
     541,   542,   543,     0,     0,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,   555,   187,     0,   189,
     556,   557,   190,     0,   558,   559,     0,   560,     0,   193,
     561,   194,   562,   563,   564,     0,   565,     0,     0,   566,
     567,   568,     0,     0,   195,     0,     0,     0,   199,   569,
     570,   571,   572,   573,   574,   575,     0,   576,   200,   577,
     201,   578,   579,   580,     0,   581,   582,   583,   584,   585,
     586,   587,   203,   588,   589,   590,   591,     0,   592,   593,
     594,   595,   596,   597,   598,   599,   600,   601,     0,   602,
     603,     0,   604,   605,   211,   606,   607,  1007,   609,   610,
     611,   612,   613,     0,   614,   615,   616,   617,   618,     0,
     619,   216,   620,   621,     0,   622,   219,     0,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   221,     0,
     633,   634,     0,   635,   636,   637,   638,   639,   640,     0,
     223,   224,     0,     0,   642,   225,   643,   226,     0,   644,
     645,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,   654,     0,     0,   655,   656,   657,   658,   659,   660,
     233,     0,   661,     0,   662,   663,   664,     0,     0,   665,
       0,     0,   666,   667,   668,   669,   670,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   671,   672,   673,    86,
      87,    88,   411,    90,    91,    92,   412,     0,   413,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   414,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   415,   416,
       0,     0,     0,   417,   418,     0,     0,     0,     0,   419,
       0,     0,     0,     0,     0,     0,     0,     0,   420,     0,
     421,     0,   422,   423,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   425,   426,   427,   428,   429,   430,
     431,   432,  1009,   433,   434,   435,     0,     0,     0,     0,
       0,     0,     0,   436,   437,     0,   438,   439,     0,   440,
     441,   442,   135,   136,     0,   138,   139,     0,   443,   444,
     445,   446,   447,     0,     0,   448,   449,  1010,   140,   451,
       0,   452,   453,   454,   455,   144,     0,   456,     0,   457,
     458,   459,   460,     0,   461,     0,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   469,     0,     0,     0,     0,
       0,     0,     0,     0,   470,   471,   472,   473,   474,   475,
     154,   155,   476,     0,   477,     0,   478,   479,   480,   481,
     482,     0,   483,   484,   485,     0,     0,   486,   487,   488,
     489,   490,     0,   491,   492,   493,     0,   494,   495,     0,
     496,   497,   498,   499,   163,   500,   501,   502,   165,     0,
     503,     0,   504,   167,   505,     0,   506,     0,   507,     0,
       0,     0,   508,   509,   510,     0,   511,   171,     0,   512,
       0,   513,   514,   515,   516,   517,     0,   518,   519,   520,
       0,   521,   522,   523,   524,   525,   526,     0,   527,     0,
     174,     0,   528,   529,   530,     0,   175,     0,   176,     0,
     531,     0,     0,   532,     0,   533,   534,   535,   536,   537,
     538,   539,     0,   180,     0,   540,     0,     0,   541,   542,
     543,     0,     0,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,   555,   187,     0,   189,   556,   557,
     190,     0,   558,   559,     0,   560,     0,   193,   561,   194,
     562,   563,   564,     0,   565,     0,     0,   566,   567,   568,
       0,     0,   195,     0,     0,     0,   199,   569,   570,   571,
     572,   573,   574,   575,     0,   576,   200,   577,   201,   578,
     579,   580,     0,   581,   582,   583,   584,   585,   586,   587,
     203,   588,   589,   590,   591,     0,   592,   593,   594,   595,
     596,   597,   598,   599,   600,   601,     0,   602,   603,     0,
     604,   605,   211,   606,   607,   608,   609,   610,   611,   612,
     613,     0,   614,   615,   616,   617,  1011,     0,   619,   216,
     620,   621,     0,   622,   219,     0,   623,   624,   625,   626,
     627,   628,   629,   630,   631,   632,   221,     0,   633,   634,
       0,   635,   636,   637,   638,   639,   640,     0,  1012,   224,
       0,     0,  1013,   225,   643,   226,     0,   644,   645,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
       0,     0,   655,   656,   657,   658,   659,  1014,   233,     0,
     661,     0,   662,   663,   664,     0,     0,   665,     0,     0,
     666,   667,   668,   669,   670,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   671,   672,   673,    86,    87,    88,
     411,    90,    91,    92,   412,     0,   413,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   414,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   415,   416,     0,     0,
       0,   417,   418,     0,     0,     0,     0,   419,     0,     0,
       0,     0,     0,     0,     0,     0,   420,     0,   421,     0,
     422,   423,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   425,   426,   427,   428,   429,   430,   431,   432,
    1049,   433,   434,   435,     0,     0,     0,     0,     0,     0,
       0,   436,   437,     0,   438,   439,     0,   440,   441,   442,
     135,   136,     0,   138,   139,     0,   443,   444,   445,   446,
     447,     0,     0,   448,   449,  1010,   140,   451,     0,   452,
     453,   454,   455,   144,     0,   456,     0,   457,   458,   459,
     460,     0,   461,     0,     0,   463,   464,   465,   466,   467,
     468,     0,     0,   469,     0,     0,     0,     0,     0,     0,
       0,     0,   470,   471,   472,   473,   474,   475,   154,   155,
     476,     0,   477,     0,   478,   479,   480,   481,   482,     0,
     483,   484,   485,     0,     0,   486,   487,   488,   489,   490,
       0,   491,   492,   493,     0,   494,   495,     0,   496,   497,
     498,   499,   163,   500,   501,   502,   165,     0,   503,     0,
     504,   167,   505,     0,   506,     0,   507,     0,     0,     0,
     508,   509,   510,     0,   511,   171,     0,   512,     0,   513,
     514,   515,   516,   517,     0,   518,   519,   520,     0,   521,
     522,   523,   524,   525,   526,     0,   527,     0,   174,     0,
     528,   529,   530,     0,   175,     0,   176,     0,   531,     0,
       0,   532,     0,   533,   534,   535,   536,   537,   538,   539,
       0,   180,     0,   540,     0,     0,   541,   542,   543,     0,
       0,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,   187,     0,   189,   556,   557,   190,     0,
     558,   559,     0,   560,     0,   193,   561,   194,   562,   563,
     564,     0,   565,     0,     0,   566,   567,   568,     0,     0,
     195,     0,     0,     0,   199,   569,   570,   571,   572,   573,
     574,   575,     0,   576,   200,   577,   201,   578,   579,   580,
       0,   581,   582,   583,   584,   585,   586,   587,   203,   588,
     589,   590,   591,     0,   592,   593,   594,   595,   596,   597,
     598,   599,   600,   601,     0,   602,   603,     0,   604,   605,
     211,   606,   607,   608,   609,   610,   611,   612,   613,     0,
     614,   615,   616,   617,  1050,     0,   619,   216,   620,   621,
       0,   622,   219,     0,   623,   624,   625,   626,   627,   628,
     629,   630,   631,   632,   221,     0,   633,   634,     0,   635,
     636,   637,   638,   639,   640,     0,  1051,   224,     0,     0,
    1052,   225,   643,   226,     0,   644,   645,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,     0,     0,
     655,   656,   657,   658,   659,  1014,   233,     0,   661,     0,
     662,   663,   664,     0,     0,   665,     0,     0,   666,   667,
     668,   669,   670,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   671,   672,   673,    86,    87,    88,   411,    90,
      91,    92,   412,     0,   413,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   414,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   415,   416,     0,     0,     0,   417,
     418,     0,     0,     0,     0,   419,     0,     0,     0,     0,
       0,     0,     0,     0,   420,     0,   421,     0,   422,   423,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     425,   426,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,     0,     0,     0,     0,     0,     0,     0,   436,
     437,     0,   438,   439,     0,   440,   441,   442,   135,   136,
       0,   138,   139,     0,   443,   444,   445,   446,   447,     0,
       0,   448,   449,   450,   140,   451,     0,   452,   453,   454,
     455,   144,     0,   456,     0,   457,   458,   459,   460,     0,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
       0,   469,     0,     0,     0,     0,     0,     0,     0,     0,
     470,   471,   472,   473,   474,   475,   154,   155,   476,     0,
     477,     0,   478,   479,   480,   481,   482,     0,   483,   484,
     485,     0,     0,   486,   487,   488,   489,   490,     0,   491,
     492,   493,     0,   494,   495,     0,   496,   497,   498,   499,
     163,   500,   501,   502,   165,     0,   503,     0,   504,   167,
     505,     0,   506,     0,   507,     0,     0,     0,   508,   509,
     510,     0,   511,   171,     0,   512,     0,   513,   514,   515,
     516,   517,     0,   518,   519,   520,     0,   521,   522,   523,
     524,   525,   526,     0,   527,     0,   174,     0,   528,   529,
     530,     0,   175,     0,   176,     0,   531,     0,     0,   532,
       0,   533,   534,   535,   536,   537,   538,   539,     0,   180,
       0,   540,     0,     0,   541,   542,   543,     0,     0,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   187,     0,   189,   556,   557,   190,     0,   558,   559,
       0,   560,     0,   193,   561,   194,   562,   563,   564,     0,
     565,     0,     0,   566,   567,   568,     0,     0,   195,     0,
       0,     0,   199,   569,   570,   571,   572,   573,   574,   575,
       0,   576,   200,   577,   201,   578,   579,   580,     0,   581,
     582,   583,   584,   585,   586,   587,   203,   588,   589,  1069,
     591,     0,   592,   593,   594,   595,   596,   597,   598,   599,
     600,   601,     0,   602,   603,     0,   604,   605,   211,   606,
     607,   608,   609,   610,   611,   612,   613,     0,   614,   615,
     616,   617,   618,     0,   619,   216,   620,   621,     0,   622,
     219,     0,   623,   624,   625,   626,   627,   628,   629,   630,
     631,   632,   221,     0,   633,   634,     0,   635,   636,   637,
     638,   639,   640,     0,   223,   224,     0,     0,   642,   225,
     643,   226,     0,   644,   645,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,     0,     0,   655,   656,
     657,   658,   659,   660,   233,     0,   661,     0,   662,   663,
     664,     0,     0,   665,     0,     0,   666,   667,   668,   669,
     670,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     671,   672,   673,    86,    87,    88,   411,    90,    91,    92,
     412,     0,   413,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   414,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   415,   416,     0,     0,     0,   417,   418,     0,
       0,     0,     0,   419,     0,     0,     0,     0,     0,     0,
       0,     0,   420,     0,   421,     0,   422,   423,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
       0,     0,     0,     0,     0,     0,     0,   436,   437,     0,
     438,   439,     0,   440,   441,   442,   135,   136,     0,   138,
     139,     0,   443,   444,   445,   446,   447,     0,     0,   448,
     449,   450,   140,   451,     0,   452,   453,   454,   455,   144,
       0,   456,     0,   457,   458,   459,   460,     0,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   469,
       0,     0,     0,     0,     0,     0,     0,     0,   470,   471,
     472,   473,   474,   475,   154,   155,   476,     0,   477,     0,
     478,   479,   480,   481,   482,     0,   483,   484,   485,     0,
       0,   486,   487,   488,   489,   490,     0,   491,   492,   493,
       0,   494,   495,     0,   496,   497,   498,   499,   163,   500,
     501,   502,   165,     0,   503,     0,   504,   167,   505,     0,
     506,     0,   507,     0,     0,     0,   508,   509,   510,     0,
     511,   171,     0,   512,     0,   513,   514,   515,   516,   517,
       0,   518,   519,   520,     0,   521,   522,   523,   524,   525,
     526,     0,   527,     0,   174,     0,   528,   529,   530,     0,
     175,     0,   176,     0,   531,     0,     0,   532,     0,   533,
     534,   535,   536,   537,   538,   539,     0,   180,     0,   540,
       0,     0,   541,   542,   543,     0,     0,   544,   545,  1201,
     547,   548,   549,   550,   551,   552,   553,   554,   555,   187,
       0,   189,   556,   557,   190,     0,   558,   559,     0,   560,
       0,   193,   561,   194,   562,   563,   564,     0,   565,     0,
       0,   566,   567,   568,     0,     0,   195,     0,     0,     0,
     199,   569,   570,   571,   572,   573,   574,   575,     0,   576,
     200,   577,   201,   578,   579,   580,     0,   581,   582,   583,
     584,   585,   586,   587,   203,   588,   589,   590,   591,     0,
     592,   593,   594,   595,   596,   597,   598,   599,   600,   601,
       0,   602,   603,     0,   604,   605,   211,   606,   607,   608,
     609,   610,   611,   612,   613,     0,   614,   615,   616,   617,
     618,     0,   619,   216,   620,   621,     0,   622,   219,     0,
     623,   624,   625,   626,   627,   628,   629,   630,   631,   632,
     221,     0,   633,   634,     0,   635,   636,   637,   638,   639,
     640,     0,   223,   224,     0,     0,   642,   225,   643,   226,
       0,   644,   645,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,     0,     0,   655,   656,   657,   658,
     659,   660,   233,     0,   661,     0,   662,   663,   664,     0,
       0,   665,     0,     0,   666,   667,   668,   669,   670,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   671,   672,
     673,    86,    87,    88,   411,    90,    91,    92,   412,     0,
     413,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   414,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     415,   416,     0,     0,     0,   417,   418,     0,     0,     0,
       0,   419,     0,     0,     0,     0,     0,     0,     0,     0,
     420,     0,   421,     0,   422,   423,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   425,   426,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,     0,     0,
       0,     0,     0,     0,     0,   436,   437,     0,   438,   439,
       0,   440,   441,   442,   135,   136,     0,   138,   139,     0,
     443,   444,   445,   446,   447,     0,     0,   448,   449,   450,
     140,   451,     0,   452,   453,   454,   455,   144,     0,   456,
       0,   457,   458,   459,   460,     0,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   469,     0,     0,
       0,     0,     0,     0,     0,     0,   470,   471,   472,   473,
     474,   475,   154,   155,   476,     0,   477,     0,   478,   479,
     480,   481,   482,     0,   483,   484,   485,     0,     0,   486,
     487,   488,   489,   490,     0,   491,   492,   493,     0,   494,
     495,     0,   496,   497,   498,   499,   163,   500,   501,   502,
     165,     0,   503,     0,   504,   167,   505,     0,   506,     0,
     507,     0,     0,     0,   508,   509,   510,     0,   511,   171,
       0,   512,     0,   513,   514,   515,   516,  1253,     0,   518,
     519,   520,     0,   521,   522,   523,   524,   525,   526,     0,
     527,     0,   174,     0,   528,   529,   530,     0,   175,     0,
     176,     0,   531,     0,     0,   532,     0,   533,   534,   535,
     536,   537,   538,   539,     0,   180,     0,   540,     0,     0,
     541,   542,   543,     0,     0,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,   555,   187,     0,   189,
     556,   557,   190,     0,   558,   559,     0,   560,     0,   193,
     561,   194,   562,   563,   564,     0,   565,     0,     0,   566,
     567,   568,     0,     0,   195,     0,     0,     0,   199,   569,
     570,   571,   572,   573,   574,   575,     0,   576,   200,   577,
     201,   578,   579,   580,     0,   581,   582,   583,   584,   585,
     586,   587,   203,   588,   589,   590,   591,     0,   592,   593,
     594,   595,   596,   597,   598,   599,   600,   601,     0,   602,
     603,     0,   604,   605,   211,   606,   607,   608,   609,   610,
     611,   612,   613,     0,   614,   615,   616,   617,   618,     0,
     619,   216,   620,   621,     0,   622,   219,     0,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   221,     0,
     633,   634,     0,   635,   636,   637,   638,   639,   640,     0,
     223,   224,     0,     0,   642,   225,   643,   226,     0,   644,
     645,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,   654,     0,     0,   655,   656,   657,   658,   659,   660,
     233,     0,   661,     0,   662,   663,   664,     0,     0,   665,
       0,     0,   666,   667,   668,   669,   670,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   671,   672,   673,    86,
      87,    88,   411,    90,    91,    92,   412,     0,   413,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   414,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   415,   416,
       0,     0,     0,   417,   418,     0,     0,     0,     0,   419,
       0,     0,     0,     0,     0,     0,     0,     0,   420,     0,
     421,     0,   422,   423,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   425,   426,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,     0,     0,     0,     0,
       0,     0,     0,   436,   437,     0,   438,   439,     0,   440,
     441,   442,   135,   136,     0,   138,   139,     0,   443,   444,
     445,   446,   447,     0,     0,   448,   449,   450,   140,   451,
       0,   452,   453,   454,   455,   144,     0,   456,     0,   457,
     458,   459,   460,     0,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   469,     0,     0,     0,     0,
       0,     0,     0,     0,   470,   471,   472,   473,   474,   475,
     154,   155,   476,     0,   477,     0,   478,   479,   480,   481,
     482,     0,   483,   484,   485,     0,     0,   486,   487,   488,
     489,   490,     0,   491,   492,   493,     0,   494,   495,     0,
     496,   497,   498,   499,   163,   500,   501,   502,   165,     0,
     503,     0,   504,   167,   505,     0,   506,     0,   507,     0,
       0,     0,   508,   509,   510,     0,   511,   171,     0,   512,
       0,   513,   514,   515,   516,   517,     0,   518,   519,   520,
       0,   521,   522,   523,   524,   525,   526,     0,   527,     0,
     174,     0,   528,   529,   530,     0,   175,     0,   176,     0,
     531,     0,     0,   532,     0,   533,   534,   535,   536,   537,
     538,   539,     0,   180,     0,   540,     0,     0,   541,   542,
     543,     0,     0,   544,   545,  1274,   547,   548,   549,   550,
     551,   552,   553,   554,   555,   187,     0,   189,   556,   557,
     190,     0,   558,   559,     0,   560,     0,   193,   561,   194,
     562,   563,   564,     0,   565,     0,     0,   566,   567,   568,
       0,     0,   195,     0,     0,     0,   199,   569,   570,   571,
     572,   573,   574,   575,     0,   576,   200,   577,   201,   578,
     579,   580,     0,   581,   582,   583,   584,   585,   586,   587,
     203,   588,   589,   590,   591,     0,   592,   593,   594,   595,
     596,   597,   598,   599,   600,   601,     0,   602,   603,     0,
     604,   605,   211,   606,   607,   608,   609,   610,   611,   612,
     613,     0,   614,   615,   616,   617,   618,     0,   619,   216,
     620,   621,     0,   622,   219,     0,   623,   624,   625,   626,
     627,   628,   629,   630,   631,   632,   221,     0,   633,   634,
       0,   635,   636,   637,   638,   639,   640,     0,   223,   224,
       0,     0,   642,   225,   643,   226,     0,   644,   645,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
       0,     0,   655,   656,   657,   658,   659,   660,   233,     0,
     661,     0,   662,   663,   664,     0,     0,   665,     0,     0,
     666,   667,   668,   669,   670,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   671,   672,   673,    86,    87,    88,
     411,    90,    91,    92,   412,     0,   413,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   414,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   415,   416,     0,     0,
       0,   417,   418,     0,     0,     0,     0,   419,     0,     0,
       0,     0,     0,     0,     0,     0,   420,     0,   421,     0,
     422,   423,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   425,   426,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,     0,     0,     0,     0,     0,     0,
       0,   436,   437,     0,   438,   439,     0,   440,   441,   442,
     135,   136,     0,   138,   139,     0,   443,   444,   445,   446,
     447,     0,     0,   448,   449,   450,   140,   451,     0,   452,
     453,   454,   455,   144,     0,   456,     0,   457,   458,   459,
     460,     0,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,     0,   469,     0,     0,     0,     0,     0,     0,
       0,     0,   470,   471,   472,   473,   474,   475,   154,   155,
     476,     0,   477,     0,   478,   479,   480,   481,   482,     0,
     483,   484,   485,     0,     0,   486,   487,   488,   489,   490,
       0,   491,   492,   493,     0,   494,   495,     0,   496,   497,
     498,   499,   163,   500,   501,   502,   165,     0,   503,     0,
     504,   167,   505,     0,   506,     0,   507,     0,     0,     0,
     508,   509,   510,     0,   511,   171,     0,   512,     0,   513,
     514,   515,   516,  1304,     0,   518,   519,   520,     0,   521,
     522,   523,   524,   525,   526,     0,   527,     0,   174,     0,
     528,   529,   530,     0,   175,     0,   176,     0,   531,     0,
       0,   532,     0,   533,   534,   535,   536,   537,   538,   539,
       0,   180,     0,   540,     0,     0,   541,   542,   543,     0,
       0,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,   187,     0,   189,   556,   557,   190,     0,
     558,   559,     0,   560,     0,   193,   561,   194,   562,   563,
     564,     0,   565,     0,     0,   566,   567,   568,     0,     0,
     195,     0,     0,     0,   199,   569,   570,   571,   572,   573,
     574,   575,     0,   576,   200,   577,   201,   578,   579,   580,
       0,   581,   582,   583,   584,   585,   586,   587,   203,   588,
     589,   590,   591,     0,   592,   593,   594,   595,   596,   597,
     598,   599,   600,   601,     0,   602,   603,     0,   604,   605,
     211,   606,   607,   608,   609,   610,   611,   612,   613,     0,
     614,   615,   616,   617,   618,     0,   619,   216,   620,   621,
       0,   622,   219,     0,   623,   624,   625,   626,   627,   628,
     629,   630,   631,   632,   221,     0,   633,   634,     0,   635,
     636,   637,   638,   639,   640,     0,   223,   224,     0,     0,
     642,   225,   643,   226,     0,   644,   645,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,     0,     0,
     655,   656,   657,   658,   659,   660,   233,     0,   661,     0,
     662,   663,   664,     0,     0,   665,     0,     0,   666,   667,
     668,   669,   670,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   671,   672,   673,    86,    87,    88,   411,    90,
      91,    92,   412,     0,   413,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   414,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   415,   416,     0,     0,     0,   417,
     418,     0,     0,     0,     0,   419,     0,     0,     0,     0,
       0,     0,     0,     0,   420,     0,   421,     0,   422,   423,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     425,   426,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,     0,     0,     0,     0,     0,     0,     0,   436,
     437,     0,   438,   439,     0,   440,   441,   442,   135,   136,
       0,   138,   139,     0,   443,   444,   445,   446,   447,     0,
       0,   448,   449,   450,   140,   451,     0,   452,   453,   454,
     455,   144,     0,   456,     0,   457,   458,   459,   460,     0,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
       0,   469,     0,     0,     0,     0,     0,     0,     0,     0,
     470,   471,   472,   473,   474,   475,   154,   155,   476,     0,
     477,     0,   478,   479,   480,   481,   482,     0,   483,   484,
     485,     0,     0,   486,   487,   488,   489,   490,     0,   491,
     492,   493,     0,   494,   495,     0,   496,   497,   498,   499,
     163,   500,   501,   502,   165,     0,   503,     0,   504,   167,
     505,     0,   506,     0,   507,     0,     0,     0,   508,   509,
     510,     0,   511,   171,     0,   512,     0,   513,   514,   515,
     516,  1310,     0,   518,   519,   520,     0,   521,   522,   523,
     524,   525,   526,     0,   527,     0,   174,     0,   528,   529,
     530,     0,   175,     0,   176,     0,   531,     0,     0,   532,
       0,   533,   534,   535,   536,   537,   538,   539,     0,   180,
       0,   540,     0,     0,   541,   542,   543,     0,     0,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   187,     0,   189,   556,   557,   190,     0,   558,   559,
       0,   560,     0,   193,   561,   194,   562,   563,   564,     0,
     565,     0,     0,   566,   567,   568,     0,     0,   195,     0,
       0,     0,   199,   569,   570,   571,   572,   573,   574,   575,
       0,   576,   200,   577,   201,   578,   579,   580,     0,   581,
     582,   583,   584,   585,   586,   587,   203,   588,   589,   590,
     591,     0,   592,   593,   594,   595,   596,   597,   598,   599,
     600,   601,     0,   602,   603,     0,   604,   605,   211,   606,
     607,   608,   609,   610,   611,   612,   613,     0,   614,   615,
     616,   617,   618,     0,   619,   216,   620,   621,     0,   622,
     219,     0,   623,   624,   625,   626,   627,   628,   629,   630,
     631,   632,   221,     0,   633,   634,     0,   635,   636,   637,
     638,   639,   640,     0,   223,   224,     0,     0,   642,   225,
     643,   226,     0,   644,   645,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,     0,     0,   655,   656,
     657,   658,   659,   660,   233,     0,   661,     0,   662,   663,
     664,     0,     0,   665,     0,     0,   666,   667,   668,   669,
     670,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     671,   672,   673,    86,    87,    88,   411,    90,    91,    92,
     412,     0,   413,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   414,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   415,   416,     0,     0,     0,   417,   418,     0,
       0,     0,     0,   419,     0,     0,     0,     0,     0,     0,
       0,     0,   420,     0,   421,     0,   422,   423,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
       0,     0,     0,     0,     0,     0,     0,   436,   437,     0,
     438,   439,     0,   440,   441,   442,   135,   136,     0,   138,
     139,     0,   443,   444,   445,   446,   447,     0,     0,   448,
     449,   450,   140,   451,     0,   452,   453,   454,   455,   144,
       0,   456,     0,   457,   458,   459,   460,     0,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   469,
       0,     0,     0,     0,     0,     0,     0,     0,   470,   471,
     472,   473,   474,   475,   154,   155,   476,     0,   477,     0,
     478,   479,   480,   481,   482,     0,   483,   484,   485,     0,
       0,   486,   487,   488,   489,   490,     0,   491,   492,   493,
       0,   494,   495,     0,   496,   497,   498,   499,   163,   500,
     501,   502,   165,     0,   503,     0,   504,   167,   505,     0,
     506,     0,   507,     0,     0,     0,   508,   509,   510,     0,
     511,   171,     0,   512,     0,   513,   514,   515,   516,  1318,
       0,   518,   519,   520,     0,   521,   522,   523,   524,   525,
     526,     0,   527,     0,   174,     0,   528,   529,   530,     0,
     175,     0,   176,     0,   531,     0,     0,   532,     0,   533,
     534,   535,   536,   537,   538,   539,     0,   180,     0,   540,
       0,     0,   541,   542,   543,     0,     0,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,   187,
       0,   189,   556,   557,   190,     0,   558,   559,     0,   560,
       0,   193,   561,   194,   562,   563,   564,     0,   565,     0,
       0,   566,   567,   568,     0,     0,   195,     0,     0,     0,
     199,   569,   570,   571,   572,   573,   574,   575,     0,   576,
     200,   577,   201,   578,   579,   580,     0,   581,   582,   583,
     584,   585,   586,   587,   203,   588,   589,   590,   591,     0,
     592,   593,   594,   595,   596,   597,   598,   599,   600,   601,
       0,   602,   603,     0,   604,   605,   211,   606,   607,   608,
     609,   610,   611,   612,   613,     0,   614,   615,   616,   617,
     618,     0,   619,   216,   620,   621,     0,   622,   219,     0,
     623,   624,   625,   626,   627,   628,   629,   630,   631,   632,
     221,     0,   633,   634,     0,   635,   636,   637,   638,   639,
     640,     0,   223,   224,     0,     0,   642,   225,   643,   226,
       0,   644,   645,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,     0,     0,   655,   656,   657,   658,
     659,   660,   233,     0,   661,     0,   662,   663,   664,     0,
       0,   665,     0,     0,   666,   667,   668,   669,   670,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   671,   672,
     673,    86,    87,    88,   411,    90,    91,    92,   412,     0,
     413,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   414,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     415,   416,     0,     0,     0,   417,   418,     0,     0,     0,
       0,   419,     0,     0,     0,     0,     0,     0,     0,     0,
     420,     0,   421,     0,   422,   423,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   425,   426,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,     0,     0,
       0,     0,     0,     0,     0,   436,   437,     0,   438,   439,
       0,   440,   441,   442,   135,   136,     0,   138,   139,     0,
     443,   444,   445,   446,   447,     0,     0,   448,   449,   450,
     140,   451,     0,   452,   453,   454,   455,   144,     0,   456,
       0,   457,   458,   459,   460,     0,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   469,     0,     0,
       0,     0,     0,     0,     0,     0,   470,   471,   472,   473,
     474,   475,   154,   155,   476,     0,   477,     0,   478,   479,
     480,   481,   482,     0,   483,   484,   485,     0,     0,   486,
     487,   488,   489,   490,     0,   491,   492,   493,     0,   494,
     495,     0,   496,   497,   498,   499,   163,   500,   501,   502,
     165,     0,   503,     0,   504,   167,   505,     0,   506,     0,
     507,     0,     0,     0,   508,   509,   510,     0,   511,   171,
       0,   512,     0,   513,   514,   515,   516,  1320,     0,   518,
     519,   520,     0,   521,   522,   523,   524,   525,   526,     0,
     527,     0,   174,     0,   528,   529,   530,     0,   175,     0,
     176,     0,   531,     0,     0,   532,     0,   533,   534,   535,
     536,   537,   538,   539,     0,   180,     0,   540,     0,     0,
     541,   542,   543,     0,     0,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,   555,   187,     0,   189,
     556,   557,   190,     0,   558,   559,     0,   560,     0,   193,
     561,   194,   562,   563,   564,     0,   565,     0,     0,   566,
     567,   568,     0,     0,   195,     0,     0,     0,   199,   569,
     570,   571,   572,   573,   574,   575,     0,   576,   200,   577,
     201,   578,   579,   580,     0,   581,   582,   583,   584,   585,
     586,   587,   203,   588,   589,   590,   591,     0,   592,   593,
     594,   595,   596,   597,   598,   599,   600,   601,     0,   602,
     603,     0,   604,   605,   211,   606,   607,   608,   609,   610,
     611,   612,   613,     0,   614,   615,   616,   617,   618,     0,
     619,   216,   620,   621,     0,   622,   219,     0,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   221,     0,
     633,   634,     0,   635,   636,   637,   638,   639,   640,     0,
     223,   224,     0,     0,   642,   225,   643,   226,     0,   644,
     645,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,   654,     0,     0,   655,   656,   657,   658,   659,   660,
     233,     0,   661,     0,   662,   663,   664,     0,     0,   665,
       0,     0,   666,   667,   668,   669,   670,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   671,   672,   673,    86,
      87,    88,   411,    90,    91,    92,   412,     0,   413,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   414,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   415,   416,
       0,     0,     0,   417,   418,     0,     0,     0,     0,   419,
       0,     0,     0,     0,     0,     0,     0,     0,   420,     0,
     421,     0,   422,   423,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   425,   426,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,     0,     0,     0,     0,
       0,     0,     0,   436,   437,     0,   438,   439,     0,   440,
     441,   442,   135,   136,     0,   138,   139,     0,   443,   444,
     445,   446,   447,     0,     0,   448,   449,   450,   140,   451,
       0,   452,   453,   454,   455,   144,     0,   456,     0,   457,
     458,   459,   460,     0,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   469,     0,     0,     0,     0,
       0,     0,     0,     0,   470,   471,   472,   473,   474,   475,
     154,   155,   476,     0,   477,     0,   478,   479,   480,   481,
     482,     0,   483,   484,   485,     0,     0,   486,   487,   488,
     489,   490,     0,   491,   492,   493,     0,   494,   495,     0,
     496,   497,   498,   499,   163,   500,   501,   502,   165,     0,
     503,     0,   504,   167,   505,     0,   506,     0,   507,     0,
       0,     0,   508,   509,   510,     0,   511,   171,     0,   512,
       0,   513,   514,   515,   516,  1322,     0,   518,   519,   520,
       0,   521,   522,   523,   524,   525,   526,     0,   527,     0,
     174,     0,   528,   529,   530,     0,   175,     0,   176,     0,
     531,     0,     0,   532,     0,   533,   534,   535,   536,   537,
     538,   539,     0,   180,     0,   540,     0,     0,   541,   542,
     543,     0,     0,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,   555,   187,     0,   189,   556,   557,
     190,     0,   558,   559,     0,   560,     0,   193,   561,   194,
     562,   563,   564,     0,   565,     0,     0,   566,   567,   568,
       0,     0,   195,     0,     0,     0,   199,   569,   570,   571,
     572,   573,   574,   575,     0,   576,   200,   577,   201,   578,
     579,   580,     0,   581,   582,   583,   584,   585,   586,   587,
     203,   588,   589,   590,   591,     0,   592,   593,   594,   595,
     596,   597,   598,   599,   600,   601,     0,   602,   603,     0,
     604,   605,   211,   606,   607,   608,   609,   610,   611,   612,
     613,     0,   614,   615,   616,   617,   618,     0,   619,   216,
     620,   621,     0,   622,   219,     0,   623,   624,   625,   626,
     627,   628,   629,   630,   631,   632,   221,     0,   633,   634,
       0,   635,   636,   637,   638,   639,   640,     0,   223,   224,
       0,     0,   642,   225,   643,   226,     0,   644,   645,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
       0,     0,   655,   656,   657,   658,   659,   660,   233,     0,
     661,     0,   662,   663,   664,     0,     0,   665,     0,     0,
     666,   667,   668,   669,   670,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   671,   672,   673,    86,    87,    88,
     411,    90,    91,    92,   412,     0,   413,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   414,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   415,   416,     0,     0,
       0,   417,   418,     0,     0,     0,     0,   419,     0,     0,
       0,     0,     0,     0,     0,     0,   420,     0,   421,     0,
     422,   423,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   425,   426,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,     0,     0,     0,     0,     0,     0,
       0,   436,   437,     0,   438,   439,     0,   440,   441,   442,
     135,   136,     0,   138,   139,     0,   443,   444,   445,   446,
     447,     0,     0,   448,   449,   450,   140,   451,     0,   452,
     453,   454,   455,   144,     0,   456,     0,   457,   458,   459,
     460,     0,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,     0,   469,     0,     0,     0,     0,     0,     0,
       0,     0,   470,   471,   472,   473,   474,   475,   154,   155,
     476,     0,   477,     0,   478,   479,   480,   481,   482,     0,
     483,   484,   485,     0,     0,   486,   487,   488,   489,   490,
       0,   491,   492,   493,     0,   494,   495,     0,   496,   497,
     498,   499,   163,   500,   501,   502,   165,     0,   503,     0,
     504,   167,   505,     0,   506,     0,   507,     0,     0,     0,
     508,   509,   510,     0,   511,   171,     0,   512,     0,   513,
     514,   515,   516,  1324,     0,   518,   519,   520,     0,   521,
     522,   523,   524,   525,   526,     0,   527,     0,   174,     0,
     528,   529,   530,     0,   175,     0,   176,     0,   531,     0,
       0,   532,     0,   533,   534,   535,   536,   537,   538,   539,
       0,   180,     0,   540,     0,     0,   541,   542,   543,     0,
       0,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,   187,     0,   189,   556,   557,   190,     0,
     558,   559,     0,   560,     0,   193,   561,   194,   562,   563,
     564,     0,   565,     0,     0,   566,   567,   568,     0,     0,
     195,     0,     0,     0,   199,   569,   570,   571,   572,   573,
     574,   575,     0,   576,   200,   577,   201,   578,   579,   580,
       0,   581,   582,   583,   584,   585,   586,   587,   203,   588,
     589,   590,   591,     0,   592,   593,   594,   595,   596,   597,
     598,   599,   600,   601,     0,   602,   603,     0,   604,   605,
     211,   606,   607,   608,   609,   610,   611,   612,   613,     0,
     614,   615,   616,   617,   618,     0,   619,   216,   620,   621,
       0,   622,   219,     0,   623,   624,   625,   626,   627,   628,
     629,   630,   631,   632,   221,     0,   633,   634,     0,   635,
     636,   637,   638,   639,   640,     0,   223,   224,     0,     0,
     642,   225,   643,   226,     0,   644,   645,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,     0,     0,
     655,   656,   657,   658,   659,   660,   233,     0,   661,     0,
     662,   663,   664,     0,     0,   665,     0,     0,   666,   667,
     668,   669,   670,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   671,   672,   673,    86,    87,    88,   411,    90,
      91,    92,   412,     0,   413,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   414,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   415,   416,     0,     0,     0,   417,
     418,     0,     0,     0,     0,   419,     0,     0,     0,     0,
       0,     0,     0,     0,   420,     0,   421,     0,   422,   423,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     425,   426,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,     0,     0,     0,     0,     0,     0,     0,   436,
     437,     0,   438,   439,     0,   440,   441,   442,   135,   136,
       0,   138,   139,     0,   443,   444,   445,   446,   447,     0,
       0,   448,   449,   450,   140,   451,     0,   452,   453,   454,
     455,   144,     0,   456,     0,   457,   458,   459,   460,     0,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
       0,   469,     0,     0,     0,     0,     0,     0,     0,     0,
     470,   471,   472,   473,   474,   475,   154,   155,   476,     0,
     477,     0,   478,   479,   480,   481,   482,     0,   483,   484,
     485,     0,     0,   486,   487,   488,   489,   490,     0,   491,
     492,   493,     0,   494,   495,     0,   496,   497,   498,   499,
     163,   500,   501,   502,   165,     0,   503,     0,   504,   167,
     505,     0,   506,     0,   507,     0,     0,     0,   508,   509,
     510,     0,   511,   171,     0,   512,     0,   513,   514,   515,
     516,  1327,     0,   518,   519,   520,     0,   521,   522,   523,
     524,   525,   526,     0,   527,     0,   174,     0,   528,   529,
     530,     0,   175,     0,   176,     0,   531,     0,     0,   532,
       0,   533,   534,   535,   536,   537,   538,   539,     0,   180,
       0,   540,     0,     0,   541,   542,   543,     0,     0,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   187,     0,   189,   556,   557,   190,     0,   558,   559,
       0,   560,     0,   193,   561,   194,   562,   563,   564,     0,
     565,     0,     0,   566,   567,   568,     0,     0,   195,     0,
       0,     0,   199,   569,   570,   571,   572,   573,   574,   575,
       0,   576,   200,   577,   201,   578,   579,   580,     0,   581,
     582,   583,   584,   585,   586,   587,   203,   588,   589,   590,
     591,     0,   592,   593,   594,   595,   596,   597,   598,   599,
     600,   601,     0,   602,   603,     0,   604,   605,   211,   606,
     607,   608,   609,   610,   611,   612,   613,     0,   614,   615,
     616,   617,   618,     0,   619,   216,   620,   621,     0,   622,
     219,     0,   623,   624,   625,   626,   627,   628,   629,   630,
     631,   632,   221,     0,   633,   634,     0,   635,   636,   637,
     638,   639,   640,     0,   223,   224,     0,     0,   642,   225,
     643,   226,     0,   644,   645,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,     0,     0,   655,   656,
     657,   658,   659,   660,   233,     0,   661,     0,   662,   663,
     664,     0,     0,   665,     0,     0,   666,   667,   668,   669,
     670,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     671,   672,   673,    86,    87,    88,   411,    90,    91,    92,
     412,     0,   413,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   414,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   415,   416,     0,     0,     0,   417,   418,     0,
       0,     0,     0,   419,     0,     0,     0,     0,     0,     0,
       0,     0,   420,     0,   421,     0,   422,   423,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
       0,     0,     0,     0,     0,     0,     0,   436,   437,     0,
     438,   439,     0,   440,   441,   442,   135,   136,     0,   138,
     139,     0,   443,   444,   445,   446,   447,     0,     0,   448,
     449,   450,   140,   451,     0,   452,   453,   454,   455,   144,
       0,   456,     0,   457,   458,   459,   460,     0,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   469,
       0,     0,     0,     0,     0,     0,     0,     0,   470,   471,
     472,   473,   474,   475,   154,   155,   476,     0,   477,     0,
     478,   479,   480,   481,   482,     0,   483,   484,   485,     0,
       0,   486,   487,   488,   489,   490,     0,   491,   492,   493,
       0,   494,   495,     0,   496,   497,   498,   499,   163,   500,
     501,   502,   165,     0,   503,     0,   504,   167,   505,     0,
     506,     0,   507,     0,     0,     0,   508,   509,   510,     0,
     511,   171,     0,   512,     0,   513,   514,   515,   516,  1329,
       0,   518,   519,   520,     0,   521,   522,   523,   524,   525,
     526,     0,   527,     0,   174,     0,   528,   529,   530,     0,
     175,     0,   176,     0,   531,     0,     0,   532,     0,   533,
     534,   535,   536,   537,   538,   539,     0,   180,     0,   540,
       0,     0,   541,   542,   543,     0,     0,   544,   545,  1330,
     547,   548,   549,   550,   551,   552,   553,   554,   555,   187,
       0,   189,   556,   557,   190,     0,   558,   559,     0,   560,
       0,   193,   561,   194,   562,   563,   564,     0,   565,     0,
       0,   566,   567,   568,     0,     0,   195,     0,     0,     0,
     199,   569,   570,   571,   572,   573,   574,   575,     0,   576,
     200,   577,   201,   578,   579,   580,     0,   581,   582,   583,
     584,   585,   586,   587,   203,   588,   589,   590,   591,     0,
     592,   593,   594,   595,   596,   597,   598,   599,   600,   601,
       0,   602,   603,     0,   604,   605,   211,   606,   607,   608,
     609,   610,   611,   612,   613,     0,   614,   615,   616,   617,
     618,     0,   619,   216,   620,   621,     0,   622,   219,     0,
     623,   624,   625,   626,   627,   628,   629,   630,   631,   632,
     221,     0,   633,   634,     0,   635,   636,   637,   638,   639,
     640,     0,   223,   224,     0,     0,   642,   225,   643,   226,
       0,   644,   645,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,     0,     0,   655,   656,   657,   658,
     659,   660,   233,     0,   661,     0,   662,   663,   664,     0,
       0,   665,     0,     0,   666,   667,   668,   669,   670,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   671,   672,
     673,    86,    87,    88,   411,    90,    91,    92,   412,     0,
     413,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   414,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     415,   416,     0,     0,     0,   417,   418,     0,     0,     0,
       0,   419,     0,     0,     0,     0,     0,     0,     0,     0,
     420,     0,   421,     0,   422,   423,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   425,   426,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,     0,     0,
       0,     0,     0,     0,     0,   436,   437,     0,   438,   439,
       0,   440,   441,   442,   135,   136,     0,   138,   139,     0,
     443,   444,   445,   446,   447,     0,     0,   448,   449,   450,
     140,   451,     0,   452,   453,   454,   455,   144,     0,   456,
       0,   457,   458,   459,   460,     0,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   469,     0,     0,
       0,     0,     0,     0,     0,     0,   470,   471,   472,   473,
     474,   475,   154,   155,   476,     0,   477,     0,   478,   479,
     480,   481,   482,     0,   483,   484,   485,     0,     0,   486,
     487,   488,   489,   490,     0,   491,   492,   493,     0,   494,
     495,     0,   496,   497,   498,   499,   163,   500,   501,   502,
     165,     0,   503,     0,   504,   167,   505,     0,   506,     0,
     507,     0,     0,     0,   508,   509,   510,     0,   511,   171,
       0,   512,     0,   513,   514,   515,   516,  1333,     0,   518,
     519,   520,     0,   521,   522,   523,   524,   525,   526,     0,
     527,     0,   174,     0,   528,   529,   530,     0,   175,     0,
     176,     0,   531,     0,     0,   532,     0,   533,   534,   535,
     536,   537,   538,   539,     0,   180,     0,   540,     0,     0,
     541,   542,   543,     0,     0,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,   555,   187,     0,   189,
     556,   557,   190,     0,   558,   559,     0,   560,     0,   193,
     561,   194,   562,   563,   564,     0,   565,     0,     0,   566,
     567,   568,     0,     0,   195,     0,     0,     0,   199,   569,
     570,   571,   572,   573,   574,   575,     0,   576,   200,   577,
     201,   578,   579,   580,     0,   581,   582,   583,   584,   585,
     586,   587,   203,   588,   589,   590,   591,     0,   592,   593,
     594,   595,   596,   597,   598,   599,   600,   601,     0,   602,
     603,     0,   604,   605,   211,   606,   607,   608,   609,   610,
     611,   612,   613,     0,   614,   615,   616,   617,   618,     0,
     619,   216,   620,   621,     0,   622,   219,     0,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   221,     0,
     633,   634,     0,   635,   636,   637,   638,   639,   640,     0,
     223,   224,     0,     0,   642,   225,   643,   226,     0,   644,
     645,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,   654,     0,     0,   655,   656,   657,   658,   659,   660,
     233,     0,   661,     0,   662,   663,   664,     0,     0,   665,
       0,     0,   666,   667,   668,   669,   670,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   671,   672,   673,    86,
      87,    88,   411,    90,    91,    92,   412,     0,   413,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   414,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   415,   416,
       0,     0,     0,   417,   418,     0,     0,     0,     0,   419,
       0,     0,     0,     0,     0,     0,     0,     0,   420,     0,
     421,     0,   422,   423,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   425,   426,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,     0,     0,     0,     0,
       0,     0,     0,   436,   437,     0,   438,   439,  1544,   440,
     441,   442,   135,   136,     0,   138,   139,     0,   443,   444,
     445,   446,   447,     0,     0,  1036,   449,  1010,   140,  1545,
       0,   452,   453,   454,   455,   144,     0,   456,     0,   457,
     458,   459,   460,     0,   461,     0,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   469,     0,     0,     0,     0,
       0,     0,     0,     0,   470,   471,   472,   473,   474,   475,
     154,   155,   476,     0,   477,     0,   478,   479,   480,   481,
     482,     0,   483,   484,   485,     0,     0,   486,   487,   488,
     489,   490,     0,   491,   492,   493,     0,   494,   495,     0,
     496,   497,   498,   499,   163,   500,   501,   502,   165,     0,
     503,     0,   504,   167,   505,     0,   506,     0,   507,     0,
       0,     0,   508,   509,   510,     0,   511,   171,     0,   512,
       0,   513,   514,   515,   516,   517,     0,   518,   519,   520,
       0,   521,   522,   523,   524,   525,   526,     0,   527,     0,
     174,     0,   528,   529,   530,     0,   175,     0,   176,     0,
     531,     0,     0,   532,     0,   533,   534,   535,   536,   537,
     538,   539,     0,   180,     0,   540,     0,     0,   541,   542,
     543,     0,     0,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,  1040,   187,     0,   189,   556,   557,
     190,     0,   558,   559,     0,   560,     0,   193,   561,   194,
     562,   563,   564,     0,   565,     0,     0,   566,   567,   568,
       0,     0,   195,     0,     0,     0,   199,   569,   570,   571,
     572,   573,   574,   575,     0,   576,   200,   577,   201,   578,
     579,   580,     0,   581,   582,   583,   584,   585,   586,   587,
     203,   588,   589,   590,   591,     0,   592,   593,   594,   595,
     596,   597,   598,   599,   600,   601,     0,   602,   603,     0,
    1041,   605,   211,   606,   607,   608,  1042,   610,   611,   612,
     613,     0,   614,   615,   616,   617,  1537,     0,   619,   216,
     620,   621,     0,   622,   219,     0,   623,   624,   625,   626,
     627,   628,   629,   630,   631,   632,   221,     0,   633,   634,
       0,   635,   636,   637,   638,   639,   640,     0,  1044,   224,
       0,     0,  1045,   225,   643,   226,     0,   644,   645,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
       0,     0,   655,   656,   657,   658,   659,  1014,   233,     0,
     661,     0,   662,   663,   664,     0,     0,   665,     0,     0,
     666,   667,   668,   669,  1046,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   671,   672,   673,  1668,    87,    88,
     411,    90,    91,    92,   412,     0,   413,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   414,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   415,   416,     0,     0,
       0,   417,   418,     0,     0,     0,     0,   419,     0,     0,
       0,     0,     0,     0,     0,     0,   420,     0,   421,     0,
     422,   423,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   425,   426,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,     0,     0,     0,     0,     0,     0,
       0,   436,   437,     0,   438,   439,     0,   440,   441,   442,
     135,   136,     0,   138,   139,     0,   443,   444,   445,   446,
     447,     0,     0,   448,   449,   450,   140,   451,     0,   452,
     453,   454,   455,   144,     0,   456,     0,   457,   458,   459,
     460,     0,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,     0,   469,     0,     0,     0,     0,     0,     0,
       0,     0,   470,   471,   472,   473,   474,   475,   154,   155,
     476,     0,   477,     0,   478,   479,   480,   481,   482,     0,
     483,   484,   485,     0,     0,   486,   487,   488,   489,   490,
       0,   491,   492,   493,     0,   494,   495,     0,   496,   497,
     498,   499,   163,   500,   501,   502,   165,     0,   503,     0,
     504,   167,   505,     0,   506,     0,   507,     0,     0,     0,
     508,   509,   510,     0,   511,   171,     0,   512,     0,   513,
     514,   515,   516,   517,     0,   518,   519,   520,     0,   521,
     522,   523,   524,   525,   526,     0,   527,     0,   174,     0,
     528,   529,   530,     0,   175,     0,   176,     0,   531,     0,
       0,   532,     0,   533,   534,   535,   536,   537,   538,   539,
       0,   180,     0,   540,     0,     0,   541,   542,   543,     0,
       0,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,   187,     0,   189,   556,   557,   190,     0,
     558,   559,     0,   560,     0,   193,   561,   194,   562,   563,
     564,     0,   565,     0,     0,   566,   567,   568,     0,     0,
     195,     0,     0,     0,   199,   569,   570,   571,   572,   573,
     574,   575,     0,   576,   200,   577,   201,   578,   579,   580,
       0,   581,   582,   583,   584,   585,   586,   587,   203,   588,
     589,   590,   591,     0,   592,   593,   594,   595,   596,   597,
     598,   599,   600,   601,     0,   602,   603,     0,   604,   605,
     211,   606,   607,   608,   609,   610,   611,   612,   613,     0,
     614,   615,   616,   617,   618,     0,   619,   216,   620,   621,
       0,   622,   219,     0,   623,   624,   625,   626,   627,   628,
     629,   630,   631,   632,   221,     0,   633,   634,     0,   635,
     636,   637,   638,   639,   640,     0,   223,   224,     0,     0,
     642,   225,   643,   226,     0,   644,   645,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,     0,     0,
     655,   656,   657,   658,   659,   660,   233,     0,   661,     0,
     662,   663,   664,     0,     0,   665,     0,     0,   666,   667,
     668,   669,   670,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   671,   672,   673,    86,    87,    88,   411,    90,
      91,    92,   412,     0,   413,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   414,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   415,   416,     0,     0,     0,   417,
     418,     0,     0,     0,     0,   419,     0,     0,     0,     0,
       0,     0,     0,     0,   420,     0,   421,     0,   422,   423,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     425,   426,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,     0,     0,     0,     0,     0,     0,     0,   436,
     437,     0,   438,   439,     0,   440,   441,   442,   135,   136,
       0,   138,   139,     0,   443,   444,   445,   446,   447,     0,
       0,   448,   449,   450,   140,   451,     0,   452,   453,   454,
     455,   144,     0,   456,     0,   457,   458,   459,   460,     0,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
       0,   469,     0,     0,     0,     0,     0,     0,     0,     0,
     470,   471,   472,   473,   474,   475,   154,   155,   476,     0,
     477,     0,   478,   479,   480,   481,   482,     0,   483,   484,
     485,     0,     0,   486,   487,   488,   489,   490,     0,   491,
     492,   493,     0,   494,   495,     0,   496,   497,   498,   499,
     163,   500,   501,   502,   165,     0,   503,     0,   504,   167,
     505,     0,   506,     0,   507,     0,     0,     0,   508,   509,
     510,     0,   511,   171,     0,   512,     0,   513,   514,   515,
     516,  1881,     0,   518,   519,   520,     0,   521,   522,   523,
     524,   525,   526,     0,   527,     0,   174,     0,   528,   529,
     530,     0,   175,     0,   176,     0,   531,     0,     0,   532,
       0,   533,   534,   535,   536,   537,   538,   539,     0,   180,
       0,   540,     0,     0,   541,   542,   543,     0,     0,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   187,     0,   189,   556,   557,   190,     0,   558,   559,
       0,   560,     0,   193,   561,   194,   562,   563,   564,     0,
     565,     0,     0,   566,   567,   568,     0,     0,   195,     0,
       0,     0,   199,   569,   570,   571,   572,   573,   574,   575,
       0,   576,   200,   577,   201,   578,   579,   580,     0,   581,
     582,   583,   584,   585,   586,   587,   203,   588,   589,   590,
     591,     0,   592,   593,   594,   595,   596,   597,   598,   599,
     600,   601,     0,   602,   603,     0,   604,   605,   211,   606,
     607,   608,   609,   610,   611,   612,   613,     0,   614,   615,
     616,   617,   618,     0,   619,   216,   620,   621,     0,   622,
     219,     0,   623,   624,   625,   626,   627,   628,   629,   630,
     631,   632,   221,     0,   633,   634,     0,   635,   636,   637,
     638,   639,   640,     0,   223,   224,     0,     0,   642,   225,
     643,   226,     0,   644,   645,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,     0,     0,   655,   656,
     657,   658,   659,   660,   233,     0,   661,     0,   662,   663,
     664,     0,     0,   665,     0,     0,   666,   667,   668,   669,
     670,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     671,   672,   673,    86,    87,    88,   411,    90,    91,    92,
     412,     0,   413,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   414,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   415,   416,     0,     0,     0,   417,   418,     0,
       0,     0,     0,   419,     0,     0,     0,     0,     0,     0,
       0,     0,   420,     0,   421,     0,   422,   423,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
       0,     0,     0,     0,     0,     0,     0,   436,   437,     0,
     438,   439,     0,   440,   441,   442,   135,   136,     0,   138,
     139,     0,   443,   444,   445,   446,   447,     0,     0,   448,
     449,   450,   140,   451,     0,   452,   453,   454,   455,   144,
       0,   456,     0,   457,   458,   459,   460,     0,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   469,
       0,     0,     0,     0,     0,     0,     0,     0,   470,   471,
     472,   473,   474,   475,   154,   155,   476,     0,   477,     0,
     478,   479,   480,   481,   482,     0,   483,   484,   485,     0,
       0,   486,   487,   488,   489,   490,     0,   491,   492,   493,
       0,   494,   495,     0,   496,   497,   498,   499,   163,   500,
     501,   502,   165,     0,   503,     0,   504,   167,   505,     0,
     506,     0,   507,     0,     0,     0,   508,   509,   510,     0,
     511,   171,     0,   512,     0,   513,   514,   515,   516,  1908,
       0,   518,   519,   520,     0,   521,   522,   523,   524,   525,
     526,     0,   527,     0,   174,     0,   528,   529,   530,     0,
     175,     0,   176,     0,   531,     0,     0,   532,     0,   533,
     534,   535,   536,   537,   538,   539,     0,   180,     0,   540,
       0,     0,   541,   542,   543,     0,     0,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,   187,
       0,   189,   556,   557,   190,     0,   558,   559,     0,   560,
       0,   193,   561,   194,   562,   563,   564,     0,   565,     0,
       0,   566,   567,   568,     0,     0,   195,     0,     0,     0,
     199,   569,   570,   571,   572,   573,   574,   575,     0,   576,
     200,   577,   201,   578,   579,   580,     0,   581,   582,   583,
     584,   585,   586,   587,   203,   588,   589,   590,   591,     0,
     592,   593,   594,   595,   596,   597,   598,   599,   600,   601,
       0,   602,   603,     0,   604,   605,   211,   606,   607,   608,
     609,   610,   611,   612,   613,     0,   614,   615,   616,   617,
     618,     0,   619,   216,   620,   621,     0,   622,   219,     0,
     623,   624,   625,   626,   627,   628,   629,   630,   631,   632,
     221,     0,   633,   634,     0,   635,   636,   637,   638,   639,
     640,     0,   223,   224,     0,     0,   642,   225,   643,   226,
       0,   644,   645,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,     0,     0,   655,   656,   657,   658,
     659,   660,   233,     0,   661,     0,   662,   663,   664,     0,
       0,   665,     0,     0,   666,   667,   668,   669,   670,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   671,   672,
     673,    86,    87,    88,   411,    90,    91,    92,   412,     0,
     413,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   414,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     415,   416,     0,     0,     0,   417,   418,     0,     0,     0,
       0,   419,     0,     0,     0,     0,     0,     0,     0,     0,
     420,     0,   421,     0,   422,   423,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   425,   426,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,     0,     0,
       0,     0,     0,     0,     0,   436,   437,     0,   438,   439,
       0,   440,   441,   442,   135,   136,     0,   138,   139,     0,
     443,   444,   445,   446,   447,     0,     0,   448,   449,   450,
     140,   451,     0,   452,   453,   454,   455,   144,     0,   456,
       0,   457,   458,   459,   460,     0,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   469,     0,     0,
       0,     0,     0,     0,     0,     0,   470,   471,   472,   473,
     474,   475,   154,   155,   476,     0,   477,     0,   478,   479,
     480,   481,   482,     0,   483,   484,   485,     0,     0,   486,
     487,   488,   489,   490,     0,   491,   492,   493,     0,   494,
     495,     0,   496,   497,   498,   499,   163,   500,   501,   502,
     165,     0,   503,     0,   504,   167,   505,     0,   506,     0,
     507,     0,     0,     0,   508,   509,   510,     0,   511,   171,
       0,   512,     0,   513,   514,   515,   516,  1942,     0,   518,
     519,   520,     0,   521,   522,   523,   524,   525,   526,     0,
     527,     0,   174,     0,   528,   529,   530,     0,   175,     0,
     176,     0,   531,     0,     0,   532,     0,   533,   534,   535,
     536,   537,   538,   539,     0,   180,     0,   540,     0,     0,
     541,   542,   543,     0,     0,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,   555,   187,     0,   189,
     556,   557,   190,     0,   558,   559,     0,   560,     0,   193,
     561,   194,   562,   563,   564,     0,   565,     0,     0,   566,
     567,   568,     0,     0,   195,     0,     0,     0,   199,   569,
     570,   571,   572,   573,   574,   575,     0,   576,   200,   577,
     201,   578,   579,   580,     0,   581,   582,   583,   584,   585,
     586,   587,   203,   588,   589,   590,   591,     0,   592,   593,
     594,   595,   596,   597,   598,   599,   600,   601,     0,   602,
     603,     0,   604,   605,   211,   606,   607,   608,   609,   610,
     611,   612,   613,     0,   614,   615,   616,   617,   618,     0,
     619,   216,   620,   621,     0,   622,   219,     0,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   221,     0,
     633,   634,     0,   635,   636,   637,   638,   639,   640,     0,
     223,   224,     0,     0,   642,   225,   643,   226,     0,   644,
     645,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,   654,     0,     0,   655,   656,   657,   658,   659,   660,
     233,     0,   661,     0,   662,   663,   664,     0,     0,   665,
       0,     0,   666,   667,   668,   669,   670,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   671,   672,   673,    86,
      87,    88,   411,    90,    91,    92,   412,     0,   413,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   414,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   415,   416,
       0,     0,     0,   417,   418,     0,     0,     0,     0,   419,
       0,     0,     0,     0,     0,     0,     0,     0,   420,     0,
     421,     0,   422,   423,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   425,   426,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,     0,     0,     0,     0,
       0,     0,     0,   436,   437,     0,   438,   439,     0,   440,
     441,   442,   135,   136,     0,   138,   139,     0,   443,   444,
     445,   446,   447,     0,     0,   448,   449,   450,   140,   451,
       0,   452,   453,   454,   455,   144,     0,   456,     0,   457,
     458,   459,   460,     0,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   469,     0,     0,     0,     0,
       0,     0,     0,     0,   470,   471,   472,   473,   474,   475,
     154,   155,   476,     0,   477,     0,   478,   479,   480,   481,
     482,     0,   483,   484,   485,     0,     0,   486,   487,   488,
     489,   490,     0,   491,   492,   493,     0,   494,   495,     0,
     496,   497,   498,   499,   163,   500,   501,   502,   165,     0,
     503,     0,   504,   167,   505,     0,   506,     0,   507,     0,
       0,     0,   508,   509,   510,     0,   511,   171,     0,   512,
       0,   513,   514,   515,   516,  1944,     0,   518,   519,   520,
       0,   521,   522,   523,   524,   525,   526,     0,   527,     0,
     174,     0,   528,   529,   530,     0,   175,     0,   176,     0,
     531,     0,     0,   532,     0,   533,   534,   535,   536,   537,
     538,   539,     0,   180,     0,   540,     0,     0,   541,   542,
     543,     0,     0,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,   555,   187,     0,   189,   556,   557,
     190,     0,   558,   559,     0,   560,     0,   193,   561,   194,
     562,   563,   564,     0,   565,     0,     0,   566,   567,   568,
       0,     0,   195,     0,     0,     0,   199,   569,   570,   571,
     572,   573,   574,   575,     0,   576,   200,   577,   201,   578,
     579,   580,     0,   581,   582,   583,   584,   585,   586,   587,
     203,   588,   589,   590,   591,     0,   592,   593,   594,   595,
     596,   597,   598,   599,   600,   601,     0,   602,   603,     0,
     604,   605,   211,   606,   607,   608,   609,   610,   611,   612,
     613,     0,   614,   615,   616,   617,   618,     0,   619,   216,
     620,   621,     0,   622,   219,     0,   623,   624,   625,   626,
     627,   628,   629,   630,   631,   632,   221,     0,   633,   634,
       0,   635,   636,   637,   638,   639,   640,     0,   223,   224,
       0,     0,   642,   225,   643,   226,     0,   644,   645,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
       0,     0,   655,   656,   657,   658,   659,   660,   233,     0,
     661,     0,   662,   663,   664,     0,     0,   665,     0,     0,
     666,   667,   668,   669,   670,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   671,   672,   673,    86,    87,    88,
     411,    90,    91,    92,   412,     0,   413,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   414,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   415,   416,     0,     0,
       0,   417,   418,     0,     0,     0,     0,   419,     0,     0,
       0,     0,     0,     0,     0,     0,   420,     0,   421,     0,
     422,   423,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   425,   426,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,     0,     0,     0,     0,     0,     0,
       0,   436,   437,     0,   438,   439,     0,   440,   441,   442,
     135,   136,     0,   138,   139,     0,   443,   444,   445,   446,
     447,     0,     0,   448,   449,   450,   140,   451,     0,   452,
     453,   454,   455,   144,     0,   456,     0,   457,   458,   459,
     460,     0,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,     0,   469,     0,     0,     0,     0,     0,     0,
       0,     0,   470,   471,   472,   473,   474,   475,   154,   155,
     476,     0,   477,     0,   478,   479,   480,   481,   482,     0,
     483,   484,   485,     0,     0,   486,   487,   488,   489,   490,
       0,   491,   492,   493,     0,   494,   495,     0,   496,   497,
     498,   499,   163,   500,   501,   502,   165,     0,   503,     0,
     504,   167,   505,     0,   506,     0,   507,     0,     0,     0,
     508,   509,   510,     0,   511,   171,     0,   512,     0,   513,
     514,   515,   516,   517,     0,   518,   519,   520,     0,   521,
     522,   523,   524,   525,   526,     0,   527,     0,   174,     0,
     528,   529,   530,     0,   175,     0,   176,     0,   531,     0,
       0,   532,     0,   533,   534,   535,   536,   537,   538,   539,
       0,   180,     0,   540,     0,     0,   541,   542,   543,     0,
       0,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,   187,     0,   189,   556,   557,   190,     0,
     558,   559,     0,   560,     0,   193,   561,   194,   562,   563,
     564,     0,   565,     0,     0,   566,   567,   568,     0,     0,
     195,     0,     0,     0,   199,   569,   570,   571,   572,   573,
     574,   575,     0,   576,   200,   577,   201,   578,   579,   580,
       0,   581,   582,   583,   584,   585,   586,   587,   203,   588,
     589,   590,   591,     0,   592,   593,   594,   595,   596,   597,
     598,   599,   600,   601,     0,   602,   603,     0,   604,   605,
     211,   606,   607,  2054,   609,   610,   611,   612,   613,     0,
     614,   615,   616,   617,   618,     0,   619,   216,   620,   621,
       0,   622,   219,     0,   623,   624,   625,   626,   627,   628,
     629,   630,   631,   632,   221,     0,   633,   634,     0,   635,
     636,   637,   638,   639,   640,     0,   223,   224,     0,     0,
     642,   225,   643,   226,     0,   644,   645,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,     0,     0,
     655,   656,   657,   658,   659,   660,   233,     0,   661,     0,
     662,   663,   664,     0,     0,   665,     0,     0,   666,   667,
     668,   669,   670,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   671,   672,   673,    86,    87,    88,   411,    90,
      91,    92,   412,     0,   413,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   414,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   415,   416,     0,     0,     0,   417,
     418,     0,     0,     0,     0,   419,     0,     0,     0,     0,
       0,     0,     0,     0,   420,     0,   421,     0,   422,   423,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     425,   426,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,     0,     0,     0,     0,     0,  2256,     0,   436,
     437,     0,   438,   439,     0,   440,   441,   442,   135,   136,
       0,   138,   139,     0,   443,   444,   445,   446,   447,     0,
       0,   448,   449,   450,   140,   451,     0,   452,   453,   454,
     455,   144,     0,   456,     0,   457,   458,   459,   460,     0,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
       0,   469,     0,     0,     0,     0,     0,     0,     0,     0,
     470,   471,   472,   473,   474,   475,   154,   155,   476,     0,
     477,     0,   478,   479,   480,   481,   482,     0,   483,   484,
     485,     0,     0,   486,   487,   488,   489,   490,     0,   491,
     492,   493,     0,   494,   495,     0,   496,   497,   498,   499,
     163,   500,   501,   502,   165,     0,   503,     0,   504,   167,
     505,     0,   506,     0,   507,     0,     0,     0,   508,   509,
     510,     0,   511,   171,     0,   512,     0,   513,   514,   515,
     516,   517,     0,   518,   519,   520,     0,   521,   522,   523,
     524,   525,   526,     0,   527,     0,   174,     0,   528,   529,
     530,     0,   175,     0,   176,     0,   531,     0,     0,   532,
       0,   533,   534,   535,   536,   537,   538,   539,     0,   180,
       0,   540,     0,     0,   541,   542,   543,     0,     0,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   187,     0,   189,   556,   557,   190,     0,   558,   559,
       0,   560,     0,   193,   561,   194,   562,   563,   564,     0,
     565,     0,     0,   566,   567,   568,     0,     0,   195,     0,
       0,     0,   199,   569,   570,   571,   572,   573,   574,   575,
       0,   576,   200,   577,   201,   578,   579,   580,     0,   581,
     582,   583,   584,   585,   586,   587,   203,   588,   589,   590,
     591,     0,   592,   593,   594,   595,   596,   597,   598,   599,
     600,   601,     0,   602,   603,     0,   604,   605,   211,   606,
     607,   608,   609,   610,   611,   612,   613,     0,   614,   615,
     616,   617,   618,     0,     0,   216,   620,   621,     0,   622,
     219,     0,   623,   624,   625,   626,   627,   628,   629,   630,
     631,   632,   221,     0,   633,   634,     0,   635,   636,   637,
     638,   639,   640,     0,   223,   224,     0,     0,   642,   225,
     643,   226,     0,   644,   645,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,     0,     0,   655,   656,
     657,   658,   659,   660,   233,     0,   661,     0,   662,   663,
     664,     0,     0,   665,     0,     0,   666,   667,   668,   669,
     670,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     671,   672,   673,    86,    87,    88,   411,    90,    91,    92,
     412,     0,   413,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   414,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   415,   416,     0,     0,     0,   417,   418,     0,
       0,     0,     0,   419,     0,     0,     0,     0,     0,     0,
       0,     0,   420,     0,   421,     0,   422,   423,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
       0,     0,     0,     0,     0,     0,     0,   436,   437,     0,
     438,   439,     0,   440,   441,   442,   135,   136,     0,   138,
     139,     0,   443,   444,   445,   446,   447,     0,     0,   448,
     449,   450,   140,   451,     0,   452,   453,   454,   455,   144,
       0,   456,     0,   457,   458,   459,   460,     0,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   469,
       0,     0,     0,     0,     0,     0,     0,     0,   470,   471,
     472,   473,   474,   475,   154,   155,   476,     0,   477,     0,
     478,   479,   480,   481,   482,     0,   483,   484,   485,     0,
       0,   486,   487,   488,   489,   490,     0,   491,   492,   493,
       0,   494,   495,     0,   496,   497,   498,   499,   163,   500,
     501,   502,   165,     0,   503,     0,   504,   167,   505,     0,
     506,     0,   507,     0,     0,     0,   508,   509,   510,     0,
     511,   171,     0,   512,     0,   513,   514,   515,   516,  2610,
       0,   518,   519,   520,     0,   521,   522,   523,   524,   525,
     526,     0,   527,     0,   174,     0,   528,   529,   530,     0,
     175,     0,   176,     0,   531,     0,     0,   532,     0,   533,
     534,   535,   536,   537,   538,   539,     0,   180,     0,   540,
       0,     0,   541,   542,   543,     0,     0,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,   187,
       0,   189,   556,   557,   190,     0,   558,   559,     0,   560,
       0,   193,   561,   194,   562,   563,   564,     0,   565,     0,
       0,   566,   567,   568,     0,     0,   195,     0,     0,     0,
     199,   569,   570,   571,   572,   573,   574,   575,     0,   576,
     200,   577,   201,   578,   579,   580,     0,   581,   582,   583,
     584,   585,   586,   587,   203,   588,   589,   590,   591,     0,
     592,   593,   594,   595,   596,   597,   598,   599,   600,   601,
       0,   602,   603,     0,   604,   605,   211,   606,   607,   608,
     609,   610,   611,   612,   613,     0,   614,   615,   616,   617,
     618,     0,   619,   216,   620,   621,     0,   622,   219,     0,
     623,   624,   625,   626,   627,   628,   629,   630,   631,   632,
     221,     0,   633,   634,     0,   635,   636,   637,   638,   639,
     640,     0,   223,   224,     0,     0,   642,   225,   643,   226,
       0,   644,   645,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,     0,     0,   655,   656,   657,   658,
     659,   660,   233,     0,   661,     0,   662,   663,   664,     0,
       0,   665,     0,     0,   666,   667,   668,   669,   670,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   671,   672,
     673,    86,    87,    88,   411,    90,    91,    92,   412,     0,
     413,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   414,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     415,   416,     0,     0,     0,   417,   418,     0,     0,     0,
       0,   419,     0,     0,     0,     0,     0,     0,     0,     0,
     420,     0,   421,     0,   422,   423,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   425,   426,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,     0,     0,
       0,     0,     0,     0,     0,   436,   437,     0,   438,   439,
       0,   440,   441,   442,   135,   136,     0,   138,   139,     0,
     443,   444,   445,   446,   447,     0,     0,   448,   449,   450,
     140,   451,     0,   452,   453,   454,   455,   144,     0,   456,
       0,   457,   458,   459,   460,     0,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   469,     0,     0,
       0,     0,     0,     0,     0,     0,   470,   471,   472,   473,
     474,   475,   154,   155,   476,     0,   477,     0,   478,   479,
     480,   481,   482,     0,   483,   484,   485,     0,     0,   486,
     487,   488,   489,   490,     0,   491,   492,   493,     0,   494,
     495,     0,   496,   497,   498,   499,   163,   500,   501,   502,
     165,     0,   503,     0,   504,   167,   505,     0,   506,     0,
     507,     0,     0,     0,   508,   509,   510,     0,   511,   171,
       0,   512,     0,   513,   514,   515,   516,  3037,     0,   518,
     519,   520,     0,   521,   522,   523,   524,   525,   526,     0,
     527,     0,   174,     0,   528,   529,   530,     0,   175,     0,
     176,     0,   531,     0,     0,   532,     0,   533,   534,   535,
     536,   537,   538,   539,     0,   180,     0,   540,     0,     0,
     541,   542,   543,     0,     0,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,   555,   187,     0,   189,
     556,   557,   190,     0,   558,   559,     0,   560,     0,   193,
     561,   194,   562,   563,   564,     0,   565,     0,     0,   566,
     567,   568,     0,     0,   195,     0,     0,     0,   199,   569,
     570,   571,   572,   573,   574,   575,     0,   576,   200,   577,
     201,   578,   579,   580,     0,   581,   582,   583,   584,   585,
     586,   587,   203,   588,   589,   590,   591,     0,   592,   593,
     594,   595,   596,   597,   598,   599,   600,   601,     0,   602,
     603,     0,   604,   605,   211,   606,   607,   608,   609,   610,
     611,   612,   613,     0,   614,   615,   616,   617,   618,     0,
     619,   216,   620,   621,     0,   622,   219,     0,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   221,     0,
     633,   634,     0,   635,   636,   637,   638,   639,   640,     0,
     223,   224,     0,     0,   642,   225,   643,   226,     0,   644,
     645,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,   654,     0,     0,   655,   656,   657,   658,   659,   660,
     233,     0,   661,     0,   662,   663,   664,     0,     0,   665,
       0,     0,   666,   667,   668,   669,   670,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   671,   672,   673,    86,
      87,    88,   411,    90,    91,    92,   412,     0,   413,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   414,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   415,   416,
       0,     0,     0,   417,   418,     0,     0,     0,     0,   419,
       0,     0,     0,     0,     0,     0,     0,     0,   420,     0,
     421,     0,   422,   423,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   425,   426,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,     0,     0,     0,     0,
       0,     0,     0,   436,   437,     0,   438,   439,     0,   440,
     441,   442,   135,   136,     0,   138,   139,     0,   443,   444,
     445,   446,   447,     0,     0,   448,   449,   450,   140,   451,
       0,   452,   453,   454,   455,   144,     0,   456,     0,   457,
     458,   459,   460,     0,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   469,     0,     0,     0,     0,
       0,     0,     0,     0,   470,   471,   472,   473,   474,   475,
     154,   155,   476,     0,   477,     0,   478,   479,   480,   481,
     482,     0,   483,   484,   485,     0,     0,   486,   487,   488,
     489,   490,     0,   491,   492,   493,     0,   494,   495,     0,
     496,   497,   498,   499,   163,   500,   501,   502,   165,     0,
     503,     0,   504,   167,   505,     0,   506,     0,   507,     0,
       0,     0,   508,   509,   510,     0,   511,   171,     0,   512,
       0,   513,   514,   515,   516,  3039,     0,   518,   519,   520,
       0,   521,   522,   523,   524,   525,   526,     0,   527,     0,
     174,     0,   528,   529,   530,     0,   175,     0,   176,     0,
     531,     0,     0,   532,     0,   533,   534,   535,   536,   537,
     538,   539,     0,   180,     0,   540,     0,     0,   541,   542,
     543,     0,     0,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,   555,   187,     0,   189,   556,   557,
     190,     0,   558,   559,     0,   560,     0,   193,   561,   194,
     562,   563,   564,     0,   565,     0,     0,   566,   567,   568,
       0,     0,   195,     0,     0,     0,   199,   569,   570,   571,
     572,   573,   574,   575,     0,   576,   200,   577,   201,   578,
     579,   580,     0,   581,   582,   583,   584,   585,   586,   587,
     203,   588,   589,   590,   591,     0,   592,   593,   594,   595,
     596,   597,   598,   599,   600,   601,     0,   602,   603,     0,
     604,   605,   211,   606,   607,   608,   609,   610,   611,   612,
     613,     0,   614,   615,   616,   617,   618,     0,   619,   216,
     620,   621,     0,   622,   219,     0,   623,   624,   625,   626,
     627,   628,   629,   630,   631,   632,   221,     0,   633,   634,
       0,   635,   636,   637,   638,   639,   640,     0,   223,   224,
       0,     0,   642,   225,   643,   226,     0,   644,   645,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
       0,     0,   655,   656,   657,   658,   659,   660,   233,     0,
     661,     0,   662,   663,   664,     0,     0,   665,     0,     0,
     666,   667,   668,   669,   670,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   671,   672,   673,    86,    87,    88,
     411,    90,    91,    92,   412,     0,   413,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   414,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   415,   416,     0,     0,
       0,   417,   418,     0,     0,     0,     0,   419,     0,     0,
       0,     0,     0,     0,     0,     0,   420,     0,   421,     0,
     422,   423,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   425,   426,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,     0,     0,     0,     0,     0,     0,
       0,   436,   437,     0,   438,   439,     0,   440,   441,   442,
     135,   136,     0,   138,   139,     0,   443,   444,   445,   446,
     447,     0,     0,   448,   449,   450,   140,   451,     0,   452,
     453,   454,   455,   144,     0,   456,     0,   457,   458,   459,
     460,     0,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,     0,   469,     0,     0,     0,     0,     0,     0,
       0,     0,   470,   471,   472,   473,   474,   475,   154,   155,
     476,     0,   477,     0,   478,   479,   480,   481,   482,     0,
     483,   484,   485,     0,     0,   486,   487,   488,   489,   490,
       0,   491,   492,   493,     0,   494,   495,     0,   496,   497,
     498,   499,   163,   500,   501,   502,   165,     0,   503,     0,
     504,   167,   505,     0,   506,     0,   507,     0,     0,     0,
     508,   509,   510,     0,   511,   171,     0,   512,     0,   513,
     514,   515,   516,  3122,     0,   518,   519,   520,     0,   521,
     522,   523,   524,   525,   526,     0,   527,     0,   174,     0,
     528,   529,   530,     0,   175,     0,   176,     0,   531,     0,
       0,   532,     0,   533,   534,   535,   536,   537,   538,   539,
       0,   180,     0,   540,     0,     0,   541,   542,   543,     0,
       0,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,   187,     0,   189,   556,   557,   190,     0,
     558,   559,     0,   560,     0,   193,   561,   194,   562,   563,
     564,     0,   565,     0,     0,   566,   567,   568,     0,     0,
     195,     0,     0,     0,   199,   569,   570,   571,   572,   573,
     574,   575,     0,   576,   200,   577,   201,   578,   579,   580,
       0,   581,   582,   583,   584,   585,   586,   587,   203,   588,
     589,   590,   591,     0,   592,   593,   594,   595,   596,   597,
     598,   599,   600,   601,     0,   602,   603,     0,   604,   605,
     211,   606,   607,   608,   609,   610,   611,   612,   613,     0,
     614,   615,   616,   617,   618,     0,   619,   216,   620,   621,
       0,   622,   219,     0,   623,   624,   625,   626,   627,   628,
     629,   630,   631,   632,   221,     0,   633,   634,     0,   635,
     636,   637,   638,   639,   640,     0,   223,   224,     0,     0,
     642,   225,   643,   226,     0,   644,   645,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,     0,     0,
     655,   656,   657,   658,   659,   660,   233,     0,   661,     0,
     662,   663,   664,     0,     0,   665,     0,     0,   666,   667,
     668,   669,   670,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   671,   672,   673,    86,    87,    88,   411,    90,
      91,    92,   412,     0,   413,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   414,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   415,   416,     0,     0,     0,   417,
     418,     0,     0,     0,     0,   419,     0,     0,     0,     0,
       0,     0,     0,     0,   420,     0,   421,     0,   422,   423,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     425,   426,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,     0,     0,     0,     0,     0,     0,     0,   436,
     437,     0,   438,   439,     0,   440,   441,   442,   135,   136,
       0,   138,   139,     0,   443,   444,   445,   446,   447,     0,
       0,  1036,   449,  1010,   140,   451,     0,   452,   453,   454,
     455,   144,     0,   456,     0,   457,   458,   459,   460,     0,
     461,     0,     0,   463,   464,   465,   466,   467,   468,     0,
       0,   469,     0,     0,     0,     0,     0,     0,     0,     0,
     470,   471,   472,   473,   474,   475,   154,   155,   476,     0,
     477,     0,   478,   479,   480,   481,   482,     0,   483,   484,
     485,     0,     0,   486,   487,   488,   489,   490,     0,   491,
     492,   493,     0,   494,   495,     0,   496,   497,   498,   499,
     163,   500,   501,   502,   165,     0,   503,     0,   504,   167,
     505,     0,   506,     0,   507,     0,     0,     0,   508,   509,
     510,     0,   511,   171,     0,   512,     0,   513,   514,   515,
     516,   517,     0,   518,   519,   520,     0,   521,   522,   523,
     524,   525,   526,     0,   527,     0,   174,     0,   528,   529,
     530,     0,   175,     0,   176,     0,   531,     0,     0,   532,
       0,   533,   534,   535,   536,   537,   538,   539,     0,   180,
       0,   540,     0,     0,   541,   542,   543,     0,     0,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
    1040,   187,     0,   189,   556,   557,   190,     0,   558,   559,
       0,   560,     0,   193,   561,   194,   562,   563,   564,     0,
     565,     0,     0,   566,   567,   568,     0,     0,   195,     0,
       0,     0,   199,   569,   570,   571,   572,   573,   574,   575,
       0,   576,   200,   577,   201,   578,   579,   580,     0,   581,
     582,   583,   584,   585,   586,   587,   203,   588,   589,   590,
     591,     0,   592,   593,   594,   595,   596,   597,   598,   599,
     600,   601,     0,   602,   603,     0,  1041,   605,   211,   606,
     607,   608,  1042,   610,   611,   612,   613,     0,   614,   615,
     616,   617,  1537,     0,   619,   216,   620,   621,     0,   622,
     219,     0,   623,   624,   625,   626,   627,   628,   629,   630,
     631,   632,   221,     0,   633,   634,     0,   635,   636,   637,
     638,   639,   640,     0,  1044,   224,     0,     0,  1045,   225,
     643,   226,     0,   644,   645,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,     0,     0,   655,   656,
     657,   658,   659,  1014,   233,     0,   661,     0,   662,   663,
     664,     0,     0,   665,     0,     0,   666,   667,   668,   669,
    1046,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     671,   672,   673,    86,    87,    88,   411,    90,    91,    92,
     412,     0,   413,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   414,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   415,   416,     0,     0,     0,   417,   418,     0,
       0,     0,     0,   419,     0,     0,     0,     0,     0,     0,
       0,     0,   420,     0,   421,     0,   422,   423,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
       0,     0,     0,     0,     0,     0,     0,   436,   437,     0,
     438,   439,     0,   440,   441,   442,   135,   136,     0,   138,
     139,     0,   443,   444,   445,   446,   447,     0,     0,  1036,
     449,  1010,   140,   451,     0,   452,   453,   454,   455,   144,
       0,   456,     0,   457,   458,   459,   460,     0,   461,     0,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   469,
       0,     0,     0,     0,     0,     0,     0,     0,   470,   471,
     472,   473,   474,   475,   154,   155,   476,     0,   477,     0,
     478,   479,   480,   481,   482,     0,   483,   484,   485,     0,
       0,   486,   487,   488,   489,   490,     0,   491,   492,   493,
       0,   494,   495,     0,   496,   497,   498,   499,   163,   500,
     501,   502,   165,     0,   503,     0,   504,   167,   505,     0,
     506,     0,   507,     0,     0,     0,   508,   509,   510,     0,
     511,   171,     0,   512,     0,   513,   514,   515,   516,   517,
       0,   518,   519,   520,     0,   521,   522,   523,   524,   525,
     526,     0,   527,     0,   174,     0,   528,   529,   530,     0,
     175,     0,   176,     0,   531,     0,     0,   532,     0,   533,
     534,   535,   536,   537,   538,   539,     0,   180,     0,   540,
       0,     0,   541,   542,   543,     0,     0,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,  1040,   187,
       0,   189,   556,   557,   190,     0,   558,   559,     0,   560,
       0,   193,   561,   194,   562,   563,   564,     0,   565,     0,
       0,   566,   567,   568,     0,     0,   195,     0,     0,     0,
     199,   569,   570,   571,   572,   573,   574,   575,     0,   576,
     200,   577,   201,   578,   579,   580,     0,   581,   582,   583,
     584,   585,   586,   587,   203,   588,   589,   590,   591,     0,
     592,   593,   594,   595,   596,   597,   598,   599,   600,   601,
       0,   602,   603,     0,  1041,   605,   211,   606,   607,   608,
    1042,   610,   611,   612,   613,     0,   614,   615,   616,   617,
    1537,     0,   619,   216,   620,   621,     0,   622,   219,     0,
     623,   624,   625,   626,   627,   628,   629,   630,   631,   632,
     221,     0,   633,   634,     0,   635,  2322,   637,   638,   639,
     640,     0,  1044,   224,     0,     0,  1045,   225,   643,   226,
       0,   644,   645,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,     0,     0,   655,   656,   657,   658,
     659,  1014,   233,     0,   661,     0,   662,   663,   664,     0,
       0,   665,     0,     0,   666,   667,   668,   669,  1046,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   671,   672,
     673,    86,    87,    88,   411,    90,    91,    92,   412,     0,
     413,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   414,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     415,   416,     0,     0,     0,   417,   418,     0,     0,     0,
       0,   419,     0,     0,     0,     0,     0,     0,     0,     0,
     420,     0,   421,     0,   422,   423,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   425,   426,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,     0,     0,
       0,     0,     0,     0,     0,   436,   437,     0,   438,   439,
       0,   440,   441,   442,   135,   136,     0,   138,   139,     0,
     443,   444,   445,   446,   447,     0,     0,  1036,   449,  1010,
     140,   451,     0,   452,   453,   454,   455,   144,     0,   456,
       0,   457,   458,   459,   460,     0,   461,     0,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   469,     0,     0,
       0,     0,     0,     0,     0,     0,   470,   471,   472,   473,
     474,   475,   154,   155,   476,     0,   477,     0,   478,   479,
     480,   481,   482,     0,   483,   484,   485,     0,     0,   486,
     487,   488,   489,   490,     0,   491,   492,   493,     0,   494,
     495,     0,   496,   497,   498,   499,   163,   500,   501,   502,
     165,     0,   503,     0,   504,   167,   505,     0,   506,     0,
     507,     0,     0,     0,   508,   509,   510,     0,   511,   171,
       0,   512,     0,   513,   514,   515,   516,   517,     0,   518,
     519,   520,     0,   521,   522,   523,   524,   525,   526,     0,
     527,     0,   174,     0,   528,   529,   530,     0,   175,     0,
     176,     0,   531,     0,     0,   532,     0,   533,   534,   535,
     536,   537,   538,   539,     0,   180,     0,   540,     0,     0,
     541,   542,   543,     0,     0,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,  1040,   187,     0,   189,
     556,   557,   190,     0,   558,   559,     0,   560,     0,   193,
     561,   194,   562,   563,   564,     0,   565,     0,     0,   566,
     567,   568,     0,     0,   195,     0,     0,     0,   199,   569,
     570,   571,   572,   573,   574,   575,     0,   576,   200,   577,
     201,   578,   579,   580,     0,   581,   582,   583,   584,   585,
     586,   587,   203,   588,   589,   590,   591,     0,   592,   593,
     594,   595,   596,   597,   598,   599,   600,   601,     0,   602,
     603,     0,  1041,   605,   211,   606,   607,   608,  2377,   610,
     611,   612,   613,     0,   614,   615,   616,   617,  1537,     0,
     619,   216,   620,   621,     0,   622,   219,     0,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   221,     0,
     633,   634,     0,   635,   636,   637,   638,   639,   640,     0,
    1044,   224,     0,     0,  1045,   225,   643,   226,     0,   644,
     645,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,   654,     0,     0,   655,   656,   657,   658,   659,  1014,
     233,     0,   661,     0,   662,   663,   664,     0,     0,   665,
       0,     0,   666,   667,   668,   669,  1046,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   671,   672,   673,    86,
      87,    88,   411,    90,    91,    92,   412,     0,   413,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   414,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   415,   416,
       0,     0,     0,   417,   418,     0,     0,     0,     0,   419,
       0,     0,     0,     0,     0,     0,     0,     0,   420,     0,
     421,     0,   422,   423,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   425,   426,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,     0,     0,     0,     0,
       0,     0,     0,   436,   437,     0,   438,   439,     0,   440,
     441,   442,   135,   136,     0,   138,   139,     0,   443,   444,
     445,   446,   447,     0,     0,   448,   449,   450,   140,   451,
       0,   452,   453,   454,   455,   144,     0,   456,     0,   457,
     458,   459,   460,     0,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   469,     0,     0,     0,     0,
       0,     0,     0,     0,   470,   471,   472,   473,   474,   475,
     154,   155,   476,     0,   477,     0,   478,   479,   480,   481,
     482,     0,   483,   484,   485,     0,     0,   486,   487,   488,
     489,   490,     0,   491,   492,   493,     0,   494,   495,     0,
     496,   497,   498,   499,   163,   500,   501,   502,   165,     0,
     503,     0,   504,   167,   505,     0,   506,     0,   507,     0,
       0,     0,   508,   509,   510,     0,   511,   171,     0,   512,
       0,   513,   514,   515,   516,   517,     0,   518,   519,   520,
       0,   521,   522,   523,   524,   525,   526,     0,   527,     0,
     174,     0,   528,   529,   530,     0,   175,     0,   176,     0,
     531,     0,     0,   532,     0,   533,   534,   535,   536,   537,
     538,   539,     0,   180,     0,   540,     0,     0,   541,   542,
     543,     0,     0,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,   555,   187,     0,   189,   556,   557,
     190,     0,   558,   559,     0,   560,     0,   193,   561,   194,
     562,   563,   564,     0,   565,     0,     0,   566,   567,   568,
       0,     0,   195,     0,     0,     0,   199,   569,   570,   571,
     572,     0,   574,   575,     0,   576,   200,   577,   201,   578,
     579,   580,     0,   581,   582,   583,   584,   585,     0,   587,
     203,   588,   589,   590,   591,     0,   592,   593,   594,   595,
     596,   597,   598,   599,   600,   601,     0,   602,   603,     0,
     604,   605,   211,     0,   607,   608,   609,   610,   611,   612,
     613,     0,   614,   615,   616,   617,   618,     0,   619,   216,
     620,   621,     0,   622,   219,     0,   623,   624,   625,   626,
     627,   628,   629,   630,   631,   632,   221,     0,   633,   634,
       0,   635,   636,   637,   638,   639,   640,     0,   223,   224,
       0,     0,   642,   225,   643,   226,     0,   644,   645,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
       0,     0,   655,   656,   657,   658,   659,   660,   233,     0,
     661,     0,   662,   663,   664,     0,     0,   665,     0,     0,
     666,   667,   668,   669,   670,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   671,   672,   673,    86,    87,    88,
       0,    90,    91,    92,     0,     0,     0,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,     0,
       0,     0,   107,   108,   109,   110,     0,   111,   112,   113,
     114,   115, -2286,   116,   117,   118,     0,     0,     0,     0,
       0,   121,   122,     0,     0,     0,     0,   123,     0,     0,
       0,     0,     0,     0,     0,     0,   124,     0,   125,     0,
     126,   127,    35,     0,   406,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   133,     0,     0,     0,
     135,   136,   137,   138,   139,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   140,     0,     0,     0,
       0,     0,     0,   144,     0,     0,     0,     0,     0,     0,
       0,   147,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   150,     0,     0,     0,     0,     0,   151,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   154,   155,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   161,     0,     0,     0,     0,
       0,     0,   163,     0,     0,     0,   165,     0,     0,     0,
       0,   167,     0,     0,     0,     0,     0,   168,     0,   169,
       0,     0,     0,     0,     0,   171,     0,     0,     0,     0,
       0,     0,     0,     0,   172,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   173,   174,     0,
       0,     0,     0,     0,   175,     0,   176,     0,     0,   177,
     178,     0,   179,     0,     0,     0,     0,     0,     0,     0,
       0,   180,   181,     0,   182,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   187,   188,   189,     0,     0,   190,     0,
       0,     0,   192,     0,     0,   193,     0,   194,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     195,   196,   197,   198,   199,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   200,     0,   201,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   203,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   209,     0,     0,
     211,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   216,     0,     0,
     218,     0,   219,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   221,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   223,   224,     0,     0,
       0,   225,     0,   226,     0,     0,     0,     0,     0,     0,
       0,   229,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,     0,     0,   234,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   236,   237,   238,   239,   240,   241,   242,
     243,   244,    86,    87,    88,     0,    90,    91,    92,     0,
       0,     0,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,     0,     0,     0,   107,   108,   109,
     110,     0,   111,   112,   113,   114,   115, -2287,   116,   117,
     118,     0,     0,     0,     0,     0,   121,   122,     0,     0,
       0,     0,   123,     0,     0,     0,     0,     0,     0,     0,
       0,   124,     0,   125,     0,   126,   127,    35,     0,  1119,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   133,     0,     0,  