.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "SET" "" "2005-01-04" "SQL - Language Statements" "SQL Commands"
.SH NAME
SET \- change a run-time parameter

.SH SYNOPSIS
.sp
.nf
SET [ SESSION | LOCAL ] \fIname\fR { TO | = } { \fIvalue\fR | '\fIvalue\fR' | DEFAULT }
SET [ SESSION | LOCAL ] TIME ZONE { \fItimezone\fR | LOCAL | DEFAULT }
.sp
.fi
.SH "DESCRIPTION"
.PP
The \fBSET\fR command changes run-time configuration
parameters. Many of the run-time parameters listed in
the documentation can be changed on-the-fly with
\fBSET\fR.
(But some require superuser privileges to change, and others cannot
be changed after server or session start.)
\fBSET\fR only affects the value used by the current
session.
.PP
If \fBSET\fR or \fBSET SESSION\fR is issued
within a transaction that is later aborted, the effects of the
\fBSET\fR command disappear when the transaction is rolled
back. (This behavior represents a change from
PostgreSQL versions prior to 7.3, where
the effects of \fBSET\fR would not roll back after a later
error.) Once the surrounding transaction is committed, the effects
will persist until the end of the session, unless overridden by another
\fBSET\fR.
.PP
The effects of \fBSET LOCAL\fR last only till the end of
the current transaction, whether committed or not. A special case is
\fBSET\fR followed by \fBSET LOCAL\fR within
a single transaction: the \fBSET LOCAL\fR value will be
seen until the end of the transaction, but afterwards (if the transaction
is committed) the \fBSET\fR value will take effect.
.SH "PARAMETERS"
.TP
\fBSESSION\fR
Specifies that the command takes effect for the current session.
(This is the default if neither SESSION nor
LOCAL appears.)
.TP
\fBLOCAL\fR
Specifies that the command takes effect for only the current
transaction. After \fBCOMMIT\fR or \fBROLLBACK\fR,
the session-level setting takes effect again. Note that
\fBSET LOCAL\fR will appear to have no effect if it is
executed outside a \fBBEGIN\fR block, since the
transaction will end immediately.
.TP
\fB\fIname\fB\fR
Name of a settable run-time parameter. Available parameters are
documented in the documentation and below.
.TP
\fB\fIvalue\fB\fR
New value of parameter. Values can be specified as string
constants, identifiers, numbers, or comma-separated lists of
these. DEFAULT can be used to specify
resetting the parameter to its default value.
.PP
Besides the configuration parameters documented in the documentation, there are a few that can only be
adjusted using the \fBSET\fR command or that have a
special syntax:
.TP
\fBNAMES\fR
SET NAMES \fIvalue\fR is an alias for
SET client_encoding TO \fIvalue\fR.
.TP
\fBSEED\fR
Sets the internal seed for the random number generator (the
function \fBrandom\fR). Allowed values are
floating-point numbers between 0 and 1, which are then
multiplied by 231-1.

The seed can also be set by invoking the function
\fBsetseed\fR:
.sp
.nf
SELECT setseed(\fIvalue\fR);
.sp
.fi
.TP
\fBTIME ZONE\fR
SET TIME ZONE \fIvalue\fR is an alias
for SET timezone TO \fIvalue\fR. The
syntax SET TIME ZONE allows special syntax
for the time zone specification. Here are examples of valid
values:
.RS
.TP
\fB\&'PST8PDT'\fR
The time zone for Berkeley, California.
.TP
\fB\&'Europe/Rome'\fR
The time zone for Italy.
.TP
\fB-7\fR
The time zone 7 hours west from UTC (equivalent
to PDT). Positive values are east from UTC.
.TP
\fBINTERVAL '-08:00' HOUR TO MINUTE\fR
The time zone 8 hours west from UTC (equivalent
to PST).
.TP
\fBLOCAL\fR
.TP
\fBDEFAULT\fR
Set the time zone to your local time zone (the one that
the server's operating system defaults to).
.RE
.PP
See the documentation for more information
about time zones. Also, the documentation
has a list of the recognized names for time zones.
.PP
.PP
.SH "NOTES"
.PP
The function \fBset_config\fR provides equivalent
functionality. See the documentation.
.SH "EXAMPLES"
.PP
Set the schema search path:
.sp
.nf
SET search_path TO my_schema, public;
.sp
.fi
.PP
Set the style of date to traditional
POSTGRES with ``day before month''
input convention:
.sp
.nf
SET datestyle TO postgres, dmy;
.sp
.fi
.PP
Set the time zone for Berkeley, California:
.sp
.nf
SET TIME ZONE 'PST8PDT';
.sp
.fi
.PP
Set the time zone for Italy:
.sp
.nf
SET TIME ZONE 'Europe/Rome';
.sp
.fi
.SH "COMPATIBILITY"
.PP
SET TIME ZONE extends syntax defined in the SQL
standard. The standard allows only numeric time zone offsets while
PostgreSQL allows more flexible
time-zone specifications. All other SET
features are PostgreSQL extensions.
.SH "SEE ALSO"
RESET [\fBreset\fR(l)], SHOW [\fBshow\fR(l)]
