#ifndef _TMSTCNVT_H_
#define _TMSTCNVT_H_

// The following C++ code is translated from the Lisp code
// in ``Calendrical Calculations'' by Nachum Dershowitz and
// Edward M. Reingold, Software---Practice & Experience,
// vol. 20, no. 9 (September, 1990), pp. 899--928.
// This code is in the public domain, but any use of it
// should publically acknowledge its source.

// This code is modified for the needs of Standard & Western Software 
// by Kholodov Igor at February 22, 1999

// Absolute dates

// "Absolute date" means the number of days elapsed since the Gregorian date
// Sunday, December 31, 1 BC. (Since there was no year 0, the year following
// 1 BC is 1 AD.) Thus the Gregorian date January 1, 1 AD is absolute date
// number 1.

// Gregorian dates
LONG LastDayOfGregorianMonth(LONG month, LONG year);

// Classes GregorianDate 
class GregorianDate 
{
private:  
  LONG year;	// 1...
  LONG month;	// 1 == January, ..., 12 == December
  LONG day;	// 1..LastDayOfGregorianMonth(month, year)  
public:
	// constructor: initialize Gregorian date from month, day, year
	GregorianDate(LONG m, LONG d, LONG y) 
		{ month = m; day = d; year = y; }  

	// constructor: Computes the Gregorian date from the absolute date.
	GregorianDate(LONG d) 
	{ 
	// Search forward year by year from approximate year   
	year = d/366;
	// while (d >= GregorianDate(1, 1, year+1))      
	//	year++;
	while ( d >= (&(GregorianDate(1, 1, year+1)))->AbsoluteDate() )      
		year++;

	// Search forward month by month from January  
	month = 1;
	//while (d > GregorianDate(month, LastDayOfGregorianMonth(month,year), year))
	//  month++;    
	//day = d - GregorianDate(month, 1, year) + 1;  
	while ( d > (&(GregorianDate(month, LastDayOfGregorianMonth(month,year), year)))->AbsoluteDate() )
	  month++;    
	day = d - (&(GregorianDate(month, 1, year)))->AbsoluteDate() + 1;  
	}
  
	// Computes the absolute date (expressed in days) from the Gregorian date.
	LONG AbsoluteDate() 
	{ 
	LONG m;
	LONG N = day;						// days this month
	for (m = month - 1;  m > 0; m--)	// days in prior months this year
	  N = N + LastDayOfGregorianMonth(m, year);    
	return
	  (N                    // days this year
	   + 365 * (year - 1)   // days in previous years ignoring leap days
	   + (year - 1)/4       // Julian leap days before this year...
	   - (year - 1)/100     // ...minus prior century years...
	   + (year - 1)/400);   // ...plus prior years divisible by 400  
	}  
  
	// HELPERS
	LONG GetMonth() { return month; };
	LONG GetDay()	 { return day; };
	LONG GetYear()  { return year; };  
};


#ifdef _EXTENT_TIME_CONVERSION_FUNCTIONALITY
// The Gregorian date of nth x-day in month, year before/after optional day.
// x = 0 means Sunday, x = 1 means Monday, and so on.  If n<0, return the nth
// x-day before month day, year (inclusive).  If n>0, return the nth x-day
// after month day, year (inclusive).  If day is omitted or 0, it defaults
// to 1 if n>0, and month's last day otherwise.
GregorianDate NthXday(LONG n, LONG x, LONG month, LONG year, LONG day = 0)
{ 
  if (n > 0) 
  {    
	  if (day == 0)
		  day = 1;  // default for positive n    return GregorianDate
	  ((7 * (n - 1)) + XdayOnOrBefore(6 + GregorianDate(month, day, year), x));
  }  
  else 
  {    if (day == 0)
  day = LastDayOfGregorianMonth(month, year);;  // default for negative n
  return GregorianDate
	  ((7 * (n + 1)) + XdayOnOrBefore(GregorianDate(month, day, year), x));  
  }
}


int XdayOnOrBefore(LONG d, LONG x) 
{
	// Absolute date of the x-day on or before absolute date d.
	// x=0 means Sunday, x=1 means Monday, and so on.    
	return (d - ((d - x) % 7));
}
#endif	// _EXTENT_TIME_CONVERSION_FUNCTIONALITY

#endif	//_TMSTCNVT_H_

