/*
 * Copyright (c)  2000
 * SWsoft  company
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted 
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

//--------------------------------------------------------------------
// MySQL OLE DB Provider 
// Functionality: base
// Release: 0.1
//
// @doc
//
// @module ROWFIND.CPP | IRowsetFind interface implementation
//
//

// Includes ------------------------------------------------------------------

#include "hfiles.h"
#include "headers.h"


// CImpIRowsetFind::FindNextRow
//
// @mfunc Begin at the specified bookmark and find the next row
//		  matching the specified value.
//
//	Now function is very simple and do not use the  indexes even in the case 
//  they are present
//
// @desc	HRESULT
//		@flag	S_OK					| The method succeeded. 
//		@flag	DB_S_ENDOFROWSET		| Reached the start or the end of the rowset 
//		@flag	DB_S_ROWLIMITEXCEEDED	| exceeded the total number of active rows
//		@flag	DB_S_STOPLIMITREACHED	| a resource limit has been reached 
//		@flag	DB_S_BOOKMARKSKIPPED	| skipped that row, and began searching with the next row 
//		@flag	E_FAIL					| A provider-specific error occurred
//		@flag	E_INVALIDARG			| pcRowsObtained or prghRows was a null pointer
//		@flag	E_OUTOFMEMORY			| unable to allocate sufficient memory 
//		@flag	E_UNEXPECTED			| the object is in a zombie state
//		@flag	DB_E_BADBINDINFO		| accessor specified binding information for more than one column
//		@flag	DB_E_BADBOOKMARK		| *pBookmark was invalid
//		@flag	DB_E_BADCHAPTER			| The rowset was chaptered and hChapter was invalid
//		@flag	DB_E_BADCOMPAREOP		| CompareOp was an invalid value
//		@flag	DB_E_BADSTARTPOSITION	| BADSTARTPOSITIONIRowsOffset would position the first row retrieved past either end of the rowset
//		@flag	DB_E_CANTFETCHBACKWARDS	| cRows was negative and the rowset cannot fetch backward
//		@flag	DB_E_CANTSCROLLBACKWARDS| the rowset cannot scroll backward
//		@flag	DB_E_NOTREENTRANT		| The consumer called this method while it was processing a notification
//		@flag	DB_E_ROWSNOTRELEASED	| The provider requires release of prior HROWs before new ones can be obtained 
//		@flag	DB_SEC_E_PERMISSIONDENIED	| The consumer did not have sufficient permission to get the rows.
//
//		@flag	DB_E_BADACCESSORHANDLE	| Aceesor given is bad
//
STDMETHODIMP	CImpIRowsetFind::FindNextRow
	(
	HCHAPTER		hReserved,		//@parm IN | The chapter handle. 
	HACCESSOR		hAccessor,		//@parm IN | Accessor describing the value to be matched.
	void *			pFindValue,		//@parm IN | Pointer to the value to be matched.  
	DBCOMPAREOP		CompareOp,		//@parm IN | Operation to use in comparing the row values.
	ULONG			cbBookmark,		//@parm IN | Length in bytes of the bookmark.
	const BYTE *	pBookmark,		//@parm IN | Pointer to a bookmark.
	LONG			IRowsOffset,	//@parm IN | Offset from the row poined by bookmark.
	LONG			cRows,			//@parm IN | The number of rows to fetch.
	ULONG *			pcRowsObtained,	//@parm OUT | A pointer to memory in which to return the actual number of fetched rows.
	HROW **			prghRows		//@parm OUT | A pointer to memory in which to return an array of handles of the retrieved rows. 
	)
{
	INTERFACE_METHOD_START( "IRowsetFind::FindNextRow" );

    HRESULT hr;

	PACCESSOR	paccessor;
	
	SWORD	dwErrorCount = 0;
	
	BOOL	bCanFetchBackwards = true;		// We can support DBPROP_CANFETCHBACKWARDS 
	BOOL	bCanScrollBackwards = true;		// We can support DBPROP_CANSCROLLBACKWARDS 
	ULONG	ulPropIndex;					// Number of property
	
	*pcRowsObtained = 0;

	// converting types (for DataConvert function)
	// source params
    DBTYPE  dwSrcType;
    void*   pSrc;
    ULONG   dwSrcLength;
    DWORD   dwSrcStatus;

	// destination params
    //DWORD	dwDstLength;
    ULONG*  pdwDstLength;
    ULONG   dwDstMaxLength;
    //DWORD   dwDstStatus;
    DWORD*  pdwDstStatus;
    DBTYPE  dwDstType;
	//void*   pDst;
	PCOLUMNDATA pDst;

	
	// binding param
    DWORD   dwPart;				// parts of buffer to be binded
	ULONG		cBindings;
	DBBINDING*	pBinding;
	ULONG	icol;				// ordinal column
	BYTE    b;					// 

	if (pFindValue == NULL || pcRowsObtained == NULL || prghRows == NULL)
		return E_INVALIDARG;

    // Look if consumer requested supporting scrolling and fetching backward.
	if (m_pObj->m_pUtilProp ->GetPropIndex(DBPROP_CANFETCHBACKWARDS, &ulPropIndex) == TRUE)
		bCanFetchBackwards = m_pObj->m_pUtilProp->m_rgproperties[ulPropIndex].boolVal;

	if (m_pObj->m_pUtilProp -> GetPropIndex(DBPROP_CANSCROLLBACKWARDS, &ulPropIndex) == TRUE)
		bCanScrollBackwards = m_pObj->m_pUtilProp->m_rgproperties[ulPropIndex].boolVal;
    
	// Look if given parameters correspond with se properties
	if ((cRows < 0) && (!bCanFetchBackwards))  
        return DB_E_CANTFETCHBACKWARDS;
	if ((IRowsOffset < 0) && (!bCanScrollBackwards))  
        return DB_E_CANTSCROLLBACKWARDS;


	// Check for accessor validity
	if (m_pObj->m_pExtBufferAccessor == NULL     
        || FAILED( m_pObj->m_pExtBufferAccessor->GetItemOfExtBuffer((ULONG) hAccessor, &paccessor))
        || paccessor == NULL)
		return DB_E_BADACCESSORHANDLE;
        
    cBindings = paccessor->cBindings;
    pBinding  = paccessor->rgBindings;

	// This accessor must describe only a single column.
	if (cBindings != 1)
		return DB_E_BADBINDINFO;

	// Check if bookmark is valid 
	if (!((PHYSICAL_POS_BUF_LEN == cbBookmark * m_pObj->m_pData->bookmarks() && pBookmark != NULL ) || 
		(cbBookmark == 0  && pBookmark == NULL) ||
		(1 == cbBookmark && pBookmark != NULL )))
		return (DB_E_BADBOOKMARK);

	// begin navigate trough table
	hr = m_pObj->MoveToBookmark((void*)pBookmark, cbBookmark);
	if (hr != S_OK)
		return hr;
	
	// Do offset. Skip rows if needed
	if (IRowsOffset)
	{
		hr = m_pObj->m_pData->Skip(IRowsOffset, FALSE);
		if (hr != S_OK)
			return hr;
	}

	// Convert OLE DB type value to a  type value

    // Apply accessor to data.
	icol = pBinding->iOrdinal;

	// Destination buffer properties
	/*if (m_pObj->m_rgdbcolinfo[icol].ulColumnSize > 1)
		pDst = malloc(m_pObj->m_rgdbcolinfo[icol].ulColumnSize);
	else
		pDst = malloc(2); //for boolean (otherwise it crashes)*/
	pDst = (PCOLUMNDATA) malloc(sizeof(COLUMNDATA) + m_pObj->m_rgdbcolinfo[icol].ulColumnSize);

	if (pDst == NULL)
		return E_OUTOFMEMORY;

    // Destination Type
	dwDstType      = m_pObj->m_rgdbcolinfo[icol].wType;
	
	// Destination Length
    //dwDstLength    = m_pObj->m_rgdbcolinfo[icol].ulColumnSize;
	//pdwDstLength   = &dwDstLength;
	pDst->dwLength = m_pObj->m_rgdbcolinfo[icol].ulColumnSize;
	pdwDstLength   = (ULONG*)&pDst->dwLength;
    
	// Destination Max length
	dwDstMaxLength = m_pObj->m_rgdbcolinfo[icol].ulColumnSize;
	
	// Destination Status
	//pdwDstStatus   = &dwDstStatus;
	pdwDstStatus   = &pDst->dwStatus;
	
	// Part
    dwPart         = pBinding->dwPart;

    // Source buffer properties
	dwSrcType      = pBinding->wType;
    if ((dwPart & DBPART_VALUE) == 0)
    {
        if (((dwPart & DBPART_STATUS)
            && (*(ULONG *) ((BYTE*) pFindValue + pBinding->obStatus) & DBSTATUS_S_ISNULL))
           || ((dwPart & DBPART_LENGTH) && *(ULONG *) ((BYTE*) pFindValue + pBinding->obLength) == 0))
        {
            pSrc = &b;
            b = 0x00;
        }
        else
		{
			hr = (E_FAIL);
			goto CImpIRowsetFind_FindNextRow_Exit;
		}	
    }
    else
    {
        pSrc = (void *) ((BYTE*) pFindValue + pBinding->obValue);
    }

    dwSrcLength = (dwPart & DBPART_LENGTH) ? 
						*(ULONG *) ((BYTE*) pFindValue + pBinding->obLength)
						: 0;
    dwSrcStatus = (dwPart & DBPART_STATUS) ? 
						*(ULONG *) ((BYTE*) pFindValue + pBinding->obStatus)
						: DBSTATUS_S_OK;

	
	// convert data
    hr = g_pIDataConvert->DataConvert(
			dwSrcType,
            dwDstType,
            dwSrcLength,
            pdwDstLength,
            pSrc,
            pDst->bData,
            dwDstMaxLength,
            dwSrcStatus,
            pdwDstStatus,
			0,	// bPrecision for conversion to DBNUMERIC
			0,	// bScale for conversion to DBNUMERIC
			//DBDATACONVERT_SETDATABEHAVIOR
			//DBDATACONVERT_DEFAULT
			DBDATACONVERT_LENGTHFROMNTS);

	#ifdef _DEBUG
	switch(hr)
		{
		case E_FAIL:			// fatal error
			TRACE("fatal error");
	        goto CImpIRowsetFind_FindNextRow_Exit;  
		case E_OUTOFMEMORY:		// unable to allocate memory
			TRACE("unable to allocate memory");
	        goto CImpIRowsetFind_FindNextRow_Exit;  
		case DB_E_BADBINDINFO:	// the source or destination data type is invalid
			TRACE("the source or destination data type is invalid");
	        goto CImpIRowsetFind_FindNextRow_Exit;  
		case DB_E_DATAOVERFLOW:	// the request conversion result in overflow
			TRACE("the request conversion result in overflow");
	        goto CImpIRowsetFind_FindNextRow_Exit;  
		case DB_E_ERRORSOCCURRED:			// errors occurd while converting data
			TRACE("errors occured while converting data");
	        goto CImpIRowsetFind_FindNextRow_Exit;  
		case DB_E_UNSUPPORTEDCONVERSION:	// errors occured while converting data
			TRACE("errors occured while converting data");
	        goto CImpIRowsetFind_FindNextRow_Exit;  
		case S_OK:
		default:	
			break;				
		}
	#else	
	if (FAILED( hr ))
        goto CImpIRowsetFind_FindNextRow_Exit;  // fatal error
    if (hr != S_OK)
        dwErrorCount++; // rounding or truncation or can't coerce
	#endif


	// find for first row satisfied criteria
	hr = m_pObj->m_pData->Find(icol, pDst, CompareOp, m_pObj->m_rgdbcolinfo[icol].wType, cRows > 0);
	if (hr != S_OK)
	{
		if (hr == DB_S_ENDOFROWSET)
			m_pObj->m_dwStatus |= STAT_ENDOFCURSOR;
		
		goto CImpIRowsetFind_FindNextRow_Exit;
	}

	// Fetch data since current row
	m_pObj->m_bSkipRow = true;
	
	// now after all positioning, fetch data into the inner buffer using GetNextRows
	hr = m_pObj->m_pIRowset->GetNextRows(NULL, 0, cRows, pcRowsObtained, prghRows);


CImpIRowsetFind_FindNextRow_Exit:
	free(pDst);

	return hr;

	INTERFACE_METHOD_END();
}


