/*
 * Copyright (c)  2000
 * SWsoft  company
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted 
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

//--------------------------------------------------------------------
// MySQL OLE DB Provider 
// Functionality: minimum
// Release: 0.1
//
// @doc
//
// @module DBINIT.CPP | IDBInitialize interface implementation
//
//

// Includes ------------------------------------------------------------------
#include "hfiles.h"
#include "headers.h"
#include "mysqlmeta.h"
#include "xqlholder.h"


static int OleDbPrompt2Odbc (int prompt)
{
	switch( prompt )
	{
	case DBPROMPT_PROMPT: return SQL_DRIVER_PROMPT;
	case DBPROMPT_COMPLETE: return SQL_DRIVER_COMPLETE;
	case DBPROMPT_COMPLETEREQUIRED: return SQL_DRIVER_COMPLETE_REQUIRED;
	case DBPROMPT_NOPROMPT:	default: return SQL_DRIVER_NOPROMPT;
	}
}



// CImpIDBInitialize::Initialize ---------------------------------------------
//
// @mfunc Initializes the DataSource object.. For this provider it requires
// that a valid path is given to where the file will be located.
//
// @rdesc HRESULT
//      @flag S_OK          | Path exists
//      @flag E_FAIL        | Invalid path
//      @flag E_INVALIDARG  | Invalid Parameters passed in
//		@flag DB_E_ALREADYINITIALIZED | Datasource Object already initialized
//
STDMETHODIMP CImpIDBInitialize::Initialize
    (
	)
{
	INTERFACE_METHOD_START( "IDBInitialize::Initialize" );

	HRESULT		hr;
 
	DBPROPIDSET	rgPropertyIDSets[1];
	ULONG		cPropertySets;
	DBPROPSET*	prgPropertySets;
	DBPROPID	rgPropId[4];

	char szDbName[ MAXDDFPATH+1 ]; *szDbName = '\0';
	char szDDFPath[ MAXDDFPATH+1 ]; *szDDFPath = '\0';
	char szDataPath[ MAXDDFPATH+1 ]; *szDataPath = '\0';
	int  nPrompt = DBPROMPT_NOPROMPT;
	HWND hWnd = NULL;

    assert( m_pObj );

    if (m_pObj->m_fDSOInitialized)
        return DB_E_ALREADYINITIALIZED;

	rgPropId[0]								= DBPROP_INIT_DATASOURCE;
	rgPropId[1]								= DBPROP_INIT_PROMPT;
	rgPropId[2]								= DBPROP_INIT_HWND;
	rgPropId[3]								= DBPROP_INIT_LOCATION;
 
	rgPropertyIDSets[0].guidPropertySet		= DBPROPSET_DBINIT;
	rgPropertyIDSets[0].rgPropertyIDs		= rgPropId;
	rgPropertyIDSets[0].cPropertyIDs		= sizeof(rgPropId)/sizeof(rgPropId[0]);

    // Get the value of the DBPROP_INIT_DATASOURCE property
    hr = m_pObj->m_pUtilProp->GetProperties( 
									PROPSET_INIT,
									sizeof(rgPropertyIDSets)/sizeof(rgPropertyIDSets[0]), 
									rgPropertyIDSets,
									&cPropertySets,
									&prgPropertySets );

	_asm {
		int 3;
	}
	// On failure treat it as if we were opening with prompt..
    if( SUCCEEDED(hr) )
	{
		// Get Data Source name
		if( !W2Asz( V_BSTR(&prgPropertySets[0].rgProperties[0].vValue), szDbName ) )
			*szDbName = '\0';

		// Get the Prompt value
		nPrompt = V_I2(&prgPropertySets[0].rgProperties[1].vValue);

		// Get handle of parent window
		hWnd = (HWND)V_I4(&prgPropertySets[0].rgProperties[2].vValue);

		// Get data path (if provided in INIT_LOCATION) -- for DDFs only
		// It is server name for DBNames, too!
		if( !W2Asz( V_BSTR(&prgPropertySets[0].rgProperties[3].vValue), szDataPath ) )
			*szDataPath = '\0';
	}

	// Set desctop window if it the property was not set
	if( hWnd == NULL ) 
		hWnd = GetDesktopWindow();

	// Free the memory
	if (prgPropertySets)
	{
		for(ULONG ulIndex=0; ulIndex<prgPropertySets[0].cProperties; ulIndex++)
			VariantClear(&prgPropertySets[0].rgProperties[ulIndex].vValue);		
		
		g_pIMalloc->Free(prgPropertySets[0].rgProperties);	
		g_pIMalloc->Free(prgPropertySets);
	}

	DATASOURCE_TYPE type = DATASOURCE_NONE;
	BYTE iDriverID = 0;
	BOOL bValidDataSource = FALSE;

	char szFullInfo[ 1024 ]; 
	*szFullInfo = 0;

	if( m_pObj->m_pUtilProp->MySqlMode() )
	{
		if( strpbrk( szDbName, ":/\\" ) ) // something like path
			strcpy( szFullInfo, "DSN=Unknown;SYSDB=" );
		else if( strchr( szDbName, '=' ) ) // something like ODBC connectiion string
		{
			strcpy( szFullInfo, szDbName );
			if( !strstr( szFullInfo, "DSN=" ) )
				strcat( szFullInfo, ";DSN=Unknown" );
		}
		else // something like ODBC DSN name
			strcpy( szFullInfo, "DSN=" );
		strcat( szFullInfo, szDbName );

		SQLHENV henv;
		SQLHDBC hdbc;
		SQLSMALLINT cbFullInfo;

		if( SQL_SUCCEEDED( SQLAllocEnv( &henv ) ) )
		{
			if( SQL_SUCCEEDED( SQLAllocConnect( henv, &hdbc ) ) )
			{
				if( SQL_SUCCEEDED( SQLDriverConnect( hdbc, hWnd, (BYTE*)szFullInfo, strlen( szFullInfo ), (BYTE*)szFullInfo, MAXSTR(szFullInfo), &cbFullInfo, OleDbPrompt2Odbc(nPrompt) ) ) )
				{
					type = DATASOURCE_MYSQL;
					char * db = strstr( szFullInfo, ";DB=" );
					char * sysdb = strstr( szFullInfo, ";SYSDB=");

					if( sysdb )
					{
						sysdb += 7; // strlen( ";SYSDB=" )
						strcpy( szDDFPath, sysdb );
					}
					else if( db )
					{
						db += 4; // strlen( ";DB=" )
						strcpy( szDDFPath, db );
					}

					if( db || sysdb )
					{
						char * end = strchr( szDDFPath, ';' );
						if( end ) *end = 0;
						strcpy( szDataPath, szDDFPath );					
					}
					
					SQLDisconnect( hdbc );
				}
			
				SQLFreeConnect( hdbc );
			}
			
			SQLFreeEnv( henv );
		}
		
		if( type == DATASOURCE_NONE )
			return DB_E_CANCELED;

		goto done;
	}

	// Check name. Get path by name of any type. Get type, too
	bValidDataSource = GetPathByAnyDatabaseName( szDbName, szDDFPath, szDataPath, &type, &iDriverID );
	
	// Check if caller did not tell us to ask and wrong information is provided
	// It is necessary for compatibility with Query Analyzer: it cannot display aby dialogues!
	if (*szDbName && !bValidDataSource && nPrompt != DBPROMPT_PROMPT )
		return E_FAIL;

	// Check if no information is provided, and it is wrong, and we should keep silence.
	if (!*szDbName && !bValidDataSource && nPrompt == DBPROMPT_NOPROMPT )
		return E_FAIL;

	if( !bValidDataSource || nPrompt == DBPROMPT_PROMPT ) 
	for(;;)
	{
		DATASOURCE_TYPE oldType = type;
		type = SelectDataSourceType( hWnd, szDbName, bValidDataSource );
		switch( type )
		{
		case DATASOURCE_DDF:
			if( !SelectDDF( hWnd, szDDFPath, szDataPath ) )
				return DB_E_CANCELED;
			strcpy0( szDbName, szDDFPath, MAXSTR( szDbName ) );
			break;
		case DATASOURCE_FILEDSN:
			{
			int ret = SelectFileDSN( hWnd, szDbName, szDDFPath, szDataPath, &iDriverID );
			if( ret == TRUE )
				break;
			else if( ret == FALSE )
				return DB_E_CANCELED;
			else
				continue;
			}
		case DATASOURCE_NAMEDDB:
		case DATASOURCE_USERDSN:
		case DATASOURCE_SYSTEMDSN:
			{
			int ret = SelectDataSourceName( hWnd, szDbName, szDDFPath, szDataPath, type );
			if( ret == TRUE )
				break;
			else if( ret == FALSE )
				return DB_E_CANCELED;
			else
				continue;
			}
		case DATASOURCE_SAME:
			type = oldType;
			break;
		default:
			return DB_E_CANCELED;
		}
		
		// Check and get short path
		DATASOURCE_TYPE checkType = DATASOURCE_DDF; // check as DDF path; it is most quickly
		if( GetPathByAnyDatabaseName( szDDFPath, szDDFPath, szDataPath, &checkType, &iDriverID ) )
			break;
	}
	
done:
	// Save it in provider object now
	strcpy0( m_pObj->m_szDDFPath, szDDFPath, MAXSTR( m_pObj->m_szDDFPath ) );
	strcpy0( m_pObj->m_szDataPath, szDataPath, MAXSTR( m_pObj->m_szDataPath ) );
	// Save type of data source
	m_pObj->m_typeOfDataSource = type;
	// Set selected datasource name. Note that property is read-only 
	m_pObj->m_pUtilProp->SetDataSourceName( *szDbName ? szDbName : szDDFPath, szFullInfo );
	// Set selected ODBC driver type (for P.SQL 2000 )
	m_pObj->m_iDriverID = iDriverID;
	
	// we succeded if we are here :)
	m_pObj->m_fDSOInitialized = TRUE;

	return S_OK;
	
	INTERFACE_METHOD_END();
}


// CImpIDBInitialize::Uninitialize ---------------------------------------------
//
// @mfunc Returns the Data Source Object to an uninitialized state
//
// @rdesc HRESULT
//      @flag S_OK            | The method succeeded
//      @flag DB_E_OBJECTOPEN | A DBSession object was already created
//
STDMETHODIMP CImpIDBInitialize::Uninitialize
    (
    void
    )
{
	INTERFACE_METHOD_START( "IDBInitialize::Uninitialize" );

    assert( m_pObj );

    if (!m_pObj->m_fDSOInitialized)
		return S_OK;

	if (m_pObj->IfActiveSessionsExist())
		return DB_E_OBJECTOPEN;

	m_pObj->ClearSwstMeta();

	m_pObj->m_fDSOInitialized = FALSE;
	
	return S_OK;
	
	INTERFACE_METHOD_END();
}
