/*
 * Copyright (c)  2000
 * SWsoft  company
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted 
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

//--------------------------------------------------------------------
// MySQL OLE DB Provider 
// Functionality: minimum
// Release: 0.1
//
// @doc
//
// @module DATASRC.H | CDataSource base object and contained interface
// definitions
//
//
#ifndef _DATASRC_H_
#define _DATASRC_H_

// For multiply sessions management
#include	"sessmgmt.h"

#define		MAX_USERID_LENGTH			10
#define		MAX_PASSWORD_LENGTH			16
#define		MAX_RESERVED_LENGTH			1


// Forward declarations ------------------------------------------------------

class   CImpIDBInitialize;
class   CImpIDBProperties;
class	CImpIDBInfo;
class   CImpIDBCreateSession;
class   CImpIPersist;
class	CDataSource;
class	CSwstMetaHolder;
// class	CDBSession;

typedef CImpIDBInitialize*      PIMPIDBINITIALIZE;
typedef CImpIDBProperties*      PIMPIDBProperties;
typedef CImpIDBInfo*			PIMPIDBINFO;
typedef CImpIDBCreateSession*   PIMPIDBCREATESESSION;
typedef CImpIPersist*			PIMPIPERSIST;
typedef CDataSource*			PCDATASOURCE;


// For common dialog browsing directories
typedef struct tagBROWSEINFO 
	{                
	OPENFILENAME*	lpofn;             // Pointer to OPENFILENAME
	UINT			uFileOkString;      // FILEOKSTRING message
	LPCSTR			szPrompt;			// Prompt text, NULL if not required
	} BROWSEINFO,  * lpBROWSEINFO;


// Classes -------------------------------------------------------------------


//----------------------------------------------------------------------------
// @class CDataSource | Containing class for all interfaces on the Datasource 
// CoType Object
//
class CDataSource : public IUnknown				//@base public | IUnknown
{
	START_CLASS(); 

//	Contained interfaces are friends
friend class CImpIDBInitialize;
friend class CImpIDBInfo;
friend class CImpIDBProperties;
friend class CImpIDBCreateSession;
friend class CImpIOpenRowset;
friend class CImpIPersist;
friend class CDBSession;
friend class CImpICommand;
friend class CSSql;
friend class CSchema;
friend class CMySql;

public:
	// MySQL data source?
	BOOL m_bMySqlMode;	

protected: //@access protected
	//Meta data for data source (files&fields)
	CSwstMetaHolder*					m_pSwstMetaHolder; 
	//@cmember Reference count
	ULONG						m_cRef;						
    //@member flag == TRUE if this Data Source object is an an initialized state
    BOOL                        m_fDSOInitialized;    
    //@member flag == TRUE if DBSession object has been created
    // BOOL                        m_fDBSessionCreated;
    //@member session's monitor 
	SESSIONBITS					m_sbSessMonitor;
    //@member total number of current sessions 
	ULONG						m_ulTotalSessions;
    //@member session's monitor 
	CDBSession*					m_pSessions[NUM_SUPPORTED_SESSIONS_PER_DATASOURCE];
    //@member Utility object to manage properties
    PCUTILPROP                  m_pUtilProp;
	//@cmember Contained IDBInitialize
	PIMPIDBINITIALIZE			m_pIDBInitialize;			
    //@cmember Contained IDBProperties
    PIMPIDBProperties           m_pIDBProperties;
	//@cmember Contained IDBInfo
	PIMPIDBINFO					m_pIDBInfo;
    //@member contained IDBCreateSession
    PIMPIDBCREATESESSION        m_pIDBCreateSession;
    //@member contained IPersist
    PIMPIPERSIST				m_pIPersist;

public:
	// Check and Load dictionary of one database
	HRESULT CheckAndTrackOneDatabase( LPOLESTR pszName, LPOLESTR pwszOwners );

	// Load dictionary of one database
	HRESULT TrackOneDatabase( LPSTR pszPath, LPSTR pszDataPath, LPOLESTR pszName, LPOLESTR pwszOwners, DATASOURCE_TYPE typeOfDataSource, BYTE iDriverID, LPOLESTR pwszMySqlStr );

	// Load dictionary of one enum 
	HRESULT TrackOneEnum( EnumDatabase* pEnum, LPOLESTR pwszOwners );

	// Load all available dictionaries
	HRESULT TrackAllEnums( LPOLESTR pwszOwners );

public: //@access public
	//@cmember Constructor		 
	 CDataSource(LPUNKNOWN);
	//@cmember Destructor
	~CDataSource(void);

	//@cmember MARK SESSION ulSession As Active/InActive
	HRESULT SetActiveSession(ULONG ulSession);
	HRESULT SetInActiveSession(ULONG ulSession);

	//@cmember Get first inactive session
	HRESULT GetFirstInactiveSession(ULONG *ulSession);

	//@cmember Count Active Sessions
	HRESULT CountActiveSessions(void);
	bool IfActiveSessionsExist(void);
	
	//@cmember Intitialization Routine
	BOOL FInit( BOOL bMySqlMode );

	//Load SwstMeta
	HRESULT GetSwstMeta(CSwstMetaHolder** prSwstMetaHolder);
	//Force to reload meta data at the next time
	void ClearSwstMeta();

	//Load authentificational information
	void GetAuthInfo( DSNINFO* pDSNINFO );

	//@cmember DDF Path Name 
	char						m_szDDFPath[_MAX_PATH+1];
	//@cmember Data Path Name 
	char						m_szDataPath[_MAX_PATH+1];

	//@cmember Type of data source
	DATASOURCE_TYPE				m_typeOfDataSource;
	//@cmember ODBC driver ID (for P.SQL 2000) 
	BYTE						m_iDriverID;

	//@cmember Controlling IUnknown
	LPUNKNOWN					m_pUnkOuter;				

	//	Object's base IUnknown
	//@cmember Request an Interface
	STDMETHODIMP			QueryInterface(REFIID, LPVOID *);
	//@cmember Increments the Reference count
	STDMETHODIMP_(ULONG)	AddRef(void);
	//@cmember Decrements the Reference count
	STDMETHODIMP_(ULONG)	Release(void);
	//@cmember Perform operations connected with correct destroying of session
	HRESULT					RemoveSession(ULONG ulSession);

	FINISH_CLASS(); 
};

typedef CDataSource *PCDATASOURCE;

#define EXTRACT_MYSQLSTR(x) ((x) + MAXDATASOURCENAME + 1)


//----------------------------------------------------------------------------
// @class CImpIDBInitialize | Contained IDBInitialize class
//
class CImpIDBInitialize : public IDBInitialize		//@base public | IDBInitialize
{
	START_CLASS(); 

	private:  //@access private
		DEBUGCODE(ULONG m_cRef);											
		CDataSource		*m_pObj;											
		LPUNKNOWN		m_pUnkOuter;

	private: //@access private
		// Session ID
		MT_SINT m_siSessionID;

		//@cmember  operation status declaration
		MT_SINT   m_bstatus;
		

	public:  //@access public
		CImpIDBInitialize( CDataSource *pObj, IUnknown *pUnkOuter )					
		{																	
			CLEAR_CONSTRUCT( CImpIDBInitialize );
			
			DEBUGCODE(m_cRef = 0L);											
			m_pObj		= pObj;												
			m_pUnkOuter	= pUnkOuter;										
		}			
	
		~CImpIDBInitialize()													
		{																	
		}

	
		STDMETHODIMP_(ULONG)	AddRef(void)									
		{																	
			DEBUGCODE( ++m_cRef );											
			return m_pUnkOuter->AddRef();									
		}																	
	
		STDMETHODIMP_(ULONG)	Release(void)									
		{																	
			ASSERT( m_cRef > 0 );											
			DEBUGCODE( --m_cRef );											
			return m_pUnkOuter->Release();									
		}																	
	
		STDMETHODIMP			QueryInterface(REFIID riid, LPVOID *ppv)		
		{																	
			return m_pUnkOuter->QueryInterface(riid, ppv);					
		}
	

	//	IDBInitialize members
		//@cmember Initialize Method
	    STDMETHODIMP			Initialize(void);
		//@cmember Uninitialize Method
        STDMETHODIMP            Uninitialize(void);    
	
		FINISH_CLASS(); 
};



//----------------------------------------------------------------------------------------
// @class CImpIDBCreateSession   | contained IDBCreateSession class


class CImpIDBCreateSession : public IDBCreateSession    //@base public | IDBCreateSession
{
	START_CLASS(); 

	private:        //@access private
		DEBUGCODE(ULONG m_cRef);											
		CDataSource		*m_pObj;											
		LPUNKNOWN		m_pUnkOuter;

	public:         //@access public
		CImpIDBCreateSession( CDataSource *pObj, IUnknown *pUnkOuter )					
		{																	
			CLEAR_CONSTRUCT( CImpIDBCreateSession ); 
			
			DEBUGCODE(m_cRef = 0L);											
			m_pObj		= pObj;												
			m_pUnkOuter	= pUnkOuter;										
		}																	
		
		~CImpIDBCreateSession()														
		{																	
		}

		
		STDMETHODIMP_(ULONG)	AddRef(void)									
		{																	
			DEBUGCODE( ++m_cRef );											
			return m_pUnkOuter->AddRef();									
		}
																			
		STDMETHODIMP_(ULONG)	Release(void)									
		{																	
			ASSERT( m_cRef > 0 );											
			DEBUGCODE( --m_cRef );											
			return m_pUnkOuter->Release();									
		}
																			
		STDMETHODIMP			QueryInterface(REFIID riid, LPVOID *ppv)		
		{																	
			return m_pUnkOuter->QueryInterface(riid, ppv);					
		}


        // IDBCreateSession method
        //@cmember CreateSession method
        STDMETHODIMP    CreateSession( IUnknown*, REFIID, IUnknown** );
	
		FINISH_CLASS(); 
};



//----------------------------------------------------------------------------
// @class CImpIDBProperties | Contained IDBProperties class
//
class CImpIDBProperties : public IDBProperties		//@base public | IDBProperties
{
	START_CLASS(); 

	private:        //@access private
		DEBUGCODE(ULONG m_cRef);											
		CDataSource		*m_pObj;											
		LPUNKNOWN		m_pUnkOuter;

	public:         //@access public
		CImpIDBProperties( CDataSource *pObj, IUnknown *pUnkOuter )					
		{																	
			CLEAR_CONSTRUCT( CImpIDBProperties );
			
			DEBUGCODE(m_cRef = 0L);											
			m_pObj		= pObj;												
			m_pUnkOuter	= pUnkOuter;										
		}																	
		
		~CImpIDBProperties()														
		{																	
		}
	
		
		STDMETHODIMP_(ULONG)	AddRef(void)									
		{																	
			DEBUGCODE( ++m_cRef );											
			return m_pUnkOuter->AddRef();									
		}
																			
		STDMETHODIMP_(ULONG)	Release(void)									
		{																	
			ASSERT( m_cRef > 0 );											
			DEBUGCODE( --m_cRef );											
			return m_pUnkOuter->Release();									
		}
																			
		STDMETHODIMP			QueryInterface(REFIID riid, LPVOID *ppv)		
		{																	
			return m_pUnkOuter->QueryInterface(riid, ppv);					
		}


		//	IDBProperties member functions

        //@cmember GetProperties method
        STDMETHODIMP GetProperties
		        	(
						ULONG				cPropertySets,		
				      	const DBPROPIDSET	rgPropertySets[], 	
			        	ULONG*              pcProperties, 	
					 	DBPROPSET**			prgProperties 	    
		        	);

        //@cmember GetPropertyInfo method
        STDMETHODIMP    GetPropertyInfo
                        ( 
							ULONG				cPropertySets, 
							const DBPROPIDSET	rgPropertySets[],
							ULONG*				pcPropertyInfoSets, 
							DBPROPINFOSET**		prgPropertyInfoSets,
							WCHAR**				ppDescBuffer
                        );

        //@cmember SetProperties method
        STDMETHODIMP	SetProperties
					 	(
							ULONG				cProperties,		
						 	DBPROPSET			rgProperties[] 	    
						);
	
		FINISH_CLASS(); 
};

//----------------------------------------------------------------------------
// @class CImpIDBInfo | Contained IDBInfo class
//
class CImpIDBInfo : public IDBInfo		//@base public | IDBInfo
{
	START_CLASS(); 

	private:        //@access private
		DEBUGCODE(ULONG m_cRef);											
		CDataSource		*m_pObj;											
		LPUNKNOWN		m_pUnkOuter;

	public:         //@access public
		CImpIDBInfo( CDataSource *pObj, IUnknown *pUnkOuter )					
		{																	
			CLEAR_CONSTRUCT( CImpIDBInfo );
			
			DEBUGCODE(m_cRef = 0L);											
			m_pObj		= pObj;												
			m_pUnkOuter	= pUnkOuter;										
		}																	
		
		~CImpIDBInfo()														
		{																	
		}

		
		STDMETHODIMP_(ULONG)	AddRef(void)									
		{																	
			DEBUGCODE( ++m_cRef );											
			return m_pUnkOuter->AddRef();									
		}
																			
		STDMETHODIMP_(ULONG)	Release(void)									
		{																	
			ASSERT( m_cRef > 0 );											
			DEBUGCODE( --m_cRef );											
			return m_pUnkOuter->Release();									
		}
																			
		STDMETHODIMP			QueryInterface(REFIID riid, LPVOID *ppv)		
		{																	
			return m_pUnkOuter->QueryInterface(riid, ppv);					
		}


		//	IDBProperties member functions
        
        //@cmember GetKeywords method
        STDMETHODIMP    GetKeywords
                        (
	                        LPWSTR*			ppwsKeywords
                        );
        
        //@cmember GetLiteralInfo method
        STDMETHODIMP    GetLiteralInfo
                        (
	                        ULONG           cLiterals,
							const DBLITERAL rgLiterals[ ],
							ULONG*          pcLiteralInfo,
							DBLITERALINFO** prgLiteralInfo,
							WCHAR**         ppCharBuffer
                        );
		FINISH_CLASS(); 
};


//----------------------------------------------------------------------------------------
// @class CImpIPersist   | contained IPersist class


class CImpIPersist : public IPersistFile    //@base public | IPersistFile
{
	START_CLASS(); 

	private:        //@access private
		DEBUGCODE(ULONG m_cRef);											
		CDataSource		*m_pObj;											
		LPUNKNOWN		m_pUnkOuter;

	public:         //@access public
		CImpIPersist( CDataSource *pObj, IUnknown *pUnkOuter )					
		{																	
			CLEAR_CONSTRUCT( CImpIPersist );

			DEBUGCODE(m_cRef = 0L);											
			m_pObj		= pObj;												
			m_pUnkOuter	= pUnkOuter;										
		}																	
		
		~CImpIPersist()														
		{																	
		}


		STDMETHODIMP_(ULONG)	AddRef(void)									
		{																	
			DEBUGCODE( ++m_cRef );											
			return m_pUnkOuter->AddRef();									
		}
																			
		STDMETHODIMP_(ULONG)	Release(void)									
		{																	
			ASSERT( m_cRef > 0 );											
			DEBUGCODE( --m_cRef );											
			return m_pUnkOuter->Release();									
		}
																			
		STDMETHODIMP			QueryInterface(REFIID riid, LPVOID *ppv)		
		{																	
			return m_pUnkOuter->QueryInterface(riid, ppv);					
		}


        // IPersist method
        //@cmember GetClassID method
        STDMETHODIMP    GetClassID( CLSID *pClassID );

		// IPersistFile methods
		// Checks an object for changes since it was last saved to its current file.
		STDMETHODIMP    IsDirty(void);

		// Opens the specified file and initializes an object from the file contents.
		STDMETHODIMP    Load( LPCOLESTR, DWORD );

		// Saves a copy of the object into the specified file
		STDMETHODIMP    Save(LPCOLESTR, BOOL fRemember);

		// Notifies the object that it can revert from NoScribble mode to Normal mode
		STDMETHODIMP    SaveCompleted(LPCOLESTR);

		// Gets the current name of the file associated with the object
		STDMETHODIMP    GetCurFile(LPOLESTR*);                          

		FINISH_CLASS(); 
};

#endif

