/*
 * Copyright (c)  2000
 * SWsoft  company
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted 
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

#ifndef _COMPARE_H
#define _COMPARE_H

// CompareNumerics
//
// @mfunc Compare two numeric values, return true if
// (*pVal1 CompareOp *pVal2)
//
// @desc  bool
//
template <class TYPE1, class TYPE2> 
  HRESULT CompareNumerics
	(
	TYPE1 *pVal1,			//@parm IN | first value to compare
	DBCOMPAREOP CompareOp,	//@parm IN | compare operation
	TYPE2 *pVal2,			//@parm IN | second value to compare
	bool *bSuccess			//@parm OUT| result of comparison
	)
{
	HRESULT hr = (S_OK);

	// if compare does match 
	*bSuccess = false;

	// perform comparision
	switch (CompareOp)
	{
	case DBCOMPAREOPS_LT:
		if (*pVal1 < *pVal2) 
			*bSuccess = true;
		break;

	case DBCOMPAREOPS_LE:
		if (*pVal1 <= *pVal2) 
			*bSuccess = true;
		break;
	
	case DBCOMPAREOPS_EQ:
		if (*pVal1 == *pVal2) 
			*bSuccess = true;
		break;
				
	case DBCOMPAREOPS_GE:
		if (*pVal1 >= *pVal2) 
			*bSuccess = true;
		break;

	case DBCOMPAREOPS_GT:
		if (*pVal1 > *pVal2) 
			*bSuccess = true;
		break;
				
	case DBCOMPAREOPS_NE:
		if (*pVal1 != *pVal2) 
			*bSuccess = true;
		break;
	default:
		hr = (DB_E_BADCOMPAREOP);
		break;
	}

	// return result of comparision
	return hr;
}

HRESULT CompareBooleans
	(
	bool Val1,				//@parm IN | first value to compare
	DBCOMPAREOP CompareOp,	//@parm IN | compare operation
	bool Val2,				//@parm IN | second value to compare
	bool *bSuccess			//@parm OUT| result of comparison
	);

HRESULT Compare
	(
	int nResult,				//@parm IN | comparision result
	DBCOMPAREOP CompareOp,		//@parm IN | compare operation
	bool *bSuccess				//@parm OUT| result of comparison	
	);


int CompareDates
	(
	DBDATE *pOLEDB,		//@parm IN | OLEDB date to compare
	BT_DATE *pBT		//@parm IN | BT date to compare
	);

HRESULT CompareDates
	(
	void *pOLEDB,				//@parm IN | OLEDB date to compare
	DBCOMPAREOP CompareOp,		//@parm IN | compare operation
	void *pBT,					//@parm IN | BT date to compare
	bool *bSuccess				//@parm OUT| result of comparison
	);

int CompareTimes
	(
	DBTIME *pOLEDB,		//@parm IN | OLEDB time to compare
	BT_TIME *pBT		//@parm IN | BT time to compare
	);

HRESULT CompareTimes
	(
	void *pOLEDB,				//@parm IN | OLEDB date to compare
	DBCOMPAREOP CompareOp,		//@parm IN | compare operation
	void *pBT,					//@parm IN | BT date to compare
	bool *bSuccess				//@parm OUT| result of comparison
	);


HRESULT CompareStrings
	(
	void *pVal1,				//@parm IN | first value to compare
	DBCOMPAREOP CompareOp,		//@parm IN | compare operation
	void *pVal2,				//@parm IN | second value to compare
	bool *bSuccess,				//@parm OUT| result of comparison
	bool bCaseSensitive			//@parm IN | compare with case
	);

#endif
