/*
 * Copyright (c)  2000
 * SWsoft  company
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted 
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

//cache_openfile.h

/** @pkg cache_val.openfile */

/**
 * Reduces actual number of file opening with SWSTID( B_OPEN, ... )
 *
 * @author     Fedor Chelnokov, fchel@mail.ru
 *
 * @version    <ul><li>Created on July 19, 2000
 * @version    <li>Modified on July 20, 2000</ul>
 *
 * @pkgdoc cache_val.openfile
 */

#ifndef _cache_openfile_h_
#define _cache_openfile_h_ 

#include    "cache_val.h"


/**
 * All parameters structure needed to open file
 */
class OpenFileParams {
	START_CLASS();
public:
    /** default constructor */
    OpenFileParams() { CLEAR_CONSTRUCT(OpenFileParams);  }

    /** constructor */
    OpenFileParams( CHAR *lpcaOwner, MT_WORD *lpdataLen, MT_CHAR *lppath_buffer, MT_WORD wOpenMode );

    /** are parameters specify the same file? */
    bool operator ==( const OpenFileParams& cmp ) const;

private:
    friend class OpenSwstFile;

	/** Owner name */
    CHAR       m_caOwner[SWST_OWNER_MAX_LENGTH+1];
	/** data buffer length declaration */
    MT_WORD   m_dataLen;
	/** Full name buffer */
	MT_CHAR   m_path_buffer[_MAX_PATH];
    /** File open name */
    MT_WORD   m_wOpenMode;

	FINISH_CLASS();
};



#endif //_cache_openfile_h_