/*
 * Copyright (c)  2000
 * SWsoft  company
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted 
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

//cache_loadmeta.h

/** @pkg cache_val.loadmeta */

/**
 * Reduces actual number of calls to CSwstMeta::LoadMetaData which is now reffered as CSwstMeta::LoadMetaData_Slow
 *
 * @author     Fedor Chelnokov, fchel@mail.ru
 *
 * @version    <ul><li>Created on July 19, 2000
 * @version    <li>Modified on July 20, 2000</ul>
 *
 * @pkgdoc cache_val.loadmeta
 */

#ifndef _cache_loadmeta_h_
#define _cache_loadmeta_h_ 

#include    "cache_val.h"
#include    "mysqlmeta.h" 

//compares two string, each pointer can be NULL
inline int strcmp0( const char *s1, const char *s2 ) 
{
    if( s1==0 && s2==0 ) return 0;
    if( s1==0 ) return -1;
    if( s2==0 ) return 1;
    return strcmp( s1, s2 );
}

//compares two string, each pointer can be NULL
inline int wcscmp0( const WCHAR *s1, const WCHAR *s2 ) 
{
    if( s1==0 && s2==0 ) return 0;
    if( s1==0 ) return -1;
    if( s2==0 ) return 1;
    return wcscmp( s1, s2 );
}

/** input parameters */
class LoadMetaDataIn
{
	START_CLASS(); 
public:
    /** default constructor */
    LoadMetaDataIn() { 	CLEAR_CONSTRUCT( LoadMetaDataIn ); }

    /** construtor */
    LoadMetaDataIn(CSwstMeta* pSwstMetaINFORMATION_SCHEMA, LPCSTR lpszDDPath, LPCSTR lpszDataPath, LPCOLESTR lpwszDatabaseName, LPCOLESTR lpwszOwner, DATASOURCE_TYPE typeOfDataSource, BYTE iDriverID, LPSTR lpszServerName, LPSTR lpszUser, LPSTR lpszPassword, LPOLESTR pwszMySqlStr ); 

    /** are parameters specify the same metadata? */
    bool operator==( const LoadMetaDataIn& cmp ) const;

private:
    friend class TempODBC;
    friend class LoadMetaDataOut;

    CSwstMeta* m_pSwstMetaINFORMATION_SCHEMA; //distinguish only NULL or equal to this, and other
	char       m_szDdfPath[_MAX_PATH];
	char       m_szDataPath[_MAX_PATH]; 
    WCHAR      m_wszDatabaseName[ MAXDATASOURCENAME+1 ];
	WCHAR	   m_wszOwner[ MAXOWNERNAME + 1 ];
    DATASOURCE_TYPE m_typeOfDataSource;
    BYTE       m_iDriverID;
	char       m_szServerName[ MAXSERVERNAME+1 ]; 
	char       m_szUser[ MAXUSERNAME+1 ]; 
	char       m_szPassword[ MAXPASSWORD+1 ]; 
    WCHAR      m_wszMySqlStr[ MYSQL_MAXDATASOURCENAME+1 ];

	FINISH_CLASS(); 
};
 
/**
 * structure that hold information about temporary created DB name and/or ODBC DSN 
 */
class TempODBC {
	START_CLASS(); 
public:
    /** default constructor */
    TempODBC() { CLEAR_CONSTRUCT( TempODBC ); ref_count = 1; }

    /** actual DSN creation */
    HRESULT create( LoadMetaDataIn& in );

    /** actual DSN deletion, Drop temporary names (do it only once: for INFORMATION_SCHEMA) */
    void destroy();

    //reference counting functions
    void AddRef() { ++ref_count; }
    void Release() {
        if( !--ref_count ) destroy();
    }

//public data members
	char m_szTempODBC[MAXDATASOURCENAME+1];
	char m_szServerName[ MAXSERVERNAME+1 ]; 
	char m_szUser[ MAXUSERNAME+1 ]; 
	char m_szPassword[ MAXPASSWORD+1 ]; 
	WCHAR m_wszOwner[ MAXOWNERNAME + 1 ];

private:
    /** reference counter */
    int ref_count;
	FINISH_CLASS(); 
};

/** output parameters */
class LoadMetaDataOut: public CSwstMeta
{
	START_CLASS(); 
public:
	LoadMetaDataOut() { CLEAR_CONSTRUCT( LoadMetaDataOut ); }

    /** calls LoadMetaData_Slow */
    void update( LoadMetaDataIn &in );

    /** converts this object to several primitives */
    HRESULT decode( CSwstMeta &SwstMeta );

private:
    HRESULT m_hr;

	FINISH_CLASS(); 
};

extern CacheVal< LoadMetaDataOut, LoadMetaDataIn > meta_cache;

#endif //_cache_loadmeta_h_ 