/*
 * Copyright (c)  2000
 * SWsoft  company
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted 
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */


//--------------------------------------------------------------------
// MySQL OLE DB Provider 
// Functionality: minimum
// Release: 0.1
//
// @doc
//
// @module MFIND.CPP | This module contains the File Manipulation code
// for a  Provider.
//
//


#include "hfiles.h"
#include "headers.h"
#include "ttypes.h"
#include "Compare.h"



// CompareBooleans
//
// @mfunc Compare two boolean values, return true if
// (*pVal1 CompareOp *pVal2)
//
// @desc  bool
//
// 
HRESULT CompareBooleans
	(
	bool Val1,				//@parm IN | first value to compare
	DBCOMPAREOP CompareOp,	//@parm IN | compare operation
	bool Val2,				//@parm IN | second value to compare
	bool *bSuccess			//@parm OUT| result of comparison
	)
{
	HRESULT hr = (S_OK);

	// if compare does match 
	*bSuccess = false;

	// perform comparision
	switch (CompareOp)
	{
	case DBCOMPAREOPS_EQ:
		if (Val1 == Val2) 
			*bSuccess = true;
		break;
				
	case DBCOMPAREOPS_NE:
		if (Val1 != Val2) 
			*bSuccess = true;
		break;
	default:
		hr = (DB_E_BADCOMPAREOP);
		break;
	}

	// return result of comparision
	return hr;
}

//Helper function for comparision
//nResult means following: -1 = LT, 0 = EQ, 1 = GT
HRESULT Compare
	(
	int nResult,				//@parm IN | comparision result
	DBCOMPAREOP CompareOp,		//@parm IN | compare operation
	bool *bSuccess				//@parm OUT| result of comparison	
	)
{
	HRESULT hr = (S_OK);

	// perform comparision
	switch (CompareOp)
	{
	case DBCOMPAREOPS_EQ:
		*bSuccess = (nResult == 0);
		break;
				
	case DBCOMPAREOPS_NE:
		*bSuccess = (nResult != 0);
		break;

	case DBCOMPAREOPS_LT:
		*bSuccess = (nResult == -1);
		break;

	case DBCOMPAREOPS_LE:
		*bSuccess = (nResult <= 0);
		break;

	case DBCOMPAREOPS_GT:
		*bSuccess = (nResult == 1);
		break;

	case DBCOMPAREOPS_GE:
		*bSuccess = (nResult >= 0);
		break;

	default:
		hr = (DB_E_BADCOMPAREOP);
		*bSuccess = false;
		break;
	}

	return hr;
}


// CompareDates
//
// @mfunc helper function compares OLEDB and BT dates
// returns 0 if *pOLEDB == *pBT
// returns 1 if *pOLEDB > *pBT
// returns -1 if *pOLEDB < *pBT

int CompareDates
	(
	DBDATE *pOLEDB,		//@parm IN | OLEDB date to compare
	BT_DATE *pBT		//@parm IN | BT date to compare
	)
{
	if (pOLEDB->year != pBT->year)
	{
		if (pOLEDB->year > pBT->year)
			return 1;
		else
			return -1;
	}

	if (pOLEDB->month != pBT->month)
	{
		if (pOLEDB->month > pBT->month)
			return 1;
		else
			return -1;
	}

	if (pOLEDB->day != pBT->day)
	{
		if (pOLEDB->day > pBT->day)
			return 1;
		else
			return -1;
	}

	return 0;
}

// CompareDates
//
// @mfunc Compares OLEDB and BT dates, returns true if
// (*pVal1 CompareOp *pVal2)
//
// @desc  bool
//
// 
HRESULT CompareDates
	(
	void *pOLEDB,				//@parm IN | OLEDB date to compare
	DBCOMPAREOP CompareOp,		//@parm IN | compare operation
	void *pBT,					//@parm IN | BT date to compare
	bool *bSuccess				//@parm OUT| result of comparison
	)
{
	int nResult = CompareDates((DBDATE*)pOLEDB, (BT_DATE*)pBT);
	return Compare(nResult, CompareOp, bSuccess);
}



// CompareTimes
//
// @mfunc helper function compares OLEDB and BT times
// returns 0 if *pOLEDB == *pBT
// returns 1 if *pOLEDB > *pBT
// returns -1 if *pOLEDB < *pBT

int CompareTimes
	(
	DBTIME *pOLEDB,		//@parm IN | OLEDB time to compare
	BT_TIME *pBT		//@parm IN | BT time to compare
	)
{
	if (pOLEDB->hour != pBT->hour)
	{
		if (pOLEDB->hour > pBT->hour)
			return 1;
		else
			return -1;
	}

	if (pOLEDB->minute != pBT->minute)
	{
		if (pOLEDB->minute > pBT->minute)
			return 1;
		else
			return -1;
	}

	if (pOLEDB->second != pBT->second)
	{
		if (pOLEDB->second > pBT->second)
			return 1;
		else
			return -1;
	}

	return 0;
}


// CompareTimes
//
// @mfunc Compares OLEDB and BT times, returns true if
// (*pVal1 CompareOp *pVal2)
//
// @desc  bool
//
// 
HRESULT CompareTimes
	(
	void *pOLEDB,				//@parm IN | OLEDB date to compare
	DBCOMPAREOP CompareOp,		//@parm IN | compare operation
	void *pBT,					//@parm IN | BT date to compare
	bool *bSuccess				//@parm OUT| result of comparison
	)
{
	int nResult = ::CompareTimes((DBTIME*)pOLEDB, (BT_TIME*)pBT);
	return Compare(nResult, CompareOp, bSuccess);
}


// compare strings
HRESULT CompareStrings
	(
	void *pVal1,				//@parm IN | first value to compare
	DBCOMPAREOP CompareOp,		//@parm IN | compare operation
	void *pVal2,				//@parm IN | second value to compare
	bool *bSuccess,				//@parm OUT| result of comparison
	bool bCaseSensitive			//@parm IN | compare with case
	)
{
	HRESULT hr = (S_OK);
	
	// string manipulation helpers
	int n = 0;
    char *pdest;   

	char *plwrVal1;
	char *plwrVal2;

	// if compare does match 
	*bSuccess = false;

	// perform comparision
	if (bCaseSensitive)
	{
		switch (CompareOp)
		{
		case DBCOMPAREOPS_LT:
			n = strcmp( (char*)pVal1, (char*)pVal2 );
			if (n < 0) 
				*bSuccess = true;
			break;

		case DBCOMPAREOPS_LE:
			n = strcmp( (char*)pVal1, (char*)pVal2 );
			if (n <= 0) 
				*bSuccess = true;
			break;
		
		case DBCOMPAREOPS_EQ:
			n = strcmp( (char*)pVal1, (char*)pVal2 );
			if (n == 0) 
				*bSuccess = true;
			break;
					
		case DBCOMPAREOPS_GE:
			n = strcmp( (char*)pVal1, (char*)pVal2 );
			if (n >= 0) 
				*bSuccess = true;
			break;

		case DBCOMPAREOPS_GT:
			n = strcmp( (char*)pVal1, (char*)pVal2 );
			if (n > 0) 
				*bSuccess = true;
			break;

		case DBCOMPAREOPS_BEGINSWITH:
			pdest = strstr( (char*)pVal1, (char*)pVal2 );
			if (pdest == (char*)pVal1) 
				*bSuccess = true;
			break;

		case DBCOMPAREOPS_NOTBEGINSWITH:
			pdest = strstr( (char*)pVal1, (char*)pVal2 );
			if (pdest != (char*)pVal1) 
				*bSuccess = true;
			break;
		
		case DBCOMPAREOPS_CONTAINS:
			pdest = strstr( (char*)pVal1, (char*)pVal2 );
			if (pdest != NULL) 
				*bSuccess = true;
			break;
			
		case DBCOMPAREOPS_NOTCONTAINS:
			pdest = strstr( (char*)pVal1, (char*)pVal2 );
			if (pdest == NULL) 
				*bSuccess = true;
			break;
			

		case DBCOMPAREOPS_NE:
			n = strcmp( (char*)pVal1, (char*)pVal2 );
			if (n != 0) 
				*bSuccess = true;
			break;

		case DBCOMPAREOPS_IGNORE:
				*bSuccess = true;
		default:
			hr = (DB_E_BADCOMPAREOP);
			break;
		}
	}
	else
	{
		switch (CompareOp)
		{
		case DBCOMPAREOPS_LT:
			n = _stricmp( (char*)pVal1, (char*)pVal2 );
			if (n < 0) 
				*bSuccess = true;
			break;

		case DBCOMPAREOPS_LE:
			n = _stricmp( (char*)pVal1, (char*)pVal2 );
			if (n <= 0) 
				*bSuccess = true;
			break;
		
		case DBCOMPAREOPS_EQ:
			n = _stricmp( (char*)pVal1, (char*)pVal2 );
			if (n == 0) 
				*bSuccess = true;
			break;
					
		case DBCOMPAREOPS_GE:
			n = _stricmp( (char*)pVal1, (char*)pVal2 );
			if (n >= 0) 
				*bSuccess = true;
			break;

		case DBCOMPAREOPS_GT:
			n = _stricmp( (char*)pVal1, (char*)pVal2 );
			if (n > 0) 
				*bSuccess = true;
			break;

		case DBCOMPAREOPS_BEGINSWITH:
			plwrVal1 = _strdup((char*)pVal1);
			plwrVal2 = _strdup((char*)pVal2);
			pdest = strstr( _strlwr(plwrVal1), _strlwr(plwrVal2) );
			if (pdest == (char*)pVal1) 
				*bSuccess = true;
			free(plwrVal1);
			free(plwrVal2);
			break;

		case DBCOMPAREOPS_NOTBEGINSWITH:
			plwrVal1 = _strdup((char*)pVal1);
			plwrVal2 = _strdup((char*)pVal2);
			pdest = strstr( _strlwr(plwrVal1), _strlwr(plwrVal2) );
			if (pdest != (char*)pVal1) 
				*bSuccess = true;
			free(plwrVal1);
			free(plwrVal2);
			break;
		
		case DBCOMPAREOPS_CONTAINS:
			plwrVal1 = _strdup((char*)pVal1);
			plwrVal2 = _strdup((char*)pVal2);
			pdest = strstr( _strlwr(plwrVal1), _strlwr(plwrVal2) );
			if (pdest != NULL) 
				*bSuccess = true;
			free(plwrVal1);
			free(plwrVal2);
			break;
			
		case DBCOMPAREOPS_NOTCONTAINS:
			plwrVal1 = _strdup((char*)pVal1);
			plwrVal2 = _strdup((char*)pVal2);
			pdest = strstr( _strlwr(plwrVal1), _strlwr(plwrVal2) );
			if (pdest == NULL) 
				*bSuccess = true;
			free(plwrVal1);
			free(plwrVal2);
			break;
			

		case DBCOMPAREOPS_NE:
			n = _stricmp( (char*)pVal1, (char*)pVal2 );
			if (n != 0) 
				*bSuccess = true;
			break;

		case DBCOMPAREOPS_IGNORE:
				*bSuccess = true;
		default:
			hr = (DB_E_BADCOMPAREOP);
			break;
		}
	}


	// return result of comparision
	return hr;
}

