/* ==== test_switch.c ============================================================
 * Copyright (c) 1993 by Chris Provenzano, proven@athena.mit.edu
 *
 * Description : Test context switch functionality.
 *
 *  1.00 93/08/04 proven
 *      -Started coding this file.
 */

#include <pthread.h>
#include <stdio.h>

char *buf = "abcdefghijklimnopqrstuvwxyz";
int fd = 1;

void* new_thread(void* arg)
{
	while(1) {
		if(write(fd, buf + (int) arg, 1)==-1)
                  switch(errno) {
                  case ERESTART:
                       write(fd,"ERESTART\n", 9);
                       break;
                  }
	}
	fprintf(stderr, "Compiler error\n");
	exit(1);
}

main()
{
	pthread_t thread;
	int i, count = 2;

	pthread_init();

	for(i = 0; i < count; i++) {
		if (pthread_create(&thread, NULL, new_thread, i)) {
			printf("error creating new thread %d\n", i);
		}
	}
	pthread_exit(NULL);
	fprintf(stderr, "pthread_exit returned\n");
	exit(1);
}
