/* 
 * Copyright (c) 2008, 2012, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _WF_PANEL_H_
#define _WF_PANEL_H_

using namespace System::Windows::Forms;
using namespace Layout;

namespace MySQL {
  namespace Forms {

    private ref class FillLayout : public LayoutEngine
    {
    public:
      System::Drawing::Size ComputeLayout(Control^ control, System::Drawing::Size proposedSize, bool resizeChildren);
      virtual bool Layout(Object^ container, LayoutEventArgs^ arguments) override;
      System::Drawing::Size GetPreferredSize(Control^ control, System::Drawing::Size proposedSize);
    };

    private interface class ValueSetter
    {
      virtual void ApplyContentBounds(const System::Drawing::Rectangle% bounds);
    };


    private delegate System::Void ApplyBoundsDelegate(const System::Drawing::Rectangle% bounds);

    /**
     * A group box with a fill layout.
     */
    public ref class FillGroupBox : public GroupBox, ValueSetter
    {
    private:
      FillLayout^ layoutEngine;
    protected:
      virtual void OnPaintBackground(PaintEventArgs^ args) override;
    public:
      FillGroupBox()
      {
      }

      virtual System::Drawing::Size GetPreferredSize(System::Drawing::Size proposedSize) override;

      virtual property Windows::Forms::Layout::LayoutEngine^ LayoutEngine
      {
        Windows::Forms::Layout::LayoutEngine^ get() override
        {
          if (layoutEngine == nullptr)
            layoutEngine = gcnew FillLayout();

          return layoutEngine;
        }
      }

      virtual void ApplyContentBounds(const System::Drawing::Rectangle% bounds)
      {
        Controls[0]->Bounds = bounds;
      };
    };

    /**
     * A panel with a fill layout.
     */
    public ref class FillPanel : public Panel, ValueSetter
    {
    private:
      FillLayout^ layoutEngine;
    protected:
      virtual void OnPaintBackground(PaintEventArgs^ args) override;
    public:
      FillPanel()
      {
      }

      virtual System::Drawing::Size GetPreferredSize(System::Drawing::Size proposedSize) override;

      virtual property Windows::Forms::Layout::LayoutEngine^ LayoutEngine
      {
        Windows::Forms::Layout::LayoutEngine^ get() override
        {
          if (layoutEngine == nullptr)
            layoutEngine = gcnew FillLayout();

          return layoutEngine;
        }
      }

      virtual void ApplyContentBounds(const System::Drawing::Rectangle% bounds)
      {
        Controls[0]->Bounds = bounds;
      };
    };

    /**
     * A header panel with a fill layout.
     */
    public ref class HeaderFillPanel : public MySQL::Controls::HeaderPanel, ValueSetter
    {
    private:
      FillLayout^ layoutEngine;
      System::Drawing::Bitmap ^background;

    public:
      HeaderFillPanel()
      {
      }

      virtual System::Drawing::Size GetPreferredSize(System::Drawing::Size proposedSize) override;

      virtual property Windows::Forms::Layout::LayoutEngine^ LayoutEngine
      {
        Windows::Forms::Layout::LayoutEngine^ get() override
        {
          if (layoutEngine == nullptr)
            layoutEngine = gcnew FillLayout();

          return layoutEngine;
        }
      }

      virtual void ApplyContentBounds(const System::Drawing::Rectangle% bounds)
      {
        if (Controls->Count > 0)
          Controls[0]->Bounds = bounds;
      };
    };

    public ref class PanelImpl : public ViewImpl
    {
    private:
      ::mforms::View *_child;
      ::mforms::PanelType type;

    protected:
      PanelImpl(::mforms::View *self)
        : ViewImpl(self)
      {
      }

      static bool create(::mforms::Panel *self, ::mforms::PanelType panelType);
      static void set_title(::mforms::Panel *self, const std::string &title);
      static void set_back_color(::mforms::Panel *self, const std::string &color);
      static void add(::mforms::Panel *self, ::mforms::View *view);
      static void set_active(::mforms::Panel* self, bool value);
      static bool get_active(::mforms::Panel* self);
      static void remove(::mforms::Panel *self, ::mforms::View* view);

    public:
      virtual void set_title(const std::string &title);
      virtual void set_back_color(const std::string &color);
      virtual void add(::mforms::View *view);
      virtual void set_active(bool value);
      virtual bool get_active();
      virtual void remove(::mforms::View* view);
      virtual void remove();

      static void init(Manager ^mgr)
      {
        ::mforms::ControlFactory *f= ::mforms::ControlFactory::get_instance();

        DEF_CALLBACK2(bool, ::mforms::Panel*, ::mforms::PanelType, mgr, f->_panel_impl, PanelImpl, create);
        DEF_CALLBACK2(void, ::mforms::Panel*, const std::string&, mgr, f->_panel_impl, PanelImpl, set_title);
        DEF_CALLBACK2(void, ::mforms::Panel*, ::mforms::View*, mgr, f->_panel_impl, PanelImpl, add);
        DEF_CALLBACK2(void, ::mforms::Panel*, const std::string&, mgr, f->_panel_impl, PanelImpl, set_back_color);
        DEF_CALLBACK2(void, ::mforms::Panel*, bool, mgr, f->_panel_impl, PanelImpl, set_active);
        DEF_CALLBACK1(bool, ::mforms::Panel*, mgr, f->_panel_impl, PanelImpl, get_active);
        DEF_CALLBACK2(void, ::mforms::Panel*, ::mforms::View*, mgr, f->_panel_impl, PanelImpl, remove);
      }
    };

  };
};


#endif
