/* 
 * Copyright (c) 2008, 2012, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _WF_BUTTON_H_
#define _WF_BUTTON_H_

/**
 * Implements a wrapper class for a .NET button control, which can be used by the mforms library.
 *
 * @ingroup mforms
 */

using namespace System;
using namespace Windows::Forms;


namespace MySQL {
  namespace Forms {

    /*
     * Implements a wrapper class around a .NET button control, so it can be used by the mforms library.
     */
    public ref class ButtonImpl : public ViewImpl
    {
    protected:
      ButtonImpl(::mforms::Button *self);
      bool _internal_padding;

      static bool create(::mforms::Button *self, ::mforms::ButtonType btype);
      static void set_text(::mforms::Button *self, const std::string &text);
      static void set_icon(::mforms::Button *self, const std::string &path);
      static void button_click(System::Object ^sender, System::EventArgs ^e);
      static void enable_internal_padding(::mforms::Button *self, bool flag);
    public:
      static void init(Manager ^mgr)
      {
        ::mforms::ControlFactory *f= ::mforms::ControlFactory::get_instance();

        DEF_CALLBACK2(bool, ::mforms::Button*, ::mforms::ButtonType, mgr, f->_button_impl, ButtonImpl, create);
        DEF_CALLBACK2(void, ::mforms::Button*, const std::string&, mgr, f->_button_impl, ButtonImpl, set_text);
        DEF_CALLBACK2(void, ::mforms::Button*, const std::string&, mgr, f->_button_impl, ButtonImpl, set_icon);
        DEF_CALLBACK2(void, ::mforms::Button*, bool, mgr, f->_button_impl, ButtonImpl, enable_internal_padding);
      }
    };

  };
};


#endif
