#ifndef __grts_structs_ui_h__
#define __grts_structs_ui_h__

#include <grtpp.h>

#ifdef _WIN32
  #pragma warning(disable: 4355) // 'this' : used in base member initizalizer list
  #ifdef GRT_STRUCTS_UI_EXPORT
  #define GRT_STRUCTS_UI_PUBLIC __declspec(dllexport)
#else
  #define GRT_STRUCTS_UI_PUBLIC __declspec(dllimport)
#endif
#else
  #define GRT_STRUCTS_UI_PUBLIC
#endif

#include <grts/structs.h>
#include <grts/structs.db.mgmt.h>


class TransientObject;
typedef grt::Ref<TransientObject> TransientObjectRef;
class ui_db_ConnectPanel;
typedef grt::Ref<ui_db_ConnectPanel> ui_db_ConnectPanelRef;
class mforms_ObjectReference;
typedef grt::Ref<mforms_ObjectReference> mforms_ObjectReferenceRef;


namespace mforms { 
	class Object;
}; 

  /** the parent of all transient (non persistent) objects */
class  TransientObject : public grt::internal::Object
{
  typedef grt::internal::Object super;
public:
  TransientObject(grt::GRT *grt, grt::MetaClass *meta=0)
  : grt::internal::Object(grt, meta ? meta : grt->get_metaclass(static_class_name()))

  {
  }

  static std::string static_class_name() { return "TransientObject"; }

protected:

private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new TransientObject(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&TransientObject::create);
  }
};


class GRT_STRUCTS_UI_PUBLIC ui_db_ConnectPanel : public TransientObject
{
  typedef TransientObject super;
public:
  class ImplData;
  friend class ImplData;
  ui_db_ConnectPanel(grt::GRT *grt, grt::MetaClass *meta=0)
  : TransientObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
    _data(0)

  {
  }

  virtual ~ui_db_ConnectPanel();

  static std::string static_class_name() { return "ui.db.ConnectPanel"; }

  /** Getter for attribute connection
   
    
   \par In Python:
value = obj.connection
   */
  grt::Ref<db_mgmt_Connection> connection() const;
  /** Setter for attribute connection
   
    
    \par In Python:
obj.connection = value
   */
  virtual void connection(const grt::Ref<db_mgmt_Connection> &value);

  /** Getter for attribute view (read-only)
   
    reference to the toplevel mforms View of the connect panel
   \par In Python:
value = obj.view
   */
  grt::Ref<mforms_ObjectReference> view() const;
private: // the next attribute is read-only
public:

  /** Method. initializes the Connection Panel
  \param mgmt 
  \return 

   */
  virtual void initialize(const grt::Ref<db_mgmt_Management> &mgmt);
  /** Method. initializes the Connection Panel
  \param mgmt 
  \param allowedRdbmsList 
  \return 

   */
  virtual void initializeWithRDBMSSelector(const grt::Ref<db_mgmt_Management> &mgmt, const grt::ListRef<db_mgmt_Rdbms> &allowedRdbmsList);
  /** Method. save the connection with the given name. Throws an exception if the connection name is duplicate or on other errors
  \param name 
  \return 

   */
  virtual void saveConnectionAs(const std::string &name);

  ImplData *get_data() const { return _data; }

  void set_data(ImplData *data);
  // default initialization function. auto-called by Ref<Object> constructor
  virtual void init();

protected:

private: // wrapper methods for use by grt
  ImplData *_data;

  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new ui_db_ConnectPanel(grt));
  }

  static grt::ValueRef call_initialize(grt::internal::Object *self, const grt::BaseListRef &args){ dynamic_cast<ui_db_ConnectPanel*>(self)->initialize(grt::Ref<db_mgmt_Management>::cast_from(args[0])); return grt::ValueRef(); }

  static grt::ValueRef call_initializeWithRDBMSSelector(grt::internal::Object *self, const grt::BaseListRef &args){ dynamic_cast<ui_db_ConnectPanel*>(self)->initializeWithRDBMSSelector(grt::Ref<db_mgmt_Management>::cast_from(args[0]), grt::ListRef<db_mgmt_Rdbms>::cast_from(args[1])); return grt::ValueRef(); }

  static grt::ValueRef call_saveConnectionAs(grt::internal::Object *self, const grt::BaseListRef &args){ dynamic_cast<ui_db_ConnectPanel*>(self)->saveConnectionAs(grt::StringRef::cast_from(args[0])); return grt::ValueRef(); }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&ui_db_ConnectPanel::create);
    {
      void (ui_db_ConnectPanel::*setter)(const grt::Ref<db_mgmt_Connection> &)= &ui_db_ConnectPanel::connection;
      grt::Ref<db_mgmt_Connection> (ui_db_ConnectPanel::*getter)() const= &ui_db_ConnectPanel::connection;
      meta->bind_member("connection", new grt::MetaClass::Property<ui_db_ConnectPanel,grt::Ref<db_mgmt_Connection> >(getter, setter));
    }
    meta->bind_member("view", new grt::MetaClass::Property<ui_db_ConnectPanel,grt::Ref<mforms_ObjectReference> >(&ui_db_ConnectPanel::view));
    meta->bind_method("initialize", &ui_db_ConnectPanel::call_initialize);
    meta->bind_method("initializeWithRDBMSSelector", &ui_db_ConnectPanel::call_initializeWithRDBMSSelector);
    meta->bind_method("saveConnectionAs", &ui_db_ConnectPanel::call_saveConnectionAs);
  }
};


  /** an object representing a reference to a mforms object */
class GRT_STRUCTS_UI_PUBLIC mforms_ObjectReference : public TransientObject
{
  typedef TransientObject super;
public:
  typedef mforms::Object ImplData;
  mforms_ObjectReference(grt::GRT *grt, grt::MetaClass *meta=0)
  : TransientObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _type(""),
    _data(0), _release_data(NULL)

  {
  }

  virtual ~mforms_ObjectReference() { if (_release_data && _data) _release_data(_data);  }

  static std::string static_class_name() { return "mforms.ObjectReference"; }

  /** Getter for attribute type
   
    the specific type of mforms object
   \par In Python:
value = obj.type
   */
  grt::StringRef type() const { return _type; }
  /** Setter for attribute type
   
    the specific type of mforms object
    \par In Python:
obj.type = value
   */
  virtual void type(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_type);
   _type= value;
    member_changed("type", ovalue, value);
  }

  /** Getter for attribute valid (read-only)
   
    whether the object is currently valid
   \par In Python:
value = obj.valid
   */
  grt::IntegerRef valid() const;
private: // the next attribute is read-only
public:

  /** Method. checks whether the reference points to the same view as another refrence
  \param other 
  \return 

   */
  virtual grt::IntegerRef isEqualTo(const grt::Ref<mforms_ObjectReference> &other);

  ImplData *get_data() const { return _data; }

  void set_data(ImplData *data, void (*release)(ImplData*))
  {
    if (_data == data) return;
    if (_data && _release_data) _release_data(_data);
    _data= data;
    _release_data= release;
  }
protected:

  grt::StringRef _type;
private: // wrapper methods for use by grt
  ImplData *_data;
  void (*_release_data)(ImplData *);

  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new mforms_ObjectReference(grt));
  }

  static grt::ValueRef call_isEqualTo(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<mforms_ObjectReference*>(self)->isEqualTo(grt::Ref<mforms_ObjectReference>::cast_from(args[0])); }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&mforms_ObjectReference::create);
    {
      void (mforms_ObjectReference::*setter)(const grt::StringRef &)= &mforms_ObjectReference::type;
      grt::StringRef (mforms_ObjectReference::*getter)() const= &mforms_ObjectReference::type;
      meta->bind_member("type", new grt::MetaClass::Property<mforms_ObjectReference,grt::StringRef >(getter,setter));
    }
    meta->bind_member("valid", new grt::MetaClass::Property<mforms_ObjectReference,grt::IntegerRef >(&mforms_ObjectReference::valid));
    meta->bind_method("isEqualTo", &mforms_ObjectReference::call_isEqualTo);
  }
};




inline void register_structs_ui_xml()
{
  grt::internal::ClassRegistry::register_class<TransientObject>();
  grt::internal::ClassRegistry::register_class<ui_db_ConnectPanel>();
  grt::internal::ClassRegistry::register_class<mforms_ObjectReference>();
}

#ifdef AUTO_REGISTER_GRT_CLASSES
static struct _autoreg__structs_ui_xml { _autoreg__structs_ui_xml() { register_structs_ui_xml(); } } __autoreg__structs_ui_xml;
#endif

#endif
