#ifndef __grts_structs_db_query_h__
#define __grts_structs_db_query_h__

#include <grtpp.h>

#ifdef _WIN32
  #pragma warning(disable: 4355) // 'this' : used in base member initizalizer list
  #ifdef GRT_STRUCTS_DB_QUERY_EXPORT
  #define GRT_STRUCTS_DB_QUERY_PUBLIC __declspec(dllexport)
#else
  #define GRT_STRUCTS_DB_QUERY_PUBLIC __declspec(dllimport)
#endif
#else
  #define GRT_STRUCTS_DB_QUERY_PUBLIC
#endif

#include <grts/structs.h>
#include <grts/structs.ui.h>
#include <grts/structs.db.mgmt.h>


class db_query_LiveDBObject;
typedef grt::Ref<db_query_LiveDBObject> db_query_LiveDBObjectRef;
class db_query_ResultsetColumn;
typedef grt::Ref<db_query_ResultsetColumn> db_query_ResultsetColumnRef;
class db_query_Resultset;
typedef grt::Ref<db_query_Resultset> db_query_ResultsetRef;
class db_query_EditableResultset;
typedef grt::Ref<db_query_EditableResultset> db_query_EditableResultsetRef;
class db_query_QueryBuffer;
typedef grt::Ref<db_query_QueryBuffer> db_query_QueryBufferRef;
class db_query_QueryEditor;
typedef grt::Ref<db_query_QueryEditor> db_query_QueryEditorRef;
class db_query_Editor;
typedef grt::Ref<db_query_Editor> db_query_EditorRef;


namespace mforms { 
	class Object;
}; 

  /** object name from a live database */
class  db_query_LiveDBObject : public GrtObject
{
  typedef GrtObject super;
public:
  db_query_LiveDBObject(grt::GRT *grt, grt::MetaClass *meta=0)
  : GrtObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _schemaName(""),
     _type("")

  {
  }

  static std::string static_class_name() { return "db.query.LiveDBObject"; }

  /** Getter for attribute schemaName
   
    name of the schema the object belongs to
   \par In Python:
value = obj.schemaName
   */
  grt::StringRef schemaName() const { return _schemaName; }
  /** Setter for attribute schemaName
   
    name of the schema the object belongs to
    \par In Python:
obj.schemaName = value
   */
  virtual void schemaName(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_schemaName);
   _schemaName= value;
    member_changed("schemaName", ovalue, value);
  }

  /** Getter for attribute type
   
    type of the object (schema, table, view, routine)
   \par In Python:
value = obj.type
   */
  grt::StringRef type() const { return _type; }
  /** Setter for attribute type
   
    type of the object (schema, table, view, routine)
    \par In Python:
obj.type = value
   */
  virtual void type(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_type);
   _type= value;
    member_changed("type", ovalue, value);
  }

protected:

  grt::StringRef _schemaName;
  grt::StringRef _type;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_query_LiveDBObject(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_query_LiveDBObject::create);
    {
      void (db_query_LiveDBObject::*setter)(const grt::StringRef &)= &db_query_LiveDBObject::schemaName;
      grt::StringRef (db_query_LiveDBObject::*getter)() const= &db_query_LiveDBObject::schemaName;
      meta->bind_member("schemaName", new grt::MetaClass::Property<db_query_LiveDBObject,grt::StringRef >(getter,setter));
    }
    {
      void (db_query_LiveDBObject::*setter)(const grt::StringRef &)= &db_query_LiveDBObject::type;
      grt::StringRef (db_query_LiveDBObject::*getter)() const= &db_query_LiveDBObject::type;
      meta->bind_member("type", new grt::MetaClass::Property<db_query_LiveDBObject,grt::StringRef >(getter,setter));
    }
  }
};


  /** a database resultset column */
class  db_query_ResultsetColumn : public GrtObject
{
  typedef GrtObject super;
public:
  db_query_ResultsetColumn(grt::GRT *grt, grt::MetaClass *meta=0)
  : GrtObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _columnType("")

  {
  }

  static std::string static_class_name() { return "db.query.ResultsetColumn"; }

  /** Getter for attribute columnType
   
    the type of the column, string, int, real, blob, date, time, datetime, geo
   \par In Python:
value = obj.columnType
   */
  grt::StringRef columnType() const { return _columnType; }
  /** Setter for attribute columnType
   
    the type of the column, string, int, real, blob, date, time, datetime, geo
    \par In Python:
obj.columnType = value
   */
  virtual void columnType(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_columnType);
   _columnType= value;
    member_changed("columnType", ovalue, value);
  }

protected:

  grt::StringRef _columnType;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_query_ResultsetColumn(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_query_ResultsetColumn::create);
    {
      void (db_query_ResultsetColumn::*setter)(const grt::StringRef &)= &db_query_ResultsetColumn::columnType;
      grt::StringRef (db_query_ResultsetColumn::*getter)() const= &db_query_ResultsetColumn::columnType;
      meta->bind_member("columnType", new grt::MetaClass::Property<db_query_ResultsetColumn,grt::StringRef >(getter,setter));
    }
  }
};


  /** a database resultset. This object does not allow changes to the resultset, if you need to edit the resultset, see \ref db_query_EditableResultset */
class GRT_STRUCTS_DB_QUERY_PUBLIC db_query_Resultset : public GrtObject
{
  typedef GrtObject super;
public:
  class ImplData;
  friend class ImplData;
  db_query_Resultset(grt::GRT *grt, grt::MetaClass *meta=0)
  : GrtObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
    _columns(grt, this, false),
    _data(0)

  {
  }

  virtual ~db_query_Resultset();

  static std::string static_class_name() { return "db.query.Resultset"; }

  // columns is owned by db_query_Resultset
  /** Getter for attribute columns (read-only)
   
    the columns of the resultset
   \par In Python:
value = obj.columns
   */
  grt::ListRef<db_query_ResultsetColumn> columns() const { return _columns; }
private: // the next attribute is read-only
  virtual void columns(const grt::ListRef<db_query_ResultsetColumn> &value)
  {
    grt::ValueRef ovalue(_columns);

    _columns= value;
    owned_member_changed("columns", ovalue, value);
  }
public:

  /** Getter for attribute currentRow (read-only)
   
    
   \par In Python:
value = obj.currentRow
   */
  grt::IntegerRef currentRow() const;
private: // the next attribute is read-only
public:

  /** Getter for attribute rowCount (read-only)
   
    
   \par In Python:
value = obj.rowCount
   */
  grt::IntegerRef rowCount() const;
private: // the next attribute is read-only
public:

  /** Getter for attribute sql (read-only)
   
    the SQL statement that generated this resultset
   \par In Python:
value = obj.sql
   */
  grt::StringRef sql() const;
private: // the next attribute is read-only
public:

  /** Method. returns the float contents of the field at the given column index and current row
  \param column 
  \return value stored in cell (can be null)

   */
  virtual grt::DoubleRef floatFieldValue(long column);
  /** Method. returns the float contents of the field at the given column name and current row
  \param column 
  \return value stored in cell (can be null)

   */
  virtual grt::DoubleRef floatFieldValueByName(const std::string &column);
  /** Method. sets the current row index to the 1st
  \return (boolean) 1 on success or 0 if the row number is out of bounds

   */
  virtual grt::IntegerRef goToFirstRow();
  /** Method. sets the current row index to the last
  \return (boolean) 1 on success or 0 if the row number is out of bounds

   */
  virtual grt::IntegerRef goToLastRow();
  /** Method. sets the current row pointer to the given index
  \param row 
  \return (boolean) 1 on success or 0 if the row number is out of bounds

   */
  virtual grt::IntegerRef goToRow(long row);
  /** Method. returns the integer contents of the field at the given column index and current row
  \param column 
  \return value stored in cell (can be null)

   */
  virtual grt::IntegerRef intFieldValue(long column);
  /** Method. returns the integer contents of the field at the given column name and current row
  \param column 
  \return value stored in cell (can be null)

   */
  virtual grt::IntegerRef intFieldValueByName(const std::string &column);
  /** Method. moves the current row pointer to the next one
  \return (boolean) 1 on success or 0 if the new row number is out of bounds

   */
  virtual grt::IntegerRef nextRow();
  /** Method. moves the current row pointer to the previous one
  \return (boolean) 1 on success or 0 if the new row number is out of bounds

   */
  virtual grt::IntegerRef previousRow();
  /** Method. refreshes the resultset, re-executing the originator query
  \return 

   */
  virtual grt::IntegerRef refresh();
  /** Method. saves the contents of the field at given column and current row to a file
  \param column 
  \param file 
  \return (boolean)

   */
  virtual grt::IntegerRef saveFieldValueToFile(long column, const std::string &file);
  /** Method. returns the contents of the field at the given column index and current row as a string. If the column type is not string, it will be converted
  \param column 
  \return value stored in cell (can be null)

   */
  virtual grt::StringRef stringFieldValue(long column);
  /** Method. returns the contents of the field at the given column name and current row as a string. If the column type is not string, it will be converted
  \param column 
  \return value stored in cell (can be null)

   */
  virtual grt::StringRef stringFieldValueByName(const std::string &column);

  ImplData *get_data() const { return _data; }

  void set_data(ImplData *data);
  // default initialization function. auto-called by Ref<Object> constructor
  virtual void init();

protected:

  grt::ListRef<db_query_ResultsetColumn> _columns;// owned
private: // wrapper methods for use by grt
  ImplData *_data;

  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_query_Resultset(grt));
  }

  static grt::ValueRef call_floatFieldValue(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_query_Resultset*>(self)->floatFieldValue(grt::IntegerRef::cast_from(args[0])); }

  static grt::ValueRef call_floatFieldValueByName(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_query_Resultset*>(self)->floatFieldValueByName(grt::StringRef::cast_from(args[0])); }

  static grt::ValueRef call_goToFirstRow(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_query_Resultset*>(self)->goToFirstRow(); }

  static grt::ValueRef call_goToLastRow(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_query_Resultset*>(self)->goToLastRow(); }

  static grt::ValueRef call_goToRow(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_query_Resultset*>(self)->goToRow(grt::IntegerRef::cast_from(args[0])); }

  static grt::ValueRef call_intFieldValue(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_query_Resultset*>(self)->intFieldValue(grt::IntegerRef::cast_from(args[0])); }

  static grt::ValueRef call_intFieldValueByName(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_query_Resultset*>(self)->intFieldValueByName(grt::StringRef::cast_from(args[0])); }

  static grt::ValueRef call_nextRow(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_query_Resultset*>(self)->nextRow(); }

  static grt::ValueRef call_previousRow(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_query_Resultset*>(self)->previousRow(); }

  static grt::ValueRef call_refresh(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_query_Resultset*>(self)->refresh(); }

  static grt::ValueRef call_saveFieldValueToFile(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_query_Resultset*>(self)->saveFieldValueToFile(grt::IntegerRef::cast_from(args[0]), grt::StringRef::cast_from(args[1])); }

  static grt::ValueRef call_stringFieldValue(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_query_Resultset*>(self)->stringFieldValue(grt::IntegerRef::cast_from(args[0])); }

  static grt::ValueRef call_stringFieldValueByName(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_query_Resultset*>(self)->stringFieldValueByName(grt::StringRef::cast_from(args[0])); }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_query_Resultset::create);
    {
      void (db_query_Resultset::*setter)(const grt::ListRef<db_query_ResultsetColumn> &)= &db_query_Resultset::columns;
      grt::ListRef<db_query_ResultsetColumn> (db_query_Resultset::*getter)() const= &db_query_Resultset::columns;
      meta->bind_member("columns", new grt::MetaClass::Property<db_query_Resultset,grt::ListRef<db_query_ResultsetColumn> >(getter,setter));
    }
    meta->bind_member("currentRow", new grt::MetaClass::Property<db_query_Resultset,grt::IntegerRef >(&db_query_Resultset::currentRow));
    meta->bind_member("rowCount", new grt::MetaClass::Property<db_query_Resultset,grt::IntegerRef >(&db_query_Resultset::rowCount));
    meta->bind_member("sql", new grt::MetaClass::Property<db_query_Resultset,grt::StringRef >(&db_query_Resultset::sql));
    meta->bind_method("floatFieldValue", &db_query_Resultset::call_floatFieldValue);
    meta->bind_method("floatFieldValueByName", &db_query_Resultset::call_floatFieldValueByName);
    meta->bind_method("goToFirstRow", &db_query_Resultset::call_goToFirstRow);
    meta->bind_method("goToLastRow", &db_query_Resultset::call_goToLastRow);
    meta->bind_method("goToRow", &db_query_Resultset::call_goToRow);
    meta->bind_method("intFieldValue", &db_query_Resultset::call_intFieldValue);
    meta->bind_method("intFieldValueByName", &db_query_Resultset::call_intFieldValueByName);
    meta->bind_method("nextRow", &db_query_Resultset::call_nextRow);
    meta->bind_method("previousRow", &db_query_Resultset::call_previousRow);
    meta->bind_method("refresh", &db_query_Resultset::call_refresh);
    meta->bind_method("saveFieldValueToFile", &db_query_Resultset::call_saveFieldValueToFile);
    meta->bind_method("stringFieldValue", &db_query_Resultset::call_stringFieldValue);
    meta->bind_method("stringFieldValueByName", &db_query_Resultset::call_stringFieldValueByName);
  }
};


  /** a resultset created for editing table data. Changes made to the resultset are queued to be applied when \ref applyChanges() is called */
class GRT_STRUCTS_DB_QUERY_PUBLIC db_query_EditableResultset : public db_query_Resultset
{
  typedef db_query_Resultset super;
public:
  class ImplData;
  friend class ImplData;
  db_query_EditableResultset(grt::GRT *grt, grt::MetaClass *meta=0)
  : db_query_Resultset(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _schema(""),
     _table(""),
    _data(0)

  {
  }

  virtual ~db_query_EditableResultset();

  static std::string static_class_name() { return "db.query.EditableResultset"; }

  /** Getter for attribute schema
   
    schema name of the table
   \par In Python:
value = obj.schema
   */
  grt::StringRef schema() const { return _schema; }
  /** Setter for attribute schema
   
    schema name of the table
    \par In Python:
obj.schema = value
   */
  virtual void schema(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_schema);
   _schema= value;
    member_changed("schema", ovalue, value);
  }

  /** Getter for attribute table
   
    name of the table being edited
   \par In Python:
value = obj.table
   */
  grt::StringRef table() const { return _table; }
  /** Setter for attribute table
   
    name of the table being edited
    \par In Python:
obj.table = value
   */
  virtual void table(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_table);
   _table= value;
    member_changed("table", ovalue, value);
  }

  /** Method. adds a new empty row to the resultset. The row contents must be set before applying changes
  \return 

   */
  virtual grt::IntegerRef addNewRow();
  /** Method. generates a SQL script with all pending changes made to the resultset and executes it, once confirmed through a GUI wizard
  \return 

   */
  virtual grt::IntegerRef applyChanges();
  /** Method. marks a row from the resultset for deletion. The row will only be deleted in the target database when applyChanges() is called
  \param column 
  \return 

   */
  virtual grt::IntegerRef deleteRow(long column);
  /** Method. loads the contents of an external file into the current row at the given column index
  \param column 
  \param file 
  \return 

   */
  virtual grt::IntegerRef loadFieldValueFromFile(long column, const std::string &file);
  /** Method. discards all changes made to the resultset
  \return 

   */
  virtual grt::IntegerRef revertChanges();
  /** Method. sets the contents of the current row at the given column index to NULL
  \param column 
  \return 

   */
  virtual grt::IntegerRef setFieldNull(long column);
  /** Method. sets the contents of the current row at the given column name to NULL
  \param column 
  \return 

   */
  virtual grt::IntegerRef setFieldNullByName(const std::string &column);
  /** Method. sets the contents of the current row at the given column index
  \param column 
  \param value 
  \return 

   */
  virtual grt::IntegerRef setFloatFieldValue(long column, double value);
  /** Method. sets the contents of the current row at the given column name
  \param column 
  \param value 
  \return 

   */
  virtual grt::IntegerRef setFloatFieldValueByName(const std::string &column, double value);
  /** Method. sets the contents of the current row at the given integer type column index
  \param column 
  \param value 
  \return 

   */
  virtual grt::IntegerRef setIntFieldValue(long column, long value);
  /** Method. sets the contents of the current row at the given column name
  \param column 
  \param value 
  \return 

   */
  virtual grt::IntegerRef setIntFieldValueByName(const std::string &column, long value);
  /** Method. sets the contents of the current row at the given column index
  \param column 
  \param value 
  \return 

   */
  virtual grt::IntegerRef setStringFieldValue(long column, const std::string &value);
  /** Method. sets the contents of the current row at the given column name
  \param column 
  \param value 
  \return 

   */
  virtual grt::IntegerRef setStringFieldValueByName(const std::string &column, const std::string &value);

  ImplData *get_data() const { return _data; }

  void set_data(ImplData *data);
  // default initialization function. auto-called by Ref<Object> constructor
  virtual void init();

protected:

  grt::StringRef _schema;
  grt::StringRef _table;
private: // wrapper methods for use by grt
  ImplData *_data;

  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_query_EditableResultset(grt));
  }

  static grt::ValueRef call_addNewRow(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_query_EditableResultset*>(self)->addNewRow(); }

  static grt::ValueRef call_applyChanges(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_query_EditableResultset*>(self)->applyChanges(); }

  static grt::ValueRef call_deleteRow(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_query_EditableResultset*>(self)->deleteRow(grt::IntegerRef::cast_from(args[0])); }

  static grt::ValueRef call_loadFieldValueFromFile(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_query_EditableResultset*>(self)->loadFieldValueFromFile(grt::IntegerRef::cast_from(args[0]), grt::StringRef::cast_from(args[1])); }

  static grt::ValueRef call_revertChanges(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_query_EditableResultset*>(self)->revertChanges(); }

  static grt::ValueRef call_setFieldNull(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_query_EditableResultset*>(self)->setFieldNull(grt::IntegerRef::cast_from(args[0])); }

  static grt::ValueRef call_setFieldNullByName(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_query_EditableResultset*>(self)->setFieldNullByName(grt::StringRef::cast_from(args[0])); }

  static grt::ValueRef call_setFloatFieldValue(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_query_EditableResultset*>(self)->setFloatFieldValue(grt::IntegerRef::cast_from(args[0]), grt::DoubleRef::cast_from(args[1])); }

  static grt::ValueRef call_setFloatFieldValueByName(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_query_EditableResultset*>(self)->setFloatFieldValueByName(grt::StringRef::cast_from(args[0]), grt::DoubleRef::cast_from(args[1])); }

  static grt::ValueRef call_setIntFieldValue(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_query_EditableResultset*>(self)->setIntFieldValue(grt::IntegerRef::cast_from(args[0]), grt::IntegerRef::cast_from(args[1])); }

  static grt::ValueRef call_setIntFieldValueByName(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_query_EditableResultset*>(self)->setIntFieldValueByName(grt::StringRef::cast_from(args[0]), grt::IntegerRef::cast_from(args[1])); }

  static grt::ValueRef call_setStringFieldValue(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_query_EditableResultset*>(self)->setStringFieldValue(grt::IntegerRef::cast_from(args[0]), grt::StringRef::cast_from(args[1])); }

  static grt::ValueRef call_setStringFieldValueByName(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_query_EditableResultset*>(self)->setStringFieldValueByName(grt::StringRef::cast_from(args[0]), grt::StringRef::cast_from(args[1])); }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_query_EditableResultset::create);
    {
      void (db_query_EditableResultset::*setter)(const grt::StringRef &)= &db_query_EditableResultset::schema;
      grt::StringRef (db_query_EditableResultset::*getter)() const= &db_query_EditableResultset::schema;
      meta->bind_member("schema", new grt::MetaClass::Property<db_query_EditableResultset,grt::StringRef >(getter,setter));
    }
    {
      void (db_query_EditableResultset::*setter)(const grt::StringRef &)= &db_query_EditableResultset::table;
      grt::StringRef (db_query_EditableResultset::*getter)() const= &db_query_EditableResultset::table;
      meta->bind_member("table", new grt::MetaClass::Property<db_query_EditableResultset,grt::StringRef >(getter,setter));
    }
    meta->bind_method("addNewRow", &db_query_EditableResultset::call_addNewRow);
    meta->bind_method("applyChanges", &db_query_EditableResultset::call_applyChanges);
    meta->bind_method("deleteRow", &db_query_EditableResultset::call_deleteRow);
    meta->bind_method("loadFieldValueFromFile", &db_query_EditableResultset::call_loadFieldValueFromFile);
    meta->bind_method("revertChanges", &db_query_EditableResultset::call_revertChanges);
    meta->bind_method("setFieldNull", &db_query_EditableResultset::call_setFieldNull);
    meta->bind_method("setFieldNullByName", &db_query_EditableResultset::call_setFieldNullByName);
    meta->bind_method("setFloatFieldValue", &db_query_EditableResultset::call_setFloatFieldValue);
    meta->bind_method("setFloatFieldValueByName", &db_query_EditableResultset::call_setFloatFieldValueByName);
    meta->bind_method("setIntFieldValue", &db_query_EditableResultset::call_setIntFieldValue);
    meta->bind_method("setIntFieldValueByName", &db_query_EditableResultset::call_setIntFieldValueByName);
    meta->bind_method("setStringFieldValue", &db_query_EditableResultset::call_setStringFieldValue);
    meta->bind_method("setStringFieldValueByName", &db_query_EditableResultset::call_setStringFieldValueByName);
  }
};


  /** a proxy to a SQL script editor buffer.\n This object cannot be instantiated directly. */
class GRT_STRUCTS_DB_QUERY_PUBLIC db_query_QueryBuffer : public GrtObject
{
  typedef GrtObject super;
public:
  class ImplData;
  friend class ImplData;
  db_query_QueryBuffer(grt::GRT *grt, grt::MetaClass *meta=0)
  : GrtObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
    _data(0)

  {
  }

  virtual ~db_query_QueryBuffer();

  static std::string static_class_name() { return "db.query.QueryBuffer"; }

  /** Getter for attribute currentStatement (read-only)
   
    the SQL statement at current cursor location
   \par In Python:
value = obj.currentStatement
   */
  grt::StringRef currentStatement() const;
private: // the next attribute is read-only
public:

  /** Getter for attribute insertionPoint
   
    gets or sets the position of the current text insertion point (caret/cursor)
   \par In Python:
value = obj.insertionPoint
   */
  grt::IntegerRef insertionPoint() const;
  /** Setter for attribute insertionPoint
   
    gets or sets the position of the current text insertion point (caret/cursor)
    \par In Python:
obj.insertionPoint = value
   */
  virtual void insertionPoint(const grt::IntegerRef &value);

  /** Getter for attribute script (read-only)
   
    full contents of the script editor buffer
   \par In Python:
value = obj.script
   */
  grt::StringRef script() const;
private: // the next attribute is read-only
public:

  /** Getter for attribute selectedText (read-only)
   
    selected text
   \par In Python:
value = obj.selectedText
   */
  grt::StringRef selectedText() const;
private: // the next attribute is read-only
public:

  /** Getter for attribute selectionEnd
   
    ending index of text selection
   \par In Python:
value = obj.selectionEnd
   */
  grt::IntegerRef selectionEnd() const;
  /** Setter for attribute selectionEnd
   
    ending index of text selection
    \par In Python:
obj.selectionEnd = value
   */
  virtual void selectionEnd(const grt::IntegerRef &value);

  /** Getter for attribute selectionStart
   
    starting index of text selection
   \par In Python:
value = obj.selectionStart
   */
  grt::IntegerRef selectionStart() const;
  /** Setter for attribute selectionStart
   
    starting index of text selection
    \par In Python:
obj.selectionStart = value
   */
  virtual void selectionStart(const grt::IntegerRef &value);

  /** Method. replace the contents of the query buffer with the provided text
  \param text 
  \return 

   */
  virtual grt::IntegerRef replaceContents(const std::string &text);
  /** Method. replace the currently selected text with the provided one, also selecting it
  \param text 
  \return 

   */
  virtual grt::IntegerRef replaceSelection(const std::string &text);

  ImplData *get_data() const { return _data; }

  void set_data(ImplData *data);
  // default initialization function. auto-called by Ref<Object> constructor
  virtual void init();

protected:

private: // wrapper methods for use by grt
  ImplData *_data;

  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_query_QueryBuffer(grt));
  }

  static grt::ValueRef call_replaceContents(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_query_QueryBuffer*>(self)->replaceContents(grt::StringRef::cast_from(args[0])); }

  static grt::ValueRef call_replaceSelection(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_query_QueryBuffer*>(self)->replaceSelection(grt::StringRef::cast_from(args[0])); }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_query_QueryBuffer::create);
    meta->bind_member("currentStatement", new grt::MetaClass::Property<db_query_QueryBuffer,grt::StringRef >(&db_query_QueryBuffer::currentStatement));
    {
      void (db_query_QueryBuffer::*setter)(const grt::IntegerRef &)= &db_query_QueryBuffer::insertionPoint;
      grt::IntegerRef (db_query_QueryBuffer::*getter)() const= &db_query_QueryBuffer::insertionPoint;
      meta->bind_member("insertionPoint", new grt::MetaClass::Property<db_query_QueryBuffer,grt::IntegerRef >(getter, setter));
    }
    meta->bind_member("script", new grt::MetaClass::Property<db_query_QueryBuffer,grt::StringRef >(&db_query_QueryBuffer::script));
    meta->bind_member("selectedText", new grt::MetaClass::Property<db_query_QueryBuffer,grt::StringRef >(&db_query_QueryBuffer::selectedText));
    {
      void (db_query_QueryBuffer::*setter)(const grt::IntegerRef &)= &db_query_QueryBuffer::selectionEnd;
      grt::IntegerRef (db_query_QueryBuffer::*getter)() const= &db_query_QueryBuffer::selectionEnd;
      meta->bind_member("selectionEnd", new grt::MetaClass::Property<db_query_QueryBuffer,grt::IntegerRef >(getter, setter));
    }
    {
      void (db_query_QueryBuffer::*setter)(const grt::IntegerRef &)= &db_query_QueryBuffer::selectionStart;
      grt::IntegerRef (db_query_QueryBuffer::*getter)() const= &db_query_QueryBuffer::selectionStart;
      meta->bind_member("selectionStart", new grt::MetaClass::Property<db_query_QueryBuffer,grt::IntegerRef >(getter, setter));
    }
    meta->bind_method("replaceContents", &db_query_QueryBuffer::call_replaceContents);
    meta->bind_method("replaceSelection", &db_query_QueryBuffer::call_replaceSelection);
  }
};


class  db_query_QueryEditor : public db_query_QueryBuffer
{
  typedef db_query_QueryBuffer super;
public:
  class ImplData;
  friend class ImplData;
  db_query_QueryEditor(grt::GRT *grt, grt::MetaClass *meta=0)
  : db_query_QueryBuffer(grt, meta ? meta : grt->get_metaclass(static_class_name())),
    _resultsets(grt, this, false)

  {
  }

  static std::string static_class_name() { return "db.query.QueryEditor"; }

  /** Getter for attribute activeResultset
   
    resultset that is currently selected in UI
   \par In Python:
value = obj.activeResultset
   */
  grt::Ref<db_query_Resultset> activeResultset() const { return _activeResultset; }
  /** Setter for attribute activeResultset
   
    resultset that is currently selected in UI
    \par In Python:
obj.activeResultset = value
   */
  virtual void activeResultset(const grt::Ref<db_query_Resultset> &value)
  {
    grt::ValueRef ovalue(_activeResultset);
   _activeResultset= value;
    member_changed("activeResultset", ovalue, value);
  }

  /** Getter for attribute resultDockingPoint
   
    
   \par In Python:
value = obj.resultDockingPoint
   */
  grt::Ref<mforms_ObjectReference> resultDockingPoint() const { return _resultDockingPoint; }
  /** Setter for attribute resultDockingPoint
   
    
    \par In Python:
obj.resultDockingPoint = value
   */
  virtual void resultDockingPoint(const grt::Ref<mforms_ObjectReference> &value)
  {
    grt::ValueRef ovalue(_resultDockingPoint);
   _resultDockingPoint= value;
    member_changed("resultDockingPoint", ovalue, value);
  }

  // resultsets is owned by db_query_QueryEditor
  /** Getter for attribute resultsets (read-only)
   
    list of open resultsets. This list cannot be modified
   \par In Python:
value = obj.resultsets
   */
  grt::ListRef<db_query_Resultset> resultsets() const { return _resultsets; }
private: // the next attribute is read-only
  virtual void resultsets(const grt::ListRef<db_query_Resultset> &value)
  {
    grt::ValueRef ovalue(_resultsets);

    _resultsets= value;
    owned_member_changed("resultsets", ovalue, value);
  }
public:

protected:

  grt::Ref<db_query_Resultset> _activeResultset;
  grt::Ref<mforms_ObjectReference> _resultDockingPoint;
  grt::ListRef<db_query_Resultset> _resultsets;// owned
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_query_QueryEditor(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_query_QueryEditor::create);
    {
      void (db_query_QueryEditor::*setter)(const grt::Ref<db_query_Resultset> &)= &db_query_QueryEditor::activeResultset;
      grt::Ref<db_query_Resultset> (db_query_QueryEditor::*getter)() const= &db_query_QueryEditor::activeResultset;
      meta->bind_member("activeResultset", new grt::MetaClass::Property<db_query_QueryEditor,grt::Ref<db_query_Resultset> >(getter,setter));
    }
    {
      void (db_query_QueryEditor::*setter)(const grt::Ref<mforms_ObjectReference> &)= &db_query_QueryEditor::resultDockingPoint;
      grt::Ref<mforms_ObjectReference> (db_query_QueryEditor::*getter)() const= &db_query_QueryEditor::resultDockingPoint;
      meta->bind_member("resultDockingPoint", new grt::MetaClass::Property<db_query_QueryEditor,grt::Ref<mforms_ObjectReference> >(getter,setter));
    }
    {
      void (db_query_QueryEditor::*setter)(const grt::ListRef<db_query_Resultset> &)= &db_query_QueryEditor::resultsets;
      grt::ListRef<db_query_Resultset> (db_query_QueryEditor::*getter)() const= &db_query_QueryEditor::resultsets;
      meta->bind_member("resultsets", new grt::MetaClass::Property<db_query_QueryEditor,grt::ListRef<db_query_Resultset> >(getter,setter));
    }
  }
};


  /** a proxy to an instance of a connection to a DB server, equivalent to a SQL Editor tab.\n This object cannot be instantiated directly. */
class GRT_STRUCTS_DB_QUERY_PUBLIC db_query_Editor : public GrtObject
{
  typedef GrtObject super;
public:
  class ImplData;
  friend class ImplData;
  db_query_Editor(grt::GRT *grt, grt::MetaClass *meta=0)
  : GrtObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
    _customData(grt, this, false),
    _queryEditors(grt, this, false),
    _resultsets(grt, this, false),
    _data(0)

  {
  }

  virtual ~db_query_Editor();

  static std::string static_class_name() { return "db.query.Editor"; }

  /** Getter for attribute activeQueryEditor (read-only)
   
    query editor that is currently selected
   \par In Python:
value = obj.activeQueryEditor
   */
  grt::Ref<db_query_QueryEditor> activeQueryEditor() const;
private: // the next attribute is read-only
  virtual void activeQueryEditor(const grt::Ref<db_query_QueryEditor> &value)
  {
    grt::ValueRef ovalue(_activeQueryEditor);
   _activeQueryEditor= value;
    member_changed("activeQueryEditor", ovalue, value);
  }
public:

  /** Getter for attribute auxConnectionHandle (read-only)
   
    aux connection handle
   \par In Python:
value = obj.auxConnectionHandle
   */
  grt::Ref<db_mgmt_ConnectionHandle> auxConnectionHandle() const;
private: // the next attribute is read-only
public:

  /** Getter for attribute connection (read-only)
   
    connection data
   \par In Python:
value = obj.connection
   */
  grt::Ref<db_mgmt_Connection> connection() const;
private: // the next attribute is read-only
public:

  /** Getter for attribute connectionHandle (read-only)
   
    main connection handle
   \par In Python:
value = obj.connectionHandle
   */
  grt::Ref<db_mgmt_ConnectionHandle> connectionHandle() const;
private: // the next attribute is read-only
public:

  /** Getter for attribute customData (read-only)
   
    
   \par In Python:
value = obj.customData
   */
  grt::DictRef customData() const { return _customData; }
private: // the next attribute is read-only
  virtual void customData(const grt::DictRef &value)
  {
    grt::ValueRef ovalue(_customData);
   _customData= value;
    member_changed("customData", ovalue, value);
  }
public:

  /** Getter for attribute defaultSchema
   
    The default schema to use for queries (equivalent to USE schema)
   \par In Python:
value = obj.defaultSchema
   */
  grt::StringRef defaultSchema() const;
  /** Setter for attribute defaultSchema
   
    The default schema to use for queries (equivalent to USE schema)
    \par In Python:
obj.defaultSchema = value
   */
  virtual void defaultSchema(const grt::StringRef &value);

  // queryEditors is owned by db_query_Editor
  /** Getter for attribute queryEditors (read-only)
   
    list of open editor buffers. This list cannot be modified
   \par In Python:
value = obj.queryEditors
   */
  grt::ListRef<db_query_QueryEditor> queryEditors() const { return _queryEditors; }
private: // the next attribute is read-only
  virtual void queryEditors(const grt::ListRef<db_query_QueryEditor> &value)
  {
    grt::ValueRef ovalue(_queryEditors);

    _queryEditors= value;
    owned_member_changed("queryEditors", ovalue, value);
  }
public:

  // resultsets is owned by db_query_Editor
  /** Getter for attribute resultsets (read-only)
   
    list of open resultsets. This list cannot be modified
   \par In Python:
value = obj.resultsets
   */
  grt::ListRef<db_query_Resultset> resultsets() const { return _resultsets; }
private: // the next attribute is read-only
  virtual void resultsets(const grt::ListRef<db_query_Resultset> &value)
  {
    grt::ValueRef ovalue(_resultsets);

    _resultsets= value;
    owned_member_changed("resultsets", ovalue, value);
  }
public:

  /** Getter for attribute serverVersion
   
    
   \par In Python:
value = obj.serverVersion
   */
  grt::Ref<GrtVersion> serverVersion() const { return _serverVersion; }
  /** Setter for attribute serverVersion
   
    
    \par In Python:
obj.serverVersion = value
   */
  virtual void serverVersion(const grt::Ref<GrtVersion> &value)
  {
    grt::ValueRef ovalue(_serverVersion);
   _serverVersion= value;
    member_changed("serverVersion", ovalue, value);
  }

  /** Method. adds a new query buffer/text editor tab in the UI and return it
  \return the newly created query buffer proxy object

   */
  virtual grt::Ref<db_query_QueryEditor> addQueryEditor();
  /** Method. write a line of text into the SQL Editor output area
  \param text 
  \param bringToFront 
  \return 

   */
  virtual grt::IntegerRef addToOutput(const std::string &text, long bringToFront);
  /** Method. executes a SELECT statement on the table and returns an editable resultset that can be used to modify its contents
  \param schema name of the table schema
  \param table name of the table to edit
  \param where not yet supported
  \param showGrid whether the resultset should be displayed as a grid in the UI
  \return an editable resultset that can be used to modify the table contents

   */
  virtual grt::Ref<db_query_EditableResultset> createTableEditResultset(const std::string &schema, const std::string &table, const std::string &where, long showGrid);
  /** Method. execute the script passed as argument
  \param sql 
  \return the list of resultsets sent back by the server

   */
  virtual grt::ListRef<db_query_Resultset> executeScript(const std::string &sql);
  /** Method. execute the script passed as argument and displays the generated resultsets as grids in the UI
  \param sql 
  \return 

   */
  virtual grt::IntegerRef executeScriptAndOutputToGrid(const std::string &sql);

  ImplData *get_data() const { return _data; }

  void set_data(ImplData *data);
  // default initialization function. auto-called by Ref<Object> constructor
  virtual void init();

protected:

  grt::Ref<db_query_QueryEditor> _activeQueryEditor;
  grt::DictRef _customData;
  grt::ListRef<db_query_QueryEditor> _queryEditors;// owned
  grt::ListRef<db_query_Resultset> _resultsets;// owned
  grt::Ref<GrtVersion> _serverVersion;
private: // wrapper methods for use by grt
  ImplData *_data;

  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_query_Editor(grt));
  }

  static grt::ValueRef call_addQueryEditor(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_query_Editor*>(self)->addQueryEditor(); }

  static grt::ValueRef call_addToOutput(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_query_Editor*>(self)->addToOutput(grt::StringRef::cast_from(args[0]), grt::IntegerRef::cast_from(args[1])); }

  static grt::ValueRef call_createTableEditResultset(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_query_Editor*>(self)->createTableEditResultset(grt::StringRef::cast_from(args[0]), grt::StringRef::cast_from(args[1]), grt::StringRef::cast_from(args[2]), grt::IntegerRef::cast_from(args[3])); }

  static grt::ValueRef call_executeScript(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_query_Editor*>(self)->executeScript(grt::StringRef::cast_from(args[0])); }

  static grt::ValueRef call_executeScriptAndOutputToGrid(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_query_Editor*>(self)->executeScriptAndOutputToGrid(grt::StringRef::cast_from(args[0])); }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_query_Editor::create);
    {
      void (db_query_Editor::*setter)(const grt::Ref<db_query_QueryEditor> &)= &db_query_Editor::activeQueryEditor;
      grt::Ref<db_query_QueryEditor> (db_query_Editor::*getter)() const= &db_query_Editor::activeQueryEditor;
      meta->bind_member("activeQueryEditor", new grt::MetaClass::Property<db_query_Editor,grt::Ref<db_query_QueryEditor> >(getter,setter));
    }
    meta->bind_member("auxConnectionHandle", new grt::MetaClass::Property<db_query_Editor,grt::Ref<db_mgmt_ConnectionHandle> >(&db_query_Editor::auxConnectionHandle));
    meta->bind_member("connection", new grt::MetaClass::Property<db_query_Editor,grt::Ref<db_mgmt_Connection> >(&db_query_Editor::connection));
    meta->bind_member("connectionHandle", new grt::MetaClass::Property<db_query_Editor,grt::Ref<db_mgmt_ConnectionHandle> >(&db_query_Editor::connectionHandle));
    {
      void (db_query_Editor::*setter)(const grt::DictRef &)= &db_query_Editor::customData;
      grt::DictRef (db_query_Editor::*getter)() const= &db_query_Editor::customData;
      meta->bind_member("customData", new grt::MetaClass::Property<db_query_Editor,grt::DictRef >(getter,setter));
    }
    {
      void (db_query_Editor::*setter)(const grt::StringRef &)= &db_query_Editor::defaultSchema;
      grt::StringRef (db_query_Editor::*getter)() const= &db_query_Editor::defaultSchema;
      meta->bind_member("defaultSchema", new grt::MetaClass::Property<db_query_Editor,grt::StringRef >(getter, setter));
    }
    {
      void (db_query_Editor::*setter)(const grt::ListRef<db_query_QueryEditor> &)= &db_query_Editor::queryEditors;
      grt::ListRef<db_query_QueryEditor> (db_query_Editor::*getter)() const= &db_query_Editor::queryEditors;
      meta->bind_member("queryEditors", new grt::MetaClass::Property<db_query_Editor,grt::ListRef<db_query_QueryEditor> >(getter,setter));
    }
    {
      void (db_query_Editor::*setter)(const grt::ListRef<db_query_Resultset> &)= &db_query_Editor::resultsets;
      grt::ListRef<db_query_Resultset> (db_query_Editor::*getter)() const= &db_query_Editor::resultsets;
      meta->bind_member("resultsets", new grt::MetaClass::Property<db_query_Editor,grt::ListRef<db_query_Resultset> >(getter,setter));
    }
    {
      void (db_query_Editor::*setter)(const grt::Ref<GrtVersion> &)= &db_query_Editor::serverVersion;
      grt::Ref<GrtVersion> (db_query_Editor::*getter)() const= &db_query_Editor::serverVersion;
      meta->bind_member("serverVersion", new grt::MetaClass::Property<db_query_Editor,grt::Ref<GrtVersion> >(getter,setter));
    }
    meta->bind_method("addQueryEditor", &db_query_Editor::call_addQueryEditor);
    meta->bind_method("addToOutput", &db_query_Editor::call_addToOutput);
    meta->bind_method("createTableEditResultset", &db_query_Editor::call_createTableEditResultset);
    meta->bind_method("executeScript", &db_query_Editor::call_executeScript);
    meta->bind_method("executeScriptAndOutputToGrid", &db_query_Editor::call_executeScriptAndOutputToGrid);
  }
};




inline void register_structs_db_query_xml()
{
  grt::internal::ClassRegistry::register_class<db_query_LiveDBObject>();
  grt::internal::ClassRegistry::register_class<db_query_ResultsetColumn>();
  grt::internal::ClassRegistry::register_class<db_query_Resultset>();
  grt::internal::ClassRegistry::register_class<db_query_EditableResultset>();
  grt::internal::ClassRegistry::register_class<db_query_QueryBuffer>();
  grt::internal::ClassRegistry::register_class<db_query_QueryEditor>();
  grt::internal::ClassRegistry::register_class<db_query_Editor>();
}

#ifdef AUTO_REGISTER_GRT_CLASSES
static struct _autoreg__structs_db_query_xml { _autoreg__structs_db_query_xml() { register_structs_db_query_xml(); } } __autoreg__structs_db_query_xml;
#endif

#endif
