/* 
 * Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#include "stdafx.h"
#include "UIForm.h"

namespace MySQL {
  namespace Grt {

//----------------- MenuItem -----------------------------------------------------------------------

MenuItem::MenuItem(const ::bec::MenuItem& item)
  : caption(CppStringToNative(item.caption)), shortcut(CppStringToNative(item.shortcut)),
  name(CppStringToNative(item.name)), type((MenuItemType)item.type), enabled(item.enabled), checked(item.checked)
{
  subitems= gcnew List<MySQL::Grt::MenuItem^>();
  for (bec::MenuItemList::const_iterator iterator= item.subitems.begin(); iterator != item.subitems.end(); ++iterator)
    subitems->Add(gcnew MySQL::Grt::MenuItem(*iterator));
}

//--------------------------------------------------------------------------------------------------

String^ MenuItem::get_caption()
{
  return caption;
}

//--------------------------------------------------------------------------------------------------

String^ MenuItem::get_shortcut()
{
  return shortcut;
}

//--------------------------------------------------------------------------------------------------

String^ MenuItem::get_name()
{
  return name;
}

//--------------------------------------------------------------------------------------------------

MenuItemType MenuItem::get_type()
{
  return type;
}

//--------------------------------------------------------------------------------------------------

bool MenuItem::get_checked()
{
  return checked;
}

//--------------------------------------------------------------------------------------------------

void MenuItem::set_checked(bool value)
{
  checked= value;
}

//--------------------------------------------------------------------------------------------------

bool MenuItem::get_enabled()
{
  return enabled;
}

//--------------------------------------------------------------------------------------------------

void MenuItem::set_enabled(bool value)
{
  enabled= value;
}

//--------------------------------------------------------------------------------------------------

List<MySQL::Grt::MenuItem^>^ MenuItem::get_subitems()
{
  return subitems;
}

//--------------------------------------------------------------------------------------------------

  };  // namespace Grt
};  // namespace MySQL
