//
//  DbPrivilegeEditorTab.h
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 28/Mar/09.
//  Copyright 2009 Sun Microsystems Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import "WBPluginEditorBase.h"

#include "wb_config.h"

@class GRTListDataSource;
@class GRTTreeDataSource;

#include "grtdb/editor_dbobject.h"
#include "grtdb/dbobject_roles.h"
#include "grtdb/role_tree_model.h"

@interface DbPrivilegeEditorTab : NSObject 
{
  bec::DBObjectEditorBE *_be;

  bec::ObjectRoleListBE *_rolesListBE;
  bec::RoleTreeBE *_roleTreeBE;
  bec::ObjectPrivilegeListBE *_privilegeListBE;

  IBOutlet NSView *view;

  IBOutlet NSTableView *assignedRolesTable;
  IBOutlet NSTableView *privilegesTable;
  IBOutlet NSOutlineView *allRolesOutline;

  IBOutlet GRTListDataSource *assignedRolesDS;
  IBOutlet GRTTreeDataSource *allRolesDS;
}

- (id)initWithObjectEditor:(bec::DBObjectEditorBE*)be;

- (IBAction)addRole:(id)sender;
- (IBAction)deleteRole:(id)sender;

- (NSView*)view;

@end
