/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */


#ifndef _RECORDSET_CDBC_STORAGE_BE_H_
#define _RECORDSET_CDBC_STORAGE_BE_H_


#include "wbpublic_public_interface.h"
#include "sqlide/recordset_sql_storage.h"
#include "cppdbc.h"


class WBPUBLICBACKEND_PUBLIC_FUNC Recordset_cdbc_storage : public Recordset_sql_storage
{
public:
  typedef boost::shared_ptr<Recordset_cdbc_storage> Ref;
  static Ref create(bec::GRTManager *grtm) { return Ref(new Recordset_cdbc_storage(grtm)); }
  virtual ~Recordset_cdbc_storage();
protected:
  Recordset_cdbc_storage(bec::GRTManager *grtm);

protected:
  virtual void do_unserialize(Recordset *recordset, sqlite::connection *data_swap_db);
  virtual void do_fetch_blob_value(Recordset *recordset, sqlite::connection *data_swap_db, RowId rowid, ColumnId column, sqlite::Variant &blob_value);

protected:
  virtual void run_sql_script(const Sql_script &sql_script);

public:
  std::string decorated_sql_query(); // adds limit clause if defined by options

public:
  void dbms_conn(const sql::Dbc_connection_handler::Ref &val) { _dbms_conn= val; }
  sql::Dbc_connection_handler::Ref dbms_conn() { return _dbms_conn; }
  void dbc_resultset(boost::shared_ptr<sql::ResultSet>& value) { _dbc_resultset= value; }
  void dbc_statement(boost::shared_ptr<sql::Statement>& value) { _dbc_statement= value; }
  bool reloadable() const { return _reloadable; }
  void reloadable(bool val) { _reloadable= val; }
protected:
  sql::Dbc_connection_handler::ConnectionRef dbms_conn_ref();
private:
  sql::Dbc_connection_handler::Ref _dbms_conn;
  boost::shared_ptr<sql::ResultSet> _dbc_resultset; // for 1-time unserialization
  boost::shared_ptr<sql::Statement> _dbc_statement; // for 1-time unserialization
  bool _reloadable; // whether can be reloaded using stored sql query
};


#endif /* _RECORDSET_CDBC_STORAGE_BE_H_ */
