/* 
 * Copyright (c) 2009, 2013, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#import <Cocoa/Cocoa.h>

#import "MFContainerBase.h"
#include "mforms/table.h"


@interface MFTableImpl : MFContainerBase {
  float mRowSpacing;
  float mColumnSpacing;
  int mRowCount;
  int mColumnCount;
  BOOL mHomogeneous;
  BOOL mCenterContents;

  NSMutableArray *mTableCells;
}


- (void)setRowSpacing:(float)spacing;
- (void)setColumnSpacing:(float)spacing;
- (void)setRowCount:(int)count;
- (void)setColumnCount:(int)count;

- (void)addSubview:(NSView*)view left:(int)left right:(int)right top:(int)top bottom:(int)bottom flags:(mforms::TableItemFlags)flags;

@end
